import * as React from 'react';
import { Row, TableState, HeaderGroup } from 'react-table';
import { VariableSizeList } from 'react-window';
import { DataFrame, Field, TimeRange, InterpolateFunction } from '@grafana/data';
import { TableCellHeight } from '@grafana/schema';
import { GetActionsFunction, TableFilterActionCallback, TableInspectCellCallback } from '../types';
import { TableStyles } from './styles';
interface RowsListProps {
    data: DataFrame;
    rows: Row[];
    enableSharedCrosshair: boolean;
    headerHeight: number;
    rowHeight: number;
    itemCount: number;
    pageIndex: number;
    listHeight: number;
    width: number;
    cellHeight?: TableCellHeight;
    listRef: React.RefObject<VariableSizeList>;
    tableState: TableState;
    tableStyles: TableStyles;
    nestedDataField?: Field;
    prepareRow: (row: Row) => void;
    onCellFilterAdded?: TableFilterActionCallback;
    timeRange?: TimeRange;
    footerPaginationEnabled: boolean;
    initialRowIndex?: number;
    headerGroups: HeaderGroup[];
    longestField?: Field;
    textWrapField?: Field;
    getActions?: GetActionsFunction;
    replaceVariables?: InterpolateFunction;
    setInspectCell?: TableInspectCellCallback;
}
export declare const RowsList: (props: RowsListProps) => import("react/jsx-runtime").JSX.Element;
export {};
