import { BootData } from '@grafana/data';
export interface Props {
    onChange: (weekStart?: WeekStart) => void;
    value?: WeekStart;
    width?: number;
    autoFocus?: boolean;
    onBlur?: () => void;
    disabled?: boolean;
    inputId?: string;
}
export type WeekStart = 'saturday' | 'sunday' | 'monday';
export declare function isWeekStart(value: string): value is WeekStart;
declare global {
    interface Window {
        grafanaBootData?: BootData;
    }
}
/**
 * Returns the system or user defined week start (as defined in bootData)
 * Or you can pass in an override weekStart string and have it be validated and returned as WeekStart type if valid
 */
export declare function getWeekStart(override?: string): WeekStart;
export declare const WeekStartPicker: (props: Props) => import("react/jsx-runtime").JSX.Element;
