import { jsxs, jsx } from 'react/jsx-runtime';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { getSelectStyles } from './getSelectStyles.mjs';

"use strict";
const SelectOptionGroup = ({
  children,
  cx,
  getClassNames,
  getStyles,
  Heading,
  headingProps,
  label,
  selectProps,
  theme
}) => {
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.group, children: [
    /* @__PURE__ */ jsx(
      Heading,
      {
        cx,
        getClassNames,
        getStyles,
        selectProps,
        theme,
        ...headingProps,
        children: label
      }
    ),
    children
  ] });
};

export { SelectOptionGroup };
//# sourceMappingURL=SelectOptionGroup.mjs.map
