import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '../../themes/index.mjs';
import { ActionButton } from '../Actions/ActionButton.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const ActionsCell = (props) => {
  const { cellProps, tableStyles, actions } = props;
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: cx(tableStyles.cellContainerText, styles.buttonsGap), children: actions && actions.map((action, i) => /* @__PURE__ */ jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles = (theme) => ({
  buttonsGap: css({
    gap: 6
  })
});

export { ActionsCell };
//# sourceMappingURL=ActionsCell.mjs.map
