import { jsxs, jsx } from 'react/jsx-runtime';
import { css, keyframes } from '@emotion/css';
import { memo } from 'react';
import '../../themes/index.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const EllipsisAnimated = memo(() => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.ellipsis, children: [
    /* @__PURE__ */ jsx("span", { className: styles.firstDot, children: "." }),
    /* @__PURE__ */ jsx("span", { className: styles.secondDot, children: "." }),
    /* @__PURE__ */ jsx("span", { className: styles.thirdDot, children: "." })
  ] });
});
EllipsisAnimated.displayName = "EllipsisAnimated";
const getStyles = (theme) => {
  return {
    ellipsis: css({
      display: "inline"
    }),
    firstDot: css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${firstDot} 2s linear infinite`
      }
    }),
    secondDot: css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${secondDot} 2s linear infinite`
      }
    }),
    thirdDot: css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${thirdDot} 2s linear infinite`
      }
    })
  };
};
const firstDot = keyframes`
  0% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const secondDot = keyframes`
  0% {
    opacity: 0;
  }
  21% {
    opacity: 0.5;
  }
  22% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const thirdDot = keyframes`
  0% {
    opacity: 0;
  }
  43% {
    opacity: 0.5;
  }
  44% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;

export { EllipsisAnimated };
//# sourceMappingURL=EllipsisAnimated.mjs.map
