import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { IconButton } from '../../IconButton/IconButton.mjs';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';

"use strict";
const CloseButton = ({ onClick, "aria-label": ariaLabel, style }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(IconButton, { "aria-label": ariaLabel != null ? ariaLabel : "Close", className: styles, name: "times", onClick, style });
};
const getStyles = (theme) => css({
  position: "absolute",
  margin: "0px",
  right: 5,
  top: 6
});

export { CloseButton };
//# sourceMappingURL=CloseButton.mjs.map
