import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { memo, Children } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { getFocusStyles } from '../../themes/mixins.mjs';
import { t } from '../../utils/i18n.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Link } from '../Link/Link.mjs';
import { ToolbarButtonRow } from '../ToolbarButton/ToolbarButtonRow.mjs';

"use strict";
const PageToolbar = memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles);
    const mainStyle = cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("span", { className: styles.truncateText, children: title }),
      section && /* @__PURE__ */ jsxs("span", { className: styles.pre, children: [
        " / ",
        section
      ] })
    ] });
    const goBackLabel = t("grafana-ui.page-toolbar.go-back", "Go back (Esc)");
    const searchParentFolderLabel = t(
      "grafana-ui.page-toolbar.search-parent-folder",
      "Search dashboard in the {{parent}} folder",
      { parent }
    );
    const searchDashboardNameLabel = t("grafana-ui.page-toolbar.search-dashboard-name", "Search dashboard by name");
    const searchLinksLabel = t("grafana-ui.page-toolbar.search-links", "Search links");
    return /* @__PURE__ */ jsxs("nav", { className: mainStyle, "aria-label": ariaLabel, children: [
      /* @__PURE__ */ jsxs("div", { className: styles.leftWrapper, children: [
        pageIcon && !onGoBack && /* @__PURE__ */ jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsx(Icon, { name: pageIcon, size: "lg", "aria-hidden": true }) }),
        onGoBack && /* @__PURE__ */ jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsx(
          IconButton,
          {
            name: "arrow-left",
            tooltip: goBackLabel,
            tooltipPlacement: "bottom",
            size: "xxl",
            "data-testid": selectors.components.BackButton.backArrow,
            onClick: onGoBack
          }
        ) }),
        /* @__PURE__ */ jsxs("nav", { "aria-label": searchLinksLabel, className: styles.navElement, children: [
          parent && parentHref && /* @__PURE__ */ jsxs(Fragment, { children: [
            /* @__PURE__ */ jsxs(
              Link,
              {
                "aria-label": searchParentFolderLabel,
                className: cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
                href: parentHref,
                children: [
                  parent,
                  " ",
                  /* @__PURE__ */ jsx("span", { className: styles.parentIcon })
                ]
              }
            ),
            titleHref && /* @__PURE__ */ jsx("span", { className: cx(styles.titleText, styles.titleDivider), "aria-hidden": true, children: "/" })
          ] }),
          (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ jsxs("div", { className: styles.titleWrapper, children: [
            title && /* @__PURE__ */ jsx("h1", { className: styles.h1Styles, children: titleHref ? /* @__PURE__ */ jsx(
              Link,
              {
                "aria-label": searchDashboardNameLabel,
                className: cx(styles.titleText, styles.titleLink),
                href: titleHref,
                children: titleEl
              }
            ) : /* @__PURE__ */ jsx("div", { className: styles.titleText, children: titleEl }) }),
            leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ jsx(
              "div",
              {
                className: cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
                children: child
              },
              index
            ))
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsx(ToolbarButtonRow, { alignment: buttonOverflowAlignment, children: Children.toArray(children).filter(Boolean) })
    ] });
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css({
      whiteSpace: "pre"
    }),
    toolbar: css({
      alignItems: "center",
      background: theme.colors.background.canvas,
      display: "flex",
      gap: theme.spacing(2),
      justifyContent: "space-between",
      padding: theme.spacing(1.5, 2),
      [theme.breakpoints.down("md")]: {
        paddingLeft: "53px"
      }
    }),
    noPageIcon: css({
      [theme.breakpoints.down("md")]: {
        paddingLeft: theme.spacing(2)
      }
    }),
    leftWrapper: css({
      display: "flex",
      flexWrap: "nowrap",
      maxWidth: "70%"
    }),
    pageIcon: css({
      display: "none",
      [theme.breakpoints.up("sm")]: {
        display: "flex",
        paddingRight: theme.spacing(1),
        alignItems: "center"
      }
    }),
    truncateText: css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    }),
    titleWrapper: css({
      display: "flex",
      margin: 0,
      minWidth: 0
    }),
    navElement: css({
      display: "flex",
      alignItems: "center",
      minWidth: 0
    }),
    h1Styles: css({
      margin: spacing(0, 1, 0, 0),
      lineHeight: "inherit",
      flexGrow: 1,
      minWidth: 0
    }),
    parentIcon: css({
      marginLeft: theme.spacing(0.5)
    }),
    titleText: css({
      display: "flex",
      fontSize: typography.size.lg,
      margin: 0,
      borderRadius: theme.shape.radius.default
    }),
    titleLink: css({
      "&:focus-visible": focusStyle
    }),
    titleDivider: css({
      padding: spacing(0, 0.5, 0, 0.5),
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset"
      }
    }),
    parentLink: css({
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset",
        flex: 1
      }
    }),
    leftActionItem: css({
      display: "none",
      alignItems: "center",
      paddingRight: spacing(0.5),
      [theme.breakpoints.up("md")]: {
        display: "flex"
      }
    }),
    forceShowLeftActionItems: css({
      display: "flex"
    })
  };
};

export { PageToolbar };
//# sourceMappingURL=PageToolbar.mjs.map
