import { locationUtil } from './location.mjs';
import { serializeStateToUrlParam, toURLRange } from './url.mjs';

"use strict";
const DataLinkBuiltInVars = {
  keepTime: "__url_time_range",
  timeRangeFrom: "__from",
  timeRangeTo: "__to",
  includeVars: "__all_variables",
  seriesName: "__series.name",
  fieldName: "__field.name",
  valueTime: "__value.time",
  valueNumeric: "__value.numeric",
  valueText: "__value.text",
  valueRaw: "__value.raw",
  // name of the calculation represented by the value
  valueCalc: "__value.calc"
};
function mapInternalLinkToExplore(options) {
  var _a, _b, _c;
  const { onClickFn, replaceVariables, link, scopedVars, range, field, internalLink } = options;
  const query = typeof ((_a = link.internal) == null ? void 0 : _a.query) === "function" ? link.internal.query({ replaceVariables, scopedVars }) : internalLink.query;
  const interpolatedQuery = interpolateObject(query, scopedVars, replaceVariables);
  const interpolatedPanelsState = interpolateObject((_b = link.internal) == null ? void 0 : _b.panelsState, scopedVars, replaceVariables);
  const interpolatedCorrelationData = interpolateObject((_c = link.meta) == null ? void 0 : _c.correlationData, scopedVars, replaceVariables);
  const title = link.title ? link.title : internalLink.datasourceName;
  return {
    title: replaceVariables(title, scopedVars),
    // In this case this is meant to be internal link (opens split view by default) the href will also points
    // to explore but this way you can open it in new tab.
    href: generateInternalHref(internalLink.datasourceUid, interpolatedQuery, range, interpolatedPanelsState),
    onClick: onClickFn ? (event) => {
      if (event.preventDefault) {
        event.preventDefault();
      }
      onClickFn({
        datasourceUid: internalLink.datasourceUid,
        queries: [interpolatedQuery],
        panelsState: interpolatedPanelsState,
        correlationHelperData: interpolatedCorrelationData,
        range
      });
    } : void 0,
    target: (link == null ? void 0 : link.targetBlank) ? "_blank" : "_self",
    origin: field
  };
}
function generateInternalHref(datasourceUid, query, range, panelsState) {
  return locationUtil.assureBaseUrl(
    `/explore?left=${encodeURIComponent(
      serializeStateToUrlParam({
        // @deprecated mapInternalLinkToExplore required passing range. Some consumers to generate the URL
        // with defaults pass range as `{} as any`. This is why we need to check for `range?.raw` not just
        // `range ? ...` here. This behavior will be marked as deprecated in #72498
        ...(range == null ? void 0 : range.raw) ? { range: toURLRange(range.raw) } : {},
        datasource: datasourceUid,
        queries: [query],
        panelsState
      })
    )}`
  );
}
function interpolateObject(obj, scopedVars, replaceVariables) {
  if (!obj) {
    return obj;
  }
  if (typeof obj === "string") {
    return replaceVariables(obj, scopedVars);
  }
  const copy = JSON.parse(JSON.stringify(obj));
  return interpolateObjectRecursive(copy, scopedVars, replaceVariables);
}
function interpolateObjectRecursive(obj, scopedVars, replaceVariables) {
  for (const k of Object.keys(obj)) {
    if (typeof obj[k] === "string") {
      obj[k] = replaceVariables(obj[k], scopedVars);
    } else if (typeof obj[k] === "object" && obj[k] !== null) {
      obj[k] = interpolateObjectRecursive(obj[k], scopedVars, replaceVariables);
    }
  }
  return obj;
}

export { DataLinkBuiltInVars, mapInternalLinkToExplore };
//# sourceMappingURL=dataLinks.mjs.map
