import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '../../themes/index.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const InlineSegmentGroup = ({ children, className, grow, ...htmlProps }) => {
  const styles = useStyles2(getStyles, grow);
  return /* @__PURE__ */ jsx("div", { className: cx(styles.container, className), ...htmlProps, children });
};
InlineSegmentGroup.displayName = "InlineSegmentGroup";
const getStyles = (theme, grow) => {
  return {
    container: css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} 0 auto`,
      marginBottom: theme.spacing(0.5)
    })
  };
};

export { InlineSegmentGroup };
//# sourceMappingURL=InlineSegmentGroup.mjs.map
