import { jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { useCallback } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { t } from '../../utils/i18n.mjs';
import { Dropdown } from '../Dropdown/Dropdown.mjs';
import '../ToolbarButton/index.mjs';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.mjs';

"use strict";
function PanelMenu({
  menu,
  title,
  placement = "bottom",
  offset,
  dragClassCancel,
  menuButtonClass,
  onOpenMenu
}) {
  const testId = title ? selectors.components.Panels.Panel.menu(title) : `panel-menu-button`;
  const handleVisibility = useCallback(
    (show) => {
      if (show && onOpenMenu) {
        onOpenMenu();
      }
    },
    [onOpenMenu]
  );
  return /* @__PURE__ */ jsx(Dropdown, { overlay: menu, placement, offset, onVisibleChange: handleVisibility, children: /* @__PURE__ */ jsx(
    ToolbarButton,
    {
      "aria-label": t("grafana-ui.panel-menu.label", "Menu for panel {{ title }}", { title: title != null ? title : "Untitled" }),
      title: t("grafana-ui.panel-menu.title", "Menu"),
      icon: "ellipsis-v",
      iconSize: "md",
      narrow: true,
      "data-testid": testId,
      className: cx(menuButtonClass, dragClassCancel)
    }
  ) });
}

export { PanelMenu };
//# sourceMappingURL=PanelMenu.mjs.map
