import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import { toOption } from '@grafana/data';
import { FlexItem, EditorRows } from '@grafana/plugin-ui';
import { useStyles2, Select, AutoSizeInput, IconButton } from '@grafana/ui';
import { binaryScalarDefs } from '../binaryScalarOperations.mjs';
import { PromQueryBuilder } from './PromQueryBuilder.mjs';

"use strict";
const NestedQuery = memo((props) => {
  const { nestedQuery, index, datasource, onChange, onRemove, onRunQuery, showExplain } = props;
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.card, children: [
    /* @__PURE__ */ jsxs("div", { className: styles.header, children: [
      /* @__PURE__ */ jsx("div", { className: styles.name, children: "Operator" }),
      /* @__PURE__ */ jsx(
        Select,
        {
          width: "auto",
          options: operators,
          value: toOption(nestedQuery.operator),
          onChange: (value) => {
            onChange(index, {
              ...nestedQuery,
              operator: value.value
            });
          }
        }
      ),
      /* @__PURE__ */ jsx("div", { className: styles.name, children: "Vector matches" }),
      /* @__PURE__ */ jsxs("div", { className: styles.vectorMatchWrapper, children: [
        /* @__PURE__ */ jsx(
          Select,
          {
            width: "auto",
            value: nestedQuery.vectorMatchesType || "on",
            allowCustomValue: true,
            options: [
              { value: "on", label: "on" },
              { value: "ignoring", label: "ignoring" }
            ],
            onChange: (val) => {
              onChange(index, {
                ...nestedQuery,
                vectorMatchesType: val.value
              });
            }
          }
        ),
        /* @__PURE__ */ jsx(
          AutoSizeInput,
          {
            className: styles.vectorMatchInput,
            minWidth: 20,
            defaultValue: nestedQuery.vectorMatches,
            onCommitChange: (evt) => {
              onChange(index, {
                ...nestedQuery,
                vectorMatches: evt.currentTarget.value,
                vectorMatchesType: nestedQuery.vectorMatchesType || "on"
              });
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsx(FlexItem, { grow: 1 }),
      /* @__PURE__ */ jsx(IconButton, { name: "times", size: "sm", onClick: () => onRemove(index), tooltip: "Remove match" })
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles.body, children: /* @__PURE__ */ jsx(EditorRows, { children: /* @__PURE__ */ jsx(
      PromQueryBuilder,
      {
        showExplain,
        query: nestedQuery.query,
        datasource,
        onRunQuery,
        onChange: (update) => {
          onChange(index, { ...nestedQuery, query: update });
        }
      }
    ) }) })
  ] });
});
const operators = binaryScalarDefs.map((def) => ({ label: def.sign, value: def.sign }));
NestedQuery.displayName = "NestedQuery";
const getStyles = (theme) => {
  return {
    card: css({
      label: "card",
      display: "flex",
      flexDirection: "column",
      gap: theme.spacing(0.5)
    }),
    header: css({
      label: "header",
      padding: theme.spacing(0.5, 0.5, 0.5, 1),
      gap: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    name: css({
      label: "name",
      whiteSpace: "nowrap"
    }),
    body: css({
      label: "body",
      paddingLeft: theme.spacing(2)
    }),
    vectorMatchInput: css({
      label: "vectorMatchInput",
      marginLeft: -1
    }),
    vectorMatchWrapper: css({
      label: "vectorMatchWrapper",
      display: "flex"
    })
  };
};

export { NestedQuery };
//# sourceMappingURL=NestedQuery.mjs.map
