import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import Tooltip from 'rc-tooltip';
import { useRef, useEffect } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const HandleTooltip = (props) => {
  const { value, children, visible, placement, tipFormatter, ...restProps } = props;
  const tooltipRef = useRef(null);
  const rafRef = useRef(null);
  const styles = useStyles2(tooltipStyles);
  function cancelKeepAlign() {
    if (rafRef.current !== null) {
      cancelAnimationFrame(rafRef.current);
    }
  }
  function keepAlign() {
    rafRef.current = requestAnimationFrame(() => {
      var _a;
      (_a = tooltipRef.current) == null ? void 0 : _a.forceAlign();
    });
  }
  useEffect(() => {
    if (visible) {
      keepAlign();
    } else {
      cancelKeepAlign();
    }
    return cancelKeepAlign;
  }, [value, visible]);
  return /* @__PURE__ */ jsx(
    Tooltip,
    {
      overlayClassName: styles.tooltip,
      placement,
      overlay: tipFormatter != null ? tipFormatter : value,
      overlayInnerStyle: { minHeight: "auto" },
      ref: tooltipRef,
      visible,
      ...restProps,
      children
    }
  );
};
const tooltipStyles = (theme) => {
  return {
    tooltip: css({
      position: "absolute",
      display: "block",
      visibility: "visible",
      fontSize: theme.typography.bodySmall.fontSize,
      opacity: 0.9,
      padding: 3,
      zIndex: theme.zIndex.tooltip
    })
  };
};

export { HandleTooltip as default };
//# sourceMappingURL=HandleTooltip.mjs.map
