import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '../../../../themes/index.mjs';
import { ActionButton } from '../../../Actions/ActionButton.mjs';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';

"use strict";
const ActionsCell = ({ actions }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.buttonsGap, children: actions && actions.map((action, i) => /* @__PURE__ */ jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles = (theme) => ({
  buttonsGap: css({
    display: "flex",
    gap: 6
  })
});

export { ActionsCell };
//# sourceMappingURL=ActionsCell.mjs.map
