import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { t } from '../../utils/i18n.mjs';
import '../Button/index.mjs';
import { ConfirmModal } from '../ConfirmModal/ConfirmModal.mjs';
import { Button } from '../Button/Button.mjs';

"use strict";
function ActionButton({ action, ...buttonProps }) {
  const [showConfirm, setShowConfirm] = useState(false);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Button,
      {
        variant: "primary",
        size: "sm",
        onClick: () => setShowConfirm(true),
        ...buttonProps,
        style: { width: "fit-content" },
        children: action.title
      }
    ),
    showConfirm && /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        isOpen: true,
        title: t("grafana-ui.action-editor.button.confirm-action", "Confirm action"),
        body: action.confirmation,
        confirmText: t("grafana-ui.action-editor.button.confirm", "Confirm"),
        confirmButtonVariant: "primary",
        onConfirm: () => {
          setShowConfirm(false);
          action.onClick(new MouseEvent("click"));
        },
        onDismiss: () => {
          setShowConfirm(false);
        }
      }
    )
  ] });
}

export { ActionButton };
//# sourceMappingURL=ActionButton.mjs.map
