import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useState, useEffect } from 'react';
import { usePrevious } from 'react-use';
import { useStyles2, InlineLabel, Tooltip, IconButton } from '@grafana/ui';

"use strict";
function PromExemplarField({ datasource, onChange, query, ...rest }) {
  const [error, setError] = useState(null);
  const styles = useStyles2(getStyles);
  const prevError = usePrevious(error);
  useEffect(() => {
    if (!datasource.exemplarsAvailable) {
      setError("Exemplars for this query are not available");
      onChange(false);
    } else if (query.instant && !query.range) {
      setError("Exemplars are not available for instant queries");
      onChange(false);
    } else {
      setError(null);
      if (prevError && !error) {
        onChange(true);
      }
    }
  }, [datasource.exemplarsAvailable, query.instant, query.range, onChange, prevError, error]);
  const iconButtonStyles = cx(
    {
      [styles.activeIcon]: !!query.exemplar
    },
    styles.eyeIcon
  );
  return /* @__PURE__ */ jsx(InlineLabel, { width: "auto", "data-testid": rest["data-testid"], children: /* @__PURE__ */ jsx(Tooltip, { content: error != null ? error : "", children: /* @__PURE__ */ jsxs("div", { className: styles.iconWrapper, children: [
    "Exemplars",
    /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "eye",
        tooltip: !!query.exemplar ? "Disable query with exemplars" : "Enable query with exemplars",
        disabled: !!error,
        className: iconButtonStyles,
        onClick: () => {
          onChange(!query.exemplar);
        }
      }
    )
  ] }) }) });
}
function getStyles(theme) {
  return {
    eyeIcon: css({
      marginLeft: theme.spacing(2)
    }),
    activeIcon: css({
      color: theme.colors.primary.main
    }),
    iconWrapper: css({
      display: "flex",
      alignItems: "center"
    })
  };
}

export { PromExemplarField };
//# sourceMappingURL=PromExemplarField.mjs.map
