import { jsx } from 'react/jsx-runtime';
import i18next from 'i18next';
import { initReactI18next, Trans as Trans$1 } from 'react-i18next';

"use strict";
function initI18n() {
  if (typeof i18next.options.resources !== "object") {
    i18next.use(initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ jsx(Trans$1, { ...props });
};
const tFunc = i18next.t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

export { Trans, t };
//# sourceMappingURL=i18n.mjs.map
