import * as react_jsx_runtime from 'react/jsx-runtime';
import * as React from 'react';
import { DataFrame, TimeRange, FieldConfigSource, InterpolateFunction, KeyValue, Field, ActionModel, BootData } from '@grafana/data';
import { TableCellHeight } from '@grafana/schema';

declare const skeletonAnimation: {
    animationName: string;
    animationDelay: string;
    animationTimingFunction: string;
    animationDuration: string;
    animationFillMode: string;
};
interface SkeletonProps {
    /**
     * Spread these props at the root of your skeleton to handle animation logic
     */
    rootProps: {
        style: React.CSSProperties;
    };
}
type SkeletonComponent<P = {}> = React.ComponentType<P & SkeletonProps>;
/**
 * Use this to attach a skeleton as a static property on the component.
 * e.g. if you render a component with `<Component />`, you can render the skeleton with `<Component.Skeleton />`.
 * @param Component   A functional or class component
 * @param Skeleton    A functional or class skeleton component
 * @returns           A wrapped component with a static skeleton property
 */
declare const attachSkeleton: <C extends object, P>(Component: C, Skeleton: SkeletonComponent<P>) => C & {
    Skeleton: (props: P) => react_jsx_runtime.JSX.Element;
};

declare const FILTER_FOR_OPERATOR = "=";
declare const FILTER_OUT_OPERATOR = "!=";
type AdHocFilterOperator = typeof FILTER_FOR_OPERATOR | typeof FILTER_OUT_OPERATOR;
type AdHocFilterItem = {
    key: string;
    value: string;
    operator: AdHocFilterOperator;
};
type TableFilterActionCallback = (item: AdHocFilterItem) => void;
type TableColumnResizeActionCallback = (fieldDisplayName: string, width: number) => void;
type TableSortByActionCallback = (state: TableSortByFieldState[]) => void;
type FooterItem = Array<KeyValue<string>> | string | undefined;
type GetActionsFunction = (frame: DataFrame, field: Field, rowIndex: number, replaceVariables?: InterpolateFunction) => ActionModel[];
interface TableSortByFieldState {
    displayName: string;
    desc?: boolean;
}
interface TableFooterCalc {
    show: boolean;
    reducer?: string[];
    fields?: string[];
    enablePagination?: boolean;
    countRows?: boolean;
}
interface BaseTableProps {
    ariaLabel?: string;
    data: DataFrame;
    width: number;
    height: number;
    maxHeight?: number;
    /** Minimal column width specified in pixels */
    columnMinWidth?: number;
    noHeader?: boolean;
    showTypeIcons?: boolean;
    resizable?: boolean;
    initialSortBy?: TableSortByFieldState[];
    onColumnResize?: TableColumnResizeActionCallback;
    onSortByChange?: TableSortByActionCallback;
    onCellFilterAdded?: TableFilterActionCallback;
    footerOptions?: TableFooterCalc;
    footerValues?: FooterItem[];
    enablePagination?: boolean;
    cellHeight?: TableCellHeight;
    /** @alpha Used by SparklineCell when provided */
    timeRange?: TimeRange;
    enableSharedCrosshair?: boolean;
    initialRowIndex?: number;
    fieldConfig?: FieldConfigSource;
    getActions?: GetActionsFunction;
    replaceVariables?: InterpolateFunction;
    enableVirtualization?: boolean;
}
interface TableNGProps extends BaseTableProps {
}

declare global {
    interface Window {
        grafanaBootData?: BootData;
    }
}

declare global {
    interface Window {
        grafanaBootData?: BootData;
    }
}

declare function TableNG(props: TableNGProps): react_jsx_runtime.JSX.Element;

export { type SkeletonComponent, TableNG, attachSkeleton, skeletonAnimation };
