import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef, useState } from 'react';
import { RgbaStringColorPicker } from 'react-colorful';
import { useThrottleFn } from 'react-use';
import { colorManipulator } from '@grafana/data';
import '../../themes/index.mjs';
import { ClickOutsideWrapper } from '../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import ColorInput from './ColorInput.mjs';
import { getStyles as getStyles$1 } from './SpectrumPalette.mjs';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const ColorPickerInput = forwardRef(
  ({ value = "", onChange, returnColorAs = "rgb", ...inputProps }, ref) => {
    const [currentColor, setColor] = useState(value);
    const [isOpen, setIsOpen] = useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles);
    const paletteStyles = useStyles2(getStyles$1);
    useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(colorManipulator.asRgbString(color));
        } else {
          onChange(colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    const handleBlur = (evt) => {
      var _a;
      const isClickInPopover = (_a = document.querySelector('[data-testid="color-popover"]')) == null ? void 0 : _a.contains(evt.relatedTarget);
      if (!isClickInPopover) {
        setIsOpen(false);
      }
    };
    return /* @__PURE__ */ jsx(ClickOutsideWrapper, { onClick: () => setIsOpen(false), children: /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
      isOpen && !inputProps.disabled && /* @__PURE__ */ jsx(
        RgbaStringColorPicker,
        {
          "data-testid": "color-popover",
          color: currentColor,
          onChange: setColor,
          className: cx(paletteStyles.root, styles.picker)
        }
      ),
      /* @__PURE__ */ jsx(
        ColorInput,
        {
          ...inputProps,
          theme,
          color: currentColor,
          onChange: setColor,
          buttonAriaLabel: "Open color picker",
          onClick: () => setIsOpen(true),
          onBlur: (e) => handleBlur(e),
          ref,
          isClearable: true
        }
      )
    ] }) });
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles = (theme) => {
  return {
    wrapper: css({
      position: "relative"
    }),
    picker: css({
      "&.react-colorful": {
        position: "absolute",
        width: "100%",
        zIndex: 11,
        bottom: "36px"
      }
    }),
    inner: css({
      position: "absolute"
    })
  };
};

export { ColorPickerInput };
//# sourceMappingURL=ColorPickerInput.mjs.map
