import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '../../themes/index.mjs';
import { Icon } from '../Icon/Icon.mjs';
import '../Tooltip/index.mjs';
import { TitleItem } from './TitleItem.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

"use strict";
function PanelDescription({ description, className }) {
  const styles = useStyles2(getStyles);
  const getDescriptionContent = () => {
    const panelDescription = typeof description === "function" ? description() : description;
    return /* @__PURE__ */ jsx("div", { className: "panel-info-content markdown-html", children: /* @__PURE__ */ jsx("div", { dangerouslySetInnerHTML: { __html: panelDescription } }) });
  };
  return description !== "" ? /* @__PURE__ */ jsx(Tooltip, { interactive: true, content: getDescriptionContent, children: /* @__PURE__ */ jsx(TitleItem, { className: cx(className, styles.description), children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "md" }) }) }) : null;
}
const getStyles = (theme) => {
  return {
    description: css({
      code: {
        whiteSpace: "normal",
        wordWrap: "break-word"
      },
      "pre > code": {
        display: "block"
      }
    })
  };
};

export { PanelDescription };
//# sourceMappingURL=PanelDescription.mjs.map
