import { createContext, useContext, useCallback } from 'react';

"use strict";
const ElementSelectionContext = createContext(void 0);
function useElementSelection(id) {
  if (!id) {
    return {};
  }
  const context = useContext(ElementSelectionContext);
  if (!context) {
    return {};
  }
  const isSelected = context.selected.some((item) => item.id === id);
  const onSelect = useCallback(
    (evt, options = {}) => {
      var _a, _b;
      if (!context.enabled) {
        return;
      }
      evt.stopPropagation();
      if (evt.shiftKey) {
        evt.preventDefault();
        (_a = window.getSelection()) == null ? void 0 : _a.empty();
      }
      context.onSelect({ id }, { ...options, multi: (_b = options.multi) != null ? _b : evt.shiftKey });
    },
    [context, id]
  );
  const onClear = useCallback(() => {
    if (!context.enabled) {
      return;
    }
    context.onClear();
  }, [context]);
  return { isSelected, onSelect, onClear, isSelectable: context.enabled };
}

export { ElementSelectionContext, useElementSelection };
//# sourceMappingURL=ElementSelectionContext.mjs.map
