import { jsx, Fragment } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { isString } from 'lodash';
import { dateTimeFormat } from '@grafana/data';
import '../../../themes/index.mjs';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';

"use strict";
const TimeZoneOffset = (props) => {
  const { timestamp, timeZone, className } = props;
  const styles = useStyles2(getStyles);
  if (!isString(timeZone)) {
    return null;
  }
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx("span", { className: cx(styles.offset, className), children: formatUtcOffset(timestamp, timeZone) }) });
};
const formatUtcOffset = (timestamp, timeZone) => {
  const offset = dateTimeFormat(timestamp, {
    timeZone,
    format: "Z"
  });
  return `UTC${offset}`;
};
const getStyles = (theme) => {
  const textBase = css({
    fontWeight: "normal",
    fontSize: theme.typography.size.sm,
    color: theme.colors.text.secondary,
    whiteSpace: "normal"
  });
  return {
    offset: css(textBase, {
      color: theme.colors.text.primary,
      background: theme.colors.background.secondary,
      padding: "2px 5px",
      borderRadius: theme.shape.radius.default,
      marginLeft: "4px"
    })
  };
};

export { TimeZoneOffset, formatUtcOffset };
//# sourceMappingURL=TimeZoneOffset.mjs.map
