'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('react/jsx-runtime');

"use strict";
exports.useTranslate = useTranslateDefault;
function useTranslateDefault() {
  const errorMessage = "useTranslate is not set. useTranslate must not be called before Grafana is initialized.";
  if (process.env.NODE_ENV === "development") {
    throw new Error(errorMessage);
  }
  console.error(errorMessage);
  return (id, defaultMessage) => {
    return defaultMessage;
  };
}
function setUseTranslateHook(hook) {
  exports.useTranslate = hook;
}
let TransComponent;
function setTransComponent(transComponent) {
  if (TransComponent && process.env.NODE_ENV !== "test") {
    throw new Error("setTransComponent() function should only be called once, when Grafana is starting.");
  }
  TransComponent = transComponent;
}
function Trans(props) {
  if (!TransComponent) {
    throw new Error("Trans component not set. Use setTransComponent to set the Trans component.");
  }
  return /* @__PURE__ */ jsxRuntime.jsx(TransComponent, { ...props });
}

"use strict";

exports.Trans = Trans;
exports.setTransComponent = setTransComponent;
exports.setUseTranslateHook = setUseTranslateHook;
//# sourceMappingURL=unstable.cjs.map
