import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { Label, Stack, Button } from '@grafana/ui';

"use strict";
function SelectorActions({
  selector,
  validationStatus,
  status,
  error,
  empty,
  onClickRunQuery,
  onClickRunRateQuery,
  onClickValidate,
  onClickClear,
  styles
}) {
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(Label, { children: "4. Resulting selector" }),
    /* @__PURE__ */ jsx("div", { "aria-label": "selector", className: styles.selector, children: selector }),
    validationStatus && /* @__PURE__ */ jsx("div", { className: styles.validationStatus, children: validationStatus }),
    /* @__PURE__ */ jsxs(Stack, { children: [
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useQuery,
          "aria-label": "Use selector for query button",
          disabled: empty,
          onClick: onClickRunQuery,
          children: "Use query"
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useAsRateQuery,
          "aria-label": "Use selector as metrics button",
          variant: "secondary",
          disabled: empty,
          onClick: onClickRunRateQuery,
          children: "Use as rate query"
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.validateSelector,
          "aria-label": "Validate submit button",
          variant: "secondary",
          disabled: empty,
          onClick: onClickValidate,
          children: "Validate selector"
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.clear,
          "aria-label": "Selector clear button",
          variant: "secondary",
          onClick: onClickClear,
          children: "Clear"
        }
      ),
      /* @__PURE__ */ jsx("div", { className: cx(styles.status, (status || error) && styles.statusShowing), children: /* @__PURE__ */ jsx("span", { className: error ? styles.error : "", children: error || status }) })
    ] })
  ] });
}

export { SelectorActions };
//# sourceMappingURL=SelectorActions.mjs.map
