import { TransformationApplicabilityLevels } from '../../types/transformations.mjs';
import { filterFieldsByNameTransformer } from './filterByName.mjs';
import { DataTransformerID } from './ids.mjs';
import { orderFieldsTransformer } from './order.mjs';
import { renameFieldsTransformer } from './rename.mjs';

"use strict";
const organizeFieldsTransformer = {
  id: DataTransformerID.organize,
  name: "Organize fields by name",
  description: "Order, filter and rename fields based on configuration given by user",
  defaultOptions: {
    excludeByName: {},
    indexByName: {},
    renameByName: {},
    includeByName: {}
  },
  isApplicable: (data) => {
    return data.length > 1 ? TransformationApplicabilityLevels.NotPossible : TransformationApplicabilityLevels.Applicable;
  },
  /**
   * Return a modified copy of the series. If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, ctx) => (source) => source.pipe(
    filterFieldsByNameTransformer.operator(
      {
        include: options.includeByName ? { names: mapToExcludeArray(options.includeByName) } : void 0,
        exclude: { names: mapToExcludeArray(options.excludeByName) }
      },
      ctx
    ),
    orderFieldsTransformer.operator(options, ctx),
    renameFieldsTransformer.operator(options, ctx)
  )
};
const mapToExcludeArray = (excludeByName) => {
  if (!excludeByName) {
    return [];
  }
  return Object.keys(excludeByName).filter((name) => excludeByName[name]);
};

export { organizeFieldsTransformer };
//# sourceMappingURL=organize.mjs.map
