import { jsx } from 'react/jsx-runtime';
import { useMemo } from 'react';
import { Context } from './PluginContext.mjs';

"use strict";
function DataSourcePluginContextProvider(props) {
  const { children, instanceSettings } = props;
  const value = useMemo(() => {
    return { instanceSettings, meta: instanceSettings.meta };
  }, [instanceSettings]);
  return /* @__PURE__ */ jsx(Context.Provider, { value, children });
}

export { DataSourcePluginContextProvider };
//# sourceMappingURL=DataSourcePluginContextProvider.mjs.map
