import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useRef, useState, useMemo, useCallback } from 'react';
import '../../index.mjs';
import '../../../themes/index.mjs';
import { Icon } from '../../Icon/Icon.mjs';
import { REGEX_OPERATOR } from './FilterList.mjs';
import { FilterPopup } from './FilterPopup.mjs';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { Popover } from '../../Tooltip/Popover.mjs';

"use strict";
const Filter = ({ column, field, tableStyles }) => {
  var _a;
  const ref = useRef(null);
  const [isPopoverVisible, setPopoverVisible] = useState(false);
  const styles = useStyles2(getStyles);
  const filterEnabled = useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = useState("");
  const [operator, setOperator] = useState(REGEX_OPERATOR);
  if (!field || !((_a = field.config.custom) == null ? void 0 : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ jsxs(
    "button",
    {
      className: cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsx(
              FilterPopup,
              {
                column,
                tableStyles,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles = (theme) => ({
  filterIconEnabled: css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

export { Filter };
//# sourceMappingURL=Filter.mjs.map
