import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { TableCellDisplayMode } from '@grafana/schema';
import '../../../../themes/index.mjs';
import { DataLinksContextMenu } from '../../../DataLinks/DataLinksContextMenu.mjs';
import { getCellLinks } from '../utils.mjs';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';

"use strict";
const DATALINKS_HEIGHT_OFFSET = 10;
const ImageCell = ({ cellOptions, field, height, justifyContent, value, rowIdx }) => {
  var _a;
  const calculatedHeight = height - DATALINKS_HEIGHT_OFFSET;
  const styles = useStyles2(getStyles, calculatedHeight, justifyContent);
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  const { text } = field.display(value);
  const { alt, title } = cellOptions.type === TableCellDisplayMode.Image ? cellOptions : { alt: void 0, title: void 0 };
  const img = /* @__PURE__ */ jsx("img", { alt, src: text, className: styles.image, title });
  return /* @__PURE__ */ jsx("div", { className: styles.imageContainer, children: hasLinks ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsx(
        "div",
        {
          onClick: api.openMenu,
          role: "button",
          tabIndex: 0,
          onKeyDown: (e) => {
            if (e.key === "Enter" && api.openMenu) {
              api.openMenu(e);
            }
          },
          children: img
        }
      );
    } else {
      return img;
    }
  } }) : img });
};
const getStyles = (theme, height, justifyContent) => ({
  image: css({
    height,
    width: "auto"
  }),
  imageContainer: css({
    display: "flex",
    justifyContent
  })
});

export { ImageCell };
//# sourceMappingURL=ImageCell.mjs.map
