import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { inputPadding } from '../Forms/commonStyles.mjs';
import { getInputStyles } from '../Input/Input.mjs';

"use strict";
const InputControl = forwardRef(
  function InputControl2({ focused, invalid, disabled, children, innerProps, prefix, ...otherProps }, ref) {
    const styles = useStyles2(getInputControlStyles, invalid, !!prefix);
    return /* @__PURE__ */ jsxs("div", { className: styles.input, ...innerProps, ref, children: [
      prefix && /* @__PURE__ */ jsx("div", { className: cx(styles.prefix), children: prefix }),
      children
    ] });
  }
);
const getInputControlStyles = (theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: cx(
      inputPadding(theme),
      css({
        width: "100%",
        maxWidth: "100%",
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
        flexWrap: "wrap",
        justifyContent: "space-between",
        paddingRight: 0,
        position: "relative",
        boxSizing: "border-box"
      }),
      withPrefix && css({
        paddingLeft: 0
      })
    ),
    prefix: cx(
      styles.prefix,
      css({
        position: "relative"
      })
    )
  };
};

export { InputControl };
//# sourceMappingURL=InputControl.mjs.map
