'use strict';

var jsxRuntime = require('react/jsx-runtime');
var css = require('@emotion/css');
require('react-data-grid/lib/styles.css');
var React = require('react');
var DataGrid = require('react-data-grid');
var reactUse = require('react-use');
var data = require('@grafana/data');
var schema = require('@grafana/schema');
var hoistNonReactStatics = require('hoist-non-react-statics');
var memoize = require('micro-memoize');
var react = require('@emotion/react');
var tinycolor = require('tinycolor2');
var i18next = require('i18next');
var reactI18next = require('react-i18next');
var e2eSelectors = require('@grafana/e2e-selectors');
var lodash = require('lodash');
var SVG = require('react-inlinesvg');
var ReactDOM = require('react-dom');
var react$1 = require('@floating-ui/react');
var slate = require('slate');
var ReactDOMServer = require('react-dom/server');
var reactTransitionGroup = require('react-transition-group');
var dialog = require('@react-aria/dialog');
var focus = require('@react-aria/focus');
var overlays = require('@react-aria/overlays');
var RcDrawer = require('rc-drawer');
require('rc-drawer/assets/index.css');
var reactWindow = require('react-window');
var classNames = require('classnames');
var ReactSelect = require('react-select');
var ReactAsyncSelect = require('react-select/async');
var Creatable = require('react-select/creatable');
var Scrollbars = require('react-custom-scrollbars-2');
var RCCascader = require('rc-cascader');
var useMeasure = require('react-use/lib/useMeasure');
var AsyncCreatable = require('react-select/async-creatable');
var reactColorful = require('react-colorful');
var dateFns = require('date-fns');
var reactVirtual = require('@tanstack/react-virtual');
var downshift = require('downshift');
var uFuzzy = require('@leeoniya/ufuzzy');
var Calendar = require('react-calendar');
var uuid = require('uuid');
var RcPicker = require('rc-picker');
var generateConfig = require('rc-picker/lib/generate/moment');
var locale = require('rc-picker/lib/locale/en_US');
require('rc-picker/assets/index.css');
var reactTable = require('react-table');
var Skeleton = require('react-loading-skeleton');
var reactHookForm = require('react-hook-form');
var Plain = require('slate-plain-serializer');
var slateReact = require('slate-react');
var isHotkey = require('is-hotkey');
var Prism = require('prismjs');
var immutable = require('immutable');
var calculateSize = require('calculate-size');
var Highlighter = require('react-highlight-words');
var reactRouterDomV5Compat = require('react-router-dom-v5-compat');
var rxjs = require('rxjs');
var operators = require('rxjs/operators');
var WKT = require('ol/format/WKT');
var geom = require('ol/geom');
var uPlot = require('uplot');
require('uplot/dist/uPlot.min.css');
var $ = require('jquery');
var usePrevious = require('react-use/lib/usePrevious');
var useClickAway = require('react-use/lib/useClickAway');
var dnd = require('@hello-pangea/dnd');
var faroWebSdk = require('@grafana/faro-web-sdk');
var SliderComponent = require('rc-slider');
require('rc-slider/assets/index.css');
var Tooltip$1 = require('rc-tooltip');
var reactDropzone = require('react-dropzone');
var uwrap = require('uwrap');
var format = require('ol/format');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceCompat(React);
var DataGrid__default = /*#__PURE__*/_interopDefaultCompat(DataGrid);
var hoistNonReactStatics__default = /*#__PURE__*/_interopDefaultCompat(hoistNonReactStatics);
var memoize__default = /*#__PURE__*/_interopDefaultCompat(memoize);
var tinycolor__default = /*#__PURE__*/_interopDefaultCompat(tinycolor);
var i18next__default = /*#__PURE__*/_interopDefaultCompat(i18next);
var SVG__default = /*#__PURE__*/_interopDefaultCompat(SVG);
var ReactDOM__default = /*#__PURE__*/_interopDefaultCompat(ReactDOM);
var ReactDOMServer__default = /*#__PURE__*/_interopDefaultCompat(ReactDOMServer);
var RcDrawer__default = /*#__PURE__*/_interopDefaultCompat(RcDrawer);
var classNames__default = /*#__PURE__*/_interopDefaultCompat(classNames);
var ReactSelect__default = /*#__PURE__*/_interopDefaultCompat(ReactSelect);
var ReactAsyncSelect__default = /*#__PURE__*/_interopDefaultCompat(ReactAsyncSelect);
var Creatable__default = /*#__PURE__*/_interopDefaultCompat(Creatable);
var Scrollbars__default = /*#__PURE__*/_interopDefaultCompat(Scrollbars);
var RCCascader__default = /*#__PURE__*/_interopDefaultCompat(RCCascader);
var useMeasure__default = /*#__PURE__*/_interopDefaultCompat(useMeasure);
var AsyncCreatable__default = /*#__PURE__*/_interopDefaultCompat(AsyncCreatable);
var uFuzzy__default = /*#__PURE__*/_interopDefaultCompat(uFuzzy);
var Calendar__default = /*#__PURE__*/_interopDefaultCompat(Calendar);
var RcPicker__default = /*#__PURE__*/_interopDefaultCompat(RcPicker);
var generateConfig__default = /*#__PURE__*/_interopDefaultCompat(generateConfig);
var locale__default = /*#__PURE__*/_interopDefaultCompat(locale);
var Skeleton__default = /*#__PURE__*/_interopDefaultCompat(Skeleton);
var Plain__default = /*#__PURE__*/_interopDefaultCompat(Plain);
var Prism__default = /*#__PURE__*/_interopDefaultCompat(Prism);
var calculateSize__default = /*#__PURE__*/_interopDefaultCompat(calculateSize);
var Highlighter__default = /*#__PURE__*/_interopDefaultCompat(Highlighter);
var WKT__default = /*#__PURE__*/_interopDefaultCompat(WKT);
var uPlot__default = /*#__PURE__*/_interopDefaultCompat(uPlot);
var $__default = /*#__PURE__*/_interopDefaultCompat($);
var usePrevious__default = /*#__PURE__*/_interopDefaultCompat(usePrevious);
var useClickAway__default = /*#__PURE__*/_interopDefaultCompat(useClickAway);
var SliderComponent__default = /*#__PURE__*/_interopDefaultCompat(SliderComponent);
var Tooltip__default = /*#__PURE__*/_interopDefaultCompat(Tooltip$1);

"use strict";
const fadeIn = css.keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ jsxRuntime.jsx(
      Skeleton,
      {
        ...props,
        rootProps: {
          style: skeletonAnimation
        }
      }
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

"use strict";
function stylesFactory(stylesCreator) {
  return memoize__default.default(stylesCreator);
}

"use strict";
let ThemeContextMock = null;
const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsxRuntime.jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsxRuntime.jsx(Component, { ...props, theme: theme.v1 }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default.default(WithTheme, Component);
  return WithTheme;
};
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsxRuntime.jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsxRuntime.jsx(Component, { ...props, theme }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default.default(WithTheme, Component);
  return WithTheme;
};
function useTheme() {
  return React.useContext(ThemeContextMock || data.ThemeContext).v1;
}
function useTheme2() {
  return React.useContext(ThemeContextMock || data.ThemeContext);
}
function useStyles(getStyles) {
  const theme = useTheme();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  if (!theme.colors.background.elevated) {
    theme.colors.background.elevated = theme.colors.mode === "light" ? theme.colors.background.primary : theme.colors.background.secondary;
  }
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize__default.default(getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}
const mockThemeContext = (theme) => {
  ThemeContextMock = React__namespace.createContext(theme);
  return () => {
    ThemeContextMock = null;
  };
};

"use strict";
let themeMock;
const getTheme = (mode = "dark") => {
  if (themeMock) {
    return themeMock(mode);
  }
  return data.createTheme({ colors: { mode } }).v1;
};
const mockTheme = (mock) => {
  themeMock = mock;
  return () => {
    themeMock = null;
  };
};

"use strict";
function getAccessibilityStyles(theme) {
  return react.css({
    ".sr-only": {
      position: "absolute",
      width: "1px",
      height: "1px",
      padding: 0,
      margin: "-1px",
      overflow: "hidden",
      clip: "rect(0, 0, 0, 0)",
      border: 0
    }
  });
}

"use strict";
function getAlertingStyles(theme) {
  return react.css({
    ".alert-state-paused, .alert-state-pending": {
      color: theme.colors.text.secondary,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".alert-state-ok": {
      color: theme.colors.success.text,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".alert-state-warning": {
      color: theme.colors.warning.text,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".alert-state-critical": {
      color: theme.colors.error.text,
      fontWeight: theme.typography.fontWeightMedium
    }
  });
}

"use strict";
function getCardStyles$1(theme) {
  return react.css({
    ".card-section": {
      marginBottom: theme.spacing(4)
    },
    ".card-list": {
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      listStyleType: "none"
    },
    ".card-item": {
      display: "block",
      height: "100%",
      background: theme.colors.background.secondary,
      boxShadow: "none",
      padding: theme.spacing(2),
      borderRadius: "4px",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary, 0.03)
      },
      ".label-tag": {
        marginLeft: theme.spacing(1),
        fontSize: "11px",
        padding: "2px 6px"
      }
    },
    ".card-item-body": {
      display: "flex",
      overflow: "hidden"
    },
    ".card-item-details": {
      overflow: "hidden"
    },
    ".card-item-header": {
      marginBottom: theme.spacing(2)
    },
    ".card-item-type": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".card-item-badge": {
      margin: "6px 0"
    },
    ".card-item-notice": {
      fontSize: theme.typography.size.sm
    },
    ".card-item-name": {
      color: theme.colors.text.primary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-label": {
      marginLeft: theme.spacing(1)
    },
    ".card-item-sub-name": {
      color: theme.colors.text.secondary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-sub-name--header": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      marginBottom: theme.spacing(2),
      fontSize: theme.typography.size.sm,
      fontWeight: "bold"
    },
    ".card-list-layout-grid": {
      ".card-item-type": {
        display: "inline-block"
      },
      ".card-item-notice": {
        fontSize: theme.typography.size.sm,
        display: "inline-block",
        marginLeft: theme.spacing(2)
      },
      ".card-item-header-action": {
        float: "right"
      },
      ".card-item-wrapper": {
        width: "100%",
        padding: theme.spacing(0, 2, 2, 0)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 2, 0),
        height: "80px",
        img: {
          width: "80px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h3.fontSize
      },
      [theme.breakpoints.up("md")]: {
        ".card-item-wrapper": {
          width: "50%"
        }
      },
      [theme.breakpoints.up("lg")]: {
        ".card-item-wrapper": {
          width: "33.333333%"
        }
      },
      "&.card-list-layout-grid--max-2-col": {
        [theme.breakpoints.up("lg")]: {
          ".card-item-wrapper": {
            width: "50%"
          }
        }
      }
    },
    ".card-list-layout-list": {
      ".card-item-wrapper": {
        padding: 0,
        width: "100%",
        marginBottom: theme.spacing(1)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item": {
        borderRadius: "2px"
      },
      ".card-item-header": {
        float: "right",
        textAlign: "right"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 0, 0),
        img: {
          width: "48px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h4.fontSize
      },
      ".card-item-sub-name": {
        fontSize: theme.typography.size.sm
      },
      ".layout-selector": {
        marginRight: 0
      }
    }
  });
}

"use strict";
function getCodeStyles(theme) {
  return react.css({
    "code, pre, kbd, samp": {
      ...theme.typography.code,
      fontSize: theme.typography.bodySmall.fontSize,
      backgroundColor: theme.colors.background.primary,
      color: theme.colors.text.primary,
      border: `1px solid ${theme.colors.border.medium}`,
      borderRadius: "4px"
    },
    code: {
      whiteSpace: "nowrap",
      padding: "2px 5px",
      margin: "0 2px"
    },
    pre: {
      display: "block",
      margin: theme.spacing(0, 0, 2),
      lineHeight: theme.typography.body.lineHeight,
      wordBreak: "break-all",
      wordWrap: "break-word",
      whiteSpace: "pre-wrap",
      overflow: "auto",
      padding: "10px",
      code: {
        padding: 0,
        color: "inherit",
        whiteSpace: "pre-wrap",
        backgroundColor: "transparent",
        border: 0
      }
    }
  });
}

"use strict";
function getDashboardGridStyles(theme) {
  return react.css({
    ".react-resizable-handle": {
      // this needs to use visibility and not display none in order not to cause resize flickering
      visibility: "hidden"
    },
    ".react-grid-item, #grafana-portal-container": {
      touchAction: "initial !important",
      "&:hover": {
        ".react-resizable-handle": {
          visibility: "visible"
        }
      }
    },
    ".dragging-active": {
      "*": {
        cursor: "move",
        userSelect: "none"
      }
    },
    [theme.breakpoints.down("md")]: {
      ".react-grid-layout": {
        height: "unset !important"
      },
      ".react-grid-item": {
        display: "block !important",
        transitionProperty: "none !important",
        // can't avoid type assertion here due to !important
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        position: "unset !important",
        transform: "translate(0px, 0px) !important",
        marginBottom: theme.spacing(2)
      },
      ".panel-repeater-grid-item": {
        height: "auto !important"
      }
    },
    ".react-grid-item.react-grid-placeholder": {
      boxShadow: `0 0 4px ${theme.colors.primary.border} !important`,
      background: `${theme.colors.primary.transparent} !important`,
      zIndex: "-1 !important",
      opacity: "unset !important"
    },
    ".react-grid-item > .react-resizable-handle::after": {
      borderRight: `2px solid ${theme.isDark ? theme.v1.palette.gray1 : theme.v1.palette.gray3} !important`,
      borderBottom: `2px solid ${theme.isDark ? theme.v1.palette.gray1 : theme.v1.palette.gray3} !important`
    },
    // Hack for preventing panel menu overlapping.
    ".react-grid-item.resizing.panel, .react-grid-item.panel.dropdown-menu-open, .react-grid-item.react-draggable-dragging.panel": {
      zIndex: theme.zIndex.dropdown
    },
    // Disable animation on initial rendering and enable it when component has been mounted.
    ".react-grid-item.cssTransforms": {
      transitionProperty: "none !important"
    },
    [theme.transitions.handleMotion("no-preference")]: {
      ".react-grid-layout--enable-move-animations": {
        ".react-grid-item.cssTransforms": {
          transitionProperty: "transform !important"
        }
      }
    },
    ".dashboard-selected-element": {
      outline: `1px dashed ${theme.colors.primary.border}`,
      outlineOffset: "0px",
      borderRadius: theme.shape.radius.default
    },
    ".dashboard-selectable-element": {
      "&:hover": {
        outline: `1px dashed ${theme.colors.border.strong}`,
        outlineOffset: "0px",
        borderRadius: theme.shape.radius.default,
        backgroundColor: theme.colors.emphasize(theme.colors.background.canvas, 0.08)
      }
    },
    ".dashboard-canvas-add-button": {
      display: "flex",
      opacity: 0.5,
      transition: theme.transitions.create("opacity"),
      filter: `grayscale(100%)`,
      "&:hover": {
        opacity: 1,
        filter: "unset"
      }
    },
    ".dashboard-visible-hidden-element": {
      position: "relative"
    },
    // Universal style for marking drop targets when dragging between layouts
    ".dashboard-drop-target": {
      // Setting same options for hovered and not hovered to overwrite any conflicting styles
      // There was a race condition with selectable elements styles
      "&:is(:hover),&:not(:hover)": {
        outline: `2px solid ${theme.colors.primary.border}`,
        outlineOffset: "0px",
        borderRadius: "2px"
      }
    },
    // Body style for preventing selection when dragging
    ".dashboard-draggable-transparent-selection": {
      "*::selection": {
        all: "inherit"
      }
    },
    ".react-draggable-dragging": {
      opacity: 0.8
    }
  });
}

"use strict";
function getDashDiffStyles(theme) {
  return react.css({
    ".delta-html": {
      background: theme.colors.background.secondary,
      paddingTop: "5px",
      paddingBottom: "5px",
      userSelect: "none"
    },
    ".diff-line": {
      color: theme.colors.text.primary,
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.size.sm,
      lineHeight: 2,
      marginBottom: 0,
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap",
      position: "relative",
      "&:after": {
        left: "-40px"
      }
    },
    ".diff-line-number": {
      color: theme.colors.text.secondary,
      display: "inline-block",
      fontSize: theme.typography.size.xs,
      lineHeight: 2.3,
      textAlign: "right",
      width: "30px"
    },
    ".diff-line-number-hide": {
      visibility: "hidden"
    },
    ".diff-line-icon": {
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.xs,
      float: "right",
      position: "relative",
      top: "2px",
      right: "10px"
    },
    ".diff-json-new, .diff-json-old, .diff-json-deleted, .diff-json-added": {
      color: theme.v1.palette.gray5,
      ".diff-line-number": {
        color: theme.colors.text.primary
      }
    },
    ".diff-json-new": {
      backgroundColor: theme.isDark ? "#457740" : "#664e33"
    },
    ".diff-json-old": {
      backgroundColor: theme.isDark ? "#a04338" : "#5a372a"
    },
    ".diff-json-added": {
      backgroundColor: theme.colors.primary.shade
    },
    ".diff-json-deleted": {
      backgroundColor: theme.colors.error.shade
    },
    ".diff-value": {
      userSelect: "all"
    },
    // Basic
    ".diff-circle": {
      marginRight: "0.5em",
      "*": {
        marginBottom: "1px"
      }
    },
    ".diff-circle-changed": {
      color: "#f59433"
    },
    ".diff-circle-added": {
      color: "#29d761"
    },
    ".diff-circle-deleted": {
      color: "#fd474a"
    },
    ".diff-item-added, .diff-item-deleted": {
      listStyle: "none"
    },
    ".diff-group": {
      background: theme.colors.background.secondary,
      fontSize: "16px",
      fontStyle: "normal",
      padding: "10px 15px",
      margin: theme.spacing(2, 0),
      ".diff-group": {
        padding: "0 5px"
      }
    },
    ".diff-group-name": {
      display: "inline-block",
      width: "100%",
      fontSize: "16px",
      paddingLeft: "1.75em",
      margin: "0 0 14px 0"
    },
    ".diff-summary-key": {
      paddingLeft: "0.25em"
    },
    ".diff-list": {
      paddingLeft: "40px",
      ".diff-list": {
        paddingLeft: 0
      }
    },
    ".diff-item": {
      color: theme.v1.palette.gray2,
      lineHeight: 2.5,
      "> div": {
        display: "inline"
      }
    },
    ".diff-item-changeset": {
      listStyle: "none"
    },
    ".diff-label": {
      backgroundColor: theme.colors.action.hover,
      borderRadius: "3px",
      color: theme.colors.text.primary,
      display: "inline",
      fontSize: `${theme.typography.fontSize}px`,
      margin: "0 5px",
      padding: "3px 8px"
    },
    ".diff-linenum": {
      float: "right"
    },
    ".diff-arrow": {
      color: theme.colors.text.primary
    },
    ".diff-block": {
      width: "100%",
      display: "inline-block"
    },
    ".diff-block-title": {
      fontSize: "16px",
      display: "inline-block"
    },
    ".diff-title": {
      fontSize: "16px"
    },
    ".diff-change-container": {
      margin: "0 0",
      paddingLeft: "3em",
      paddingRight: 0
    },
    ".diff-change-group": {
      width: "100%",
      color: theme.colors.text.primary,
      marginBottom: "14px"
    },
    ".diff-change-item": {
      display: "inline-block"
    },
    ".diff-change-title": {
      fontSize: "16px"
    },
    ".bullet-position-container": {
      position: "relative",
      left: "-6px"
    },
    ".diff-list-circle": {
      marginBottom: "3px"
    }
  });
}

"use strict";
function cardChrome(theme) {
  return `
    background: ${theme.colors.background.secondary};
    &:hover {
      background: ${hoverColor(theme.colors.background.secondary, theme)};
    }
    box-shadow: ${theme.components.panel.boxShadow};
    border-radius: ${theme.shape.radius.default};
`;
}
function hoverColor(color, theme) {
  return theme.isDark ? tinycolor__default.default(color).brighten(2).toString() : tinycolor__default.default(color).darken(2).toString();
}
function listItem(theme) {
  return `
  background: ${theme.colors.background.secondary};
  &:hover {
    background: ${hoverColor(theme.colors.background.secondary, theme)};
  }
  box-shadow: ${theme.components.panel.boxShadow};
  border-radius: ${theme.shape.radius.default};
`;
}
function listItemSelected(theme) {
  return `
    background: ${hoverColor(theme.colors.background.secondary, theme)};
    color: ${theme.colors.text.maxContrast};
`;
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
const isGrafanaTheme2 = (theme) => theme.hasOwnProperty("v1");
const focusCss = (theme) => {
  const isTheme2 = isGrafanaTheme2(theme);
  const firstColor = isTheme2 ? theme.colors.background.canvas : theme.colors.bodyBg;
  const secondColor = isTheme2 ? theme.colors.primary.main : theme.colors.formFocusOutline;
  return `
  outline: 2px dotted transparent;
  outline-offset: 2px;
  box-shadow: 0 0 0 2px ${firstColor}, 0 0 0px 4px ${secondColor};
  transition-property: outline, outline-offset, box-shadow;
  transition-duration: 0.2s;
  transition-timing-function: cubic-bezier(0.19, 1, 0.22, 1);`;
};
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => ({
  overflow: "hidden",
  background: theme.colors.background.elevated,
  boxShadow: theme.shadows.z2,
  maxWidth: "800px",
  padding: theme.spacing(1),
  borderRadius: theme.shape.radius.default,
  zIndex: theme.zIndex.tooltip
});
const getExternalRadius = (theme, offset, additionalOptions = {}) => {
  const { selfBorderWidth = 1, childBorderRadius } = additionalOptions;
  const childBorderRadiusPx = childBorderRadius !== void 0 ? `${childBorderRadius}px` : theme.shape.radius.default;
  return `calc(max(0px, ${childBorderRadiusPx} + ${offset}px + ${selfBorderWidth}px))`;
};
const getInternalRadius = (theme, offset, additionalOptions = {}) => {
  const { parentBorderWidth = 1, parentBorderRadius } = additionalOptions;
  const parentBorderRadiusPx = parentBorderRadius !== void 0 ? `${parentBorderRadius}px` : theme.shape.radius.default;
  return `calc(max(0px, ${parentBorderRadiusPx} - ${offset}px - ${parentBorderWidth}px))`;
};

var mixins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  cardChrome: cardChrome,
  focusCss: focusCss,
  getExternalRadius: getExternalRadius,
  getFocusStyles: getFocusStyles,
  getInternalRadius: getInternalRadius,
  getMouseFocusStyles: getMouseFocusStyles,
  getTooltipContainerStyles: getTooltipContainerStyles,
  hoverColor: hoverColor,
  listItem: listItem,
  listItemSelected: listItemSelected,
  mediaUp: mediaUp
});

"use strict";
function getElementStyles(theme, isExtensionSidebarOpen) {
  const bodyOverflow = isExtensionSidebarOpen ? {} : { overflowY: "auto !important" };
  return react.css({
    "*, *::before, *::after": {
      boxSizing: "inherit"
    },
    // Suppress the focus outline on elements that cannot be accessed via keyboard.
    // This prevents an unwanted focus outline from appearing around elements that
    // might still respond to pointer events.
    //
    // Credit: https://github.com/suitcss/base
    "[tabindex='-1']:focus": {
      outline: "none !important"
    },
    html: {
      MsOverflowStyle: "scrollbar",
      WebkitTapHighlightColor: "rgba(0, 0, 0, 0)",
      boxSizing: "border-box",
      height: "100%",
      fontSize: `${theme.typography.htmlFontSize}px`,
      fontFamily: theme.typography.fontFamily,
      lineHeight: theme.typography.body.lineHeight,
      fontKerning: "normal"
    },
    ":root": {
      colorScheme: theme.colors.mode
    },
    body: {
      height: "100%",
      width: "100%",
      position: "unset",
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.canvas,
      paddingRight: "0 !important",
      "@media print": {
        overflow: "visible"
      },
      "@page": {
        margin: 0,
        size: "auto",
        padding: 0
      },
      // disable contextual font ligatures. otherwise, in firefox and safari,
      // an "x" between 2 numbers is replaced by a multiplication ligature
      // see https://github.com/rsms/inter/issues/222
      fontVariantLigatures: "no-contextual",
      ...theme.typography.body,
      ...bodyOverflow
    },
    "h1, .h1": getVariantStyles(theme.typography.h1),
    "h2, .h2": getVariantStyles(theme.typography.h2),
    "h3, .h3": getVariantStyles(theme.typography.h3),
    "h4, .h4": getVariantStyles(theme.typography.h4),
    "h5, .h5": getVariantStyles(theme.typography.h5),
    "h6, .h6": getVariantStyles(theme.typography.h6),
    p: {
      margin: theme.spacing(0, 0, 2)
    },
    textarea: {
      overflow: "auto",
      // Textareas should really only resize vertically so they don't break their (horizontal) containers.
      resize: "vertical"
    },
    button: {
      letterSpacing: theme.typography.body.letterSpacing,
      "&:focus-visible": getFocusStyles(theme),
      "&:focus": {
        outline: "none"
      }
    },
    label: {
      // Allow labels to use `margin` for spacing.
      display: "inline-block"
    },
    figure: {
      margin: theme.spacing(0, 0, 2)
    },
    img: {
      // By default, `<img>`s are `inline-block`. This assumes that, and vertically
      // centers them. This won't apply should you reset them to `block` level.
      verticalAlign: "middle"
      // Note: `<img>`s are deliberately not made responsive by default.
      // For the rationale behind this, see the comments on the `.img-fluid` class.
    },
    fieldset: {
      // Chrome and Firefox set a `min-width: min-content;` on fieldsets,
      // so we reset that to ensure it behaves more like a standard block element.
      // See https://github.com/twbs/bootstrap/issues/12359.
      minWidth: 0,
      // Reset the default outline behavior of fieldsets so they don't affect page layout.
      padding: 0,
      margin: 0,
      border: 0
    },
    legend: {
      // Reset the entire legend element to match the `fieldset`
      display: "block",
      width: "100%",
      padding: 0,
      marginBottom: theme.spacing(1),
      fontSize: theme.spacing(3),
      lineHeight: "inherit",
      border: 0
    },
    // Ex: 14px base font * 85% = about 12px
    "small, .small": {
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: "normal"
    },
    "b, strong": {
      fontWeight: theme.typography.fontWeightMedium
    },
    em: {
      fontStyle: "italic",
      color: theme.colors.text.primary
    },
    cite: {
      fontStyle: "normal"
    },
    blockquote: {
      padding: theme.spacing(0, 0, 0, 2),
      margin: theme.spacing(0, 0, 2),
      borderLeft: `5px solid ${theme.v1.palette.gray3}`,
      p: {
        marginBottom: 0,
        fontSize: theme.typography.fontSize * 1.25,
        fontWeight: 300,
        lineHeight: 1.25
      },
      small: {
        display: "block",
        lineHeight: theme.typography.body.lineHeight,
        color: theme.v1.palette.gray2,
        "&:before": {
          content: "'\\2014 \\00A0'"
        }
      }
    },
    // Quotes
    "q:before, q:after, blockquote:before, blockquote:after": {
      content: "''"
    },
    // Addresses
    address: {
      display: "block",
      marginBottom: theme.spacing(2),
      fontStyle: "normal",
      lineHeight: theme.typography.body.lineHeight
    },
    "a.external-link": {
      color: theme.colors.text.link,
      textDecoration: "normal",
      "&:hover": {
        color: theme.colors.text.link,
        textDecoration: "underline"
      }
    },
    ".link": {
      color: theme.colors.text.primary,
      cursor: "pointer"
    },
    ".link:hover": {
      color: theme.colors.text.maxContrast
    },
    ".pointer": {
      cursor: "pointer"
    },
    "audio, canvas, progress, video": {
      display: "inline-block",
      verticalAlign: "baseline"
    },
    // Prevent modern browsers from displaying `audio` without controls.
    // Remove excess height in iOS 5 devices.
    "audio:not([controls])": {
      display: "none",
      height: 0
    },
    // Address styling not present in Safari.
    "abbr[title]": {
      borderBottom: "1px dotted",
      cursor: "help"
    },
    dfn: {
      fontStyle: "italic"
    },
    // Prevent `sub` and `sup` affecting `line-height` in all browsers.
    "sub, sup": {
      fontSize: "75%",
      lineHeight: 0,
      position: "relative",
      verticalAlign: "baseline"
    },
    sup: {
      top: "-0.5em"
    },
    sub: {
      bottom: "-0.25em"
    },
    hr: {
      marginTop: theme.spacing(2),
      marginBottom: theme.spacing(2),
      border: 0,
      borderTop: `1px solid ${theme.colors.border.medium}`
    },
    "mark, .mark": {
      background: theme.colors.warning.main
    },
    "ul, ol, dl": {
      marginTop: 0,
      marginBottom: 0,
      padding: 0
    },
    "ul ul, ul ol, ol ol, ol ul": {
      marginBottom: 0
    },
    li: {
      lineHeight: theme.typography.body.lineHeight
    },
    dd: {
      marginBottom: theme.spacing(1),
      marginLeft: 0
      // Undo browser default
    },
    "dt, dd": {
      lineHeight: theme.typography.body.lineHeight
    },
    dt: {
      fontWeight: theme.typography.fontWeightMedium
    },
    // 1. Correct color not being inherited.
    //    Known issue: affects color of disabled elements.
    // 2. Correct font properties not being inherited.
    // 3. Address margins set differently in Firefox 4+, Safari, and Chrome.
    "button, input, optgroup, select, textarea": {
      borderRadius: 0,
      color: "inherit",
      font: "inherit",
      lineHeight: "inherit",
      margin: 0
    },
    // Don't inherit the `font-weight` (applied by a rule above).
    // NOTE: the default cannot safely be changed in Chrome and Safari on OS X.
    optgroup: {
      fontWeight: "bold"
    },
    // 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`
    //    and `video` controls.
    // 2. Correct inability to style clickable `input` types in iOS.
    // 3. Improve usability and consistency of cursor style between image-type
    //    `input` and others.
    'button, html input[type="button"], input[type="submit"]': {
      WebkitAppearance: "button",
      cursor: "pointer"
    },
    'input[type="search"]': {
      // This overrides the extra rounded corners on search inputs in iOS so that our
      // `.form-control` class can properly style them. Note that this cannot simply
      // be added to `.form-control` as it's not specific enough. For details, see
      // https://github.com/twbs/bootstrap/issues/11586.
      WebkitAppearance: "none"
    },
    // Remove inner padding and search cancel button in Safari and Chrome on OS X.
    // Safari (but not Chrome) clips the cancel button when the search input has
    // padding (and `textfield` appearance).
    'input[type="search"]::-webkit-search-cancel-button, input[type="search"]::-webkit-search-decoration': {
      WebkitAppearance: "none"
    },
    table: {
      // Reset for nesting within parents with `background-color`.
      backgroundColor: "transparent",
      borderCollapse: "collapse",
      borderSpacing: 0
    },
    caption: {
      paddingTop: theme.spacing(0.5),
      paddingBottom: theme.spacing(0.5),
      color: theme.colors.text.secondary,
      textAlign: "left",
      captionSide: "bottom"
    },
    th: {
      fontWeight: theme.typography.fontWeightMedium,
      textAlign: "left"
    },
    "td, th": {
      padding: 0
    },
    // Utility classes
    ".muted": {
      color: theme.colors.text.secondary
    },
    "a.muted:hover, a.muted:focus": {
      color: theme.colors.text.primary
    },
    ".text-warning": {
      color: theme.colors.warning.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.warning.text, 0.15)
      }
    },
    ".text-error": {
      color: theme.colors.error.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.error.text, 0.15)
      }
    },
    ".text-success": {
      color: "$success-text-color",
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.success.text, 0.15)
      }
    },
    a: {
      cursor: "pointer",
      color: theme.colors.text.primary,
      textDecoration: "none",
      "&:focus": {
        outline: "none"
      },
      "&:focus-visible": getFocusStyles(theme),
      "&:[disabled]": {
        cursor: "default",
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        pointerEvents: "none !important"
      }
    },
    // iOS "clickable elements" fix for role="button"
    //
    // Fixes "clickability" issue (and more generally, the firing of events such as focus as well)
    // for traditionally non-focusable elements with role="button"
    // see https://developer.mozilla.org/en-US/docs/Web/Events/click#Safari_Mobile
    "[role='button']": {
      cursor: "pointer"
    },
    // Always hide an element with the `hidden` HTML attribute (from PureCSS).
    "[hidden]": {
      display: "none !important"
    },
    // Avoid 300ms click delay on touch devices that support the `touch-action` CSS property.
    //
    // In particular, unlike most other browsers, IE11+Edge on Windows 10 on touch devices and IE Mobile 10-11
    // DON'T remove the click delay when `<meta name="viewport" content="width=device-width">` is present.
    // However, they DO support removing the click delay via `touch-action: manipulation`.
    // See:
    // * http://v4-alpha.getbootstrap.com/content/reboot/#click-delay-optimization-for-touch
    // * http://caniuse.com/#feat=css-touch-action
    // * http://patrickhlauke.github.io/touch/tests/results/#suppressing-300ms-delay
    "a, area, button, [role='button'], input, label, select, summary, textarea": {
      touchAction: "manipulation"
    },
    ".text-link": {
      textDecoration: "underline"
    },
    ".text-left": {
      textAlign: "left"
    },
    ".text-right": {
      textAlign: "right"
    },
    ".text-center": {
      textAlign: "center"
    },
    ".highlight-search-match": {
      background: theme.components.textHighlight.background,
      color: theme.components.textHighlight.text,
      padding: 0
    },
    ".template-variable": {
      color: theme.colors.primary.text
    },
    ".modal-header-title": {
      fontSize: theme.typography.size.lg,
      float: "left",
      paddingTop: theme.spacing(1),
      margin: theme.spacing(0, 2)
    }
  });
}
function getVariantStyles(variant) {
  return {
    margin: 0,
    fontSize: variant.fontSize,
    lineHeight: variant.lineHeight,
    fontWeight: variant.fontWeight,
    letterSpacing: variant.letterSpacing,
    fontFamily: variant.fontFamily,
    marginBottom: "0.45em"
  };
}

"use strict";
function getExtraStyles(theme) {
  return react.css({
    // fix white background on intercom in dark mode
    "iframe.intercom-borderless-frame": {
      colorScheme: theme.colors.mode
    }
  });
}

"use strict";
function getFilterTableStyles(theme) {
  return react.css({
    ".filter-table *": {
      boxSizing: "border-box"
    },
    ".filter-table": {
      width: "100%",
      borderCollapse: "separate",
      tbody: {
        "tr:nth-of-type(odd)": {
          background: theme.colors.emphasize(theme.colors.background.primary, 0.02)
        }
      },
      th: {
        width: "auto",
        padding: theme.spacing(0.5, 1),
        textAlign: "left",
        lineHeight: "30px",
        height: "30px",
        whiteSpace: "nowrap"
      },
      td: {
        padding: theme.spacing(0.5, 1),
        lineHeight: "30px",
        height: "30px",
        whiteSpace: "nowrap"
      },
      ".link-td": {
        padding: 0,
        lineHeight: "30px",
        height: "30px",
        whiteSpace: "nowrap",
        a: {
          display: "block",
          padding: theme.spacing(0, 1),
          height: "30px"
        }
      },
      ".ellipsis": {
        display: "block",
        width: "100%",
        whiteSpace: "nowrap",
        overflow: "hidden",
        textOverflow: "ellipsis"
      },
      ".expanded": {
        borderColor: theme.components.panel.background
      },
      ".expanded > td": {
        paddingBottom: 0
      },
      ".filter-table__avatar": {
        width: "25px",
        height: "25px",
        borderRadius: "50%"
      },
      "&--hover": {
        "tbody tr:hover": {
          background: theme.colors.emphasize(theme.colors.background.primary, 0.05)
        }
      }
    }
  });
}

"use strict";
function getFontStyles(theme) {
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  const fontRoot = grafanaPublicPath ? `${grafanaPublicPath}fonts/` : "public/fonts/";
  return react.css([
    {
      /* latin */
      "@font-face": {
        fontFamily: "Roboto Mono",
        fontStyle: "normal",
        fontWeight: 400,
        fontDisplay: "swap",
        src: `url('${fontRoot}roboto/L0xTDF4xlVMF-BfR8bXMIhJHg45mwgGEFl0_3vrtSM1J-gEPT5Ese6hmHSh0mQ.woff2') format('woff2')`,
        unicodeRange: "U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD"
      }
    },
    {
      /* latin */
      "@font-face": {
        fontFamily: "Roboto Mono",
        fontStyle: "normal",
        fontWeight: 500,
        fontDisplay: "swap",
        src: `url('${fontRoot}roboto/L0xTDF4xlVMF-BfR8bXMIhJHg45mwgGEFl0_3vrtSM1J-gEPT5Ese6hmHSh0mQ.woff2') format('woff2')`,
        unicodeRange: "U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD"
      }
    },
    {
      /*
          To add new variations/version of Inter, download from https://rsms.me/inter/ and add the
          web font files to the public/fonts/inter folder. Do not download the fonts from Google Fonts
          or somewhere else because they don't support the features we require (like tabular numerals).
      
          If adding additional weights, consider switching to the InterVariable variable font as combined
          it may take less space than multiple static weights.
          */
      "@font-face": {
        fontFamily: "Inter",
        fontStyle: "normal",
        fontWeight: 400,
        fontDisplay: "swap",
        src: `url('${fontRoot}inter/Inter-Regular.woff2') format('woff2')`
      }
    },
    {
      "@font-face": {
        fontFamily: "Inter",
        fontStyle: "normal",
        fontWeight: 500,
        fontDisplay: "swap",
        src: `url('${fontRoot}inter/Inter-Medium.woff2') format('woff2')`
      }
    }
  ]);
}

"use strict";
function getFormElementStyles(theme) {
  return react.css({
    "input, button, select, textarea": {
      fontFamily: theme.typography.body.fontFamily,
      fontSize: theme.typography.body.fontSize,
      fontWeight: theme.typography.body.fontWeight,
      lineHeight: theme.typography.body.lineHeight
    },
    "input, select": {
      backgroundColor: theme.components.input.background,
      color: theme.components.input.text,
      border: "none",
      boxShadow: "none"
    },
    // Placeholder text gets special styles because when browsers invalidate entire lines if it doesn't understand a selector
    "input, textarea": {
      "&::placeholder": {
        color: theme.colors.text.disabled
      }
    },
    // not a big fan of number fields
    'input[type="number"]::-webkit-outer-spin-button, input[type="number"]::-webkit-inner-spin-button': {
      WebkitAppearance: "none",
      margin: 0
    },
    'input[type="number"]': {
      MozAppearance: "textfield"
    },
    // Set the height of select and file controls to match text inputs
    'select, input[type="file"]': {
      height: theme.components.height.md,
      lineHeight: theme.components.height.md
    },
    // Make select elements obey height by applying a border
    select: {
      width: "220px",
      // default input width + 10px of padding that doesn't get applied
      border: `1px solid ${theme.components.input.borderColor}`,
      backgroundColor: theme.components.input.background
      // Chrome on Linux and Mobile Safari need background-color
    },
    "select[multiple], select[size], textarea": {
      height: "auto"
    },
    // Focus for select, file, radio, and checkbox
    'select:focus, input[type="file"]:focus, input[type="radio"]:focus, input[type="checkbox"]:focus': {
      // WebKit
      outline: "5px auto -webkit-focus-ring-color",
      outlineOffset: "-2px"
    },
    // Reset width of input images, buttons, radios, checkboxes
    "input[type='file'], input[type='image'], input[type='submit'], input[type='reset'], input[type='button'], input[type='radio'], input[type='checkbox']": {
      width: "auto"
      // Override of generic input selector
    },
    // Disabled and read-only inputs
    "input[disabled], select[disabled], textarea[disabled], input[readonly], select[readonly], textarea[readonly]": {
      cursor: "not-allowed",
      backgroundColor: theme.colors.action.disabledBackground
    },
    // Explicitly reset the colors here
    'input[type="radio"][disabled], input[type="checkbox"][disabled], input[type="radio"][readonly], input[type="checkbox"][readonly]': {
      cursor: "not-allowed",
      backgroundColor: "transparent"
    },
    "input:-webkit-autofill, input:-webkit-autofill:hover, input:-webkit-autofill:focus, input:-webkit-autofill, textarea:-webkit-autofill, textarea:-webkit-autofill:hover, textarea:-webkit-autofill:focus, select:-webkit-autofill, select:-webkit-autofill:hover, select:-webkit-autofill:focus": {
      WebkitBoxShadow: `0 0 0px 1000px ${theme.components.input.background} inset !important`,
      WebkitTextFillColor: theme.components.input.text,
      boxShadow: `0 0 0px 1000px ${theme.components.input.background} inset`,
      border: `1px solid ${theme.components.input.background}`
    },
    ".gf-form": {
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      marginBottom: theme.spacing(0.5),
      "&--offset-1": {
        marginLeft: theme.spacing(2)
      },
      "&--grow": {
        flexGrow: 1
      },
      "&--flex-end": {
        justifyContent: "flex-end"
      },
      "&--align-center": {
        alignContent: "center"
      },
      "&--alt": {
        flexDirection: "column",
        alignItems: "flex-start",
        ".gf-form-label": {
          padding: "4px 0"
        }
      }
    },
    ".gf-form--has-input-icon": {
      position: "relative",
      marginRight: theme.spacing(0.5),
      ".gf-form-input-icon": {
        position: "absolute",
        top: "8px",
        fontSize: theme.typography.size.lg,
        left: "10px",
        color: theme.colors.text.disabled
      },
      "> input": {
        paddingLeft: "35px",
        "&:focus + .gf-form-input-icon": {
          color: theme.colors.text.secondary
        }
      },
      ".Select--multi .Select-multi-value-wrapper, .Select-placeholder": {
        paddingLeft: "30px"
      }
    },
    ".gf-form-disabled": {
      color: theme.colors.text.secondary,
      ".gf-form-select-wrapper::after": {
        color: theme.colors.text.secondary
      },
      "a, .gf-form-input": {
        color: theme.colors.text.secondary
      }
    },
    ".gf-form-group": {
      marginBottom: theme.spacing(5)
    },
    ".gf-form-inline": {
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      alignContent: "flex-start",
      "&--nowrap": {
        flexWrap: "nowrap"
      },
      "&--xs-view-flex-column": {
        flexDirection: "row",
        flexWrap: "nowrap",
        [theme.breakpoints.down("sm")]: {
          flexDirection: "column"
        }
      },
      ".select-container": {
        marginRight: theme.spacing(0.5)
      },
      ".gf-form-spacing": {
        marginRight: theme.spacing(0.5)
      }
    },
    ".gf-form-button-row": {
      paddingTop: theme.spacing(3),
      "a, button": {
        marginRight: theme.spacing(2)
      }
    },
    ".gf-form-label": {
      display: "flex",
      alignItems: "center",
      padding: theme.spacing(0, 1),
      flexShrink: 0,
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      backgroundColor: theme.colors.background.secondary,
      height: "32px",
      lineHeight: "32px",
      marginRight: theme.spacing(0.5),
      borderRadius: theme.shape.radius.default,
      justifyContent: "space-between",
      border: "none",
      "&--grow": {
        flexGrow: 1
      },
      "&--transparent": {
        backgroundColor: "transparent",
        border: 0,
        textAlign: "right",
        paddingLeft: 0
      },
      "&--variable": {
        color: theme.colors.primary.text,
        background: theme.components.panel.background,
        border: `1px solid ${theme.components.panel.borderColor}`
      },
      "&--btn": {
        border: "none",
        borderRadius: theme.shape.radius.default,
        "&:hover": {
          background: theme.colors.background.secondary,
          color: theme.colors.text.primary
        }
      },
      "&:disabled": {
        color: theme.colors.text.secondary
      }
    },
    ".gf-form-label + .gf-form-label": {
      marginRight: theme.spacing(0.5)
    },
    ".gf-form-pre": {
      display: "block !important",
      flexGrow: 1,
      margin: 0,
      marginRight: theme.spacing(0.5),
      border: `1px solid transparent`,
      borderLeft: "none",
      borderRadius: theme.shape.radius.default
    },
    ".gf-form-textarea": {
      maxWidth: "650px"
    },
    ".gf-form-input": {
      display: "block",
      width: "100%",
      height: "32px",
      padding: theme.spacing(0, 1),
      fontSize: theme.typography.size.md,
      lineHeight: "18px",
      color: theme.components.input.text,
      backgroundColor: theme.components.input.background,
      backgroundImage: "none",
      backgroundClip: "padding-box",
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      marginRight: theme.spacing(0.5),
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      // text areas should be scrollable
      "&textarea": {
        overflow: "auto",
        whiteSpace: "pre-wrap",
        padding: `6px ${theme.spacing(1)}`,
        minHeight: "32px",
        height: "auto"
      },
      // Unstyle the caret on `<select>`s in IE10+.
      "&::-ms-expand": {
        backgroundColor: "transparent",
        border: 0,
        display: "none"
      },
      // Customize the `:focus` state to imitate native WebKit styles.
      "&:focus": {
        borderColor: theme.colors.primary.border,
        outline: "none"
      },
      // Placeholder
      "&::placeholder": {
        color: theme.colors.text.disabled,
        opacity: 1
      },
      "&:disabled, &[readonly]": {
        backgroundColor: theme.colors.action.disabledBackground,
        // iOS fix for unreadable disabled content; see https://github.com/twbs/bootstrap/issues/11655.
        opacity: 1
      },
      "&:disabled": {
        cursor: "not-allowed"
      },
      "&.gf-size-auto": {
        width: "auto"
      },
      "&--dropdown": {
        paddingRight: theme.spacing(3),
        position: "relative",
        display: "flex",
        alignItems: "center",
        "&::after": {
          position: "absolute",
          top: "36%",
          right: "11px",
          fontSize: "11px",
          backgroundColor: "transparent",
          color: theme.colors.text.primary,
          font: `normal normal normal ${theme.typography.size.sm}/1 FontAwesome`,
          content: '"\f0d7"',
          pointerEvents: "none"
        }
      },
      "&--has-help-icon": {
        paddingRight: theme.spacing(4)
      }
    },
    ".gf-form-select-wrapper": {
      position: "relative",
      backgroundColor: theme.components.input.background,
      marginRight: theme.spacing(0.5),
      ".gf-form-select-icon": {
        position: "absolute",
        zIndex: 1,
        top: "50%",
        marginTop: "-7px",
        "+ .gf-form-input": {
          position: "relative",
          zIndex: 2,
          paddingLeft: theme.spacing(4),
          backgroundColor: "transparent",
          option: {
            // Firefox
            color: theme.v1.palette.black
          }
        }
      },
      ".gf-form-input": {
        marginRight: 0,
        lineHeight: "32px"
      },
      "select.gf-form-input": {
        textIndent: "0.01px",
        textOverflow: "''",
        paddingRight: theme.spacing(4),
        appearance: "none",
        "&:-moz-focusring": {
          outline: "none",
          color: "transparent",
          textShadow: `0 0 0 ${theme.colors.text.primary}`
        },
        "&.ng-empty": {
          color: theme.colors.text.secondary
        }
      },
      "&::after": {
        position: "absolute",
        top: "36%",
        right: "11px",
        backgroundColor: "transparent",
        color: theme.colors.text.primary,
        font: `normal normal normal ${theme.typography.size.sm}/1 FontAwesome`,
        content: '"\f0d7"',
        pointerEvents: "none",
        fontSize: "11px"
      },
      "&--has-help-icon": {
        "&::after": {
          right: theme.spacing(4)
        }
      }
    },
    ".gf-form--v-stretch": {
      alignItems: "stretch"
    },
    ".gf-form-btn": {
      padding: theme.spacing(0, 1),
      marginRight: theme.spacing(0.5),
      lineHeight: "18px",
      fontSize: theme.typography.size.sm,
      flexShrink: 0,
      flexGrow: 0
    },
    ".gf-form-help-icon": {
      flexGrow: 0,
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.primary
      }
    },
    ".cta-form": {
      position: "relative",
      padding: theme.spacing(3),
      backgroundColor: theme.colors.background.secondary,
      marginBottom: theme.spacing(3),
      borderTop: `3px solid ${theme.colors.success.main}`
    },
    ".input-small": {
      width: "90px"
    }
  });
}

"use strict";
function getHacksStyles(hacks) {
  return react.css([]);
}

"use strict";
function getJsonFormatterStyles(theme) {
  return react.css({
    ".json-formatter-row": {
      fontFamily: "monospace",
      "&, a, a:hover": {
        color: theme.colors.text.primary,
        textDecoration: "none"
      },
      ".json-formatter-row": {
        marginLeft: theme.spacing(2)
      },
      ".json-formatter-children": {
        "&.json-formatter-empty": {
          opacity: 0.5,
          marginLeft: theme.spacing(2),
          "&::after": {
            display: "none"
          },
          "&.json-formatter-object::after": {
            content: "'No properties'"
          },
          "&.json-formatter-array::after": {
            content: "'[]'"
          }
        }
      },
      ".json-formatter-string": {
        color: theme.isDark ? "#23d662" : "green",
        whiteSpace: "pre-wrap",
        wordWrap: "break-word",
        wordBreak: "break-all"
      },
      ".json-formatter-number": {
        color: theme.isDark ? theme.colors.primary.text : theme.colors.primary.main
      },
      ".json-formatter-boolean": {
        color: theme.isDark ? theme.colors.primary.text : theme.colors.error.main
      },
      ".json-formatter-null": {
        color: theme.isDark ? "#eec97d" : "#855a00"
      },
      ".json-formatter-undefined": {
        color: theme.isDark ? "rgb(239, 143, 190)" : "rgb(202, 11, 105)"
      },
      ".json-formatter-function": {
        color: theme.isDark ? "#fd48cb" : "#ff20ed"
      },
      ".json-formatter-url": {
        textDecoration: "underline",
        color: theme.isDark ? "#027bff" : theme.colors.primary.main,
        cursor: "pointer"
      },
      ".json-formatter-bracket": {
        color: theme.isDark ? "#9494ff" : theme.colors.primary.main
      },
      ".json-formatter-key": {
        color: theme.isDark ? "#23a0db" : "#00008b",
        cursor: "pointer",
        paddingRight: theme.spacing(0.25),
        marginRight: theme.spacing(0.5)
      },
      ".json-formatter-constructor-name": {
        cursor: "pointer"
      },
      ".json-formatter-array-comma": {
        marginRight: theme.spacing(0.5)
      },
      ".json-formatter-toggler": {
        lineHeight: "16px",
        fontSize: theme.typography.size.xs,
        verticalAlign: "middle",
        opacity: 0.6,
        cursor: "pointer",
        paddingRight: theme.spacing(0.25),
        "&::after": {
          display: "inline-block",
          transition: "transform 100ms ease-in",
          content: "'\u25BA'"
        }
      },
      // Inline preview on hover (optional)
      "> a > .json-formatter-preview-text": {
        opacity: 0,
        transition: "opacity 0.15s ease-in",
        fontStyle: "italic"
      },
      "&:hover > a > .json-formatter-preview-text": {
        opacity: 0.6
      },
      // Open state
      "&.json-formatter-open": {
        "> .json-formatter-toggler-link .json-formatter-toggler::after": {
          transform: "rotate(90deg)"
        },
        "> .json-formatter-children::after": {
          display: "inline-block"
        },
        "> a > .json-formatter-preview-text": {
          display: "none"
        },
        "&.json-formatter-empty::after": {
          display: "block"
        }
      }
    }
  });
}

"use strict";
function getLegacySelectStyles(theme) {
  return react.css({
    ".gf-form-select-box__control": {
      width: "100%",
      marginRight: theme.spacing(0.5),
      backgroundColor: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      color: theme.components.input.text,
      cursor: "default",
      height: theme.spacing(4),
      outline: "none",
      overflow: "hidden",
      position: "relative"
    },
    ".gf-form-select-box__control--is-focused": {
      backgroundColor: theme.components.input.background,
      borderColor: theme.colors.primary.border,
      outline: "none",
      boxShadow: `inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px ${theme.colors.primary.border}`
    },
    ".gf-form-select-box__control--is-disabled": {
      backgroundColor: theme.colors.action.disabledBackground
    },
    ".gf-form-select-box__control--menu-right": {
      ".gf-form-select-box__menu": {
        right: 0,
        left: "unset"
      }
    },
    ".gf-form-select-box__input": {
      input: {
        lineHeight: "inherit"
      }
    },
    ".gf-form-select-box__menu": {
      background: theme.colors.background.primary,
      boxShadow: theme.shadows.z3,
      position: "absolute",
      zIndex: theme.zIndex.dropdown,
      minWidth: "100%",
      "&-notice--no-options": {
        backgroundColor: theme.components.input.background,
        padding: "10px"
      }
    },
    ".gf-form-select-box__menu-list": {
      overflowY: "auto",
      maxHeight: "300px",
      maxWidth: "600px"
    },
    ".tag-filter .gf-form-select-box__menu": {
      width: "100%"
    },
    ".gf-form-select-box__multi-value": {
      display: "inline",
      margin: "0 6px 0 0",
      cursor: "pointer"
    },
    ".gf-form-select-box__multi-value__remove": {
      textAlign: "center",
      display: "inline-block",
      marginLeft: "2px",
      position: "relative"
    },
    ".gf-form-select-box__multi-value__label": {
      display: "inline",
      verticalAlign: "middle"
    },
    ".gf-form-select-box__option": {
      borderLeft: "2px solid transparent",
      whiteSpace: "nowrap",
      backgroundColor: theme.components.input.background,
      "&.gf-form-select-box__option--is-focused": {
        color: theme.colors.text.primary,
        background: theme.colors.action.hover,
        borderImage: theme.colors.gradients.brandVertical,
        borderImageSlice: 1,
        borderStyle: "solid",
        borderTop: 0,
        borderRight: 0,
        borderBottom: 0,
        borderLeftWidth: "2px"
      },
      "&.gf-form-select-box__option--is-selected": {
        ".fa": {
          color: theme.colors.text.primary
        }
      }
    },
    ".gf-form-select-box__placeholder": {
      color: theme.colors.text.disabled
    },
    ".gf-form-select-box__control--is-focused .gf-form-select-box__placeholder": {
      display: "none"
    },
    ".gf-form-select-box__value-container": {
      display: "inline-block",
      padding: "6px 20px 6px 10px",
      verticalAlign: "middle",
      "> div": {
        display: "inline-block",
        verticalAlign: "middle"
      }
    },
    ".gf-form-select-box__indicators": {
      position: "absolute",
      height: "100%",
      right: "8px",
      top: "1px",
      display: "inline-block",
      textAlign: "right"
    },
    ".gf-form-input--form-dropdown": {
      padding: 0,
      border: 0,
      overflow: "visible",
      position: "relative"
    },
    ".gf-form--has-input-icon": {
      ".gf-form-select-box__value-container": {
        paddingLeft: "30px"
      }
    },
    ".gf-form-select-box__desc-option": {
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%"
    },
    ".gf-form-select-box__desc-option__body": {
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      paddingRight: "10px",
      fontWeight: theme.typography.fontWeightMedium
    },
    ".gf-form-select-box__desc-option__desc": {
      fontWeight: "normal",
      fontSize: theme.typography.bodySmall.fontSize,
      color: theme.colors.text.secondary
    },
    ".gf-form-select-box__desc-option__img": {
      width: "16px",
      marginRight: "10px"
    },
    ".gf-form-select-box__option-group__header": {
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.v1.palette.dark9}`,
      textTransform: "capitalize",
      ".fa": {
        paddingRight: "2px"
      }
    },
    ".gf-form-select-box-button-select": {
      height: "auto"
    },
    ".select-button": {
      display: "flex",
      alignItems: "center"
    }
  });
}

"use strict";
function getMarkdownStyles(theme) {
  return react.css({
    ".markdown-html": {
      img: {
        maxWidth: "100%"
      },
      "ul, ol": {
        paddingLeft: theme.spacing(3),
        marginBottom: theme.spacing(2)
      },
      table: {
        marginBottom: theme.spacing(2),
        "td, th": {
          padding: theme.spacing(0.5, 1)
        },
        th: {
          fontWeight: theme.typography.fontWeightMedium,
          background: theme.colors.background.secondary
        }
      },
      "table, th, td": {
        border: `1px solid ${theme.colors.border.medium}`,
        borderCollapse: "collapse"
      },
      a: {
        color: theme.colors.text.link,
        textDecoration: "none",
        "&:hover": {
          color: theme.colors.text.link,
          textDecoration: "underline"
        }
      },
      "p:last-child": {
        marginBottom: 0
      },
      "table:last-child, ul:last-child, ol:last-child": {
        marginBottom: 0
      }
    }
  });
}

"use strict";
function getPageStyles(theme) {
  const maxWidthBreakpoint = theme.breakpoints.values.xxl + theme.spacing.gridSize * 2 + theme.components.sidemenu.width;
  return react.css({
    ".grafana-app": {
      display: "flex",
      flexDirection: "column",
      height: "100vh"
    },
    ".main-view": {
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      position: "relative",
      minWidth: 0
    },
    ".page-scrollbar-content": {
      display: "flex",
      minHeight: "100%",
      flexDirection: "column",
      width: "100%",
      height: "100%"
    },
    ".page-container": {
      flexGrow: 1,
      flexBasis: "100%",
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2),
      [theme.breakpoints.up("sm")]: {
        margin: theme.spacing(0, 1)
      },
      [theme.breakpoints.up("md")]: {
        margin: theme.spacing(0, 2)
      },
      [`@media (min-width: ${maxWidthBreakpoint}px)`]: {
        maxWidth: `${theme.breakpoints.values.xxl}px`,
        marginLeft: "auto",
        marginRight: "auto",
        width: "100%"
      }
    },
    ".page-full": {
      marginLeft: theme.spacing(2),
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2)
    },
    ".page-body": {
      padding: theme.spacing(1),
      background: theme.components.panel.background,
      border: `1px solid ${theme.components.panel.borderColor}`,
      marginBottom: "32px",
      [theme.breakpoints.up("md")]: {
        padding: theme.spacing(2)
      },
      [theme.breakpoints.up("lg")]: {
        padding: theme.spacing(3)
      }
    },
    ".page-heading": {
      fontSize: theme.typography.h4.fontSize,
      marginTop: 0,
      marginBottom: theme.spacing(2)
    },
    ".page-action-bar": {
      marginBottom: theme.spacing(2),
      display: "flex",
      alignItems: "flex-start",
      gap: theme.spacing(2)
    },
    ".page-action-bar--narrow": {
      marginBottom: 0
    },
    ".page-action-bar__spacer": {
      width: theme.spacing(2),
      flexGrow: 1
    },
    ".page-sub-heading": {
      marginBottom: theme.spacing(2)
    },
    ".page-sub-heading-icon": {
      marginLeft: theme.spacing(1),
      marginTop: theme.spacing(0.5)
    },
    ".page-hidden": {
      display: "none"
    }
  });
}

"use strict";
function getQueryEditorStyles(theme) {
  return react.css({
    ".query-editor-row": {
      marginBottom: "2px",
      "&--disabled": {
        ".query-keyword": {
          color: theme.colors.text.secondary
        }
      }
    },
    ".query-keyword": {
      fontWeight: theme.typography.fontWeightMedium,
      color: `${theme.colors.primary.text} !important`
    },
    ".query-part": {
      backgroundColor: theme.colors.background.secondary,
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary, 0.03)
      }
    },
    ".query-segment-operator": {
      color: `${theme.v1.palette.orange} !important`
    },
    ".tight-form-func": {
      background: theme.colors.background.secondary
    },
    'input[type="text"].tight-form-func-param': {
      fontSize: theme.typography.bodySmall.fontSize,
      background: "transparent",
      border: "none",
      margin: 0,
      padding: 0
    },
    ".tight-form-func-controls": {
      textAlign: "center",
      ".fa-arrow-left": {
        float: "left",
        position: "relative",
        top: 2
      },
      ".fa-arrow-right": {
        float: "right",
        position: "relative",
        top: 2
      },
      ".fa-remove": {
        marginLeft: "10px"
      }
    }
  });
}

"use strict";
const getSkeletonStyles$3 = (theme) => {
  return react.css({
    ".react-loading-skeleton": skeletonAnimation
  });
};

"use strict";
function getSlateStyles(theme) {
  return react.css({
    ".slate-query-field": {
      fontSize: theme.typography.fontSize,
      fontFamily: theme.typography.fontFamilyMonospace,
      height: "auto",
      wordBreak: "break-word",
      // Affects only placeholder in query field. Adds scrollbar only if content is cropped.
      overflow: "auto"
    },
    ".slate-query-field__wrapper": {
      position: "relative",
      display: "inline-block",
      padding: "6px 8px",
      minHeight: "32px",
      width: "100%",
      color: theme.colors.text.primary,
      backgroundColor: theme.components.input.background,
      backgroundImage: "none",
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      transition: "all 0.3s",
      lineHeight: "18px"
    },
    ".slate-query-field__wrapper--disabled": {
      backgroundColor: "inherit",
      cursor: "not-allowed"
    },
    ".slate-typeahead": {
      ".typeahead": {
        position: "relative",
        zIndex: theme.zIndex.typeahead,
        borderRadius: theme.shape.radius.default,
        border: `1px solid ${theme.components.panel.borderColor}`,
        maxHeight: "66vh",
        overflowY: "scroll",
        overflowX: "hidden",
        outline: "none",
        listStyle: "none",
        background: theme.components.panel.background,
        color: theme.colors.text.primary,
        boxShadow: theme.shadows.z2
      },
      ".typeahead-group__title": {
        color: theme.colors.text.secondary,
        fontSize: theme.typography.size.sm,
        lineHeight: theme.typography.body.lineHeight,
        padding: theme.spacing(1)
      },
      ".typeahead-item": {
        height: "auto",
        fontFamily: theme.typography.fontFamilyMonospace,
        padding: theme.spacing(1, 1, 1, 2),
        fontSize: theme.typography.size.sm,
        textOverflow: "ellipsis",
        overflow: "hidden",
        zIndex: 1,
        display: "block",
        whiteSpace: "nowrap",
        cursor: "pointer",
        transition: "color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), border-color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), background 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), padding 0.15s cubic-bezier(0.645, 0.045, 0.355, 1)"
      },
      ".typeahead-item__selected": {
        backgroundColor: theme.isDark ? theme.v1.palette.dark9 : theme.v1.palette.gray6,
        ".typeahead-item-hint": {
          fontSize: theme.typography.size.xs,
          color: theme.colors.text.primary,
          whiteSpace: "normal"
        }
      },
      ".typeahead-match": {
        color: theme.v1.palette.yellow,
        borderBottom: `1px solid ${theme.v1.palette.yellow}`,
        // Undoing mark styling
        padding: "inherit",
        background: "inherit"
      }
    },
    /* SYNTAX */
    ".slate-query-field, .prism-syntax-highlight": {
      ".token.comment, .token.block-comment, .token.prolog, .token.doctype, .token.cdata": {
        color: theme.colors.text.secondary
      },
      ".token.variable, .token.entity": {
        color: theme.colors.text.primary
      },
      ".token.property, .token.tag, .token.constant, .token.symbol, .token.deleted": {
        color: theme.colors.error.text
      },
      ".token.attr-value, .token.selector, .token.string, .token.char, .token.builtin, .token.inserted": {
        color: theme.colors.success.text
      },
      ".token.boolean, .token.number, .token.operator, .token.url": {
        color: "#fe85fc"
      },
      ".token.function, .token.attr-name, .token.function-name, .token.atrule, .token.keyword, .token.class-name": {
        color: theme.colors.primary.text
      },
      ".token.punctuation, .token.regex, .token.important": {
        color: theme.v1.palette.orange
      },
      ".token.important": {
        fontWeight: "normal"
      },
      ".token.bold": {
        fontWeight: "bold"
      },
      ".token.italic": {
        fontStyle: "italic"
      },
      ".token.entity": {
        cursor: "help"
      },
      ".namespace": {
        opacity: 0.7
      }
    }
  });
}

"use strict";
function getUplotStyles(theme) {
  return react.css({
    ".uplot": {
      fontFamily: "inherit"
    },
    ".u-select": {
      background: "rgba(120, 120, 130, 0.2)"
    },
    ".u-hz .u-cursor-x, .u-vt .u-cursor-y": {
      borderRight: "1px dashed rgba(120, 120, 130, 0.5)"
    },
    ".u-hz .u-cursor-y, .u-vt .u-cursor-x": {
      borderBottom: "1px dashed rgba(120, 120, 130, 0.5)"
    },
    ".shared-crosshair:not(.plot-active) .u-cursor-pt": {
      display: "none !important"
    }
  });
}

"use strict";
function buttonBackgroundMixin(startColor, endColor, textColor = "#fff", textShadow = "0px 1px 0 rgba(0, 0, 0, 0.1)") {
  return {
    backgroundColor: startColor,
    backgroundImage: `linear-gradient(to bottom, ${startColor}, ${endColor})`,
    backgroundRepeat: "repeat-x",
    color: textColor,
    textShadow,
    borderColor: startColor,
    // in these cases the gradient won't cover the background, so we override
    "&:hover, &:focus, &:active, &.active, &.disabled, &[disabled]": {
      color: textColor,
      backgroundImage: "none",
      backgroundColor: startColor
    }
  };
}
function buttonSizeMixin(paddingY, paddingX, fontSize, borderRadius) {
  return {
    padding: `${paddingY} ${paddingX}`,
    fontSize,
    borderRadius
  };
}
function widthMixin(theme, max) {
  let result = {};
  for (let i = 1; i <= max; i++) {
    const width = `${theme.spacing(2 * i)} !important`;
    result[`.width-${i}`] = {
      width
    };
    result[`.max-width-${i}`] = {
      maxWidth: width,
      flexGrow: 1
    };
    result[`.min-width-${i}`] = {
      minWidth: width
    };
    result[`.offset-width-${i}`] = {
      marginLeft: width
    };
  }
  return result;
}
function getUtilityClassStyles(theme) {
  return react.css({
    ".highlight-word": {
      color: theme.v1.palette.orange
    },
    ".hide": {
      display: "none"
    },
    ".show": {
      display: "block"
    },
    ".invisible": {
      // can't avoid type assertion here due to !important
      // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
      visibility: "hidden !important"
    },
    ".absolute": {
      position: "absolute"
    },
    ".flex-grow-1": {
      flexGrow: 1
    },
    ".flex-shrink-1": {
      flexShrink: 1
    },
    ".flex-shrink-0": {
      flexShrink: 0
    },
    ".center-vh": {
      height: "100%",
      display: "flex",
      flexDirection: "column",
      alignItems: "center",
      justifyContent: "center",
      justifyItems: "center"
    },
    ".btn": {
      display: "inline-flex",
      alignItems: "center",
      justifyContent: "center",
      fontWeight: theme.typography.fontWeightMedium,
      lineHeight: theme.typography.body.lineHeight,
      textAlign: "center",
      verticalAlign: "middle",
      cursor: "pointer",
      border: "none",
      height: `${theme.spacing.gridSize * theme.components.height.md}px`,
      ...buttonSizeMixin(
        theme.spacing(0),
        theme.spacing(2),
        `${theme.typography.fontSize}px`,
        theme.shape.radius.default
      ),
      "&, &:active, &.active": {
        "&:focus, &.focus": {
          outline: "none"
        }
      },
      "&:focus, &:hover": {
        textDecoration: "none"
      },
      "&.focus": {
        textDecoration: "none"
      },
      "&:active, &.active": {
        backgroundImage: "none",
        outline: 0
      },
      "&.disabled, &[disabled], &:disabled": {
        cursor: "not-allowed",
        opacity: 0.65,
        boxShadow: "none",
        pointerEvents: "none"
      }
    },
    ".btn-small": {
      ...buttonSizeMixin(theme.spacing(0.5), theme.spacing(1), theme.typography.size.sm, theme.shape.radius.default),
      height: `${theme.spacing.gridSize * theme.components.height.sm}px`
    },
    // Deprecated, only used by old plugins
    ".btn-mini": {
      ...buttonSizeMixin(theme.spacing(0.5), theme.spacing(1), theme.typography.size.sm, theme.shape.radius.default),
      height: `${theme.spacing.gridSize * theme.components.height.sm}px`
    },
    ".btn-success, .btn-primary": {
      ...buttonBackgroundMixin(theme.colors.primary.main, theme.colors.primary.shade)
    },
    ".btn-danger": {
      ...buttonBackgroundMixin(theme.colors.error.main, theme.colors.error.shade)
    },
    ".btn-secondary": {
      ...buttonBackgroundMixin(theme.colors.secondary.main, theme.colors.secondary.shade, theme.colors.text.primary)
    },
    ".btn-inverse": {
      ...buttonBackgroundMixin(
        theme.isDark ? theme.v1.palette.dark6 : theme.v1.palette.gray5,
        theme.isDark ? theme.v1.palette.dark5 : theme.v1.palette.gray4,
        theme.colors.text.primary
      ),
      "&": {
        boxShadow: "none"
      }
    },
    ".typeahead": {
      zIndex: theme.zIndex.typeahead
    },
    ...widthMixin(theme, 30),
    ".row": {
      display: "flex",
      flexWrap: "wrap",
      marginLeft: `calc(${theme.spacing(4)} / -2)`,
      marginRight: `calc(${theme.spacing(4)} / -2)`
    },
    ".container": {
      marginLeft: "auto",
      marginRight: "auto",
      paddingLeft: `calc(${theme.spacing(4)} / 2)`,
      paddingRight: `calc(${theme.spacing(4)} / 2)`,
      [theme.breakpoints.up("sm")]: {
        maxWidth: theme.breakpoints.values.sm
      },
      [theme.breakpoints.up("md")]: {
        maxWidth: theme.breakpoints.values.md
      },
      [theme.breakpoints.up("lg")]: {
        maxWidth: theme.breakpoints.values.lg
      },
      [theme.breakpoints.up("xl")]: {
        maxWidth: theme.breakpoints.values.xl
      }
    }
  });
}

"use strict";
function GlobalStyles(props) {
  const theme = useTheme2();
  const { isExtensionSidebarOpen } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(
    react.Global,
    {
      styles: [
        getAccessibilityStyles(theme),
        getAlertingStyles(theme),
        getCodeStyles(theme),
        getDashDiffStyles(theme),
        getDashboardGridStyles(theme),
        getElementStyles(theme, isExtensionSidebarOpen),
        getExtraStyles(theme),
        getFilterTableStyles(theme),
        getFontStyles(theme),
        getFormElementStyles(theme),
        getJsonFormatterStyles(theme),
        getCardStyles$1(theme),
        getMarkdownStyles(theme),
        getPageStyles(theme),
        getQueryEditorStyles(theme),
        getSkeletonStyles$3(theme),
        getSlateStyles(theme),
        getUplotStyles(theme),
        getUtilityClassStyles(theme),
        getLegacySelectStyles(theme),
        getHacksStyles({})
      ]
    }
  );
}

"use strict";

"use strict";
function initI18n() {
  if (typeof i18next__default.default.options.resources !== "object") {
    i18next__default.default.use(reactI18next.initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ jsxRuntime.jsx(reactI18next.Trans, { ...props });
};
const tFunc = i18next__default.default.t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

"use strict";
function breakpointCSS(theme, prop, getCSS, key) {
  const value = prop[key];
  if (value !== void 0 && value !== null) {
    return {
      [theme.breakpoints.up(key)]: getCSS(value)
    };
  }
  return;
}
function getResponsiveStyle(theme, prop, getCSS) {
  if (prop === void 0 || prop === null) {
    return null;
  }
  if (typeof prop !== "object" || !("xs" in prop)) {
    return getCSS(prop);
  }
  return [
    breakpointCSS(theme, prop, getCSS, "xs"),
    breakpointCSS(theme, prop, getCSS, "sm"),
    breakpointCSS(theme, prop, getCSS, "md"),
    breakpointCSS(theme, prop, getCSS, "lg"),
    breakpointCSS(theme, prop, getCSS, "xl"),
    breakpointCSS(theme, prop, getCSS, "xxl")
  ];
}

"use strict";
const getSizeStyles = (theme, width, minWidth, maxWidth, height, minHeight, maxHeight) => {
  return css.css([
    getResponsiveStyle(theme, width, (val) => ({
      width: theme.spacing(val)
    })),
    getResponsiveStyle(theme, minWidth, (val) => ({
      minWidth: theme.spacing(val)
    })),
    getResponsiveStyle(theme, maxWidth, (val) => ({
      maxWidth: theme.spacing(val)
    })),
    getResponsiveStyle(theme, height, (val) => ({
      height: theme.spacing(val)
    })),
    getResponsiveStyle(theme, minHeight, (val) => ({
      minHeight: theme.spacing(val)
    })),
    getResponsiveStyle(theme, maxHeight, (val) => ({
      maxHeight: theme.spacing(val)
    }))
  ]);
};

"use strict";
const Box = React.forwardRef((props, ref) => {
  const {
    children,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    element,
    gap,
    width,
    minWidth,
    maxWidth,
    height,
    minHeight,
    maxHeight,
    position,
    ...rest
  } = props;
  const styles = useStyles2(
    getStyles$2s,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    gap,
    position
  );
  const sizeStyles = useStyles2(getSizeStyles, width, minWidth, maxWidth, height, minHeight, maxHeight);
  const Element = element != null ? element : "div";
  return /* @__PURE__ */ jsxRuntime.jsx(Element, { ref, className: css.cx(styles.root, sizeStyles), ...rest, children });
});
Box.displayName = "Box";
const customBorderColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].borderTransparent;
    default:
      return color ? theme.colors.border[color] : void 0;
  }
};
const customBackgroundColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].transparent;
    default:
      return color ? theme.colors.background[color] : void 0;
  }
};
const getStyles$2s = (theme, margin, marginX, marginY, marginTop, marginBottom, marginLeft, marginRight, padding, paddingX, paddingY, paddingTop, paddingBottom, paddingLeft, paddingRight, display, backgroundColor, grow, shrink, basis, flex, borderColor, borderStyle, borderRadius, direction, justifyContent, alignItems, boxShadow, gap, position) => {
  return {
    root: css.css([
      getResponsiveStyle(theme, margin, (val) => ({
        margin: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginX, (val) => ({
        marginLeft: theme.spacing(val),
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginY, (val) => ({
        marginTop: theme.spacing(val),
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginTop, (val) => ({
        marginTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginBottom, (val) => ({
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginLeft, (val) => ({
        marginLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginRight, (val) => ({
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, padding, (val) => ({
        padding: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingX, (val) => ({
        paddingLeft: theme.spacing(val),
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingY, (val) => ({
        paddingTop: theme.spacing(val),
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingTop, (val) => ({
        paddingTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingBottom, (val) => ({
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingLeft, (val) => ({
        paddingLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingRight, (val) => ({
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, display, (val) => ({
        display: val
      })),
      getResponsiveStyle(theme, backgroundColor, (val) => ({
        backgroundColor: customBackgroundColor(val, theme)
      })),
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      })),
      getResponsiveStyle(theme, borderStyle, (val) => ({
        borderStyle: val
      })),
      getResponsiveStyle(theme, borderColor, (val) => ({
        borderColor: customBorderColor(val, theme)
      })),
      (borderStyle || borderColor) && {
        borderWidth: "1px"
      },
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, borderRadius, (val) => ({
        borderRadius: theme.shape.radius[val]
      })),
      getResponsiveStyle(theme, boxShadow, (val) => ({
        boxShadow: theme.shadows[val]
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, position, (val) => ({
        position: val
      }))
    ])
  };
};

"use strict";
function MenuDivider() {
  const styles = useStyles2(getStyles$2r);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.divider });
}
const getStyles$2r = (theme) => {
  return {
    divider: css.css({
      height: 1,
      backgroundColor: theme.colors.border.weak,
      margin: theme.spacing(0.5, 0)
    })
  };
};

"use strict";
const MenuGroup = ({ label, ariaLabel, children }) => {
  const styles = useStyles2(getStyles$2q);
  const labelID = `group-label-${lodash.uniqueId()}`;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { role: "group", "aria-labelledby": !ariaLabel && label ? labelID : void 0, "aria-label": ariaLabel, children: [
    label && /* @__PURE__ */ jsxRuntime.jsx("label", { id: labelID, className: styles.groupLabel, "aria-hidden": true, children: label }),
    children
  ] });
};
MenuGroup.displayName = "MenuGroup";
const getStyles$2q = (theme) => {
  return {
    groupLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      padding: theme.spacing(0.5, 1)
    })
  };
};

"use strict";
const spin$1 = css.keyframes({
  "0%": {
    transform: "rotate(0deg)"
  },
  "100%": {
    transform: "rotate(359deg)"
  }
});

"use strict";
const alwaysMonoIcons = [
  "grafana",
  "favorite",
  "heart-break",
  "heart",
  "panel-add",
  "library-panel",
  "circle-mono"
];
function getIconSubDir(name, type) {
  if (name == null ? void 0 : name.startsWith("gf-")) {
    return "custom";
  } else if (alwaysMonoIcons.includes(name)) {
    return "mono";
  } else if (type === "default") {
    return "unicons";
  } else if (type === "solid") {
    return "solid";
  } else {
    return "mono";
  }
}
function getSvgSize(size) {
  switch (size) {
    case "xs":
      return 12;
    case "sm":
      return 14;
    case "md":
      return 16;
    case "lg":
      return 18;
    case "xl":
      return 24;
    case "xxl":
      return 36;
    case "xxxl":
      return 48;
  }
}
let iconRoot;
function getIconRoot() {
  if (iconRoot) {
    return iconRoot;
  }
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  if (grafanaPublicPath) {
    iconRoot = grafanaPublicPath + "img/icons/";
  } else {
    iconRoot = "public/img/icons/";
  }
  return iconRoot;
}

"use strict";
const getIconStyles = (theme) => {
  return {
    icon: css.css({
      display: "inline-block",
      fill: "currentColor",
      flexShrink: 0,
      label: "Icon",
      // line-height: 0; is needed for correct icon alignment in Safari
      lineHeight: 0,
      verticalAlign: "middle"
    }),
    orange: css.css({
      fill: theme.v1.palette.orange
    }),
    spin: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${spin$1} 2s infinite linear`
      }
    })
  };
};
const Icon = React__namespace.forwardRef(
  ({ size = "md", type = "default", name, className, style, title = "", ...rest }, ref) => {
    const styles = useStyles2(getIconStyles);
    if (!data.isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    const iconName = name === "fa fa-spinner" ? "spinner" : name;
    const iconRoot = getIconRoot();
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(iconName, type);
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    const composedClassName = css.cx(
      styles.icon,
      className,
      type === "mono" ? { [styles.orange]: name === "favorite" } : "",
      {
        [styles.spin]: iconName === "spinner"
      }
    );
    return /* @__PURE__ */ jsxRuntime.jsx(
      SVG__default.default,
      {
        "aria-hidden": rest.tabIndex === void 0 && !title && !rest["aria-label"] && !rest["aria-labelledby"] && !rest["aria-describedby"],
        innerRef: ref,
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: composedClassName,
        style,
        loader: /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            className: css.cx(
              css.css({
                width: svgWid,
                height: svgHgt
              }),
              composedClassName
            )
          }
        ),
        ...rest
      }
    );
  }
);
Icon.displayName = "Icon";

"use strict";
const Stack = React__namespace.forwardRef((props, ref) => {
  const {
    gap = 1,
    rowGap,
    columnGap,
    alignItems,
    justifyContent,
    direction,
    wrap,
    children,
    grow,
    shrink,
    basis,
    flex,
    width,
    minWidth,
    maxWidth,
    height,
    minHeight,
    maxHeight,
    ...rest
  } = props;
  const styles = useStyles2(
    getStyles$2p,
    gap,
    rowGap,
    columnGap,
    alignItems,
    justifyContent,
    direction,
    wrap,
    grow,
    shrink,
    basis,
    flex
  );
  const sizeStyles = useStyles2(getSizeStyles, width, minWidth, maxWidth, height, minHeight, maxHeight);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx(styles.flex, sizeStyles), ...rest, children });
});
Stack.displayName = "Stack";
const getStyles$2p = (theme, gap, rowGap, columnGap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex) => {
  return {
    flex: css.css([
      {
        display: "flex"
      },
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, wrap, (val) => ({
        flexWrap: typeof val === "boolean" ? val ? "wrap" : "nowrap" : val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, rowGap, (val) => ({
        rowGap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, columnGap, (val) => ({
        columnGap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      }))
    ])
  };
};

"use strict";
const modulo$3 = (a, n) => (a % n + n) % n;
const UNFOCUSED = -1;
const useMenuFocus = ({
  localRef,
  isMenuOpen,
  close,
  onOpen,
  onClose,
  onKeyDown
}) => {
  const [focusedItem, setFocusedItem] = React.useState(UNFOCUSED);
  React.useEffect(() => {
    if (isMenuOpen) {
      setFocusedItem(0);
    }
  }, [isMenuOpen]);
  React.useEffect(() => {
    var _a, _b;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    (_b = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _b.focus();
    menuItems == null ? void 0 : menuItems.forEach((menuItem, i) => {
      menuItem.tabIndex = i === focusedItem ? 0 : -1;
    });
  }, [localRef, focusedItem]);
  reactUse.useEffectOnce(() => {
    onOpen == null ? void 0 : onOpen(setFocusedItem);
  });
  const handleKeys = (event) => {
    var _a, _b, _c;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    const menuItemsCount = (_b = menuItems == null ? void 0 : menuItems.length) != null ? _b : 0;
    switch (event.key) {
      case "ArrowUp":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$3(focusedItem - 1, menuItemsCount));
        break;
      case "ArrowDown":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$3(focusedItem + 1, menuItemsCount));
        break;
      case "ArrowLeft":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(UNFOCUSED);
        close == null ? void 0 : close();
        break;
      case "Home":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(0);
        break;
      case "End":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(menuItemsCount - 1);
        break;
      case "Enter":
        event.preventDefault();
        event.stopPropagation();
        (_c = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _c.click();
        break;
      case "Escape":
        onClose == null ? void 0 : onClose();
        break;
      case "Tab":
        event.preventDefault();
        onClose == null ? void 0 : onClose();
        break;
      default:
        break;
    }
    onKeyDown == null ? void 0 : onKeyDown(event);
  };
  return [handleKeys];
};

"use strict";
const isElementOverflowing = (element) => {
  if (!element) {
    return false;
  }
  const wrapperPos = element.parentElement.getBoundingClientRect();
  const pos = element.getBoundingClientRect();
  return pos.width !== 0 && wrapperPos.right + pos.width + 10 > window.innerWidth;
};

"use strict";
const SubMenu = React.memo(({ items, isOpen, close, customStyle }) => {
  const styles = useStyles2(getStyles$2o);
  const localRef = React.useRef(null);
  const [handleKeys] = useMenuFocus({
    localRef,
    isMenuOpen: isOpen,
    close
  });
  const [pushLeft, setPushLeft] = React.useState(false);
  React.useEffect(() => {
    if (isOpen && localRef.current) {
      setPushLeft(isElementOverflowing(localRef.current));
    }
  }, [isOpen]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.iconWrapper, "aria-hidden": true, "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.icon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right", className: styles.icon }) }),
    isOpen && /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        ref: localRef,
        className: css.cx(styles.subMenu, { [styles.pushLeft]: pushLeft }),
        "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.container,
        style: customStyle,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { tabIndex: -1, className: styles.itemsWrapper, role: "menu", onKeyDown: handleKeys, children: items })
      }
    )
  ] });
});
SubMenu.displayName = "SubMenu";
const getStyles$2o = (theme) => {
  return {
    iconWrapper: css.css({
      display: "flex",
      flex: 1,
      justifyContent: "end"
    }),
    icon: css.css({
      opacity: 0.7,
      marginLeft: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    itemsWrapper: css.css({
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      boxShadow: theme.shadows.z3,
      display: "inline-block",
      borderRadius: theme.shape.radius.default
    }),
    pushLeft: css.css({
      right: "100%",
      left: "unset"
    }),
    subMenu: css.css({
      position: "absolute",
      top: 0,
      left: "100%",
      zIndex: theme.zIndex.dropdown
    })
  };
};

"use strict";
const MenuItem = React__namespace.memo(
  React__namespace.forwardRef((props, ref) => {
    const {
      url,
      icon,
      label,
      description,
      ariaLabel,
      ariaChecked,
      target,
      onClick,
      className,
      active,
      disabled,
      destructive,
      childItems,
      role,
      tabIndex = -1,
      customSubMenuContainerStyles,
      shortcut,
      testId
    } = props;
    const styles = useStyles2(getStyles$2n);
    const [isActive, setIsActive] = React.useState(active);
    const [isSubMenuOpen, setIsSubMenuOpen] = React.useState(false);
    const onMouseEnter = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(true);
      setIsActive(true);
    }, [disabled]);
    const onMouseLeave = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(false);
      setIsActive(false);
    }, [disabled]);
    const hasSubMenu = childItems && childItems.length > 0;
    const ItemElement = hasSubMenu ? "div" : url === void 0 ? "button" : "a";
    const itemStyle = css.cx(
      {
        [styles.item]: true,
        [styles.active]: isActive,
        [styles.disabled]: disabled,
        [styles.destructive]: destructive && !disabled
      },
      className
    );
    const disabledProps = {
      [ItemElement === "button" ? "disabled" : "aria-disabled"]: disabled,
      ...ItemElement === "a" && disabled && { href: void 0, onClick: void 0 },
      ...disabled && {
        tabIndex: -1,
        ["data-disabled"]: disabled
        // used to identify disabled items in Menu.tsx
      }
    };
    const localRef = React.useRef(null);
    React.useImperativeHandle(ref, () => localRef.current);
    const handleKeys = (event) => {
      switch (event.key) {
        case "ArrowRight":
          event.preventDefault();
          event.stopPropagation();
          if (hasSubMenu) {
            setIsSubMenuOpen(true);
            setIsActive(true);
          }
          break;
        default:
          break;
      }
    };
    const closeSubMenu = () => {
      var _a;
      setIsSubMenuOpen(false);
      setIsActive(false);
      (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.focus();
    };
    const hasShortcut = Boolean(shortcut && shortcut.length > 0);
    return /* @__PURE__ */ jsxRuntime.jsxs(
      ItemElement,
      {
        target,
        className: itemStyle,
        rel: target === "_blank" ? "noopener noreferrer" : void 0,
        href: url,
        onClick: (event) => {
          if (hasSubMenu && !isSubMenuOpen) {
            event.preventDefault();
            event.stopPropagation();
          }
          onClick == null ? void 0 : onClick(event);
        },
        onMouseEnter,
        onMouseLeave,
        onKeyDown: handleKeys,
        role: !url ? role || "menuitem" : role,
        "data-role": "menuitem",
        ref: localRef,
        "data-testid": testId,
        "aria-label": ariaLabel,
        "aria-checked": ariaChecked,
        tabIndex,
        ...disabledProps,
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "row", justifyContent: "flex-start", alignItems: "center", children: [
            icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, className: styles.icon, "aria-hidden": true }),
            /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.ellipsis, children: label }),
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.rightWrapper, { [styles.withShortcut]: hasShortcut }), children: [
              hasShortcut && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.shortcut, children: [
                /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "keyboard", title: t("grafana-ui.menu-item.keyboard-shortcut-label", "Keyboard shortcut") }),
                shortcut
              ] }),
              hasSubMenu && /* @__PURE__ */ jsxRuntime.jsx(
                SubMenu,
                {
                  items: childItems,
                  isOpen: isSubMenuOpen,
                  close: closeSubMenu,
                  customStyle: customSubMenuContainerStyles
                }
              )
            ] })
          ] }),
          description && /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: css.cx(styles.description, styles.ellipsis, {
                [styles.descriptionWithIcon]: icon !== void 0
              }),
              children: description
            }
          ),
          props.component ? /* @__PURE__ */ jsxRuntime.jsx(props.component, {}) : null
        ]
      }
    );
  })
);
MenuItem.displayName = "MenuItem";
const getStyles$2n = (theme) => {
  return {
    item: css.css({
      background: "none",
      cursor: "pointer",
      whiteSpace: "nowrap",
      color: theme.colors.text.primary,
      display: "flex",
      flexDirection: "column",
      alignItems: "stretch",
      justifyContent: "center",
      padding: theme.spacing(0.5, 1.5),
      minHeight: theme.spacing(4),
      borderRadius: theme.shape.radius.default,
      margin: 0,
      border: "none",
      width: "100%",
      position: "relative",
      "&:hover, &:focus-visible": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary,
        textDecoration: "none"
      },
      "&:focus-visible": getFocusStyles(theme)
    }),
    active: css.css({
      background: theme.colors.action.hover
    }),
    destructive: css.css({
      color: theme.colors.error.text,
      svg: {
        color: theme.colors.error.text
      },
      "&:hover, &:focus, &:focus-visible": {
        background: theme.colors.error.main,
        color: theme.colors.error.contrastText,
        svg: {
          color: theme.colors.error.contrastText
        }
      }
    }),
    disabled: css.css({
      color: theme.colors.action.disabledText,
      label: "menu-item-disabled",
      "&:hover, &:focus, &:focus-visible": {
        cursor: "not-allowed",
        background: "none",
        color: theme.colors.action.disabledText
      }
    }),
    icon: css.css({
      opacity: 0.7,
      color: theme.colors.text.secondary
    }),
    rightWrapper: css.css({
      display: "flex",
      alignItems: "center",
      marginLeft: "auto"
    }),
    withShortcut: css.css({
      minWidth: theme.spacing(10.5)
    }),
    shortcut: css.css({
      display: "flex",
      alignItems: "center",
      gap: theme.spacing(1),
      marginLeft: theme.spacing(2),
      color: theme.colors.text.secondary,
      opacity: 0.7
    }),
    description: css.css({
      ...theme.typography.bodySmall,
      color: theme.colors.text.secondary,
      textAlign: "start"
    }),
    descriptionWithIcon: css.css({
      marginLeft: theme.spacing(3)
    }),
    ellipsis: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    })
  };
};

"use strict";
const MenuComp = React__namespace.forwardRef(
  ({ header, children, ariaLabel, onOpen, onClose, onKeyDown, ...otherProps }, forwardedRef) => {
    const styles = useStyles2(getStyles$2m);
    const localRef = React.useRef(null);
    React.useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ isMenuOpen: true, localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ jsxRuntime.jsxs(
      Box,
      {
        ...otherProps,
        "aria-label": ariaLabel,
        backgroundColor: "elevated",
        borderRadius: "default",
        boxShadow: "z3",
        display: "inline-block",
        onKeyDown: handleKeys,
        paddingX: 0.5,
        paddingY: 0.5,
        ref: localRef,
        role: "menu",
        tabIndex: -1,
        children: [
          header && /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: css.cx(
                styles.header,
                Boolean(children) && React__namespace.Children.toArray(children).length > 0 && styles.headerBorder
              ),
              children: header
            }
          ),
          children
        ]
      }
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles$2m = (theme) => {
  return {
    header: css.css({
      padding: theme.spacing(0.5, 0.5, 1, 0.5)
    }),
    headerBorder: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      marginBottom: theme.spacing(0.5)
    })
  };
};

"use strict";
function Portal$1(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = React.useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  React.useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM__default.default.createPortal(/* @__PURE__ */ jsxRuntime.jsx("div", { ref: forwardedRef, children }), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
function PortalContainer() {
  const styles = useStyles2(getStyles$2l);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      id: "grafana-portal-container",
      "data-testid": e2eSelectors.selectors.components.Portal.container,
      className: styles.grafanaPortalContainer
    }
  );
}
const getStyles$2l = (theme) => {
  return {
    grafanaPortalContainer: css.css({
      position: "fixed",
      top: 0,
      width: "100%",
      zIndex: theme.zIndex.portal
    })
  };
};
const RefForwardingPortal = React__namespace.forwardRef((props, ref) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { ...props, forwardedRef: ref });
});
RefForwardingPortal.displayName = "RefForwardingPortal";

"use strict";
const ContextMenu = React__namespace.memo(
  ({ x, y, onClose, focusOnOpen = true, renderMenuItems, renderHeader }) => {
    const menuRef = React.useRef(null);
    const [positionStyles, setPositionStyles] = React.useState({});
    React.useLayoutEffect(() => {
      const menuElement = menuRef.current;
      if (menuElement) {
        const rect = menuElement.getBoundingClientRect();
        const OFFSET = 5;
        const collisions = {
          right: window.innerWidth < x + rect.width,
          bottom: window.innerHeight < y + rect.height + OFFSET
        };
        setPositionStyles({
          position: "fixed",
          left: collisions.right ? x - rect.width - OFFSET : x - OFFSET,
          top: Math.max(0, collisions.bottom ? y - rect.height - OFFSET : y + OFFSET)
        });
      }
    }, [x, y]);
    reactUse.useClickAway(menuRef, () => {
      onClose == null ? void 0 : onClose();
    });
    const header = renderHeader == null ? void 0 : renderHeader();
    const menuItems = renderMenuItems == null ? void 0 : renderMenuItems();
    const onOpen = (setFocusedItem) => {
      if (focusOnOpen) {
        setFocusedItem(0);
      }
    };
    const onKeyDown = (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        onClose == null ? void 0 : onClose();
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(
      Menu,
      {
        header,
        ref: menuRef,
        style: positionStyles,
        ariaLabel: e2eSelectors.selectors.components.Menu.MenuComponent("Context"),
        onOpen,
        onClick: onClose,
        onKeyDown,
        children: menuItems
      }
    ) });
  }
);
ContextMenu.displayName = "ContextMenu";

"use strict";
const getFocusStyle = (theme) => css.css({
  "&:focus": getFocusStyles(theme)
});
const sharedInputStyle = (theme, invalid = false) => {
  const borderColor = invalid ? theme.colors.error.border : theme.components.input.borderColor;
  const borderColorHover = invalid ? theme.colors.error.shade : theme.components.input.borderHover;
  const background = theme.components.input.background;
  const textColor = theme.components.input.text;
  const autoFillBorder = theme.isDark ? "#2e2f35" : "#bab4ca";
  return css.cx(
    inputPadding(theme),
    css.css({
      background,
      lineHeight: theme.typography.body.lineHeight,
      fontSize: theme.typography.size.md,
      color: textColor,
      border: `1px solid ${borderColor}`,
      "&:-webkit-autofill, &:-webkit-autofill:hover": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`,
        borderColor: autoFillBorder
      },
      "&:-webkit-autofill:focus": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `0 0 0 2px ${theme.colors.background.primary}, 0 0 0px 4px ${theme.colors.primary.main}, inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`
      },
      "&:hover": {
        borderColor: borderColorHover
      },
      "&:focus": {
        outline: "none"
      },
      "&:disabled": {
        backgroundColor: theme.colors.action.disabledBackground,
        color: theme.colors.action.disabledText,
        border: `1px solid ${theme.colors.action.disabledBackground}`,
        "&:hover": {
          borderColor
        }
      },
      "&::placeholder": {
        color: theme.colors.text.disabled,
        opacity: 1
      }
    })
  );
};
const inputPadding = (theme) => {
  return css.css({
    padding: theme.spacing(0, 1, 0, 1)
  });
};
const inputSizes = () => {
  return {
    sm: css.css({
      width: inputSizesPixels("sm")
    }),
    md: css.css({
      width: inputSizesPixels("md")
    }),
    lg: css.css({
      width: inputSizesPixels("lg")
    }),
    auto: css.css({
      width: inputSizesPixels("auto")
    })
  };
};
const inputSizesPixels = (size) => {
  switch (size) {
    case "sm":
      return "200px";
    case "md":
      return "320px";
    case "lg":
      return "580px";
    case "auto":
    default:
      return "auto";
  }
};
function getPropertiesForButtonSize(size, theme) {
  switch (size) {
    case "sm":
      return {
        padding: 1,
        fontSize: theme.typography.size.sm,
        height: theme.components.height.sm
      };
    case "lg":
      return {
        padding: 3,
        fontSize: theme.typography.size.lg,
        height: theme.components.height.lg
      };
    case "md":
    default:
      return {
        padding: 2,
        fontSize: theme.typography.size.md,
        height: theme.components.height.md
      };
  }
}

"use strict";
function getPlacement(placement) {
  switch (placement) {
    case "auto":
      return "bottom";
    case "auto-start":
      return "bottom-start";
    case "auto-end":
      return "bottom-end";
    default:
      return placement != null ? placement : "bottom";
  }
}
function buildTooltipTheme(theme, tooltipBg, toggletipBorder, tooltipText, tooltipPadding) {
  return {
    arrow: css.css({
      fill: tooltipBg
    }),
    container: css.css({
      backgroundColor: tooltipBg,
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${toggletipBorder}`,
      boxShadow: theme.shadows.z2,
      color: tooltipText,
      fontSize: theme.typography.bodySmall.fontSize,
      padding: theme.spacing(tooltipPadding.topBottom, tooltipPadding.rightLeft),
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: "opacity 0.3s"
      },
      zIndex: theme.zIndex.tooltip,
      maxWidth: "400px",
      overflowWrap: "break-word",
      "&[data-popper-interactive='false']": {
        pointerEvents: "none"
      }
    }),
    headerClose: css.css({
      color: theme.colors.text.secondary,
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1.5),
      backgroundColor: "transparent",
      border: 0
    }),
    header: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(2)
    }),
    body: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(1)
    }),
    footer: css.css({
      paddingTop: theme.spacing(2),
      paddingBottom: theme.spacing(1)
    })
  };
}

"use strict";
const Tooltip = React.forwardRef(
  ({ children, theme, interactive, show, placement, content }, forwardedRef) => {
    const arrowRef = React.useRef(null);
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: setControlledVisible,
      middleware,
      whileElementsMounted: react$1.autoUpdate
    });
    const tooltipId = React.useId();
    const hover = react$1.useHover(context, {
      handleClose: interactive ? react$1.safePolygon() : void 0,
      move: false
    });
    const focus = react$1.useFocus(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, hover, focus]);
    const contentIsFunction = typeof content === "function";
    const styles = useStyles2(getStyles$2k);
    const style = styles[theme != null ? theme : "info"];
    const handleRef = React.useCallback(
      (ref) => {
        refs.setReference(ref);
        if (typeof forwardedRef === "function") {
          forwardedRef(ref);
        } else if (forwardedRef) {
          forwardedRef.current = ref;
        }
      },
      [forwardedRef, refs]
    );
    const childHasMatchingAriaLabel = "aria-label" in children.props && children.props["aria-label"] === content;
    return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      React.cloneElement(children, {
        ref: handleRef,
        tabIndex: 0,
        // tooltip trigger should be keyboard focusable
        "aria-describedby": !childHasMatchingAriaLabel && isOpen ? tooltipId : void 0,
        ...getReferenceProps()
      }),
      isOpen && /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: refs.setFloating, style: floatingStyles, ...getFloatingProps(), children: [
        /* @__PURE__ */ jsxRuntime.jsx(react$1.FloatingArrow, { className: style.arrow, ref: arrowRef, context }),
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            "data-testid": e2eSelectors.selectors.components.Tooltip.container,
            id: tooltipId,
            role: "tooltip",
            className: style.container,
            children: [
              typeof content === "string" && content,
              React.isValidElement(content) && React.cloneElement(content),
              contentIsFunction && content({})
            ]
          }
        )
      ] }) })
    ] });
  }
);
Tooltip.displayName = "Tooltip";
const getStyles$2k = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

"use strict";
class PopoverController extends React.Component {
  constructor() {
    super(...arguments);
    this.hideTimeout = null;
    this.state = { show: false };
    this.showPopper = () => {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.setState({ show: true });
    };
    this.hidePopper = () => {
      this.hideTimeout = setTimeout(() => {
        this.setState({ show: false });
      }, this.props.hideAfter);
    };
  }
  render() {
    const { children, content, placement = "auto" } = this.props;
    const { show } = this.state;
    return children(this.showPopper, this.hidePopper, {
      show,
      placement,
      content
    });
  }
}

"use strict";

"use strict";
const allButtonVariants = ["primary", "secondary", "destructive"];
const allButtonFills = ["solid", "outline", "text"];
const Button = React__namespace.forwardRef(
  ({
    variant = "primary",
    size = "md",
    fill = "solid",
    icon,
    fullWidth,
    children,
    className,
    type = "button",
    tooltip,
    disabled,
    tooltipPlacement,
    onClick,
    ...otherProps
  }, ref) => {
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      size,
      variant,
      fill,
      fullWidth,
      iconOnly: !children
    });
    const buttonStyles = css.cx(
      styles.button,
      {
        [styles.disabled]: disabled
      },
      className
    );
    const hasTooltip = Boolean(tooltip);
    const button = /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        className: buttonStyles,
        type,
        onClick: disabled ? void 0 : onClick,
        ...otherProps,
        "aria-disabled": hasTooltip && disabled,
        disabled: !hasTooltip && disabled,
        ref: tooltip ? void 0 : ref,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon, size, className: styles.icon }),
          children && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.content, children })
        ]
      }
    );
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: button });
    }
    return button;
  }
);
Button.displayName = "Button";
const LinkButton = React__namespace.forwardRef(
  ({
    variant = "primary",
    size = "md",
    fill = "solid",
    icon,
    fullWidth,
    children,
    className,
    onBlur,
    onFocus,
    disabled,
    tooltip,
    tooltipPlacement,
    ...otherProps
  }, ref) => {
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      fullWidth,
      size,
      variant,
      fill,
      iconOnly: !children
    });
    const linkButtonStyles = css.cx(
      styles.button,
      {
        [css.css(styles.disabled, {
          pointerEvents: "none"
        })]: disabled
      },
      className
    );
    const button = /* @__PURE__ */ jsxRuntime.jsxs(
      "a",
      {
        className: linkButtonStyles,
        ...otherProps,
        tabIndex: disabled ? -1 : 0,
        "aria-disabled": disabled,
        ref: tooltip ? void 0 : ref,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon, size, className: styles.icon }),
          children && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.content, children })
        ]
      }
    );
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: button });
    }
    return button;
  }
);
LinkButton.displayName = "LinkButton";
const IconRenderer = ({ icon, size, className, iconType }) => {
  if (!icon) {
    return null;
  }
  if (React__namespace.isValidElement(icon)) {
    return React__namespace.cloneElement(icon, {
      className,
      size
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size, className, type: iconType });
};
const getButtonStyles = (props) => {
  const { theme, variant, fill = "solid", size, iconOnly, fullWidth } = props;
  const { height, padding, fontSize } = getPropertiesForButtonSize(size, theme);
  const variantStyles = getPropertiesForVariant(theme, variant, fill);
  const disabledStyles = getPropertiesForDisabled(theme, variant, fill);
  const focusStyle = getFocusStyles(theme);
  const paddingMinusBorder = theme.spacing.gridSize * padding - 1;
  return {
    button: css.css({
      label: "button",
      display: "inline-flex",
      alignItems: "center",
      fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      fontFamily: theme.typography.fontFamily,
      padding: `0 ${paddingMinusBorder}px`,
      height: theme.spacing(height),
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${theme.spacing.gridSize * height - 2}px`,
      verticalAlign: "middle",
      cursor: "pointer",
      borderRadius: theme.shape.radius.default,
      "&:focus": focusStyle,
      "&:focus-visible": focusStyle,
      "&:focus:not(:focus-visible)": getMouseFocusStyles(theme),
      ...fullWidth && {
        flexGrow: 1,
        justifyContent: "center"
      },
      ...variantStyles,
      ":disabled": disabledStyles,
      "&[disabled]": disabledStyles
    }),
    disabled: css.css(disabledStyles, {
      "&:hover": css.css(disabledStyles)
    }),
    img: css.css({
      width: "16px",
      height: "16px",
      margin: theme.spacing(0, 1, 0, 0.5)
    }),
    icon: iconOnly ? css.css({
      // Important not to set margin bottom here as it would override internal icon bottom margin
      marginRight: theme.spacing(-padding / 2),
      marginLeft: theme.spacing(-padding / 2)
    }) : css.css({
      marginRight: theme.spacing(padding / 2)
    }),
    content: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      whiteSpace: "nowrap",
      overflow: "hidden",
      height: "100%"
    })
  };
};
function getButtonVariantStyles(theme, color, fill) {
  let outlineBorderColor = color.border;
  let borderColor = "transparent";
  let hoverBorderColor = "transparent";
  if (color.name === "secondary") {
    borderColor = color.border;
    hoverBorderColor = theme.colors.emphasize(color.border, 0.25);
    outlineBorderColor = theme.colors.border.strong;
  }
  if (fill === "outline") {
    return {
      background: "transparent",
      color: color.text,
      border: `1px solid ${outlineBorderColor}`,
      transition: theme.transitions.create(["background-color", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        background: color.transparent,
        borderColor: theme.colors.emphasize(outlineBorderColor, 0.25),
        color: color.text
      }
    };
  }
  if (fill === "text") {
    return {
      background: "transparent",
      color: color.text,
      border: "1px solid transparent",
      transition: theme.transitions.create(["background-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus": {
        outline: "none",
        textDecoration: "none"
      },
      "&:hover": {
        background: color.transparent,
        textDecoration: "none"
      }
    };
  }
  return {
    background: color.main,
    color: color.contrastText,
    border: `1px solid ${borderColor}`,
    transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    }),
    "&:hover": {
      background: color.shade,
      color: color.contrastText,
      boxShadow: theme.shadows.z1,
      borderColor: hoverBorderColor
    }
  };
}
function getPropertiesForDisabled(theme, variant, fill) {
  const disabledStyles = {
    cursor: "not-allowed",
    boxShadow: "none",
    color: theme.colors.text.disabled,
    transition: "none"
  };
  if (fill === "text") {
    return {
      ...disabledStyles,
      background: "transparent",
      border: `1px solid transparent`
    };
  }
  if (fill === "outline") {
    return {
      ...disabledStyles,
      background: "transparent",
      border: `1px solid ${theme.colors.border.weak}`
    };
  }
  return {
    ...disabledStyles,
    background: theme.colors.action.disabledBackground,
    border: `1px solid transparent`
  };
}
function getPropertiesForVariant(theme, variant, fill) {
  switch (variant) {
    case "secondary":
      return getButtonVariantStyles(theme, theme.colors.secondary, fill);
    case "destructive":
      return getButtonVariantStyles(theme, theme.colors.error, fill);
    case "success":
      return getButtonVariantStyles(theme, theme.colors.success, fill);
    case "primary":
    default:
      return getButtonVariantStyles(theme, theme.colors.primary, fill);
  }
}
const clearButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    color: theme.colors.text.primary,
    border: "none",
    padding: 0
  });
};
const clearLinkButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    border: "none",
    padding: 0,
    fontFamily: "inherit",
    color: "inherit",
    height: "100%",
    cursor: "context-menu",
    "&:hover": {
      background: "transparent",
      color: "inherit"
    }
  });
};

"use strict";
const ButtonGroup = React.forwardRef(({ className, children, ...rest }, ref) => {
  const styles = useStyles2(getStyles$2j);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx("button-group", styles.wrapper, className), ...rest, children });
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles$2j = (theme) => ({
  wrapper: css.css({
    display: "flex",
    borderRadius: theme.shape.radius.default,
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0,
      borderLeft: `1px solid rgba(255, 255, 255, 0.12)`
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0,
      borderRight: `1px solid rgba(0, 0, 0, 0.12)`
    }
  })
});

"use strict";

"use strict";
const Pagination = ({
  currentPage,
  numberOfPages,
  onNavigate,
  hideWhenSinglePage,
  showSmallVersion,
  className
}) => {
  const styles = useStyles2(getStyles$2i);
  const pageLengthToCondense = showSmallVersion ? 1 : 8;
  const pageButtons = React.useMemo(() => {
    const pages = [...new Array(numberOfPages).keys()];
    const condensePages = numberOfPages > pageLengthToCondense;
    const getListItem = (page, variant) => /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", variant, onClick: () => onNavigate(page), children: page }) }, page);
    return pages.reduce((pagesToRender, pageIndex) => {
      const page = pageIndex + 1;
      const variant = page === currentPage ? "primary" : "secondary";
      const lowerBoundIndex = pageLengthToCondense;
      const upperBoundIndex = numberOfPages - pageLengthToCondense + 1;
      const differenceOfBounds = upperBoundIndex - lowerBoundIndex;
      const isFirstOrLastPage = page === 1 || page === numberOfPages;
      const currentPageIsBetweenBounds = differenceOfBounds > -1 && currentPage >= lowerBoundIndex && currentPage <= upperBoundIndex;
      const ellipsisOffset = showSmallVersion ? 1 : 3;
      const pageOffset = showSmallVersion ? 0 : 2;
      if (condensePages) {
        if (isFirstOrLastPage || currentPage < lowerBoundIndex && page < lowerBoundIndex || differenceOfBounds >= 0 && currentPage > upperBoundIndex && page > upperBoundIndex || differenceOfBounds < 0 && currentPage >= lowerBoundIndex && page > upperBoundIndex || currentPageIsBetweenBounds && page >= currentPage - pageOffset && page <= currentPage + pageOffset) {
          pagesToRender.push(getListItem(page, variant));
        } else if (page === lowerBoundIndex && currentPage < lowerBoundIndex || page === upperBoundIndex && currentPage > upperBoundIndex || currentPageIsBetweenBounds && (page === currentPage - ellipsisOffset || page === currentPage + ellipsisOffset)) {
          pagesToRender.push(
            /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.ellipsis, name: "ellipsis-v" }) }, page)
          );
        }
      } else {
        pagesToRender.push(getListItem(page, variant));
      }
      return pagesToRender;
    }, []);
  }, [currentPage, numberOfPages, onNavigate, pageLengthToCondense, showSmallVersion, styles.ellipsis, styles.item]);
  if (hideWhenSinglePage && numberOfPages <= 1) {
    return null;
  }
  const previousPageLabel = t("grafana-ui.pagination.previous-page", "previous page");
  const nextPageLabel = t("grafana-ui.pagination.next-page", "next page");
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.container, className), children: /* @__PURE__ */ jsxRuntime.jsxs("ol", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": previousPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage - 1),
        disabled: currentPage === 1,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" })
      }
    ) }),
    pageButtons,
    /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": nextPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage + 1),
        disabled: currentPage === numberOfPages,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" })
      }
    ) })
  ] }) });
};
const getStyles$2i = () => {
  return {
    container: css.css({
      float: "right"
    }),
    item: css.css({
      display: "inline-block",
      paddingLeft: "10px",
      marginBottom: "5px"
    }),
    ellipsis: css.css({
      transform: "rotate(90deg)"
    })
  };
};

"use strict";
const LoadingIndicator = ({ onCancel, loading }) => {
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  const styles = useStyles2(getStyles$2h);
  if (!loading) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: "Cancel query", children: /* @__PURE__ */ jsxRuntime.jsx(
    Icon,
    {
      className: css.cx(styles.spin, { [styles.clickable]: !!onCancel }),
      name: prefersReducedMotion ? "hourglass" : "sync",
      size: "sm",
      onClick: onCancel,
      "data-testid": e2eSelectors.selectors.components.LoadingIndicator.icon
    }
  ) });
};
const spin = css.keyframes({
  "0%": {
    transform: "rotate(0deg) scaleX(-1)"
    // scaleX flips the `sync` icon so arrows point the correct way
  },
  "100%": {
    transform: "rotate(359deg) scaleX(-1)"
  }
});
const getStyles$2h = (theme) => {
  return {
    clickable: css.css({
      cursor: "pointer"
    }),
    spin: css.css({
      [theme.transitions.handleMotion("no-preference")]: {
        animation: `${spin} 3s linear infinite`
      }
    })
  };
};

"use strict";
if (typeof window !== "undefined" && "Element" in window && !Element.prototype.closest) {
  Element.prototype.closest = function(s) {
    const matches = (this.document || this.ownerDocument).querySelectorAll(s);
    let el = this;
    let i;
    do {
      i = matches.length;
      while (--i >= 0 && matches.item(i) !== el) {
      }
      el = el.parentElement;
    } while (i < 0 && el);
    return el;
  };
}
function getPreviousCousin(node, selector) {
  var _a;
  let sibling = (_a = node.parentElement) == null ? void 0 : _a.previousSibling;
  let el;
  while (sibling) {
    if (sibling instanceof HTMLElement) {
      el = sibling.querySelector(selector);
    }
    if (el) {
      return el;
    }
    sibling = sibling.previousSibling;
  }
  return void 0;
}
function getNextCharacter(global) {
  const selection = (global || window).getSelection();
  if (!selection || !selection.anchorNode) {
    return null;
  }
  const range = selection.getRangeAt(0);
  const text = selection.anchorNode.textContent;
  const offset = range.startOffset;
  return text.slice(offset, offset + 1);
}

var dom = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getNextCharacter: getNextCharacter,
  getPreviousCousin: getPreviousCousin
});

"use strict";
function getChildId(children) {
  let inputId;
  const child = React__namespace.Children.only(children);
  if ("id" in (child == null ? void 0 : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? void 0 : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : void 0;
}
function renderOrCallToRender(itemToRender, props) {
  if (React__namespace.isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function" && props) {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

var reactUtils = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getChildId: getChildId,
  renderOrCallToRender: renderOrCallToRender
});

"use strict";
const PALETTE_ROWS = 4;
const DEFAULT_ANNOTATION_COLOR = "rgba(0, 211, 255, 1)";
const OK_COLOR = "rgba(11, 237, 50, 1)";
const ALERTING_COLOR = "rgba(237, 46, 24, 1)";
const NO_DATA_COLOR = "rgba(150, 150, 150, 1)";
const PENDING_COLOR = "rgba(247, 149, 32, 1)";
const REGION_FILL_ALPHA = 0.09;
const colors = [
  "#7EB26D",
  // 0: pale green
  "#EAB839",
  // 1: mustard
  "#6ED0E0",
  // 2: light blue
  "#EF843C",
  // 3: orange
  "#E24D42",
  // 4: red
  "#1F78C1",
  // 5: ocean
  "#BA43A9",
  // 6: purple
  "#705DA0",
  // 7: violet
  "#508642",
  // 8: dark green
  "#CCA300",
  // 9: dark sand
  "#447EBC",
  "#C15C17",
  "#890F02",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#B7DBAB",
  "#F4D598",
  "#70DBED",
  "#F9BA8F",
  "#F29191",
  "#82B5D8",
  "#E5A8E2",
  "#AEA2E0",
  "#629E51",
  "#E5AC0E",
  "#64B0C8",
  "#E0752D",
  "#BF1B00",
  "#0A50A1",
  "#962D82",
  "#614D93",
  "#9AC48A",
  "#F2C96D",
  "#65C5DB",
  "#F9934E",
  "#EA6460",
  "#5195CE",
  "#D683CE",
  "#806EB7",
  "#3F6833",
  "#967302",
  "#2F575E",
  "#99440A",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B",
  "#E0F9D7",
  "#FCEACA",
  "#CFFAFF",
  "#F9E2D2",
  "#FCE2DE",
  "#BADFF4",
  "#F9D9F9",
  "#DEDAF7"
];
function sortColorsByHue(hexColors) {
  const hslColors = lodash.map(hexColors, hexToHsl);
  const sortedHSLColors = lodash.sortBy(hslColors, ["h"]);
  const chunkedHSLColors = lodash.chunk(sortedHSLColors, PALETTE_ROWS);
  const sortedChunkedHSLColors = lodash.map(chunkedHSLColors, (chunk2) => {
    return lodash.sortBy(chunk2, "l");
  });
  const flattenedZippedSortedChunkedHSLColors = lodash.flattenDeep(lodash.zip(...sortedChunkedHSLColors));
  return lodash.map(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
  return tinycolor__default.default(color).toHsl();
}
function hslToHex(color) {
  return tinycolor__default.default(color).toHexString();
}
function getTextColorForBackground(color) {
  const b = tinycolor__default.default(color).getBrightness();
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
function getTextColorForAlphaBackground(color, themeIsDark) {
  const tcolor = tinycolor__default.default(color);
  const b = tcolor.getBrightness();
  const a = tcolor.getAlpha();
  if (a < 0.3) {
    return themeIsDark ? "rgb(247, 248, 250)" : "rgb(32, 34, 38)";
  }
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
let sortedColors = sortColorsByHue(colors);

"use strict";
var EventsWithValidation = /* @__PURE__ */ ((EventsWithValidation2) => {
  EventsWithValidation2["onBlur"] = "onBlur";
  EventsWithValidation2["onFocus"] = "onFocus";
  EventsWithValidation2["onChange"] = "onChange";
  return EventsWithValidation2;
})(EventsWithValidation || {});
const validate = (value, validationRules) => {
  const errors = validationRules.reduce((acc, currRule) => {
    if (!currRule.rule(value)) {
      return acc.concat(currRule.errorMessage);
    }
    return acc;
  }, []);
  return errors.length > 0 ? errors : null;
};
const hasValidationEvent = (event, validationEvents) => {
  return validationEvents && validationEvents[event];
};
const regexValidation = (pattern, errorMessage) => {
  return {
    rule: (valueToValidate) => {
      return !!valueToValidate.match(pattern);
    },
    errorMessage: errorMessage || "Value is not valid"
  };
};

"use strict";
const SCHEMA = {
  document: {
    nodes: [
      {
        match: [{ type: "paragraph" }, { type: "code_block" }, { type: "code_line" }]
      }
    ]
  },
  inlines: {}
};
const makeFragment = (text, syntax) => {
  const lines = text.split("\n").map(
    (line) => slate.Block.create({
      type: "code_line",
      nodes: [slate.Text.create(line)]
    })
  );
  const block = slate.Block.create({
    data: {
      syntax
    },
    type: "code_block",
    nodes: lines
  });
  return slate.Document.create({
    nodes: [block]
  });
};
const makeValue = (text, syntax) => {
  const fragment = makeFragment(text, syntax);
  return slate.Value.create({
    document: fragment
  });
};

"use strict";
const linkModelToContextMenuItems = (links) => {
  return links().map((link) => {
    return {
      label: link.title,
      ariaLabel: link.title,
      // TODO: rename to href
      url: link.href,
      target: link.target,
      icon: `${link.target === "_blank" ? "external-link-alt" : "link"}`,
      onClick: link.onClick
    };
  });
};

"use strict";
const TAG_COLORS = [
  "#D32D20",
  "#1E72B8",
  "#B240A2",
  "#705DA0",
  "#466803",
  "#497A3C",
  "#3D71AA",
  "#B15415",
  "#890F02",
  "#6E6E6E",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#4C7A3F",
  "#2F4F4F",
  "#BF1B00",
  "#7662B1",
  "#8A2EB8",
  "#517A00",
  "#000000",
  "#3F6833",
  "#2F575E",
  "#99440A",
  "#AE561A",
  "#0E4AB4",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B"
];
const TAG_BORDER_COLORS = [
  "#FF7368",
  "#459EE7",
  "#E069CF",
  "#9683C6",
  "#6C8E29",
  "#76AC68",
  "#6AA4E2",
  "#E7823D",
  "#AF3528",
  "#9B9B9B",
  "#3069A2",
  "#934588",
  "#7E6A9D",
  "#88C477",
  "#557575",
  "#E54126",
  "#A694DD",
  "#B054DE",
  "#8FC426",
  "#262626",
  "#658E59",
  "#557D84",
  "#BF6A30",
  "#FF9B53",
  "#3470DA",
  "#7E3A32",
  "#2B5177",
  "#773D6F",
  "#655181"
];
function getTagColorIndexFromName(name = "") {
  const hash = djb2(name.toLowerCase());
  return Math.abs(hash % TAG_COLORS.length);
}
function getTagColorsFromName(name = "") {
  const index = getTagColorIndexFromName(name);
  return getTagColor(index);
}
function getTagColor(index) {
  return { color: TAG_COLORS[index], borderColor: TAG_BORDER_COLORS[index] };
}
function djb2(str) {
  let hash = 5381;
  for (let i = 0; i < str.length; i++) {
    hash = (hash << 5) + hash + str.charCodeAt(i);
  }
  return hash;
}
var tags = {
  getTagColorsFromName
};

"use strict";
let scrollbarWidth = null;
function getScrollbarWidth$1() {
  if (scrollbarWidth !== null) {
    return scrollbarWidth;
  }
  if (typeof document !== "undefined") {
    const div = document.createElement("div");
    const newStyles = {
      width: "100px",
      height: "100px",
      position: "absolute",
      top: "-9999px",
      overflow: "scroll",
      MsOverflowStyle: "scrollbar"
    };
    Object.keys(newStyles).map((style) => {
      div.style[style] = newStyles[style];
    });
    document.body.appendChild(div);
    scrollbarWidth = div.offsetWidth - div.clientWidth;
    document.body.removeChild(div);
  } else {
    scrollbarWidth = 0;
  }
  return scrollbarWidth || 0;
}

"use strict";
const getCellLinks$1 = (field, row) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: row.index
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: row.index
          });
        }
      };
    }
  }
  return links;
};

"use strict";
let _context;
const cache = /* @__PURE__ */ new Map();
const cacheLimit = 500;
let ctxFontStyle = "";
function getCanvasContext() {
  if (!_context) {
    _context = document.createElement("canvas").getContext("2d");
  }
  return _context;
}
function measureText(text, fontSize, fontWeight = 400) {
  const fontStyle = `${fontWeight} ${fontSize}px 'Inter'`;
  const cacheKey = text + fontStyle;
  const fromCache = cache.get(cacheKey);
  if (fromCache) {
    return fromCache;
  }
  const context = getCanvasContext();
  if (ctxFontStyle !== fontStyle) {
    context.font = ctxFontStyle = fontStyle;
  }
  const metrics = context.measureText(text);
  if (cache.size === cacheLimit) {
    cache.clear();
  }
  cache.set(cacheKey, metrics);
  return metrics;
}
function calculateFontSize(text, width, height, lineHeight, maxSize, fontWeight) {
  const textSize = measureText(text, 14, fontWeight);
  const fontSizeBasedOnWidth = width / (textSize.width + 2) * 14;
  const fontSizeBasedOnHeight = height / lineHeight;
  const optimalSize = Math.min(fontSizeBasedOnHeight, fontSizeBasedOnWidth);
  return Math.min(optimalSize, maxSize != null ? maxSize : optimalSize);
}

"use strict";
function createPointerDistance(distance = 10) {
  let initial = { x: 0, y: 0 };
  const set = (evt) => {
    initial = getPoint(evt);
  };
  const check = (evt, overrideDistance = distance) => checkDistance(initial, getPoint(evt), overrideDistance);
  return { set, check };
}
function usePointerDistance(distance = 10) {
  const initial = React__namespace.default.useRef({ x: 0, y: 0 });
  const set = React.useCallback((evt) => {
    initial.current = getPoint(evt);
  }, []);
  const check = React.useCallback(
    (evt, overrideDistance = distance) => checkDistance(initial.current, getPoint(evt), overrideDistance),
    [distance]
  );
  return React.useMemo(() => ({ set, check }), [set, check]);
}
function getPoint(evt) {
  return { x: evt.clientX, y: evt.clientY };
}
function checkDistance(point1, point2, distance) {
  return Math.hypot(point1.x - point2.x, point1.y - point2.y) > distance;
}

"use strict";
function useForceUpdate() {
  const [_, setValue] = React.useState(0);
  return React.useCallback(() => setValue((prevState) => prevState + 1), []);
}

"use strict";
function fuzzyMatch(stack, needle) {
  let distance = 0, searchIndex = stack.indexOf(needle);
  needle = needle.replace(/\s/g, "");
  const ranges = [];
  if (searchIndex !== -1) {
    return {
      distance: 0,
      found: true,
      ranges: [{ start: searchIndex, end: searchIndex + needle.length - 1 }]
    };
  }
  for (const letter of needle) {
    const letterIndex = stack.indexOf(letter, searchIndex);
    if (letterIndex === -1) {
      return { distance: Infinity, ranges: [], found: false };
    }
    if (searchIndex !== -1) {
      distance += letterIndex - searchIndex;
    }
    searchIndex = letterIndex + 1;
    if (ranges.length === 0) {
      ranges.push({ start: letterIndex, end: letterIndex });
    } else {
      const lastRange = lodash.last(ranges);
      if (letterIndex === lastRange.end + 1) {
        lastRange.end++;
      } else {
        ranges.push({ start: letterIndex, end: letterIndex });
      }
    }
  }
  return {
    distance,
    ranges,
    found: true
  };
}

"use strict";
var SearchFunctionType = /* @__PURE__ */ ((SearchFunctionType2) => {
  SearchFunctionType2["Word"] = "Word";
  SearchFunctionType2["Prefix"] = "Prefix";
  SearchFunctionType2["Fuzzy"] = "Fuzzy";
  return SearchFunctionType2;
})(SearchFunctionType || {});
const wordSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).includes(text));
};
const prefixSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).startsWith(text));
};
const fuzzySearch = (items, text) => {
  text = text.toLowerCase();
  return items.filter((item) => {
    const { distance, ranges, found } = fuzzyMatch(item.label.toLowerCase(), text);
    if (!found) {
      return false;
    }
    item.sortValue = distance;
    item.highlightParts = ranges;
    return true;
  });
};
const SearchFunctionMap = {
  ["Word" /* Word */]: wordSearch,
  ["Prefix" /* Prefix */]: prefixSearch,
  ["Fuzzy" /* Fuzzy */]: fuzzySearch
};

"use strict";
const throttledLog = lodash.throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let loggingEnabled = false;
  if (typeof window !== "undefined") {
    loggingEnabled = window.localStorage.getItem("grafana.debug") === "true";
  }
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !loggingEnabled) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]:`, ...t);
    },
    enable: () => loggingEnabled = true,
    disable: () => loggingEnabled = false,
    isEnabled: () => loggingEnabled
  };
};

"use strict";
function attachDebugger(key, thebugger, logger) {
  var _a;
  if (process.env.NODE_ENV === "production") {
    return;
  }
  let completeDebugger = thebugger || {};
  if (logger !== void 0) {
    completeDebugger = { ...completeDebugger, enable: () => logger.enable(), disable: () => logger.disable() };
  }
  let debugGlobal = (_a = typeof window !== "undefined" && window["_debug"]) != null ? _a : {};
  debugGlobal[key] = completeDebugger;
  if (typeof window !== "undefined") {
    window["_debug"] = debugGlobal;
  }
}

"use strict";
var NodeGraphDataFrameFieldNames = /* @__PURE__ */ ((NodeGraphDataFrameFieldNames2) => {
  NodeGraphDataFrameFieldNames2["id"] = "id";
  NodeGraphDataFrameFieldNames2["title"] = "title";
  NodeGraphDataFrameFieldNames2["subTitle"] = "subTitle";
  NodeGraphDataFrameFieldNames2["mainStat"] = "mainStat";
  NodeGraphDataFrameFieldNames2["secondaryStat"] = "secondaryStat";
  NodeGraphDataFrameFieldNames2["source"] = "source";
  NodeGraphDataFrameFieldNames2["target"] = "target";
  NodeGraphDataFrameFieldNames2["detail"] = "detail__";
  NodeGraphDataFrameFieldNames2["arc"] = "arc__";
  NodeGraphDataFrameFieldNames2["color"] = "color";
  return NodeGraphDataFrameFieldNames2;
})(NodeGraphDataFrameFieldNames || {});

"use strict";
function logOptions(amount, recommendedAmount, id, ariaLabelledBy) {
  if (amount > recommendedAmount) {
    const msg = `[Combobox] Items exceed the recommended amount ${recommendedAmount}.`;
    console.warn(msg, {
      itemsCount: "" + amount,
      recommendedAmount: "" + recommendedAmount,
      "aria-labelledby": ariaLabelledBy != null ? ariaLabelledBy : "",
      id: id != null ? id : ""
    });
  }
}

"use strict";

"use strict";
function DelayRender({ children, delay }) {
  const [shouldRender, setShouldRender] = React.useState(false);
  React.useEffect(() => {
    window.setTimeout(() => {
      setShouldRender(true);
    }, delay);
  }, [children, delay]);
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: shouldRender ? children : null });
}

"use strict";
const ElementSelectionContext = React.createContext(void 0);
function useElementSelection(id) {
  if (!id) {
    return {};
  }
  const context = React.useContext(ElementSelectionContext);
  if (!context) {
    return {};
  }
  const isSelected = context.selected.some((item) => item.id === id);
  const onSelect = React.useCallback(
    (evt, options = {}) => {
      var _a, _b;
      if (!context.enabled) {
        return;
      }
      evt.stopPropagation();
      if (evt.shiftKey) {
        evt.preventDefault();
        (_a = window.getSelection()) == null ? void 0 : _a.empty();
      }
      context.onSelect({ id }, { ...options, multi: (_b = options.multi) != null ? _b : evt.shiftKey });
    },
    [context, id]
  );
  const onClear = React.useCallback(() => {
    if (!context.enabled) {
      return;
    }
    context.onClear();
  }, [context]);
  return { isSelected, onSelect, onClear, isSelectable: context.enabled };
}

"use strict";
const BAR_WIDTH = 28;
const MILLISECONDS_PER_PIXEL = 2.4;
const MIN_DURATION_MS = 500;
const MAX_DURATION_MS = 4e3;
const DEFAULT_ANIMATION_DELAY = 300;
const MAX_TRANSLATE_X = 100 / BAR_WIDTH * 100;
function LoadingBar({ width, delay = DEFAULT_ANIMATION_DELAY, ariaLabel = "Loading bar" }) {
  const durationMs = Math.min(Math.max(Math.round(width * MILLISECONDS_PER_PIXEL), MIN_DURATION_MS), MAX_DURATION_MS);
  const styles = useStyles2(getStyles$2g, delay, durationMs);
  const containerStyles = {
    overflow: "hidden"
  };
  return /* @__PURE__ */ jsxRuntime.jsx("div", { style: containerStyles, children: /* @__PURE__ */ jsxRuntime.jsx("div", { "aria-label": ariaLabel, className: styles.bar }) });
}
const getStyles$2g = (theme, delay, duration) => {
  const animation = css.keyframes({
    "0%": {
      transform: "translateX(-100%)"
    },
    // this gives us a delay between iterations
    "85%, 100%": {
      transform: `translateX(${MAX_TRANSLATE_X}%)`
    }
  });
  return {
    bar: css.css({
      width: BAR_WIDTH + "%",
      height: 1,
      background: `linear-gradient(90deg, transparent 0%, ${theme.colors.primary.main} 80.75%, transparent 100%)`,
      transform: "translateX(-100%)",
      willChange: "transform",
      [theme.transitions.handleMotion("no-preference")]: {
        animationName: animation,
        // an initial delay to prevent the loader from showing if the response is faster than the delay
        animationDelay: `${delay}ms`,
        animationTimingFunction: "linear",
        animationIterationCount: "infinite",
        animationDuration: `${duration}ms`
      },
      [theme.transitions.handleMotion("reduce")]: {
        animationName: animation,
        // an initial delay to prevent the loader from showing if the response is faster than the delay
        animationDelay: `${delay}ms`,
        animationTimingFunction: "linear",
        animationIterationCount: "infinite",
        animationDuration: `${4 * duration}ms`
      }
    })
  };
};

"use strict";
const TruncatedText = React__namespace.forwardRef(({ childElement, children }, ref) => {
  const [isOverflowing, setIsOverflowing] = React.useState(false);
  const internalRef = React.useRef(null);
  React.useImperativeHandle(ref, () => internalRef.current);
  const resizeObserver = React.useMemo(
    () => new ResizeObserver((entries) => {
      for (const entry of entries) {
        if (entry.target.clientWidth && entry.target.scrollWidth) {
          if (entry.target.scrollWidth > entry.target.clientWidth) {
            setIsOverflowing(true);
          }
          if (entry.target.scrollWidth <= entry.target.clientWidth) {
            setIsOverflowing(false);
          }
        }
      }
    }),
    []
  );
  React.useEffect(() => {
    const { current } = internalRef;
    if (current) {
      resizeObserver.observe(current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [setIsOverflowing, resizeObserver]);
  const getTooltipText = (children2) => {
    if (typeof children2 === "string") {
      return children2;
    }
    const html = ReactDOMServer__default.default.renderToStaticMarkup(/* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: children2 }));
    return html.replace(/(<([^>]+)>)/gi, "");
  };
  if (isOverflowing) {
    return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref: internalRef, content: getTooltipText(children), children: childElement(void 0) });
  } else {
    return childElement(internalRef);
  }
});
TruncatedText.displayName = "TruncatedText";

"use strict";
const customWeight = (weight, theme) => {
  switch (weight) {
    case "bold":
      return theme.typography.fontWeightBold;
    case "medium":
      return theme.typography.fontWeightMedium;
    case "light":
      return theme.typography.fontWeightLight;
    case "regular":
    case void 0:
      return theme.typography.fontWeightRegular;
  }
};
const customColor = (color, theme) => {
  switch (color) {
    case "error":
      return theme.colors.error.text;
    case "success":
      return theme.colors.success.text;
    case "info":
      return theme.colors.info.text;
    case "warning":
      return theme.colors.warning.text;
    default:
      return color ? theme.colors.text[color] : void 0;
  }
};
const customVariant = (theme, element, variant) => {
  if (variant) {
    return theme.typography[variant];
  }
  switch (element) {
    //Span elements does not have a default variant to be able to take the parents style
    case "span":
      return;
    case "h1":
      return theme.typography.h1;
    case "h2":
      return theme.typography.h2;
    case "h3":
      return theme.typography.h3;
    case "h4":
      return theme.typography.h4;
    case "h5":
      return theme.typography.h5;
    case "h6":
      return theme.typography.h6;
    default:
      return theme.typography.body;
  }
};

"use strict";
const Text = React__namespace.forwardRef(
  ({ element = "span", variant, weight, color, truncate, italic, textAlignment, children, tabular, ...restProps }, ref) => {
    const styles = useStyles2(getTextStyles, element, variant, color, weight, truncate, italic, textAlignment, tabular);
    const childElement = (ref2) => {
      return React.createElement(
        element,
        {
          ...restProps,
          style: void 0,
          // Remove the style prop to avoid overriding the styles
          className: styles,
          // When overflowing, the internalRef is passed to the tooltip, which forwards it to the child element
          ref: ref2
        },
        children
      );
    };
    if (!truncate || element === "span") {
      return childElement(void 0);
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      TruncatedText,
      {
        childElement,
        children,
        ref
      }
    );
  }
);
Text.displayName = "Text";
const getTextStyles = (theme, element, variant, color, weight, truncate, italic, textAlignment, tabular) => {
  return css.css([
    {
      margin: 0,
      padding: 0,
      ...customVariant(theme, element, variant)
    },
    variant && {
      ...theme.typography[variant]
    },
    color && {
      color: customColor(color, theme)
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    truncate && {
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    },
    italic && {
      fontStyle: "italic"
    },
    textAlignment && {
      textAlign: textAlignment
    },
    tabular && {
      fontFeatureSettings: '"tnum"'
    }
  ]);
};

"use strict";
const Dropdown = React__namespace.memo(({ children, overlay, placement, offset, onVisibleChange }) => {
  var _a, _b;
  const [show, setShow] = React.useState(false);
  const transitionRef = React.useRef(null);
  const handleOpenChange = React.useCallback(
    (newState) => {
      setShow(newState);
      onVisibleChange == null ? void 0 : onVisibleChange(newState);
    },
    [onVisibleChange]
  );
  const middleware = [
    react$1.offset({
      mainAxis: (_a = offset == null ? void 0 : offset[0]) != null ? _a : 8,
      crossAxis: (_b = offset == null ? void 0 : offset[1]) != null ? _b : 0
    }),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: show,
    placement: getPlacement(placement),
    onOpenChange: handleOpenChange,
    middleware,
    whileElementsMounted: react$1.autoUpdate
  });
  const click = react$1.useClick(context);
  const dismiss = react$1.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
  const animationDuration = 150;
  const animationStyles = useStyles2(getStyles$2f, animationDuration);
  const onOverlayClicked = () => {
    handleOpenChange(false);
  };
  const handleKeys = (event) => {
    if (event.key === "Tab") {
      handleOpenChange(false);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    React__namespace.cloneElement(children, {
      ref: refs.setReference,
      ...getReferenceProps()
    }),
    show && /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(react$1.FloatingFocusManager, { context, children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref: refs.setFloating, style: floatingStyles, onClick: onOverlayClicked, onKeyDown: handleKeys, children: /* @__PURE__ */ jsxRuntime.jsx(
      reactTransitionGroup.CSSTransition,
      {
        nodeRef: transitionRef,
        appear: true,
        in: true,
        timeout: { appear: animationDuration, exit: 0, enter: 0 },
        classNames: animationStyles,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref: transitionRef, children: renderOrCallToRender(overlay, { ...getFloatingProps() }) })
      }
    ) }) }) })
  ] });
});
Dropdown.displayName = "Dropdown";
const getStyles$2f = (theme, duration) => {
  return {
    appear: css.css({
      opacity: "0",
      position: "relative",
      transformOrigin: "top",
      [theme.transitions.handleMotion("no-preference")]: {
        transform: "scaleY(0.5)"
      }
    }),
    appearActive: css.css({
      opacity: "1",
      [theme.transitions.handleMotion("no-preference")]: {
        transform: "scaleY(1)",
        transition: `transform ${duration}ms cubic-bezier(0.2, 0, 0.2, 1), opacity ${duration}ms cubic-bezier(0.2, 0, 0.2, 1)`
      }
    })
  };
};

"use strict";
const ToolbarButton = React.forwardRef(
  ({
    tooltip,
    icon,
    iconSize,
    className,
    children,
    imgSrc,
    imgAlt,
    fullWidth,
    isOpen,
    narrow,
    variant = "default",
    iconOnly,
    "aria-label": ariaLabel,
    isHighlighted,
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles$2e);
    const buttonStyles = css.cx(
      {
        [styles.button]: true,
        [styles.buttonFullWidth]: fullWidth,
        [styles.narrow]: narrow
      },
      styles[variant],
      className
    );
    const contentStyles = css.cx({
      [styles.content]: true,
      [styles.contentWithIcon]: !!icon,
      [styles.contentWithRightIcon]: isOpen !== void 0
    });
    const body = /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        ref,
        className: buttonStyles,
        "aria-label": getButtonAriaLabel(ariaLabel, tooltip),
        "aria-expanded": isOpen,
        type: "button",
        ...rest,
        children: [
          renderIcon(icon, iconSize),
          imgSrc && /* @__PURE__ */ jsxRuntime.jsx("img", { className: styles.img, src: imgSrc, alt: imgAlt != null ? imgAlt : "" }),
          children && !iconOnly && /* @__PURE__ */ jsxRuntime.jsx("div", { className: contentStyles, children }),
          isOpen === false && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-down" }),
          isOpen === true && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-up" }),
          isHighlighted && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.highlight })
        ]
      }
    );
    return tooltip ? /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: "bottom", children: body }) : body;
  }
);
ToolbarButton.displayName = "ToolbarButton";
function getButtonAriaLabel(ariaLabel, tooltip) {
  return ariaLabel ? ariaLabel : tooltip ? e2eSelectors.selectors.components.PageToolbar.item(tooltip) : void 0;
}
function renderIcon(icon, iconSize) {
  if (!icon) {
    return null;
  }
  if (data.isIconName(icon)) {
    return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size: `${iconSize ? iconSize : "lg"}` });
  }
  return icon;
}
const getStyles$2e = (theme) => {
  const primaryVariant = getPropertiesForVariant(theme, "primary", "solid");
  const destructiveVariant = getPropertiesForVariant(theme, "destructive", "solid");
  const defaultOld = css.css({
    color: theme.colors.text.primary,
    background: theme.colors.secondary.main,
    "&:hover": {
      color: theme.colors.text.primary,
      background: theme.colors.secondary.shade,
      border: `1px solid ${theme.colors.border.medium}`
    }
  });
  return {
    button: css.css({
      label: "toolbar-button",
      position: "relative",
      display: "flex",
      alignItems: "center",
      height: theme.spacing(theme.components.height.md),
      padding: theme.spacing(0, 1),
      borderRadius: theme.shape.radius.default,
      lineHeight: `${theme.components.height.md * theme.spacing.gridSize - 2}px`,
      fontWeight: theme.typography.fontWeightMedium,
      border: `1px solid ${theme.colors.secondary.border}`,
      whiteSpace: "nowrap",
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create(["background", "box-shadow", "border-color", "color"], {
          duration: theme.transitions.duration.short
        })
      },
      [theme.breakpoints.down("md")]: {
        width: "auto !important"
      },
      "&:focus, &:focus-visible": {
        ...getFocusStyles(theme),
        zIndex: 1
      },
      "&:focus:not(:focus-visible)": getMouseFocusStyles(theme),
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        opacity: theme.colors.action.disabledOpacity,
        background: theme.colors.action.disabledBackground,
        boxShadow: "none",
        "&:hover": {
          color: theme.colors.text.disabled,
          background: theme.colors.action.disabledBackground,
          boxShadow: "none"
        }
      }
    }),
    default: css.css({
      color: theme.colors.text.secondary,
      background: "transparent",
      border: `1px solid transparent`,
      "&:hover": {
        color: theme.colors.text.primary,
        background: theme.colors.action.hover
      }
    }),
    canvas: defaultOld,
    active: css.cx(
      defaultOld,
      css.css({
        "&::before": {
          display: "block",
          content: '" "',
          position: "absolute",
          left: 0,
          right: 0,
          height: "2px",
          bottom: 0,
          borderRadius: theme.shape.radius.default,
          backgroundImage: theme.colors.gradients.brandHorizontal
        }
      })
    ),
    primary: css.css(primaryVariant),
    destructive: css.css(destructiveVariant),
    narrow: css.css({
      padding: theme.spacing(0, 0.5)
    }),
    img: css.css({
      width: "16px",
      height: "16px",
      marginRight: theme.spacing(1)
    }),
    buttonFullWidth: css.css({
      flexGrow: 1
    }),
    content: css.css({
      display: "flex",
      flexGrow: 1
    }),
    contentWithIcon: css.css({
      display: "none",
      paddingLeft: theme.spacing(1),
      [`@media ${mediaUp(theme.v1.breakpoints.md)}`]: {
        display: "block"
      }
    }),
    contentWithRightIcon: css.css({
      paddingRight: theme.spacing(0.5)
    }),
    highlight: css.css({
      backgroundColor: theme.colors.success.main,
      borderRadius: theme.shape.radius.circle,
      width: "6px",
      height: "6px",
      position: "absolute",
      top: "-3px",
      right: "-3px",
      zIndex: 1
    })
  };
};

"use strict";
const ToolbarButtonRow = React.forwardRef(
  ({ alignment = "left", className, children, ...rest }, ref) => {
    const childrenWithoutNull = React.Children.toArray(children).filter((child) => child != null);
    const [childVisibility, setChildVisibility] = React.useState(Array(childrenWithoutNull.length).fill(false));
    const containerRef = React.useRef(null);
    const [showOverflowItems, setShowOverflowItems] = React.useState(false);
    const overflowRef = React.useRef(null);
    const overflowItemsRef = React.createRef();
    const { overlayProps } = overlays.useOverlay(
      {
        onClose: () => setShowOverflowItems(false),
        isDismissable: true,
        isOpen: showOverflowItems,
        shouldCloseOnInteractOutside: (element) => {
          var _a;
          const portalContainer = getPortalContainer();
          return !((_a = overflowRef.current) == null ? void 0 : _a.contains(element)) && !portalContainer.contains(element);
        }
      },
      overflowItemsRef
    );
    const { dialogProps } = dialog.useDialog({}, overflowItemsRef);
    const theme = useTheme2();
    const overflowButtonOrder = alignment === "left" ? childVisibility.indexOf(false) - 1 : childVisibility.length;
    const styles = getStyles$2d(theme, overflowButtonOrder, alignment);
    React.useLayoutEffect(() => {
      const intersectionObserver = new IntersectionObserver(
        (entries) => {
          entries.forEach((entry) => {
            if (entry.target instanceof HTMLElement && entry.target.parentNode) {
              const index = Array.prototype.indexOf.call(entry.target.parentNode.children, entry.target);
              setChildVisibility((prev) => {
                const newVisibility = [...prev];
                newVisibility[index] = entry.isIntersecting;
                return newVisibility;
              });
            }
          });
        },
        {
          threshold: 1,
          root: containerRef.current
        }
      );
      if (containerRef.current) {
        Array.from(containerRef.current.children).forEach((item) => {
          if (item instanceof HTMLElement && item !== overflowRef.current) {
            intersectionObserver.observe(item);
          }
        });
      }
      return () => intersectionObserver.disconnect();
    }, [children]);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: containerRef, className: css.cx(styles.container, className), ...rest, children: [
      childrenWithoutNull.map((child, index) => /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          style: { order: index, visibility: childVisibility[index] ? "visible" : "hidden" },
          className: styles.childWrapper,
          children: child
        },
        index
      )),
      childVisibility.includes(false) && /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: overflowRef, className: styles.overflowButton, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          ToolbarButton,
          {
            variant: showOverflowItems ? "active" : "default",
            tooltip: t("grafana-ui.toolbar-button-row.show-more", "Show more items"),
            onClick: () => setShowOverflowItems(!showOverflowItems),
            icon: "ellipsis-v",
            iconOnly: true,
            narrow: true
          }
        ),
        showOverflowItems && /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.overflowItems, ref: overflowItemsRef, ...overlayProps, ...dialogProps, children: childrenWithoutNull.map((child, index) => !childVisibility[index] && child) }) })
      ] })
    ] });
  }
);
ToolbarButtonRow.displayName = "ToolbarButtonRow";
const getStyles$2d = (theme, overflowButtonOrder, alignment) => ({
  overflowButton: css.css({
    order: overflowButtonOrder
  }),
  overflowItems: css.css({
    alignItems: "center",
    backgroundColor: theme.colors.background.primary,
    borderRadius: theme.shape.radius.default,
    boxShadow: theme.shadows.z2,
    display: "flex",
    flexWrap: "wrap",
    gap: theme.spacing(1),
    marginTop: theme.spacing(1),
    maxWidth: "80vw",
    padding: theme.spacing(0.5, 1),
    position: "absolute",
    right: 0,
    top: "100%",
    width: "max-content",
    zIndex: theme.zIndex.dropdown
  }),
  container: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1),
    justifyContent: alignment === "left" ? "flex-start" : "flex-end",
    minWidth: 0,
    position: "relative"
  }),
  childWrapper: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1)
  })
});

"use strict";

"use strict";
function PanelMenu({
  menu,
  title,
  placement = "bottom",
  offset,
  dragClassCancel,
  menuButtonClass,
  onOpenMenu
}) {
  const testId = title ? e2eSelectors.selectors.components.Panels.Panel.menu(title) : `panel-menu-button`;
  const handleVisibility = React.useCallback(
    (show) => {
      if (show && onOpenMenu) {
        onOpenMenu();
      }
    },
    [onOpenMenu]
  );
  return /* @__PURE__ */ jsxRuntime.jsx(Dropdown, { overlay: menu, placement, offset, onVisibleChange: handleVisibility, children: /* @__PURE__ */ jsxRuntime.jsx(
    ToolbarButton,
    {
      "aria-label": t("grafana-ui.panel-menu.label", "Menu for panel {{ title }}", { title: title != null ? title : "Untitled" }),
      title: t("grafana-ui.panel-menu.title", "Menu"),
      icon: "ellipsis-v",
      iconSize: "md",
      narrow: true,
      "data-testid": testId,
      className: css.cx(menuButtonClass, dragClassCancel)
    }
  ) });
}

"use strict";
function HoverWidget({ menu, title, dragClass, children, offset = -32, onOpenMenu }) {
  const styles = useStyles2(getStyles$2c);
  const draggableRef = React.useRef(null);
  const selectors = e2eSelectors.selectors.components.Panels.Panel.HoverWidget;
  const onPointerDown = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.setPointerCapture(e.pointerId);
  }, []);
  const onPointerUp = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.releasePointerCapture(e.pointerId);
  }, []);
  if (children === void 0 || React__namespace.Children.count(children) === 0) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, "show-on-hover"), style: { top: offset }, "data-testid": selectors.container, children: [
    dragClass && /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.square, styles.draggable, dragClass),
        onPointerDown,
        onPointerUp,
        ref: draggableRef,
        "data-testid": selectors.dragIcon,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "expand-arrows", className: styles.draggableIcon })
      }
    ),
    children,
    menu && /* @__PURE__ */ jsxRuntime.jsx(
      PanelMenu,
      {
        menu,
        title,
        placement: "bottom",
        menuButtonClass: styles.menuButton,
        onOpenMenu
      }
    )
  ] });
}
function getStyles$2c(theme) {
  return {
    container: css.css({
      label: "hover-container-widget",
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: `all .1s linear`
      },
      display: "flex",
      position: "absolute",
      zIndex: 1,
      right: 0,
      boxSizing: "content-box",
      alignItems: "center",
      background: theme.colors.background.secondary,
      color: theme.colors.text.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default,
      height: theme.spacing(4),
      boxShadow: theme.shadows.z1
    }),
    square: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: theme.spacing(4),
      height: "100%"
    }),
    draggable: css.css({
      cursor: "move",
      // mobile do not support draggable panels
      [theme.breakpoints.down("md")]: {
        display: "none"
      }
    }),
    menuButton: css.css({
      // Background and border are overriden when topnav toggle is disabled
      background: "inherit",
      border: "none",
      "&:hover": {
        background: theme.colors.secondary.main
      }
    }),
    draggableIcon: css.css({
      transform: "rotate(45deg)",
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
}

"use strict";
const TitleItem = React.forwardRef(
  ({ className, children, href, onClick, target, title, ...rest }, ref) => {
    const styles = useStyles2(getStyles$2b);
    if (href) {
      return /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          ref,
          href,
          onClick,
          target,
          title,
          className: css.cx(styles.linkItem, className),
          ...rest,
          children
        }
      );
    } else if (onClick) {
      return /* @__PURE__ */ jsxRuntime.jsx(Button, { ref, className: css.cx(styles.item, className), variant: "secondary", fill: "text", onClick, children });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx("span", { ref, className: css.cx(styles.item, className), ...rest, children });
    }
  }
);
TitleItem.displayName = "TitleItem";
const getStyles$2b = (theme) => {
  const item = css.css({
    color: `${theme.colors.text.secondary}`,
    label: "panel-header-item",
    cursor: "auto",
    border: "none",
    borderRadius: `${theme.shape.radius.default}`,
    padding: `${theme.spacing(0, 1)}`,
    height: `${theme.spacing(theme.components.panel.headerHeight)}`,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    "&:focus, &:focus-visible": {
      ...getFocusStyles(theme),
      zIndex: 1
    },
    "&: focus:not(:focus-visible)": getMouseFocusStyles(theme),
    "&:hover ": {
      boxShadow: `${theme.shadows.z1}`,
      background: `${theme.colors.background.secondary}`,
      color: `${theme.colors.text.primary}`
    }
  });
  return {
    item,
    linkItem: css.cx(item, css.css({ cursor: "pointer" }))
  };
};

"use strict";
function PanelDescription({ description, className }) {
  const styles = useStyles2(getStyles$2a);
  const getDescriptionContent = () => {
    const panelDescription = typeof description === "function" ? description() : description;
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: "panel-info-content markdown-html", children: /* @__PURE__ */ jsxRuntime.jsx("div", { dangerouslySetInnerHTML: { __html: panelDescription } }) });
  };
  return description !== "" ? /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { interactive: true, content: getDescriptionContent, children: /* @__PURE__ */ jsxRuntime.jsx(TitleItem, { className: css.cx(className, styles.description), children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "info-circle", size: "md" }) }) }) : null;
}
const getStyles$2a = (theme) => {
  return {
    description: css.css({
      code: {
        whiteSpace: "normal",
        wordWrap: "break-word"
      },
      "pre > code": {
        display: "block"
      }
    })
  };
};

"use strict";
function PanelStatus({ message, onClick, ariaLabel = "status" }) {
  const styles = useStyles2(getStyles$29);
  return /* @__PURE__ */ jsxRuntime.jsx(
    ToolbarButton,
    {
      className: styles.buttonStyles,
      onClick,
      variant: "destructive",
      icon: "exclamation-triangle",
      iconSize: "md",
      tooltip: message || "",
      "aria-label": ariaLabel,
      "data-testid": e2eSelectors.selectors.components.Panels.Panel.status("error")
    }
  );
}
const getStyles$29 = (theme) => {
  const { headerHeight, padding } = theme.components.panel;
  return {
    buttonStyles: css.css({
      label: "panel-header-state-button",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      padding: theme.spacing(padding),
      width: theme.spacing(headerHeight),
      height: theme.spacing(headerHeight),
      borderRadius: theme.shape.radius.default
    })
  };
};

"use strict";
function PanelChrome$1({
  width,
  height,
  children,
  padding = "md",
  title = "",
  description = "",
  displayMode = "default",
  titleItems,
  menu,
  dragClass,
  dragClassCancel,
  hoverHeader = false,
  hoverHeaderOffset,
  loadingState,
  statusMessage,
  statusMessageOnClick,
  leftItems,
  actions,
  selectionId,
  onCancelQuery,
  onOpenMenu,
  collapsible = false,
  collapsed,
  onToggleCollapse,
  onFocus,
  onMouseMove,
  onMouseEnter,
  onDragStart,
  showMenuAlways = false
}) {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$28);
  const panelContentId = React.useId();
  const panelTitleId = React.useId().replace(/:/g, "_");
  const { isSelected, onSelect, isSelectable } = useElementSelection(selectionId);
  const pointerDistance = usePointerDistance();
  const hasHeader = !hoverHeader;
  const [isOpen, toggleOpen] = reactUse.useToggle(true);
  const [selectableHighlight, setSelectableHighlight] = React.useState(false);
  const onHeaderEnter = React__namespace.useCallback(() => setSelectableHighlight(true), []);
  const onHeaderLeave = React__namespace.useCallback(() => setSelectableHighlight(false), []);
  if (collapsed === void 0) {
    collapsed = !isOpen;
  }
  const showOnHoverClass = showMenuAlways ? "always-show" : "show-on-hover";
  const isPanelTransparent = displayMode === "transparent";
  const headerHeight = getHeaderHeight(theme, hasHeader);
  const { contentStyle, innerWidth, innerHeight } = getContentStyle(
    padding,
    theme,
    headerHeight,
    collapsed,
    height,
    width
  );
  const headerStyles = {
    height: headerHeight,
    cursor: dragClass ? "move" : "auto"
  };
  const containerStyles = { width, height: collapsed ? void 0 : height };
  const [ref, { width: loadingBarWidth }] = reactUse.useMeasure();
  if (leftItems) {
    actions = leftItems;
  }
  const testid = typeof title === "string" ? e2eSelectors.selectors.components.Panels.Panel.title(title) : "Panel";
  const onPointerUp = React__namespace.useCallback(
    (evt) => {
      if (pointerDistance.check(evt) || dragClassCancel && evt.target instanceof Element && evt.target.closest(`.${dragClassCancel}`)) {
        return;
      }
      setTimeout(() => onSelect == null ? void 0 : onSelect(evt));
    },
    [dragClassCancel, onSelect, pointerDistance]
  );
  const onPointerDown = React__namespace.useCallback(
    (evt) => {
      evt.stopPropagation();
      pointerDistance.set(evt);
      onDragStart == null ? void 0 : onDragStart(evt);
    },
    [pointerDistance, onDragStart]
  );
  const onContentPointerDown = React__namespace.useCallback(
    (evt) => {
      if (evt.target instanceof Element && evt.target.closest("button,a,canvas,svg")) {
        return;
      }
      onSelect == null ? void 0 : onSelect(evt);
    },
    [onSelect]
  );
  const headerContent = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    !collapsible && title && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.title, children: /* @__PURE__ */ jsxRuntime.jsx(
      Text,
      {
        element: "h2",
        variant: "h6",
        truncate: true,
        title: typeof title === "string" ? title : void 0,
        id: panelTitleId,
        children: title
      }
    ) }),
    collapsible && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.title, children: /* @__PURE__ */ jsxRuntime.jsx(Text, { element: "h2", variant: "h6", children: /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        type: "button",
        className: styles.clearButtonStyles,
        onClick: () => {
          toggleOpen();
          if (onToggleCollapse) {
            onToggleCollapse(!collapsed);
          }
        },
        "aria-expanded": !collapsed,
        "aria-controls": !collapsed ? panelContentId : void 0,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            Icon,
            {
              name: !collapsed ? "angle-down" : "angle-right",
              "aria-hidden": !!title,
              "aria-label": !title ? "toggle collapse panel" : void 0
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(Text, { variant: "h6", truncate: true, id: panelTitleId, children: title })
        ]
      }
    ) }) }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.titleItems, dragClassCancel), "data-testid": "title-items-container", children: [
      /* @__PURE__ */ jsxRuntime.jsx(PanelDescription, { description, className: dragClassCancel }),
      titleItems
    ] }),
    loadingState === data.LoadingState.Streaming && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: onCancelQuery ? "Stop streaming" : "Streaming", children: /* @__PURE__ */ jsxRuntime.jsx(TitleItem, { className: dragClassCancel, "data-testid": "panel-streaming", onClick: onCancelQuery, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "circle-mono", size: "md", className: styles.streaming }) }) }),
    loadingState === data.LoadingState.Loading && onCancelQuery && /* @__PURE__ */ jsxRuntime.jsx(DelayRender, { delay: 2e3, children: /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: "Cancel query", children: /* @__PURE__ */ jsxRuntime.jsx(
      TitleItem,
      {
        className: css.cx(dragClassCancel, styles.pointer),
        "data-testid": "panel-cancel-query",
        onClick: onCancelQuery,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "sync-slash", size: "md" })
      }
    ) }) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.rightAligned, children: actions && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.rightActions, children: itemsRenderer(actions, (item) => item) }) })
  ] });
  return (
    // tabIndex={0} is needed for keyboard accessibility in the plot area
    /* @__PURE__ */ jsxRuntime.jsxs(
      "section",
      {
        className: css.cx(
          styles.container,
          isPanelTransparent && styles.transparentContainer,
          isSelected && "dashboard-selected-element",
          !isSelected && isSelectable && selectableHighlight && "dashboard-selectable-element"
        ),
        style: containerStyles,
        "aria-labelledby": !!title ? panelTitleId : void 0,
        "data-testid": testid,
        tabIndex: 0,
        onFocus,
        onMouseMove,
        onMouseEnter,
        ref,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.loadingBarContainer, children: loadingState === data.LoadingState.Loading ? /* @__PURE__ */ jsxRuntime.jsx(LoadingBar, { width: loadingBarWidth, ariaLabel: "Panel loading bar" }) : null }),
          hoverHeader && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              HoverWidget,
              {
                menu,
                title: typeof title === "string" ? title : void 0,
                offset: hoverHeaderOffset,
                dragClass,
                onOpenMenu,
                children: headerContent
              }
            ),
            statusMessage && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.errorContainerFloating, children: /* @__PURE__ */ jsxRuntime.jsx(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" }) })
          ] }),
          hasHeader && /* @__PURE__ */ jsxRuntime.jsxs(
            "div",
            {
              className: css.cx(styles.headerContainer, dragClass),
              style: headerStyles,
              "data-testid": "header-container",
              onPointerDown,
              onMouseEnter: isSelectable ? onHeaderEnter : void 0,
              onMouseLeave: isSelectable ? onHeaderLeave : void 0,
              onPointerUp,
              children: [
                statusMessage && /* @__PURE__ */ jsxRuntime.jsx("div", { className: dragClassCancel, children: /* @__PURE__ */ jsxRuntime.jsx(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" }) }),
                headerContent,
                menu && /* @__PURE__ */ jsxRuntime.jsx(
                  PanelMenu,
                  {
                    menu,
                    title: typeof title === "string" ? title : void 0,
                    placement: "bottom-end",
                    menuButtonClass: css.cx(styles.menuItem, dragClassCancel, showOnHoverClass),
                    onOpenMenu
                  }
                )
              ]
            }
          ),
          !collapsed && /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              id: panelContentId,
              "data-testid": e2eSelectors.selectors.components.Panels.Panel.content,
              className: css.cx(styles.content, height === void 0 && styles.containNone),
              style: contentStyle,
              onPointerDown: onContentPointerDown,
              children: typeof children === "function" ? children(innerWidth, innerHeight) : children
            }
          )
        ]
      }
    )
  );
}
const itemsRenderer = (items, renderer) => {
  const toRender = React__namespace.Children.toArray(items).filter(Boolean);
  return toRender.length > 0 ? renderer(toRender) : null;
};
const getHeaderHeight = (theme, hasHeader) => {
  if (hasHeader) {
    return theme.spacing.gridSize * theme.components.panel.headerHeight;
  }
  return 0;
};
const getContentStyle = (padding, theme, headerHeight, collapsed, height, width) => {
  const chromePadding = (padding === "md" ? theme.components.panel.padding : 0) * theme.spacing.gridSize;
  const panelPadding = chromePadding * 2;
  const panelBorder = 1 * 2;
  let innerWidth = 0;
  if (width) {
    innerWidth = width - panelPadding - panelBorder;
  }
  let innerHeight = 0;
  if (height) {
    innerHeight = height - headerHeight - panelPadding - panelBorder;
  }
  if (collapsed) {
    innerHeight = headerHeight;
  }
  const contentStyle = {
    padding: chromePadding
  };
  return { contentStyle, innerWidth, innerHeight };
};
const getStyles$28 = (theme) => {
  const { background, borderColor, padding } = theme.components.panel;
  return {
    container: css.css({
      label: "panel-container",
      backgroundColor: background,
      border: `1px solid ${borderColor}`,
      position: "relative",
      borderRadius: theme.shape.radius.default,
      height: "100%",
      display: "flex",
      flexDirection: "column",
      ".always-show": {
        background: "none",
        "&:focus-visible, &:hover": {
          background: theme.colors.secondary.shade
        }
      },
      ".show-on-hover": {
        opacity: "0",
        visibility: "hidden"
      },
      "&:focus-visible, &:hover": {
        // only show menu icon on hover or focused panel
        ".show-on-hover": {
          opacity: "1",
          visibility: "visible"
        }
      },
      "&:focus-visible": getFocusStyles(theme),
      // The not:(:focus) clause is so that this rule is only applied when decendants are focused (important otherwise the hover header is visible when panel is clicked).
      "&:focus-within:not(:focus)": {
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      }
    }),
    transparentContainer: css.css({
      label: "panel-transparent-container",
      backgroundColor: "transparent",
      border: "1px solid transparent",
      boxSizing: "border-box",
      "&:hover": {
        border: `1px solid ${borderColor}`
      }
    }),
    loadingBarContainer: css.css({
      label: "panel-loading-bar-container",
      position: "absolute",
      top: 0,
      width: "100%",
      // this is to force the loading bar container to create a new stacking context
      // otherwise, in webkit browsers on windows/linux, the aliasing of panel text changes when the loading bar is shown
      // see https://github.com/grafana/grafana/issues/88104
      zIndex: 1
    }),
    containNone: css.css({
      contain: "none"
    }),
    content: css.css({
      label: "panel-content",
      flexGrow: 1,
      contain: "size layout"
    }),
    headerContainer: css.css({
      label: "panel-header",
      display: "flex",
      alignItems: "center"
    }),
    pointer: css.css({
      cursor: "pointer"
    }),
    streaming: css.css({
      label: "panel-streaming",
      marginRight: 0,
      color: theme.colors.success.text,
      "&:hover": {
        color: theme.colors.success.text
      }
    }),
    title: css.css({
      label: "panel-title",
      display: "flex",
      padding: theme.spacing(0, padding),
      minWidth: 0,
      "& > h2": {
        minWidth: 0
      }
    }),
    items: css.css({
      display: "flex"
    }),
    item: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center"
    }),
    hiddenMenu: css.css({
      visibility: "hidden"
    }),
    menuItem: css.css({
      label: "panel-menu",
      border: "none",
      background: theme.colors.secondary.main,
      "&:hover": {
        background: theme.colors.secondary.shade
      }
    }),
    errorContainerFloating: css.css({
      label: "error-container",
      position: "absolute",
      left: 0,
      top: 0,
      zIndex: 1
    }),
    rightActions: css.css({
      display: "flex",
      padding: theme.spacing(0, padding),
      gap: theme.spacing(1)
    }),
    rightAligned: css.css({
      label: "right-aligned-container",
      marginLeft: "auto",
      display: "flex",
      alignItems: "center"
    }),
    titleItems: css.css({
      display: "flex",
      height: "100%"
    }),
    clearButtonStyles: css.css({
      alignItems: "center",
      display: "flex",
      gap: theme.spacing(0.5),
      background: "transparent",
      border: "none",
      padding: 0,
      maxWidth: "100%"
    })
  };
};

"use strict";
const PanelContextRoot = React.createContext({
  eventsScope: "global",
  eventBus: new data.EventBusSrv()
});
const PanelContextProvider = PanelContextRoot.Provider;
const usePanelContext = () => React.useContext(PanelContextRoot);

"use strict";
var SeriesVisibilityChangeMode = /* @__PURE__ */ ((SeriesVisibilityChangeMode2) => {
  SeriesVisibilityChangeMode2["ToggleSelection"] = "select";
  SeriesVisibilityChangeMode2["AppendToSelection"] = "append";
  return SeriesVisibilityChangeMode2;
})(SeriesVisibilityChangeMode || {});

"use strict";
const PanelChrome = PanelChrome$1;
PanelChrome.LoadingIndicator = LoadingIndicator;
PanelChrome.TitleItem = TitleItem;

"use strict";
function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const styles = useStyles2(getStyles$27);
  const theme = useTheme2();
  const middleware = [
    react$1.offset(8),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: true,
    placement,
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react$1.useTransitionStyles(context, {
    initial: ({ side }) => {
      return {
        opacity: 0,
        transform: getInitialTransform(side, theme)
      };
    },
    duration: theme.transitions.duration.shortest
  });
  return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { style: { display: "inline-block", ...floatingStyles }, ref: refs.setFloating, "aria-live": "polite", children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: css.cx(styles.root), style: placementStyles, children: [
    children && /* @__PURE__ */ jsxRuntime.jsx("span", { children }),
    suffixIcon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: suffixIcon })
  ] }) }) });
}
const getStyles$27 = (theme) => {
  return {
    root: css.css({
      ...theme.typography.bodySmall,
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: theme.shape.radius.pill,
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    })
  };
};
const getInitialTransform = (placement, theme) => {
  const gap = 1;
  switch (placement) {
    case "top":
      return `translateY(${theme.spacing(gap)})`;
    case "bottom":
      return `translateY(-${theme.spacing(gap)})`;
    case "left":
      return `translateX(${theme.spacing(gap)})`;
    case "right":
      return `translateX(-${theme.spacing(gap)})`;
  }
};

"use strict";
const SHOW_SUCCESS_DURATION$1 = 2 * 1e3;
function ClipboardButton({
  onClipboardCopy,
  onClipboardError,
  children,
  getText,
  icon,
  variant,
  ...buttonProps
}) {
  const styles = useStyles2(getStyles$26);
  const [showCopySuccess, setShowCopySuccess] = React.useState(false);
  React.useEffect(() => {
    let timeoutId;
    if (showCopySuccess) {
      timeoutId = setTimeout(() => {
        setShowCopySuccess(false);
      }, SHOW_SUCCESS_DURATION$1);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [showCopySuccess]);
  const buttonRef = React.useRef(null);
  const copyTextCallback = React.useCallback(async () => {
    const textToCopy = getText();
    try {
      await copyText(textToCopy, buttonRef);
      setShowCopySuccess(true);
      onClipboardCopy == null ? void 0 : onClipboardCopy(textToCopy);
    } catch (e) {
      onClipboardError == null ? void 0 : onClipboardError(textToCopy, e);
    }
  }, [getText, onClipboardCopy, onClipboardError]);
  const copiedText = t("clipboard-button.inline-toast.success", "Copied");
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    showCopySuccess && /* @__PURE__ */ jsxRuntime.jsx(InlineToast, { placement: "top", referenceElement: buttonRef.current, children: copiedText }),
    /* @__PURE__ */ jsxRuntime.jsxs(
      Button,
      {
        onClick: copyTextCallback,
        icon,
        variant: showCopySuccess ? "success" : variant,
        "aria-label": showCopySuccess ? copiedText : void 0,
        ...buttonProps,
        className: css.cx(styles.button, showCopySuccess && styles.successButton, buttonProps.className),
        ref: buttonRef,
        children: [
          children,
          showCopySuccess && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.successOverlay, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check" }) })
        ]
      }
    )
  ] });
}
const copyText = async (text, buttonRef) => {
  var _a;
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text);
  } else {
    const textarea = document.createElement("textarea");
    (_a = buttonRef.current) == null ? void 0 : _a.appendChild(textarea);
    textarea.value = text;
    textarea.focus();
    textarea.select();
    document.execCommand("copy");
    textarea.remove();
  }
};
const getStyles$26 = (theme) => {
  return {
    button: css.css({
      position: "relative"
    }),
    successButton: css.css({
      "> *": css.css({
        visibility: "hidden"
      })
    }),
    successOverlay: css.css({
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      left: 0,
      visibility: "visible"
      // re-visible the overlay
    })
  };
};

"use strict";
const getDragStyles = (theme, handlePosition) => {
  const position = handlePosition || "middle";
  const baseColor = theme.colors.emphasize(theme.colors.background.secondary, 0.15);
  const hoverColor = theme.colors.primary.border;
  const clickTargetSize = theme.spacing(2);
  const handlebarThickness = 4;
  const handlebarWidth = 200;
  let verticalOffset = "50%";
  let horizontalOffset = "50%";
  switch (position) {
    case "start": {
      verticalOffset = "0%";
      horizontalOffset = "0%";
      break;
    }
    case "end": {
      verticalOffset = "100%";
      horizontalOffset = "100%";
      break;
    }
  }
  const dragHandleBase = css.css({
    position: "relative",
    "&:before": {
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("border-color"),
      zIndex: 1
    },
    "&:after": {
      background: baseColor,
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("background"),
      transform: "translate(-50%, -50%)",
      borderRadius: theme.shape.radius.pill,
      zIndex: 1
    },
    "&:hover": {
      "&:before": {
        borderColor: hoverColor
      },
      "&:after": {
        background: hoverColor
      }
    }
  });
  const beforeVertical = {
    borderRight: "1px solid transparent",
    height: "100%",
    left: verticalOffset,
    transform: "translateX(-50%)"
  };
  const beforeHorizontal = {
    borderTop: "1px solid transparent",
    top: horizontalOffset,
    transform: "translateY(-50%)"
  };
  return {
    dragHandleVertical: css.cx(
      dragHandleBase,
      css.css({
        cursor: "col-resize",
        width: clickTargetSize,
        "&:before": beforeVertical,
        "&:after": {
          left: verticalOffset,
          top: "50%",
          height: handlebarWidth,
          width: handlebarThickness
        }
      })
    ),
    dragHandleHorizontal: css.cx(
      dragHandleBase,
      css.css({
        height: clickTargetSize,
        cursor: "row-resize",
        "&:before": beforeHorizontal,
        "&:after": {
          left: "50%",
          top: horizontalOffset,
          height: handlebarThickness,
          width: handlebarWidth
        }
      })
    ),
    dragHandleBaseVertical: css.cx(
      dragHandleBase,
      css.css({
        cursor: "col-resize",
        width: clickTargetSize,
        "&:before": beforeVertical
      })
    ),
    dragHandleBaseHorizontal: css.cx(
      dragHandleBase,
      css.css({
        cursor: "row-resize",
        height: clickTargetSize,
        "&:before": beforeHorizontal
      })
    )
  };
};

"use strict";
const IconButton = React__namespace.forwardRef((props, ref) => {
  const { size = "md", variant = "secondary" } = props;
  let limitedIconSize;
  if (size === "xxl" || size === "xxxl") {
    data.deprecationWarning("IconButton", 'size="xxl" and size="xxxl"', 'size="xl"');
    limitedIconSize = "xl";
  } else {
    limitedIconSize = size;
  }
  const styles = useStyles2(getStyles$25, limitedIconSize, variant);
  let ariaLabel;
  let buttonRef;
  if ("tooltip" in props) {
    const { tooltip } = props;
    ariaLabel = typeof tooltip === "string" ? tooltip : void 0;
  } else if ("ariaLabel" in props || "aria-label" in props) {
    const { ariaLabel: deprecatedAriaLabel, ["aria-label"]: ariaLabelProp } = props;
    ariaLabel = ariaLabelProp || deprecatedAriaLabel;
    buttonRef = ref;
  }
  if ("tooltip" in props) {
    const { name, iconType, className, tooltip, tooltipPlacement, ...restProps } = props;
    return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: /* @__PURE__ */ jsxRuntime.jsx(
      "button",
      {
        ...restProps,
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button",
        children: /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon: name, size: limitedIconSize, className: styles.icon, iconType })
      }
    ) });
  } else {
    const { name, iconType, className, ...restProps } = props;
    return /* @__PURE__ */ jsxRuntime.jsx(
      "button",
      {
        ...restProps,
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button",
        children: /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon: name, size: limitedIconSize, className: styles.icon, iconType })
      }
    );
  }
});
IconButton.displayName = "IconButton";
const getStyles$25 = (theme, size, variant) => {
  const hoverSize = getSvgSize(size) + theme.spacing.gridSize;
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css.css({
      zIndex: 0,
      position: "relative",
      margin: `0 ${theme.spacing.x0_5} 0 0`,
      boxShadow: "none",
      border: "none",
      display: "inline-flex",
      background: "transparent",
      justifyContent: "center",
      alignItems: "center",
      padding: 0,
      color: iconColor,
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        color: theme.colors.action.disabledText,
        opacity: 0.65
      },
      "&:before": {
        zIndex: -1,
        position: "absolute",
        opacity: 0,
        width: `${hoverSize}px`,
        height: `${hoverSize}px`,
        borderRadius: theme.shape.radius.default,
        content: '""',
        [theme.transitions.handleMotion("no-preference", "reduce")]: {
          transitionDuration: "0.2s",
          transitionTimingFunction: "cubic-bezier(0.4, 0, 0.2, 1)",
          transitionProperty: "opacity"
        }
      },
      "&:focus, &:focus-visible": getFocusStyles(theme),
      "&:focus:not(:focus-visible)": getMouseFocusStyles(theme),
      "&:hover": {
        "&:before": {
          backgroundColor: variant === "secondary" ? theme.colors.action.hover : data.colorManipulator.alpha(iconColor, 0.12),
          opacity: 1
        }
      }
    }),
    icon: css.css({
      verticalAlign: "baseline"
    })
  };
};

"use strict";
const ScrollIndicators$1 = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$24);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
          [styles.scrollIndicatorVisible]: showScrollTopIndicator
        }),
        role: "presentation"
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.scrollContent, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollTopMarker, className: css.cx(styles.scrollMarker, styles.scrollTopMarker) }),
      children,
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollBottomMarker, className: css.cx(styles.scrollMarker, styles.scrollBottomMarker) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
          [styles.scrollIndicatorVisible]: showScrollBottomIndicator
        }),
        role: "presentation"
      }
    )
  ] });
};
const getStyles$24 = (theme) => {
  const scrollGradientColor = `rgba(0, 0, 0, ${theme.isDark ? 0.25 : 0.08})`;
  return {
    scrollContent: css.css({
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: `max(5%, ${theme.spacing(3)})`,
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create("opacity")
      },
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${scrollGradientColor})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${scrollGradientColor})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    }),
    scrollMarker: css.css({
      height: "1px",
      left: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0
    }),
    scrollTopMarker: css.css({
      top: 0
    }),
    scrollBottomMarker: css.css({
      bottom: 0
    })
  };
};

"use strict";
const ScrollContainer = React.forwardRef(
  ({
    children,
    showScrollIndicators = false,
    onScroll,
    overflowX = "auto",
    overflowY = "auto",
    scrollbarWidth = "thin",
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles$23, scrollbarWidth, overflowY, overflowX);
    const defaults = {
      maxHeight: "100%",
      minHeight: 0,
      minWidth: 0
    };
    const boxProps = { ...defaults, ...rest };
    return /* @__PURE__ */ jsxRuntime.jsx(Box, { ...boxProps, display: "flex", direction: "column", flex: 1, position: "relative", children: /* @__PURE__ */ jsxRuntime.jsx("div", { onScroll, className: styles.scroller, ref, children: showScrollIndicators ? /* @__PURE__ */ jsxRuntime.jsx(ScrollIndicators$1, { children }) : children }) });
  }
);
ScrollContainer.displayName = "ScrollContainer";
const getStyles$23 = (theme, scrollbarWidth, overflowY, overflowX) => ({
  scroller: css.css({
    display: "flex",
    flex: 1,
    flexDirection: "column",
    overflowX,
    overflowY,
    scrollbarWidth
  })
});

"use strict";
const drawerSizes = {
  sm: { width: "25vw", minWidth: 384 },
  md: { width: "50vw", minWidth: 568 },
  lg: { width: "75vw", minWidth: 744 }
};
function Drawer({
  children,
  onClose,
  closeOnMaskClick = true,
  scrollableContent = true,
  title,
  subtitle,
  width,
  size = "md",
  tabs
}) {
  var _a;
  const [drawerWidth, onMouseDown, onTouchStart] = useResizebleDrawer();
  const styles = useStyles2(getStyles$22);
  const wrapperStyles = useStyles2(getWrapperStyles, size);
  const dragStyles = useStyles2(getDragStyles);
  const overlayRef = React__namespace.useRef(null);
  const { dialogProps, titleProps } = dialog.useDialog({}, overlayRef);
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: false,
      isOpen: true,
      onClose
    },
    overlayRef
  );
  useBodyClassWhileOpen();
  const content = /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.content, children });
  const overrideWidth = (_a = drawerWidth != null ? drawerWidth : width) != null ? _a : drawerSizes[size].width;
  const minWidth = drawerSizes[size].minWidth;
  return /* @__PURE__ */ jsxRuntime.jsx(
    RcDrawer__default.default,
    {
      open: true,
      onClose,
      placement: "right",
      getContainer: ".main-view",
      className: styles.drawerContent,
      rootClassName: styles.drawer,
      classNames: {
        wrapper: wrapperStyles
      },
      styles: {
        wrapper: {
          width: overrideWidth,
          minWidth
        }
      },
      width: "",
      motion: {
        motionAppear: true,
        motionName: styles.drawerMotion
      },
      maskClassName: styles.mask,
      maskClosable: closeOnMaskClick,
      maskMotion: {
        motionAppear: true,
        motionName: styles.maskMotion
      },
      children: /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { restoreFocus: true, contain: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          "aria-label": typeof title === "string" ? e2eSelectors.selectors.components.Drawer.General.title(title) : e2eSelectors.selectors.components.Drawer.General.title("no title"),
          className: styles.container,
          ...overlayProps,
          ...dialogProps,
          ref: overlayRef,
          children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                className: css.cx(dragStyles.dragHandleVertical, styles.resizer),
                onMouseDown,
                onTouchStart
              }
            ),
            typeof title === "string" && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.header, Boolean(tabs) && styles.headerWithTabs), children: [
              /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.actions, children: /* @__PURE__ */ jsxRuntime.jsx(
                IconButton,
                {
                  name: "times",
                  variant: "secondary",
                  onClick: onClose,
                  "data-testid": e2eSelectors.selectors.components.Drawer.General.close,
                  tooltip: t(`grafana-ui.drawer.close`, "Close")
                }
              ) }),
              /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.titleWrapper, children: [
                /* @__PURE__ */ jsxRuntime.jsx(Text, { element: "h3", ...titleProps, children: title }),
                subtitle && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.subtitle, "data-testid": e2eSelectors.selectors.components.Drawer.General.subtitle, children: subtitle }),
                tabs && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.tabsWrapper, children: tabs })
              ] })
            ] }),
            typeof title !== "string" && title,
            !scrollableContent ? content : /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { showScrollIndicators: true, children: content })
          ]
        }
      ) })
    }
  );
}
function useResizebleDrawer() {
  const [drawerWidth, setDrawerWidth] = React.useState(void 0);
  const onMouseMove = React.useCallback((e) => {
    setDrawerWidth(getCustomDrawerWidth(e.clientX));
  }, []);
  const onTouchMove = React.useCallback((e) => {
    const touch = e.touches[0];
    setDrawerWidth(getCustomDrawerWidth(touch.clientX));
  }, []);
  const onMouseUp = React.useCallback(
    (e) => {
      document.removeEventListener("mousemove", onMouseMove);
      document.removeEventListener("mouseup", onMouseUp);
    },
    [onMouseMove]
  );
  const onTouchEnd = React.useCallback(
    (e) => {
      document.removeEventListener("touchmove", onTouchMove);
      document.removeEventListener("touchend", onTouchEnd);
    },
    [onTouchMove]
  );
  function onMouseDown(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("mousemove", onMouseMove);
    document.addEventListener("mouseup", onMouseUp);
  }
  function onTouchStart(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("touchmove", onTouchMove);
    document.addEventListener("touchend", onTouchEnd);
  }
  return [drawerWidth, onMouseDown, onTouchStart];
}
function getCustomDrawerWidth(clientX) {
  let offsetRight = document.body.offsetWidth - (clientX - document.body.offsetLeft);
  let widthPercent = Math.min(offsetRight / document.body.clientWidth * 100, 98).toFixed(2);
  return `${widthPercent}vw`;
}
function useBodyClassWhileOpen() {
  React.useEffect(() => {
    if (!document.body) {
      return;
    }
    document.body.classList.add("body-drawer-open");
    return () => {
      document.body.classList.remove("body-drawer-open");
    };
  }, []);
}
const getStyles$22 = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column",
      height: "100%",
      flex: "1 1 0",
      minHeight: "100%",
      position: "relative"
    }),
    drawer: css.css({
      top: 0,
      ".rc-drawer-content-wrapper": {
        boxShadow: theme.shadows.z3
      }
    }),
    drawerContent: css.css({
      backgroundColor: `${theme.colors.background.primary} !important`,
      display: "flex",
      overflow: "unset !important",
      flexDirection: "column"
    }),
    drawerMotion: css.css({
      "&-appear": {
        transform: "translateX(100%)",
        transition: "none !important",
        "&-active": {
          transition: `${theme.transitions.create("transform")} !important`,
          transform: "translateX(0)"
        }
      }
    }),
    // we want the mask itself to span the whole page including the top bar
    // this ensures trying to click something in the top bar will close the drawer correctly
    // but we don't want the backdrop styling to apply over the top bar as it looks weird
    // instead have a child pseudo element to apply the backdrop styling below the top bar
    mask: css.css({
      // The !important here is to override the default .rc-drawer-mask styles
      backgroundColor: "transparent !important",
      // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
      position: "fixed !important",
      "&:before": {
        backgroundColor: `${theme.components.overlay.background} !important`,
        bottom: 0,
        content: '""',
        left: 0,
        position: "fixed",
        right: 0,
        top: 0
      }
    }),
    maskMotion: css.css({
      "&-appear": {
        opacity: 0,
        "&-active": {
          opacity: 1,
          transition: theme.transitions.create("opacity")
        }
      }
    }),
    header: css.css({
      label: "drawer-header",
      flexGrow: 0,
      padding: theme.spacing(2, 2, 3),
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    headerWithTabs: css.css({
      borderBottom: "none"
    }),
    actions: css.css({
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1)
    }),
    titleWrapper: css.css({
      label: "drawer-title",
      overflowWrap: "break-word"
    }),
    subtitle: css.css({
      label: "drawer-subtitle",
      color: theme.colors.text.secondary,
      paddingTop: theme.spacing(1)
    }),
    content: css.css({
      padding: theme.spacing(2),
      height: "100%",
      flexGrow: 1,
      minHeight: 0
    }),
    tabsWrapper: css.css({
      label: "drawer-tabs",
      paddingLeft: theme.spacing(2),
      margin: theme.spacing(1, -1, -3, -3)
    }),
    resizer: css.css({
      top: 0,
      left: theme.spacing(-1),
      bottom: 0,
      position: "absolute",
      zIndex: theme.zIndex.modal
    })
  };
};
function getWrapperStyles(theme, size) {
  return css.css({
    label: `drawer-content-wrapper-${size}`,
    overflow: "unset !important",
    [theme.breakpoints.down("md")]: {
      width: `calc(100% - ${theme.spacing(2)}) !important`,
      minWidth: "0 !important"
    }
  });
}

"use strict";
const useAsyncDependency = (importStatement) => {
  const state = reactUse.useAsync(async () => {
    return await importStatement;
  });
  return {
    ...state,
    dependency: state.value
  };
};

"use strict";
const ErrorWithStack = ({ error, errorInfo, title }) => {
  const style = useStyles2(getStyles$21);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style, children: [
    /* @__PURE__ */ jsxRuntime.jsx("h2", { children: title }),
    /* @__PURE__ */ jsxRuntime.jsxs("details", { style: { whiteSpace: "pre-wrap" }, children: [
      error && error.toString(),
      /* @__PURE__ */ jsxRuntime.jsx("br", {}),
      errorInfo && errorInfo.componentStack
    ] })
  ] });
};
ErrorWithStack.displayName = "ErrorWithStack";
const getStyles$21 = () => {
  return css.css({
    width: "500px",
    margin: "64px auto"
  });
};

"use strict";

"use strict";

"use strict";
var CompletionItemKind = /* @__PURE__ */ ((CompletionItemKind2) => {
  CompletionItemKind2["GroupTitle"] = "GroupTitle";
  return CompletionItemKind2;
})(CompletionItemKind || {});

"use strict";

"use strict";
const isIconSize = (value) => {
  return ["xs", "sm", "md", "lg", "xl", "xxl", "xxxl"].includes(value);
};
const getAvailableIcons = () => Object.keys(data.availableIconsIndex);
function getFieldTypeIcon(field) {
  return getFieldTypeIconName(field == null ? void 0 : field.type);
}
function getFieldTypeIconName(type) {
  if (type) {
    switch (type) {
      case data.FieldType.time:
        return "clock-nine";
      case data.FieldType.string:
        return "font";
      case data.FieldType.number:
        return "calculator-alt";
      case data.FieldType.boolean:
        return "toggle-on";
      case data.FieldType.trace:
        return "info-circle";
      case data.FieldType.enum:
        return "list-ol";
      case data.FieldType.geo:
        return "map-marker";
      case data.FieldType.other:
        return "brackets-curly";
    }
  }
  return "question-circle";
}

"use strict";

"use strict";

"use strict";

"use strict";

"use strict";
const Spinner = ({
  className,
  inline = false,
  iconClassName,
  style,
  size = "md"
}) => {
  const styles = useStyles2(getStyles$20);
  const deprecatedStyles = useStyles2(getDeprecatedStyles, size);
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  const iconName = prefersReducedMotion ? "hourglass" : "spinner";
  if (typeof size !== "string" || !isIconSize(size)) {
    const iconRoot = getIconRoot();
    const subDir = getIconSubDir(iconName, "default");
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        "data-testid": "Spinner",
        style,
        className: css.cx(
          {
            [styles.inline]: inline
          },
          deprecatedStyles.wrapper,
          className
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          SVG__default.default,
          {
            src: svgPath,
            width: size,
            height: size,
            className: css.cx(styles.spin, deprecatedStyles.icon, className),
            style
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      "data-testid": "Spinner",
      style,
      className: css.cx(
        {
          [styles.inline]: inline
        },
        className
      ),
      children: /* @__PURE__ */ jsxRuntime.jsx(
        Icon,
        {
          className: css.cx(styles.spin, iconClassName),
          name: iconName,
          size,
          "aria-label": t("grafana-ui.spinner.aria-label", "Loading")
        }
      )
    }
  );
};
const getStyles$20 = (theme) => ({
  inline: css.css({
    display: "inline-block"
  }),
  spin: css.css({
    [theme.transitions.handleMotion("no-preference")]: {
      animation: `${spin$1} 2s infinite linear`
    }
  })
});
const getDeprecatedStyles = (theme, size) => ({
  wrapper: css.css({
    fontSize: typeof size === "string" ? size : `${size}px`
  }),
  icon: css.css({
    display: "inline-block",
    fill: "currentColor",
    flexShrink: 0,
    label: "Icon",
    // line-height: 0; is needed for correct icon alignment in Safari
    lineHeight: 0,
    verticalAlign: "middle"
  })
});

"use strict";
const LoadingPlaceholder = ({ text, className, ...rest }) => {
  const styles = useStyles2(getStyles$1$);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, className), ...rest, children: [
    text,
    " ",
    /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true })
  ] });
};
const getStyles$1$ = (theme) => {
  return {
    container: css.css({
      marginBottom: theme.spacing(4)
    })
  };
};

"use strict";
const ReactMonacoEditorLazy = (props) => {
  var _a, _b;
  const styles = useStyles2(getStyles$1_);
  const { loading, error, dependency } = useAsyncDependency(
    Promise.resolve().then(function () { return require(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor-Cv6Fb6eQ.js'
    ); })
  );
  if (loading) {
    return /* @__PURE__ */ jsxRuntime.jsx(
      LoadingPlaceholder,
      {
        text: t("grafana-ui.monaco.loading-placeholder", "Loading editor"),
        className: styles.container
      }
    );
  }
  if (error) {
    return /* @__PURE__ */ jsxRuntime.jsx(
      ErrorWithStack,
      {
        title: t("grafana-ui.monaco.error-label", "React Monaco Editor failed to load"),
        error,
        errorInfo: { componentStack: (_a = error == null ? void 0 : error.stack) != null ? _a : "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ jsxRuntime.jsx(
    ReactMonacoEditor,
    {
      ...props,
      loading: (_b = props.loading) != null ? _b : null,
      wrapperProps: {
        "data-testid": e2eSelectors.selectors.components.ReactMonacoEditor.editorLazy
      }
    }
  );
};
const getStyles$1_ = (theme) => {
  return {
    container: css.css({
      marginBottom: "unset",
      marginLeft: theme.spacing(1)
    })
  };
};

"use strict";
var CodeEditorSuggestionItemKind = /* @__PURE__ */ ((CodeEditorSuggestionItemKind2) => {
  CodeEditorSuggestionItemKind2["Method"] = "method";
  CodeEditorSuggestionItemKind2["Field"] = "field";
  CodeEditorSuggestionItemKind2["Property"] = "property";
  CodeEditorSuggestionItemKind2["Constant"] = "constant";
  CodeEditorSuggestionItemKind2["Text"] = "text";
  return CodeEditorSuggestionItemKind2;
})(CodeEditorSuggestionItemKind || {});

"use strict";
function findInsertIndex(line) {
  for (let i = line.length - 1; i > 0; i--) {
    const ch = line.charAt(i);
    if (ch === "$") {
      return {
        index: i,
        prefix: line.substring(i)
      };
    }
    if (ch === " " || ch === "	" || ch === '"' || ch === "'") {
      return {
        index: i + 1,
        prefix: line.substring(i + 1)
      };
    }
  }
  return {
    index: 0,
    prefix: line
  };
}
function getCompletionItems(monaco, prefix, suggestions, range) {
  var _a;
  const items = [];
  for (const suggestion of suggestions) {
    if (prefix && !suggestion.label.startsWith(prefix)) {
      continue;
    }
    items.push({
      ...suggestion,
      kind: mapKinds(monaco, suggestion.kind),
      range,
      insertText: (_a = suggestion.insertText) != null ? _a : suggestion.label
    });
  }
  return items;
}
function mapKinds(monaco, sug) {
  switch (sug) {
    case CodeEditorSuggestionItemKind.Method:
      return monaco.languages.CompletionItemKind.Method;
    case CodeEditorSuggestionItemKind.Field:
      return monaco.languages.CompletionItemKind.Field;
    case CodeEditorSuggestionItemKind.Property:
      return monaco.languages.CompletionItemKind.Property;
    case CodeEditorSuggestionItemKind.Constant:
      return monaco.languages.CompletionItemKind.Constant;
    case CodeEditorSuggestionItemKind.Text:
      return monaco.languages.CompletionItemKind.Text;
  }
  return monaco.languages.CompletionItemKind.Text;
}
function registerSuggestions(monaco, language, getSuggestions, modelId) {
  if (!language || !getSuggestions) {
    return void 0;
  }
  return monaco.languages.registerCompletionItemProvider(language, {
    triggerCharacters: ["$"],
    provideCompletionItems: (model, position, context) => {
      if (model.id !== modelId) {
        return void 0;
      }
      const range = {
        startLineNumber: position.lineNumber,
        endLineNumber: position.lineNumber,
        startColumn: position.column,
        endColumn: position.column
      };
      if (context.triggerCharacter === "$") {
        range.startColumn = position.column - 1;
        return {
          suggestions: getCompletionItems(monaco, "$", getSuggestions(), range)
        };
      }
      const currentLine = model.getValueInRange({
        startLineNumber: position.lineNumber,
        startColumn: 1,
        endLineNumber: position.lineNumber,
        endColumn: position.column
      });
      const { index, prefix } = findInsertIndex(currentLine);
      range.startColumn = index + 1;
      const suggestions = getCompletionItems(monaco, prefix, getSuggestions(), range);
      if (suggestions.length) {
        return { suggestions };
      }
      return void 0;
    }
  });
}

"use strict";
class UnthemedCodeEditor extends React.PureComponent {
  constructor(props) {
    super(props);
    this.loadCustomLanguage = () => {
      const { language } = this.props;
      const customLanguage = data.monacoLanguageRegistry.getIfExists(language);
      if (customLanguage) {
        return customLanguage.init();
      }
      return Promise.resolve();
    };
    // This is replaced with a real function when the actual editor mounts
    this.getEditorValue = () => "";
    this.onBlur = () => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur(this.getEditorValue());
      }
    };
    this.onFocus = () => {
      const { onFocus } = this.props;
      if (onFocus) {
        onFocus(this.getEditorValue());
      }
    };
    this.onSave = () => {
      const { onSave } = this.props;
      if (onSave) {
        onSave(this.getEditorValue());
      }
    };
    this.handleBeforeMount = (monaco) => {
      this.monaco = monaco;
      const { onBeforeEditorMount } = this.props;
      onBeforeEditorMount == null ? void 0 : onBeforeEditorMount(monaco);
    };
    this.handleOnMount = (editor, monaco) => {
      var _a, _b;
      const { getSuggestions, language, onChange, onEditorDidMount } = this.props;
      this.modelId = (_a = editor.getModel()) == null ? void 0 : _a.id;
      this.getEditorValue = () => editor.getValue();
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(monaco, language, getSuggestions, this.modelId);
      }
      editor.onKeyDown((e) => {
        if (e.keyCode === monaco.KeyCode.KeyS && (e.ctrlKey || e.metaKey)) {
          e.preventDefault();
          this.onSave();
        }
      });
      if (onChange) {
        (_b = editor.getModel()) == null ? void 0 : _b.onDidChangeContent(() => onChange(editor.getValue()));
      }
      if (onEditorDidMount) {
        onEditorDidMount(editor, monaco);
      }
    };
  }
  componentWillUnmount() {
    var _a, _b;
    if (this.completionCancel) {
      this.completionCancel.dispose();
    }
    (_b = (_a = this.props).onEditorWillUnmount) == null ? void 0 : _b.call(_a);
  }
  componentDidUpdate(oldProps) {
    const { getSuggestions, language } = this.props;
    const newLanguage = oldProps.language !== language;
    const newGetSuggestions = oldProps.getSuggestions !== getSuggestions;
    if (newGetSuggestions || newLanguage) {
      if (this.completionCancel) {
        this.completionCancel.dispose();
      }
      if (!this.monaco) {
        console.warn("Monaco instance not loaded yet");
        return;
      }
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(this.monaco, language, getSuggestions, this.modelId);
      }
    }
    if (newLanguage) {
      this.loadCustomLanguage();
    }
  }
  render() {
    var _a, _b;
    const { theme, language, width, height, showMiniMap, showLineNumbers, readOnly, wordWrap, monacoOptions } = this.props;
    const { alwaysConsumeMouseWheel, ...restMonacoOptions } = monacoOptions != null ? monacoOptions : {};
    const value = (_a = this.props.value) != null ? _a : "";
    const longText = value.length > 100;
    const containerStyles = (_b = this.props.containerStyles) != null ? _b : getStyles$1Z(theme).container;
    const options = {
      wordWrap: wordWrap ? "on" : "off",
      tabSize: 2,
      codeLens: false,
      contextmenu: false,
      minimap: {
        enabled: longText && showMiniMap,
        renderCharacters: false
      },
      readOnly,
      lineNumbersMinChars: 4,
      lineDecorationsWidth: 1 * theme.spacing.gridSize,
      overviewRulerBorder: false,
      automaticLayout: true,
      padding: {
        top: 0.5 * theme.spacing.gridSize,
        bottom: 0.5 * theme.spacing.gridSize
      },
      fixedOverflowWidgets: true,
      // Ensures suggestions menu is drawn on top
      scrollbar: {
        alwaysConsumeMouseWheel: alwaysConsumeMouseWheel != null ? alwaysConsumeMouseWheel : false
      }
    };
    if (!showLineNumbers) {
      options.glyphMargin = false;
      options.folding = false;
      options.lineNumbers = "off";
      options.lineNumbersMinChars = 0;
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: containerStyles,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        "data-testid": e2eSelectors.selectors.components.CodeEditor.container,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ReactMonacoEditorLazy,
          {
            width,
            height,
            language,
            value,
            options: {
              ...options,
              ...restMonacoOptions != null ? restMonacoOptions : {}
            },
            beforeMount: this.handleBeforeMount,
            onMount: this.handleOnMount,
            keepCurrentModel: true
          }
        )
      }
    );
  }
}
const CodeEditor = withTheme2(UnthemedCodeEditor);
const getStyles$1Z = (theme) => {
  return {
    container: css.css({
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${theme.components.input.borderColor}`
    })
  };
};

"use strict";
const Counter = ({ value }) => {
  const styles = useStyles2(getStyles$1Y);
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.counter, children: data.locale(value, 0).text });
};
const getStyles$1Y = (theme) => ({
  counter: css.css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

"use strict";
const Tab = React__namespace.forwardRef(
  ({ label, active, icon, onChangeTab, counter, suffix: Suffix, className, href, truncate, tooltip, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getStyles$1X);
    const clearStyles = useStyles2(clearButtonStyles);
    const content = () => /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsxRuntime.jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsxRuntime.jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = css.cx(
      clearStyles,
      tabsStyles.link,
      active ? tabsStyles.activeStyle : tabsStyles.notActive,
      truncate && tabsStyles.linkTruncate
    );
    const commonProps = {
      className: linkClass,
      "data-testid": e2eSelectors.selectors.components.Tab.title(label),
      ...otherProps,
      onClick: onChangeTab,
      role: "tab",
      "aria-selected": active,
      title: !!tooltip ? void 0 : otherProps.title
      // If tooltip is provided, don't set the title on the link or button, it looks weird
    };
    let tab = null;
    if (href) {
      tab = /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tabsStyles.item, truncate && tabsStyles.itemTruncate, className), children: /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          ...commonProps,
          href,
          ref,
          children: content()
        }
      ) });
    } else {
      tab = /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tabsStyles.item, truncate && tabsStyles.itemTruncate, className), children: /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          ...commonProps,
          type: "button",
          ref,
          children: content()
        }
      ) });
    }
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: tooltip, children: tab });
    }
    return tab;
  }
);
Tab.displayName = "Tab";
const getStyles$1X = (theme) => {
  return {
    item: css.css({
      listStyle: "none",
      position: "relative",
      display: "flex",
      whiteSpace: "nowrap",
      padding: theme.spacing(0, 0.5)
    }),
    itemTruncate: css.css({
      maxWidth: theme.spacing(40)
    }),
    link: css.css({
      color: theme.colors.text.secondary,
      padding: theme.spacing(1, 1.5, 1),
      borderRadius: theme.shape.radius.default,
      display: "block",
      height: "100%",
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:focus-visible": getFocusStyles(theme),
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        right: 0,
        height: "2px",
        borderRadius: theme.shape.radius.default,
        bottom: 0
      }
    }),
    linkTruncate: css.css({
      textOverflow: "ellipsis",
      whiteSpace: "nowrap",
      wordBreak: "break-word",
      overflow: "hidden"
    }),
    notActive: css.css({
      "a:hover, &:hover, &:focus": {
        color: theme.colors.text.primary,
        "&::before": {
          backgroundColor: theme.colors.action.hover
        }
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.primary,
      overflow: "hidden",
      "&::before": {
        backgroundImage: theme.colors.gradients.brandHorizontal
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

"use strict";
const TabsBar = React.forwardRef(({ children, className, hideBorder = false }, ref) => {
  const styles = useStyles2(getStyles$1W);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.tabsWrapper, hideBorder && styles.noBorder, className), ref, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.tabs, role: "tablist", children }) });
});
const getStyles$1W = (theme) => ({
  tabsWrapper: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    overflowX: "auto"
  }),
  noBorder: css.css({
    borderBottom: 0
  }),
  tabs: css.css({
    position: "relative",
    display: "flex",
    alignItems: "center"
  })
});
TabsBar.displayName = "TabsBar";

"use strict";
const TabContent = ({ children, className, ...restProps }) => {
  const styles = useStyles2(getTabContentStyle);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...restProps, className: css.cx(styles.tabContent, className), children });
};
const getTabContentStyle = (theme) => ({
  tabContent: css.css({
    background: theme.colors.background.primary
  })
});

"use strict";

"use strict";
var TableCellInspectorMode = /* @__PURE__ */ ((TableCellInspectorMode2) => {
  TableCellInspectorMode2["code"] = "code";
  TableCellInspectorMode2["text"] = "text";
  return TableCellInspectorMode2;
})(TableCellInspectorMode || {});
function TableCellInspector({ value, onDismiss, mode }) {
  let displayValue = value;
  const [currentMode, setMode] = React.useState(mode);
  if (lodash.isString(value)) {
    const trimmedValue = value.trim();
    if (trimmedValue[0] === "{" || trimmedValue[0] === "[" || mode === "code") {
      try {
        value = JSON.parse(value);
        displayValue = JSON.stringify(value, null, "  ");
      } catch (error) {
        console.log(
          "Failed to parse JSON in Table cell inspector (this will cause JSON to not print nicely): ",
          error.message
        );
      }
    }
  } else {
    displayValue = JSON.stringify(value);
  }
  let text = displayValue;
  const tabs = [
    {
      label: "Plain text",
      value: "text"
    },
    {
      label: "Code editor",
      value: "code"
    }
  ];
  const changeTabs = () => {
    setMode(currentMode === "text" /* text */ ? "code" /* code */ : "text" /* text */);
  };
  const tabBar = /* @__PURE__ */ jsxRuntime.jsx(TabsBar, { children: tabs.map((t2, index) => /* @__PURE__ */ jsxRuntime.jsx(Tab, { label: t2.label, active: t2.value === currentMode, onChangeTab: changeTabs }, `${t2.value}-${index}`)) });
  return /* @__PURE__ */ jsxRuntime.jsx(Drawer, { onClose: onDismiss, title: t("grafana-ui.table.inspect-drawer-title", "Inspect value"), tabs: tabBar, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 2, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ClipboardButton, { icon: "copy", getText: () => text, style: { marginLeft: "auto", width: "200px" }, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.copy", children: "Copy to Clipboard" }) }),
    currentMode === "code" ? /* @__PURE__ */ jsxRuntime.jsx(
      CodeEditor,
      {
        width: "100%",
        height: 500,
        language: "json",
        showLineNumbers: true,
        showMiniMap: (text && text.length) > 100,
        value: text,
        readOnly: true,
        wordWrap: true
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx("pre", { children: text })
  ] }) });
}

"use strict";
function Popover({
  content,
  show,
  placement,
  className,
  wrapperClassName,
  referenceElement,
  renderArrow,
  hidePopper,
  ...rest
}) {
  const theme = useTheme2();
  const arrowRef = React.useRef(null);
  const middleware = [
    react$1.offset(8),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  if (renderArrow) {
    middleware.push(
      react$1.arrow({
        element: arrowRef
      })
    );
  }
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: show,
    placement: getPlacement(placement),
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react$1.useTransitionStyles(context, {
    initial: () => ({
      opacity: 0
    }),
    duration: theme.transitions.duration.enteringScreen
  });
  return show ? /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref: refs.setFloating,
      style: {
        ...floatingStyles,
        ...placementStyles
      },
      className: wrapperClassName,
      ...rest,
      children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className, children: [
        renderArrow && /* @__PURE__ */ jsxRuntime.jsx(react$1.FloatingArrow, { fill: theme.colors.border.weak, ref: arrowRef, context }),
        typeof content === "string" && content,
        React__namespace.isValidElement(content) && React__namespace.cloneElement(content),
        typeof content === "function" && content({ hidePopper })
      ] })
    }
  ) }) : void 0;
}

"use strict";
const FormLabel = ({
  children,
  isFocused,
  isInvalid,
  className,
  htmlFor,
  tooltip,
  width,
  interactive,
  ...rest
}) => {
  const classes = classNames__default.default(className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ jsxRuntime.jsxs("label", { className: classes, ...rest, htmlFor, children: [
    children,
    tooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }) })
  ] });
};
const InlineFormLabel = FormLabel;

"use strict";
const FormField = ({
  label,
  tooltip,
  labelWidth = 6,
  inputWidth = 12,
  inputEl,
  className,
  interactive,
  ...inputProps
}) => {
  const styles = getStyles$1V();
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.formField, className), children: [
    /* @__PURE__ */ jsxRuntime.jsx(InlineFormLabel, { width: labelWidth, tooltip, interactive, children: label }),
    inputEl || /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        type: "text",
        className: `gf-form-input ${inputWidth ? `width-${inputWidth}` : ""}`,
        ...inputProps,
        disabled: inputProps.disabled
      }
    )
  ] });
};
FormField.displayName = "FormField";
const getStyles$1V = () => {
  return {
    formField: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative"
    })
  };
};

"use strict";
var LegacyInputStatus = /* @__PURE__ */ ((LegacyInputStatus2) => {
  LegacyInputStatus2["Invalid"] = "invalid";
  LegacyInputStatus2["Valid"] = "valid";
  return LegacyInputStatus2;
})(LegacyInputStatus || {});
let Input$1 = class Input extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null
    };
    this.validatorAsync = (validationRules) => {
      return (evt) => {
        const errors = validate(evt.target.value, validationRules);
        this.setState((prevState) => {
          return { ...prevState, error: errors ? errors[0] : null };
        });
      };
    };
    this.populateEventPropsWithStatus = (restProps, validationEvents) => {
      const inputElementProps = { ...restProps };
      if (!validationEvents) {
        return inputElementProps;
      }
      Object.keys(EventsWithValidation).forEach((eventName) => {
        if (hasValidationEvent(eventName, validationEvents) || restProps[eventName]) {
          inputElementProps[eventName] = async (evt) => {
            evt.persist();
            if (hasValidationEvent(eventName, validationEvents)) {
              await this.validatorAsync(validationEvents[eventName]).apply(this, [evt]);
            }
            if (restProps[eventName]) {
              restProps[eventName].apply(null, [evt, this.status]);
            }
          };
        }
      });
      return inputElementProps;
    };
  }
  get status() {
    return this.state.error ? "invalid" /* Invalid */ : "valid" /* Valid */;
  }
  get isInvalid() {
    return this.status === "invalid" /* Invalid */;
  }
  render() {
    const { validationEvents, className, hideErrorMessage, inputRef, ...restProps } = this.props;
    const { error } = this.state;
    const inputClassName = classNames__default.default("gf-form-input", { invalid: this.isInvalid }, className);
    const inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { flexGrow: 1 }, children: [
      /* @__PURE__ */ jsxRuntime.jsx("input", { ...inputElementProps, ref: inputRef, className: inputClassName }),
      error && !hideErrorMessage && /* @__PURE__ */ jsxRuntime.jsx("span", { children: error })
    ] });
  }
};
Input$1.defaultProps = {
  className: ""
};

"use strict";
const IndicatorsContainer$1 = (props) => {
  const isOpen = props.selectProps.menuIsOpen;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.IndicatorsContainer, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: isOpen ? "angle-up" : "angle-down", style: { marginTop: "7px" } }) });
};

"use strict";
const NoOptionsMessage = (props) => {
  const { children } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.NoOptionsMessage, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option__body", children }) }) });
};

"use strict";
function useDelayedSwitch(value, options = {}) {
  const { duration = 250, delay = 250 } = options;
  const [delayedValue, setDelayedValue] = React.useState(value);
  const onStartTime = React.useRef();
  React.useEffect(() => {
    let timeout;
    if (value) {
      timeout = setTimeout(() => {
        onStartTime.current = /* @__PURE__ */ new Date();
        setDelayedValue(value);
      }, delay);
    } else {
      const timeSpent = onStartTime.current ? Date.now() - onStartTime.current.valueOf() : 0;
      const turnOff = () => {
        onStartTime.current = void 0;
        setDelayedValue(value);
      };
      if (timeSpent >= duration) {
        turnOff();
      } else {
        timeout = setTimeout(turnOff, duration - timeSpent);
      }
    }
    return () => {
      if (timeout) {
        clearTimeout(timeout);
        timeout = void 0;
      }
    };
  }, [value, duration, delay]);
  return delayedValue;
}

"use strict";
function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = useStyles2(getStyles$1U, duration);
  const transitionRef = React.useRef(null);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactTransitionGroup.CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React__namespace.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles$1U = (theme, duration) => ({
  enter: css.css({
    label: "enter",
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    opacity: 1,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css.css({
    label: "exit",
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

"use strict";
function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles$1T, duration, horizontal ? "width" : "height", size);
  const transitionRef = React.useRef(null);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactTransitionGroup.CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React__namespace.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles$1T = (theme, duration, measurement, size) => ({
  enter: css.css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css.css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

"use strict";
const getStyles$1S = (theme) => {
  return {
    singleValue: css.css({
      label: "singleValue",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%",
      gridArea: "1 / 1 / 2 / 3"
    }),
    spinnerWrapper: css.css({
      width: "16px",
      height: "16px",
      display: "inline-block",
      marginRight: "10px",
      position: "relative",
      verticalAlign: "middle",
      overflow: "hidden"
    }),
    spinnerIcon: css.css({
      width: "100%",
      height: "100%",
      position: "absolute"
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    disabled: css.css({
      color: theme.colors.text.disabled
    }),
    isOpen: css.css({
      color: theme.colors.text.disabled
    })
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data: data$1, isDisabled } = props;
  const styles = useStyles2(getStyles$1S);
  const loading = useDelayedSwitch(data$1.loading || false, { delay: 250, duration: 750 });
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ jsxRuntime.jsxs(
    ReactSelect.components.SingleValue,
    {
      ...props,
      className: css.cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen),
      children: [
        data$1.imgUrl ? /* @__PURE__ */ jsxRuntime.jsx(FadeWithImage, { loading, imgUrl: data$1.imgUrl, styles, alt: String((_a = data$1.label) != null ? _a : data$1.value) }) : /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.spinnerWrapper, children: /* @__PURE__ */ jsxRuntime.jsx(Spinner, { className: styles.spinnerIcon, inline: true }) }) }),
          icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, role: "img", className: styles.optionIcon })
        ] }),
        !data$1.hideText && children
      ]
    }
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: props.styles.spinnerWrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(FadeTransition, { duration: 150, visible: props.loading, children: /* @__PURE__ */ jsxRuntime.jsx(Spinner, { className: props.styles.spinnerIcon, inline: true }) }),
    /* @__PURE__ */ jsxRuntime.jsx(FadeTransition, { duration: 150, visible: !props.loading, children: /* @__PURE__ */ jsxRuntime.jsx("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt }) })
  ] });
};

"use strict";
function resetSelectStyles(theme) {
  return {
    clearIndicator: () => ({}),
    container: () => ({}),
    control: () => ({}),
    dropdownIndicator: () => ({}),
    group: () => ({}),
    groupHeading: () => ({}),
    indicatorsContainer: () => ({}),
    indicatorSeparator: () => ({}),
    input: function(originalStyles) {
      return {
        ...originalStyles,
        color: "inherit",
        margin: 0,
        padding: 0,
        // Set an explicit z-index here to ensure this element always overlays the singleValue
        zIndex: 1,
        overflow: "hidden"
      };
    },
    loadingIndicator: () => ({}),
    loadingMessage: () => ({}),
    menu: () => ({}),
    menuList: ({ maxHeight }) => ({
      maxHeight
    }),
    multiValue: () => ({}),
    multiValueLabel: () => ({
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    multiValueRemove: () => ({}),
    noOptionsMessage: () => ({}),
    option: () => ({}),
    placeholder: (originalStyles) => ({
      ...originalStyles,
      color: theme.colors.text.secondary
    }),
    singleValue: () => ({}),
    valueContainer: () => ({})
  };
}
function useCustomSelectStyles(theme, width) {
  return React.useMemo(() => {
    return {
      ...resetSelectStyles(theme),
      menuPortal: (base) => {
        return {
          ...base,
          zIndex: theme.zIndex.portal
        };
      },
      //These are required for the menu positioning to function
      menu: ({ top, bottom, position }) => {
        return {
          top,
          bottom,
          position,
          minWidth: "100%",
          zIndex: theme.zIndex.dropdown
        };
      },
      container: () => ({
        width: width ? theme.spacing(width) : "100%",
        display: width === "auto" ? "inline-flex" : "flex"
      }),
      option: (provided, state) => ({
        ...provided,
        opacity: state.isDisabled ? 0.5 : 1
      })
    };
  }, [theme, width]);
}

"use strict";
const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.Option, { ...props, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-select-box__desc-option", children: [
    data.imgUrl && /* @__PURE__ */ jsxRuntime.jsx("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-select-box__desc-option__body", children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { children }),
      data.description && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option__desc", children: data.description })
    ] }),
    isSelected && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check", "aria-hidden": "true" })
  ] }) });
};

"use strict";
const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.colors.background.secondary}`,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    label: css.css({
      flexGrow: 1
    }),
    icon: css.css({
      paddingRight: "2px"
    })
  };
});
class UnthemedSelectOptionGroup extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      expanded: false
    };
    this.onToggleChildren = () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    };
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.header, onClick: this.onToggleChildren, role: "presentation", children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" })
      ] }),
      expanded && children
    ] });
  }
}
const SelectOptionGroup$1 = withTheme2(UnthemedSelectOptionGroup);

"use strict";
const MenuList = (props) => {
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.MenuList, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { showScrollIndicators: true, overflowX: "hidden", maxHeight: "inherit", children: props.children }) });
};
const _Select = class _Select extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect__default.default;
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable__default.default;
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames__default.default("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = { ..._Select.defaultProps.components, ...components2 };
    return /* @__PURE__ */ jsxRuntime.jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        SelectComponent,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel,
          ...creatableOptions
        }
      );
    } });
  }
};
_Select.contextType = data.ThemeContext;
_Select.defaultProps = {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer: IndicatorsContainer$1,
    MenuList,
    Group: SelectOptionGroup$1
  }
};
let Select$1 = _Select;
let AsyncSelect$1 = class AsyncSelect extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames__default.default("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ jsxRuntime.jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        ReactAsyncSelect__default.default,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer: IndicatorsContainer$1,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    } });
  }
};
AsyncSelect$1.contextType = data.ThemeContext;
AsyncSelect$1.defaultProps = {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
};
class WrapInTooltip extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isOpenInternal: false
    };
    this.onOpenMenu = () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    };
    this.onCloseMenu = () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    };
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom", children: /* @__PURE__ */ jsxRuntime.jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) }) });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) });
    }
  }
}

"use strict";
class UnthemedSwitch extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      id: lodash.uniqueId()
    };
    this.internalOnChange = (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    };
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      theme,
      tooltip,
      tooltipPlacement
    } = this.props;
    const styles = getStyles$1R(theme);
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = css.cx(styles.switch, switchClass, {
      [styles.switchTransparent]: transparent
    });
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children: /* @__PURE__ */ jsxRuntime.jsxs("label", { htmlFor: labelId, className: css.cx("gf-form", styles.labelContainer, className), children: [
      label && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: labelClassName, children: [
        label,
        tooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info", children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }) })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: switchClassName, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          "input",
          {
            disabled,
            id: labelId,
            type: "checkbox",
            checked,
            onChange: this.internalOnChange
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.slider })
      ] })
    ] }) });
  }
}
const Switch$1 = withTheme2(UnthemedSwitch);
const getStyles$1R = (theme) => {
  const slider = css.css({
    background: theme.v1.palette.gray1,
    borderRadius: theme.shape.radius.pill,
    height: "16px",
    width: "32px",
    display: "block",
    position: "relative",
    "&::before": {
      position: "absolute",
      content: "''",
      height: "12px",
      width: "12px",
      left: "2px",
      top: "2px",
      background: theme.components.input.background,
      transition: "0.4s",
      borderRadius: theme.shape.radius.circle,
      boxShadow: theme.shadows.z1
    }
  });
  return {
    container: css.css({
      display: "flex",
      flexShrink: 0
    }),
    labelContainer: css.css({
      display: "flex",
      cursor: "pointer",
      marginRight: theme.spacing(0.5)
    }),
    switch: css.css({
      display: "flex",
      position: "relative",
      width: "56px",
      height: theme.spacing(4),
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      alignItems: "center",
      justifyContent: "center",
      input: {
        opacity: 0,
        width: 0,
        height: 0
      },
      [`input:checked + .${slider}`]: {
        background: theme.colors.primary.main
      },
      [`input:checked + .${slider}::before`]: {
        transform: "translateX(16px)"
      }
    }),
    switchTransparent: css.css({
      background: "transparent",
      border: 0,
      width: "40px"
    }),
    slider
  };
};

"use strict";
const getSecretFormFieldStyles = () => {
  return {
    noRadiusInput: css.css({
      borderBottomRightRadius: "0 !important",
      borderTopRightRadius: "0 !important"
    }),
    noRadiusButton: css.css({
      borderBottomLeftRadius: "0 !important",
      borderTopLeftRadius: "0 !important"
    })
  };
};
const SecretFormField = ({
  label = "Password",
  labelWidth,
  inputWidth = 12,
  onReset,
  isConfigured,
  tooltip,
  placeholder = "Password",
  interactive,
  ...inputProps
}) => {
  const styles = getSecretFormFieldStyles();
  return /* @__PURE__ */ jsxRuntime.jsx(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          "input",
          {
            type: "text",
            className: css.cx(`gf-form-input width-${inputWidth}`, styles.noRadiusInput),
            disabled: true,
            value: "configured",
            ...lodash.omit(inputProps, "value")
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { onClick: onReset, variant: "secondary", type: "button", children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.secret-form-field.reset", children: "Reset" }) })
      ] }) : /* @__PURE__ */ jsxRuntime.jsx(
        "input",
        {
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder,
          ...inputProps
        }
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

"use strict";
const ConfirmButton = ({
  children,
  className,
  closeOnConfirm,
  confirmText = "Save",
  confirmVariant = "primary",
  disabled = false,
  onCancel,
  onClick,
  onConfirm,
  size = "md"
}) => {
  const mainButtonRef = React.useRef(null);
  const confirmButtonRef = React.useRef(null);
  const [showConfirm, setShowConfirm] = React.useState(false);
  const [shouldRestoreFocus, setShouldRestoreFocus] = React.useState(false);
  const styles = useStyles2(getStyles$1Q);
  React.useEffect(() => {
    var _a, _b;
    if (showConfirm) {
      (_a = confirmButtonRef.current) == null ? void 0 : _a.focus();
      setShouldRestoreFocus(true);
    } else {
      if (shouldRestoreFocus) {
        (_b = mainButtonRef.current) == null ? void 0 : _b.focus();
        setShouldRestoreFocus(false);
      }
    }
  }, [shouldRestoreFocus, showConfirm]);
  const onClickButton = (event) => {
    if (event) {
      event.preventDefault();
    }
    setShowConfirm(true);
    onClick == null ? void 0 : onClick();
  };
  const onClickCancel = (event) => {
    var _a;
    if (event) {
      event.preventDefault();
    }
    setShowConfirm(false);
    (_a = mainButtonRef.current) == null ? void 0 : _a.focus();
    onCancel == null ? void 0 : onCancel();
  };
  const onClickConfirm = (event) => {
    if (event) {
      event.preventDefault();
    }
    onConfirm == null ? void 0 : onConfirm();
    if (closeOnConfirm) {
      setShowConfirm(false);
    }
  };
  const buttonClass = css.cx(className, styles.mainButton, {
    [styles.mainButtonHide]: showConfirm
  });
  const confirmButtonClass = css.cx(styles.confirmButton, {
    [styles.confirmButtonHide]: !showConfirm
  });
  const confirmButtonContainerClass = css.cx(styles.confirmButtonContainer, {
    [styles.confirmButtonContainerHide]: !showConfirm
  });
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: buttonClass, children: typeof children === "string" ? /* @__PURE__ */ jsxRuntime.jsx(Button, { disabled, size, fill: "text", onClick: onClickButton, ref: mainButtonRef, children }) : React__namespace.cloneElement(children, { disabled, onClick: onClickButton, ref: mainButtonRef }) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: confirmButtonContainerClass, children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: confirmButtonClass, children: [
      /* @__PURE__ */ jsxRuntime.jsx(Button, { size, variant: confirmVariant, onClick: onClickConfirm, ref: confirmButtonRef, children: confirmText }),
      /* @__PURE__ */ jsxRuntime.jsx(Button, { size, fill: "text", onClick: onClickCancel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.confirm-button.cancel", children: "Cancel" }) })
    ] }) })
  ] });
};
ConfirmButton.displayName = "ConfirmButton";
const getStyles$1Q = (theme) => {
  return {
    container: css.css({
      alignItems: "center",
      display: "flex",
      justifyContent: "flex-end",
      position: "relative"
    }),
    mainButton: css.css({
      opacity: 1,
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["opacity"], {
          duration: theme.transitions.duration.shortest,
          easing: theme.transitions.easing.easeOut
        })
      },
      zIndex: 2
    }),
    mainButtonHide: css.css({
      opacity: 0,
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["opacity", "visibility"], {
          duration: theme.transitions.duration.shortest,
          easing: theme.transitions.easing.easeIn
        })
      },
      visibility: "hidden",
      zIndex: 0
    }),
    confirmButtonContainer: css.css({
      overflow: "visible",
      position: "absolute",
      pointerEvents: "all",
      right: 0
    }),
    confirmButtonContainerHide: css.css({
      overflow: "hidden",
      pointerEvents: "none"
    }),
    confirmButton: css.css({
      alignItems: "flex-start",
      background: theme.colors.background.primary,
      display: "flex",
      opacity: 1,
      transform: "translateX(0)",
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["opacity", "transform"], {
          duration: theme.transitions.duration.shortest,
          easing: theme.transitions.easing.easeOut
        })
      },
      zIndex: 1
    }),
    confirmButtonHide: css.css({
      opacity: 0,
      transform: "translateX(100%)",
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["opacity", "transform", "visibility"], {
          duration: theme.transitions.duration.shortest,
          easing: theme.transitions.easing.easeIn
        })
      },
      visibility: "hidden"
    })
  };
};

"use strict";
const DeleteButton = ({ size, disabled, onConfirm, "aria-label": ariaLabel, closeOnConfirm }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(
    ConfirmButton,
    {
      confirmText: "Delete",
      confirmVariant: "destructive",
      size: size || "md",
      disabled,
      onConfirm,
      closeOnConfirm,
      children: /* @__PURE__ */ jsxRuntime.jsx(Button, { "aria-label": ariaLabel, variant: "destructive", icon: "times", size: size || "sm" })
    }
  );
};

"use strict";
const Toggletip = React.memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer,
    fitContent = false,
    onOpen,
    show
  }) => {
    const arrowRef = React.useRef(null);
    const grafanaTheme = useTheme2();
    const styles = useStyles2(getStyles$1P);
    const style = styles[theme];
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: (open) => {
        if (show === void 0) {
          setControlledVisible(open);
        }
        if (!open) {
          onClose == null ? void 0 : onClose();
        } else {
          onOpen == null ? void 0 : onOpen();
        }
      },
      middleware,
      whileElementsMounted: react$1.autoUpdate,
      strategy: "fixed"
    });
    const click = react$1.useClick(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
    return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      React.cloneElement(children, {
        ref: refs.setReference,
        tabIndex: 0,
        "aria-expanded": isOpen,
        ...getReferenceProps()
      }),
      isOpen && /* @__PURE__ */ jsxRuntime.jsx(react$1.FloatingFocusManager, { context, modal: false, closeOnFocusOut: false, children: /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          "data-testid": "toggletip-content",
          className: css.cx(style.container, {
            [styles.fitContent]: fitContent
          }),
          ref: refs.setFloating,
          style: floatingStyles,
          ...getFloatingProps(),
          children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              react$1.FloatingArrow,
              {
                strokeWidth: 0.3,
                stroke: grafanaTheme.colors.border.weak,
                className: style.arrow,
                ref: arrowRef,
                context
              }
            ),
            Boolean(title) && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.header, children: title }),
            closeButton && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.headerClose, children: /* @__PURE__ */ jsxRuntime.jsx(
              IconButton,
              {
                "aria-label": t("grafana-ui.toggletip.close", "Close"),
                name: "times",
                "data-testid": "toggletip-header-close",
                onClick: () => {
                  setControlledVisible(false);
                  onClose == null ? void 0 : onClose();
                }
              }
            ) }),
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.body, children: [
              (typeof content === "string" || React.isValidElement(content)) && content,
              typeof content === "function" && content({})
            ] }),
            Boolean(footer) && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.footer, children: footer })
          ]
        }
      ) })
    ] });
  }
);
Toggletip.displayName = "Toggletip";
const getStyles$1P = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.colors.background.primary,
    theme.colors.border.weak,
    theme.components.tooltip.text,
    { topBottom: 2, rightLeft: 2 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 2, rightLeft: 2 }
  );
  return {
    info,
    error,
    fitContent: css.css({
      maxWidth: "fit-content"
    })
  };
};

"use strict";
const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$1O);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
          [styles.scrollIndicatorVisible]: showScrollTopIndicator
        })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.scrollContent, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollTopMarker }),
      children,
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollBottomMarker })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
          [styles.scrollIndicatorVisible]: showScrollBottomIndicator
        })
      }
    )
  ] });
};
const getStyles$1O = (theme) => {
  return {
    scrollContent: css.css({
      flex: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: theme.spacing(6),
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create("opacity")
      },
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${theme.colors.background.canvas})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${theme.colors.background.canvas})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    })
  };
};

"use strict";
const CustomScrollbar = ({
  autoHide = false,
  autoHideTimeout = 200,
  setScrollTop,
  className,
  testId,
  autoHeightMin = "0",
  autoHeightMax = "100%",
  hideTracksWhenNotNeeded = false,
  hideHorizontalTrack,
  hideVerticalTrack,
  scrollRefCallback,
  showScrollIndicators = false,
  updateAfterMountMs,
  scrollTop,
  onScroll,
  children,
  divId
}) => {
  const ref = React.useRef(null);
  const styles = useStyles2(getStyles$1N);
  React.useEffect(() => {
    if (ref.current && scrollRefCallback) {
      scrollRefCallback(ref.current.view);
    }
  }, [ref, scrollRefCallback]);
  useScrollTop(ref.current, scrollTop);
  React.useEffect(() => {
    if (!updateAfterMountMs) {
      return;
    }
    setTimeout(() => {
      const scrollbar = ref.current;
      if (scrollbar == null ? void 0 : scrollbar.update) {
        scrollbar.update();
      }
    }, updateAfterMountMs);
  }, [updateAfterMountMs]);
  function renderTrack(className2, hideTrack, passedProps) {
    if (passedProps.style && hideTrack) {
      passedProps.style.display = "none";
    }
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: className2 });
  }
  const renderTrackHorizontal = React.useCallback(
    (passedProps) => {
      return renderTrack("track-horizontal", hideHorizontalTrack, passedProps);
    },
    [hideHorizontalTrack]
  );
  const renderTrackVertical = React.useCallback(
    (passedProps) => {
      return renderTrack("track-vertical", hideVerticalTrack, passedProps);
    },
    [hideVerticalTrack]
  );
  const renderThumbHorizontal = React.useCallback((passedProps) => {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "thumb-horizontal" });
  }, []);
  const renderThumbVertical = React.useCallback((passedProps) => {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "thumb-vertical" });
  }, []);
  const renderView = React.useCallback(
    (passedProps) => {
      if (passedProps.style && passedProps.style["WebkitOverflowScrolling"] === "touch") {
        passedProps.style["WebkitOverflowScrolling"] = "auto";
      }
      return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "scrollbar-view", id: divId });
    },
    [divId]
  );
  const onScrollStop = React.useCallback(() => {
    ref.current && setScrollTop && setScrollTop(ref.current.getValues());
  }, [setScrollTop]);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Scrollbars__default.default,
    {
      "data-testid": testId,
      ref,
      className: css.cx(styles.customScrollbar, className, {
        [styles.scrollbarWithScrollIndicators]: showScrollIndicators
      }),
      onScrollStop,
      autoHeight: true,
      autoHide,
      autoHideTimeout,
      hideTracksWhenNotNeeded,
      autoHeightMax,
      autoHeightMin,
      renderTrackHorizontal,
      renderTrackVertical,
      renderThumbHorizontal,
      renderThumbVertical,
      renderView,
      onScroll,
      children: showScrollIndicators ? /* @__PURE__ */ jsxRuntime.jsx(ScrollIndicators, { children }) : children
    }
  );
};
const getStyles$1N = (theme) => {
  return {
    customScrollbar: css.css({
      // Fix for Firefox. For some reason sometimes .view container gets a height of its content, but in order to
      // make scroll working it should fit outer container size (scroll appears only when inner container size is
      // greater than outer one).
      display: "flex",
      flexGrow: 1,
      ".scrollbar-view": {
        display: "flex",
        flexGrow: 1,
        flexDirection: "column"
      },
      ".track-vertical": {
        borderRadius: theme.shape.borderRadius(2),
        width: `${theme.spacing(1)} !important`,
        right: 0,
        bottom: theme.spacing(0.25),
        top: theme.spacing(0.25)
      },
      ".track-horizontal": {
        borderRadius: theme.shape.borderRadius(2),
        height: `${theme.spacing(1)} !important`,
        right: theme.spacing(0.25),
        bottom: theme.spacing(0.25),
        left: theme.spacing(0.25)
      },
      ".thumb-vertical": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      ".thumb-horizontal": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      "&:hover": {
        ".thumb-vertical, .thumb-horizontal": {
          opacity: 1,
          transition: "opacity 0.3s ease-in-out"
        }
      }
    }),
    // override the scroll container position so that the scroll indicators
    // are positioned at the top and bottom correctly.
    // react-custom-scrollbars doesn't provide any way for us to hook in nicely,
    // so we have to override with !important. feelsbad.
    scrollbarWithScrollIndicators: css.css({
      ".scrollbar-view": {
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        position: "static !important"
      }
    })
  };
};
function useScrollTop(scrollBar, scrollTop) {
  React.useEffect(() => {
    if (scrollBar && scrollTop != null) {
      scrollBar.scrollTop(scrollTop);
    }
  }, [scrollTop, scrollBar]);
}

"use strict";
function TabbedContainer({ tabs, defaultTab, closeIconTooltip, onClose, testId }) {
  var _a;
  const [activeTab, setActiveTab] = React.useState(tabs.some((tab) => tab.value === defaultTab) ? defaultTab : tabs[0].value);
  const styles = useStyles2(getStyles$1M);
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, "data-testid": testId, children: [
    /* @__PURE__ */ jsxRuntime.jsxs(TabsBar, { className: styles.tabs, children: [
      tabs.map((t) => /* @__PURE__ */ jsxRuntime.jsx(
        Tab,
        {
          label: t.label,
          active: t.value === activeTab,
          onChangeTab: () => onSelectTab(t),
          icon: t.icon
        },
        t.value
      )),
      /* @__PURE__ */ jsxRuntime.jsx(Box, { grow: 1, display: "flex", justifyContent: "flex-end", paddingRight: 1, children: /* @__PURE__ */ jsxRuntime.jsx(IconButton, { size: "lg", onClick: onClose, name: "times", tooltip: closeIconTooltip != null ? closeIconTooltip : "Close" }) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { children: /* @__PURE__ */ jsxRuntime.jsx(TabContent, { className: styles.tabContent, children: (_a = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _a.content }) })
  ] });
}
const getStyles$1M = (theme) => ({
  container: css.css({
    height: "100%",
    display: "flex",
    flexDirection: "column",
    flex: "1 1 0",
    minHeight: 0
  }),
  tabContent: css.css({
    padding: theme.spacing(2),
    backgroundColor: theme.colors.background.primary,
    flex: 1
  }),
  tabs: css.css({
    paddingTop: theme.spacing(0.5),
    borderColor: theme.colors.border.weak,
    ul: {
      marginLeft: theme.spacing(2)
    }
  })
});

"use strict";
const AutoSizeInputContext = React__namespace.default.createContext(false);
AutoSizeInputContext.displayName = "AutoSizeInputContext";

"use strict";
const Input = React.forwardRef((props, ref) => {
  const {
    className,
    addonAfter,
    addonBefore,
    prefix,
    suffix: suffixProp,
    invalid,
    loading,
    width = 0,
    ...restProps
  } = props;
  const [prefixRef, prefixRect] = useMeasure__default.default();
  const [suffixRef, suffixRect] = useMeasure__default.default();
  const isInAutoSizeInput = React.useContext(AutoSizeInputContext);
  const accessoriesWidth = (prefixRect.width || 0) + (suffixRect.width || 0);
  const autoSizeWidth = isInAutoSizeInput && width ? width + accessoriesWidth / 8 : void 0;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width: autoSizeWidth ? void 0 : width });
  const suffix = suffixProp || loading && /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true });
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(styles.wrapper, className),
      style: autoSizeWidth ? { width: theme.spacing(autoSizeWidth) } : void 0,
      "data-testid": "input-wrapper",
      children: [
        !!addonBefore && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.addon, children: addonBefore }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.inputWrapper, children: [
          prefix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.prefix, ref: prefixRef, children: prefix }),
          /* @__PURE__ */ jsxRuntime.jsx(
            "input",
            {
              ref,
              className: styles.input,
              ...restProps,
              style: {
                paddingLeft: prefix ? prefixRect.width + 12 : void 0,
                paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
              }
            }
          ),
          suffix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.suffix, ref: suffixRef, children: suffix })
        ] }),
        !!addonAfter && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.addon, children: addonAfter })
      ]
    }
  );
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css.css({
    position: "absolute",
    top: 0,
    zIndex: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    flexGrow: 0,
    flexShrink: 0,
    fontSize: theme.typography.size.md,
    height: "100%",
    /* Min width specified for prefix/suffix classes used outside React component*/
    minWidth: prefixSuffixStaticWidth,
    color: theme.colors.text.secondary
  });
  return {
    // Wraps inputWrapper and addons
    wrapper: css.cx(
      css.css({
        label: "input-wrapper",
        display: "flex",
        width: width ? theme.spacing(width) : "100%",
        height: theme.spacing(theme.components.height.md),
        borderRadius: theme.shape.radius.default,
        "&:hover": {
          "> .prefix, .suffix, .input": {
            borderColor: invalid ? theme.colors.error.border : theme.colors.primary.border
          },
          // only show number buttons on hover
          "input[type='number']": {
            appearance: "textfield"
          },
          "input[type='number']::-webkit-inner-spin-button, input[type='number']::-webkit-outer-spin-button": {
            // Need type assertion here due to the use of !important
            // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
            // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
            WebkitAppearance: "inner-spin-button !important",
            opacity: 1
          }
        }
      })
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css.css({
      label: "input-inputWrapper",
      position: "relative",
      flexGrow: 1,
      /* we want input to be above addons, especially for focused state */
      zIndex: 1,
      /* when input rendered with addon before only*/
      "&:not(:first-child):last-child": {
        "> input": {
          borderLeft: "none",
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      /* when input rendered with addon after only*/
      "&:first-child:not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      /* when rendered with addon before and after */
      "&:not(:first-child):not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0,
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      input: {
        /* paddings specified for classes used outside React component */
        "&:not(:first-child)": {
          paddingLeft: prefixSuffixStaticWidth
        },
        "&:not(:last-child)": {
          paddingRight: prefixSuffixStaticWidth
        },
        "&[readonly]": {
          cursor: "default"
        }
      }
    }),
    input: css.cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css.css({
        label: "input-input",
        position: "relative",
        zIndex: 0,
        flexGrow: 1,
        borderRadius: theme.shape.radius.default,
        height: "100%",
        width: "100%"
      })
    ),
    inputDisabled: css.css({
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      border: `1px solid ${theme.colors.action.disabledBackground}`,
      "&:focus": {
        boxShadow: "none"
      }
    }),
    addon: css.css({
      label: "input-addon",
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      flexGrow: 0,
      flexShrink: 0,
      position: "relative",
      "&:first-child": {
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0,
        "> :last-child": {
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      "&:last-child": {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        "> :first-child": {
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      "> *:focus": {
        /* we want anything that has focus and is an addon to be above input */
        zIndex: 2
      }
    }),
    prefix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-prefix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(0.5),
        borderRight: "none",
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
      })
    ),
    suffix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-suffix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
        marginBottom: "-2px",
        borderLeft: "none",
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        right: 0
      })
    ),
    loadingIndicator: css.css({
      "& + *": {
        marginLeft: theme.spacing(0.5)
      }
    })
  };
});

"use strict";
const CustomInput = (props) => {
  let testId;
  if ("data-testid" in props.selectProps && props.selectProps["data-testid"]) {
    testId = props.selectProps["data-testid"] + "-input";
  }
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.Input, { ...props, "data-testid": testId });
};

"use strict";
function DropdownIndicator({ selectProps }) {
  const isOpen = selectProps.menuIsOpen;
  const icon = isOpen ? "search" : "angle-down";
  const size = isOpen ? "sm" : "md";
  return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size });
}

"use strict";
const IndicatorsContainer = React.forwardRef((props, ref) => {
  const { children } = props;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: false });
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      className: css.cx(
        styles.suffix,
        css.css({
          position: "relative"
        })
      ),
      ref,
      children
    }
  );
});
IndicatorsContainer.displayName = "IndicatorsContainer";

"use strict";
const InputControl$1 = React.forwardRef(
  function InputControl2({ focused, invalid, disabled, children, innerProps, prefix, ...otherProps }, ref) {
    const styles = useStyles2(getInputControlStyles, invalid, !!prefix);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.input, ...innerProps, ref, children: [
      prefix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.prefix), children: prefix }),
      children
    ] });
  }
);
const getInputControlStyles = (theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: css.cx(
      inputPadding(theme),
      css.css({
        width: "100%",
        maxWidth: "100%",
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
        flexWrap: "wrap",
        justifyContent: "space-between",
        paddingRight: 0,
        position: "relative",
        boxSizing: "border-box"
      }),
      withPrefix && css.css({
        paddingLeft: 0
      })
    ),
    prefix: css.cx(
      styles.prefix,
      css.css({
        position: "relative"
      })
    )
  };
};

"use strict";
const getSelectStyles = stylesFactory((theme) => {
  return {
    menu: css.css({
      label: "grafana-select-menu",
      background: theme.components.dropdown.background,
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      position: "relative",
      minWidth: "100%",
      overflow: "hidden",
      zIndex: 1
    }),
    option: css.css({
      label: "grafana-select-option",
      padding: "8px",
      position: "relative",
      display: "flex",
      alignItems: "center",
      flexDirection: "row",
      flexShrink: 0,
      whiteSpace: "nowrap",
      cursor: "pointer",
      borderLeft: "2px solid transparent",
      borderRadius: theme.shape.radius.default,
      "&:hover": {
        background: theme.colors.action.hover,
        "@media (forced-colors: active), (prefers-contrast: more)": {
          border: `1px solid ${theme.colors.primary.border}`
        }
      }
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1)
    }),
    optionImage: css.css({
      label: "grafana-select-option-image",
      width: "16px",
      marginRight: "10px"
    }),
    optionDescription: css.css({
      label: "grafana-select-option-description",
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      lineHeight: theme.typography.body.lineHeight
    }),
    optionBody: css.css({
      label: "grafana-select-option-body",
      display: "flex",
      fontWeight: theme.typography.fontWeightMedium,
      flexDirection: "column",
      flexGrow: 1
    }),
    optionFocused: css.css({
      label: "grafana-select-option-focused",
      background: theme.colors.action.focus,
      "@media (forced-colors: active), (prefers-contrast: more)": {
        border: `1px solid ${theme.colors.primary.border}`
      }
    }),
    optionSelected: css.css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        transform: "translateX(-50%)",
        width: theme.spacing(0.5),
        left: 0
      }
    }),
    optionDisabled: css.css({
      label: "grafana-select-option-disabled",
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      cursor: "not-allowed"
    }),
    singleValue: css.css({
      label: "grafana-select-single-value",
      color: theme.components.input.text,
      gridArea: "1 / 1 / 2 / 3",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%"
    }),
    valueContainer: css.css({
      label: "grafana-select-value-container",
      alignItems: "center",
      display: "grid",
      position: "relative",
      boxSizing: "border-box",
      flex: "1 1 0%",
      outline: "none",
      overflow: "hidden"
    }),
    valueContainerMulti: css.css({
      label: "grafana-select-value-container-multi",
      flexWrap: "wrap",
      display: "flex"
    }),
    valueContainerMultiNoWrap: css.css({
      display: "grid",
      gridAutoFlow: "column"
    }),
    loadingMessage: css.css({
      label: "grafana-select-loading-message",
      padding: theme.spacing(1),
      textAlign: "center",
      width: "100%"
    }),
    multiValueContainer: css.css({
      label: "grafana-select-multi-value-container",
      display: "flex",
      alignItems: "center",
      lineHeight: 1,
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      margin: theme.spacing(0.25, 1, 0.25, 0),
      padding: theme.spacing(0.25, 0, 0.25, 1),
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      overflow: "hidden",
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary)
      }
    }),
    multiValueRemove: css.css({
      label: "grafana-select-multi-value-remove",
      margin: theme.spacing(0, 0.5),
      cursor: "pointer",
      svg: {
        marginBottom: 0
      }
    }),
    singleValueRemove: css.css({
      cursor: "pointer",
      "&:hover": {
        color: theme.colors.text.primary
      }
    }),
    groupHeader: css.css({
      padding: theme.spacing(1, 1, 1, 0.75),
      borderLeft: "2px solid transparent"
    }),
    group: css.css({
      "&:not(:first-child)": {
        borderTop: `1px solid ${theme.colors.border.weak}`
      },
      // ensure there's a bottom border if there are options following the group
      ':has(+ [role="option"])': {
        borderBottom: `1px solid ${theme.colors.border.weak}`
      }
    }),
    toggleAllButton: css.css({
      width: "100%",
      border: 0,
      padding: 0,
      textAlign: "left"
    })
  };
});

"use strict";
const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...innerProps, className: styles.multiValueContainer, children });
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx(
    IconButton,
    {
      ...innerProps,
      name: "times",
      size: "sm",
      className: styles.multiValueRemove,
      tooltip: t("grafana-ui.select.multi-value-remove", "Remove")
    }
  );
};

"use strict";
const SelectContainer = (props) => {
  const {
    isDisabled,
    isFocused,
    children,
    selectProps: { invalid = false }
  } = props;
  const styles = useStyles2(getSelectContainerStyles, isFocused, isDisabled, invalid);
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.SelectContainer, { ...props, className: css.cx(styles.wrapper, props.className), children });
};
const getSelectContainerStyles = (theme, focused, disabled, invalid) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    wrapper: css.cx(
      styles.wrapper,
      sharedInputStyle(theme, invalid),
      focused && css.css(getFocusStyles(theme)),
      disabled && styles.inputDisabled,
      css.css({
        position: "relative",
        boxSizing: "border-box",
        /* The display property is set by the styles prop in SelectBase because it's dependant on the width prop  */
        flexDirection: "row",
        flexWrap: "wrap",
        alignItems: "stretch",
        justifyContent: "space-between",
        minHeight: theme.spacing(theme.components.height.md),
        height: "auto",
        maxWidth: "100%",
        /* Input padding is applied to the InputControl so the menu is aligned correctly */
        padding: 0,
        cursor: disabled ? "not-allowed" : "pointer"
      })
    )
  };
};

"use strict";
var ToggleAllState = /* @__PURE__ */ ((ToggleAllState2) => {
  ToggleAllState2["allSelected"] = "allSelected";
  ToggleAllState2["indeterminate"] = "indeterminate";
  ToggleAllState2["noneSelected"] = "noneSelected";
  return ToggleAllState2;
})(ToggleAllState || {});

"use strict";
const SelectMenu = ({
  children,
  maxHeight,
  innerRef,
  innerProps,
  selectProps
}) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const { toggleAllOptions, components } = selectProps;
  const optionsElement = (_a = components == null ? void 0 : components.Option) != null ? _a : SelectMenuOptions;
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ...innerProps,
      "data-testid": e2eSelectors.selectors.components.Select.menu,
      className: styles.menu,
      style: { maxHeight },
      "aria-label": t("grafana-ui.select.menu-label", "Select options menu"),
      children: /* @__PURE__ */ jsxRuntime.jsxs(ScrollContainer, { ref: innerRef, maxHeight: "inherit", overflowX: "hidden", showScrollIndicators: true, padding: 0.5, children: [
        toggleAllOptions && /* @__PURE__ */ jsxRuntime.jsx(
          ToggleAllOption,
          {
            state: toggleAllOptions.state,
            optionComponent: optionsElement,
            selectedCount: toggleAllOptions.selectedCount,
            onClick: toggleAllOptions.selectAllClicked
          }
        ),
        children
      ] })
    }
  );
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 8;
const VIRTUAL_LIST_PADDING = 8;
const VIRTUAL_LIST_WIDTH_EXTRA = 58;
const VirtualizedSelectMenu = ({
  children,
  maxHeight,
  innerRef: scrollRef,
  options,
  selectProps,
  focusedOption
}) => {
  var _a, _b;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const listRef = React.useRef(null);
  const { toggleAllOptions, components } = selectProps;
  const optionComponent = (_a = components == null ? void 0 : components.Option) != null ? _a : SelectMenuOptions;
  const flattenedOptions = React.useMemo(
    () => options.flatMap((option) => option.options ? [option, ...option.options] : [option]),
    [options]
  );
  const focusedIndex = flattenedOptions.findIndex(
    (option) => option.value === (focusedOption == null ? void 0 : focusedOption.value)
  );
  React.useLayoutEffect(() => {
    var _a2;
    (_a2 = listRef.current) == null ? void 0 : _a2.scrollToItem(focusedIndex);
  }, [focusedIndex]);
  if (!Array.isArray(children)) {
    return null;
  }
  const flattenedChildren = children.flatMap((child, index) => {
    if (hasArrayChildren(child)) {
      const childWithoutChildren = React__namespace.cloneElement(child, {
        children: null
      });
      return [
        childWithoutChildren,
        ...child.props.children.slice(0, -1),
        // add a bottom divider to the last item in the category
        React__namespace.cloneElement(child.props.children.at(-1), {
          innerProps: {
            ...child.props.children.at(-1).props.innerProps,
            style: {
              borderBottom: `1px solid ${theme.colors.border.weak}`,
              height: VIRTUAL_LIST_ITEM_HEIGHT
            }
          }
        })
      ];
    }
    return [child];
  });
  if (toggleAllOptions) {
    flattenedChildren.unshift(
      /* @__PURE__ */ jsxRuntime.jsx(
        ToggleAllOption,
        {
          optionComponent,
          state: toggleAllOptions.state,
          selectedCount: toggleAllOptions.selectedCount,
          onClick: toggleAllOptions.selectAllClicked
        }
      )
    );
  }
  let longestOption = (_b = lodash.max(flattenedOptions.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _b : 0;
  if (toggleAllOptions && longestOption < 12) {
    longestOption = 12;
  }
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER + VIRTUAL_LIST_PADDING * 2 + VIRTUAL_LIST_WIDTH_EXTRA;
  const heightEstimate = Math.min(flattenedChildren.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactWindow.FixedSizeList,
    {
      outerRef: scrollRef,
      ref: listRef,
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": t("grafana-ui.select.menu-label", "Select options menu"),
      itemCount: flattenedChildren.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      children: ({ index, style }) => /* @__PURE__ */ jsxRuntime.jsx("div", { style: { ...style, overflow: "hidden" }, children: flattenedChildren[index] })
    }
  );
};
const hasArrayChildren = (child) => {
  return React__namespace.isValidElement(child) && Array.isArray(child.props.children);
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const ToggleAllOption = ({
  state,
  onClick,
  selectedCount,
  optionComponent
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      "data-testid": e2eSelectors.selectors.components.Select.toggleAllOptions,
      className: css.css(clearButtonStyles(theme), styles.toggleAllButton, {
        height: VIRTUAL_LIST_ITEM_HEIGHT
      }),
      onClick,
      children: optionComponent({
        isDisabled: false,
        isSelected: state === ToggleAllState.allSelected,
        isFocused: false,
        data: {},
        indeterminate: state === ToggleAllState.indeterminate,
        innerRef: () => {
        },
        innerProps: {},
        children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "select.select-menu.selected-count", children: "Selected " }),
          `(${selectedCount != null ? selectedCount : 0})`
        ] })
      })
    }
  );
};
const SelectMenuOptions = ({
  children,
  data: data$1,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  const { onMouseMove, onMouseOver, ...rest } = innerProps;
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      ref: innerRef,
      className: css.cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data$1.isDisabled && styles.optionDisabled
      ),
      ...rest,
      "data-testid": e2eSelectors.selectors.components.Select.option,
      title: data$1.title,
      children: [
        icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, className: styles.optionIcon }),
        data$1.imgUrl && /* @__PURE__ */ jsxRuntime.jsx("img", { className: styles.optionImage, src: data$1.imgUrl, alt: data$1.label || String(data$1.value) }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.optionBody, children: [
          /* @__PURE__ */ jsxRuntime.jsx("span", { children: renderOptionLabel ? renderOptionLabel(data$1) : children }),
          data$1.description && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionDescription, children: data$1.description }),
          data$1.component && /* @__PURE__ */ jsxRuntime.jsx(data$1.component, {})
        ] })
      ]
    }
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

"use strict";
const SelectOptionGroup = ({
  children,
  cx,
  getClassNames,
  getStyles,
  Heading,
  headingProps,
  label,
  selectProps,
  theme
}) => {
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.group, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Heading,
      {
        cx,
        getClassNames,
        getStyles,
        selectProps,
        theme,
        ...headingProps,
        children: label
      }
    ),
    children
  ] });
};

"use strict";
const SelectOptionGroupHeader = (props) => {
  var _a;
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.groupHeader, children: /* @__PURE__ */ jsxRuntime.jsx(Text, { weight: "bold", variant: "bodySmall", color: "secondary", children: (_a = props.children) != null ? _a : "" }) });
};

"use strict";
class UnthemedValueContainer extends React.Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    var _a, _b;
    const { isMulti, theme, selectProps } = this.props;
    const noWrap = ((_a = this.props.selectProps) == null ? void 0 : _a.noMultiValueWrap) && !((_b = this.props.selectProps) == null ? void 0 : _b.menuIsOpen);
    const styles = getSelectStyles(theme);
    const dataTestid = selectProps["data-testid"];
    const className = css.cx(styles.valueContainer, {
      [styles.valueContainerMulti]: isMulti && !noWrap,
      [styles.valueContainerMultiNoWrap]: isMulti && noWrap
    });
    return /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": dataTestid, className, children });
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

"use strict";
const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? void 0 : filtered.length) ? filtered : void 0;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return void 0;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map(({ description, ...rest }) => rest);
};

"use strict";
const CustomControl = (props) => {
  const {
    children,
    innerProps,
    selectProps: { menuIsOpen, onMenuClose, onMenuOpen },
    isFocused,
    isMulti,
    getValue,
    innerRef
  } = props;
  const selectProps = props.selectProps;
  if (selectProps.renderControl) {
    return React__namespace.createElement(selectProps.renderControl, {
      isOpen: menuIsOpen,
      value: isMulti ? getValue() : getValue()[0],
      ref: innerRef,
      onClick: menuIsOpen ? onMenuClose : onMenuOpen,
      onBlur: onMenuClose,
      disabled: !!selectProps.disabled,
      invalid: !!selectProps.invalid
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    InputControl$1,
    {
      ref: innerRef,
      innerProps,
      prefix: selectProps.prefix,
      focused: isFocused,
      invalid: !!selectProps.invalid,
      disabled: !!selectProps.disabled,
      children
    }
  );
};
function determineToggleAllState(selectedValue, options) {
  if (options.length === selectedValue.length) {
    return ToggleAllState.allSelected;
  } else if (selectedValue.length === 0) {
    return ToggleAllState.noneSelected;
  } else {
    return ToggleAllState.indeterminate;
  }
}
function SelectBase({
  allowCustomValue = false,
  allowCreateWhileLoading = false,
  "aria-label": ariaLabel,
  "data-testid": dataTestid,
  autoFocus = false,
  backspaceRemovesValue = true,
  blurInputOnSelect,
  cacheOptions,
  className,
  closeMenuOnSelect = true,
  components,
  createOptionPosition = "last",
  defaultOptions,
  defaultValue,
  disabled = false,
  filterOption,
  formatCreateLabel,
  getOptionLabel,
  getOptionValue,
  inputValue,
  invalid,
  isClearable = false,
  id,
  isLoading = false,
  isMulti = false,
  inputId,
  isOpen,
  isOptionDisabled,
  isSearchable = true,
  loadOptions,
  loadingMessage = "Loading options...",
  maxMenuHeight = 300,
  minMenuHeight,
  maxVisibleValues,
  menuPlacement = "auto",
  menuPosition,
  menuShouldPortal = true,
  noOptionsMessage = t("grafana-ui.select.no-options-label", "No options found"),
  onBlur,
  onChange,
  onCloseMenu,
  onCreateOption,
  onInputChange,
  onKeyDown,
  onMenuScrollToBottom,
  onMenuScrollToTop,
  onOpenMenu,
  onFocus,
  toggleAllOptions,
  openMenuOnFocus = false,
  options = [],
  placeholder = t("grafana-ui.select.placeholder", "Choose"),
  prefix,
  renderControl,
  showAllSelectedWhenOpen = true,
  tabSelectsValue = true,
  value,
  virtualized = false,
  noMultiValueWrap,
  width,
  isValidNewOption,
  formatOptionLabel,
  hideSelectedOptions,
  ...rest
}) {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const reactSelectRef = React.useRef(null);
  const [closeToBottom, setCloseToBottom] = React.useState(false);
  const selectStyles = useCustomSelectStyles(theme, width);
  const [hasInputValue, setHasInputValue] = React.useState(!!inputValue);
  React.useEffect(() => {
    if (loadOptions && isOpen && reactSelectRef.current && reactSelectRef.current.controlRef && menuPlacement === "auto") {
      const distance = window.innerHeight - reactSelectRef.current.controlRef.getBoundingClientRect().bottom;
      setCloseToBottom(distance < maxMenuHeight);
    }
  }, [maxMenuHeight, menuPlacement, loadOptions, isOpen]);
  const onChangeWithEmpty = React.useCallback(
    (value2, action) => {
      if (isMulti && (value2 === void 0 || value2 === null)) {
        return onChange([], action);
      }
      onChange(value2, action);
    },
    [isMulti, onChange]
  );
  let ReactSelectComponent = ReactSelect__default.default;
  const creatableProps = {};
  let asyncSelectProps = {};
  let selectedValue;
  if (isMulti && loadOptions) {
    selectedValue = value;
  } else {
    if (isMulti && value && Array.isArray(value) && !loadOptions) {
      selectedValue = value.map((v) => {
        var _a;
        const selectableValue = findSelectedValue((_a = v.value) != null ? _a : v, options);
        if (selectableValue) {
          return selectableValue;
        }
        return typeof v === "string" ? data.toOption(v) : v;
      });
    } else if (loadOptions) {
      const hasValue = defaultValue || value;
      selectedValue = hasValue ? [hasValue] : [];
    } else {
      selectedValue = cleanValue(value, options);
    }
  }
  const commonSelectProps = {
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus,
    backspaceRemovesValue,
    blurInputOnSelect,
    captureMenuScroll: onMenuScrollToBottom || onMenuScrollToTop,
    closeMenuOnSelect,
    // We don't want to close if we're actually scrolling the menu
    // So only close if none of the parents are the select menu itself
    defaultValue,
    // Also passing disabled, as this is the new Select API, and I want to use this prop instead of react-select's one
    disabled,
    // react-select always tries to filter the options even at first menu open, which is a problem for performance
    // in large lists. So we set it to not try to filter the options if there is no input value.
    filterOption: hasInputValue ? filterOption : null,
    getOptionLabel,
    getOptionValue,
    hideSelectedOptions,
    inputValue,
    invalid,
    isClearable,
    id,
    // Passing isDisabled as react-select accepts this prop
    isDisabled: disabled,
    isLoading,
    isMulti,
    inputId,
    isOptionDisabled,
    isSearchable,
    maxMenuHeight,
    minMenuHeight,
    maxVisibleValues,
    menuIsOpen: isOpen,
    menuPlacement: menuPlacement === "auto" && closeToBottom ? "top" : menuPlacement,
    menuPosition,
    menuShouldBlockScroll: true,
    menuPortalTarget: menuShouldPortal && typeof document !== "undefined" ? document.body : void 0,
    menuShouldScrollIntoView: false,
    onBlur,
    onChange: onChangeWithEmpty,
    onInputChange: (val, actionMeta) => {
      var _a;
      const newValue = (_a = onInputChange == null ? void 0 : onInputChange(val, actionMeta)) != null ? _a : val;
      const newHasValue = !!newValue;
      if (newHasValue !== hasInputValue) {
        setHasInputValue(newHasValue);
      }
      return newValue;
    },
    onKeyDown,
    onMenuClose: onCloseMenu,
    onMenuOpen: onOpenMenu,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onFocus,
    formatOptionLabel,
    openMenuOnFocus,
    options: virtualized ? omitDescriptions(options) : options,
    placeholder,
    prefix,
    renderControl,
    showAllSelectedWhenOpen,
    tabSelectsValue,
    value: isMulti ? selectedValue : selectedValue == null ? void 0 : selectedValue[0],
    noMultiValueWrap
  };
  if (allowCustomValue) {
    ReactSelectComponent = Creatable__default.default;
    creatableProps.allowCreateWhileLoading = allowCreateWhileLoading;
    creatableProps.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : defaultFormatCreateLabel;
    creatableProps.onCreateOption = onCreateOption;
    creatableProps.createOptionPosition = createOptionPosition;
    creatableProps.isValidNewOption = isValidNewOption;
  }
  if (loadOptions) {
    ReactSelectComponent = allowCustomValue ? AsyncCreatable__default.default : ReactAsyncSelect__default.default;
    asyncSelectProps = {
      loadOptions,
      cacheOptions,
      defaultOptions
    };
  }
  const SelectMenuComponent = virtualized ? VirtualizedSelectMenu : SelectMenu;
  let toggleAllState = ToggleAllState.noneSelected;
  if ((toggleAllOptions == null ? void 0 : toggleAllOptions.enabled) && lodash.isArray(selectedValue)) {
    if (toggleAllOptions == null ? void 0 : toggleAllOptions.determineToggleAllState) {
      toggleAllState = toggleAllOptions.determineToggleAllState(selectedValue, options);
    } else {
      toggleAllState = determineToggleAllState(selectedValue, options);
    }
  }
  const toggleAll = React.useCallback(() => {
    let toSelect = toggleAllState === ToggleAllState.noneSelected ? options : [];
    if (toggleAllOptions == null ? void 0 : toggleAllOptions.optionsFilter) {
      toSelect = toggleAllState === ToggleAllState.noneSelected ? options.filter(toggleAllOptions.optionsFilter) : options.filter(lodash.negate(toggleAllOptions.optionsFilter));
    }
    onChange(toSelect, {
      action: "select-option",
      option: {}
    });
  }, [options, toggleAllOptions, onChange, toggleAllState]);
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
    ReactSelectComponent,
    {
      ref: reactSelectRef,
      components: {
        MenuList: SelectMenuComponent,
        Group: SelectOptionGroup,
        GroupHeading: SelectOptionGroupHeader,
        ValueContainer,
        IndicatorsContainer: CustomIndicatorsContainer,
        IndicatorSeparator,
        Control: CustomControl,
        Option: SelectMenuOptions,
        ClearIndicator(props) {
          const { clearValue } = props;
          return /* @__PURE__ */ jsxRuntime.jsx(
            Icon,
            {
              name: "times",
              role: "button",
              "aria-label": t("grafana-ui.select.clear-value", "Clear value"),
              className: styles.singleValueRemove,
              onMouseDown: (e) => {
                e.preventDefault();
                e.stopPropagation();
                clearValue();
              }
            }
          );
        },
        LoadingIndicator() {
          return /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true });
        },
        LoadingMessage() {
          return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.loadingMessage, children: loadingMessage });
        },
        NoOptionsMessage() {
          return /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: styles.loadingMessage,
              "aria-label": t("grafana-ui.select.empty-options", "No options provided"),
              children: noOptionsMessage
            }
          );
        },
        DropdownIndicator,
        SingleValue(props) {
          return /* @__PURE__ */ jsxRuntime.jsx(SingleValue, { ...props, isDisabled: disabled });
        },
        SelectContainer,
        MultiValueContainer,
        MultiValueRemove: !disabled ? MultiValueRemove : () => null,
        Input: CustomInput,
        ...components
      },
      toggleAllOptions: (toggleAllOptions == null ? void 0 : toggleAllOptions.enabled) && {
        state: toggleAllState,
        selectAllClicked: toggleAll,
        selectedCount: lodash.isArray(selectedValue) ? selectedValue.length : void 0
      },
      styles: selectStyles,
      className,
      ...commonSelectProps,
      ...creatableProps,
      ...asyncSelectProps,
      ...rest
    }
  ) });
}
function defaultFormatCreateLabel(input) {
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { display: "flex", gap: "8px", alignItems: "center" }, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: input }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { style: { flexGrow: 1 } }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: "muted small", style: { display: "flex", gap: "8px", alignItems: "center" }, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.select.default-create-label", children: "Hit enter to add" }) })
  ] });
}
function CustomIndicatorsContainer(props) {
  const { showAllSelectedWhenOpen, maxVisibleValues, menuIsOpen } = props.selectProps;
  const value = props.getValue();
  if (maxVisibleValues !== void 0 && Array.isArray(props.children)) {
    const selectedValuesCount = value.length;
    if (selectedValuesCount > maxVisibleValues && !(showAllSelectedWhenOpen && menuIsOpen)) {
      const indicatorChildren = [...props.children];
      indicatorChildren.splice(
        -1,
        0,
        /* @__PURE__ */ jsxRuntime.jsx("span", { id: "excess-values", children: `(+${selectedValuesCount - maxVisibleValues})` }, "excess-values")
      );
      return /* @__PURE__ */ jsxRuntime.jsx(IndicatorsContainer, { ...props, children: indicatorChildren });
    }
  }
  return /* @__PURE__ */ jsxRuntime.jsx(IndicatorsContainer, { ...props });
}
function IndicatorSeparator() {
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, {});
}

"use strict";
function Select(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props });
}
function MultiSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props, isMulti: true });
}
function AsyncSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props });
}
function VirtualizedSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { virtualized: true, ...props });
}
function AsyncVirtualizedSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { virtualized: true, ...props });
}
function AsyncMultiSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props, isMulti: true });
}

"use strict";
const onChangeCascader = (onChanged) => (values, options) => {
  if (onChanged) {
    onChanged(
      values.map((value) => String(value)),
      fromRCOptions(options)
    );
  }
};
const onLoadDataCascader = (onLoadData) => (options) => {
  if (onLoadData) {
    onLoadData(fromRCOptions(options));
  }
};
const fromRCOptions = (options) => {
  return options.map(fromRCOption);
};
const fromRCOption = (option) => {
  const value = option.value ? String(option.value) : "";
  return {
    value,
    label: typeof option.label === "string" ? option.label : value
  };
};

"use strict";
const slideUpIn = css.keyframes({
  "0%": {
    opacity: 0,
    transformOrigin: "0% 0%",
    transform: "scaleY(0.8)"
  },
  "100%": {
    opacity: 1,
    transformOrigin: "0% 0%",
    transform: "scaleY(1)"
  }
});
const slideUpOut = css.keyframes({
  "0%": {
    opacity: 1,
    transformOrigin: "0% 0%",
    transform: "scaleY(1)"
  },
  "100%": {
    opacity: 0,
    transformOrigin: "0% 0%",
    transform: "scaleY(0.8)"
  }
});
const slideDownIn = css.keyframes({
  "0%": {
    opacity: 0,
    transformOrigin: "0% 100%",
    transform: "scaleY(0.8)"
  },
  "100%": {
    opacity: 1,
    transformOrigin: "0% 100%",
    transform: "scaleY(1)"
  }
});
const slideDownOut = css.keyframes({
  "0%": {
    opacity: 1,
    transformOrigin: "0% 100%",
    transform: "scaleY(1)"
  },
  "100%": {
    opacity: 0,
    transformOrigin: "0% 100%",
    transform: "scaleY(0.8)"
  }
});
const getCascaderStyles = (theme) => ({
  dropdown: css.css({
    "&.rc-cascader-dropdown": {
      position: "absolute",
      // Required, otherwise the portal that the popup is shown in will render under other components
      zIndex: 9999,
      "&-hidden": {
        display: "none"
      }
    },
    ".rc-cascader": {
      "&-menus": {
        overflow: "hidden",
        background: theme.colors.background.elevated,
        border: `none`,
        borderRadius: theme.shape.radius.default,
        boxShadow: theme.shadows.z3,
        whiteSpace: "nowrap",
        "&.slide-up-enter, &.slide-up-appear": {
          animationDuration: "0.3s",
          animationFillMode: "both",
          transformOrigin: "0 0",
          opacity: 0,
          animationTimingFunction: "cubic-bezier(0.08, 0.82, 0.17, 1)",
          animationPlayState: "paused"
        },
        "&.slide-up-enter.slide-up-enter-active.rc-cascader-menus-placement, &.slide-up-appear.slide-up-appear-active.rc-cascader-menus-placement": {
          "&-bottomLeft": {
            animationName: slideUpIn,
            animationPlayState: "running"
          },
          "&-topLeft": {
            animationName: slideDownIn,
            animationPlayState: "running"
          }
        },
        "&.slide-up-leave": {
          animationDuration: "0.3s",
          animationFillMode: "both",
          transformOrigin: "0 0",
          opacity: 1,
          animationTimingFunction: "cubic-bezier(0.6, 0.04, 0.98, 0.34)",
          animationPlayState: "paused",
          "&.slide-up-leave-active.rc-cascader-menus-placement": {
            "&-bottomLeft": {
              animationName: slideUpOut,
              animationPlayState: "running"
            },
            "&-topLeft": {
              animationName: slideDownOut,
              animationPlayState: "running"
            }
          }
        }
      },
      "&-menu": {
        display: "inline-block",
        maxWidth: "50vw",
        height: "192px",
        listStyle: "none",
        margin: 0,
        padding: theme.spacing(0.5),
        borderRight: `1px solid ${theme.colors.border.weak}`,
        overflow: "auto",
        "&:last-child": {
          borderRight: 0
        },
        "&-item": {
          height: theme.spacing(4),
          lineHeight: theme.spacing(4),
          padding: theme.spacing(0, 4, 0, 2),
          borderRadius: theme.shape.radius.default,
          cursor: "pointer",
          whiteSpace: "nowrap",
          overflow: "hidden",
          textOverflow: "ellipsis",
          transition: "all 0.3s ease",
          position: "relative",
          "&:hover": {
            background: theme.colors.action.hover
          },
          "&-disabled": {
            cursor: "not-allowed",
            color: theme.colors.text.disabled,
            "&:hover": {
              background: "transparent"
            },
            "&:after": {
              position: "absolute",
              right: "12px",
              content: "'loading'",
              color: theme.colors.text.disabled,
              fontStyle: "italic"
            }
          },
          "&-active": {
            color: theme.colors.text.maxContrast,
            background: theme.colors.background.secondary,
            "&:hover": {
              background: theme.colors.action.hover
            }
          },
          "&-expand": {
            position: "relative",
            "&:after": {
              background: theme.colors.background.secondary,
              content: "''",
              height: theme.spacing(3),
              mask: "url(../img/icons/unicons/angle-right.svg)",
              maskType: "luminance",
              position: "absolute",
              right: 0,
              top: theme.spacing(0.5),
              width: theme.spacing(3)
            }
          }
        }
      }
    }
  })
});

"use strict";
const disableDivFocus = css.css({
  "&:focus": {
    outline: "none"
  }
});
const DEFAULT_SEPARATOR = " / ";
class UnthemedCascader extends React.PureComponent {
  constructor(props) {
    super(props);
    this.flattenOptions = (options, optionPath = []) => {
      let selectOptions = [];
      for (const option of options) {
        const cpy = [...optionPath];
        cpy.push(option);
        if (!option.items || option.items.length === 0) {
          selectOptions.push({
            singleLabel: cpy[cpy.length - 1].label,
            label: cpy.map((o) => o.label).join(this.props.separator || DEFAULT_SEPARATOR),
            value: cpy.map((o) => o.value)
          });
        } else {
          selectOptions = [...selectOptions, ...this.flattenOptions(option.items, cpy)];
        }
      }
      return selectOptions;
    };
    this.getSearchableOptions = memoize__default.default((options) => this.flattenOptions(options));
    //For rc-cascader
    this.onChange = (value, selectedOptions) => {
      const activeLabel = this.props.hideActiveLevelLabel ? "" : this.props.displayAllSelectedLevels ? selectedOptions.map((option) => option.label).join(this.props.separator || DEFAULT_SEPARATOR) : selectedOptions[selectedOptions.length - 1].label;
      const state = {
        rcValue: { value, label: activeLabel },
        focusCascade: true,
        activeLabel,
        isSearching: false,
        inputValue: activeLabel
      };
      this.setState(state);
      this.props.onSelect(selectedOptions[selectedOptions.length - 1].value);
    };
    //For select
    this.onSelect = (obj) => {
      const valueArray = obj.value || [];
      const activeLabel = this.props.displayAllSelectedLevels ? obj.label : obj.singleLabel || "";
      const state = {
        activeLabel,
        inputValue: activeLabel,
        rcValue: { value: valueArray, label: activeLabel },
        isSearching: false,
        focusCascade: false
      };
      this.setState(state);
      this.props.onSelect(valueArray[valueArray.length - 1]);
    };
    this.onCreateOption = (value) => {
      this.setState({
        activeLabel: value,
        inputValue: value,
        rcValue: [],
        isSearching: false
      });
      this.props.onSelect(value);
    };
    this.onBlur = () => {
      var _a, _b;
      this.setState({
        isSearching: false,
        focusCascade: false
      });
      if (this.state.activeLabel === "") {
        this.setState({
          rcValue: []
        });
      }
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onBlurCascade = () => {
      var _a, _b;
      this.setState({
        focusCascade: false
      });
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onInputKeyDown = (e) => {
      if (["ArrowDown", "ArrowUp", "Enter", "ArrowLeft", "ArrowRight"].includes(e.key)) {
        return;
      }
      const { activeLabel } = this.state;
      this.setState({
        focusCascade: false,
        isSearching: true,
        inputValue: activeLabel
      });
    };
    this.onSelectInputChange = (value) => {
      this.setState({
        inputValue: value
      });
    };
    const searchableOptions = this.getSearchableOptions(props.options);
    const { rcValue, activeLabel } = this.setInitialValue(searchableOptions, props.initialValue);
    this.state = {
      isSearching: false,
      focusCascade: false,
      rcValue,
      activeLabel,
      inputValue: ""
    };
  }
  setInitialValue(searchableOptions, initValue) {
    if (!initValue) {
      return { rcValue: [], activeLabel: "" };
    }
    for (const option of searchableOptions) {
      const optionPath = option.value || [];
      if (optionPath[optionPath.length - 1] === initValue) {
        return {
          rcValue: optionPath,
          activeLabel: this.props.displayAllSelectedLevels ? option.label : option.singleLabel || ""
        };
      }
    }
    if (this.props.allowCustomValue) {
      return { rcValue: [], activeLabel: initValue };
    }
    return { rcValue: [], activeLabel: "" };
  }
  render() {
    const {
      allowCustomValue,
      formatCreateLabel,
      placeholder,
      width,
      changeOnSelect,
      options,
      disabled,
      id,
      isClearable,
      theme
    } = this.props;
    const { focusCascade, isSearching, rcValue, activeLabel, inputValue } = this.state;
    const searchableOptions = this.getSearchableOptions(options);
    const styles = getCascaderStyles(theme);
    return /* @__PURE__ */ jsxRuntime.jsx("div", { children: isSearching ? /* @__PURE__ */ jsxRuntime.jsx(
      Select,
      {
        allowCustomValue,
        placeholder,
        autoFocus: !focusCascade,
        onChange: this.onSelect,
        onBlur: this.onBlur,
        options: searchableOptions,
        onCreateOption: this.onCreateOption,
        formatCreateLabel,
        width,
        onInputChange: this.onSelectInputChange,
        disabled,
        inputValue,
        inputId: id
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx(
      RCCascader__default.default,
      {
        onChange: onChangeCascader(this.onChange),
        options,
        changeOnSelect,
        value: rcValue.value,
        fieldNames: { label: "label", value: "value", children: "items" },
        expandIcon: null,
        open: this.props.alwaysOpen,
        disabled,
        dropdownClassName: styles.dropdown,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: disableDivFocus, children: /* @__PURE__ */ jsxRuntime.jsx(
          Input,
          {
            autoFocus: this.props.autoFocus,
            width,
            placeholder,
            onBlur: this.onBlurCascade,
            value: activeLabel,
            onKeyDown: this.onInputKeyDown,
            onChange: () => {
            },
            suffix: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 0.5, children: [
              isClearable && activeLabel !== "" && /* @__PURE__ */ jsxRuntime.jsx(
                IconButton,
                {
                  name: "times",
                  "aria-label": t("grafana-ui.cascader.clear-button", "Clear selection"),
                  onClick: (e) => {
                    e.preventDefault();
                    e.stopPropagation();
                    this.setState({ rcValue: [], activeLabel: "", inputValue: "" });
                    this.props.onSelect("");
                  }
                }
              ),
              /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: focusCascade ? "angle-up" : "angle-down" })
            ] }),
            disabled,
            id
          }
        ) })
      }
    ) });
  }
}
UnthemedCascader.defaultProps = { changeOnSelect: true };
const Cascader = withTheme2(UnthemedCascader);

"use strict";
const Alert = React__namespace.forwardRef(
  ({
    title,
    onRemove,
    children,
    buttonContent,
    elevated,
    bottomSpacing,
    topSpacing,
    className,
    severity = "error",
    ...restProps
  }, ref) => {
    const theme = useTheme2();
    const hasTitle = Boolean(title);
    const styles = getStyles$1L(theme, severity, hasTitle, elevated, bottomSpacing, topSpacing);
    const rolesBySeverity = {
      error: "alert",
      warning: "alert",
      info: "status",
      success: "status"
    };
    const role = restProps["role"] || rolesBySeverity[severity];
    const ariaLabel = restProps["aria-label"] || title;
    const closeLabel = t("grafana-ui.alert.close-button", "Close alert");
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx(styles.wrapper, className), role, "aria-label": ariaLabel, ...restProps, children: /* @__PURE__ */ jsxRuntime.jsxs(
      Box,
      {
        "data-testid": e2eSelectors.selectors.components.Alert.alertV2(severity),
        display: "flex",
        backgroundColor: severity,
        borderRadius: "default",
        paddingY: 1,
        paddingX: 2,
        borderStyle: "solid",
        borderColor: severity,
        alignItems: "stretch",
        boxShadow: elevated ? "z3" : void 0,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(Box, { paddingTop: 1, paddingRight: 2, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.icon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "xl", name: getIconFromSeverity(severity) }) }) }),
          /* @__PURE__ */ jsxRuntime.jsxs(Box, { paddingY: 1, grow: 1, children: [
            /* @__PURE__ */ jsxRuntime.jsx(Text, { color: "primary", weight: "medium", children: title }),
            children && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.content, children })
          ] }),
          onRemove && !buttonContent && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.close, children: /* @__PURE__ */ jsxRuntime.jsx(
            Button,
            {
              "aria-label": closeLabel,
              icon: "times",
              onClick: onRemove,
              type: "button",
              fill: "text",
              variant: "secondary"
            }
          ) }),
          onRemove && buttonContent && /* @__PURE__ */ jsxRuntime.jsx(Box, { marginLeft: 1, display: "flex", alignItems: "center", children: /* @__PURE__ */ jsxRuntime.jsx(Button, { "aria-label": closeLabel, variant: "secondary", onClick: onRemove, type: "button", children: buttonContent }) })
        ]
      }
    ) });
  }
);
Alert.displayName = "Alert";
const getIconFromSeverity = (severity) => {
  switch (severity) {
    case "error":
      return "exclamation-circle";
    case "warning":
      return "exclamation-triangle";
    case "info":
      return "info-circle";
    case "success":
      return "check";
  }
};
const getStyles$1L = (theme, severity, hasTitle, elevated, bottomSpacing, topSpacing) => {
  const color = theme.colors[severity];
  return {
    wrapper: css.css({
      flexGrow: 1,
      marginBottom: theme.spacing(bottomSpacing != null ? bottomSpacing : 2),
      marginTop: theme.spacing(topSpacing != null ? topSpacing : 0),
      position: "relative",
      "&:before": {
        content: '""',
        position: "absolute",
        top: 0,
        left: 0,
        bottom: 0,
        right: 0,
        background: theme.colors.background.primary,
        zIndex: -1
      }
    }),
    icon: css.css({
      color: color.text,
      position: "relative",
      top: "-1px"
    }),
    content: css.css({
      color: theme.colors.text.primary,
      paddingTop: hasTitle ? theme.spacing(0.5) : 0,
      maxHeight: "50vh",
      overflowY: "auto"
    }),
    close: css.css({
      position: "relative",
      color: theme.colors.text.secondary,
      background: "none",
      display: "flex",
      top: "-6px",
      right: "-14px"
    })
  };
};

"use strict";
const Carousel = ({ images }) => {
  const [selectedIndex, setSelectedIndex] = React.useState(null);
  const [imageErrors, setImageErrors] = React.useState({});
  const [validImages, setValidImages] = React.useState(images);
  const styles = useStyles2(getStyles$1K());
  const handleImageError = (path) => {
    setImageErrors((prev) => ({
      ...prev,
      [path]: true
    }));
  };
  React.useEffect(() => {
    const filteredImages = images.filter((image) => !imageErrors[image.path]);
    setValidImages(filteredImages);
  }, [imageErrors, images]);
  const openPreview = (index) => {
    setSelectedIndex(index);
  };
  const closePreview = () => {
    setSelectedIndex(null);
  };
  const goToNext = () => {
    if (selectedIndex !== null && validImages.length > 0) {
      setSelectedIndex((selectedIndex + 1) % validImages.length);
    }
  };
  const goToPrevious = () => {
    if (selectedIndex !== null && validImages.length > 0) {
      setSelectedIndex((selectedIndex - 1 + validImages.length) % validImages.length);
    }
  };
  const handleKeyDown = (event) => {
    if (selectedIndex === null) {
      return;
    }
    switch (event.key) {
      case "ArrowRight":
        goToNext();
        break;
      case "ArrowLeft":
        goToPrevious();
        break;
      case "Escape":
        closePreview();
        break;
      default:
        break;
    }
  };
  if (validImages.length === 0) {
    return /* @__PURE__ */ jsxRuntime.jsx(
      Alert,
      {
        title: t("carousel.error", "Something went wrong loading images"),
        severity: "warning",
        "data-testid": "alert-warning"
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { onKeyDown: handleKeyDown, tabIndex: 0, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.imageGrid), children: validImages.map((image, index) => /* @__PURE__ */ jsxRuntime.jsxs("div", { onClick: () => openPreview(index), style: { cursor: "pointer" }, children: [
      /* @__PURE__ */ jsxRuntime.jsx("img", { src: image.path, alt: image.name, onError: () => handleImageError(image.path) }),
      /* @__PURE__ */ jsxRuntime.jsx("p", { children: image.name })
    ] }, image.path)) }),
    selectedIndex !== null && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.fullScreenDiv), onClick: closePreview, "data-testid": "carousel-full-screen", children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        IconButton,
        {
          name: "times",
          "aria-label": t("carousel.close", "Close"),
          size: "xl",
          onClick: closePreview,
          className: css.cx(styles.closeButton)
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        IconButton,
        {
          size: "xl",
          name: "angle-left",
          "aria-label": t("carousel.previous", "Previous"),
          onClick: (e) => {
            e.stopPropagation();
            goToPrevious();
          },
          className: css.cx(styles.navigationButton, styles.previousButton),
          "data-testid": "previous-button"
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          style: { position: "relative", maxWidth: "90%", maxHeight: "90%" },
          onClick: (e) => e.stopPropagation(),
          "data-testid": "carousel-full-image",
          children: /* @__PURE__ */ jsxRuntime.jsx(
            "img",
            {
              src: validImages[selectedIndex].path,
              alt: validImages[selectedIndex].name,
              onError: () => handleImageError(validImages[selectedIndex].path)
            }
          )
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        IconButton,
        {
          size: "xl",
          name: "angle-right",
          "aria-label": t("carousel.next", "Next"),
          onClick: (e) => {
            e.stopPropagation();
            goToNext();
          },
          className: css.cx(styles.navigationButton, styles.nextButton),
          "data-testid": "next-button"
        }
      )
    ] })
  ] });
};
const getStyles$1K = () => (theme) => ({
  imageGrid: css.css({
    display: "grid",
    gridTemplateColumns: `repeat(auto-fill, minmax(200px, 1fr))`,
    gap: "16px",
    marginBottom: "20px",
    "& img": {
      width: "100%",
      height: "150px",
      objectFit: "cover",
      border: theme.colors.border.strong,
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z1
    },
    "& p": {
      margin: "4px 0",
      fontWeight: theme.typography.fontWeightMedium,
      color: theme.colors.text.primary
    }
  }),
  fullScreenDiv: css.css({
    position: "fixed",
    zIndex: theme.zIndex.modalBackdrop,
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    backgroundColor: theme.components.overlay.background,
    alignItems: "center",
    justifyContent: "center",
    display: "flex",
    "& img": {
      maxWidth: "100%",
      maxHeight: "80vh",
      objectFit: "contain"
    }
  }),
  closeButton: css.css({
    position: "absolute",
    top: "20px",
    right: "20px",
    backgroundColor: "transparent",
    color: theme.colors.text.primary
  }),
  navigationButton: css.css({
    position: "absolute",
    backgroundColor: "transparent",
    color: theme.colors.text.primary,
    cursor: "pointer",
    display: "flex",
    alignItems: "center",
    justifyContent: "center"
  }),
  nextButton: css.css({
    right: "20px"
  }),
  previousButton: css.css({
    left: "20px"
  })
});

"use strict";
const ButtonCascader = (props) => {
  const { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled, ...rest } = props;
  const styles = useStyles2(getStyles$1J);
  const cascaderStyles = useStyles2(getCascaderStyles);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-down", className: styles.icons.right }, "down-icon")];
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    RCCascader__default.default,
    {
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: css.cx(cascaderStyles.dropdown, styles.popup),
      ...rest,
      expandIcon: null,
      children: /* @__PURE__ */ jsxRuntime.jsx(Button, { icon, disabled, variant, ...buttonProps != null ? buttonProps : {}, children: content })
    }
  );
};
ButtonCascader.displayName = "ButtonCascader";
const getStyles$1J = (theme) => {
  return {
    popup: css.css({
      label: "popup",
      zIndex: theme.zIndex.dropdown
    }),
    icons: {
      right: css.css({
        margin: "1px 0 0 4px"
      }),
      left: css.css({
        margin: "-1px 4px 0 0"
      })
    }
  };
};

"use strict";
const closePopover = (event, hidePopper) => {
  if (event.key === "Tab" || event.altKey || event.ctrlKey || event.metaKey) {
    return;
  }
  event.stopPropagation();
  if (event.key === "Escape") {
    hidePopper();
  }
  return;
};

"use strict";
var ColorSwatchVariant = /* @__PURE__ */ ((ColorSwatchVariant2) => {
  ColorSwatchVariant2["Small"] = "small";
  ColorSwatchVariant2["Large"] = "large";
  return ColorSwatchVariant2;
})(ColorSwatchVariant || {});
const ColorSwatch = React__namespace.forwardRef(
  ({ color, label, variant = "small" /* Small */, isSelected, "aria-label": ariaLabel, ...otherProps }, ref) => {
    const theme = useTheme2();
    const { isFocusVisible, focusProps } = focus.useFocusRing();
    const styles = getStyles$1I(theme, variant, color, isFocusVisible, isSelected);
    const hasLabel = !!label;
    const colorLabel = ariaLabel || label;
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { ref, className: styles.wrapper, "data-testid": e2eSelectors.selectors.components.ColorSwatch.name, ...otherProps, children: [
      hasLabel && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
      /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          className: styles.swatch,
          ...focusProps,
          "aria-label": colorLabel ? `${colorLabel} color` : "Pick a color",
          type: "button"
        }
      )
    ] });
  }
);
const getStyles$1I = (theme, variant, color, isFocusVisible, isSelected) => {
  const tc = tinycolor__default.default(color);
  const isSmall = variant === "small" /* Small */;
  const swatchSize = isSmall ? "16px" : "32px";
  let border = "none";
  if (tc.getAlpha() < 0.1) {
    border = `2px solid ${theme.colors.border.medium}`;
  }
  return {
    wrapper: css.css({
      display: "flex",
      alignItems: "center",
      cursor: "pointer"
    }),
    label: css.css({
      marginRight: theme.spacing(1)
    }),
    swatch: css.css({
      width: swatchSize,
      height: swatchSize,
      background: `${color}`,
      border,
      borderRadius: theme.shape.radius.circle,
      outlineOffset: "1px",
      outline: isFocusVisible ? `2px solid  ${theme.colors.primary.main}` : "none",
      boxShadow: isSelected ? `inset 0 0 0 2px ${color}, inset 0 0 0 4px ${theme.colors.getContrastText(color)}` : "none",
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["transform"], {
          duration: theme.transitions.duration.short
        })
      },
      "&:hover": {
        transform: "scale(1.1)"
      },
      "@media (forced-colors: active)": {
        forcedColorAdjust: "none"
      }
    })
  };
};
ColorSwatch.displayName = "ColorSwatch";

"use strict";
function reverseMap(arr, callbackfn) {
  const reversedAndMapped = new Array(arr.length);
  for (let i = 0; i < arr.length; i++) {
    const reverseIndex = arr.length - 1 - i;
    reversedAndMapped[i] = callbackfn(arr[reverseIndex], reverseIndex, arr);
  }
  return reversedAndMapped;
}

"use strict";
const NamedColorsGroup = ({ hue, selectedColor, onColorSelect, ...otherProps }) => {
  const label = lodash.upperFirst(hue.name);
  const styles = useStyles2(getStyles$1H);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.colorRow, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.colorLabel, children: label }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { ...otherProps, className: styles.swatchRow, children: reverseMap(hue.shades, (shade) => /* @__PURE__ */ jsxRuntime.jsx(
      ColorSwatch,
      {
        "aria-label": shade.name,
        variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
        isSelected: shade.name === selectedColor,
        color: shade.color,
        onClick: () => onColorSelect(shade.name)
      },
      shade.name
    )) })
  ] });
};
const getStyles$1H = (theme) => {
  return {
    colorRow: css.css({
      display: "grid",
      gridTemplateColumns: "25% 1fr",
      gridColumnGap: theme.spacing(2),
      padding: theme.spacing(0.5, 0),
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    colorLabel: css.css({
      paddingLeft: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    swatchRow: css.css({
      display: "flex",
      gap: theme.spacing(1),
      alignItems: "center",
      justifyContent: "space-around",
      flexDirection: "row"
    })
  };
};

"use strict";
const NamedColorsPalette = ({ color, onChange }) => {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1G);
  const swatches = [];
  for (const hue of theme.visualization.hues) {
    swatches.push(/* @__PURE__ */ jsxRuntime.jsx(NamedColorsGroup, { selectedColor: color, hue, onColorSelect: onChange }, hue.name));
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.swatches, children: swatches }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.extraColors, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorSwatch,
        {
          isSelected: color === "transparent",
          color: "rgba(0,0,0,0)",
          label: t("grafana-ui.named-colors-palette.transparent-swatch", "Transparent"),
          onClick: () => onChange("transparent")
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorSwatch,
        {
          isSelected: color === "text",
          color: theme.colors.text.primary,
          label: t("grafana-ui.named-colors-palette.text-color-swatch", "Text color"),
          onClick: () => onChange("text")
        }
      )
    ] })
  ] });
};
const getStyles$1G = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column"
    }),
    extraColors: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-around",
      gap: theme.spacing(1),
      padding: theme.spacing(1, 0)
    }),
    swatches: css.css({
      display: "grid",
      flexGrow: 1
    })
  };
};

"use strict";
const ColorInput = React.forwardRef(
  ({ color, onChange, isClearable = false, onClick, onBlur, disabled, buttonAriaLabel, ...inputProps }, ref) => {
    const [value, setValue] = React.useState(color);
    const [previousColor, setPreviousColor] = React.useState(color);
    const updateColor = React.useMemo(() => lodash.debounce(onChange, 100), []);
    React.useEffect(() => {
      const newColor = tinycolor__default.default(color);
      if (newColor.isValid() && color !== previousColor) {
        setValue(newColor.toString());
        setPreviousColor(color);
      }
    }, [color, previousColor]);
    const onChangeColor = (event) => {
      const { value: colorValue } = event.currentTarget;
      setValue(colorValue);
      if (colorValue === "" && isClearable) {
        updateColor(colorValue);
        return;
      }
      const newColor = tinycolor__default.default(colorValue);
      if (newColor.isValid()) {
        updateColor(newColor.toString());
      }
    };
    const onBlurInput = (event) => {
      const newColor = tinycolor__default.default(value);
      if (!newColor.isValid()) {
        setValue(color);
      }
      onBlur == null ? void 0 : onBlur(event);
    };
    return /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        ...inputProps,
        value,
        onChange: onChangeColor,
        disabled,
        onClick,
        onBlur: onBlurInput,
        addonBefore: /* @__PURE__ */ jsxRuntime.jsx(ColorPreview, { onClick, ariaLabel: buttonAriaLabel, disabled, color }),
        ref
      }
    );
  }
);
ColorInput.displayName = "ColorInput";
const ColorPreview = ({ color, onClick, disabled, ariaLabel }) => {
  const styles = useStyles2(getColorPreviewStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      type: "button",
      onClick,
      "aria-label": ariaLabel,
      disabled: disabled || !onClick,
      className: css.cx(
        styles,
        css.css({
          backgroundColor: color
        })
      )
    }
  );
};
const getColorPreviewStyles = (theme) => css.css({
  height: "100%",
  width: `${theme.spacing.gridSize * 4}px`,
  borderRadius: `${theme.shape.radius.default} 0 0 ${theme.shape.radius.default}`,
  border: `1px solid ${theme.colors.border.medium}`
});

"use strict";
const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = React.useState(color);
  reactUse.useThrottleFn(
    (c) => {
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1F);
  const rgbaString = React.useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor__default.default(theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(reactColorful.RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }),
    /* @__PURE__ */ jsxRuntime.jsx(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput })
  ] });
};
const getStyles$1F = (theme) => ({
  wrapper: css.css({
    flexGrow: 1
  }),
  root: css.css({
    "&.react-colorful": {
      width: "auto"
    },
    ".react-colorful": {
      "&__saturation": {
        borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
      },
      "&__alpha": {
        borderRadius: `0 0 ${theme.shape.radius.default} ${theme.shape.radius.default}`
      },
      "&__alpha, &__hue": {
        height: theme.spacing(2),
        position: "relative"
      },
      "&__pointer": {
        height: theme.spacing(2),
        width: theme.spacing(2)
      }
    }
  }),
  colorInput: css.css({
    marginTop: theme.spacing(2)
  })
});

"use strict";
class UnThemedColorPickerPopover extends React.Component {
  constructor(props) {
    super(props);
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ jsxRuntime.jsx(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ jsxRuntime.jsx(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__namespace.createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ jsxRuntime.jsx(Tab, { label: customPickers[key].name, onChangeTab: this.onTabChange(key) }, key);
      }) });
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const { activePicker } = this.state;
    const styles = getStyles$1E(theme);
    return /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { tabIndex: -1, className: styles.colorPickerPopover, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(TabsBar, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.palette-tab", "Colors"),
            onChangeTab: this.onTabChange("palette"),
            active: activePicker === "palette"
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.spectrum-tab", "Custom"),
            onChangeTab: this.onTabChange("spectrum"),
            active: activePicker === "spectrum"
          }
        ),
        this.renderCustomPickerTabs()
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.colorPickerPopoverContent, children: this.renderPicker() })
    ] }) });
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles$1E = stylesFactory((theme) => {
  return {
    colorPickerPopover: css.css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      border: `1px solid ${theme.colors.border.weak}`
    }),
    colorPickerPopoverContent: css.css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      height: "290px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css.css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

"use strict";
const FieldValidationMessage = ({
  children,
  horizontal,
  className
}) => {
  const styles = useStyles2(getFieldValidationMessageStyles);
  const cssName = css.cx(horizontal ? styles.horizontal : styles.vertical, className);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { role: "alert", className: cssName, children: [
    /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.fieldValidationMessageIcon, name: "exclamation-triangle" }),
    children
  ] });
};
const getFieldValidationMessageStyles = (theme) => {
  const baseStyle = `
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      padding: ${theme.spacing(0.5, 1)};
      color: ${theme.colors.error.contrastText};
      background: ${theme.colors.error.main};
      border-radius: ${theme.shape.radius.default};
      position: relative;
      display: inline-block;
      align-self: flex-start;

      a {
        color: ${theme.colors.error.contrastText};
        text-decoration: underline;
      }

      a:hover {
        text-decoration: none;
      }
    `;
  return {
    vertical: css.css(baseStyle, {
      margin: theme.spacing(0.5, 0, 0, 0),
      "&:before": {
        content: '""',
        position: "absolute",
        left: "9px",
        top: "-5px",
        width: 0,
        height: 0,
        borderWidth: "0 4px 5px 4px",
        borderColor: `transparent transparent ${theme.colors.error.main} transparent`,
        borderStyle: "solid"
      }
    }),
    horizontal: css.css(baseStyle, {
      marginLeft: "10px",
      "&:before": {
        content: '""',
        position: "absolute",
        left: "-5px",
        top: "9px",
        width: 0,
        height: 0,
        borderWidth: "4px 5px 4px 0",
        borderColor: "transparent #e02f44 transparent transparent",
        borderStyle: "solid"
      }
    }),
    fieldValidationMessageIcon: css.css({
      marginRight: theme.spacing()
    })
  };
};

"use strict";
const InlineLabel = ({
  children,
  className,
  tooltip,
  width,
  transparent,
  interactive,
  as: Component = "label",
  ...rest
}) => {
  const styles = useStyles2(getInlineLabelStyles, transparent, width);
  return /* @__PURE__ */ jsxRuntime.jsxs(Component, { className: css.cx(styles.label, className), ...rest, children: [
    children,
    tooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { interactive, placement: "top", content: tooltip, theme: "info", children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { tabIndex: 0, name: "info-circle", size: "sm", className: styles.icon }) })
  ] });
};
const getInlineLabelStyles = (theme, transparent = false, width) => {
  return {
    label: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-between",
      flexShrink: 0,
      padding: theme.spacing(0, 1),
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      backgroundColor: transparent ? "transparent" : theme.colors.background.secondary,
      height: theme.spacing(theme.components.height.md),
      lineHeight: theme.spacing(theme.components.height.md),
      marginRight: theme.spacing(0.5),
      borderRadius: theme.shape.radius.default,
      border: "none",
      width: width ? width !== "auto" ? `${8 * width}px` : width : "100%",
      color: theme.colors.text.primary
    }),
    icon: css.css({
      color: theme.colors.text.secondary,
      marginLeft: "10px",
      ":hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

"use strict";
const InlineField = ({
  children,
  label,
  tooltip,
  labelWidth = "auto",
  invalid,
  loading,
  disabled,
  required,
  className,
  htmlFor,
  grow,
  shrink,
  error,
  transparent,
  interactive,
  validationMessageHorizontalOverflow,
  ...htmlProps
}) => {
  const theme = useTheme2();
  const styles = getStyles$1D(theme, grow, shrink);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ jsxRuntime.jsx(
    InlineLabel,
    {
      interactive,
      width: labelWidth,
      tooltip,
      htmlFor: inputId,
      transparent,
      children: `${label}${required ? " *" : ""}`
    }
  ) : label;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, className), ...htmlProps, children: [
    labelElement,
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.childContainer, children: [
      React.cloneElement(children, { invalid, disabled, loading }),
      invalid && error && /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: css.cx(styles.fieldValidationWrapper, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
        }
      )
    ] })
  ] });
};
InlineField.displayName = "InlineField";
const getStyles$1D = (theme, grow, shrink) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`,
      margin: `0 ${theme.spacing(0.5)} ${theme.spacing(0.5)} 0`
    }),
    childContainer: css.css({
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`
    }),
    fieldValidationWrapper: css.css({
      marginTop: theme.spacing(0.5)
    }),
    validationMessageHorizontalOverflow: css.css({
      width: 0,
      overflowX: "visible",
      "& > *": {
        whiteSpace: "nowrap"
      }
    })
  };
};

"use strict";
const Switch = React.forwardRef(
  ({ value, checked, onChange, id, label, disabled, invalid = false, ...inputProps }, ref) => {
    if (checked) {
      data.deprecationWarning("Switch", "checked prop", "value");
    }
    const styles = useStyles2(getSwitchStyles);
    const switchIdRef = React.useRef(id ? id : lodash.uniqueId("switch-"));
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.switch, invalid && styles.invalid), children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        "input",
        {
          type: "checkbox",
          role: "switch",
          disabled,
          checked: value,
          onChange: (event) => {
            !disabled && (onChange == null ? void 0 : onChange(event));
          },
          id: switchIdRef.current,
          ...inputProps,
          ref
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("label", { htmlFor: switchIdRef.current, "aria-label": label, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check", size: "xs" }) })
    ] });
  }
);
Switch.displayName = "Switch";
const InlineSwitch = React.forwardRef(
  ({ transparent, className, showLabel, label, value, id, invalid, ...props }, ref) => {
    const styles = useStyles2(getSwitchStyles, transparent);
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        className: css.cx(styles.inlineContainer, className, props.disabled && styles.disabled, invalid && styles.invalid),
        children: [
          showLabel && /* @__PURE__ */ jsxRuntime.jsx(
            "label",
            {
              htmlFor: id,
              className: css.cx(styles.inlineLabel, value && styles.inlineLabelEnabled, "inline-switch-label"),
              children: label
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(Switch, { ...props, id, label, ref, value })
        ]
      }
    );
  }
);
InlineSwitch.displayName = "Switch";
const getSwitchStyles = (theme, transparent) => ({
  switch: css.css({
    width: theme.spacing(4),
    height: theme.spacing(2),
    position: "relative",
    lineHeight: 1,
    input: {
      height: "100%",
      width: "100% !important",
      opacity: 0,
      zIndex: -1e3,
      position: "absolute",
      "&:checked + label": {
        background: theme.colors.primary.main,
        borderColor: theme.colors.primary.main,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        svg: {
          transform: `translate3d(${theme.spacing(2.25)}, -50%, 0)`,
          background: theme.colors.primary.contrastText,
          color: theme.colors.primary.main
        }
      },
      "&:disabled + label": {
        background: theme.colors.action.disabledBackground,
        borderColor: theme.colors.border.weak,
        cursor: "not-allowed",
        svg: {
          background: theme.colors.text.disabled
        }
      },
      "&:disabled:checked + label": {
        background: theme.colors.primary.transparent,
        svg: {
          color: theme.colors.primary.contrastText
        }
      },
      "&:focus + label, &:focus-visible + label": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + label": getMouseFocusStyles(theme)
    },
    label: {
      width: "100%",
      height: "100%",
      cursor: "pointer",
      borderRadius: theme.shape.radius.pill,
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      transition: "all 0.3s ease",
      "&:hover": {
        borderColor: theme.components.input.borderHover
      },
      svg: {
        position: "absolute",
        display: "block",
        color: "transparent",
        width: theme.spacing(1.5),
        height: theme.spacing(1.5),
        borderRadius: theme.shape.radius.circle,
        background: theme.colors.text.secondary,
        boxShadow: theme.shadows.z1,
        left: 0,
        top: "50%",
        transform: `translate3d(${theme.spacing(0.25)}, -50%, 0)`,
        transition: "transform 0.2s cubic-bezier(0.19, 1, 0.22, 1)",
        "@media (forced-colors: active)": {
          border: `1px solid ${theme.colors.primary.contrastText}`
        }
      }
    }
  }),
  inlineContainer: css.css({
    padding: theme.spacing(0, 1),
    height: theme.spacing(theme.components.height.md),
    display: "inline-flex",
    alignItems: "center",
    background: transparent ? "transparent" : theme.components.input.background,
    border: `1px solid ${transparent ? "transparent" : theme.components.input.borderColor}`,
    borderRadius: theme.shape.radius.default,
    "&:hover": {
      border: `1px solid ${transparent ? "transparent" : theme.components.input.borderHover}`,
      ".inline-switch-label": {
        color: theme.colors.text.primary
      }
    }
  }),
  disabled: css.css({
    backgroundColor: "rgba(204, 204, 220, 0.04)",
    color: "rgba(204, 204, 220, 0.6)",
    border: "1px solid rgba(204, 204, 220, 0.04)"
  }),
  inlineLabel: css.css({
    cursor: "pointer",
    paddingRight: theme.spacing(1),
    color: theme.colors.text.secondary,
    whiteSpace: "nowrap"
  }),
  inlineLabelEnabled: css.css({
    color: theme.colors.text.primary
  }),
  invalid: css.css({
    "input + label, input:checked + label, input:hover + label": {
      border: `1px solid ${theme.colors.error.border}`
    }
  })
});

"use strict";
const SeriesColorPickerPopover = (props) => {
  const { yaxis, onToggleAxis, color, ...colorPickerProps } = props;
  const yAxisLabel = t("grafana-ui.series-color-picker-popover.y-axis-usage", "Use right y-axis");
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ jsxRuntime.jsx(InlineField, { labelWidth: 20, label: yAxisLabel, children: /* @__PURE__ */ jsxRuntime.jsx(InlineSwitch, { value: yaxis === 2, label: yAxisLabel, onChange: onToggleAxis }) });
      }
    }
  } : void 0;
  return /* @__PURE__ */ jsxRuntime.jsx(ColorPickerPopover, { ...colorPickerProps, color: color || "#000000", customPickers });
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);

"use strict";
const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends React.Component {
    constructor() {
      super(...arguments);
      this.pickerTriggerRef = React.createRef();
    }
    render() {
      const { theme, children, onChange, color } = this.props;
      const styles = getStyles$1C(theme);
      const popoverElement = React__namespace.createElement(popover, {
        ...{ ...this.props, children: null },
        onChange
      });
      return /* @__PURE__ */ jsxRuntime.jsx(PopoverController, { content: popoverElement, hideAfter: 300, children: (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          this.pickerTriggerRef.current && /* @__PURE__ */ jsxRuntime.jsx(
            Popover,
            {
              ...popperProps,
              referenceElement: this.pickerTriggerRef.current,
              wrapperClassName: styles.colorPicker,
              onMouseLeave: hidePopper,
              onMouseEnter: showPopper,
              onKeyDown: (event) => closePopover(event, hidePopper)
            }
          ),
          children ? children({
            ref: this.pickerTriggerRef,
            showColorPicker: showPopper,
            hideColorPicker: hidePopper
          }) : /* @__PURE__ */ jsxRuntime.jsx(
            ColorSwatch,
            {
              ref: this.pickerTriggerRef,
              onClick: showPopper,
              onMouseLeave: hidePopper,
              color: theme.visualization.getColorByName(color || "#000000"),
              "aria-label": color
            }
          )
        ] });
      } });
    }
  }, _a.displayName = displayName, _a;
};
const ColorPicker = withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles$1C = stylesFactory((theme) => {
  return {
    colorPicker: css.css({
      position: "absolute",
      zIndex: theme.zIndex.tooltip,
      color: theme.colors.text.primary,
      maxWidth: "400px",
      fontSize: theme.typography.size.sm
    })
  };
});

"use strict";
class ClickOutsideWrapper extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.myRef = React.createRef();
    this.state = {
      hasEventListener: false
    };
    this.onOutsideClick = (event) => {
      const domNode = this.myRef.current;
      if (!domNode || event.target instanceof Node && !domNode.contains(event.target)) {
        this.props.onClick();
      }
    };
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ref: this.myRef, children: this.props.children });
  }
}
ClickOutsideWrapper.defaultProps = {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : void 0,
  useCapture: false
};

"use strict";
const ColorPickerInput = React.forwardRef(
  ({ value = "", onChange, returnColorAs = "rgb", ...inputProps }, ref) => {
    const [currentColor, setColor] = React.useState(value);
    const [isOpen, setIsOpen] = React.useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles$1B);
    const paletteStyles = useStyles2(getStyles$1F);
    reactUse.useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(data.colorManipulator.asRgbString(color));
        } else {
          onChange(data.colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    const handleBlur = (evt) => {
      var _a;
      const isClickInPopover = (_a = document.querySelector('[data-testid="color-popover"]')) == null ? void 0 : _a.contains(evt.relatedTarget);
      if (!isClickInPopover) {
        setIsOpen(false);
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { onClick: () => setIsOpen(false), children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
      isOpen && !inputProps.disabled && /* @__PURE__ */ jsxRuntime.jsx(
        reactColorful.RgbaStringColorPicker,
        {
          "data-testid": "color-popover",
          color: currentColor,
          onChange: setColor,
          className: css.cx(paletteStyles.root, styles.picker)
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorInput,
        {
          ...inputProps,
          theme,
          color: currentColor,
          onChange: setColor,
          buttonAriaLabel: "Open color picker",
          onClick: () => setIsOpen(true),
          onBlur: (e) => handleBlur(e),
          ref,
          isClearable: true
        }
      )
    ] }) });
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles$1B = (theme) => {
  return {
    wrapper: css.css({
      position: "relative"
    }),
    picker: css.css({
      "&.react-colorful": {
        position: "absolute",
        width: "100%",
        zIndex: 11,
        bottom: "36px"
      }
    }),
    inner: css.css({
      position: "absolute"
    })
  };
};

"use strict";
const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles$1A);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children });
};
const getStyles$1A = (theme) => {
  return {
    container: css.css({
      borderLeft: `3px solid ${theme.colors.info.main}`,
      backgroundColor: `${theme.colors.background.secondary}`,
      padding: theme.spacing(2),
      minWidth: "350px",
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(4)
    })
  };
};

var grotCTASvg = "<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 321 171\">\n  <ellipse cx=\"160.5\" cy=\"153.5\" fill=\"#9087e9\" fill-opacity=\".3\" rx=\"160.5\" ry=\"17.5\"/>\n  <g id=\"grot-cta-cactus-1\" fill=\"#9087e9\">\n    <path d=\"m12.5 76.3-.1.3-.2.1H12c-.1 0-.2 0-.2-.2l-.2-.3a4.4 4.4 0 0 1-.6-1.7c-.2 2 0 4.3.2 6.4l.1 1c1.1 11.3 7.4 19.7 18.7 25.2V93.7c-.9-.3-1.8-.7-2.6-1.7-2.2-2.5-2.9-6.2-3.4-9.5l-.3-1.4-.2-1.3c-.6-3.3-1.2-6.8-3-9.4a4.7 4.7 0 0 0-3.9-2.2c-1.5 0-3 .7-4 2-.7 1-1.2 2.1-1.4 3.4v-.2l.2-.1h.1l.2.4.2.4.5 1.6v.6Zm13 21v.2l-.2.3h-.1c-.2 0-.2-.1-.3-.3V96.1h.1a4.6 4.6 0 0 1 .5 1.2Zm-1.7-9.5.1-.2.2-.1h.2l1 1v.5l-.1.2H25c-.3 0-.5-.2-.6-.4l-.5-.5v-.5Zm.4 13.8.1.3v.4c0 .2-.1.3-.2.3 0 .2-.1.2-.2.2h-.1c-.1 0-.2 0-.3-.2a32.3 32.3 0 0 1-1-1.6v-.7l.2-.1h.2l1.3 1.5Zm-2.3-21.2.2-.3.2-.1h.2l.1.3c.1.7.3 1.3.6 1.8v.4a1 1 0 0 1-.2.7l-.3.1h-.2l-.2-.3a4.2 4.2 0 0 1-.5-2l.1-.6ZM20 72.8l.1-.7c0-.2.1-.3.2-.3l.2-.2.2.1.2.3.1 1.5v.4l-.1.2h-.1l-.1.1h-.4l-.1-.1-.1-.1V72.8Zm-.7 17.3.3-.2h.1l1.1.4h.2v.3h.1v.6l-.1.2h-.4c-.3 0-.7-.2-1-.4-.2 0-.2-.2-.3-.3v-.6Zm-2.5-10.6v-.2l.2-.2h.2l.2.1.3.5.3.5.1.3v.3l-.2.3-.3.1h-.1a.8.8 0 0 1-.3-.3l-.4-1v-.3Zm0 14v.7h-.1l-.2.2c-.5 0-.7-.2-1.1-.5l-.2-.3V93l.3-.2h.2l.5.2.4.4.2.3Zm-1.6-24.4V69c0-.2.1-.2.2-.3H15.7l.3.3.2.6.1.3v.4l-.3.3-.2.1h-.2v-.1l-.3-.4-.1-.7v-.3ZM14 82.8s0-.2.2-.3h.2c0-.1.1 0 .1 0 .2 0 .2 0 .3.2l.2.5.2 1.8v.4l-.2.2-.1.2H14.3a.8.8 0 0 1-.2-.5L14 84v-1.2ZM60.2 62c0-20.3-7-23-14-23s-14 2.7-14 23l-.2 8.3c-.2 17.3-.7 53.5.5 60 2.6 14.1 7.7 14.1 11.7 14.1H48c4.1 0 9.2 0 11.9-14.3 1.1-6.4.7-42.5.4-59.8V62Zm-26.7-3.4.3-.4h.4l.1.3v.8l-.3.3-.1.3-.1.3-.2.1h-.1a.4.4 0 0 1-.2-.3c-.2-.5 0-1 .2-1.4Zm-.4 40H33l-.2.1h-.1l-.2-.1V98a16.4 16.4 0 0 1 .6-2.4c0-.1 0-.2.2-.2l.1-.1h.2l.2.2v.6l-.2 1.2-.5 1.1Zm0-21c0 .2-.1.2-.2.2h-.1l-.1-.2v-.4a11 11 0 0 1 .7-1.7h.2l.2.3v.5a10.3 10.3 0 0 1-.7 1.4Zm.5 40.1.2-.2H34l.2.2v.5c0 .4-.2.7-.3 1l-.4 1.1-.1.2-.2.1h-.2l-.1-.3v-.2c-.1-.2-.1-.3 0-.4l.2-1 .4-1Zm-1.2-51.3v-.3h.4c.5.5 1 .8 1.3 1.4V68.4l-.3.2-.2-.1c-.5-.5-.8-1-1.2-1.6v-.5Zm-.4 19v-.2l.2-.2.2-.1h.1a28.7 28.7 0 0 1 1 2.1v.3l-.2.3-.2.1h-.2a.6.6 0 0 1-.2-.3l-.7-1.6v-.3Zm0 22.2V107.3h.3l1.1 1.4.1.4v.4l-.2.4-.2.1h-.2a.6.6 0 0 1-.3-.3l-.7-1.9v-.2Zm2.4 21.9-.2.3-.2.1-.4-.1-1.2-1.8V127.4H32.7l.8.7.7.7.2.3v.4Zm.3-77.7-.1.2-.2.2-.3.1-.2-.1a.7.7 0 0 1-.2-.4l-.2-1.4v-.2l.2-.1.1-.2H34.1l.2.2.4 1.2v.4Zm1.5 86.2v.3l-.3.2h-.2l-.1-.2-.2-.2v-.3l-.1-1 .1-.6.4-.2.2.1h.1l.2.6v1.3Zm7.4-30.5.5-1.5c0-.2.1-.2.2-.3h.4l.2.3.1.3v.5l-.8 1.8-.2.1h-.2a.7.7 0 0 1-.3-.4v-.3l.1-.5ZM43 81.2h.2l.1.4v.7l-.9 1.2-.1.3H42a.4.4 0 0 1-.2-.2l-.1-.4c0-.3 0-.8.3-1.2.1-.3.4-.7.8-.8h.1ZM41.5 70l-.2-.1-.2-.3V69a9.5 9.5 0 0 1 1-1.6l.2-.2.3.1.1.3.1.4v.3l-1 1.6-.3.1Zm0-19.7.4-.7.2-.2h.4l.2.2.1.3V50.8l-.7.8h-.6v-.1l-.2-.3V51l.2-.8ZM40 42v-.2l.2-.1.1-.1h.1l.2.2.6 1.2v.8l-.2.3h-.5c-.2-.1-.2-.3-.3-.4v-.8l-.2-.7V42Zm-.4 15.5c0-.2.1-.3.2-.3l.2-.2h.2l.2.3.5.8.1.4v.5l-.2.4-.3.2a.5.5 0 0 1-.3-.3c-.4-.4-.5-.8-.6-1.3v-.5Zm1.8 52c0 .2-.1.2-.2.3l-.2.2c-.2 0-.3-.1-.3-.2l-.7-1V108h.4a21.9 21.9 0 0 1 1 1.2v.4Zm-2.8-34.7v-.3l.1-.3h.5l1.3 1.5.1.1v1l-.2.2H40a4 4 0 0 1-1.4-2v-.3ZM39.7 91l-.8-1.2v-1l.2-.1h.2l1 1.2.2.3v.5l-.2.3-.3.1-.3-.1Zm0 24.9v-.5l.2-.2.1-.1.3.1 1.2 1.6.1.4v.5l-.2.3-.2.2H41a.6.6 0 0 1-.2-.3l-.5-1-.5-1Zm2.1 13-.1.2-.3.2c-.2 0-.2-.1-.3-.2 0-.2-.2-.3-.3-.5l-.3-.5v-.9h.4l.8 1 .1.2v.4Zm.8-29.7c-.2.7-.5 1.2-1 1.6l-.2.2-.2-.2v-.3l-.1-.3v-.3l.4-.8.6-.6.2-.1h.2l.1.3v.5Zm1.2 39.1a24.8 24.8 0 0 0-.5 1h-.2l-.1-.2-.1-.3v-.2l.5-.9.1-.1h.2l.1.2v.5Zm.7-8.2-.4 2.2c0 .2-.1.3-.2.3l-.2.1h-.1l-.2-.1v-.2c-.1-.2-.1-.3 0-.4l.3-2.2c0-.2.1-.3.2-.3l.2-.2.2.1.1.1.1.2v.4Zm.7-10.4-.5 1.6v.4H44l-.1-.2-.1-.3V120c.1-.5.3-1 .7-1.3h.4l.1.3v.6Zm7.2-41 .1-.3.3-.1h.2l.2.2v.2l.1.1v.3c0 .5-.2 1-.3 1.4l-.1.3h-.4l-.1-.1-.2-.2V80l.2-1.3Zm-.2 15.9H52a.7.7 0 0 1-.3-.4v-.4a19.9 19.9 0 0 1 .7-2.9H52.7l.2.2.1.3v.3a22.1 22.1 0 0 1-.6 2.7c0 .2-.1.2-.2.2Zm-.5-28.4a1.9 1.9 0 0 0 .2.2v.2l.1.4c0 .3 0 .6-.2 1l-.1.1h-.3l-.1-.3c-.2-.3-.2-.6-.2-1v-.5l.2-.1h.4ZM50.9 50h.4l.2.4v.8c-.4.5-.7 1-.8 1.5l-.1.2h-.4l-.1-.2-.1-.3c0-.8.2-1.6.7-2.3l.2-.1ZM49 59v-.2l.3-.1h.2l.7 1v.8l-.2.1-.3-.1-.7-1V59Zm0 14.3.2-.3h.5l.6.7v.8l-.1.4-.3.2h-.1a.6.6 0 0 1-.3-.3l-.4-.9V73.3Zm.6-32.7.2-.5.5-.3h.1l.2.1.1.3v.4l-.2.2-.1.1-.1.2-.2.3h-.4l-.1-.4v-.4Zm-1 3.8a.9.9 0 0 1 .3-.5l.1-.2.3.2a66.8 66.8 0 0 1 .8 1.8v.3l-.2.3h-.4a.5.5 0 0 1-.2-.2l-.6-1.4v-.3Zm-.1 40.8v-.4l.2-.3c.1-.2.2-.2.3-.2l.3.1c.6.7 1 1.3 1 2.2v.3l-.1.1-.1.2H50l-.2.2h-.4L49 87c-.3-.4-.5-1-.6-1.5v-.3Zm.4 13.9v-.6l.3-.2h.3l1.4 1.3.1.2v1.1l-.2.2h-.2l-.2-.1-1.4-1.6-.1-.3Zm.1 14.4v-.8l.2-.2h.2l1 .8.2.2V114.5l-.1.2-.2.1H50a.7.7 0 0 1-.3-.1l-.4-.6-.4-.5Zm.5 14.2a1.2 1.2 0 0 1 .2-.6h.4l1 1.5v.8c0 .2-.1.3-.2.3l-.3.2h-.2v-.1l-.3-.3a6.1 6.1 0 0 1-.6-1.6v-.2Zm1.6 13.4v.2l-.1.2-.2.2h-.5c-.5-.4-.7-1-.8-1.7v-.2l.2-.2.2-.1.3.1.6.6.2.2v.7h.1Zm.8-6c0 .4-.2.8-.4 1.2l-.2.1h-.1l-.2-.2v-1.5l.2-.3.2-.2h.2l.2.2v.3l.1.3Zm1.4-15.6-.1.3a3 3 0 0 0-.7 1.5l-.1.3H52v-.1l-.2-.3v-.6l.7-1.7.2-.2h.1l.2.1a1 1 0 0 1 .3.6v.1Zm.2-13.8a34 34 0 0 0-1.2 2.7h-.2l-.2-.2v-.2c0-.1-.1-.2 0-.2 0-.9.2-1.6.5-2.4l.4-.7.1-.2H53.2l.3.2v.2c.2.3 0 .6 0 .9ZM59 57h.2l.2.1.1.3v.5l-.1.3-.2.2v.6l-.1.2H58.8a.5.5 0 0 1-.2-.2l-.2-.5V58c0-.4.3-.8.7-1Zm-1.5 21.3c.2-.5.4-1 .8-1.4h.4v.3l.1.3-.3.9-.4.8-.1.1h-.3l-.2-.3v-.7Zm0 9.3v-.4h.5a6.4 6.4 0 0 1 1 1.3v.5l-.1.3h-.4a4.7 4.7 0 0 1-1-1.2v-.5Zm.8 8.6c0-.2.2-.2.2-.3h.4l.1.3.1.2v.4a20.6 20.6 0 0 1-1 1.8H58a.8.8 0 0 1-.2-.6v-.2c.1-.6.4-1.1.6-1.6Zm-.8 10.4v-.3l.2-.1.1-.1h.3a24.3 24.3 0 0 1 1 1.7v.3l-.2.3-.2.2-.3-.2a53.4 53.4 0 0 1-.9-1.8Zm1.5 6.6-.1.3-.7.7h-.4V113.3l.7-.7h.4v.3l.1.3ZM57.4 67v-.2l.2-.2H58l.2.2.4.7.5.6.2.4v.5l-.2.3-.3.2h-.1l-.3-.2a4.4 4.4 0 0 1-.9-2V67Zm-1.6-19.2-.3-.9v-.3l.1-.3.2-.2.2-.2h.1l.2.2.9 1.7v.8l-.2.4h-.5c-.2 0-.2-.2-.3-.3l-.4-.9Zm1.9 87.9v.2l-.2.2h-.2c-.2 0-.2 0-.2-.2l-.3-.8-.4-.8v-.4l.2-.2h.2l.2.1.7 1.6v.2ZM59 127l-.3 1v.1l-.2.1h-.2l-.2-.2-.1-.3v-.3l.2-.9a2.2 2.2 0 0 1 .4-.8l.2-.1h.2l.2.4-.1 1Zm.5-5.9c0 .2-.1.3-.2.3 0 .2-.2.2-.2.2H59a.6.6 0 0 1-.3-.2l-.8-1-.7-1-.1-.3v-.4l.1-.3.2-.2.2.1a24.2 24.2 0 0 1 1.9 2.4v.4ZM63.2 78.1a2 2 0 0 0-.2.6l-1 .2.2 13.6c1 0 2-.3 3.2-.7v-1.3l.2-.2h.2l.2.2c.2.3.2.6.2.9 3.5-1.4 6.7-3.7 9.4-6.8h-.1c-.3-.4-.4-.8-.3-1.2l.2-.4.1-.2.3.1.2.3.1.7v.2-.2c2.5-2.9 4.5-6.4 6-10.4v-.1H81.8a.8.8 0 0 1-.3-.4v-1.3l.2-.2.2.1.3.4.2.4v.4-.2c.4-1.3 1-3 1.4-4.8l-.2-.3-.1-.3V67l.5-1 .1-.2h.3-.1a35.5 35.5 0 0 0 .5-8.8l-.6-1-.1-.2v-.5l.1-.3.3-.1h.2a8.3 8.3 0 0 0-1.5-3.6c-1-1.2-2.3-1.8-4.2-1.7-5.3.4-6.6 8.4-7.5 13.7L71 66c-1 5.2-2.8 10.6-7.2 12.4 0-.2-.1-.2-.2-.3l.1.2.1.5.2.4v.7l-.2.3-.2.1a.5.5 0 0 1-.3-.2 1.7 1.7 0 0 1-.4-1v-.4l.2-.6Zm16.6-.2v.4l-.2.1-.1.1h-.2l-.2.2H78.8a.8.8 0 0 1-.2-.4v-.6l.4-.5h.5l.2.1.1.3v.3Zm1.6-16.4v.3l-.1.4c-.3.5-.6.9-.6 1.5l-.1.4-.3.2h-.1l-.1-.1-.2-.3-.1-.8c0-.6 0-1.2.4-1.6.1-.2.3-.4.6-.5h.4l.2.4ZM80 51.9l.4-1.1.2-.3H81l.2.3V51.4l-.4 1c0 .2-.1.2-.2.3H80.3l-.2-.2v-.6Zm-1.8 2.2v-.2l.2-.2.2-.1h.2l.2.3.2.4 1 1v.3l.1.4v.3c-.1.2-.2.2-.3.2h-.2l-.6-.3-.8-1.1-.2-.7V54.1Zm-1.8 15.2V69l.2-.2.2-.1c.2 0 .4 0 .5.2l.4.2.1.2V70.2l-.1.2h-.5a3 3 0 0 1-.7-.7l-.1-.3Zm-2 6.4.2-.2h.1l.2.1.2.3v.8l-.4.5-.3.6-.2.1H74l-.1-.3v-.7l.6-1.2Zm-1.2-19.4.1-.3c0-.2.1-.2.2-.3h.1c.2 0 .3.1.3.3l.3.9.1.3v.5l-.1.1-.1.1-.3.2-.2-.1a.8.8 0 0 1-.2-.4l-.1-1.3Zm-.8 6.3v-.2l.1-.3.4-.4.3-.2.3.2v.2h.1v.8l-.1.2-.5.5h-.5V63l-.1-.2V62.6Zm-.8 5.5.1-.2h.3l.1.1.1.3c0 .3 0 .5.2.7v.5l-.1.2-.2.1H72c-.5-.5-.5-1-.3-1.7Zm-.3 19.4.2.1v.5l-.3.2h-.4l-.2-.2v-.5h.2c.2 0 .3 0 .5-.2ZM70.3 78l.2-.2h.2l.2.4a7.5 7.5 0 0 1 .3 1.4v.5l-.2.3h-.2a.4.4 0 0 1-.3-.2c-.3-.6-.3-1.2-.3-1.8l.1-.4ZM68 75v-.3l.5-.5h.4l.1.3v.5l-.2.2-.2.2-.1.2h-.4l-.1-.3V75Zm-3.4 9.8.6-.6.8-.2h.2l.1.2.1.2v.2l.1.1v.5l-.2.2-.2.1c-.4 0-.7.1-1 .3H64.8v-.1l-.2-.2v-.7Z\"/>\n  </g>\n  <g id=\"grot-cta-cactus-2\" fill=\"#9087e9\">\n    <path d=\"m185.2 118.4.1 1.4h.3l.1.1v.2c-.1.1-.2.1-.2 0h-.1c.3 2 .8 3.8 1.8 5.5-.1 0-.2.4 0 .4l.3.1a12.4 12.4 0 0 0 4.5 3.8l-.1.1v.2c-.1 0 0-.1 0-.2h.1l.1-.1h.2v.2l1.2.5v-4.9l-1-.5-.1-.1v.4h-.2l-.1-.2V125h.2c-1.3-.9-2-2.4-2.2-4.6h-.2V119.7l.1-.1v-.8a57.4 57.4 0 0 1 .2-7.8c0-1.6-.5-4-1.9-4l-.9.3.1.1V107.8l-.2.1-.1-.2v-.2a3.1 3.1 0 0 0-1.5 1.6h-.1l.2.3v.5H185.5l-.1-.3v.7a23 23 0 0 0-.3 3h.2l.1.1V113.7l-.1.1h-.2V113.5v5l.1-.1Zm7.7 9.6.1-.1.1.1.1.3v.2h-.2l-.1-.2V128Zm-2.8-5.3h.4v.4h-.1l-.3-.2v-.2Zm-.1 5.4v.2h-.1l-.1.1h-.1l-.1-.4v-.2h.2l.1.2v.1Zm0-13.4h-.1l-.1.1-.1-.1v-.4h.2l.1.2v.2Zm-.5-4.2h.2l.3.5v.2l-.1.2h-.1l-.2-.1a3 3 0 0 1-.1-.6v-.2Zm-.1 6.3v-.1h.2l.2.3v.4H189.5v-.3h-.1v-.2Zm-.4 7.8v-.1H189.7v.4h-.1l-.4-.1v-.2Zm-.5-16.5h.2v.4h-.1v.1h-.1v-.5Zm-.2 13.8h.2V122.5h-.2l-.1-.3v-.2Zm-.5-8.1v-.1c0-.1 0 0 .1 0h.1v.1l.1.1v.1l-.1.1-.2-.2v-.1Zm0 4.3.1-.1h.1l.1.1V118.8H187.7v-.7Zm-.5-7.7h.2l.1.2v.2l-.2.2h-.2v-.6Zm-.3 5.7c.1-.1.2 0 .2 0l.3.3v.2h-.1c0 .1 0 0-.1 0h-.1l-.1-.3v-.2Zm-.7 6.4.1-.3h.2v.7h-.1c-.2 0-.2 0-.2-.2v-.2Zm-1-6.6v-.1h.2l.2.1v.2l-.1.2-.2.1-.2-.3.1-.2ZM204.8 110.7V113.5l-.1 1.8v.2l.2-.1 1.1-.9v-.2l.1-.2.1.1v.1h.1a9 9 0 0 0 2.2-3V111l.1-.2h.1c.3-.6.5-1.3.6-2l-.1-.1v-.2c.1-.1.1-.1.2 0l.2-2v-.5l.1-2.2v-1.1c0-1 0-1.7-.5-2.2a2 2 0 0 0-1.4-.5c-.4 0-.7 0-1 .3-.6.3-1 .8-1 1.3v.4h-.2V103.6h-.1.2l.1.1v.4h-.2V106.7l-.1.1v1l-.1.4c0 .8-.2 1.8-.5 2.5v.5l-.1-.1v-.3Zm3.6-4.6-.1.2-.2-.1v-.6h.2v.2h.1v.3Zm.1-3.5h.1l.1.1V103l-.2.2h-.2v-.2l.1-.4h.1Zm-.5-2.2v-.2h.3l.1.2v.4h-.2l-.1-.2-.1-.1v-.1Zm-.5 8.7v-.2H207.9v.4l-.2.1h-.1V109Zm-.6-7.9.1-.2H207.3v.4l-.2.3h-.2v-.5Zm-.2 2.8v-.1H207l.1.2v.2h-.2l-.1-.1v-.2Zm-.1 2.7v-.2l.3-.2h.1V106.6c0 .2-.2.3-.3.4h-.1V106.7Zm0 4v-.2h.2l.1.3v.4h-.2l-.2-.2v-.4Zm-.9-1.3v-.2h.1l.1-.1h.1v.4l-.2.1-.1-.1v-.1Zm-.7 3.5.3-.2h.1l.1.2v.2l-.2.1h-.2l-.1-.1v-.2ZM194.1 109.2v.1c.1-.1.1 0 .1 0l.3.4v.2a1 1 0 0 1-.4-.6v.2l.2 1.6.2 3v5.8l.4.2v.6l-.1-.1v-.1l-.2-.2v10.4c-.1 3-.3 6.9 1.5 8.7.6.7 1.6 1 2.7 1 2.9 0 4.3-2.5 4.3-7.5v-.1l-.2.5h-.2v-.2l.3-.4v-.1h.1a73 73 0 0 1 0-3l-.2-.5v-.2h.1c.2 0 .2.2.2.3l.1-3.8v.3l-.1.1h-.1v-.5l.1-.3c.2-.4.2-.7.2-1v-1.4.1l-.1.1h-.2v-.2l.2-.2v-.1h.1l.2-7h-.1l-.1.2-.1-.2v-.1l.2-.3s.2 0 .2-.2v.1-1.4a88 88 0 0 0-.2-5c-.1-.1 0-.2 0-.2v-.3a28 28 0 0 0-.3-3.3v.2l-.2.3h-.1v-.8l.1-.1h.1v-.3c-.3-1.4-1.3-3.8-4.3-3.8a4.5 4.5 0 0 0-4.2 3l-.3 1 .2.5v.1h-.1l-.1-.3a19 19 0 0 0-.2 4.8Zm8.8 9.5h.1l.2.4v.2h-.1l-.2-.4v-.2Zm-.2-7.1h.1v.7l-.2-.1v-.2l.1-.4Zm-2.3 13.8c-.1.1-.1.1-.2 0v-.4h.2v.4Zm.5-13.2-.2.3-.4.3v-.2l.1-.3.3-.3.2.1v.1Zm-.4 4.1h-.1v-.7h.1v.7Zm0 3.3v-.2l.2-.3.1-.3.2-.1.1.2c0 .3-.1.7-.5.7Zm.4 14h-.2v-.5c.2 0 .2.2.3.3v.2Zm.3-2.8-.3.2v-.2l.2-.4h.2l-.1.4Zm.2-3.8v.1c0 .4-.1.7-.4.9v-.5l.2-.4v-.1h.2Zm-.1-4.3v.2l-.1.4-.3.3-.1-.2c0-.3.2-.5.4-.7Zm-.3-21.2v-.2h.1s.1.1 0 .2V102h-.1v-.6Zm-.3 3.8.1-.1.1.1v.7h-.2v-.7Zm-.5 3.5.1.1.1.3V109.5h-.1l-.1-.2-.1-.2v-.2Zm-.2 12v.2l.1.2v.6c-.2-.2-.2-.5-.3-.7v-.2h.2Zm-.3-6.8h.2v.4l-.2-.3v-.1Zm0 14.4.1-.2h.1c.2.1.3.2.3.4l.2.4v.1H200l-.1-.2-.2-.2v-.2Zm-3-11.1h.1l.2.3v.3h-.1l-.2-.4v-.2Zm0 4.6h.2l.1.3V122.5h-.1l-.2-.3V121.9Zm.6 7.5v.1l-.1.1-.3-.4V128.9h.2v.1l.2.4Zm-.5 2.5c.1-.1.2 0 .2 0l.2.2v.1h-.1a1 1 0 0 1-.3-.3Zm.8 3.8v.1h-.2l-.3-.7v-.2c.2 0 .3.2.3.3l.2.4v.1Zm.1-7.7v-.5c.2-.1.2-.3.3-.4h.2v.2l-.3.5v.1h-.2Zm.6 4.4V132.7c0 .2-.2.3-.4.4l-.1-.2.2-.3s.2 0 .2-.2h.1Zm0-11.9-.2.2c0 .2-.1.3-.3.4V120.8l.1-.3.1-.2h.2v.2Zm-.2-5.6v.4l-.1.2-.1.2h-.1l-.1-.1v-.1l.3-.6Zm-.4-8h.2v.4l-.2.3h-.2v-.2l.2-.4Zm-.4 18 .1.1.2.5-.1.1h-.1c0-.2 0-.3-.2-.3V125c0-.1.1-.1.1 0Zm-.4-23 .2.1v.3l.1.3v.2h-.1l-.1-.2-.1-.4v-.2Zm-.2 8.1h.2l.2.6-.1.2-.2-.1-.1-.4v-.3Zm-1.3 6.8V117.1l-.5.6-.1-.1V117.3l.5-.5Zm-.7-9.6.4-.7h.1s.1.1 0 .2a3 3 0 0 1-.3.8h-.1l-.1-.2v-.1Zm0 5.5v.2l.1.2v.2h-.1l-.3-.3V112.7l.1-.1h.1Z\"/>\n  </g>\n  <path fill=\"#080821\" d=\"M125.7 159.2c30.1 0 54.6-2.8 54.6-6.4 0-3.5-24.5-6.4-54.6-6.4-30.2 0-54.7 2.9-54.7 6.4 0 3.6 24.5 6.4 54.7 6.4Z\" opacity=\".3\"/>\n  <path fill=\"#F99F10\" d=\"M190 110.6c4.6 1.4 12.8 7.9 10.5 14.3-2.2 6.5-10 5.4-19-1\"/>\n  <path stroke=\"#3A1103\" stroke-linecap=\"round\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"M190 110.6c4.6 1.4 12.8 7.9 10.5 14.3-2.2 6.5-10 5.4-19-1\"/>\n  <path fill=\"#EF6122\" d=\"M115.6 36.1c-13.2-9.1-30-11.2-33-8-2.3 2.8 6.7 17.3 5.3 21.6-1.5 4.2-14.3 1.5-15.7 7-.7 2.5 9.1 8.7 8.9 12.3-.3 3.6-7.9 2.6-8.4 7.2-.4 3.1 6.5 3.8 6.3 7.6-.3 3.7-5.3 3-5.1 6.6.2 3 5.7 1 7.1 6 1.5 4.9 34.6-60.3 34.6-60.3Z\"/>\n  <path fill=\"#FAC20C\" stroke=\"#3A1103\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"M57 123.5c.4-12 8.8-14.7 15-12.7 6 2.1 5.7 9.2 4.1 11.9-2.4 4.2-6 2.4-4.7-.6 1-2.9 1.2-6.8-3.5-5.6-6 1.6-4 17.4 8.3 14.3 8.5-2.1 7.8-11.1 7.1-24.2-1.8-12.7.2-29.3 5.6-45 10.9-32 76.6-42.4 98.5-12.8 28.3 38.4-3 75.9-7.8 80.6-15 11.7-12.5 22.2-23.2 22.9-10.2.6-9.4-9.7-16.2-10.3h-1.1c-8 .6-9.5 10.5-21.4 10.3-9.8-.2-5.4-8.7-12-12.7-1.3-.7-2.5-1.1-3.6-1.4l-2.9-.4h-2.1c-4 0-6.2 1-15 2.7-15.7 3.2-25.4-6.8-25-17Z\"/>\n  <path fill=\"#EF6122\" d=\"M100 44.3a54.4 54.4 0 0 1 51.6-5c3.4 2.2 8-.4 5.4-7-8.8-22.1-31.7-33.4-37.9-29.6-6.9 4.3 1.8 23.3-2.7 27.7-3.6 3.6-6.1.9-12.3-1.2-5.5-1.9-4.2 15-4.2 15Z\"/>\n  <path fill=\"#FAC20C\" fill-opacity=\".5\" d=\"M139 19.7a5.8 5.8 0 0 0-.5-2.3 6.7 6.7 0 0 0-1.4-1.9c.3-1-.2-1.9-.2-1.9-1 0-1.7.3-1.9.4h-.1l-.5-.2c-.2 0-.4 0-.6-.2h-.5l-.1-.1c-.4-1.4-1.7-2-1.7-2-1.3.9-1.6 2.1-1.6 2.1l-.3.1a2 2 0 0 1-.3.1l-.3.1-.7.3-.5.4c-2-.8-3.7 0-3.7 0-.2 2 .7 3.4 1 3.6l-.2.4-.3 1.4v.3a4.5 4.5 0 0 0-2.4 2.5c1.4 1.7 3.1 1.9 3.1 1.9a8.3 8.3 0 0 0 1.2 1.5 4 4 0 0 0 0 2.8c1.6.1 2.7-.6 3-.8l.4.2 1.5.2h.6a3.2 3.2 0 0 0 2.2 1.3c1-1 1-2 1-2.2v-.1a6.5 6.5 0 0 0 1.6-1.6l.1-.1c1.1 0 1.9-.7 1.9-.7a2.9 2.9 0 0 0-1-1.8V21.6a4.7 4.7 0 0 0-4-3.6h-.6s-.1 0 0 0H132.5a3.7 3.7 0 0 0-2.2 1.2 3.4 3.4 0 0 0-.8 2v1.1l.5.8c.1.3.4.5.6.7l.7.4h1.4l.3-.1.3-.2v-.3h-.2l-.3.1h-.7a2 2 0 0 1-1.7-1.6v-.7a2.4 2.4 0 0 1 1-1.5l.4-.2a2.2 2.2 0 0 1 .8-.2h.9l.8.4a3 3 0 0 1 1.4 2.2v1.4a4.1 4.1 0 0 1-.7 1.3 4 4 0 0 1-2.5 1.5H131.5c-.3 0-.7 0-1-.2a5.2 5.2 0 0 1-3.5-3.6l-.2-1V20.9l.1-.5.1-.5.1-.5.4-1a5.2 5.2 0 0 1 1.5-1.9l.4-.2.4-.3h.2v-.1h.2l.4-.2H131l.2-.1h.5v-.1H133a6 6 0 0 1 3.7 1.5l.1.1.2.1v.2h.2l.4.6c.3.3.5.7.6 1v.1l.1.2h.1v.2l.2.4.2.6s0 .2.1.1l.2-.1c.1-.3.1-.5 0-.8Z\"/>\n  <path fill=\"#F99F10\" d=\"M128 119.9c-5.8 5.2-12.3 7.1-16 2.6-4-5-.4-10.6 4.9-15.5\"/>\n  <path stroke=\"#3A1103\" stroke-linecap=\"round\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"M128 119.9c-5.8 5.2-12.3 7.1-16 2.6-4-5-.4-10.6 4.9-15.5\"/>\n  <path stroke=\"#3A1103\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"M107.9 31.7c-11.3-5.3-22.3-8.1-25.2-3.5-3.2 5 7.6 15.6 5.2 21.5-2.3 5.5-15 .8-15.7 7-.7 4.8 9.1 8.7 8.9 12.3-.3 3.6-8 2.1-8.5 6.8-.4 3.1 6.6 4.2 6.4 8-.3 3.7-5 3-5.1 6.6 0 3.4 8.6 3.3 8.9 9.5M151.6 39.3c3.4 2.2 8-.4 5.4-7-8.8-22.1-31-33.4-37.9-29.6-7.2 4 1.8 23.3-2.7 27.7-2.5 2.5-5.8 2.4-8.9 1.1\"/>\n  <path stroke=\"#3A1103\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"M151.8 39.4c-12-7.1-32.8-7.5-51.6 6.5\"/>\n  <path fill=\"#5545EF\" stroke=\"#231735\" stroke-miterlimit=\"10\" stroke-width=\"2.1\" d=\"m133.3 88.6 61 5a13.3 13.3 0 1 0 2.2-26.6l-61-5a13.3 13.3 0 1 0-2.2 26.6Z\"/>\n  <path fill=\"#19052D\" d=\"m147.7 85.3 46.4 3.8a8.8 8.8 0 0 0 1.4-17.7L149 67.7a8.8 8.8 0 1 0-1.4 17.6Z\"/>\n  <path fill=\"#fff\" d=\"M157 82.6c.1-.6-.5-1.2-1.3-1.3l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .7.6 1.2 1.4 1.3l7.6.6c.8 0 1.5-.4 1.6-1ZM157.5 78c0-.5-.6-1.1-1.4-1.2l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .7.6 1.2 1.4 1.3l7.6.6c.8 0 1.5-.4 1.6-1ZM170.2 83.6c0-.6-.6-1.1-1.4-1.2l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .6.6 1.2 1.4 1.2l7.6.7c.8 0 1.5-.4 1.6-1ZM170.6 79.1c0-.6-.6-1.1-1.4-1.2l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .6.6 1.2 1.4 1.2l7.6.7c.8 0 1.5-.4 1.6-1ZM171 74.6c0-.6-.6-1.1-1.5-1.2l-7.6-.6c-.8 0-1.5.4-1.5 1s.5 1.2 1.4 1.3l7.6.6c.8 0 1.5-.4 1.5-1ZM183.3 84.7c0-.6-.6-1.2-1.4-1.3l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .7.6 1.2 1.4 1.3l7.6.6c.8 0 1.5-.4 1.6-1ZM196.4 85.8c0-.7-.6-1.2-1.4-1.3l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .6.6 1.2 1.4 1.3l7.6.6c.8 0 1.6-.4 1.6-1ZM196.8 81.3c0-.7-.6-1.2-1.4-1.3l-7.6-.6c-.8 0-1.5.4-1.6 1 0 .6.6 1.2 1.4 1.3l7.6.6c.8 0 1.5-.4 1.6-1Z\"/>\n  <path fill=\"#231F20\" d=\"m171.7 104.2-12.3-1.4c-1.9-.2-3.2-2-3-3.8a1 1 0 1 1 2 .2c-.1.8.5 1.5 1.2 1.6l12.4 1.4a1 1 0 1 1-.3 2Z\"/>\n  <path fill=\"#3B3B5A\" fill-rule=\"evenodd\" d=\"M242 64.8a27 27 0 0 0 7 2.3 56.8 56.8 0 0 0 29-4.2c4.2-1.6 8-3.6 11-5.8.3-.2.4-.6.2-.8a.6.6 0 0 0-.8-.2c-3 2.2-6.7 4.2-10.7 5.9a64.9 64.9 0 0 1-21.8 4.7 46.2 46.2 0 0 1-13.9-1.9Z\" clip-rule=\"evenodd\"/>\n  <path fill=\"#3B3B5A\" fill-rule=\"evenodd\" d=\"M242.8 68.6a54.6 54.6 0 0 0 29.7.7c5.2-1.4 10.4-4 15.8-5.5 3.6-.9 7.2-1.3 10.9-.5 6.9 1.6 9.8 5.8 9.4 9.8-.4 4.3-4.4 8-11 7.7-3-.2-4.9-2.8-5.1-5.6-.3-2.7 1-5.5 4.2-6.2 2.7-.5 4.4.7 4.8 2.3.3.9 0 1.9-.5 2.6-.6.6-1.4 1-2.6 1a.6.6 0 0 0 0 1.2c1.6 0 2.8-.6 3.5-1.4a4 4 0 0 0 .7-3.8c-.5-2-2.6-3.7-6.1-3-3.8.8-5.4 4.2-5 7.4.2 3.2 2.4 6.3 6.1 6.5 7.2.4 11.6-4 12-8.6.3-4.3-2.7-9-10.2-10.8-3.9-.8-7.6-.4-11.3.6-5.4 1.4-10.6 4-15.8 5.5a50.1 50.1 0 0 1-14.7 1.9 62.5 62.5 0 0 1-14.8-1.8ZM291.4 59.6l2.4-.5.8-.1.8-.2c3-.6 6.3-.7 9.2 0a13 13 0 0 1 7.3 4.4c.3.3.6.3.9 0 .2-.1.3-.5 0-.8-1.3-1.5-3-2.6-4.7-3.4a17 17 0 0 0-5.6-1.5 21.8 21.8 0 0 0-8.9 1l-2.2 1ZM10 9.8a27 27 0 0 0 7 2.3 56.7 56.7 0 0 0 29-4.2c4.2-1.6 8-3.6 11-5.8.3-.2.4-.6.2-.8a.6.6 0 0 0-.8-.2c-3 2.2-6.7 4.2-10.7 5.9A64.9 64.9 0 0 1 24 11.7 46.2 46.2 0 0 1 10 9.8Z\" clip-rule=\"evenodd\"/>\n  <path fill=\"#3B3B5A\" fill-rule=\"evenodd\" d=\"M10.8 13.6a54.6 54.6 0 0 0 29.7.7c5.2-1.4 10.4-4 15.8-5.5 3.6-.9 7.2-1.3 10.9-.5 6.9 1.6 9.8 5.8 9.4 9.8-.4 4.3-4.4 8-11 7.7-3-.2-4.9-2.8-5.1-5.6-.3-2.7 1-5.5 4.2-6.2 2.7-.5 4.4.7 4.8 2.3.3.9 0 1.9-.5 2.6-.6.6-1.4 1-2.6 1a.6.6 0 0 0 0 1.2c1.6 0 2.8-.6 3.5-1.4a4 4 0 0 0 .7-3.8c-.5-2-2.6-3.7-6.1-3-3.8.8-5.4 4.2-5 7.4.2 3.2 2.4 6.3 6.1 6.5 7.2.4 11.6-4 12-8.6.3-4.3-2.7-9-10.2-10.8-3.9-.8-7.6-.4-11.3.6-5.4 1.4-10.6 4-15.8 5.5a50.2 50.2 0 0 1-14.7 1.9 62.5 62.5 0 0 1-14.8-1.8ZM59.4 4.6l2.4-.5.8-.1.8-.2c3-.6 6.3-.7 9.2 0A13 13 0 0 1 80 8.2c.3.3.6.3.9 0 .2-.1.3-.5 0-.8-1.3-1.5-3-2.6-4.7-3.4a17 17 0 0 0-5.6-1.5 21.8 21.8 0 0 0-8.9 1l-2.2 1Z\" clip-rule=\"evenodd\"/>\n  <g id=\"grot-cta-tumbleweed\" fill=\"#9087e9\" fill-opacity=\".8\">\n    <path d=\"m255.8 142.6.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a14.7 14.7 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a27.4 27.4 0 0 0-.1 4.3 5.7 5.7 0 0 1 .3-.3l.2-.2v-.1Zm-1.3-12.6a28.5 28.5 0 0 1 0-.5h-.1l-.1.2-.2.3-.3.3v.5c.2 0 .2-.1.3-.2a21 21 0 0 0 .3-.4v-.2Zm1.9 5.3v-.2l.4-.8-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1-.3-1.4v-.4l-.2-1.3-.1-.8a32.4 32.4 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1a40.5 40.5 0 0 1 1-1.6l.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a74.4 74.4 0 0 0-1.8 2.4 139.7 139.7 0 0 0-1.5 2.5l-.1.1a19.5 19.5 0 0 0-1.4 3.7l-.4 1.9a71.3 71.3 0 0 1-.2-3.1v-.2.2l-.3.3-.3.4a31.5 31.5 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4 1-3.3Zm6.7-20.2v.2l-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm2.6 23.2v-.2l-.8.8-.2 1a32.9 32.9 0 0 0 .8-.6l.2-1Zm4.4-3.7a18.9 18.9 0 0 0-.5.4l-.6.3-.5.4-.4.4h-.1a10.5 10.5 0 0 0-.5.5l-.2.2a8.6 8.6 0 0 0-.8 1l-.2.3-.4.5-.3.6a22.5 22.5 0 0 0 2.7-2.6l.8-.8v.2h.2l-.2-.2a29 29 0 0 0 1-1.2Zm10 8.5a18.3 18.3 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.2.2-.3-.4.2-.2.4-.1.3-.1.2-.2 1-.1.2c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2c1-.8 1.8-1.6 2.6-2.5l.3-.2c0-.1 0-.2.2-.3l.1-.1.2-.3a26.4 26.4 0 0 0 .4-.5 18.6 18.6 0 0 1-1.8.5l-.2.2a3.2 3.2 0 0 0 .2-.4h-.4a7.1 7.1 0 0 1 0 .7l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 7.8 7.8 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6v-.4a5.8 5.8 0 0 0 0-1V146.2a7.5 7.5 0 0 0-.2-1l-.1-.3a4.3 4.3 0 0 0-.2-.5V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3v.2a9.8 9.8 0 0 1-.1.6v.3l-.3 1v.3l-.2.6a15.8 15.8 0 0 1-1 .4 44 44 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.3 1.3-.7.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l-.6.4Zm-11.8-6.4-.5.3-.4.4a39.2 39.2 0 0 0 1-.7h-.1Zm2.8 8.5-.4.2v.4l.4-.4v-.2Zm-1.8-9.2.1.5.2-.1-.3-.4Zm.8-1.4-.3.2-.2.2-.6.3-.5.4-.4.4h-.1l-.5.5a8.1 8.1 0 0 0-1 1.2l-.2.3-.4.5-.3.6a21 21 0 0 0 2.2-2 39.6 39.6 0 0 0 1.3-1.4v.2h.2l-.2-.2 1-1v-.2Zm-4.4 3.7v-.2l-.8.8-.2 1a35 35 0 0 0 .8-.6l.2-1ZM280 143a21.3 21.3 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.2.2-.3-.4.2-.2.4-.1.3a8.4 8.4 0 0 0-.4 1.4c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2c1-.8 1.8-1.6 2.6-2.5l.3-.2c0-.1 0-.2.2-.3l.1-.1h-.3a7 7 0 0 1-.3.1 22.4 22.4 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 7.8 7.8 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6 1 1 0 0 0 0-.2v-.2a5.3 5.3 0 0 0 0-1V146.1a5.4 5.4 0 0 0-.2-.9l-.1-.3-.2-.4v-.1V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8a4.9 4.9 0 0 1-.2.5c0 .3 0 .7-.2 1v.3l-.2.6a19.6 19.6 0 0 1-1 .4 45.3 45.3 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l-.6.4Zm-11.8-6.4-.5.3-.4.4a39.2 39.2 0 0 0 1-.7h-.1Zm-12.5 5.9.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a14.7 14.7 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a28.3 28.3 0 0 0-.1 4.3 5.8 5.8 0 0 1 .3-.3l.2-.2v-.1Zm-1.3-12.6a28.6 28.6 0 0 1 0-.5h-.1l-.1.2a13 13 0 0 1-.5.6v.5a9.3 9.3 0 0 0 .6-.6v-.2Zm1.9 5.3a9.2 9.2 0 0 1 .4-1l-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1a10.3 10.3 0 0 1-.4-1.8l-.1-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5a118 118 0 0 1 2-3.4l-1.3 1.6a78.8 78.8 0 0 0-1.8 2.4 81.6 81.6 0 0 0-1.5 2.5l-.1.1a19.2 19.2 0 0 0-1.4 3.7l-.4 1.9a79 79 0 0 1-.2-3.1v-.1a1 1 0 0 1 0-.2V130.3l-.3.3-.3.4a32.6 32.6 0 0 0 .3 2.7l.1.6v.2l.1.3a59.8 59.8 0 0 0 .5 2.5l.5 1.4 1-3.3Zm6.7-20.2v.2l-.1.2h-.2l-.1.3-.1.2.4-.4a16.2 16.2 0 0 0 1-1.2l-1 .7Zm-8.6 14.2a13.3 13.3 0 0 1 .2-2.5 16.3 16.3 0 0 1 .5-2.5 24.5 24.5 0 0 1-.5.4l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.9 15.9 0 0 0-.2 3.4 21.5 21.5 0 0 0 .5-.5v-.1l.1-.1h.1v-.2Zm25.6 13.8a21.3 21.3 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.2.2-.3-.4.2-.2.4-.1.3-.1.2-.2 1-.1.2c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3a14.9 14.9 0 0 0 2.3-1.7 40.3 40.3 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a15.3 15.3 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.6 13.6 0 0 1-3.5 2.2 7 7 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.5v-.5a5.3 5.3 0 0 0 0-1 7.6 7.6 0 0 0-.2-1.9l-.1-.3a4.5 4.5 0 0 0-.2-.5V145.3a8.2 8.2 0 0 0 0 .7 4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2a11.4 11.4 0 0 1-.3 1.3v.3l-.2.6a20.6 20.6 0 0 1-1 .4 45.4 45.4 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l-.6.4Zm-24.3-.5.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a14.7 14.7 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a28.3 28.3 0 0 0-.1 4.3 5.8 5.8 0 0 1 .3-.3l.2-.2v-.1Zm-1.3-12.6a28.6 28.6 0 0 1 0-.5h-.1l-.1.2a13 13 0 0 1-.5.6v.5a9.3 9.3 0 0 0 .6-.6v-.2Zm1.9 5.3a9.2 9.2 0 0 1 .4-1l-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1a10.3 10.3 0 0 1-.4-1.8l-.1-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5a118 118 0 0 1 2-3.4l-1.3 1.6a78.8 78.8 0 0 0-1.8 2.4 81.6 81.6 0 0 0-1.5 2.5l-.1.1a19.2 19.2 0 0 0-1.4 3.7l-.4 1.9a79 79 0 0 1-.2-3.1v-.1a1 1 0 0 1 0-.2V130.3l-.3.3-.3.4a32.6 32.6 0 0 0 .3 2.7l.1.6v.2l.1.3a59.8 59.8 0 0 0 .5 2.5l.5 1.4 1-3.3Zm6.7-20.2v.2l-.1.2h-.2l-.1.3-.1.2.4-.4a16.2 16.2 0 0 0 1-1.2l-1 .7Zm-8.6 14.2a13.3 13.3 0 0 1 .2-2.5 16.3 16.3 0 0 1 .5-2.5 24.5 24.5 0 0 1-.5.4l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.9 15.9 0 0 0-.2 3.4 21.5 21.5 0 0 0 .5-.5v-.1l.1-.1h.1v-.2Zm25.6 13.8a21.3 21.3 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.2.2-.3-.4.2-.2.4-.1.3-.1.2-.2 1-.1.2c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3a14.9 14.9 0 0 0 2.3-1.7 40.3 40.3 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a15.3 15.3 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.6 13.6 0 0 1-3.5 2.2 7 7 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.5v-.5a5.3 5.3 0 0 0 0-1 7.6 7.6 0 0 0-.2-1.9l-.1-.3a4.5 4.5 0 0 0-.2-.5V145.3a8.2 8.2 0 0 0 0 .7 4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2a11.4 11.4 0 0 1-.3 1.3v.3l-.2.6a20.6 20.6 0 0 1-1 .4 45.4 45.4 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l-.6.4Zm-24.3-.5.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a14.7 14.7 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a28.3 28.3 0 0 0-.1 4.3 5.8 5.8 0 0 1 .3-.3l.2-.2v-.1Zm-1.3-12.6a28.6 28.6 0 0 1 0-.5h-.1l-.1.2a13 13 0 0 1-.5.6v.5a9.3 9.3 0 0 0 .6-.6v-.2Zm1.9 5.3a9.2 9.2 0 0 1 .4-1l-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1a10.3 10.3 0 0 1-.4-1.8l-.1-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5a118 118 0 0 1 2-3.4l-1.3 1.6a78.8 78.8 0 0 0-1.8 2.4 81.6 81.6 0 0 0-1.5 2.5l-.1.1a19.2 19.2 0 0 0-1.4 3.7l-.4 1.9a79 79 0 0 1-.2-3.1v-.1a1 1 0 0 1 0-.2V130.3l-.3.3-.3.4a32.6 32.6 0 0 0 .3 2.7l.1.6v.2l.1.3a59.8 59.8 0 0 0 .5 2.5l.5 1.4 1-3.3Zm6.7-20.2v.2l-.1.2h-.2l-.1.3-.1.2.4-.4a16.2 16.2 0 0 0 1-1.2l-1 .7Zm-8.6 14.2a13.3 13.3 0 0 1 .2-2.5 16.3 16.3 0 0 1 .5-2.5 24.5 24.5 0 0 1-.5.4l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.9 15.9 0 0 0-.2 3.4 21.5 21.5 0 0 0 .5-.5v-.1l.1-.1h.1v-.2Zm25.6 13.8a21.3 21.3 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.2.2-.3-.4.2-.2.4-.1.3-.1.2-.2 1-.1.2c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3a14.9 14.9 0 0 0 2.3-1.7 40.3 40.3 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a15.3 15.3 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.6 13.6 0 0 1-3.5 2.2 7 7 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.5v-.5a5.3 5.3 0 0 0 0-1 7.6 7.6 0 0 0-.2-1.9l-.1-.3a4.5 4.5 0 0 0-.2-.5V145.3a8.2 8.2 0 0 0 0 .7 4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2a11.4 11.4 0 0 1-.3 1.3v.3l-.2.6a20.6 20.6 0 0 1-1 .4 45.4 45.4 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l-.6.4Zm-24.3-.5.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a14.7 14.7 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a28.3 28.3 0 0 0-.1 4.3 5.8 5.8 0 0 1 .3-.3l.2-.2v-.1Zm-1.3-12.7a28.6 28.6 0 0 1 0-.4h-.1l-.1.2a13 13 0 0 1-.5.6v.5a9.3 9.3 0 0 0 .6-.6v-.2h.1Zm1.9 5.4a9.2 9.2 0 0 1 .4-1l-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1a10.3 10.3 0 0 1-.4-1.8l-.1-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5a118 118 0 0 1 2-3.4l-1.3 1.6a78.8 78.8 0 0 0-1.8 2.4 81.6 81.6 0 0 0-1.5 2.5l-.1.1a19.2 19.2 0 0 0-1.4 3.7l-.4 1.9a79 79 0 0 1-.2-3.1v-.1a1 1 0 0 1 0-.2V130.3l-.3.3-.3.4a32.6 32.6 0 0 0 .3 2.7l.1.6v.2l.1.3a59.8 59.8 0 0 0 .5 2.5l.5 1.4 1-3.3Zm6.6-19.7a18.5 18.5 0 0 0 1-1.2 37.2 37.2 0 0 0-1 .7v.2a6.4 6.4 0 0 1 0 .2h-.2l-.1.3-.1.2.4-.4Zm-8.6 13.9h.1v-.2a13.3 13.3 0 0 1 .2-2.5 16.5 16.5 0 0 1 .5-2.5 24.5 24.5 0 0 0-.5.4l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.5 27.5 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4 21.6 21.6 0 0 0 .6-.6v-.1Zm46 7.7c.4-1.2.6-2.4.8-3.6a17.3 17.3 0 0 0 0-3.3 30.6 30.6 0 0 0-.8-6v-.1l-.2-.7a88 88 0 0 0-.4-2c0 1 .3 2 .4 2.9l.1 1a118 118 0 0 0 .3 1.8c.1 1.6.2 3.3.1 4.9a19.6 19.6 0 0 1-.7 4.6 14 14 0 0 1-.6 1.6v.2l-1 2c0-.5.2-1 .4-1.4v-.2a23.4 23.4 0 0 0 1-9c.1-.1 0-.1 0-.2a12.5 12.5 0 0 0 0 .3v.1a25.9 25.9 0 0 1-3.6 12.8 17 17 0 0 1-1 1.5 25.9 25.9 0 0 1-12.4 9.3 24.6 24.6 0 0 1-5.6 1.2l.1-.1.7-.7.2-.2 1-1 .6-.5a42 42 0 0 0 4.2-1.2 18 18 0 0 0 4.2-1.4l1.2-.7a11.3 11.3 0 0 0 3.8-4.2v-.2l.7-1.8a12 12 0 0 1-7.5 7l2-1.3.1-.1a11.3 11.3 0 0 0 1.5-1.4 15.2 15.2 0 0 0 3.7-6.2 15.6 15.6 0 0 1-1.9 3.4v.2a17 17 0 0 1-3.7 3.7h-.2l-1.1.8.6-1 .9-1.3.9-1.3.5-.6.4-.7a10.4 10.4 0 0 0-2.1 2.4 12.4 12.4 0 0 0-1.4 2.6 22.5 22.5 0 0 1-5.6 2.4l-.5.1 3.1-3.2 3.1-3.1.5-.6 1.8-1.8a56.1 56.1 0 0 0 1.6-1.6l.6-.3a11.7 11.7 0 0 0 2-1.2v-.1l.2-.1a12.3 12.3 0 0 0 3.4-4.6v-.2c.2-.2.3-.5.3-.7l-.2.4h-.1v.1a34.3 34.3 0 0 1-5.9 6.2 18.9 18.9 0 0 0 2.7-4l.4-.6a19.8 19.8 0 0 0 2.1-3.7l.2-.6.2-.7v-.2a15 15 0 0 0 .5-4v-.6l.1-.7v-.1l.1-.4.2-1.3a15.8 15.8 0 0 0-1.1-7.6l-1-2.2-.5-.8-.3-.4.2.6a47.2 47.2 0 0 1 1 3l.6 1.7a21.5 21.5 0 0 1 .5 3.7v1.9a22.3 22.3 0 0 1 0 1.2v.1-.1a24.5 24.5 0 0 0-1.5-6.3 126.6 126.6 0 0 0-.7-2v.1l.5 2a51.4 51.4 0 0 1 1.3 7v1.5a16 16 0 0 1-.8 5 14.4 14.4 0 0 1-1.5 3 16 16 0 0 0 .7-4.8V129c0-.9 0-1.7-.2-2.4v-.4l-.8-4.5v-.2.2l.6 4.8.2 2.9V131.1l-.1.6c-.2 1.2-.4 2.5-.8 3.7a69 69 0 0 1-.6-2.3 22.4 22.4 0 0 1-.7-4.4v-.1a38 38 0 0 1 0-2.1v-.5a7.9 7.9 0 0 0-.5 1.8v.2a11 11 0 0 0 0 2.3 12 12 0 0 0 .7 3.4 13.2 13.2 0 0 0 1 2 13.4 13.4 0 0 1-3.4 5.2l-1.6 1.6-1.2 1.2-.6.6-.9.8-2.8 2.8.6-1 .1-.2a33 33 0 0 0 2.2-4.4v-.2h.1a11 11 0 0 0 2.4-3.6l.7-2a3.2 3.2 0 0 0 0-.3l.1-.1v-.2c.2-.8.3-1.6.3-2.5l-.8 2.5a27.8 27.8 0 0 1-1.4 3.4 24.6 24.6 0 0 1-.8 1.4l.2-.6v-.2l.1-.3.3-1.1v-.1l.3-1 .2-1v-.4a30.7 30.7 0 0 1 1-3.2 9.4 9.4 0 0 0-1 2.1l-.3 1v.1a22 22 0 0 0-.4 1.2l-.5 1.5-.1.5-.3.7v.2a36.7 36.7 0 0 1-.6 1.5v.2l-.3.7-.1.2-.1.2v.2l-.4.7-1 2.2-.6 1.3-.1.2-.6 1-.1.3-.1.1-2.3 2.3-.3.3-1.1 1.2c0-.2 0-.4.2-.6l.1-.5a51.2 51.2 0 0 1 .7-2l.1-.2.1-.3.2-.3v-.2l.4-1-.7 1v.3h-.1l-.2.6-.1.2a18 18 0 0 0-1 3.2l-.3.4h-.1l-.8.8v.2h-.2l-.3.4-.2.2a324 324 0 0 0-3.8.2H267l.6-.3a29.5 29.5 0 0 0 .5-.2l.4-.2a62.9 62.9 0 0 0 2.6-1.2l.7-.3.7-.5a7 7 0 0 0-2.4.5 10 10 0 0 0-3 1.8l-.4.3a37.7 37.7 0 0 1-5-.6 16 16 0 0 1-1.6-.6l-.7-.2a15 15 0 0 0 1.8-.3h.1l.5-.1.4-.1a18.2 18.2 0 0 0 3.7-1.5l.5-.2h.2l.7-.2 2-.4 1.6-.2 2-.3a24.6 24.6 0 0 0 3.7-1 14.9 14.9 0 0 0 1.7-1 6.4 6.4 0 0 0 1.7-1.6l.6-1.5c-.4.8-1 1.5-1.5 2l-1 .7a10.2 10.2 0 0 1-1.7.8l-1.8.6-1.9.4a36.4 36.4 0 0 1-1 .2l-.9.1-1.1.3h.1l.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 7.6-5.9l.3-.3a13.5 13.5 0 0 0 1-1l.3-.5.6-.7.4-.6.5-.6.4-.6.4-.6.7-1.2.7-1.3.3-.7.2-.3.1-.3.6-1.3.2-.6v-.1l.3-.7a23 23 0 0 0 1.2-6.7V122.8a16.4 16.4 0 0 0-.5-2.5l-.1-.4v.5l.1.3a15 15 0 0 1 .3 2.3 16.8 16.8 0 0 1 0 1.8 18.7 18.7 0 0 1-.8 4.7l-.1-.6a12.6 12.6 0 0 1 0-3.4v-.1l.1-.6a4.5 4.5 0 0 0-.4 1.4 6.5 6.5 0 0 0 .3 3.6 25.6 25.6 0 0 1-.7 2l-.3.7-.6 1.3-.1.3-.2.3-.3.7-.7 1.2-.8 1.2v.1l.1-.8.1-.7.8-4v-.5l.1-.1v-.3a66.4 66.4 0 0 0 .8-4.4V125.4a47.3 47.3 0 0 0 0-4.6 18.3 18.3 0 0 0 0-.8v-.2l.2-.4.3-.8.2-.8.1-.9.2-1.9a16 16 0 0 1 2.4-1.8 12 12 0 0 1 .9-.5l.7-.4-.7.2-.7.2h-.1a6.6 6.6 0 0 0-2.5 2 21.8 21.8 0 0 0 0-1.3c0-.8-.1-1.6-.3-2.3v-.2l.1-.6a6.3 6.3 0 0 1 .2-.6 12.5 12.5 0 0 1 1-2.5l-.8 1a6.4 6.4 0 0 0-.7 2v-.2l-.2-.8-.3-.8-.3-.8-.1-.1-.3-.7.2.6v.2l.3.9.2.8.2.8v.4a7 7 0 0 0-1.4-2.7h-.1a4.4 4.4 0 0 0-.5-.6c-.6-.5-1.2-.9-1.9-1.1a9 9 0 0 1 2.2 1.9 8 8 0 0 1 1.6 3l.2 1.3a7.6 7.6 0 0 1 .1.6v.1-.2 2.3a3.9 3.9 0 0 0-.1-.5v-.3h-.1l-.2-.6a7.1 7.1 0 0 0-1.9-2.8c-.5-.5-1.1-.9-1.8-1.1a8.8 8.8 0 0 1 3.6 4.5 6.1 6.1 0 0 1 .2.7l.2.8-.2 1-.1.8-.2.8-.1.3-.1-.4v-.1l-.2-.6a4.6 4.6 0 0 0-.1-.3c-.3-1-.8-2-1.3-2.9-.6-1-1.3-1.9-2.2-2.6a14 14 0 0 1 3.3 7l.2 1.1v1.1l.1.2a4.8 4.8 0 0 1 0 .7v1.6l-.1-.4a63.5 63.5 0 0 1-.4-1l-.3-.8-.1-.2a30 30 0 0 1-1-2.8l-.6-1.6v-.1l-.2-.4.1.6v.2a18.6 18.6 0 0 0 1.5 4.7l.2.3.3.6.5.9.2.3v.6l-.1 1.5v.2l-.2 1V127.8l-.5 3.3-.2 1.5a82 82 0 0 0-.1 1.2 44.9 44.9 0 0 0-.3 3.9l-.4.4-.4.6-.4.6-.4.6-.9 1-.3.4-.7.7-.4.6-.4.3-.1.2v-.2l.1-.5v-.2l.2-.6v-.2a56.4 56.4 0 0 1 .5-2l.1-.4.5-1.6a10.2 10.2 0 0 0-1.2 3 14 14 0 0 0-.3 1.6V143.2h-.1l-.3.3-.6.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.6.4.2-.3.3-.7.2-.5v-.2l.1-.2.2-.3v-.2h.1l.1-.3.4-.8.2-.4.3-.7.4-.8-1 1.3v.1a11.7 11.7 0 0 0-.7 1.4 9.4 9.4 0 0 0-.4 1l-.1.3-.1.2-.2 1-.1.2c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6a7 7 0 0 1-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2c1-.8 1.8-1.6 2.6-2.5l.3-.2c0-.1 0-.2.2-.3l.1-.1a9.3 9.3 0 0 0 .7-.8l.1-.2a16.9 16.9 0 0 0 .5-.5c1-1.2 1.8-2.4 2.6-3.6 0-.2.2-.4.3-.5l1.4-1.2a18.4 18.4 0 0 0 2.1-2.7 55 55 0 0 0 2-3.3l.2-.1 1.4-2.2-.9.8-1.4 1.7-1.9 2.7a120.8 120.8 0 0 1-2 2.7v.1-.2l.2-.2.3-.7.4-.6.6-1.3.5-1.2c0-.3.2-.5.3-.7l.2-.7.5-1.3.4-1.3.2-.6.1-.8.1-.2.3-1.1V128a12 12 0 0 1 1.8-2.1l.3-.3.7-.6-.6.3a5.8 5.8 0 0 0-1.6 1.4l-.5.6.1-.4.1-.7.1-.7v-.4l.1-.2v-.5l.1-.2v-1.4l.1-.7V120v1.4l-.1.7v.6l-.2.7v.7l-.1.4v.2l-.2.6v.1l-.1.8v.1l-.2.5-.3 1.4-.3 1a97.3 97.3 0 0 0 0-2.9v-.1l-.1-.7v-.2l-.2-3.4v-.5a32.8 32.8 0 0 0-.3-1.7v-.2l-.1-.7a10.5 10.5 0 0 0 .4-2 12.3 12.3 0 0 0 0-2V114.5a10.6 10.6 0 0 0-.5-3l-.2-.4v-.2l-.2-.2v1.4h.1a53.4 53.4 0 0 1 .2 3.5v2.2a7.2 7.2 0 0 0-.3-.8 6.5 6.5 0 0 0-.2-.4l-.6-1.2a6.7 6.7 0 0 0-.7-1v-.2h-.1l-.5-.5.3.5.1.1v.1a9.5 9.5 0 0 1 1.2 2.8l.1.4.1.3.4 2.6v1.4l.2 2.2.1 1.7v.9l.1.1v.1-.2l-.3-.6v-.1l-.1-.3a53.8 53.8 0 0 1-1-2.5v-.5l-.3-.7v-.3l-.1-.2v-.1l-.3-1-.2-.6v-.2l-.1-.3a11.4 11.4 0 0 0 .1 1.4 17.9 17.9 0 0 0 .3 1.2v.3a14 14 0 0 0 .3.9l.1.4v.2a20.3 20.3 0 0 0 1 2.4v.1l.4.6v.2l.2.3a80.7 80.7 0 0 0 .2 3.5l-.4 1.3-.5 1.3-.3.6c0 .3-.2.5-.3.7v.2l-.2-.4a43.3 43.3 0 0 0-.2-2l-.2-1.6-.2-1.6a10.5 10.5 0 0 0 0 3.3 14.2 14.2 0 0 0 .6 2.6l-.3.7-.7 1.2-.3.6-.3.6-.6 1-.1.2-.5.7v.1l-.3.4-.4.5c0 .2-.2.4-.4.6l-.8 1v.2a22.3 22.3 0 0 1-.5.5l-.2.3-.2.1c-.2.4-.5.7-.9 1l-.6.8-.3.3-.2.2v-.1a10 10 0 0 0 .6-4.1h.1l.3-.5.3-.5.2-.5.5-1a6.6 6.6 0 0 0 1.1-1.1 7.3 7.3 0 0 0 1-1.7h.1a9.3 9.3 0 0 0 .8-4.5 7.7 7.7 0 0 0-.5-2.3 6 6 0 0 0-.2-.5v1h.1v.2a8.5 8.5 0 0 1 0 1.7c0 .6 0 1.3-.2 2v.2l-.2.5-.9 2.4-.1.2-.6 1v-.1a14.7 14.7 0 0 0 .7-4.2l-.7 2v.1l-.7 2-.6 1.5v.2l-.1.2-.2.5-.1.2-.1.3v-.2a6.2 6.2 0 0 0-.2-1 10.7 10.7 0 0 0-2-4.2v-.1l.8-1 .1-.2.2-.3a24.8 24.8 0 0 0 3.2-5.3 19.5 19.5 0 0 0 .7-2.5 19.9 19.9 0 0 1-2.6 5.2 30.2 30.2 0 0 1-4.3 5l-.2.2-1.3 1.2h-.1l-.8.8h-.1l-1.2 1v-.1l.4-.5.3-.5a9 9 0 0 0 .7-2.2l.1-.6v-.6l.1-.5a18.3 18.3 0 0 0 0-1.4l-.3-1.5a29.1 29.1 0 0 1-.2 2.8l-.1.6-.1.5-.2.5-.6 2.1-.2.5-.2.6-.2.5-.1.3-.8.6-1.3 1-1.3 1-.4.2a29 29 0 0 1 0-1.6v-.7h.1v-.4l.1-1.1v-.5l.2-.4v-.2l.2-1v-.3a28.2 28.2 0 0 1 .7-2.6 15 15 0 0 0-1.4 3.3v.2l-.3.9-.1.4v.2l-.2 1.2a9.8 9.8 0 0 0 0 .6l-.1.3V142.1a13.8 13.8 0 0 0 0 1.5h.3l-.5.2a2.8 2.8 0 0 1-1.6.2v.3a25.5 25.5 0 0 1-.2-2v-.8a29.7 29.7 0 0 1 .3-4l.3-1.5.3-1.3v-.2a28.9 28.9 0 0 1 .3-1l.3-.9h1l.4-.2a6.4 6.4 0 0 0 .8-.2 9.5 9.5 0 0 0 1.6-.8l.2-.1.4-.2.6-.4.4-.3a44.1 44.1 0 0 0 5.5-3.9l1.1-1.1.2-.1.5-.6a14.6 14.6 0 0 0 3-.7 14.5 14.5 0 0 0 2.3-.8 7.6 7.6 0 0 0-2.4.2 10.8 10.8 0 0 0-2.2.6l-.1.1 2-2.2 2-2.4v-.2h.2l.2-.5.1-.1a8.5 8.5 0 0 0 1-2v-.1a8.2 8.2 0 0 1-1 1.9l-.2.1-.2.3-.3.4-.2.1-.2.3-1.8 2-1 .9a120.9 120.9 0 0 0-1.6 1.6l-.2.2-.6.6a66.5 66.5 0 0 1 3-4.7c.2 0 .3-.2.4-.4l.4-.6 1.1-1.3a173.2 173.2 0 0 1-.3 0 22.7 22.7 0 0 0-4 5.5l-.9 1.8a33.7 33.7 0 0 1-.8.7h-.1l-1 1a14.9 14.9 0 0 0 .1-1v-.1a37 37 0 0 0 .4-3v-.4l.1-.1v-.4a27.8 27.8 0 0 0 0-2 8.2 8.2 0 0 0-.3 1.2 18.3 18.3 0 0 0-.5 2v.7a19.4 19.4 0 0 0-.2 3.3 30.4 30.4 0 0 1-3.9 2.5l-.7.5-1 .5-.1.1a15 15 0 0 1-1.3.7 7 7 0 0 1-1 .3l-.7.2c.4-1.2 1-2.3 1.5-3.4l.1-.3a25.3 25.3 0 0 1 5.5-7.1 95.3 95.3 0 0 0 .8-.8l.3-.3.8-.7.4-.4.2-.1 2.7-2.4a8.3 8.3 0 0 0 1.5 0 11.6 11.6 0 0 0 3.6-.9h-1a8.3 8.3 0 0 0-1.8 0c-.4.2-.8.2-1.3.3l-.6.2.2-.1.2-.2.2-.2 1.3-1.1.1-.1.3-.3.2-.1 1.5-1.4.4-.3.2-.2.5-.5 1.2-1-1.4 1-.6.6c-.2 0-.3.2-.5.3l-.5.4-1.4 1.2-.6.4a308.2 308.2 0 0 1-.8.6l-.7.6-.3.3h-.1l-.3.3-1.9 1.5-.4.3a67.2 67.2 0 0 1-2.4 2V118h.1a16 16 0 0 1 .1-1v-.1a17.3 17.3 0 0 1 .3-1.5h.1l.6-.3a44.8 44.8 0 0 0 1.3-.7l.6-.3h.2l1-.7a27.8 27.8 0 0 0 5.6-5 15.3 15.3 0 0 1 1.3-.6 14.5 14.5 0 0 1 3.8-1l2.1-.1c-.6-.3-1.3-.4-2-.4H280a8.1 8.1 0 0 0-4 1l.3-.3.7-1h.1l.1-.3.3-.4.1-.2.6-1 .5-.8.1-.2-.1.2-.6.8-.7.9-.1.2-.2.2-.3.4-.2.2-.6.8a20.9 20.9 0 0 1-1.4 1.4l-.2.2-.3.2-1.4 1.4c-.2 0-.3.2-.5.3l-.5.4-1.3 1 .1-.5a29.4 29.4 0 0 0 .6-2.2v-.2l.1-.1v-.2l.2-.7v-.1l.1-.6a4.7 4.7 0 0 0-.8 1.2v.2l-.1.2v.1l-.2.2a8.9 8.9 0 0 0-.4 3l-1 .6-.3.1-.4.3a23.7 23.7 0 0 0-1.3.7l-1 .6.1-.5.1-.3a24 24 0 0 1 1.5-3.5l.1-.2.8-1.3.2-.3.3-.2-.2.1a9.6 9.6 0 0 1 3-2.7c.2 0 .3 0 .3-.2l.9-.5a25.7 25.7 0 0 0 .5-.3l1.1-1c.4-.2.7-.6 1-1a8.8 8.8 0 0 1-2 1.6l-.2.1-.4.2-1 .6h-.1l-1 .7a10 10 0 0 0-3.4 3.2 32.4 32.4 0 0 0-8.9 7.3c0 .2-.2.3-.3.5l-.2.2-.2.3-2 2.7-.3.6v-.3a24.3 24.3 0 0 1 .4-1.5v-.2a17.6 17.6 0 0 1 1.7-3.8l.5-.8v-.1a20.3 20.3 0 0 1 1-1.6l1.2-1.7.9-1.3.1-.3c.4-.6.8-1.1 1.1-1.8l-1.8 2.2-.3.3a68.5 68.5 0 0 0-2.8 4 18.4 18.4 0 0 0-1.8 4.3l-.1.4a12.3 12.3 0 0 0-.3 2.4l-.8 1.4-.2.4-.1.3c-.7 1.4-1.4 2.8-1.9 4.3l-.1-2.1v-.2a14 14 0 0 1 .1-2.7c.2-1 .5-1.8.9-2.7a9 9 0 0 1 1.6-2.3c-.9.5-1.6 1.2-2.1 2a9.2 9.2 0 0 0-1.1 5.6v.2a10.6 10.6 0 0 0 .7 2.4l-.5 1.7-.2.8-.2.4v.5a35.4 35.4 0 0 0-.7 5 21.7 21.7 0 0 1-1-3.2v-.9a10 10 0 0 1 .7-5l.2-.4a6.3 6.3 0 0 0-1.7 4.5 8 8 0 0 0 .3 2.4 9.2 9.2 0 0 0 1.5 3.2 21.4 21.4 0 0 0 .1 2 30 30 0 0 0 .8 4.4l.1.2a27.7 27.7 0 0 0 3.2 7.2 24.7 24.7 0 0 1-1.7-1.6l-.5-.5a28.2 28.2 0 0 1-3.6-5.3 32.7 32.7 0 0 1-.8-1.6l-.1-.1c-.6-1.2-1-2.4-1.5-3.7l-.6-2a29.5 29.5 0 0 1-.8-3.9v-.2l.1-.2a117.1 117.1 0 0 0 .9-2.9l.3-1 .5-1.8v-.2l.1-.4v-.2l.6-1.3c.3-.6.7-1.1 1.2-1.6v-.1l.4-.4 1-1c.4-.6.8-1.2 1-1.9-.3.6-.7 1.2-1.2 1.7a17.3 17.3 0 0 1-.8.7l-.6.6-.1.1-.1.1a7 7 0 0 0-1.2 1.5l-.1.3c-.3.4-.4 1-.6 1.4V124.7l-.2.4-.1.4-.1.4v.2l-.1.2-.1.4v.1l-.2.4v.1l-.4 1.4c0 .4-.2.8-.3 1.1v-.7c0-1.2.3-2.5.6-3.8v-.2a45.5 45.5 0 0 1 1.8-5.7l.3-.2c0-.2.2-.3.3-.4l.2-.2a106.2 106.2 0 0 0 .8-1l.9-.9 1-1.2a10.7 10.7 0 0 1 1.1-1.1l.6-.4h.1l.1-.1.6-.3.6-.2.2-.1h.1a11 11 0 0 0 1.1-.6l.9-.7a4.2 4.2 0 0 1-1.5.8 1 1 0 0 1-.1 0h-.2l-.4.2-.8.3h-.1a8.6 8.6 0 0 0-1.3.6h-.1l-1.3 1.2-1 1.3-1.1 1.2v.1l-.5.5a41.7 41.7 0 0 1 .7-1.5c.4-1 1-1.8 1.4-2.7.7-.2 1.3-.6 2-1a20 20 0 0 0 1.9-1.6l3.7-3a15.3 15.3 0 0 1 4.2-2.3 8.9 8.9 0 0 1 2.4-.4 6.8 6.8 0 0 1 2 .2h.2l.2.1a3.2 3.2 0 0 0-.3-.1h-.1a6.7 6.7 0 0 0-3-.4 7.7 7.7 0 0 0-1.8.4c-1.5.4-2.9 1.1-4.1 2l-3.4 2.8-.4.3-.4.4-1.4 1.2-1.4 1a27.4 27.4 0 0 1 6-6.5l.4-.3a20.6 20.6 0 0 1 5.5-2.7 15.3 15.3 0 0 1 5.3-.8 14.6 14.6 0 0 0-5.1.4l-.4.1-.6.2a19.6 19.6 0 0 0-4.9 2.3 20.8 20.8 0 0 0-1.4.9l.5-.7a6.4 6.4 0 0 1 .7-.6l.1-.2a13.6 13.6 0 0 1 3.8-2.5l2.6-1a30.4 30.4 0 0 1 8.4-1.5h1.8l.8-.2h.3-1.1a108.5 108.5 0 0 0-4.7.2c-1.9.1-3.8.4-5.7 1-1.5.4-3 1-4.4 2a13.8 13.8 0 0 0-3.5 3v.2l-.3.3-.1.2-.5 1a23 23 0 0 0-4.1 4.5l-.3.5a8.8 8.8 0 0 1 .5-2.5l.1-.2a7.5 7.5 0 0 1 1.3-2.3l.6-.6 1.1-1.3.3-.4.2-.2v-.1l-.5.4v.1c-.2 0-.3.2-.4.3l-.7.6-.3.2-.9 1a7.9 7.9 0 0 0-1 1.7l-.1.2v.1l-.2.5a6.1 6.1 0 0 0-.3 1.6v1.2l-.7 1.3-1 1.8a42.3 42.3 0 0 0-3 8 29.2 29.2 0 0 0-.5 2.6 18.2 18.2 0 0 0-.2 2.2v.2a15.2 15.2 0 0 1-.2-1.4v-.5l-.1-1.5v-1.7l.1-.4a16.7 16.7 0 0 1 1-4.3 9.9 9.9 0 0 1 .4-.8l.9-1.8v-.1l.5-.8a171 171 0 0 0 2.4-4.7v-.1l.2-.2.1-.3-.2.4-2.5 4-.2.3v.2l-.2.2a31 31 0 0 0-2.1 4.5 14.4 14.4 0 0 0-.4 1v.5a17.8 17.8 0 0 0 .3 8.9 17.5 17.5 0 0 0 .3 2.2v.2a32.7 32.7 0 0 0 1 4l.4 1 .4 1 .4 1 .1.3.1.2.3.5.5 1 .5 1 .5.8.3.5.2.2.1.3.6.9.7.8.3.4.4.4.7.9.8.7c0 .2.2.3.4.4l.4.4.2.2.2.1.2.2h.1l.1.2h.1l.3.3.5.3a15 15 0 0 0 1 .6l.2.1.2.1.3.1-.6.6c-.3.2-.5.5-.5 1a1.6 1.6 0 0 0 .2.6h.2a1.3 1.3 0 0 0 .3-.5v-.2a1.6 1.6 0 0 0 .1-.2l.2-.7H257.1l.2.2.3.2.6.4a1.9 1.9 0 0 1 .2-.2l.2.3.2.1.2.1.8.4a17.1 17.1 0 0 0 4.6 1.2l.8.1a41 41 0 0 0 7.2.4 95.1 95.1 0 0 0 3.3 0c1.3-.1 2.7-.2 4-.5l1.6.2a46 46 0 0 0 7.4-1.7c.8-.3 1.5-.8 2.2-1.3 1.4-1 2.5-2.2 3.6-3.6a27.4 27.4 0 0 1-3.8 3.3c-1.4 1-3 1.5-4.5 2l-2.5.5a10.9 10.9 0 0 1-3 .4 24 24 0 0 0 6.8-2.7 27.8 27.8 0 0 0 3.2-2.1 25.4 25.4 0 0 0 4.3-4.4l.5-.8.6-.7.9-1.6.5-1a12.2 12.2 0 0 0 2.9-5v-.1Zm-37-25 .2-.3a32.8 32.8 0 0 1 3.7-2.7 10.8 10.8 0 0 0-.8 1.5 21.3 21.3 0 0 0-2 6.8v.5l-.1 1v1.7h.2l-.3.2-.3.3-.4.4-.2.2-1 1-.3.3-1.7 2.3-.2.2a28.3 28.3 0 0 0-4 9.1l-.1.2-.1.6v.1l-.1.1-.3 1.6-.1 1a10.1 10.1 0 0 1-.4-1.8l-.1-1.3-.1-.8v-.6l.2-.6a21 21 0 0 1 .7-2.1v-.4a20.8 20.8 0 0 1 1.9-3.6v-.1a52.1 52.1 0 0 1 1-1.6l.2-.4.3-.5a118 118 0 0 0 2-3.4l-1.3 1.6a71.6 71.6 0 0 0-1.8 2.4 140 140 0 0 0-1.6 2.6 19.4 19.4 0 0 0-1.4 3.7l-.4 1.9a71.2 71.2 0 0 1-.2-3.1v-.1a.9.9 0 0 1 0-.2v-.6a14.2 14.2 0 0 1 .2-2.5 16.4 16.4 0 0 1 .6-2.6 11.3 11.3 0 0 1 .8-1.3l.3-.4 2-2.5.4-.3a42 42 0 0 1 1.7-1.7l.8-.8a74 74 0 0 0 1.3-1.2l.4-.4a21.6 21.6 0 0 0 1-1.2 37.2 37.2 0 0 0-1 .7v.1h-.2l-1.9 1.6-1.5 1.3a29.4 29.4 0 0 0-3 3.4 25.8 25.8 0 0 1 3.2-5.3l.7-.8c0-.2.2-.3.3-.4l2.8-2.9Zm-6.8 39a12.2 12.2 0 0 0-.2-.5 28.3 28.3 0 0 1-.8-2 50.9 50.9 0 0 1-1.4-3.4l-1-3-.2-.8-.1-.4v-.4c-.2-.3-.2-.5-.2-.8l-.1-.4v-.4l-.3-2.5a19.4 19.4 0 0 1 .3-4.5V131.8a27.5 27.5 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4v.6a32.6 32.6 0 0 0 .4 2.8l.1.6v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4V139a28.3 28.3 0 0 0-.1 4.3v.9a26.7 26.7 0 0 0 1.4 6.8v.2l.2.3-.3-.3Zm2.3 1.2h-.3v-.2l-.1-.2a14.2 14.2 0 0 1-.8-2.2 27.2 27.2 0 0 1-1.1-5.5 2.8 2.8 0 0 0 1.7 0l1.6-.8 1.4-1 1.3-1a62.3 62.3 0 0 0 2-1.5 37.8 37.8 0 0 0 1-.8 19.7 19.7 0 0 0 2.2-2 39.6 39.6 0 0 0 1.3-1.4v.2h.1a19.3 19.3 0 0 1 1.4 5V141.3l.1.5v4a21.5 21.5 0 0 1-.1.3v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.6 13.6 0 0 1-3.5 2.2 7.6 7.6 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.5v-.5a5.3 5.3 0 0 0 0-1 8.3 8.3 0 0 0 0-.9v-.1a5.3 5.3 0 0 0-.2-.9l-.1-.3a4.4 4.4 0 0 0-.2-.5V145.4a33.1 33.1 0 0 1 0 .7v.5l-.1.4v.1a16.5 16.5 0 0 1 0 .8l-.1.3a6 6 0 0 1 0 .6l-.1.2v.3l-.3 1v.3l-.2.6a16.8 16.8 0 0 1-2.6.8 14.3 14.3 0 0 1-2.5.4Zm-4.4-23.1a13.3 13.3 0 0 1 .2-2.5 16.5 16.5 0 0 1 .5-2.5l-.2.2c-.1 0-.2 0-.3.2l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4l.3-.2.2-.3v-.1l.1-.1h.1v-.2Zm8.6-14.2v.2a5.5 5.5 0 0 1-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm-6.7 20.2v-.2l.4-.8-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1-.3-1.4v-.4l-.2-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a71.6 71.6 0 0 0-1.8 2.4l-.5.8a34 34 0 0 0-2 3.5 14.3 14.3 0 0 0-.9 3.9 80 80 0 0 1-.2-3.1v-.1a1.2 1.2 0 0 1 0-.2V130.3l-.3.3-.3.4a31.4 31.4 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4a36 36 0 0 1 1-3.3Zm-2-5.3h.1a17 17 0 0 1 0-.5h-.1l-.1.2-.2.3-.2.3v.5l.2-.2.3-.4v-.2Zm1.4 12.6.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a13.6 13.6 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a27.4 27.4 0 0 0-.1 4.3 5.7 5.7 0 0 1 .3-.3l.2-.2v-.1Zm24.3.5a21.2 21.2 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.3.3-.6.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.1.2-.4-.4.2-.2.4-.1.3a8.4 8.4 0 0 0-.3 1.1l-.1.3c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2a39.8 39.8 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a24.1 24.1 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 8.6 8.6 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6v-.4a5.3 5.3 0 0 0 0-1V146.2a7.5 7.5 0 0 0-.2-1l-.1-.3a4.4 4.4 0 0 0-.2-.5V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2v.3l-.3 1v.3l-.2.6a17.5 17.5 0 0 1-1 .4 45.3 45.3 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31.1 31.1 0 0 0 7.6-5.9l-.6.4Zm-25.6-13.8a13.3 13.3 0 0 1 .2-2.5 16.5 16.5 0 0 1 .5-2.5l-.2.2c-.1 0-.2 0-.3.2l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4l.3-.2.2-.3v-.1l.1-.1h.1v-.2Zm8.6-14.2v.2a5.5 5.5 0 0 1-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm-6.7 20.2v-.2l.4-.8-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1-.3-1.4v-.4l-.2-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a71.6 71.6 0 0 0-1.8 2.4l-.5.8a34 34 0 0 0-2 3.5 14.3 14.3 0 0 0-.9 3.9 80 80 0 0 1-.2-3.1v-.1a1.2 1.2 0 0 1 0-.2V130.3l-.3.3-.3.4a31.4 31.4 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4a36 36 0 0 1 1-3.3Zm-2-5.3h.1a17 17 0 0 1 0-.5h-.1l-.1.2-.2.3-.2.3v.5l.2-.2.3-.4v-.2Zm1.4 12.6.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a13.6 13.6 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a27.4 27.4 0 0 0-.1 4.3 5.7 5.7 0 0 1 .3-.3l.2-.2v-.1Zm24.3.5a21.2 21.2 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.3.3-.6.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.1.2-.4-.4.2-.2.4-.1.3a8.4 8.4 0 0 0-.3 1.1l-.1.3c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2a39.8 39.8 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a24.1 24.1 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 8.6 8.6 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6v-.4a5.3 5.3 0 0 0 0-1V146.2a7.5 7.5 0 0 0-.2-1l-.1-.3a4.4 4.4 0 0 0-.2-.5V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2v.3l-.3 1v.3l-.2.6a17.5 17.5 0 0 1-1 .4 45.3 45.3 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31.1 31.1 0 0 0 7.6-5.9l-.6.4Zm-25.6-13.8a13.3 13.3 0 0 1 .2-2.5 16.5 16.5 0 0 1 .5-2.5l-.2.2c-.1 0-.2 0-.3.2l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4l.3-.2.2-.3v-.1l.1-.1h.1v-.2Zm8.6-14.2v.2a5.5 5.5 0 0 1-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm-6.7 20.2v-.2l.4-.8-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1-.3-1.4v-.4l-.2-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a71.6 71.6 0 0 0-1.8 2.4l-.5.8a34 34 0 0 0-2 3.5 14.3 14.3 0 0 0-.9 3.9 80 80 0 0 1-.2-3.1v-.1a1.2 1.2 0 0 1 0-.2V130.3l-.3.3-.3.4a31.4 31.4 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4a36 36 0 0 1 1-3.3Zm-2-5.3h.1a17 17 0 0 1 0-.5h-.1l-.1.2-.2.3-.2.3v.5l.2-.2.3-.4v-.2Zm1.4 12.6.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a13.6 13.6 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a27.4 27.4 0 0 0-.1 4.3 5.7 5.7 0 0 1 .3-.3l.2-.2v-.1Zm24.3.5a21.2 21.2 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.3.3-.6.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.1.2-.4-.4.2-.2.4-.1.3a8.4 8.4 0 0 0-.3 1.1l-.1.3c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2a39.8 39.8 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a24.1 24.1 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 8.6 8.6 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6v-.4a5.3 5.3 0 0 0 0-1V146.2a7.5 7.5 0 0 0-.2-1l-.1-.3a4.4 4.4 0 0 0-.2-.5V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2v.3l-.3 1v.3l-.2.6a17.5 17.5 0 0 1-1 .4 45.3 45.3 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31.1 31.1 0 0 0 7.6-5.9l-.6.4Zm-25.6-13.8a13.3 13.3 0 0 1 .2-2.5 16.5 16.5 0 0 1 .5-2.5l-.2.2c-.1 0-.2 0-.3.2l-.2.1-1 .7v.2l-.2.5-.2.7-.3 1.5v.4l-.1.2v.2-.1l.5-.5c-.3.3-.4.6-.6 1v.4l-.2.8v.8l-.1.8c0-.2.2-.3.3-.4v-.2a27.4 27.4 0 0 1 1.4-5 15.6 15.6 0 0 0-.2 3.4l.3-.2.2-.3v-.1l.1-.1h.1v-.2Zm8.6-14.2v.2a5.5 5.5 0 0 1-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm-6.7 20.2v-.2l.4-.8-.7.6-.1.6v.1l-.1.1-.3 1.6-.1 1-.3-1.4v-.4l-.2-1.3-.1-.8a42 42 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1l.5-.8.1-.2.4-.6.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a71.6 71.6 0 0 0-1.8 2.4l-.5.8a34 34 0 0 0-2 3.5 14.3 14.3 0 0 0-.9 3.9 80 80 0 0 1-.2-3.1v-.1a1.2 1.2 0 0 1 0-.2V130.3l-.3.3-.3.4a31.4 31.4 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5l.5 1.4a36 36 0 0 1 1-3.3Zm-2-5.3h.1a17 17 0 0 1 0-.5h-.1l-.1.2-.2.3-.2.3v.5l.2-.2.3-.4v-.2Zm1.4 12.6.3-2.1.5-2.5.1-.4.3-1.6.3-1.3a13.6 13.6 0 0 0-.9.6 36.5 36.5 0 0 0-1 3.4v.2a27.4 27.4 0 0 0-.1 4.3 5.7 5.7 0 0 1 .3-.3l.2-.2v-.1Zm9.9-4.3v-.2l-.8.8-.2 1a37.8 37.8 0 0 0 .8-.6l.2-1Zm4.4-3.7a18.8 18.8 0 0 0-.5.4l-.6.3-.5.4-.4.4h-.1a10 10 0 0 0-.5.5l-.2.2a8.4 8.4 0 0 0-.7.7l-.1.3-.2.3-.4.5-.3.6.6-.5a40 40 0 0 0 2.9-2.9v.2h.2l-.2-.2a30 30 0 0 0 1-1.2Zm10 8.5a21.2 21.2 0 0 1-1 .4l-.5.6-.1.1-.3.2-.3.3-.3.3-.6.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2l.1-.1.2-.4-.4.2-.2.4-.1.3a8.4 8.4 0 0 0-.3 1.1l-.1.3c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3c.7-.4 1.4-.9 2-1.5l.3-.2a39.8 39.8 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1h-.3l-.3.1a24.1 24.1 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4a13.5 13.5 0 0 1-3.5 2.2 8.6 8.6 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6v-.4a5.3 5.3 0 0 0 0-1V146.2a7.5 7.5 0 0 0-.2-1l-.1-.3a4.4 4.4 0 0 0-.2-.5V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8l-.1.2v.3l-.3 1v.3l-.2.6a17.5 17.5 0 0 1-1 .4 45.3 45.3 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31.1 31.1 0 0 0 7.6-5.9l-.6.4Zm-11.8-6.4-.5.3-.4.4a39.9 39.9 0 0 0 1-.7h-.1Zm-13.2-.2-.1-1.3-.1-.8a32.4 32.4 0 0 1 .9-3.3v-.4a21 21 0 0 1 1.9-3.6v-.1a40.5 40.5 0 0 1 1-1.6l.2-.4.3-.5.3-.4 1.7-3-1.3 1.6a74.4 74.4 0 0 0-1.8 2.4 139.7 139.7 0 0 0-1.5 2.5l-.1.1a19.5 19.5 0 0 0-1.4 3.7l-.4 1.9a71.3 71.3 0 0 1-.2-3.1v-.2.2l-.3.3-.3.4a31.5 31.5 0 0 0 .4 3.3v.2l.1.3a59.4 59.4 0 0 0 .5 2.5 20.9 20.9 0 0 1 .2-.7Zm8-21.4v.2l-.1.2h-.2l-.1.3-.1.2.4-.4a18.5 18.5 0 0 0 1-1.2l-1 .7Zm-7 19.8-.1.6v.1l.2-.1.1-.1.1-.1a11.8 11.8 0 0 1 .4-1l-.7.6Zm-1.6-5a28.5 28.5 0 0 1 0-.4h-.1l-.1.2-.2.3-.3.3v.5c.2 0 .2-.1.3-.2a21 21 0 0 0 .3-.4v-.2Zm17-7-1.3 1.3-.1.3-.2.1a23.5 23.5 0 0 0-.7 1.1l-.2.3v.2l-.2.3 1.1-1.1.2-.1v-.2a8.9 8.9 0 0 1 .4-.6 10.3 10.3 0 0 1 1-1.3l.2-.4.2-.2-.4.4Zm2.9 19.4-.8.7-.4.5-.2.3a17 17 0 0 0 .8-.9 27.8 27.8 0 0 0 .6-.6Zm6.3.3-.3.1-.3.2a10 10 0 0 1-.4.2 1.6 1.6 0 0 1-.2.1l-.3.3-.6.6-.1.1-.3.2-.3.3-.4.3-.5.5-.6.4-.5.4-.6.4-.5.4v-.3l.4-.7.2-.5v-.2a6.7 6.7 0 0 1 .3-.5 12.4 12.4 0 0 1 .1-.3l.1-.2-.4.2a8.7 8.7 0 0 0-.4 1l-.1.2a8.4 8.4 0 0 0-.3 1.1l-.1.3c-.6.4-1.1.8-1.7 1l-.6.5-.3.1-.4.2-1.2.6c-.2.2-.5.3-.7.3l-.6.3-1.4.6-1 .3a14.9 14.9 0 0 0 2.3-1.7 40.3 40.3 0 0 0 2.9-2.7c0-.1 0-.2.2-.3l.1-.1.2-.3a26.3 26.3 0 0 0 1-1.2l-.3.1-1.4.6-.4.2-.3.3-.2.2v-.1a9 9 0 0 0 .3-.7v-.4a8.6 8.6 0 0 0 .3-1.2V142h.1l.3-.5.3-.5.2-.5.6-1a6 6 0 0 0 1-1.1 7.3 7.3 0 0 0 1-1.7 31 31 0 0 1 0-1.7 12 12 0 0 1-1 2.4l-.1.2-.6 1v-.1a14.8 14.8 0 0 0 .7-4.2l-.7 2v.1a59 59 0 0 1-.7 2l-.6 1.5v.2l-.1.2-.2.5-.1.2v.3h-.1v-.2a5.6 5.6 0 0 0-.2-1 10.7 10.7 0 0 0-1.9-4.1l-.2-.2 1-1v-.2l.3-.3a24.6 24.6 0 0 0 3.1-5.3 19.5 19.5 0 0 0 .7-2.5 19.8 19.8 0 0 1-2.6 5.2 30.3 30.3 0 0 1-4.3 5l-.2.2-1.3 1.2h-.1l-.8.8-.2 1a35 35 0 0 0 .9-.7 19.5 19.5 0 0 0 2.2-2 39.7 39.7 0 0 0 1.3-1.4v.2h.1a19.3 19.3 0 0 1 1.4 4.7v.6l.1.5v4a6.7 6.7 0 0 1-.2.7 23.6 23.6 0 0 0-.6.6l-1.3 1.2-.5.4a13.6 13.6 0 0 1-3.5 2.2 7.8 7.8 0 0 0 .2-.6l.1-.2a8.3 8.3 0 0 0 .4-1.6 1 1 0 0 0 0-.2v-.2a5.3 5.3 0 0 0 0-1V146.2a8.9 8.9 0 0 0-.2-1l-.1-.3a4 4 0 0 0-.2-.4v-.1V146a4.4 4.4 0 0 1 0 .4v.2l-.1.4v.9l-.1.3V148.8a5 5 0 0 1-.2.5c0 .3 0 .7-.2 1v.3l-.2.6a19.6 19.6 0 0 1-1 .4 44 44 0 0 0 6-.9l.9-.2.9-.3.8-.3h.2l-1 .1-1 .3.7-.4 1.3-.6.3-.1.4-.2.6-.4a31 31 0 0 0 8-6.2l-.4.2Z\"/>\n    <path d=\"M264.6 148v-.3a3.6 3.6 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a31 31 0 0 1 1.3-5.5v-.2a35.2 35.2 0 0 1 .3-.6h-.3v-.1.2l-.1.2a19 19 0 0 0-.6 2.3v.6l-.1.4-.1.5-.2 1.2v.1a24.8 24.8 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm1.8-16.1v.3l-.1.2.1-.5Zm-6.1 8.8h-.4l-.1.1h-.4l-.1.1a6 6 0 0 0-.3.1h-.2l-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1.4-.3h.2a14 14 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm2.6-9.1a5.7 5.7 0 0 0-.7.1h-.2l-.1.2v-.1h-.3l-.1.5a9.6 9.6 0 0 0-.4.5l.5-.2h.2a7.8 7.8 0 0 1 .4-.2l.2-.2.1-.2a37.5 37.5 0 0 1 .4-.4Zm-7.6 12.6-.2.1a9.1 9.1 0 0 1 .2-.1Zm29-3.2h.2-.1Zm-3.2 2a18.3 18.3 0 0 1-1.5.8l1.1-1a28.2 28.2 0 0 1-1.5.7l-.3.2a25.6 25.6 0 0 1-1.3 1.1h.3v-.1l.3-.1a28.6 28.6 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1a15.3 15.3 0 0 0 1.1-.7l-1 .5Zm-5.8 2v.1l-.4.1-1.8.8a17.4 17.4 0 0 1-.7.2h-.2l-.2.1a24 24 0 0 0 .5-.6h.2l.1-.2-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a24.2 24.2 0 0 0 2-1.3l.2-.1.2-.2h.1a4.7 4.7 0 0 0 .6 0h.1l.3-.1a14.2 14.2 0 0 0 1.9-.6 79.9 79.9 0 0 0 1.2-.4v-.2a5.5 5.5 0 0 1 .3-.5l-.4.2Zm16.6-17v-.2.1c0 .3-.2.5-.3.7l.3-.5Zm-.4.3-.1.3a32.6 32.6 0 0 1-1.7 4.1l.1-.1a25.6 25.6 0 0 0 1.4-2.8l.3-1.5Zm-3 5.9.1-.4.1-.2.2-.8.1-.3a23.3 23.3 0 0 0 .7-3.3 63.4 63.4 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2a40 40 0 0 1-.6 2.1v.2l-.1.3a27.8 27.8 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1l-.1.2a19.2 19.2 0 0 1-1.4 2.5 18.1 18.1 0 0 1-1.6 1.5l2-.3.3-.3a49.6 49.6 0 0 0 .8-2.5l.3-.9.1-.5v-.2l.3-.1.4-.5-.2.8.1-.2a5.7 5.7 0 0 0 .2-.6l.2-.3.2-.7Zm-6.2 7.4-.5.3-.5.4-.3.1-.3.2-.3.1a19.2 19.2 0 0 1-.7.4l-.2.1-.3.2h-.2l-1 .6-.6.2-.5.2a15.9 15.9 0 0 0 1.4-1.1h.1v-.1l.2-.1a6.9 6.9 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a22.1 22.1 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1a75.1 75.1 0 0 0 .8-1.7l.2-.6.1-.2-.2.3v.1a22.3 22.3 0 0 0-.5.6l-.2.4-.3.5-1.1 2-1.1 2a73 73 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a18.8 18.8 0 0 1-.5.8h-.1c0 .2-.1.2-.2.3l-.9 1v.1l-.4.4a8.8 8.8 0 0 1-.3.3 27 27 0 0 1-1.1 1l-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a78.8 78.8 0 0 0 2.1-.8h.1a27.1 27.1 0 0 0 1.6-1.3 10 10 0 0 0 .9-.4l.6-.4-1 1.1.2-.1a28.7 28.7 0 0 0 1.2-.6l1.2-1.5Zm2-.6h.2-.1Zm-3.2 2a14.3 14.3 0 0 1-1.5.8l1.1-1a28.2 28.2 0 0 1-1.5.7l-.3.2a25.6 25.6 0 0 1-1.3 1.1h.3v-.1l.3-.1a24.4 24.4 0 0 0 1.1-.5l.3-.1h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3-1 .5Zm-5.8 2v.1l-.4.1-1.8.8-.4.1-.3.1h-.2l-.2.1-.4.1a18.6 18.6 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2.2-.1.5-.3a12.6 12.6 0 0 0 1.3-.9l.2-.1.2-.2h.1a3.8 3.8 0 0 0 .6 0h.1a9 9 0 0 0 1.2-.4l1-.3.8-.2.4-.2v-.2l.1-.2.2-.3-.4.2Zm-10.7 3v-.3a3.6 3.6 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a31.4 31.4 0 0 1 1.3-5.5v-.2a41.9 41.9 0 0 1 .3-.6h-.3v-.1.2a10.1 10.1 0 0 0-.2.7 20.4 20.4 0 0 0-.6 2.4v.4l-.1.5-.2 1.2v.1a24.9 24.9 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm1.8-16.1v.3l-.1.2.1-.5Zm-6.1 8.8h-.4l-.1.1a4 4 0 0 0-.4 0l-.1.1-.3.1h-.2a9.5 9.5 0 0 0-2.4 1.2l-.1.2h-.2v.1l-.3.2-.2.2a3.5 3.5 0 0 0-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1a7.2 7.2 0 0 1 .5-.3 21.3 21.3 0 0 1 .8-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm2.6-9.1a5.7 5.7 0 0 0-.9.2h-.4l-.1.5a9.6 9.6 0 0 0-.4.5l.5-.2h.2l.4-.1.2-.3.1-.2a37.4 37.4 0 0 1 .4-.4Zm-7.6 12.6-.2.1a6.5 6.5 0 0 1 .2-.1Zm36.6-16.1V127.8v.1a50.7 50.7 0 0 1 0 .2Zm-.4.2-.1.3a33 33 0 0 1-1.7 4.1l.1-.1a26.7 26.7 0 0 0 1.4-2.8l.3-1.5Zm-3 5.9.1-.4a44.5 44.5 0 0 0 .3-1l.1-.3a22.5 22.5 0 0 0 .7-3.3 63.2 63.2 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a21 21 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1l-.1.2a13.1 13.1 0 0 1-.5 1 23.5 23.5 0 0 1-.9 1.5 21.4 21.4 0 0 1-1.5 1.4l2-.2.2-.3.3-.7.1-.5a81.2 81.2 0 0 0 .8-2.7v-.2l.3-.1.4-.5-.2.8.1-.2.1-.3v-.2a25.8 25.8 0 0 0 .3-.4l.2-.7Zm-6.2 7.4-.5.3-.5.4-.3.1-.3.2-.3.1a19.2 19.2 0 0 1-.7.4 1.6 1.6 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a15.9 15.9 0 0 0 1.5-1.2l.2-.1a6.2 6.2 0 0 0 .7-.8l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a22 22 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4a31 31 0 0 0-1.4 2.5l-1.1 2a67 67 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a12.8 12.8 0 0 1-.5.8h-.1l-.2.3-.9 1v.1a47.9 47.9 0 0 1-1.4 1.4l-.4.3-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a78.8 78.8 0 0 0 2.1-.8h.1a26.2 26.2 0 0 0 1.3-1.1l.3-.2h.2a19.1 19.1 0 0 0 1.3-.8 33 33 0 0 1-.8 1 28.7 28.7 0 0 0 1.2-.6l1.2-1.5Zm2-.6h.2-.1Zm-3.2 2a18.3 18.3 0 0 1-1.2.7l-.3.1 1.1-1a30.3 30.3 0 0 1-1.5.7l-.3.2a25.6 25.6 0 0 1-1.3 1.1h.3v-.1l.3-.1a24.4 24.4 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3-1 .5Zm-5.8 2v.1l-.4.1-1.8.8-.4.1-.3.1h-.2l-.2.1-.4.1a30.7 30.7 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a13 13 0 0 0 1-.6l1-.7.2-.1.2-.2h.1a4.7 4.7 0 0 0 .6 0h.1a9 9 0 0 0 1.2-.4l1-.3.8-.2.4-.2v-.2l.1-.2.2-.3-.4.2Zm-10.7 3v-.3a3.5 3.5 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a30.6 30.6 0 0 1 1.3-5.5v-.2l.2-.5v-.1h-.2v-.1.2a6.7 6.7 0 0 0-.2.7l-.2.6a20.6 20.6 0 0 0-.4 1.8v.4l-.1.5-.2 1.2v.1a19.3 19.3 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm1.8-16.1v.3l-.1.2.1-.5Zm-6.1 8.8h-.4l-.1.1h-.4l-.1.1-.3.1h-.2l-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1.4-.3h.2a16.9 16.9 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm2.6-9.1a7.4 7.4 0 0 0-.9.2h-.4l-.1.5a8.4 8.4 0 0 0-.4.5 13.8 13.8 0 0 1 1.1-.4l.2-.2.1-.2.4-.4Zm-7.6 12.6-.2.1.2-.2Zm36.6-16.1V127.8v.1a56 56 0 0 1 0 .2Zm-.4.2-.1.3a31 31 0 0 1-.7 2.3l.5-1c0-.6.2-1.1.3-1.6Zm-3 5.9.1-.4a44.5 44.5 0 0 1 .3-1l.1-.3a23.3 23.3 0 0 0 .7-3.3 63.3 63.3 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7a45.4 45.4 0 0 0-.4 1.5l-.6 2.2a40 40 0 0 1-.6 2.1v.2l-.1.3a21 21 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1a49.9 49.9 0 0 1-1.5 2.7 19.7 19.7 0 0 1-1.6 1.5l2-.3.3-.3.3-.7.1-.5a96 96 0 0 0 .8-2.7v-.2l.3-.1.4-.5-.2.8.1-.2a5.2 5.2 0 0 0 .2-.6l.2-.3.2-.7Zm-6.2 7.4-.5.3-.5.4-.3.1-.3.2-.3.1-.3.2a10 10 0 0 1-.4.2 1.6 1.6 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a15.5 15.5 0 0 0 1.5-1.2l.2-.1.3-.3.4-.4v-.1a7.8 7.8 0 0 0 .3-.2l.4-.5.2-.3.1-.1.2-.2a21.9 21.9 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1a24.4 24.4 0 0 0-.5.6l-.2.4a31 31 0 0 0-1.4 2.5l-1.1 2a67.2 67.2 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a14.8 14.8 0 0 1-.5.8h-.1l-.2.3-.9 1v.1l-.4.4a8.7 8.7 0 0 1-.3.3 25.4 25.4 0 0 1-1.1 1l-.2.2-.4.4h-.1a14.3 14.3 0 0 0-.2.5l-.1.2 1.5-.5.6-.3h.1l.4-.3a25.6 25.6 0 0 0 1.2-1 10 10 0 0 0 .9-.4l.6-.4-1 1.1.2-.1a28.7 28.7 0 0 0 1.2-.6l1.2-1.5Zm2-.6h.2-.1Zm-3.2 2a18.3 18.3 0 0 1-1.2.7l-.3.1 1.1-1a26.1 26.1 0 0 1-1.5.7l-.3.2a25.6 25.6 0 0 1-1 1l.3-.1a20.1 20.1 0 0 0 1.4-.6h.1l.1-.1a27.6 27.6 0 0 0 1-.5l.3-.1.3-.2a28 28 0 0 1 .8-.5l-1 .5Zm-5.8 2v.1l-.4.1-1.8.8a19.7 19.7 0 0 1-.7.2h-.2l-.2.1-.4.1a24.1 24.1 0 0 0 .9-.6l.2-.2.1-.1h-.3v.1l-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2a36.2 36.2 0 0 0-.5.4l.5-.2.2-.2a13 13 0 0 0 1-.6l1-.7.2-.1.2-.2h.1a4.6 4.6 0 0 0 .6 0h.1a9.7 9.7 0 0 0 1.2-.4l1-.3.8-.2.4-.2v-.2l.1-.2.2-.3-.4.2Zm-10.7 3v-.3a3.6 3.6 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a37 37 0 0 1 1.3-5.5v-.2l.2-.5v-.1h-.2v-.1a1.8 1.8 0 0 0 0 .2l-.1.2-.1.5-.2.6a20.5 20.5 0 0 0-.4 1.8v.4a52.4 52.4 0 0 0-.3 1.7v.1a19.3 19.3 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm1.8-16.1v.3l-.1.2.1-.5Zm-6.1 8.8h-.4l-.1.1h-.4l-.1.1-.3.1h-.2a7 7 0 0 0-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1.4-.3h.2a14 14 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3a97.1 97.1 0 0 0 .2-.2Zm2.6-9.1a5.7 5.7 0 0 0-.9.2h-.4l-.1.5a9.3 9.3 0 0 0-.4.5l.5-.2h.2l.4-.1.2-.3.1-.2.4-.4Zm-7.6 12.6-.2.1.2-.2Zm36.6-16.1V127.8v.1a46.8 46.8 0 0 1 0 .2Zm-.4.2-.1.3a31.4 31.4 0 0 1-1.7 4.1l.1-.1a25.6 25.6 0 0 0 1.4-2.8l.3-1.5Zm-3 5.9.1-.4.1-.2a33 33 0 0 0 1-4.4 62.7 62.7 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7a49.6 49.6 0 0 0-.4 1.5l-.6 2.2-.6 2.1v.2l-.1.3a20.8 20.8 0 0 1-.4 1.2 25.1 25.1 0 0 1-.4.8v.3l-.1.1-.1.2a15 15 0 0 1-1.9 3l-1 1 2-.3.2-.3.3-.7.1-.5a96 96 0 0 0 .8-2.7v-.2a7.6 7.6 0 0 0 .7-.6l-.2.8.1-.2a5.7 5.7 0 0 0 .2-.6 9.1 9.1 0 0 0 .2-.4l.2-.6Zm-6.2 7.4-.5.3-.5.4-.3.1-.3.2-.3.1-.3.2a9.2 9.2 0 0 1-.4.2 1.5 1.5 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a16.2 16.2 0 0 0 1.4-1.1h.1v-.1l.2-.1a6.2 6.2 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a22 22 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5a75 75 0 0 0-1.1 2l-1.1 2a78 78 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a12.8 12.8 0 0 1-.6.9l-.2.2-.9 1v.1l-.4.4-.1.1a10.7 10.7 0 0 1-1 1l-.3.2-.2.2-.4.4h-.1a16.5 16.5 0 0 0-.2.5l-.1.2a76.4 76.4 0 0 0 2.1-.8h.1a35.3 35.3 0 0 0 1.3-1.1l.3-.2a7.8 7.8 0 0 0 .9-.4l.6-.4a31 31 0 0 1-.8 1 26.4 26.4 0 0 0 1.2-.6l1.2-1.5Zm2-.6h.2-.1Zm-3.8 2.4-.6.3-.3.1 1.1-1a28.2 28.2 0 0 1-1.5.7l-.3.2-1 .8-.3.3h.3v-.1l.3-.1.5-.2.6-.3.3-.1h.1l.1-.1.7-.3.3-.2.3-.1.3-.2a16.5 16.5 0 0 1 .8-.5 27 27 0 0 1-1.7.8Zm-5.3 1.7-.3.1-1.8.8-.4.1-.3.1h-.2l-.2.1a7 7 0 0 1-.4.1 22.4 22.4 0 0 0 .9-.6l.2-.2.1-.1a22.3 22.3 0 0 1-.3.1l-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2.2-.1.5-.3a14 14 0 0 0 1.3-.9l.2-.1.2-.2h.1a3.8 3.8 0 0 0 .6 0h.1a9.1 9.1 0 0 0 1.2-.4l1-.3a133.2 133.2 0 0 0 1.2-.4v-.2a5.5 5.5 0 0 1 .3-.5l-.4.2Zm-10.6 2.9a3 3 0 0 1-.3-1l-.1-.2c-.1-.7-.2-1.3-.1-2l.2-1.9a98.3 98.3 0 0 1 .3-3 34 34 0 0 1 1.3-5.4v-.2a41.9 41.9 0 0 1 .3-.6h-.3v-.1.2l-.1.2a20.2 20.2 0 0 0-.6 2.3v.6l-.1.4-.1.5-.2 1.2v.1a24.9 24.9 0 0 0-.2 1 61 61 0 0 0-.4 3l-.2 1.9.1 2 .4 1v.1h.1v-.1Zm1.7-15.8v.2l.1-.5v.3Zm-6.2 8.5h-.2l-.1.1a4 4 0 0 0-.4 0l-.1.1a6 6 0 0 0-.3.1h-.2l-.4.2a5.7 5.7 0 0 0-.3.1l-1.7 1h-.1l-.2.2-.3.2-.2.1a3.5 3.5 0 0 0-.3.4v.9l.5-.4h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1a7.2 7.2 0 0 1 .4-.3 18.4 18.4 0 0 1 .8-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.4Zm1.5-8a13.1 13.1 0 0 1 .6-.3l.2-.2.1-.2.4-.4a7.4 7.4 0 0 0-.9.2h-.4l-.1.5a8.4 8.4 0 0 0-.4.5l.5-.2Zm-6.5 11.6a6.5 6.5 0 0 1 .2-.1l-.2.1Zm36.8-16.2V127.8v.1c0 .3-.2.5-.3.7l.3-.5Zm-.5.5a31.8 31.8 0 0 1-1.7 4.1l.1-.1a25.9 25.9 0 0 0 1.4-2.8l.3-1.5-.1.3Zm-2.8 5.2.1-.2a29 29 0 0 0 1-4.4 62.7 62.7 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a16.7 16.7 0 0 1-.4 1.2 25 25 0 0 1-.4.8v.3l-.1.1-.1.2a15 15 0 0 1-1.9 3l-1 1 2-.3.2-.3.3-.7.1-.5a81.4 81.4 0 0 0 .8-2.7v-.2a7.7 7.7 0 0 0 .7-.6l-.2.8.1-.2a4.7 4.7 0 0 0 .2-.5l.2-.4.2-.7.1-.4Zm-6.4 7.9-.4.2-.5.4-.3.1-.3.2-.3.1a19.1 19.1 0 0 1-.6.4h-.2v.1h-.1l-.3.2a14 14 0 0 1-1.3.6l-.5.2-.5.2a15.8 15.8 0 0 0 1.5-1.2l.2-.1a6.9 6.9 0 0 0 .7-.8l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a21.2 21.2 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5-1.1 2-1.1 2a67 67 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a18.7 18.7 0 0 1-.5.8h-.1l-.2.3-.9 1v.1l-.4.4-.1.1-.2.2-.8.7-.3.3-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a81.3 81.3 0 0 0 2.1-.8h.1a26.2 26.2 0 0 0 1.6-1.3 7.8 7.8 0 0 0 .9-.4l.6-.4-1 1.1.2-.1a31 31 0 0 0 1.2-.6l1.2-1.5Zm21.4-8.1.1-.4v-.2l.1-.3a35.2 35.2 0 0 0 .5-2.5 28.5 28.5 0 0 0-1 2.4c0 .2 0 .5-.2.7v.3l-.2.3v.1a3.4 3.4 0 0 1-.2.3c0 .1 0 .2-.2.3v.3a13 13 0 0 1-1 1.4 9.1 9.1 0 0 1-1.1 1l-.9.7a7.1 7.1 0 0 1-.2.2v-.2l.2-.3.3-.7.2-.3a27 27 0 0 0 1-2.6l.1-.3v-.2l.1-.2v-.1a11.5 11.5 0 0 0 .3-.7v-.3l.2-.5v-.5l.1-.2.2-.3.1-.2a12.1 12.1 0 0 0 .6-1.1l.1-.3.3-.7v-.3h.1v-.2l.1-.2v-.1a4.8 4.8 0 0 0 .2-.5v-.2a7.2 7.2 0 0 0 .1-.6l.2-1.2c.3-2.1.1-4.4-.4-6.5a30.8 30.8 0 0 0-3.6-9l-1.6-2.8.8 1.7a72.3 72.3 0 0 1 3.8 9.9v.3c.5 2.1.6 4.3.4 6.4v.3a9.8 9.8 0 0 1-.2 1v.3l-.1.3a7.3 7.3 0 0 1-.3 1v.2l-.5 1.1a25.8 25.8 0 0 0 .2-3.1v-.4a27 27 0 0 0-.1-2.7l-.1-.5-.1-.7-.1-.5a22 22 0 0 0-.5-2l-.1-.3a6.3 6.3 0 0 0-.3-.7 18.6 18.6 0 0 0-.3-.9l-.2-.4a13.1 13.1 0 0 0-1-1.9h-.1a13.5 13.5 0 0 0 .3.6l.1.2.1.2.1.3.2.4a19 19 0 0 1 1.6 7.7v1.1a16.2 16.2 0 0 1-.2 1.8v.4a22 22 0 0 1-.3 1.6v.6a20.4 20.4 0 0 1-.5 1.8l-.1.4-.1.2a19 19 0 0 1-.8 2.2v.1h-.1a27 27 0 0 1-.8 1.8l-.2.4a35.6 35.6 0 0 1-.1 0l.1-1.5.6-2.7.4-2v-.5l.1-.1v-.3l.1-.3a30.8 30.8 0 0 0 .2-1.3v-.5l.1-.5v-.3l.1-.4a23.6 23.6 0 0 0 0-1.1v-.4a6 6 0 0 0 0-.8 8.5 8.5 0 0 0 0-.6v-.3h-.1a12.2 12.2 0 0 0-1.5-4.4l-.1-.2a6.6 6.6 0 0 0-.4-.4 7.5 7.5 0 0 0-.9-1l-.2-.1-.1-.2a9.2 9.2 0 0 1 .3.3v.1l.3.3a5 5 0 0 1 .4.6 2.8 2.8 0 0 1 .2.1l.1.3.2.2.1.3 1 2.6c.3 1.7.3 3.6 0 5.4-.2 1.8-.6 3.6-1 5.4a35 35 0 0 0-.3 2.7l-.1.6a7.4 7.4 0 0 0 0 .8v.1a2 2 0 0 0 0 .3 5 5 0 0 0 0 .5V138a33.3 33.3 0 0 1-2.5 3.8l-.3.4v-.2l.2-.5.4-.9.3-.9.6-1.7V137.8l.2-.4v-.2l.1-.3v-.1a8.6 8.6 0 0 0 .1-.6 5.6 5.6 0 0 0 0-1.7l-.1-.2a21.2 21.2 0 0 0 0-.2v-.1h-.1v-.2l-.3-1.3a5 5 0 0 1 0-1.8V131l-.1.2v.2a4.7 4.7 0 0 0-.1 1v.2l.2 1.8V134.7a6.4 6.4 0 0 1 0 .3V136a3.4 3.4 0 0 1 0 .7 2.5 2.5 0 0 1-.2.4v.1l-.1.3v.1l-.2.4-.6 1.7-.5 1.4a31.3 31.3 0 0 0-.3.9l-.1.4v.2l-.2.4v.2l-.2.3v.2L293 145h-.1l-.4.5-.1.1-.9 1-.4.3-.2.2-.4.5-.4.4c-.2 0-.3.2-.4.3l-.4.4a31 31 0 0 1-2.8 2.2h-.2v.2h-.2a2.9 2.9 0 0 1-.3.2l-.2.1-.1.1h-.1l.4-.3.3-.3.2-.3.3-.2.6-.6.3-.3.3-.3.2-.2.7-.7.2-.2.7-.8.3-.3.4-.4.2-.3.7-.8v-.1l.1-.2.2-.3a11 11 0 0 0 .2-.4V144.3l.1-.2v-.1a7.4 7.4 0 0 0 .2-.6v-.1l.3-.8v-.3a27.7 27.7 0 0 1 .4-1.2v-.1a6.2 6.2 0 0 1 .4-.9v-.1l.1-.2v-.1h.1v-.1l.2-.2.1-.2a2.2 2.2 0 0 0-.2.3l-.2.1v.2a1.6 1.6 0 0 0-.1 0v.1l-.2.2-.2.3-.1.3a8.8 8.8 0 0 0-.5 1.3l-.3.8v.2l-.1.4-.2.4v.2a5.6 5.6 0 0 1-.4.7v.1l-.1.2-.1.1v.2h-.1v.1a5.4 5.4 0 0 1-.6.7l-.2.2-.2.3-.2.2-.2.1-.2.2-.9.9-.2.2-.3.4-.2.1-.2.3-1 1-.3.2a16.4 16.4 0 0 0-.7.8l-.3.2v.1l-.8.8-.3.4a20.6 20.6 0 0 1-4.3 1.3l-.5.1-.8.2h-.3v.1h-.2a15.4 15.4 0 0 1-1.1.2h-.2l-.4.1a40.4 40.4 0 0 1-6 .5h-1.1a30 30 0 0 1-1.6-.1h-.5a21.1 21.1 0 0 0-1-.2h-.3a10.7 10.7 0 0 1-.8-.2h-.5a33.2 33.2 0 0 1-1.6-.4l-.5-.1a12.1 12.1 0 0 1-1.3-.4l-.3-.1-.4-.1H262.1a49.3 49.3 0 0 0 4.8-.5h.5l1.1-.2.3-.1a28 28 0 0 0 7.5-2.8H279.4l.4-.1a12.5 12.5 0 0 0 2.5-.9 8.3 8.3 0 0 0 1.4-.8 2.5 2.5 0 0 0 .2-.2l.2-.2.2-.1a5.7 5.7 0 0 0 .4-.5l.2-.2.2-.2v-.1h.1v-.1l.2-.2.1-.2a2.5 2.5 0 0 0 .2-.3l.1-.2v-.1l.1-.2.2-.2v-.3l.1-.2v-.1a11.4 11.4 0 0 1-1.8 2c0 .2-.2.2-.3.3a5.8 5.8 0 0 1-.4.4 9.8 9.8 0 0 1-.6.4l-.2.1a9.2 9.2 0 0 1-1.4.7l-1.7.6h-.4l-.1.1a18.2 18.2 0 0 1-1.2.3h-.4l-.4.1h-.4l.8-.4.2-.2a5.6 5.6 0 0 0 .6-.4h.1l.3-.3a8.7 8.7 0 0 0 .7-.5 16.4 16.4 0 0 0 1.9-1.5l.3-.4h.1l.2-.2v-.1l.8-.7a37.4 37.4 0 0 0 1.5-1.4h.5l.8-.3a11 11 0 0 0 1.3-.4h.2l.3-.2.3-.1.3-.1a8.6 8.6 0 0 0 1.8-1.2l.3-.3a6.5 6.5 0 0 0 1-1.1 8 8 0 0 0 1.3-2.4l.1-.2v-.4l.1-.1v-.2a6 6 0 0 0 .1-.6v-.5a2.5 2.5 0 0 1 0 .2v.2a12.6 12.6 0 0 1-.3.6v.2l-.2.3a8.3 8.3 0 0 1-1 1.6l-.2.3a37.7 37.7 0 0 0-.6.7 11 11 0 0 1-2.4 2h-.1l-.1.1a16.9 16.9 0 0 1-1.9 1l-.9.4a30.4 30.4 0 0 1-.6.2 18.4 18.4 0 0 0 .4-.5l.2-.2.3-.4a70.5 70.5 0 0 0 .8-1h.1l.2-.3a36.4 36.4 0 0 0 .3-.4l.1-.2.1-.1.2-.4h.1v-.1l.2-.2v-.1a9.2 9.2 0 0 0 .4-.5c0-.2.2-.3.3-.5a33.9 33.9 0 0 0 1-1.5 21.8 21.8 0 0 0 1-.7l.2-.1.8-.6.2-.2.2-.2.1-.1.1-.1a13.1 13.1 0 0 0 .7-.7 94.4 94.4 0 0 1 .5-.6l.2-.2.5-.7.2-.2.6-.9a10.2 10.2 0 0 0 .3-.6l.2-.2a39.2 39.2 0 0 0 .4-.8v-.1l.2-.3v-.2l.3-.4v-.2a77.7 77.7 0 0 0 .5-1l.1-.2a6 6 0 0 0 .3-.6v-.3l.2-.3.1-.3v-.1l.1-.2a35.6 35.6 0 0 0 1.2-3.1v-.2a48.3 48.3 0 0 0-1 1.8v.1l-.3.5c0 .2-.2.3-.3.5v.2l-.1.1v.1l-.3.5v.1l-.4.6-.2.4a56.2 56.2 0 0 1-.3.7l-.2.3a8.8 8.8 0 0 1-.2.5l-.2.3a6 6 0 0 1-.1.3l-.2.3v.2c-.2.1-.3.3-.3.4l-.1.2-.1.2-.6.8a20.5 20.5 0 0 1-.5.8l-.1.2v.1l-.5.6-.1.1-.5.6-.2.3-.3.3-.1.2h-.1a24 24 0 0 1-1.8 1.8 5.8 5.8 0 0 0 0-.1v-.1l.4-.5.2-.5.2-.4a36.7 36.7 0 0 0 1.8-4.3v-.1a15.9 15.9 0 0 0 .4-1v-.3l.1-.2v-.1l.2-.4.1-.5.1-.4.1-.4.1-.4v-.1l.1-.4.2-.6V124.8l.1-.3v-.3l.1-.2a21.3 21.3 0 0 0 .2-1v-1.1l.1-.3v-1l.1-.1a7.8 7.8 0 0 0 0-1 43 43 0 0 0 0-1.3l.3-.4.1-.4.1-.2.1-.2v-.2h.1l.2-.6v-.2l.1-.3a3.4 3.4 0 0 0 .1-.4 6.8 6.8 0 0 0 .1-.5v-.2a4.2 4.2 0 0 0 .1-.3v-.3a7.7 7.7 0 0 0 .1-1v-4.5l.1-.3a10.2 10.2 0 0 1 .2-1.2v.3l-.1.1v.1l-.1.3-.1.4-.3 1.6c0 1 0 2.1-.2 3.2v.8l-.1.2v.4a8 8 0 0 1-.3 1l-.1.3-.1.3-.1.2-.2.4v-.4.6l-.2.2-.1.3-.1.2-.8 1.3c-1 1.4-2 2.7-3.2 4a48.1 48.1 0 0 0 0-1.4 35.6 35.6 0 0 0 0-2v-.5a31.1 31.1 0 0 1 0-1.2v-.2h.2l.2-.1.2-.1a7.8 7.8 0 0 0 .6-.5h.1a7.7 7.7 0 0 0 .3-.3l.2-.1v-.1l.2-.1v-.1h.1v-.1a7 7 0 0 0 .8-.7v-.2a7.5 7.5 0 0 0 .7-.9 5 5 0 0 0 .3-.7v-.1a10.3 10.3 0 0 0-.2.2l-.2.2h-.1l-.1.1a11.7 11.7 0 0 0-.5.5l-.3.2a27.6 27.6 0 0 0-1.1 1l-.2.3a27.4 27.4 0 0 0-.6.6l-.3.3-.2.2V116.3a30.3 30.3 0 0 1 .4-2.5l.1-.5a15.1 15.1 0 0 1 .1-.5v-.1l.1-.2a16.4 16.4 0 0 1 .5-2l.1-.4.1-.3.1-.2v-.3l.2-.2v-.3l.5-1.3.5-1.2.5-1.2.2-.4a55.3 55.3 0 0 0-.3.4l-.7 1.1-.5 1.2-.6 1.2v.1l-.2.3a9.3 9.3 0 0 0-1.5-5.1l-.2-.2-.8-1-.3-.2.3.4a24.7 24.7 0 0 1 .4 1l.1.2.1.3.2.3a15.2 15.2 0 0 1 1 4v.3l.1.3v.9l.1.2-.1.5-.2.6a44.6 44.6 0 0 0-.4 1.1v.4h-.1v.2l-.1.4-.2.6v.3l-.3 1.5v.4l-.1.4V117.1l-.1.2v.7l-.1.1v.8l-.1 1.3v.2a6.6 6.6 0 0 0 0 .5 24.6 24.6 0 0 0 0 1.3v.6l.1.5v.4a14.6 14.6 0 0 1-.6.5l-.3.2a14.4 14.4 0 0 1-1.5 1.2 6.3 6.3 0 0 1-.7.5h-.1l-.2.1-.3.2-.3.2h-.1l-.3.2a40.6 40.6 0 0 0 .5-2.8l.2-1.1v-.3l.1-.5.2-1.2.1-.7v-.3l.1-.3.2-1.1v-.3l.6-3v-.3l.1-.7v-.3l.2-1 .3-1.6v-.3l.1-.7v-.4.4l-.4 2-.1.2-.2.7v.5l-.1.2v.4a8.9 8.9 0 0 0-.2.6l-.5 2.4v.2l-.3 1v.2l-.1.4a16 16 0 0 0-.6-2.1 14.2 14.2 0 0 0-1.4-2.7l-.1-.1v.3a6.9 6.9 0 0 0 0 .5l.1.2.1.5v.1l.2.4a10.2 10.2 0 0 0 .2.7l.1.3a14.5 14.5 0 0 0 1.3 2.5l-.3 1.4v.2l-.1.4v.2l-.5 2-.3 1.3V125.6l-.2.8-.2.6a36.2 36.2 0 0 1-.3 1.4l-.1.2-.1.4a7.3 7.3 0 0 1-.2.5V129.7a29.6 29.6 0 0 1-3.6 7.4l-.2.2a15.3 15.3 0 0 1-1 1.3 15.2 15.2 0 0 1-1 1.2v.3c-.2 0-.3.2-.3.2l-.1-.2a5.4 5.4 0 0 1-.2-.6V139.2l-.1-.2v-.5l-.1-.5v-3.6c0-1.2 0-2.4.2-3.6V130.5a5.7 5.7 0 0 1 0-.7v-.1l.1-.4v-.2l.4-.2a12.3 12.3 0 0 0 .7-.4l.3-.1a19.5 19.5 0 0 0 1.9-1.2l.2-.3h.2l.6-.5a11.8 11.8 0 0 0 .4-.4l.3-.3.3-.2.4-.4a11.5 11.5 0 0 0 .9-1 6.5 6.5 0 0 0-.4.2l-.4.2-.3.2h-.1v.1a14 14 0 0 0-.6.3l-.2.1-.3.3a37.3 37.3 0 0 0-.7.5h-.2l-.2.2-.1.1-.3.2a44.4 44.4 0 0 0-2.7 2.2 32.4 32.4 0 0 1 .5-2.7v-.2c.5-.6 1-1.2 1.3-1.8l.2-.3v-.1l.2-.2v-.2l.2-.2.1-.2a27.5 27.5 0 0 0 .4-.8l.3-.5v-.1a27.6 27.6 0 0 0 .4-.8v-.1l.1-.2v-.2h.1l.1-.2v-.2a12 12 0 0 0 .5-1.1 27.2 27.2 0 0 0 .4-1v-.4l.2-.4v-.2a21.8 21.8 0 0 0 .2-.8l-.5 1.3a78 78 0 0 1-.8 2l-.2.4v.1h-.1l-.1.3v.1l-.2.3-.1.3v.1l-.3.5-.4.7-.4.8v.1a9 9 0 0 1-.3.5l-.3.5-.9 1.6.1-.3v-.1l.2-.4v-.4l.3-.8V123.1l.2-.4.1-.5a4.3 4.3 0 0 1 0-.3l.3-.5v-.5c.2-.2.2-.5.3-.7l.2-.6.2-.8.1-.3.1-.4v-.1l.1-.1v-.1l.1-.4.1-.2v-.2l.1-.1v-.1l.1-.1V116.4h.1v-.2l.2-.3.1-.2a10.3 10.3 0 0 1 .3-.7l.1-.1v-.1l.2-.3.1-.2.2-.2c0-.2.1-.2.2-.3l.2-.3a5 5 0 0 0-.3.3l-.1.1v.1l-.2.2a5.7 5.7 0 0 0-.3.3l-.1.3a5.8 5.8 0 0 0-.5.8l-.2.5-.2.4-.1.2-.1.2v.1l-.1.2-.2.3-.1.5-.3.6-.5 1.4-.1.4v.2l-.1.1-.5 1.4-.3 1v-.2l-.2-.9a10.7 10.7 0 0 0-.2-.8 13 13 0 0 0-.8-2.3l-.1-.2-.1-.2-.1-.2-.2-.2v-.1a10.2 10.2 0 0 0 0 .7 2.4 2.4 0 0 0 0 .3v.2l.1.1v.4a25 25 0 0 0 .8 3l.1.4.1.2c0 .3.2.5.3.7a47.4 47.4 0 0 0-.7 2.6v.1l-.1.3-.1.5a24.8 24.8 0 0 0-.3 1.7l-.1.7-.1.5V131.2a33.3 33.3 0 0 0-.2 3.3v2.2a17 17 0 0 0 0 1.8l.1.4.2.8.1.2a5.6 5.6 0 0 1 .2.4l.1.4a.4.4 0 0 0 0 .1l.2.1-.2.1-.4.5-.4.4a27 27 0 0 1-1 1h-.1c0 .2-.2.2-.2.3l-.4.3-.2.2-1 .8-.2.2h-.1l-.1.1-.2.1-.2.3-.4.2-.1.1a35.1 35.1 0 0 1-2 1.3l-.3.2-.3.1a30.2 30.2 0 0 1-2.8 1.5l-.2.1.1-.1.1-.1v-.1l-.1-.2a1.6 1.6 0 0 1-.2-.2v-.2l-.1-.1-.2-.6V146.1v.2l.4-.1h.2a13 13 0 0 0 1-.7h.1l1-.6a19.9 19.9 0 0 0 3.3-3l.3-.4.2-.2.1-.1v-.1l.2-.2a8.4 8.4 0 0 0 .3-.4l.2-.2v-.2a20 20 0 0 0 .5-.5l.2-.4a38.8 38.8 0 0 1-1.4 1.4l-.4.3-.2.2-.1.1-.2.2h-.1c0 .2-.2.2-.3.3a18.4 18.4 0 0 1-.6.5l-.3.3a15.9 15.9 0 0 1-1.4 1 27 27 0 0 1-.8.6 17.7 17.7 0 0 1-1.8 1l-.1.1-.3.1v-.4a6 6 0 0 1 0-.5v-.1l.2-1.2.3-1.9V140.7l.1-.3v-.1h.1v-.1l.3-.2.2-.4.1-.1.4-.5.4-.5a30.3 30.3 0 0 1 1.3-1.4l.2-.2.2-.2.2-.2.3-.2.1-.1.1-.1.1-.1.1-.1.5-.4.3-.2.2-.2.2-.2 1.4-1 .5-.2a8 8 0 0 0-2 .7 6 6 0 0 0-.4.2 18.8 18.8 0 0 0-.5.4l-.6.3-.5.4-.4.3-.1.1a10 10 0 0 0-1.5 1.7l-.2.3-.4.5-.3.6v.1l.1-1v-.2l.1-.5.2-.8v-.3l.1-.5.1-.5.1-.4.2-.5a32 32 0 0 1 .5-2l.1-.5v-.1l.2-.3v-.2a8.4 8.4 0 0 1 .3-.9l.2-.5v-.1l.3-.6v-.2l.1-.1v-.1a18.1 18.1 0 0 1 .4-.8 21.4 21.4 0 0 1 1-2l.1-.3.2-.3a18.2 18.2 0 0 1 .3-.5l.2-.4a5.7 5.7 0 0 1 .4-.6 17.1 17.1 0 0 1 .6-1l.3-.3.2-.2c0-.2.2-.3.3-.4v-.1l.4-.4.2-.2.1-.2.5-.5-.3.2-.3.3-.2.2-.3.3a22.4 22.4 0 0 0-.8.8l-.2.3-.5.6-.3.4a14.4 14.4 0 0 0-.3.3l-.1.3-.2.1a23.5 23.5 0 0 0-.7 1.1l-.1.3-.2.2-.1.3-.1.2-.1.1-.2.3-.2.4-.2.4-.2.5-.1.3a32.3 32.3 0 0 0-1.2 3l-.3-.1h-.3l-.3-.1h-.1a6 6 0 0 0-1 0H263a5.9 5.9 0 0 0-1 .3h-.3a16.2 16.2 0 0 0-1.7.6l.2-.2.1-.2.4-.5.4-.5.3-.3.8-1 1.6-1.8 1.3-1.5.3-.3-.5.3-.2.1-.2.2a13.7 13.7 0 0 0-2.9 2.5 12.7 12.7 0 0 1 .5-1l.1-.2a14 14 0 0 1 2-2.4l.2-.2a4.3 4.3 0 0 1 .3-.3h.1l.2-.2.1-.2h.2l.2-.2v-.1a10.5 10.5 0 0 1 .8-.6l.4-.2a13.4 13.4 0 0 1 1.1-.6l.5-.2.4-.2.3-.1h.2l.4-.2h-.6l-1.1.2-.7.2-.2.1-.6.3a9.9 9.9 0 0 0-3 2.2l-.2.2-.1.1a13.2 13.2 0 0 0-.5.7l-.2.2-.1.2-.1.1a1.5 1.5 0 0 0-.1.2l-.1.2a6.1 6.1 0 0 0-.5 1v.2l-.2.3v.2l-.1.2-.1.3-.2.6-.7 1.1-.3.4v.1l-.4.6v.2l-.2.2v.2l-.5.2-.4.3h-.1l-.6.4-.7.5h-.1v.1l-.7.6-.2.2-.2.2-.2.2-.2.2.1-.2v-.2l.5-1.4.1-.3v-.2l.1-.1.2-.5.1-.3.2-.5.1-.3.1-.2.1-.3v-.2l.4-.8.2-.2.1-.4.3-.7.4-.7.7-1.3.8-1.4v-.1l.3-.4v-.1l.5-.7.1-.2.3-.5.4-.6.6-.8H262.7l.1-.1h.2a6.3 6.3 0 0 0 .7-.3h.3l1-.4.3-.1.2-.2h.2l.4-.2.2-.1.3-.2.3-.2.2-.1.3-.2.2-.1a7.4 7.4 0 0 0 .3-.2l.1-.1.2-.1-.5.2-.8.3-.4.2h-.1l-.3.2h-.1l-.5.3-.7.2-.4.2-.3.1-1 .4h-.2l-.5.3h-.1l.1-.2.2-.3.3-.4.3-.4.2-.2 1-1.2v-.1l1-1c0-.2.2-.3.3-.4a94 94 0 0 0 2.4-1h.1a173.8 173.8 0 0 0 1.1-.4h1.5l.2-.1h.6l.3-.1h.1a11 11 0 0 0 .8-.2 7 7 0 0 0 .5 0l.3-.1.6-.1.4-.1h.1a25 25 0 0 0 1.1-.4h.2a6.8 6.8 0 0 0 .8-.3l.2-.1.2-.1a2.1 2.1 0 0 0 .2 0l.3-.2h.2l.1-.1.2-.1H277.8l-.2.1-2 .5a61.4 61.4 0 0 1-4.2.9h-.2l-.5.1a4.9 4.9 0 0 1-.4 0l-.5.1-.5.1.6-.3a66.5 66.5 0 0 0 1.5-.7l.4-.2.4-.1.2-.2.3-.1.3-.2.4-.2.6-.3.4-.1a42.2 42.2 0 0 1 5.3-2v-.1a6.6 6.6 0 0 1 1-.2 8.4 8.4 0 0 1 .7 0l.2-.1h.3a5.2 5.2 0 0 1 .8 0h.4a6.6 6.6 0 0 1 .6 0 8.2 8.2 0 0 0-.6 0l-.3-.2a8 8 0 0 0-.3 0h-.3l-1-.1a6 6 0 0 0-.6 0h-.7l-.2.1h-.2a11.7 11.7 0 0 0-.7.2h-.5l.5-.2a24.8 24.8 0 0 1 .6-.4l.4-.2.3-.2.2-.1h.1a36.3 36.3 0 0 1 2.6-1.4 7.5 7.5 0 0 1 .3-.1l.2-.1a59 59 0 0 1 1-.5l.2-.1h.2l.2-.2.4-.1h-.5a4.3 4.3 0 0 0-.5 0h-.2a8.8 8.8 0 0 0-1 .3l-.3.1-.3.1-.3.1h-.1l-.3.2h-.1a6.5 6.5 0 0 0-1 .4 10 10 0 0 0-1.2.8l-.3.1-.2.2-.3.2-.2.1a16 16 0 0 0-.9.8 10.5 10.5 0 0 0-.6.6l-.4.1-.5.2-.6.2-.2.1-.7.3-.2.1-.4.2h-.2l-2 1-.8.4-.8.4-.8.4-.8.4-2 1-.2.2.9-.9.9-.9.2-.1.2-.2.1-.1.3-.3.6-.5.8-.6.4-.3.5-.4.3-.2.5-.4.6-.4.1-.1.5-.4 1.3-.8-1.3.7-.7.4-.3.2-.4.3-.5.3-.8.5-1 .8-.2.1-.5.4-.2.1-.3.3-.3.2-.3.3v-.2h.1v-.2h.1v-.2h.1v-.2l.2-.4v-.2a7 7 0 0 0 .3-1.2 3.4 3.4 0 0 0 0-.5v-.4a3 3 0 0 0 0-.4v.3a1 1 0 0 1 0 .2l-.1.1-.2 1-.1.1v.2l-.1.2v.2l-.3.7-.1.2-.1.3-.1.1v.1l-.2.4-.2.2v.2l-.2.1-.6.6-.5.5-.2.1-.4.4-.6.6-.4.4-.7.7-1 1.2-.5.6-.5.6-1 1.3v.2l-.2.1-.7 1-.4.6-.2.4-.1.1v.1l-.1.1-.2.2-.1.3v-.4a26.4 26.4 0 0 1 1-2.1l.2-.3.2-.3c0-.2 0-.3.2-.5l.4-.9.3-.6.1-.3.1-.2a19.3 19.3 0 0 0 .5-.9l.2-.5a23.5 23.5 0 0 0 1-2.8v-.2l.1-.2v-.2l.1-.2v.2h-.1v.2h-.1v.1l-.1.1-.1.3-.1.2-.2.2-1 2-.6 1-.3.5c0 .2-.2.4-.3.5v.3h-.1l-.1.3h-.1l-.1.3v.1l-.3.4v.2a35.5 35.5 0 0 0-1.1 2.6l-.1.3-.1.2v.2l-.1.2v.2a3.8 3.8 0 0 0-.2.5V126.3l-.1.3v.2l-.1.2v.2l-.1.1-.2.5a44.6 44.6 0 0 0-1.2 2.4l-.3.4v.3l-.1.2-.3.5v.1l-.3.7a41.8 41.8 0 0 0-.5 1.3v.2l-.1.3-.1.2v.3h-.1v.1l-.1.3v.2h-.1a17.5 17.5 0 0 0-.3 1.1v.2l-.2.3v.3l-.1.4-.1.4-.1.5-.1.4-.1.3a31.6 31.6 0 0 0-.4 3.3l-.3-1.2-.2-1.6v-.8l-.1-.8v-1.8l-.1-.2v-2.5l.1-.4v-.6l.2-.2h.1v-.1l.2-.2.2-.1a13.2 13.2 0 0 0 .6-.7l.3-.3v-.1l.3-.3a21 21 0 0 0 .3-.4l.1-.1.3-.5.1-.1a5.1 5.1 0 0 0 .3-.4l.2-.5.2-.2v-.1l.2-.3.2-.5.1-.3.1-.2-.4.5c0 .2-.2.4-.3.5l-.3.5-.5.7-.2.2-.1.2-.1.1a13 13 0 0 1-.4.6h-.1l-.6.9-.2.2-.2.3-.2.2-.3.5V131l.1-.2.1-.8v-.3l.1-.4V129l.1-.2v-.4l.4-1.5.2-.7.1-.5v-.2l1.1-.7.2-.1.3-.2.2-.2.1-.1.1-.1.3-.2.2-.3a16.9 16.9 0 0 0 2.4-2.8l-.2.1-.2.2-.1.1-.8.9a101.1 101.1 0 0 1-1 .8c0 .2-.2.3-.4.4l-1.3 1.3-.8.7.2-.7.3-.8c0-.4.2-.7.3-1v-.2l.2-.3v-.2l.6-1.4v-.2h.1v-.1l.1-.2.1-.2.1-.2v-.1l.3-.4.1-.3.2-.5a7 7 0 0 0 .3-.5l.3-.2.3-.2h.1l.2-.2.4-.3.3-.1.2-.2a43.2 43.2 0 0 0 1.8-1.2l.3-.2a38 38 0 0 0 1.7-1.3l.5-.4.7-.6 2.3-1.7 1-.7.6-.4.6-.4a50 50 0 0 1 1-.6l.5-.4h1.3a6.8 6.8 0 0 0 .6 0h1l.4-.1a20 20 0 0 0 1.3-.2h.5l.8-.3h.4l.2-.1h.1l.7-.2.4-.1.3-.1.5-.2h.1l.2-.1.2-.1-.8.1-1 .2-.7.2h-.5l-.4.1h-.2l-1.4.3h-.6v.1H271.8l-.7.2h-.7l-.6.1h-.3l1.2-.7h.1l.2-.1.3-.1.2-.2h.3v-.1l.6-.2a22 22 0 0 1 1.4-.6l.4-.1a14.5 14.5 0 0 1 1-.4h.2l1.1-.3h.5v-.1h.4a8.3 8.3 0 0 1 .6-.1h.3a14.6 14.6 0 0 1 1.3-.2h1a7.6 7.6 0 0 1 .5 0h.1l.2.1h.4l.3.1h.3a8.5 8.5 0 0 0 .6.2l-.2-.1a8 8 0 0 0-.3-.1 3.2 3.2 0 0 0-.5-.1 8.7 8.7 0 0 0-.7-.2h-.2l-.4-.1h-.5a10 10 0 0 0-1.9-.1h-1.3a15.3 15.3 0 0 0-1.6.3h-.1l-.1.1-1 .2-.2.1.3-.3.7-.6.7-.6a12.2 12.2 0 0 1 .8-.7 9.6 9.6 0 0 1 2.1-.5 7.7 7.7 0 0 1 1-.1h.2a11 11 0 0 1 3.3.5h.3a6.9 6.9 0 0 1 .5.3l.8.4-.2-.2a6.2 6.2 0 0 0-2-1 7.8 7.8 0 0 0-5.3 0l.4-.1.2-.2a26.3 26.3 0 0 1 .5-.3l.5-.3a18.1 18.1 0 0 1 .4-.2 9.9 9.9 0 0 1 7.2-.6 7.7 7.7 0 0 1 1.7.7l.2.1-.4-.3-.2-.1a2.9 2.9 0 0 0-.3-.3h-.1a11 11 0 0 0-1.1-.5 7.8 7.8 0 0 0-3.4-.4 7.7 7.7 0 0 0-1 .2l.4-.2 1-.3.9-.2h.2l.7-.2 1-.2h-1l-1 .2-1 .2-.8.2h-.2l.2-.2.3-.2a7.4 7.4 0 0 0 1.6-2.7 24.3 24.3 0 0 1-1.9 2.4l-1 1a20.2 20.2 0 0 0-4 1.8v-.2l.1-.2.1-.2a4.2 4.2 0 0 0 .2-.8 2.5 2.5 0 0 0 0-.3l.1-.1V100.3a7.4 7.4 0 0 0-.3-3v-.1V98a13.1 13.1 0 0 1-.4 4.3v.2h-.1l-.4.2-1.3 1-.8.6-.7.6-.6.8-.4.3v.1l-.1.1-.2.2a16 16 0 0 0-.6.2h-.2l-2.6 1.4-.2.1-.3.2-.4.2-.4.3-.5.3-.5.4a52.2 52.2 0 0 0-2.5 1.8l-.1.1a80 80 0 0 0-1.5 1.2l-.6.5-1.5 1.3-1.5 1.2-.3.3-.7.6-.4.3h-.1l-1 1h-.2l.1-.2.4-.7.4-.6v-.2l.2-.1.6-1 .5-.7.2-.4.2-.3.6-.8.2-.2.2-.3a9.4 9.4 0 0 1 .5-.6l.1-.2.2-.2.2-.2 1.1-1.2a6.4 6.4 0 0 0 2-.7h.3a3.7 3.7 0 0 0 .6-.4 6.7 6.7 0 0 0 1.1-.9l.2-.2a7.6 7.6 0 0 0 .3-.4l.2-.2v-.1a19.9 19.9 0 0 1-4.2 2.5l-.2.1a23.1 23.1 0 0 1 2.4-2.2h.1a21.8 21.8 0 0 1 1.8-1.3l.2-.1.1-.1a23 23 0 0 1 1.2-.7h.2l.3-.2a9.4 9.4 0 0 1 1.4-.6 16.7 16.7 0 0 1 .9-.4l-1.1.4h-.3l-.3.2-.4.1h-.1l-.1.1-.4.2a6.2 6.2 0 0 0-.4.2h-.2l-.3.2-.3.2-.3.2h-.1l-.2.1a17.2 17.2 0 0 0-2.6 1.8l-.2.2-.4.3-.4.4-.4.3-.4.4-.3.3a17.5 17.5 0 0 0-1.7 1.8l-.2.2a4.6 4.6 0 0 0-.2.3l-.1.1-.1.1-.6.8-.2.2-.1.2-.3.3-.2.4-.2.3-.2.3-.3.4-.2.3-.4.7-.8 1.4a1.9 1.9 0 0 0-.2.3l-.2.5-.2.4-.2.3-.3.7v.1l-.1.1-.2.6-.7 1.5-.1.4-.2.6-.1.4v.2l-.1.1-.1.4-.1.3a11.3 11.3 0 0 0-.3 1 32.4 32.4 0 0 0-.3 1.4l-.1.3v.2l-.1.2v.2l-.1.3v.5a35.2 35.2 0 0 0-.4 2.2v.8l-.1.4v.9a27 27 0 0 0-.1 1.2v2.5l.1 1.6v.5l.1.3v.2-.2l-.1-.3v-.2l-.2-.5-.7-2.1-.3-.9-.1-.2-.1-.4v-.2a12.4 12.4 0 0 1-.4-1v-.3l-.1-.3v-.5h-.1v-.3a11 11 0 0 1-.2-2.1v-.2a5.4 5.4 0 0 1 0-.5 4 4 0 0 1 .1-.2v-.5l.1-.2v-.2l.1-.1a6 6 0 0 1 .4-1.2v-.1l.2-.2v-.1a3.2 3.2 0 0 1 .3-.4v-.1l-.1.1-.1.1-.1.1a3.4 3.4 0 0 0-.2.3l-.1.1-.1.2a6.6 6.6 0 0 0-.3.5l-.1.2a6.6 6.6 0 0 0-.2.4l-.1.3a12.6 12.6 0 0 0 0 .2l-.2.4a6.5 6.5 0 0 0-.1.5v.5a8.3 8.3 0 0 0-.1 1.4v.2a13.8 13.8 0 0 0 .2 1.6 8.3 8.3 0 0 0 0 .5l.1.3a13.2 13.2 0 0 0 .9 2.6l.7 1.9.1.2.5 1v.4a21 21 0 0 1 .9 2.4l.2 1 .1.5a19.6 19.6 0 0 0 0 1l.1.1V145a14.4 14.4 0 0 0 .1 1v.2l.1.5.1.3a21.3 21.3 0 0 0 .3 1.2v.2l.1.4.3.9.1.2v.1a9.1 9.1 0 0 0 .5 1.2l-.2-.2-.3-.3-.2-.1a14.1 14.1 0 0 1-.2-.3l-.3-.2-.4-.4a10.4 10.4 0 0 1-.5-.5 26.2 26.2 0 0 1-3.4-4.5 6.4 6.4 0 0 0 .3-1V141.5a9.3 9.3 0 0 0 0-1.3 9 9 0 0 0-.6-2l-.1-.2v-.2l-.2-.2v.5a13.9 13.9 0 0 0 0 1.3 55.4 55.4 0 0 0 .1 1.8v.4l.1.7.1.7v.5a23.5 23.5 0 0 0 .2.9l-.1-.2a58.5 58.5 0 0 1-1-1.6l-.3-.6-.3-.5-.3-.6-.6-1a108.7 108.7 0 0 1-2.3-4.4l-.1-.2V135l.2-.6v-.1l.3-.7V133.3l.1-.1V132.9l.1-.1.2-.5a9.8 9.8 0 0 0 .7-.6v-.1h.1a12.5 12.5 0 0 0 1.2-1.3l.2-.2v-.1l.2-.1.2-.3.1-.2h.1v-.1l.1-.1.1-.2.2-.2.2-.3a11.5 11.5 0 0 0 .6-1V127.2l-.2.4-.3.3a91.4 91.4 0 0 1-.7.9l-.3.3a18.6 18.6 0 0 1-.3.4 24.2 24.2 0 0 1-1.3 1.5l-.2.2-.1.1-.5.6.4-1.5.1-.3v-.2l.1-.2a161.9 161.9 0 0 0 .6-2.2v-.1l.2-.4v-.2l.1-.3v-.2l.1-.2.2-.2v-.2h.1a86.4 86.4 0 0 1 .7-1.2 124.8 124.8 0 0 1 1-1.5l.5-.6.2-.3.2-.3a33.9 33.9 0 0 1 2.4-3v-.1h.1l.5-.7.2-.2.2-.3a66.3 66.3 0 0 1 3.6-3.7v-.1l.3-.2.3-.4.2-.2a12.7 12.7 0 0 0 .5-.7 8.7 8.7 0 0 0 .7-1l.1-.2.1-.1.1-.2a8.3 8.3 0 0 1-.4.4 16.2 16.2 0 0 1-1.8 2l-.2.1-.1.1-.3.2-.2.2-.8.7-1 1h-.1a18.2 18.2 0 0 0-.8.9l-.2.1-.5.6-.2.2.2-.2v-.2a30.3 30.3 0 0 1 1.9-2.7l.3-.4.4-.5.2-.3.2-.2.2-.2.1-.2.4-.4.3-.4a63.3 63.3 0 0 1 1.3-1.3 9.1 9.1 0 0 0-2.3 1.6h-.1a9.8 9.8 0 0 0-1 1v.2c-.2 0-.2.1-.3.2l-.1.1-.2.2-.3.4-.1.2a20.4 20.4 0 0 0-1 1.6l-.1.2a2.1 2.1 0 0 0-.2.3v.1a13.4 13.4 0 0 0-.7 1.7v.2l-.1.2-.5.6-.3.3-.2.4a38.6 38.6 0 0 0-1 1.3l-.3.4-.2.4-.3.4a18.7 18.7 0 0 0-.7 1.2l-.1.2v.1a60.4 60.4 0 0 0-.5 1v-.1l1.4-5.4v-.2l.1-.2.3-1v-.1l.2-.8v-.2l.2-.5.3-1v-.2a39.1 39.1 0 0 1 .3-1l.1-.2v-.2l.1-.2.1-.3.1-.2a24.5 24.5 0 0 1 .6-1.6l.1-.2.2-.3a8.6 8.6 0 0 1 .2-.6l.2-.2a4.1 4.1 0 0 1 .2-.5 8.2 8.2 0 0 1 .3-.4l.1-.2.2-.2a10.4 10.4 0 0 1 1-1.2h.8a6 6 0 0 0 .5 0h.2a9.8 9.8 0 0 0 .8-.2H256.2l.3-.1h.3l.4-.2h.3l.3-.2a14 14 0 0 0 2.4-1l.2-.1.7-.4.4-.3a15.1 15.1 0 0 0 .5-.4h.1l.3-.2.2-.2v-.1l.2-.1.1-.2.2-.1.3-.4a14.5 14.5 0 0 0-.8.5 14.6 14.6 0 0 1-.7.4h-.2a16.3 16.3 0 0 1-.9.5 30.4 30.4 0 0 1-3.8 1.6h-.2l-.5.2H256l-.5.2h-.2l-.1.1-.5.1-.6.2-.5.1h-.2a4.8 4.8 0 0 1 .4-.4h.1c0-.2.2-.3.2-.3a12 12 0 0 1 .7-.7l.3-.2.2-.2.2-.1.3-.3h.1l.2-.2.5-.4a31.8 31.8 0 0 1 7.2-3.7h.1a53.4 53.4 0 0 1-1 .2l-.7.3a46.6 46.6 0 0 0-6.4 3.4l-.3.2-.8.6-.3.2-.2.3-.3.2-.2.2-.2.2-.2.2-.1.1.2-.3v-.2a6.2 6.2 0 0 0 .1-.1 24.8 24.8 0 0 1 1.8-2.5c1.4-1.6 3-2.8 4.9-3.8a30 30 0 0 1 8.8-3.2l.7-.2 2.3-.6a88.7 88.7 0 0 0-7.3 1.5l-.3.1-2 .7-.3.1-.3.2 1.2-.8.5-.3.2-.1.3-.1.2-.1.5-.3h.2a22.9 22.9 0 0 1 4-1.6l2-.5.6-.1.4-.1a45.7 45.7 0 0 1 2.3-.6 8.1 8.1 0 0 0-.7 0h-1.1a18.8 18.8 0 0 0-7.8 2.1l-.3.2a32.5 32.5 0 0 0-2.8 1.9l-.3.2a15.2 15.2 0 0 0-.8.8 17.4 17.4 0 0 0-4.4 3l-.6.6-.4.4-.1.2a14.4 14.4 0 0 0-1.8 2.6l-.2.3v.2l-.2.2-.1.3a2.3 2.3 0 0 0-.1.3l-.1.2-.2.2v.2a2.8 2.8 0 0 0-.1.3l-.2.3a12 12 0 0 0-.5.7l-.1.2-.2.3a8.2 8.2 0 0 0-.6 1v.2a11.3 11.3 0 0 0-.4.9l-.1.2-.3.6v.3l-.1.1V112.3l.1-.2a26.8 26.8 0 0 1 .2-1.1v-.2l.1-.2v-.2h.1V110a20.3 20.3 0 0 1 .4-1.1 15.5 15.5 0 0 1 .1-.6l.2-.5a30.9 30.9 0 0 1 1-2.7l.1-.3a40.8 40.8 0 0 1 .8-1.5v-.3c0 .2-.1.2-.2.3l-.2.3a8 8 0 0 0-.9 1.2 13.6 13.6 0 0 0-1.5 3V108.3l-.1.3a11.8 11.8 0 0 0-.2.6v.4l-.1.1a10.7 10.7 0 0 0-.1.9 7 7 0 0 0-.1 1V111.8a9.4 9.4 0 0 0 0 1V114l-.2.4v.1l-.1.3v.3h-.1l-.1.4-.2.6-.5 1.7v.2l-.2.5-.1.4-1.2 4v.2l-.4 1.3-.1.3-.1.2-.5 2-.5 1.5-.2.7v.2a23.8 23.8 0 0 1-.4-1.8v-.2l-.1-.5v-.1a8 8 0 0 1-.2-.9v-.9a4.6 4.6 0 0 0-.1-.1v-.8l-.1-.4v-1.3a14.9 14.9 0 0 1 0-.4l.1-.2.5-.6v-.2a4.4 4.4 0 0 0 .4-.5l.2-.3v-.1a17.5 17.5 0 0 0 .9-1.6l.1-.4.2-.4v-.2l.2-.4v-.3l.1-.3.1-.2v-.3l.1-.2-.1.3a25.5 25.5 0 0 0-.4.8l-.3.5a128.5 128.5 0 0 1-.7 1.6l-.3.5a80.5 80.5 0 0 0-.6 1.2l-.1.2-.4.9a19.2 19.2 0 0 1 .7-5v-.2a15 15 0 0 1 1-2.2 18.1 18.1 0 0 1 3-4.6l.2-.3-.1.2-.2.1-.2.2-.1.2a16.4 16.4 0 0 0-3 4l-1.2 3v.2l-.2.3v.4l-.1.2v.2a17.6 17.6 0 0 0-.5 2.9v.3a8.6 8.6 0 0 0 0 1v-.3a12.5 12.5 0 0 1-.2-1.1V119.7a12.4 12.4 0 0 1 .2-2.8v-.5l.1-.2v-.3h.1V115.7h.1c0-.3.2-.5.3-.8v-.2l.1-.3.2-.2a15.1 15.1 0 0 1 .4-1l.2-.2v-.2l.1-.1.1-.2.2-.2.1-.2.2-.3.2-.3.3-.3a10.8 10.8 0 0 0-1 1c0 .1 0 .2-.2.3a21 21 0 0 0-.3.5l-.1.2-.3.4a13.2 13.2 0 0 0-1.4 3.6v.3a13.4 13.4 0 0 0-.2 4.8v.2l.2.7v.2a16.7 16.7 0 0 0 .6 2.1v.3l.1.2v.1l.1.2.1.2a27.3 27.3 0 0 0 .3 1.3v.5l.1.2v.3l.2.4v.4l.1.2.2.4v.1l-.2.8v.3l-.2.4v.2l-.2.5v.2l-.1.4-.3 1v.1l-.3-.6-.2-.5v-.1l-.2-.5-.2-.5v-.1a30.9 30.9 0 0 1-1.5-7.8 28.7 28.7 0 0 1 .4-6.7l.1-.3v-.3l.1-.3a7 7 0 0 1 .2-.9l.1-.3.1-.3v-.2l.1-.2.1-.2.1-.4.2-.4a27.5 27.5 0 0 1 2.1-4.7 31.2 31.2 0 0 1 1.3-2l.1-.2a14.3 14.3 0 0 1 .8-1l1-1.2.1-.3.4-.4.3-.3a4.2 4.2 0 0 1 .3-.3l2-1.9.3-.3.3-.2a10.2 10.2 0 0 1 .7-.6l.4-.2.2-.2.4-.3a27.4 27.4 0 0 1 1.4-1 23 23 0 0 0-2.4 1.3 16.9 16.9 0 0 0-1.6 1.2l-.2.2a27.1 27.1 0 0 0-1.6 1.3l-.3.2-.3.3-.3.3a73.1 73.1 0 0 0-1.5 1.6l-.4.4v.2l.2-.6.2-.3a23.2 23.2 0 0 1 1-1.3c1.2-1.7 2.8-3.1 4.6-4.3a34.6 34.6 0 0 1 8.6-4.2l1-.4 2-.8-.8.3-.5.1-1.7.5-3.1 1.1c-2 .8-4 1.7-5.8 2.9a19.4 19.4 0 0 0-6.6 7.2l-.6 1.5v.1l-.7 1-1 1.9-.5.9-.4 1a29.4 29.4 0 0 0-1 2.7l-.2.3v.2a23.2 23.2 0 0 0-1 4.7 31.4 31.4 0 0 0 .2 7.8l.1.5v.1a23.4 23.4 0 0 0 .7 2.8l-.2-.3a8.4 8.4 0 0 1-1.1-2.9l-.4-1.3-.2-.7-.2-.7c-.4-1.8-.7-3.7-.5-5.5.1-1.9.6-3.7 1-5.5l-.6 1.6-.1.4a13.7 13.7 0 0 0-.5 1.5V118.4l-.1.2a15.8 15.8 0 0 0-.3 4l.5 2.9.8 2.7.1.2a23.7 23.7 0 0 0 1 2.4l1.2 1.5c.9 2.7 2.2 5.1 3.6 7.4l2 3.5a45.8 45.8 0 0 0 5 6.6l1.6 1.4.8.6.2.2h.2a.7.7 0 0 0 .2.1h.2V152.4a2 2 0 0 1-.2.2v.1a3.9 3.9 0 0 1-.5.7 2 2 0 0 1-.1.2 2.6 2.6 0 0 1-.4.3v.1a1.4 1.4 0 0 1-.2.2 3.6 3.6 0 0 1-.4.2l.1.1.1.1a1.3 1.3 0 0 0 .3.1h.1a2.3 2.3 0 0 0 .6.3 3.5 3.5 0 0 0 1.2 0h.1a2 2 0 0 0 .2-.1 1.8 1.8 0 0 0 .3-.2h.2a1.3 1.3 0 0 0 .3-.5 1.2 1.2 0 0 0 0-.2l.1-.2v-.2h.1v-.6h.2l.2.1.2.2.3.2.7.4.4.2.5.3.6.2.6.2 1.1.4.6.2 1.2.3.5.2h.3l.3.1.7.1.6.1 1.2.2 1.2.1h1.2l1.3.1h2.4l.6-.1H274.2l1.2-.2h.3l1-.2 1.1-.2a38.7 38.7 0 0 0 7.1-2.2l.4-.1a18.5 18.5 0 0 0 2.2-.7 9 9 0 0 0 .8-.3h.2a20.5 20.5 0 0 0 5.7-3.8 21 21 0 0 0 4.5-6.2l.5-.8.4-.7.4-.8.4-.7c0-.2.2-.3.3-.5l.3-.6a76.7 76.7 0 0 0-.1 0l-.4.5a66.7 66.7 0 0 0-.8 1.2l-.4.7-.6 1-.8 1.2a27 27 0 0 0-.9 1.4 24.9 24.9 0 0 1-4 4.6l-.2.1a21.3 21.3 0 0 1-1.6 1.2l-.5.4-.2.1-.7.4-.4.2-.7.4-.4.2a13 13 0 0 1-1.4.6l-.3.1-.4.2.4-.2.4-.3.4-.3a22.7 22.7 0 0 0 1-.7l.4-.4 1.9-1.6v-.1a55.1 55.1 0 0 0 1-1l.5-.4.5-.6.4-.4.5-.6.4-.5a43.5 43.5 0 0 0 4.2-5.8l.3-.5.1-.2.2-.3v-.1l.3-.4.2-.1.8-.4a6.6 6.6 0 0 0 .6-.4 8 8 0 0 0 2.9-4v-.2Zm-19-6a10 10 0 0 0 .6-.3l.3-.2h.1l.3-.2.2-.2a16.5 16.5 0 0 0 1.5-1l.2-.1a13 13 0 0 0 .8-.7l.1-.1.1-.1h.1l.2-.3s.2 0 .2-.2a11.8 11.8 0 0 0 .6-.5l.8-.9.3-.3.1-.2.2-.2.2-.2v-.1h.1a24 24 0 0 0 .7-.9l.2-.3.3-.5.2-.2a22.5 22.5 0 0 0 .8-1.4 31.8 31.8 0 0 1-.1 1.4v.3a4.9 4.9 0 0 1-.1.5 24.6 24.6 0 0 1-.4 2.4l-.1.4V123.8l-.1.2a15.8 15.8 0 0 1-.3 1.2l-.2.6v.5l-.1.1-.1.3v.2l-.2.3v.4l-.2.2v.2l-.3.6-.1.5-.2.5-.2.5v-.2a22.8 22.8 0 0 0 .3-1.3 32.6 32.6 0 0 1-1.7 4.1v.1l-.2.4v.2a14.8 14.8 0 0 1-.9 1.5l-.2.3a22.4 22.4 0 0 1-.6 1h-.1v-.1l.1-.1.1-.2.1-.3v-.2h.1a9.8 9.8 0 0 0 .2-.5 18.9 18.9 0 0 0 .3-1l.1-.2a34.3 34.3 0 0 0 1-4.4 62.6 62.6 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7a45.5 45.5 0 0 0-.4 1.5l-.6 2.2-.6 2.1v.2l-.1.3a19.3 19.3 0 0 1-.4 1.2 26.7 26.7 0 0 1-.4.8v.3l-.1.1-.1.2a15 15 0 0 1-1.9 3l-1 1a16.9 16.9 0 0 1-1.6 1.1 16.4 16.4 0 0 1-1 .7l-.3.1-.3.2-.3.1a19.1 19.1 0 0 1-.7.4 1.5 1.5 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a15.9 15.9 0 0 0 1.4-1.1h.1v-.1l.2-.1a6.9 6.9 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a21.7 21.7 0 0 0 2.1-3.5 54.3 54.3 0 0 0 1.4-2.9l.3-.7v-.1l.4-.8.4-.9a21.7 21.7 0 0 0 .3-.8l-.2.3v.1a20.6 20.6 0 0 0-.5.6l-.2.4-.3.5a75 75 0 0 0-1.1 2l-1.1 2a67 67 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a15.7 15.7 0 0 1-.5.8h-.1c0 .2-.1.2-.2.3l-.9 1v.1a19 19 0 0 1-.5.5l-.2.2-.7.7-.4.3-.2.2-.4.4h-.1l-.4.2-.4.1-1.8.8-.4.1-.3.1h-.2l-.2.1-.4.1a24.1 24.1 0 0 0 .9-.6l.2-.2.2-.1.1-.2.8-.6.6-.6a24.7 24.7 0 0 0 .8-.7l.5-.5.5-.5.2-.2v-.2c.1 0 .2 0 .3-.2a37 37 0 0 0 3.9-5.4l.1-.2.2-.4.1-.2.2-.3.1-.3a27 27 0 0 0 .5-.9l.1-.4.2-.3v-.1a11 11 0 0 0 .5-1.3l.4-.9V130.8l.1-.1v-.1l.1-.3a17.5 17.5 0 0 0 .4-1.4v-.2l.1-.3.1-.4v-.2h.1l.7-.2ZM257.2 151h-.4l-.1.1h-.7a11.7 11.7 0 0 1-.2-.4l-.2-.4v-.2l-.2-.2a15.2 15.2 0 0 1-1.2-4.6v-.1a27 27 0 0 1 .6-.6 4 4 0 0 1 .3-.3l.2-.2.5-.3v-.1h.1a45 45 0 0 1 .5-.4v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1l.3-.3h.2a15.6 15.6 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2a4.9 4.9 0 0 0-.4 0h-.2l-.1.1a4 4 0 0 0-.4 0l-.1.1-.3.1h-.2l-.4.2a4 4 0 0 0-.3.1l-1.7 1h-.1l-.2.2-.3.2-.2.2a3.5 3.5 0 0 0-.3.3 6.6 6.6 0 0 0-.6.5 7.3 7.3 0 0 0-.6.8 19.3 19.3 0 0 1 0-2.3V140.9l.1-.2v-.5h.1V139.8l.1-.3.2-1 .2-.8v-.3l.1-.3.1-.3a7 7 0 0 0 .1-.4v-.1l.1-.2.7-.5.3-.2.1-.1.1-.1.3-.2.6-.4.4-.3a21.3 21.3 0 0 1 3-1.4l.2-.1h.2v-.1l.5-.2h.2l.4-.1h.1v-.1l.4-.1h.2l.4-.1a16.2 16.2 0 0 1 3.2-.5v.1l-.2.4v.4l-.2.2v.3l-.2.4v.4l-.1.1-.1.5-.2.6v.3a14.3 14.3 0 0 0-.4 1.5v.4a52.5 52.5 0 0 0-.3 1.7v.1a35 35 0 0 0-.2 1 59.7 59.7 0 0 0-.4 3l-.2 1.9.1 2a3.6 3.6 0 0 0 .4 1v.1h.1a2.5 2.5 0 0 0 .3.5l.2.1-.2.1h-.1l-.3.2a31.2 31.2 0 0 1-7.3 2Zm1.3 1.4h-.2l-.3-.1h.5l.4-.2h.4a27.1 27.1 0 0 0 1.8-.5 37.3 37.3 0 0 0 3-1h.2l.6-.3 1.8-.9.5-.2.5-.2.4-.3.5-.2.2-.2.2-.1a14.6 14.6 0 0 0 1.8-1.2l.2-.1.2-.2h.1a4.5 4.5 0 0 0 .6 0h.1a9.7 9.7 0 0 0 1.2-.4l1-.3.8-.2.4-.2a78.8 78.8 0 0 0 2.1-.8h.4l.1-.1.2-.1a18 18 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3a18.4 18.4 0 0 0 1.6-1.1l.3-.2.2-.2.2-.1-.3.2-.2.3-.3.3a7 7 0 0 1-.3.3 27.3 27.3 0 0 1-1.2 1.2l-.3.3a31.7 31.7 0 0 1-6 4.5l-.1.1-.4.2a14.5 14.5 0 0 1-.5.3l-.4.2h-.1l-.3.2h-.2a6 6 0 0 1-.7.4l-.4.1h-.1l-.2.2-.4.1-.3.1h-.2v.1l-.9.3-.9.3h-.5l-.4.2-.4.1h-.4a35 35 0 0 1-1.5.4h-.5l-.4.1-.8.2a30.5 30.5 0 0 1-2.7.3h-.8l-1 .2h-1l-.1.1h-.4l-.4.1Zm23.8-10.8-.5.3-.5.4-.3.1-.3.2-.3.1a19.2 19.2 0 0 1-.7.4 1.4 1.4 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a15.5 15.5 0 0 0 1.5-1.2l.2-.1a6.2 6.2 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a22 22 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1a96.7 96.7 0 0 0 .8-1.7l.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5-1.1 2-1.1 2a67 67 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a12.8 12.8 0 0 1-.5.8h-.1l-.2.3-.9 1v.1l-.4.4-.1.1a17.8 17.8 0 0 1-1 1l-.3.2-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a78.8 78.8 0 0 0 2.1-.8h.1a21.4 21.4 0 0 0 1.3-1.1l.3-.2a7.8 7.8 0 0 0 .9-.4l.6-.4-1 1.1.2-.1a28.7 28.7 0 0 0 1.2-.6l1.2-1.5Zm6.2-7.4.1-.4.1-.2.2-.8.1-.3a22.5 22.5 0 0 0 .7-3.3 63.3 63.3 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a21 21 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1l-.1.2a15 15 0 0 1-1.9 3l-1 1 2-.3.2-.3a49.8 49.8 0 0 0 1.2-3.9v-.2l.3-.1.4-.5-.2.8.1-.2.1-.3v-.2a25.8 25.8 0 0 0 .3-.4l.2-.7Zm3-6-.1.4a33 33 0 0 1-1.7 4.1l.1-.1a25.9 25.9 0 0 0 1.4-2.8l.3-1.5Zm.4-.1V127.8v.1c0 .3-.2.5-.3.7l.3-.5Zm-36.6 16-.2.2a7.5 7.5 0 0 1 .2-.1Zm7.6-12.5a5.7 5.7 0 0 0-.9.2h-.4l-.1.5a9.6 9.6 0 0 0-.4.5l.5-.2h.2l.4-.1.2-.3.1-.2a48.2 48.2 0 0 1 .4-.4Zm-2.6 9.1h-.4l-.1.1a4 4 0 0 0-.4 0l-.1.1-.3.1h-.2l-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2a3.5 3.5 0 0 0-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1a7.2 7.2 0 0 1 .4-.3 21.3 21.3 0 0 1 .8-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm6.1-8.8v.3l-.1.2.1-.5Zm-1.8 16v-.2a3.6 3.6 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a31 31 0 0 1 1.3-5.5v-.2a41.9 41.9 0 0 1 .3-.6h-.3v-.1.2l-.1.2a20.2 20.2 0 0 0-.6 2.3v.6l-.1.4-.1.5-.2 1.2v.1a24.9 24.9 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm10.7-2.8-.4.1-1.8.8-.4.1-.3.1h-.2l-.2.1a7 7 0 0 1-.4.1 15.3 15.3 0 0 0 .9-.6l.2-.2.1-.1a22.3 22.3 0 0 1-.3.1l-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a13.1 13.1 0 0 0 1-.6l1-.7.2-.1a9.4 9.4 0 0 1 .3-.2 3.8 3.8 0 0 0 .6 0h.1l.3-.1a13.6 13.6 0 0 0 1.9-.6l.8-.2.4-.2v-.2a5.5 5.5 0 0 1 .3-.5l-.4.2Zm5.8-2a16.4 16.4 0 0 1-1.2.6l-.3.1 1.1-1a28.2 28.2 0 0 1-1.5.7l-.3.2-1 .8-.3.3h.3v-.1l.3-.1.5-.2.6-.3.3-.1h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3-1 .5Zm3.3-2v-.1Zm-2.1.5-.5.3-.5.4-.3.1-.3.2-.3.1a24.6 24.6 0 0 1-.7.4 1.6 1.6 0 0 1-.2.1l-.3.2h-.2l-1 .6-.6.2-.5.2a15.9 15.9 0 0 0 1.4-1.1h.1v-.1l.2-.1a6.9 6.9 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a22.3 22.3 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1a59.7 59.7 0 0 0 .8-1.8l.2-.5.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5-1.1 2-1.1 2a67 67 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a15.7 15.7 0 0 1-1.7 2.2l-.4.4-.1.1-.2.2a27 27 0 0 1-1.1 1l-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a78.8 78.8 0 0 0 2.1-.8h.1a22.1 22.1 0 0 0 1.3-1.1l.3-.2h.2a18.2 18.2 0 0 0 1.3-.8l-1 1.1.2-.1a26.5 26.5 0 0 0 1.2-.6l1.2-1.5Zm6.2-7.4.1-.4a10.5 10.5 0 0 0 .4-1.3 24.3 24.3 0 0 0 .7-3.3 63.3 63.3 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a27.8 27.8 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1l-.1.2a17.6 17.6 0 0 1-1.9 3l-1 1 2-.3.2-.3a49.6 49.6 0 0 0 .8-2.5l.3-.9.1-.5v-.2l.3-.1.4-.5a30.8 30.8 0 0 0-.2.8l.1-.2a5.7 5.7 0 0 0 .2-.6l.2-.3.2-.7Zm3-6a34 34 0 0 1-1.8 4.5l.1-.1a25.6 25.6 0 0 0 1.4-2.8l.3-1.5Zm.4-.1V127.8v.1c0 .3-.2.5-.3.7l.3-.5Zm-36.6 16-.2.2.2-.2Zm7.6-12.5a5.7 5.7 0 0 0-.7.1h-.2l-.1.2v-.1h-.3l-.1.5a12.5 12.5 0 0 0-.4.5l.5-.2h.2a7.8 7.8 0 0 1 .4-.2l.2-.2.1-.2a50.7 50.7 0 0 1 .4-.4Zm-2.6 9.1h-.4l-.1.1h-.4l-.1.1a6 6 0 0 0-.3.1h-.2l-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1l.3-.3h.2a12.6 12.6 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm6.1-8.8v.3l-.1.2.1-.5Zm-1.8 16v-.2a3.5 3.5 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9a97.4 97.4 0 0 1 .3-2.9 34 34 0 0 1 1.3-5.5v-.2a35.2 35.2 0 0 1 .3-.6h-.3v-.1.2l-.1.2a20 20 0 0 0-.6 2.3v.6l-.1.4a33.8 33.8 0 0 0-.3 1.7v.1a24.8 24.8 0 0 0-.2 1 59.7 59.7 0 0 0-.4 3l-.2 2 .1 1.9a3.7 3.7 0 0 0 .4 1v.1h.1v-.1Zm10.7-2.8-.4.1-1.8.8a17.4 17.4 0 0 1-.7.2h-.2l-.2.1-.4.1a30.6 30.6 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a18 18 0 0 0 2-1.3l.2-.1.2-.2h.1a4.7 4.7 0 0 0 .6 0h.1a9.7 9.7 0 0 0 1.2-.4l1-.3.8-.2.4-.2v-.2a5.5 5.5 0 0 1 .3-.5l-.4.2Zm5.8-2-.6.3-.6.3-.3.1 1.1-1a28.2 28.2 0 0 1-1.5.7l-.3.2-1 .8-.3.3h.3v-.1l.3-.1a24.3 24.3 0 0 0 1.4-.6h.1l.1-.1a25.8 25.8 0 0 0 1-.5l.3-.1.3-.2.2-.2.6-.3-1 .5Zm3.3-2v-.1Zm-2.1.5-.5.3-.5.4-.3.1-.3.2-.3.1-.3.2-.3.2h-.2v.1h-.1l-.3.2a14 14 0 0 1-1.3.6l-.5.2-.5.2a15.5 15.5 0 0 0 1.5-1.2l.2-.1a6.2 6.2 0 0 0 .7-.7v-.1a5.5 5.5 0 0 0 .3-.2l.4-.5.2-.3.1-.1.2-.2a21.2 21.2 0 0 0 2.1-3.5 53.6 53.6 0 0 0 1.7-3.6v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5-1.1 2-1.1 2a67.2 67.2 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a18.7 18.7 0 0 1-.5.8h-.1c0 .2-.1.2-.2.3l-.9 1v.1l-.4.4-.1.1-.2.2a25.5 25.5 0 0 1-1.7 1.6h-.1l-.2.3v.2l-.1.2 1.5-.5.6-.3h.1l.4-.3a24.8 24.8 0 0 0 1.2-1 8.8 8.8 0 0 0 .9-.4l.6-.4-1 1.1.2-.1a31 31 0 0 0 1.2-.6l1.2-1.5Zm6.2-7.4.1-.4.1-.2a29 29 0 0 0 1-4.4 62.7 62.7 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2a40 40 0 0 1-.6 2.1v.2l-.1.3a16.7 16.7 0 0 1-.4 1.2l-.3.6v.2l-.2.3v.1a49.9 49.9 0 0 1-1.5 2.7 19.6 19.6 0 0 1-1.6 1.5l2-.3.3-.3.3-.7.1-.5a75.1 75.1 0 0 0 .8-2.7v-.2a7.7 7.7 0 0 0 .7-.6l-.2.8.1-.2a5.2 5.2 0 0 0 .2-.5 15.6 15.6 0 0 0 .2-.5l.2-.6Zm3-6-.1.4a32.5 32.5 0 0 1-.7 2.3l.5-1c0-.6.2-1.1.3-1.6Zm.4-.1V127.8v.1c0 .3-.2.5-.3.7l.3-.5Zm-36.6 16-.2.2.2-.2Zm7.6-12.5a7 7 0 0 0-.9.2h-.4l-.1.5-.3.3-.1.2a14.5 14.5 0 0 1 1.1-.4l.2-.2.1-.2.4-.4Zm-2.6 9.1h-.4l-.1.1h-.4l-.1.1-.3.1h-.2l-.4.2a4 4 0 0 0-.3.1l-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1l.3-.3h.2a19.3 19.3 0 0 1 .7-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm6.1-8.8v.3l-.1.2.1-.5Zm-1.8 16v-.2a3.5 3.5 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9a99.3 99.3 0 0 1 .3-2.9 33 33 0 0 1 1.3-5.5v-.2l.2-.5v-.1h-.2v-.1.2l-.1.2-.1.5-.2.6v.3a13.6 13.6 0 0 0-.4 1.5v.4l-.1.5-.2 1.2v.1a34.9 34.9 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.6 3.6 0 0 0 .4 1v.1h.1v-.1Zm10.7-2.8-.4.1-1.8.8-.4.1-.3.1h-.2l-.2.1a30.6 30.6 0 0 0 .5-.6h.2l.1-.2-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a18 18 0 0 0 2-1.3 16.3 16.3 0 0 0 .4-.3h.1a4.5 4.5 0 0 0 .6 0h.1l.3-.1a14.2 14.2 0 0 0 1.9-.6l.8-.2.4-.2v-.2l.1-.2.2-.3-.4.2Zm5.8-2a19.4 19.4 0 0 1-1.5.7l1.1-1a36.6 36.6 0 0 1-1.5.7l-.3.2a24 24 0 0 1-1 1l.3-.1a24.3 24.3 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3-1 .5Zm3.3-2v-.1Zm-2.1.5-.5.3-.5.4-.3.1-.3.2-.3.1a19.1 19.1 0 0 1-.7.4l-.2.1-.3.2h-.2l-1 .6-.6.2-.5.2a16.2 16.2 0 0 0 1.5-1.2l.2-.1a6.9 6.9 0 0 0 .7-.7v-.1l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a21.4 21.4 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3v.1l-.4.5v.1l-.3.4-.3.5a75 75 0 0 0-1.1 2l-1.1 2a78 78 0 0 1-1.2 1.8l-.1.3-.2.3-.6.8a15.7 15.7 0 0 1-.5.8h-.1c0 .2-.1.2-.2.3l-.9 1v.1a23.6 23.6 0 0 1-.5.5l-.2.2-.8.7-.3.3-.2.2-.4.4h-.1l-.2.3v.2l-.1.2a81.3 81.3 0 0 0 2.1-.8h.1a26.2 26.2 0 0 0 1.3-1.1l.3-.2h.2a19.2 19.2 0 0 0 1.3-.8l-1 1.1.2-.1a31 31 0 0 0 1.2-.6l1.2-1.5Zm6.2-7.4.1-.4.1-.2a30 30 0 0 0 1-4.4 62.6 62.6 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a15.7 15.7 0 0 1-.4 1.2 26.7 26.7 0 0 1-.4.8v.3l-.1.1-.1.2a15 15 0 0 1-1.9 3l-1 1 2-.3.2-.3.3-.7.1-.5a81.3 81.3 0 0 0 .8-2.7v-.2a7.6 7.6 0 0 0 .7-.6 31.8 31.8 0 0 0-.2.8l.1-.2a4.7 4.7 0 0 0 .2-.5l.2-.4.2-.7Zm3-6a15 15 0 0 1-.6 1.9c-.4.9-.7 1.8-1.2 2.6h.1a26.1 26.1 0 0 0 1.4-2.9l.3-1.5Zm.4-.1V127.8v.1c0 .3-.2.5-.3.7l.3-.5Zm-36.6 16-.2.2.2-.2Zm7.6-12.5a6.8 6.8 0 0 0-.7.1h-.2l-.1.2v-.1h-.3l-.1.5-.3.3-.1.2.5-.2h.2l.4-.1.2-.3.1-.2.4-.4Zm-2.6 9.1h-.4a9.4 9.4 0 0 1-.5.2h-.1a3 3 0 0 1-.3.1h-.2a9.5 9.5 0 0 0-2.4 1.2l-.1.2h-.2v.1l-.3.2-.2.2-.3.3v.9l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1l.2-.1h.1a6.7 6.7 0 0 1 .4-.3l.5-.3.3-.2a20.4 20.4 0 0 0 .9-.5l.4-.2h-.2Zm6.1-8.8v.3l-.1.2.1-.5Zm-1.8 16v-.2a3.5 3.5 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a34 34 0 0 1 1.3-5.5v-.2l.2-.5v-.1h-.2a1.7 1.7 0 0 0 0-.1v.2l-.1.2-.1.5-.2.6v.3a14.3 14.3 0 0 0-.4 1.5v.4a52.5 52.5 0 0 0-.3 1.7v.1a25 25 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2a3.6 3.6 0 0 0 .4 1v.1h.1v-.1Zm10.7-2.8-.4.1-1.8.8a17.5 17.5 0 0 1-.7.2h-.2l-.2.1-.4.1a18.7 18.7 0 0 0 .9-.6l.2-.2.1-.1-.3.1-.7.2-.8.2-.2.2v-.1h-.2v.4l-.5.4-.2.2-1.3 1.2-.5.4.5-.2.2-.2a13 13 0 0 0 1-.6l1-.7.2-.1.2-.2a2.2 2.2 0 0 0 .4 0h.4a9.7 9.7 0 0 0 1.2-.4l1-.3.8-.2.4-.2v-.2l.1-.2.2-.3-.4.2Zm5.8-2a15.7 15.7 0 0 1-1.2.6l-.3.1 1.1-1a30.7 30.7 0 0 1-1.5.7l-.3.2a24.8 24.8 0 0 1-1.3 1.1h.3v-.1l.3-.1a18 18 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1a58.7 58.7 0 0 0 1.1-.7l-1 .5Zm3.3-2v-.1ZM268 119.4Zm13.9 14a34 34 0 0 1-5.6 8.6l.3-.3a38 38 0 0 0 3.9-5.4l.1-.2.2-.4.1-.2a10.6 10.6 0 0 0 .6-1.1l.2-.4.1-.4.2-.3-.1.1Zm3.2-1.9v.1l-.4.5v.1l-.3.4-.3.5-1.1 2-1.1 2a67.2 67.2 0 0 1-1.3 2.1l-.2.3-.6.8a18.7 18.7 0 0 1-.5.8h-.1c0 .2-.1.2-.2.3l-.9 1v.1a16.1 16.1 0 0 0 1.5-1v.3h-.1a13.8 13.8 0 0 1-1.3 1.4h.1v-.1l.2-.1a6.9 6.9 0 0 0 .7-.8l.2-.2h.1l.4-.5.2-.3.1-.1.2-.2a21.4 21.4 0 0 0 2.1-3.5l1-2 .4-.9.3-.7v-.1l.4-.8.4-.9.2-.6.1-.2-.2.3Zm2.6-6.2-.2.1v.2l.2-.1v-.2Zm.7 8.8.1-.4.1-.2a30 30 0 0 0 1-4.4 62.6 62.6 0 0 0 .3-3.4v.4c-.2.2-.2.5-.3.7l-.2.7-.2.6-.2.9-.6 2.2-.6 2.1v.2l-.1.3a15.7 15.7 0 0 1-.4 1.2 26.7 26.7 0 0 1-.4.8v.3l-.1.1-.1.2a15 15 0 0 1-1.9 3l-1 1a16.8 16.8 0 0 1-1.6 1.1l-.5.3-.5.4-.3.1-.3.3-1 1.1.2-.1a28.7 28.7 0 0 0 2.4-1.1l.4-.3.3-.2a13.5 13.5 0 0 0 .8-.6l.3-.2.2-.2.2-.1-.3.2-.2.3-.3.3.3-.2a11 11 0 0 0 2.1-1.7l.3-.7.1-.5a68.1 68.1 0 0 0 .8-2.7v-.2a7.6 7.6 0 0 0 .7-.6l-.2.8.1-.2.1-.3v-.2h.1a11 11 0 0 0 .2-.5l.2-.6Zm3-6a15 15 0 0 1-.6 1.9c-.4.9-.7 1.8-1.2 2.6h.1a26.1 26.1 0 0 0 1.4-2.9l.3-1.5Zm.9-1.7v-.3c.3-.7.5-1.5.6-2.3v.1a14.1 14.1 0 0 1-.5 2 15 15 0 0 1-.1.4l-.1.3v-.2Zm-.5 1.3v.2-.2Zm-8 13.5a17 17 0 0 1-4 2.4l-.3.1a34 34 0 0 0 1.4-1.4l-.3.2-.3.1a25.8 25.8 0 0 1-.7.4l-.2.1-.3.2a11.8 11.8 0 0 1-.3.3l-1 .8a30.1 30.1 0 0 1-2.4 1v-.2l.2-.4-.4.2-.2.4-.1.3.4-.2a67 67 0 0 0 2.1-.8h.4v-.1l.3-.1a24.3 24.3 0 0 0 1.4-.6h.1l.1-.1.7-.3.3-.2.3-.1.3-.2.2-.2.6-.3a15.2 15.2 0 0 0 1.6-1.1l.3-.2.4-.5-.6.5Zm-23.6-.6h-.4l-.1.1h-.4l-.1.1-.3.1h-.2l-.4.2h-.2l-.1.1-1.7 1h-.1l-.2.2-.3.2-.2.2-.3.3a35.6 35.6 0 0 0 0 .9 18.2 18.2 0 0 0-.5.4v.1a11 11 0 0 1 .5-.5l.5-.3v-.1h.1l.2-.2.3-.2v-.1l.2-.1 1-.7h.1v-.1a4.5 4.5 0 0 1 .3-.1 6.5 6.5 0 0 1 .4-.3 16.9 16.9 0 0 1 .8-.5l.4-.2c.2 0 .3-.2.5-.3l.4-.2h-.2Zm6.2-9-.3-.1h-.3l-.3-.1H265a7.9 7.9 0 0 0-1 0H263a7 7 0 0 0-.7.2H262l-.3.2a15.1 15.1 0 0 0-1.7.5l.2-.2h-.2l-.6.2v.2l-.1.1-.5.3-.4.3h-.1l-.6.4v.2l-.2.5v.1l-1 .6v.2l.3-.2.6-.4.4-.3h.1a21.3 21.3 0 0 1 2.8-1.4l.3-.1h.2v-.1l.5-.2h.2l.4-.1h.1v-.1h.4l.2-.1.4-.1a16.2 16.2 0 0 1 3.2-.5Zm-1.9 16.3v-.3a3.6 3.6 0 0 1-.4-1c-.1-.6-.2-1.2-.1-1.9l.2-1.9.2-1.9.1-.8v-.2a31 31 0 0 1 1.3-5.5v-.2l.2-.5v-.1h-.2v-.1l.3-1v.2l-.1.3-.2.4a1.8 1.8 0 0 0 0 .3l-.1.2-.1.5-.2.6a23 23 0 0 0-.4 1.8v.4a52.4 52.4 0 0 0-.3 1.7v.1a19.3 19.3 0 0 0-.2 1l-.2 1.1-.2 2-.2 1.8.1 2 .4 1v.1h.1v-.1Z\"/>\n  </g>\n</svg>\n";

"use strict";
const GrotCTA = ({ width = "auto", height }) => {
  const styles = useStyles2(getStyles$1z);
  return /* @__PURE__ */ jsxRuntime.jsx(SVG__default.default, { src: grotCTASvg, className: styles.svg, height, width });
};
GrotCTA.displayName = "GrotCTA";
const getStyles$1z = (theme) => {
  return {
    svg: css.css({
      "#grot-cta-cactus-1, #grot-cta-cactus-2": {
        fill: theme.isDark ? "#58558c" : "#c9c5f4"
      }
    })
  };
};

var notFoundSvg = "<svg viewBox=\"0 0 722 480\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n  <path d=\"M514.59 3.80879C447.52 -7.78121 379.51 8.58879 314.8 32.5588C275.1 47.2688 236.85 58.9488 196.11 69.7588C150.35 81.8988 102.13 94.2588 62.7402 123.959C15.7502 159.389 -0.05983 214.349 0.000170029 274.969C0.04017 319.049 7.54023 365.349 33.0602 399.379C71.8302 451.069 139.04 459.809 196.03 455.539C267.53 450.189 313.45 436.549 383.95 458.929C471.35 486.669 580.88 498.339 659.07 416.129C765.14 304.599 726.89 126.169 614.63 45.6788C598.19 33.8888 580.48 24.2188 561.98 16.9888C546.27 10.8488 530.46 6.53878 514.59 3.79878V3.80879Z\" fill=\"#9087E9\" fill-opacity=\"0.3\"/>\n  <path opacity=\"0.3\" d=\"M273.041 410.45C346.097 410.45 405.321 403.497 405.321 394.92C405.321 386.343 346.097 379.39 273.041 379.39C199.985 379.39 140.761 386.343 140.761 394.92C140.761 403.497 199.985 410.45 273.041 410.45Z\" fill=\"black\"/>\n  <g id=\"grot-not-found-arm\">\n    <path d=\"M346.921 293.19C358.131 296.32 448.181 322.33 432.881 344.87C418.531 366 348.841 340.92 326.921 325.65\" fill=\"#F99F10\"/>\n    <path d=\"M346.921 293.19C358.131 296.32 448.181 322.33 432.881 344.87C418.531 366 348.841 340.92 326.921 325.65\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  </g>\n  <path d=\"M218.861 115.04C187.091 92.89 146.441 87.92 139.291 95.87C133.491 102.31 155.401 137.59 151.851 147.9C148.311 158.21 117.231 151.54 113.831 164.65C112.221 170.88 136.061 185.91 135.421 194.61C134.781 203.31 116.371 200.85 115.021 212.11C114.111 219.68 130.911 221.35 130.271 230.37C129.631 239.39 117.501 237.74 118.031 246.48C118.461 253.57 131.721 248.9 135.271 260.82C138.811 272.74 218.871 115.04 218.871 115.04H218.861Z\" fill=\"#EF6122\"/>\n  <path d=\"M77.1408 326.59C78.1108 297.43 98.4608 290.96 113.241 295.94C128.011 300.92 127.191 318.09 123.461 324.55C117.501 334.86 108.751 330.41 112.021 323.19C114.441 316.26 114.891 306.64 103.441 309.7C89.2109 313.51 93.6408 351.77 123.601 344.25C144.121 339.1 142.511 317.37 140.881 285.68C136.511 255.02 141.241 214.82 154.281 176.66C180.701 99.34 339.851 74.21 392.681 145.73C461.311 238.63 385.631 329.37 373.991 340.96C337.731 369.1 343.611 394.56 317.631 396.25C292.941 397.86 294.971 372.77 278.641 371.37C277.681 371.37 276.721 371.37 275.761 371.35C256.591 372.76 252.891 396.67 223.981 396.25C200.421 395.91 210.911 375.33 195.171 365.46C191.871 363.9 189.011 362.8 186.371 362.08C184.291 361.64 181.981 361.32 179.371 361.16C178.771 361.12 175.141 361.14 174.081 361.14C164.731 361.31 159.121 363.52 137.991 367.82C99.9208 375.56 76.3208 351.26 77.1408 326.59Z\" fill=\"#FAC20C\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\"/>\n  <path d=\"M181.051 134.78C235.171 96.44 298.161 117.38 306.211 122.7C314.261 128.02 325.671 121.7 319.261 105.73C297.781 52.25 242.361 25.05 227.441 34.26C210.761 44.56 231.741 90.5 220.841 101.27C212.091 109.91 206.131 103.31 191.251 98.32C177.811 93.81 181.051 134.78 181.051 134.78Z\" fill=\"#EF6122\"/>\n  <path d=\"M262.101 239.52L410.381 239.52C428.197 239.52 442.641 225.077 442.641 207.26V207.25C442.641 189.433 428.197 174.99 410.381 174.99L262.101 174.99C244.284 174.99 229.841 189.433 229.841 207.25V207.26C229.841 225.077 244.284 239.52 262.101 239.52Z\" fill=\"#5545EF\" stroke=\"#231735\" stroke-width=\"5\" stroke-miterlimit=\"10\"/>\n  <path d=\"M296.28 228.67L408.8 228.67C420.619 228.67 430.2 219.089 430.2 207.27C430.2 195.451 420.619 185.87 408.8 185.87H296.28C284.461 185.87 274.88 195.451 274.88 207.27C274.88 219.089 284.461 228.67 296.28 228.67Z\" fill=\"#19052D\"/>\n  <path d=\"M257.971 297.31C257.351 316.15 250.621 333.66 236.651 332.47C221.221 331.16 217.391 315.15 217.921 297.76\" fill=\"#F99F10\"/>\n  <path d=\"M257.971 297.31C257.351 316.15 250.621 333.66 236.651 332.47C221.221 331.16 217.391 315.15 217.921 297.76\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M200.23 104.32C172.95 91.48 146.34 84.67 139.29 95.87C131.67 107.98 157.65 133.7 151.85 147.9C146.43 161.18 115.82 149.78 113.83 164.65C112.24 176.55 136.06 185.91 135.42 194.61C134.78 203.31 116.14 199.76 114.78 211.03C113.87 218.6 130.91 221.35 130.26 230.37C129.62 239.39 118.02 237.73 118.02 246.48C118.02 253.6 138.81 254.21 139.4 269.02\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\"/>\n  <path d=\"M306.211 122.7C314.261 128.02 325.671 121.7 319.261 105.73C297.781 52.25 244.001 24.95 227.441 34.26C210.061 44.03 231.741 90.5 220.841 101.27C214.751 107.29 206.751 107.03 199.421 103.95\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\"/>\n  <path d=\"M306.531 122.94C277.581 105.78 226.39 104.87 180.98 138.83\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\"/>\n  <path d=\"M341.4 253.66C351.4 254.03 366.49 259.17 366.02 269.49C365.55 279.82 349.3 283.19 335.71 279.29C322.12 275.39 323.16 265.5 325.3 262.15C327.44 258.8 332.12 253.32 341.41 253.66H341.4Z\" fill=\"black\"/>\n  <path d=\"M345.16 258.45C351.6 259.28 356.39 262.63 356.39 262.63C356.39 262.63 355.45 269.62 344.22 269.4C332.99 269.18 336.07 258.72 336.07 258.72C336.07 258.72 339.03 257.66 345.15 258.44L345.16 258.45Z\" fill=\"white\"/>\n  <g opacity=\"0.6\">\n    <path d=\"M621.96 318.31V332.84\" stroke=\"#7F73F2\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M629.23 325.58H614.69\" stroke=\"#7F73F2\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M657.411 162.86V175.25\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M663.601 169.05H651.221\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <g opacity=\"0.4\">\n      <path d=\"M497.061 209.35V221.73\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n      <path d=\"M503.25 215.54H490.87\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    </g>\n    <path d=\"M660.051 285.01L668.811 293.76\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M668.811 285.01L660.051 293.76\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M476.391 312.83L482.341 318.78\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M482.341 312.83L476.391 318.78\" stroke=\"#5545EF\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M519 113.2H527.41\" stroke=\"#7F73F2\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M523.21 109V117.41\" stroke=\"#7F73F2\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M609.581 239.16L616.861 231.87C617.721 231.01 617.721 229.61 616.861 228.74C616.001 227.88 614.601 227.88 613.731 228.74L606.451 236.03L599.161 228.75C598.301 227.89 596.901 227.89 596.031 228.75C595.171 229.61 595.171 231.01 596.031 231.88L603.321 239.16L596.041 246.45C595.181 247.31 595.181 248.71 596.041 249.58C596.471 250.01 597.041 250.23 597.601 250.23C598.161 250.23 598.731 250.01 599.161 249.58L606.441 242.29L613.731 249.57C614.161 250 614.731 250.22 615.291 250.22C615.851 250.22 616.421 250 616.851 249.57C617.711 248.71 617.711 247.31 616.851 246.44L609.561 239.16H609.581Z\" fill=\"#B4ADF8\"/>\n    <path d=\"M557.84 280.71V267.77C557.83 266.23 556.581 264.99 555.051 264.99C553.521 264.99 552.271 266.23 552.271 267.77V280.71C552.281 282.25 553.531 283.49 555.061 283.49C556.591 283.49 557.84 282.25 557.84 280.71Z\" fill=\"#A59DF7\"/>\n    <path d=\"M648.21 244.27V257.21C648.22 258.75 649.47 259.99 651 259.99C652.53 259.99 653.78 258.75 653.78 257.21V244.27C653.77 242.73 652.52 241.49 650.99 241.49C649.46 241.49 648.21 242.73 648.21 244.27Z\" fill=\"#402EED\"/>\n    <path d=\"M561.34 181.68H548.4C546.86 181.69 545.62 182.94 545.62 184.47C545.62 186 546.86 187.25 548.4 187.25H561.34C562.88 187.24 564.12 185.99 564.12 184.46C564.12 182.93 562.88 181.68 561.34 181.68Z\" fill=\"#5041E4\"/>\n    <path d=\"M568.931 247.36L568.951 280.7C568.951 282.24 570.191 283.48 571.731 283.48C573.271 283.48 574.511 282.24 574.511 280.7L574.491 247.36C574.491 245.82 573.251 244.58 571.711 244.58C570.171 244.58 568.931 245.82 568.931 247.36Z\" fill=\"#A59DF7\"/>\n    <path d=\"M574.791 321.8L541.451 321.82C539.911 321.82 538.671 323.06 538.671 324.6C538.671 326.14 539.911 327.38 541.451 327.38L574.791 327.36C576.331 327.36 577.571 326.12 577.571 324.58C577.571 323.04 576.331 321.8 574.791 321.8Z\" fill=\"#5041E4\"/>\n    <path d=\"M601.3 192.84H588.12C586.46 192.84 585.11 194.2 585.11 195.86V209.04C585.11 210.71 586.47 212.05 588.13 212.05H601.31C602.97 212.05 604.32 210.7 604.32 209.03V195.85C604.32 194.19 602.96 192.84 601.3 192.84ZM599.82 207.55H589.61V197.35H599.82V207.55Z\" fill=\"#7C6FFD\"/>\n    <path d=\"M541.171 280.72V258.49C541.161 256.95 539.911 255.71 538.381 255.71C536.851 255.71 535.601 256.95 535.601 258.49V280.72C535.611 282.26 536.861 283.5 538.391 283.5C539.921 283.5 541.171 282.26 541.171 280.72Z\" fill=\"#A59DF7\"/>\n    <path d=\"M524.981 318.59C528.361 318.59 531.111 321.34 531.111 324.72C531.111 328.1 528.361 330.85 524.981 330.85C521.601 330.85 518.851 328.1 518.851 324.72C518.851 321.34 521.601 318.59 524.981 318.59ZM524.981 326.76C526.111 326.76 527.021 325.84 527.021 324.72C527.021 323.6 526.101 322.68 524.981 322.68C523.861 322.68 522.941 323.6 522.941 324.72C522.941 325.84 523.861 326.76 524.981 326.76Z\" fill=\"#5545EF\"/>\n    <path d=\"M656.781 228.23C656.781 231.6 654.041 234.34 650.671 234.34C647.301 234.34 644.561 231.6 644.561 228.23C644.561 224.86 647.301 222.12 650.671 222.12C654.041 222.12 656.781 224.86 656.781 228.23ZM648.641 228.23C648.641 229.35 649.551 230.27 650.681 230.27C651.811 230.27 652.72 229.36 652.72 228.23C652.72 227.1 651.811 226.19 650.681 226.19C649.551 226.19 648.641 227.1 648.641 228.23Z\" fill=\"#402EED\"/>\n    <path d=\"M607.45 279.74C607.04 279.74 606.56 279.67 606.15 279.47C605.74 279.33 605.33 279.06 605.06 278.72C604.72 278.45 604.45 278.04 604.31 277.63C604.1 277.22 604.04 276.81 604.04 276.33C604.04 275.44 604.38 274.55 605.06 273.94C605.33 273.6 605.74 273.33 606.15 273.19C606.97 272.85 607.93 272.85 608.75 273.19C609.16 273.33 609.57 273.6 609.84 273.94C610.52 274.55 610.87 275.44 610.87 276.33C610.87 276.81 610.8 277.22 610.6 277.63C610.46 278.04 610.19 278.45 609.85 278.72C609.58 279.06 609.17 279.34 608.76 279.47C608.35 279.67 607.94 279.74 607.46 279.74H607.45Z\" fill=\"#7F73F2\"/>\n    <path d=\"M560.38 219.83C559.24 219.83 558.111 219.4 557.331 218.52C556.461 217.74 556.021 216.61 556.021 215.47C556.021 214.33 556.451 213.21 557.331 212.42C558.901 210.77 561.861 210.77 563.421 212.42C563.861 212.77 564.21 213.3 564.38 213.82C564.64 214.35 564.73 214.95 564.73 215.48C564.73 216.08 564.64 216.61 564.38 217.13C564.21 217.66 563.861 218.18 563.421 218.53C562.641 219.41 561.51 219.84 560.37 219.84L560.38 219.83Z\" fill=\"#5545EF\"/>\n    <path d=\"M678.98 214.927C678.2 214.927 677.43 214.627 676.89 214.027C676.29 213.487 676 212.717 676 211.937C676 211.157 676.3 210.387 676.89 209.847C677.96 208.717 679.99 208.717 681.06 209.847C681.36 210.087 681.6 210.447 681.72 210.807C681.9 211.167 681.96 211.578 681.96 211.948C681.96 212.358 681.9 212.717 681.72 213.077C681.6 213.437 681.36 213.798 681.06 214.038C680.52 214.638 679.75 214.937 678.97 214.937L678.98 214.927Z\" fill=\"#B4ADF8\"/>\n    <path d=\"M614.5 106.948C614.08 106.948 613.59 106.878 613.17 106.668C612.75 106.528 612.33 106.247 612.05 105.897C611.35 105.267 611 104.358 611 103.448C611 102.958 611.07 102.537 611.28 102.117C611.42 101.697 611.7 101.278 612.05 100.998C613.31 99.6675 615.69 99.6675 616.95 100.998C617.3 101.278 617.58 101.697 617.72 102.117C617.93 102.537 618 102.958 618 103.448C618 104.358 617.65 105.267 616.95 105.897C616.67 106.247 616.25 106.528 615.83 106.668C615.41 106.878 614.92 106.948 614.5 106.948Z\" fill=\"#5545EF\"/>\n    <path d=\"M614.231 301.93H493.311C485.081 301.93 477.641 296.42 475.231 288.53C474.831 287.21 475.571 285.81 476.891 285.41C478.211 285.01 479.611 285.75 480.011 287.07C481.791 292.88 487.261 296.93 493.311 296.93H614.231C621.901 296.93 628.131 290.69 628.131 283.03V192.28C628.131 184.62 621.891 178.38 614.231 178.38H575.251C573.871 178.38 572.751 177.26 572.751 175.88C572.751 174.5 573.871 173.38 575.251 173.38H614.231C624.651 173.38 633.131 181.86 633.131 192.28V283.03C633.131 293.45 624.651 301.93 614.231 301.93Z\" fill=\"#5A49FA\"/>\n  </g>\n  <path d=\"M364.23 218.6L394.26 198.12\" stroke=\"white\" stroke-width=\"5.18\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M394.26 218.6L364.23 198.12\" stroke=\"white\" stroke-width=\"5.18\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M319.95 218.6L349.99 198.12\" stroke=\"white\" stroke-width=\"5.18\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M349.99 218.6L319.95 198.12\" stroke=\"white\" stroke-width=\"5.18\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <g id=\"grot-not-found-magnifier\">\n    <path opacity=\"0.15\" d=\"M459.55 269.6C493.527 269.6 521.07 242.057 521.07 208.08C521.07 174.103 493.527 146.56 459.55 146.56C425.574 146.56 398.03 174.103 398.03 208.08C398.03 242.057 425.574 269.6 459.55 269.6Z\" fill=\"white\"/>\n    <path d=\"M531.381 221.52C532.261 216.9 532.671 212.18 532.621 207.48C532.571 202.87 532.071 198.24 531.131 193.71C530.201 189.23 528.831 184.82 527.061 180.6C525.291 176.38 523.111 172.3 520.581 168.5C518.021 164.65 515.071 161.04 511.831 157.77C508.521 154.43 504.861 151.42 500.961 148.8C496.961 146.12 492.661 143.82 488.171 141.98C483.681 140.14 479.011 138.75 474.271 137.85C469.651 136.97 464.931 136.56 460.231 136.61C455.621 136.66 450.99 137.16 446.46 138.1C441.98 139.03 437.571 140.4 433.351 142.17C429.131 143.94 425.051 146.12 421.251 148.65C417.401 151.21 413.791 154.16 410.521 157.4C407.181 160.71 404.171 164.37 401.551 168.27C398.871 172.27 396.571 176.57 394.731 181.06C392.891 185.55 391.501 190.22 390.601 194.96C389.721 199.58 389.311 204.3 389.361 209C389.411 213.61 389.911 218.24 390.851 222.77C391.781 227.25 393.151 231.66 394.921 235.88C396.691 240.1 398.871 244.18 401.401 247.98C403.961 251.83 406.911 255.44 410.151 258.71C413.461 262.05 417.121 265.06 421.021 267.68C423.211 269.15 425.491 270.5 427.841 271.73L420.241 290.27L419.321 289.89C416.121 288.58 412.441 290.12 411.131 293.32L383.451 360.83C382.141 364.03 383.681 367.71 386.881 369.02L400.891 374.77C404.091 376.08 407.771 374.54 409.081 371.34L436.761 303.83C438.071 300.63 436.531 296.95 433.331 295.64L432.411 295.26L440.011 276.72C442.551 277.5 445.121 278.14 447.711 278.63C452.331 279.51 457.051 279.92 461.751 279.87C466.361 279.82 470.991 279.32 475.521 278.38C480.001 277.45 484.411 276.08 488.631 274.31C492.851 272.54 496.931 270.36 500.731 267.83C504.581 265.27 508.19 262.32 511.46 259.08C514.8 255.77 517.811 252.11 520.431 248.21C523.111 244.21 525.411 239.91 527.251 235.42C529.091 230.93 530.481 226.26 531.381 221.52ZM438.471 263.14C408.151 250.71 393.651 216.04 406.081 185.72C418.511 155.4 453.181 140.9 483.501 153.33C513.821 165.76 528.321 200.43 515.891 230.75C503.461 261.07 468.791 275.57 438.471 263.14Z\" fill=\"black\"/>\n    <path opacity=\"0.3\" d=\"M431.661 246.88C433.981 248.49 436.401 249.85 438.881 250.99C422.951 235.18 420.151 209.77 433.381 190.69C446.611 171.61 471.401 165.33 491.781 174.71C489.841 172.79 487.721 171 485.401 169.39C464.001 154.55 434.621 159.86 419.781 181.26C404.941 202.66 410.251 232.04 431.651 246.88H431.661Z\" fill=\"white\"/>\n    <path d=\"M425.671 350.09C437.371 343.43 440.131 329.99 437.201 321.33C434.781 314.19 424.271 311.27 418.091 319.96C411.221 329.61 422.451 339.87 422.451 339.87\" fill=\"#F99F10\"/>\n    <path d=\"M425.671 350.09C437.371 343.43 440.131 329.99 437.201 321.33C434.781 314.19 424.271 311.27 418.091 319.96C411.221 329.61 422.451 339.87 422.451 339.87\" stroke=\"#3A1103\" stroke-width=\"5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  </g>\n</svg>\n";

"use strict";
const MIN_ARM_ROTATION = -20;
const MAX_ARM_ROTATION = 5;
const MIN_ARM_TRANSLATION = -5;
const MAX_ARM_TRANSLATION = 5;
const GrotNotFound = ({ width = "auto", height }) => {
  const svgRef = React.useRef(null);
  const styles = useStyles2(getStyles$1y);
  React.useEffect(() => {
    const handleMouseMove = (event) => {
      var _a, _b;
      if (window.matchMedia("(prefers-reduced-motion: reduce").matches) {
        return;
      }
      const grotArm = (_a = svgRef.current) == null ? void 0 : _a.querySelector("#grot-not-found-arm");
      const grotMagnifier = (_b = svgRef.current) == null ? void 0 : _b.querySelector("#grot-not-found-magnifier");
      const { clientX, clientY } = event;
      const { innerWidth, innerHeight } = window;
      const heightRatio = clientY / innerHeight;
      const widthRatio = clientX / innerWidth;
      const rotation = getIntermediateValue(heightRatio, MIN_ARM_ROTATION, MAX_ARM_ROTATION);
      const translation = getIntermediateValue(widthRatio, MIN_ARM_TRANSLATION, MAX_ARM_TRANSLATION);
      window.requestAnimationFrame(() => {
        grotArm == null ? void 0 : grotArm.setAttribute("style", `transform: rotate(${rotation}deg) translateX(${translation}%)`);
        grotMagnifier == null ? void 0 : grotMagnifier.setAttribute("style", `transform: rotate(${rotation}deg) translateX(${translation}%)`);
      });
    };
    window.addEventListener("mousemove", handleMouseMove);
    return () => {
      window.removeEventListener("mousemove", handleMouseMove);
    };
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsx(SVG__default.default, { innerRef: svgRef, src: notFoundSvg, className: styles.svg, height, width });
};
GrotNotFound.displayName = "GrotNotFound";
const getStyles$1y = (theme) => {
  return {
    svg: css.css({
      "#grot-not-found-arm, #grot-not-found-magnifier": {
        transformOrigin: "center"
      }
    })
  };
};
const getIntermediateValue = (ratio, start, end) => {
  const value = ratio * (end - start) + start;
  return value;
};

var GrotCompleted = "<svg viewBox=\"0 0 269 196\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n  <path d=\"M190.886 173.235C237.118 175.202 274.318 140.851 259.601 84.308C249.806 46.8174 221.186 14.007 191.104 10.9849C161.022 7.9629 79.5466 4.64546 31.9694 53.4698C-15.6077 102.294 18.1404 168.354 54.3243 184.766C90.5082 201.179 144.653 171.267 190.886 173.235Z\" fill=\"#9087E9\" fill-opacity=\"0.3\"/>\n  <path opacity=\"0.3\" d=\"M127.931 164.331C156.997 164.331 180.56 161.565 180.56 158.152C180.56 154.739 156.997 151.973 127.931 151.973C98.8654 151.973 75.3027 154.739 75.3027 158.152C75.3027 161.565 98.8654 164.331 127.931 164.331Z\" fill=\"black\"/>\n  <path d=\"M151.419 40.8042C164.809 31.4686 181.942 29.3738 184.956 32.7236C187.401 35.4389 178.166 50.3077 179.663 54.6536C181.156 58.9994 194.255 56.1885 195.689 61.7124C196.368 64.339 186.319 70.6724 186.589 74.3394C186.86 78.0065 194.618 76.9708 195.188 81.7155C195.57 84.9067 188.49 85.6112 188.759 89.4112C189.029 93.2135 194.14 92.5184 193.919 96.2018C193.737 99.19 188.147 97.2212 186.652 102.246C185.159 107.271 151.414 40.7995 151.414 40.7995H151.419V40.8042Z\" fill=\"#EE6224\"/>\n  <path d=\"M211.16 129.971C210.751 117.68 202.174 114.953 195.943 117.052C189.717 119.152 190.062 126.388 191.635 129.113C194.147 133.458 197.835 131.583 196.456 128.539C195.437 125.618 195.246 121.564 200.072 122.854C206.07 124.459 204.203 140.587 191.574 137.417C182.924 135.248 183.603 126.087 184.291 112.73C186.134 99.8065 184.14 82.8616 178.644 66.7774C167.507 34.1869 100.427 23.5963 78.1592 53.7398C49.2311 92.8969 81.1311 131.144 86.0368 136.029C101.321 147.889 98.8412 158.622 109.793 159.333C120.2 160.012 119.343 149.438 126.227 148.845C126.631 148.845 127.037 148.845 127.44 148.836C135.521 149.431 137.079 159.508 149.265 159.331C159.196 159.188 154.775 150.513 161.41 146.354C162.8 145.696 164.006 145.232 165.119 144.928C165.996 144.744 166.968 144.609 168.069 144.541C168.321 144.525 169.852 144.532 170.3 144.532C174.24 144.604 176.605 145.535 185.511 147.347C201.558 150.609 211.505 140.368 211.16 129.969V129.971Z\" fill=\"#F9C213\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\"/>\n  <path d=\"M167.355 49.1243C144.544 32.9631 117.995 41.7902 114.601 44.0319C111.207 46.2737 106.399 43.6097 109.1 36.8798C118.153 14.3387 141.513 2.87331 147.802 6.75497C154.833 11.0962 145.99 30.4601 150.583 34.9996C154.271 38.641 156.783 35.8604 163.056 33.7563C168.72 31.8551 167.355 49.1243 167.355 49.1243Z\" fill=\"#EE6224\"/>\n  <path d=\"M133.194 93.2719H70.6951C63.1861 93.2719 57.0977 87.1834 57.0977 79.6744V79.6697C57.0977 72.1607 63.1861 66.0723 70.6951 66.0723H133.194C140.703 66.0723 146.791 72.1607 146.791 79.6697V79.6744C146.791 87.1834 140.703 93.2719 133.194 93.2719Z\" fill=\"#5545EF\" stroke=\"#231735\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\"/>\n  <path d=\"M118.785 88.6966H71.3585C66.3782 88.6966 62.3379 84.6586 62.3379 79.6759C62.3379 74.6932 66.3758 70.6553 71.3585 70.6553H118.785C123.768 70.6553 127.806 74.6932 127.806 79.6759C127.806 84.6586 123.768 88.6966 118.785 88.6966Z\" fill=\"#1C0F2D\"/>\n  <path d=\"M159.273 36.2856C170.771 30.8737 181.987 28.0045 184.959 32.7236C188.171 37.8276 177.221 48.6678 179.666 54.6535C181.95 60.2497 194.852 55.4467 195.692 61.7124C196.361 66.7277 186.321 70.6724 186.592 74.3394C186.863 78.0064 194.719 76.5112 195.291 81.2606C195.673 84.4518 188.493 85.6111 188.766 89.4135C189.037 93.2158 193.926 92.516 193.926 96.204C193.926 99.2039 185.162 99.4629 184.915 105.705\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\"/>\n  <path d=\"M114.601 44.0325C111.207 46.2743 106.399 43.6103 109.1 36.8804C118.153 14.3393 140.823 2.83194 147.802 6.75559C155.127 10.8728 145.99 30.4608 150.583 35.0002C153.149 37.5382 156.522 37.4286 159.611 36.1293\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\"/>\n  <path d=\"M114.467 44.133C126.669 36.8992 148.245 36.5166 167.385 50.8302\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\"/>\n  <path d=\"M69.666 86.4961H79.6408\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M69.666 82.2236H79.6408\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M69.666 77.9531H79.6408\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M110.295 86.4961H120.27\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M110.295 82.2236H120.27\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M110.295 77.9531H120.27\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M96.752 86.4951H106.729\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M96.752 82.2246H106.729\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M83.2129 86.4961H93.1876\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M83.2129 82.2246H93.1876\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M83.2129 77.9521H93.1876\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M83.2129 73.6816H93.1876\" stroke=\"#5BBA47\" stroke-width=\"2.19422\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M143.089 23.8493C143.072 23.5039 143.016 23.1376 142.915 22.7062C142.815 22.2747 142.651 21.8188 142.423 21.3205C142.194 20.8435 141.88 20.3217 141.479 19.8403C141.333 19.6434 141.164 19.4474 140.973 19.2717C141.272 18.1572 140.664 17.1785 140.664 17.1785C139.59 17.0952 138.916 17.4714 138.654 17.6602C138.612 17.6387 138.569 17.6148 138.525 17.6147C138.354 17.5477 138.161 17.4579 137.97 17.4117C137.777 17.3437 137.584 17.297 137.392 17.229C137.198 17.1823 136.985 17.1371 136.77 17.0893C136.727 17.0892 136.706 17.0881 136.664 17.0667C136.216 15.5735 134.893 14.9283 134.893 14.9283C133.393 15.8495 133.068 17.1778 133.068 17.1778C133.068 17.1778 133.067 17.1991 133.046 17.263C132.959 17.2821 132.874 17.3038 132.787 17.3228C132.679 17.3647 132.548 17.4051 132.442 17.4256C132.334 17.4675 132.203 17.5078 132.095 17.5497C131.879 17.6528 131.639 17.7563 131.422 17.8614C131.205 17.9879 130.987 18.1123 130.792 18.2377C130.771 18.2153 130.749 18.2163 130.749 18.2163C128.697 17.4063 126.851 18.3439 126.851 18.3439C126.641 20.5349 127.607 21.9517 127.818 22.2122C127.772 22.3411 127.726 22.4893 127.683 22.6187C127.524 23.112 127.407 23.6246 127.312 24.1622C127.31 24.2481 127.288 24.3115 127.287 24.3978C125.336 25.2676 124.743 27.1956 124.743 27.1956C126.304 29.0521 128.173 29.2131 128.173 29.2131C128.402 29.6469 128.674 30.0396 128.97 30.4319C129.096 30.5846 129.224 30.7378 129.371 30.8915C128.762 32.5391 129.404 33.9475 129.404 33.9475C131.188 34.0417 132.365 33.2224 132.605 33.0325C132.776 33.0995 132.969 33.1461 133.142 33.1918C133.678 33.351 134.236 33.425 134.795 33.4777C134.924 33.48 135.075 33.4814 135.204 33.4837L135.268 33.4849L135.311 33.485L135.397 33.4873L135.483 33.4895C136.302 34.7094 137.762 34.8836 137.762 34.8836C138.835 33.805 138.896 32.7081 138.9 32.4714L138.901 32.4501L138.901 32.4069L138.901 32.3638C139.12 32.216 139.337 32.0484 139.533 31.8798C139.949 31.4989 140.343 31.0758 140.653 30.6291C140.674 30.587 140.719 30.5444 140.741 30.5023C141.922 30.587 142.777 29.8049 142.777 29.8049C142.603 28.5754 141.903 27.9602 141.755 27.8298L141.735 27.8074L141.713 27.8064C141.713 27.8064 141.692 27.8053 141.693 27.784C141.694 27.7195 141.718 27.6347 141.719 27.5702C141.721 27.4412 141.745 27.3133 141.746 27.1625L141.748 27.0548L141.748 27.0116L141.749 26.9903L141.749 26.9471L141.751 26.8613L141.753 26.7536L141.754 26.646L141.755 26.5383L141.756 26.4306L141.736 26.3219C141.717 26.1918 141.697 26.042 141.657 25.9108C141.536 25.3707 141.351 24.8725 141.08 24.4153C140.809 23.958 140.47 23.5443 140.088 23.1929C139.706 22.8416 139.281 22.5764 138.834 22.3534C138.386 22.1517 137.914 21.9936 137.441 21.9411C137.206 21.9162 136.968 21.8907 136.732 21.8851L136.646 21.8828L136.625 21.8818C136.625 21.8818 136.582 21.8817 136.603 21.8807L136.56 21.8806L136.474 21.8783L136.389 21.8761C136.258 21.8951 136.151 21.8938 136.023 21.9133C135.547 21.9919 135.115 22.1569 134.703 22.3855C134.312 22.6151 133.962 22.8895 133.677 23.2301C133.392 23.5488 133.171 23.9099 133.013 24.2955C132.855 24.6811 132.762 25.0659 132.736 25.4523L132.732 25.7321L132.731 25.7966L132.729 25.8824L132.726 26.0114C132.744 26.206 132.784 26.3996 132.825 26.5719C132.926 26.9388 133.071 27.2647 133.281 27.5273C133.471 27.8106 133.724 28.0301 133.978 28.2283C134.234 28.4052 134.511 28.5379 134.789 28.6295C135.066 28.7211 135.325 28.7456 135.583 28.7503L135.669 28.7525L135.712 28.7526L135.755 28.7527L135.841 28.755L135.862 28.756L135.884 28.7571L135.927 28.7572C135.97 28.7573 135.991 28.7584 136.014 28.7381C136.035 28.7392 136.079 28.718 136.101 28.719C136.166 28.6989 136.209 28.699 136.273 28.6783C136.381 28.6364 136.49 28.5971 136.598 28.5552C136.706 28.5133 136.793 28.451 136.88 28.3867C136.902 28.3665 136.923 28.3437 136.945 28.3447C137.032 28.2825 137.056 28.1525 136.97 28.066C136.907 27.979 136.799 27.9559 136.712 28.0181C136.689 28.0384 136.668 28.0393 136.647 28.0601C136.583 28.1021 136.496 28.1212 136.408 28.1423C136.321 28.1614 136.236 28.183 136.149 28.2021C136.106 28.202 136.062 28.2212 136.019 28.2211L135.955 28.2199L135.89 28.2188L135.826 28.2176L135.74 28.2153L135.718 28.2143L135.675 28.2142L135.611 28.213C135.418 28.1882 135.204 28.1211 135.011 28.0312C134.82 27.9419 134.626 27.8089 134.458 27.6561C134.289 27.5033 134.14 27.3059 134.036 27.1111C133.933 26.895 133.85 26.6775 133.811 26.4194C133.792 26.2893 133.793 26.1816 133.796 26.0526L133.797 25.945L133.798 25.9236L133.799 25.9023L133.799 25.8591C133.801 25.7946 133.823 25.7312 133.824 25.6667C133.92 25.151 134.207 24.6402 134.622 24.2593C134.731 24.1529 134.841 24.0684 134.95 24.0072C135.06 23.9226 135.19 23.8605 135.32 23.7983C135.45 23.7362 135.579 23.6954 135.732 23.6541C135.861 23.6133 136.013 23.5933 136.163 23.5967L136.378 23.6013L136.421 23.6014L136.486 23.6026L136.529 23.6027L136.55 23.6038L136.615 23.605C136.764 23.6297 136.937 23.654 137.087 23.6767C137.387 23.746 137.687 23.8585 137.964 24.0364C138.518 24.347 138.983 24.851 139.275 25.4368C139.421 25.7413 139.524 26.0438 139.561 26.3664C139.58 26.4533 139.58 26.5396 139.579 26.6041L139.577 26.6686L139.576 26.7331L139.575 26.7976L139.574 26.8621L139.574 26.9052L139.573 26.9697L139.569 27.1201C139.567 27.2059 139.545 27.2912 139.543 27.377C139.541 27.4628 139.519 27.5481 139.495 27.6349C139.471 27.7217 139.45 27.8069 139.426 27.8917C139.381 28.0637 139.314 28.2347 139.245 28.4052C139.11 28.7253 138.932 29.0454 138.712 29.344C138.271 29.9173 137.705 30.3811 137.031 30.671C136.705 30.8155 136.359 30.9182 135.993 30.9768C135.819 30.9956 135.627 31.014 135.454 31.0328L135.41 31.0327L135.389 31.0317L135.325 31.0305L135.239 31.0283L135.196 31.0282L135.174 31.0271C135.088 31.0248 134.981 31.0236 134.895 31.002C134.51 30.9737 134.123 30.8803 133.758 30.7666C133.394 30.653 133.032 30.4967 132.712 30.3187C132.051 29.9423 131.436 29.4369 130.972 28.8253C130.741 28.5206 130.532 28.1935 130.365 27.8685C130.198 27.5218 130.076 27.1756 129.975 26.8066C129.873 26.4397 129.836 26.0719 129.799 25.7062L129.8 25.6417L129.801 25.6203L129.802 25.599L129.804 25.5777L129.805 25.5132L129.806 25.4919L129.807 25.4705L129.807 25.4274L129.809 25.3415L129.81 25.3202L129.81 25.277L129.813 25.148C129.816 24.9545 129.84 24.7834 129.865 24.589C129.89 24.3966 129.937 24.2032 129.961 24.0301C130.008 23.8367 130.053 23.6666 130.102 23.4738C130.215 23.1094 130.35 22.7461 130.507 22.427C130.818 21.765 131.239 21.1693 131.741 20.7043C131.872 20.5776 132.002 20.4723 132.135 20.3675C132.267 20.2627 132.396 20.1787 132.548 20.0724C132.68 19.9889 132.831 19.904 132.983 19.8216C133.048 19.7796 133.135 19.7605 133.199 19.7185C133.244 19.6973 133.285 19.6776 133.307 19.6766C133.351 19.6554 133.393 19.6357 133.415 19.6347C133.566 19.5736 133.74 19.5116 133.891 19.4698C133.935 19.4486 133.978 19.4507 134.02 19.429C134.064 19.4077 134.107 19.4099 134.149 19.3881C134.236 19.3691 134.321 19.3474 134.387 19.3273C134.431 19.306 134.474 19.3082 134.517 19.3083C134.56 19.3084 134.604 19.2892 134.647 19.2893C134.69 19.2894 134.734 19.2702 134.777 19.2703L134.842 19.2502L134.907 19.2513C134.95 19.2515 134.994 19.2323 135.037 19.2324C135.08 19.2325 135.124 19.2133 135.188 19.2145C135.232 19.2146 135.297 19.1944 135.34 19.1965L135.426 19.1988L135.49 19.2L135.511 19.201L135.555 19.2011L135.705 19.2045L135.769 19.2057L135.791 19.2068L135.812 19.2079L135.941 19.2102L136.414 19.2174C136.736 19.2446 137.038 19.2713 137.338 19.3406C137.939 19.4578 138.516 19.6619 139.027 19.9293C139.538 20.1966 140.007 20.505 140.389 20.8564C140.409 20.8788 140.432 20.8997 140.452 20.9221C140.473 20.9445 140.495 20.9654 140.516 20.9878C140.559 21.031 140.599 21.0758 140.664 21.1202C140.707 21.1634 140.747 21.2082 140.79 21.2515C140.833 21.2948 140.874 21.3396 140.917 21.3828C141.087 21.5575 141.233 21.7544 141.381 21.9492C141.654 22.3207 141.885 22.6899 142.051 23.058C142.071 23.0804 142.072 23.1023 142.093 23.1226C142.114 23.143 142.114 23.1669 142.113 23.1882C142.134 23.2324 142.154 23.2741 142.175 23.3184C142.197 23.3626 142.216 23.4043 142.237 23.4485C142.259 23.4928 142.278 23.5345 142.3 23.5787C142.362 23.752 142.423 23.9035 142.465 24.0545C142.547 24.2934 142.607 24.5094 142.646 24.703C142.666 24.7685 142.73 24.8342 142.817 24.8131C142.903 24.8153 142.969 24.752 142.971 24.6662C143.106 24.346 143.111 24.1099 143.093 23.8503L143.089 23.8493Z\" fill=\"#FAC20C\" fill-opacity=\"0.5\"/>\n  <path d=\"M49.6318 167.102C49.9857 160.328 54.1058 159.882 54.2811 159.867C54.3754 159.859 54.4713 159.869 54.5622 159.897L56.3717 160.469C56.9357 159.222 58.1448 155.804 56.7554 151.74C55.8193 149.002 55.8523 146.884 56.8497 145.446C57.9926 143.8 59.9476 143.738 60.0303 143.737C60.0931 143.737 60.1543 143.742 60.2139 143.757L64.5407 144.792L58.5119 118.195C57.422 114.096 57.6453 111.126 59.1752 109.371C60.7332 107.585 63.0438 107.765 63.3647 107.8L115.736 110.486C116.313 110.486 116.836 110.636 117.283 110.841C120.402 112.274 122.152 117.48 122.761 119.651C123.963 123.949 124.233 128.535 123.465 131.624C123.285 132.352 122.734 134.565 121.214 134.602C121.064 134.605 120.901 134.59 120.728 134.542L112.549 133.175C113.369 138.274 114.489 143.705 115.514 148.678C118.339 162.368 119.578 168.976 116.891 169.571C116.548 169.648 116.196 169.646 115.835 169.578C115.311 169.648 113.192 169.904 110.395 169.904C107.994 169.904 105.094 169.712 102.274 169.054C104.362 174.479 105.587 177.89 104.61 179.519C104.314 180.014 103.832 180.315 103.217 180.389C103.063 180.407 102.911 180.415 102.759 180.415C102.159 180.61 99.552 181.384 95.9248 181.384C94.4842 181.384 92.8815 181.261 91.1812 180.932C90.8554 184.842 90.9017 188.757 90.9033 188.825C90.9066 189.061 90.7958 189.286 90.6056 189.424C90.4799 189.515 90.3311 189.562 90.1806 189.562C90.1012 189.562 90.0234 189.549 89.9457 189.522L49.7095 175.687C49.4052 175.582 49.205 175.287 49.2216 174.962C49.2216 174.962 49.3026 173.325 49.6284 167.101L49.6318 167.102Z\" fill=\"white\"/>\n  <path d=\"M49.6318 167.102C49.9857 160.328 54.1058 159.882 54.2811 159.867C54.3754 159.859 54.4713 159.869 54.5622 159.897L56.3717 160.469C56.9357 159.222 58.1448 155.804 56.7554 151.74C55.8193 149.002 55.8523 146.884 56.8497 145.446C57.9926 143.8 59.9476 143.738 60.0303 143.737C60.0931 143.737 60.1543 143.742 60.2139 143.757L64.5407 144.792L58.5119 118.195C57.422 114.096 57.6453 111.126 59.1752 109.371C60.7332 107.585 63.0438 107.765 63.3647 107.8L115.736 110.486C116.313 110.486 116.836 110.636 117.283 110.841C120.402 112.274 122.152 117.48 122.761 119.651C123.963 123.949 124.233 128.535 123.465 131.624C123.285 132.352 122.734 134.565 121.214 134.602C121.064 134.605 120.903 134.59 120.728 134.542L112.549 133.175C113.369 138.274 114.489 143.705 115.514 148.678C118.339 162.368 119.578 168.976 116.891 169.571C116.548 169.648 116.196 169.646 115.835 169.578C115.311 169.648 113.192 169.904 110.395 169.904C107.994 169.904 105.094 169.712 102.274 169.054C104.362 174.479 105.587 177.89 104.61 179.519C104.314 180.014 103.832 180.315 103.217 180.389C103.063 180.407 102.911 180.415 102.759 180.415C102.159 180.61 99.552 181.384 95.9248 181.384C94.4842 181.384 92.8815 181.261 91.1812 180.932C90.8554 184.842 90.9017 188.757 90.9033 188.825C90.9066 189.061 90.7958 189.286 90.6056 189.424C90.4799 189.515 90.3311 189.562 90.1806 189.562C90.1012 189.562 90.0234 189.549 89.9457 189.522L49.7095 175.687C49.4052 175.582 49.205 175.287 49.2216 174.962C49.2216 174.962 49.3026 173.325 49.6284 167.101L49.6318 167.102ZM121.116 133.132L121.193 133.145C121.302 133.117 121.69 132.758 122.061 131.272C122.772 128.414 122.506 124.113 121.366 120.047C120.232 115.991 118.435 112.97 116.679 112.164C116.373 112.023 116.065 111.953 115.756 111.953C114.767 111.953 113.765 112.671 112.766 114.101C111.669 115.67 111.284 118.461 111.358 121.969L115.781 122.622C116.059 122.664 116.287 122.862 116.368 123.133C116.376 123.159 117.162 125.774 118.22 128.351C119.902 132.441 120.868 133.042 121.115 133.132H121.116ZM118.798 132.745C118.244 131.895 117.61 130.668 116.887 128.908C116.05 126.875 115.395 124.865 115.122 123.995L111.416 123.447C111.548 125.942 111.874 128.732 112.314 131.661L118.798 132.743V132.745ZM115.974 168.128C116.004 168.133 116.034 168.14 116.062 168.148C116.246 168.183 116.419 168.186 116.58 168.15C116.588 168.148 117.329 167.837 116.667 162.752C116.199 159.158 115.179 154.21 114.097 148.972C111.161 134.746 107.835 118.622 111.581 113.264C112.003 112.661 112.422 112.177 112.832 111.793L63.2655 109.251C63.2489 109.251 63.2291 109.248 63.2125 109.246C63.1943 109.245 61.375 109.04 60.2519 110.342C59.0842 111.695 58.9668 114.285 59.9112 117.834C59.9129 117.843 59.9162 117.853 59.9178 117.861L66.1086 145.17L100.554 153.415C102.905 153.662 105.606 157.045 108.713 160.94C111.138 163.979 114.095 167.679 115.973 168.13L115.974 168.128ZM113.449 168.339C111.616 166.895 109.636 164.414 107.587 161.849C104.969 158.569 102.003 154.854 100.285 154.854H100.281C100.071 154.854 99.7868 154.907 99.466 155.314C97.9708 157.209 99.8116 162.582 101.641 167.395C105.92 168.584 110.695 168.52 113.449 168.341V168.339ZM103.052 178.946C103.268 178.921 103.333 178.842 103.374 178.771C104.038 177.662 102.374 173.336 100.905 169.52C98.5695 163.448 96.153 157.171 98.333 154.41C98.3413 154.4 98.3495 154.391 98.3561 154.381L59.9873 145.196C59.6912 145.226 58.6409 145.396 58.029 146.29C57.3293 147.313 57.3624 149.033 58.1249 151.268C59.6251 155.66 58.4491 159.339 57.7643 160.91L93.4951 172.203C94.5652 172.484 95.6684 173.632 97.0015 175.021C98.7845 176.877 101.001 179.19 103.052 178.944V178.946ZM100.003 179.574C98.5133 178.693 97.1504 177.271 95.9612 176.031C95.0168 175.047 93.8706 173.852 93.2106 173.629C93.1742 173.624 93.1379 173.616 93.1015 173.604L93.08 173.597C93.0403 173.592 93.0022 173.591 92.9675 173.596C92.8219 173.614 92.6797 173.835 92.6086 173.965C91.9751 175.105 91.5765 177.208 91.3268 179.481C94.8547 180.182 97.979 179.923 100.005 179.574H100.003ZM89.4578 187.82C89.4677 184.839 89.6496 176.311 91.345 173.257C91.378 173.197 91.4128 173.139 91.4492 173.082L54.2943 161.339C53.732 161.463 51.3354 162.283 51.079 167.18C50.8524 171.493 50.7449 173.602 50.7002 174.49L89.4594 187.818L89.4578 187.82Z\" fill=\"#38170F\" stroke=\"#38170F\" stroke-width=\"0.627339\"/>\n  <g clip-path=\"url(#clip0_54475_3665)\">\n    <path d=\"M91.666 170.086C91.4553 170.019 91.2538 169.925 91.0675 169.806C90.9494 169.73 90.8328 169.653 90.7264 169.563C89.7327 168.728 89.4848 167.28 90.132 166.154C90.6999 165.165 91.8217 164.622 92.9187 164.805C94.378 165.047 95.3632 166.348 95.2032 167.822C95.0308 169.409 93.4721 170.511 91.9009 170.157C91.882 170.153 91.7816 170.123 91.6658 170.086L91.666 170.086ZM93.8977 168.374C94.102 168.281 94.1917 168.039 94.0976 167.835C93.9237 167.458 93.7482 167.077 93.5745 166.7C93.4807 166.497 93.2403 166.408 93.0367 166.502L90.7559 167.553C90.5519 167.647 90.4633 167.888 90.5571 168.092L90.5666 168.112C90.6604 168.315 90.9011 168.405 91.1045 168.311C91.6151 168.075 92.1306 167.837 92.6491 167.598C92.8534 167.504 93.0955 167.594 93.1889 167.799C93.2465 167.925 93.3035 168.05 93.3599 168.174C93.453 168.378 93.6937 168.467 93.8976 168.374L93.8977 168.374Z\" fill=\"#70D839\"/>\n  </g>\n  <g clip-path=\"url(#clip1_54475_3665)\">\n    <path d=\"M89.666 162.086C89.4553 162.019 89.2538 161.925 89.0675 161.806C88.9494 161.73 88.8328 161.653 88.7264 161.563C87.7327 160.728 87.4848 159.28 88.132 158.154C88.6999 157.165 89.8217 156.622 90.9187 156.805C92.378 157.047 93.3632 158.348 93.2032 159.822C93.0308 161.409 91.4721 162.511 89.9009 162.157C89.882 162.153 89.7816 162.123 89.6658 162.086L89.666 162.086ZM91.8977 160.374C92.102 160.281 92.1917 160.039 92.0976 159.835C91.9237 159.458 91.7482 159.077 91.5745 158.7C91.4807 158.497 91.2403 158.408 91.0367 158.502L88.7559 159.553C88.5519 159.647 88.4633 159.888 88.5571 160.092L88.5666 160.112C88.6604 160.315 88.9011 160.405 89.1045 160.311C89.6151 160.075 90.1306 159.837 90.6491 159.598C90.8534 159.504 91.0955 159.594 91.1889 159.799C91.2465 159.925 91.3035 160.05 91.3599 160.174C91.453 160.378 91.6937 160.467 91.8976 160.374L91.8977 160.374Z\" fill=\"#70D839\"/>\n  </g>\n  <path d=\"M69.3945 118.617L99.808 120.725\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M69.3945 124.037L99.808 126.145\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M69.3945 129.458L99.808 132.168\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M69.3945 134.878L99.808 137.889\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M69.3945 140.298L99.2057 144.815\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M56.002 167.098L75.9746 174M61.9198 157.176L86.502 164.5M62.6595 152L83.002 158.039\" stroke=\"black\" stroke-opacity=\"0.1\" stroke-width=\"1.88202\" stroke-linecap=\"round\"/>\n  <path d=\"M53.6501 112.828C47.3284 114.211 46.9948 122.133 49.3952 126.82C52.1968 132.288 55.7286 134.343 62.1086 133.081L60.1887 126.946\" fill=\"#F9A01B\"/>\n  <path d=\"M53.5078 112.866C57.4245 111.842 62.1249 114.284 63.1467 119.516C64.1684 124.749 60.3451 127.695 58.6258 128.089L54.6369 129.864L50.207 121.079L53.5078 112.866Z\" fill=\"#F9A01B\"/>\n  <path d=\"M53.6501 112.829C47.3284 114.212 46.9948 122.134 49.3952 126.821\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M53.5078 112.866C57.4245 111.842 62.1249 114.284 63.1466 119.516C63.8488 123.114 62.2625 125.631 60.6436 126.979\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M49.3945 126.82C52.1961 132.288 55.7279 134.343 62.1079 133.081\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M133.07 112.597C128.188 113.08 118.759 118.083 119.757 124.967C120.753 131.851 128.794 132.271 139.009 127.528\" fill=\"#F9A01B\"/>\n  <path d=\"M133.07 112.597C128.188 113.08 118.759 118.083 119.757 124.967C120.753 131.851 128.794 132.271 139.009 127.528\" stroke=\"#38170F\" stroke-width=\"2.19422\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M98.1195 102.247C102.94 105.085 108.425 104.247 112.237 99.5356\" stroke=\"black\" stroke-width=\"2.40181\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <g clip-path=\"url(#clip2_54475_3665)\">\n    <path d=\"M103.399 148.569C103.211 148.556 103.026 148.514 102.85 148.445C102.738 148.402 102.627 148.356 102.522 148.296C101.545 147.739 101.082 146.429 101.423 145.212C101.722 144.145 102.562 143.368 103.51 143.284C104.771 143.171 105.824 144.17 105.951 145.6C106.088 147.141 104.982 148.548 103.608 148.582C103.591 148.583 103.502 148.577 103.399 148.57L103.399 148.569ZM104.959 146.428C105.113 146.292 105.145 146.043 105.031 145.872C104.819 145.556 104.605 145.237 104.393 144.922C104.279 144.751 104.062 144.724 103.909 144.86L102.191 146.389C102.037 146.525 102.006 146.774 102.121 146.944L102.132 146.961C102.246 147.132 102.463 147.16 102.616 147.023C103.001 146.681 103.389 146.335 103.779 145.987C103.933 145.85 104.151 145.879 104.265 146.05C104.336 146.156 104.406 146.261 104.475 146.365C104.588 146.536 104.805 146.564 104.959 146.428L104.959 146.428Z\" fill=\"#70D839\"/>\n  </g>\n  <g clip-path=\"url(#clip3_54475_3665)\">\n    <path d=\"M103.399 140.57C103.211 140.557 103.026 140.515 102.85 140.446C102.738 140.403 102.627 140.357 102.522 140.297C101.545 139.74 101.082 138.43 101.423 137.213C101.722 136.146 102.562 135.369 103.51 135.284C104.771 135.172 105.824 136.171 105.951 137.601C106.088 139.142 104.982 140.549 103.608 140.583C103.591 140.583 103.502 140.578 103.399 140.571L103.399 140.57ZM104.959 138.429C105.113 138.293 105.145 138.044 105.031 137.873C104.819 137.557 104.605 137.238 104.393 136.923C104.279 136.752 104.062 136.725 103.909 136.861L102.191 138.39C102.037 138.526 102.006 138.775 102.121 138.945L102.132 138.962C102.246 139.133 102.463 139.161 102.616 139.024C103.001 138.682 103.389 138.336 103.779 137.988C103.933 137.851 104.151 137.88 104.265 138.051C104.336 138.157 104.406 138.262 104.475 138.366C104.588 138.537 104.805 138.565 104.959 138.429L104.959 138.429Z\" fill=\"#70D839\"/>\n  </g>\n  <g clip-path=\"url(#clip4_54475_3665)\">\n    <path d=\"M103.399 134.57C103.211 134.557 103.026 134.515 102.85 134.446C102.738 134.403 102.627 134.357 102.522 134.297C101.545 133.74 101.082 132.43 101.423 131.213C101.722 130.146 102.562 129.369 103.51 129.284C104.771 129.172 105.824 130.171 105.951 131.601C106.088 133.142 104.982 134.549 103.608 134.583C103.591 134.583 103.502 134.578 103.399 134.571L103.399 134.57ZM104.959 132.429C105.113 132.293 105.145 132.044 105.031 131.873C104.819 131.557 104.605 131.238 104.393 130.923C104.279 130.752 104.062 130.725 103.909 130.861L102.191 132.39C102.037 132.526 102.006 132.775 102.121 132.945L102.132 132.962C102.246 133.133 102.463 133.161 102.616 133.024C103.001 132.682 103.389 132.336 103.779 131.988C103.933 131.851 104.151 131.88 104.265 132.051C104.336 132.157 104.406 132.262 104.475 132.366C104.588 132.537 104.805 132.565 104.959 132.429L104.959 132.429Z\" fill=\"#70D839\"/>\n  </g>\n  <g clip-path=\"url(#clip5_54475_3665)\">\n    <path d=\"M103.399 124.569C103.211 124.556 103.026 124.514 102.85 124.445C102.738 124.402 102.627 124.356 102.522 124.296C101.545 123.739 101.082 122.429 101.423 121.212C101.722 120.145 102.562 119.368 103.51 119.284C104.771 119.171 105.824 120.17 105.951 121.6C106.088 123.141 104.982 124.548 103.608 124.582C103.591 124.583 103.502 124.577 103.399 124.57L103.399 124.569ZM104.959 122.428C105.113 122.292 105.145 122.043 105.031 121.872C104.819 121.556 104.605 121.237 104.393 120.922C104.279 120.751 104.062 120.724 103.909 120.86L102.191 122.389C102.037 122.525 102.006 122.774 102.121 122.944L102.132 122.961C102.246 123.132 102.463 123.16 102.616 123.023C103.001 122.681 103.389 122.335 103.779 121.987C103.933 121.85 104.151 121.879 104.265 122.05C104.336 122.156 104.406 122.261 104.475 122.365C104.588 122.536 104.805 122.564 104.959 122.428L104.959 122.428Z\" fill=\"#70D839\"/>\n  </g>\n  <path d=\"M210.502 25L206.002 31L203.002 28\" stroke=\"#645DB5\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path d=\"M222.008 64L218.027 69.308C217.896 69.4818 217.697 69.5904 217.48 69.6058C217.263 69.6211 217.05 69.5417 216.897 69.388L214.508 67\" stroke=\"#7B76B8\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M216.988 55.6082C217.297 55.2237 217.764 55 218.258 55C218.751 55 219.218 55.2237 219.528 55.6082L221.04 57.4892C221.388 57.9229 221.933 58.1491 222.486 58.0892L224.886 57.8282C225.378 57.7736 225.868 57.9456 226.218 58.2957C226.568 58.6458 226.74 59.1361 226.686 59.6282L226.425 62.0282C226.365 62.581 226.591 63.1262 227.025 63.4742L228.906 64.9862C229.29 65.2956 229.514 65.7626 229.514 66.2562C229.514 66.7498 229.29 67.2168 228.906 67.5262L227.019 69.0312C226.585 69.3798 226.359 69.9252 226.419 70.4782L226.68 72.8782C226.735 73.3705 226.563 73.861 226.213 74.2112C225.863 74.5614 225.372 74.7333 224.88 74.6782L222.48 74.4172C221.927 74.3571 221.382 74.5834 221.034 75.0172L219.528 76.8912C219.219 77.2762 218.752 77.5001 218.258 77.5001C217.764 77.5001 217.297 77.2762 216.988 76.8912L215.477 75.0112C215.128 74.5775 214.583 74.3514 214.03 74.4112L211.63 74.6722C211.137 74.7277 210.647 74.556 210.296 74.2056C209.946 73.8553 209.774 73.3645 209.83 72.8722L210.091 70.4722C210.151 69.9191 209.924 69.3737 209.491 69.0252L207.611 67.5142C207.226 67.205 207.002 66.738 207.002 66.2442C207.002 65.7505 207.226 65.2834 207.611 64.9742L209.491 63.4622C209.925 63.1143 210.151 62.5691 210.091 62.0162L209.83 59.6162C209.775 59.124 209.947 58.6335 210.297 58.2833C210.647 57.933 211.138 57.7612 211.63 57.8162L214.03 58.0772C214.583 58.1369 215.128 57.9108 215.477 57.4772L216.988 55.6082Z\" stroke=\"#7B76B8\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n  <g opacity=\"0.6\">\n    <path d=\"M223.002 119.615H228.234\" stroke=\"#7F73F2\" stroke-width=\"3.1107\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M225.621 117V122.232\" stroke=\"#7F73F2\" stroke-width=\"3.1107\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n    <path d=\"M19.8157 85C21.9185 85 23.6294 86.7109 23.6294 88.8137C23.6294 90.9165 21.9185 92.6274 19.8157 92.6274C17.7128 92.6274 16.002 90.9165 16.002 88.8137C16.002 86.7109 17.7128 85 19.8157 85ZM19.8157 90.0829C20.5187 90.0829 21.0849 89.5105 21.0849 88.8137C21.0849 88.1169 20.5125 87.5445 19.8157 87.5445C19.1189 87.5445 18.5466 88.1169 18.5466 88.8137C18.5466 89.5105 19.1189 90.0829 19.8157 90.0829Z\" fill=\"#5545EF\"/>\n    <path d=\"M198.123 37.6028C197.868 37.6028 197.57 37.5592 197.315 37.4348C197.06 37.3477 196.805 37.1797 196.637 36.9682C196.425 36.8002 196.257 36.5452 196.17 36.2901C196.039 36.035 196.002 35.7799 196.002 35.4813C196.002 34.9276 196.213 34.3739 196.637 33.9944C196.805 33.7829 197.06 33.6149 197.315 33.5278C197.825 33.3163 198.422 33.3163 198.932 33.5278C199.187 33.6149 199.442 33.7829 199.61 33.9944C200.033 34.3739 200.251 34.9276 200.251 35.4813C200.251 35.7799 200.208 36.035 200.083 36.2901C199.996 36.5452 199.828 36.8002 199.617 36.9682C199.449 37.1797 199.194 37.3539 198.938 37.4348C198.683 37.5592 198.428 37.6028 198.13 37.6028H198.123Z\" fill=\"#7F73F2\"/>\n    <path d=\"M35.1978 93H29.3398C28.602 93 28.002 93.6045 28.002 94.3423V100.2C28.002 100.942 28.6064 101.538 29.3442 101.538H35.2022C35.94 101.538 36.54 100.938 36.54 100.196V94.3378C36.54 93.6 35.9355 93 35.1978 93ZM34.54 99.538H30.002V95.0045H34.54V99.538Z\" fill=\"#7C6FFD\"/>\n  </g>\n  <path d=\"M250.324 57.5928V65.3011\" stroke=\"#5545EF\" stroke-width=\"3.1107\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M254.177 61.4443H246.475\" stroke=\"#5545EF\" stroke-width=\"3.1107\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <defs>\n    <clipPath id=\"clip0_54475_3665\">\n      <rect width=\"5.45219\" height=\"5.4418\" fill=\"white\" transform=\"translate(94.1172 170.993) rotate(-159.744)\"/>\n    </clipPath>\n    <clipPath id=\"clip1_54475_3665\">\n      <rect width=\"5.45219\" height=\"5.4418\" fill=\"white\" transform=\"translate(92.1172 162.993) rotate(-159.744)\"/>\n    </clipPath>\n    <clipPath id=\"clip2_54475_3665\">\n      <rect width=\"4.64054\" height=\"5.31007\" fill=\"white\" transform=\"translate(105.605 148.853) rotate(-172.756)\"/>\n    </clipPath>\n    <clipPath id=\"clip3_54475_3665\">\n      <rect width=\"4.64054\" height=\"5.31007\" fill=\"white\" transform=\"translate(105.605 140.854) rotate(-172.756)\"/>\n    </clipPath>\n    <clipPath id=\"clip4_54475_3665\">\n      <rect width=\"4.64054\" height=\"5.31007\" fill=\"white\" transform=\"translate(105.605 134.854) rotate(-172.756)\"/>\n    </clipPath>\n    <clipPath id=\"clip5_54475_3665\">\n      <rect width=\"4.64054\" height=\"5.31007\" fill=\"white\" transform=\"translate(105.605 124.853) rotate(-172.756)\"/>\n    </clipPath>\n  </defs>\n</svg>\n";

"use strict";
const EmptyState = ({
  button,
  children,
  image,
  message,
  hideImage = false,
  variant,
  role
}) => {
  const styles = useStyles2(getStyles$1x);
  const imageToShow = image != null ? image : getDefaultImageForVariant(variant);
  return /* @__PURE__ */ jsxRuntime.jsx(Box, { paddingY: 4, display: "flex", direction: "column", alignItems: "center", role, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    !hideImage && imageToShow,
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", alignItems: "center", children: [
      /* @__PURE__ */ jsxRuntime.jsx(Text, { variant: "h4", textAlignment: "center", children: message }),
      children && /* @__PURE__ */ jsxRuntime.jsx(Text, { color: "secondary", textAlignment: "center", children })
    ] }),
    button
  ] }) });
};
function getDefaultImageForVariant(variant) {
  switch (variant) {
    case "call-to-action": {
      return /* @__PURE__ */ jsxRuntime.jsx(GrotCTA, { width: 300 });
    }
    case "not-found": {
      return /* @__PURE__ */ jsxRuntime.jsx(GrotNotFound, { width: 300 });
    }
    case "completed": {
      return /* @__PURE__ */ jsxRuntime.jsx(SVG__default.default, { src: GrotCompleted, width: 300 });
    }
    default: {
      throw new Error(`Unknown variant: ${variant}`);
    }
  }
}
const getStyles$1x = (theme) => ({
  container: css.css({
    display: "flex",
    flexDirection: "column",
    alignItems: "center",
    gap: theme.spacing(4),
    maxWidth: "600px"
  })
});

"use strict";
function formatCreateLabel(input) {
  return `Custom unit: ${input}`;
}
class UnitPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.onChange = (value) => {
      this.props.onChange(value.value);
    };
  }
  render() {
    const { value, width } = this.props;
    let current = void 0;
    const unitGroups = data.getValueFormats();
    const groupOptions = unitGroups.map((group) => {
      const options = group.submenu.map((unit) => {
        const sel = {
          label: unit.text,
          value: unit.value
        };
        if (unit.value === value) {
          current = sel;
        }
        return sel;
      });
      return {
        label: group.text,
        value: group.text,
        items: options
      };
    });
    if (value && !current) {
      current = { value, label: value };
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      Cascader,
      {
        width,
        initialValue: current && current.label,
        allowCustomValue: true,
        changeOnSelect: false,
        formatCreateLabel,
        options: groupOptions,
        placeholder: t("grafana-ui.unit-picker.placeholder", "Choose"),
        isClearable: true,
        onSelect: this.props.onChange
      }
    );
  }
}

"use strict";
class StatsPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.checkInput = () => {
      const { stats, allowMultiple, defaultStat, onChange } = this.props;
      const current = data.fieldReducers.list(stats);
      if (current.length !== stats.length) {
        const found = current.map((v) => v.id);
        const notFound = lodash.difference(stats, found);
        console.warn("Unknown stats", notFound, stats);
        onChange(current.map((stat) => stat.id));
      }
      if (!allowMultiple && stats.length > 1) {
        console.warn("Removing extra stat", stats);
        onChange([stats[0]]);
      }
      if (defaultStat && stats.length < 1) {
        onChange([defaultStat]);
      }
    };
    this.onSelectionChange = (item) => {
      const { onChange } = this.props;
      if (Array.isArray(item)) {
        onChange(item.map((v) => v.value));
      } else {
        onChange(item && item.value ? [item.value] : []);
      }
    };
  }
  componentDidMount() {
    this.checkInput();
  }
  componentDidUpdate(prevProps) {
    this.checkInput();
  }
  render() {
    const { stats, allowMultiple, defaultStat, placeholder, className, menuPlacement, width, inputId, filterOptions } = this.props;
    const select = data.fieldReducers.selectOptions(stats, filterOptions);
    return /* @__PURE__ */ jsxRuntime.jsx(
      Select,
      {
        value: select.current,
        className,
        isClearable: !defaultStat,
        isMulti: allowMultiple,
        width,
        isSearchable: true,
        options: select.options,
        placeholder,
        onChange: this.onSelectionChange,
        menuPlacement,
        inputId
      }
    );
  }
}
StatsPicker.defaultProps = {
  allowMultiple: false
};

"use strict";
const ButtonSelectComponent = (props) => {
  const { className, options, value, onChange, narrow, variant, ...restProps } = props;
  const styles = useStyles2(getStyles$1w);
  const [isOpen, setIsOpen] = React.useState(false);
  const middleware = [
    react$1.offset(0),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: isOpen,
    placement: "bottom-end",
    onOpenChange: setIsOpen,
    middleware,
    whileElementsMounted: react$1.autoUpdate
  });
  const click = react$1.useClick(context);
  const dismiss = react$1.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
  const onChangeInternal = (item) => {
    onChange(item);
    setIsOpen(false);
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ToolbarButton,
      {
        className,
        isOpen,
        narrow,
        variant,
        ref: refs.setReference,
        ...getReferenceProps(),
        ...restProps,
        children: (value == null ? void 0 : value.label) || ((value == null ? void 0 : value.value) != null ? String(value == null ? void 0 : value.value) : null)
      }
    ),
    isOpen && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.menuWrapper, ref: refs.setFloating, ...getFloatingProps(), style: floatingStyles, children: /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx(Menu, { tabIndex: -1, onClose: () => setIsOpen(false), children: options.map((item) => {
      var _a;
      return /* @__PURE__ */ jsxRuntime.jsx(
        MenuItem,
        {
          label: (_a = item.label) != null ? _a : String(item.value),
          onClick: () => onChangeInternal(item),
          active: item.value === (value == null ? void 0 : value.value),
          ariaChecked: item.value === (value == null ? void 0 : value.value),
          ariaLabel: item.ariaLabel || item.label,
          disabled: item.isDisabled,
          component: item.component,
          role: "menuitemradio"
        },
        `${item.value}`
      );
    }) }) }) })
  ] });
};
ButtonSelectComponent.displayName = "ButtonSelect";
const ButtonSelect = React.memo(ButtonSelectComponent);
const getStyles$1w = (theme) => {
  return {
    wrapper: css.css({
      position: "relative",
      display: "inline-flex"
    }),
    menuWrapper: css.css({
      zIndex: theme.zIndex.dropdown
    })
  };
};

"use strict";
const defaultIntervals = ["5s", "10s", "30s", "1m", "5m", "15m", "30m", "1h", "2h", "1d"];
const _RefreshPicker = class _RefreshPicker extends React.PureComponent {
  constructor(props) {
    super(props);
    this.onChangeSelect = (item) => {
      const { onIntervalChanged } = this.props;
      if (onIntervalChanged && item.value != null) {
        onIntervalChanged(item.value);
      }
    };
  }
  getVariant() {
    if (this.props.isLive) {
      return "primary";
    }
    if (this.props.primary) {
      return "primary";
    }
    return this.props.isOnCanvas ? "canvas" : "default";
  }
  render() {
    const { onRefresh, intervals, tooltip, value, text, isLoading, noIntervalPicker, width, showAutoInterval } = this.props;
    const currentValue = value || "";
    const variant = this.getVariant();
    const options = intervalsToOptions({ intervals, showAutoInterval });
    const option = options.find(({ value: value2 }) => value2 === currentValue);
    const translatedOffOption = translateOption(_RefreshPicker.offOption.value);
    let selectedValue = option || translatedOffOption;
    if (selectedValue.label === translatedOffOption.label) {
      selectedValue = { value: "" };
    }
    const durationAriaLabel = selectedValue.ariaLabel;
    const ariaLabelDurationSelectedMessage = t(
      "refresh-picker.aria-label.duration-selected",
      "Choose refresh time interval with current interval {{durationAriaLabel}} selected",
      { durationAriaLabel }
    );
    const ariaLabelChooseIntervalMessage = t(
      "refresh-picker.aria-label.choose-interval",
      "Auto refresh turned off. Choose refresh time interval"
    );
    const ariaLabel = selectedValue.value === "" ? ariaLabelChooseIntervalMessage : ariaLabelDurationSelectedMessage;
    const tooltipIntervalSelected = t("refresh-picker.tooltip.interval-selected", "Set auto refresh interval");
    const tooltipAutoRefreshOff = t("refresh-picker.tooltip.turned-off", "Auto refresh off");
    const tooltipAutoRefresh = selectedValue.value === "" ? tooltipAutoRefreshOff : tooltipIntervalSelected;
    return /* @__PURE__ */ jsxRuntime.jsxs(ButtonGroup, { className: "refresh-picker", children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ToolbarButton,
        {
          "aria-label": text,
          tooltip,
          onClick: onRefresh,
          variant,
          icon: isLoading ? "spinner" : "sync",
          style: width ? { width } : void 0,
          "data-testid": e2eSelectors.selectors.components.RefreshPicker.runButtonV2,
          children: text
        }
      ),
      !noIntervalPicker && /* @__PURE__ */ jsxRuntime.jsx(
        ButtonSelect,
        {
          className: css.css({
            borderTopLeftRadius: 0,
            borderBottomLeftRadius: 0
          }),
          value: selectedValue,
          options,
          onChange: this.onChangeSelect,
          variant,
          "data-testid": e2eSelectors.selectors.components.RefreshPicker.intervalButtonV2,
          "aria-label": ariaLabel,
          tooltip: tooltipAutoRefresh
        }
      )
    ] });
  }
};
_RefreshPicker.offOption = {
  label: "Off",
  value: "",
  ariaLabel: "Turn off auto refresh"
};
_RefreshPicker.liveOption = {
  label: "Live",
  value: "LIVE",
  ariaLabel: "Turn on live streaming"
};
_RefreshPicker.autoOption = {
  label: "Auto",
  value: "auto",
  ariaLabel: "Select refresh from the query range"
};
_RefreshPicker.isLive = (refreshInterval) => refreshInterval === _RefreshPicker.liveOption.value;
let RefreshPicker = _RefreshPicker;
function translateOption(option) {
  switch (option) {
    case RefreshPicker.liveOption.value:
      return {
        label: t("refresh-picker.live-option.label", "Live"),
        value: option,
        ariaLabel: t("refresh-picker.live-option.aria-label", "Turn on live streaming")
      };
    case RefreshPicker.offOption.value:
      return {
        label: t("refresh-picker.off-option.label", "Off"),
        value: option,
        ariaLabel: t("refresh-picker.off-option.aria-label", "Turn off auto refresh")
      };
    case RefreshPicker.autoOption.value:
      return {
        label: t("refresh-picker.auto-option.label", RefreshPicker.autoOption.label),
        value: option,
        ariaLabel: t("refresh-picker.auto-option.aria-label", RefreshPicker.autoOption.ariaLabel)
      };
  }
  return {
    label: option,
    value: option
  };
}
function intervalsToOptions({
  intervals = defaultIntervals,
  showAutoInterval = false
} = {}) {
  const options = intervals.map((interval) => {
    const duration = data.parseDuration(interval);
    const ariaLabel = dateFns.formatDuration(duration);
    return {
      label: interval,
      value: interval,
      ariaLabel
    };
  });
  if (showAutoInterval) {
    options.unshift(translateOption(RefreshPicker.autoOption.value));
  }
  options.unshift(translateOption(RefreshPicker.offOption.value));
  return options;
}

"use strict";
const getModalStyles = (theme) => {
  const borderRadius = theme.shape.radius.default;
  return {
    modal: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modal,
      background: theme.colors.background.primary,
      boxShadow: theme.shadows.z3,
      borderRadius,
      border: `1px solid ${theme.colors.border.weak}`,
      backgroundClip: "padding-box",
      outline: "none",
      width: "750px",
      maxWidth: "100%",
      left: 0,
      right: 0,
      marginLeft: "auto",
      marginRight: "auto",
      top: "10%",
      maxHeight: "80%",
      display: "flex",
      flexDirection: "column"
    }),
    modalBackdrop: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modalBackdrop,
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      backgroundColor: theme.components.overlay.background
    }),
    modalHeader: css.css({
      label: "modalHeader",
      display: "flex",
      alignItems: "center",
      minHeight: "42px",
      margin: theme.spacing(1, 2, 0, 2)
    }),
    modalHeaderWithTabs: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    modalHeaderTitle: css.css({
      fontSize: theme.typography.size.lg,
      margin: theme.spacing(0, 4, 0, 1),
      display: "flex",
      alignItems: "center",
      position: "relative",
      top: "2px"
    }),
    modalHeaderIcon: css.css({
      marginRight: theme.spacing(2),
      fontSize: "inherit",
      "&:before": {
        verticalAlign: "baseline"
      }
    }),
    modalHeaderClose: css.css({
      height: "100%",
      display: "flex",
      alignItems: "center",
      color: theme.colors.text.secondary,
      flexGrow: 1,
      justifyContent: "flex-end"
    }),
    modalContent: css.css({
      overflow: "auto",
      padding: theme.spacing(3),
      width: "100%"
    }),
    modalButtonRow: css.css({
      paddingTop: theme.spacing(3)
    })
  };
};

"use strict";
function useCombinedRefs(...refs) {
  const targetRef = React__namespace.useRef(null);
  React__namespace.useEffect(() => {
    refs.forEach((ref) => {
      if (!ref) {
        return;
      }
      if (typeof ref === "function") {
        ref(targetRef.current);
      } else {
        ref.current = targetRef.current;
      }
    });
  }, [refs]);
  return targetRef;
}

"use strict";
const FilterInput = React.forwardRef(
  ({ value, width, onChange, escapeRegex = true, ...restProps }, ref) => {
    const innerRef = React.useRef(null);
    const combinedRef = useCombinedRefs(ref, innerRef);
    const suffix = value !== "" ? /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        icon: "times",
        fill: "text",
        size: "sm",
        onClick: (e) => {
          var _a;
          (_a = innerRef.current) == null ? void 0 : _a.focus();
          onChange("");
          e.stopPropagation();
        },
        children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.filter-input.clear", children: "Clear" })
      }
    ) : null;
    return /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        prefix: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "search" }),
        suffix,
        width,
        type: "text",
        value: escapeRegex ? data.unEscapeStringFromRegex(value != null ? value : "") : value,
        onChange: (event) => onChange(escapeRegex ? data.escapeStringForRegex(event.currentTarget.value) : event.currentTarget.value),
        ...restProps,
        ref: combinedRef
      }
    );
  }
);
FilterInput.displayName = "FilterInput";

"use strict";
const AutoSizeInput = React__namespace.forwardRef((props, ref) => {
  const {
    defaultValue = "",
    minWidth = 10,
    maxWidth,
    onCommitChange,
    onChange,
    onKeyDown,
    onBlur,
    value: controlledValue,
    placeholder,
    ...restProps
  } = props;
  const [inputState, setInputValue] = useControlledState(controlledValue, onChange);
  const inputValue = inputState != null ? inputState : defaultValue;
  const inputWidth = React.useMemo(() => {
    const displayValue = inputValue || placeholder || "";
    const valueString = typeof displayValue === "string" ? displayValue : displayValue.toString();
    return getWidthFor(valueString, minWidth, maxWidth);
  }, [placeholder, inputValue, minWidth, maxWidth]);
  return /* @__PURE__ */ jsxRuntime.jsx(AutoSizeInputContext.Provider, { value: true, children: /* @__PURE__ */ jsxRuntime.jsx(
    Input,
    {
      "data-testid": "autosize-input",
      ...restProps,
      placeholder,
      ref,
      value: inputValue.toString(),
      onChange: (event) => {
        if (onChange) {
          onChange(event);
        }
        setInputValue(event.currentTarget.value);
      },
      width: inputWidth,
      onBlur: (event) => {
        if (onBlur) {
          onBlur(event);
        } else if (onCommitChange) {
          onCommitChange(event);
        }
      },
      onKeyDown: (event) => {
        if (onKeyDown) {
          onKeyDown(event);
        } else if (event.key === "Enter" && onCommitChange) {
          onCommitChange(event);
        }
      }
    }
  ) });
});
function getWidthFor(value, minWidth, maxWidth) {
  if (!value) {
    return minWidth;
  }
  const extraSpace = 3;
  const realWidth = measureText(value.toString(), 14).width / 8 + extraSpace;
  if (minWidth && realWidth < minWidth) {
    return minWidth;
  }
  if (maxWidth && realWidth > maxWidth) {
    return maxWidth;
  }
  return realWidth;
}
AutoSizeInput.displayName = "AutoSizeInput";
function useControlledState(controlledValue, onChange) {
  const isControlledNow = controlledValue !== void 0 && onChange !== void 0;
  const isControlledRef = React.useRef(isControlledNow);
  const hasLoggedControlledWarning = React.useRef(false);
  if (isControlledNow !== isControlledRef.current && !hasLoggedControlledWarning.current) {
    console.warn(
      "An AutoSizeInput is changing from an uncontrolled to a controlled input. If you want to control the input, the empty value should be an empty string."
    );
    hasLoggedControlledWarning.current = true;
  }
  const [internalValue, setInternalValue] = React__namespace.useState(controlledValue);
  React.useEffect(() => {
    if (!isControlledRef.current) {
      setInternalValue(controlledValue);
    }
  }, [controlledValue]);
  const handleChange = React.useCallback((newValue) => {
    if (!isControlledRef.current) {
      setInternalValue(newValue);
    }
  }, []);
  const value = isControlledRef.current ? controlledValue : internalValue;
  return [value, handleChange];
}

"use strict";
const Label$1 = ({ children, description, className, category, ...labelProps }) => {
  const styles = useStyles2(getLabelStyles$3);
  const categories = category == null ? void 0 : category.map((c, i) => {
    return /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.categories, children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { children: c }),
      /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right", className: styles.chevron })
    ] }, `${c}/${i}`);
  });
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.label, className), children: /* @__PURE__ */ jsxRuntime.jsxs("label", { ...labelProps, children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.labelContent, children: [
      categories,
      children
    ] }),
    description && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.description, children: description })
  ] }) });
};
const getLabelStyles$3 = (theme) => ({
  label: css.css({
    label: "Label",
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightMedium,
    lineHeight: 1.25,
    marginBottom: theme.spacing(0.5),
    color: theme.colors.text.primary,
    maxWidth: "480px"
  }),
  labelContent: css.css({
    display: "flex",
    alignItems: "center"
  }),
  description: css.css({
    label: "Label-description",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightRegular,
    marginTop: theme.spacing(0.25),
    display: "block"
  }),
  categories: css.css({
    label: "Label-categories",
    display: "inline-flex",
    alignItems: "center"
  }),
  chevron: css.css({
    margin: theme.spacing(0, 0.25)
  })
});

"use strict";
const Checkbox = React__namespace.forwardRef(
  ({ label, description, value, htmlValue, onChange, disabled, className, indeterminate, invalid, ...inputProps }, ref) => {
    const handleOnChange = React.useCallback(
      (e) => {
        if (onChange) {
          onChange(e);
        }
      },
      [onChange]
    );
    const styles = useStyles2(getCheckboxStyles, invalid);
    const ariaChecked = indeterminate ? "mixed" : void 0;
    return /* @__PURE__ */ jsxRuntime.jsxs("label", { className: css.cx(styles.wrapper, className), children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.checkboxWrapper, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          "input",
          {
            type: "checkbox",
            className: css.cx(styles.input, indeterminate && styles.inputIndeterminate),
            checked: value,
            disabled,
            onChange: handleOnChange,
            value: htmlValue,
            "aria-checked": ariaChecked,
            ...inputProps,
            ref
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.checkmark })
      ] }),
      label && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
      description && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.description, children: description })
    ] });
  }
);
const getCheckboxStyles = (theme, invalid = false) => {
  const labelStyles = getLabelStyles$3(theme);
  const checkboxSize = 2;
  const labelPadding = 1;
  const getBorderColor = (color) => {
    return invalid ? theme.colors.error.border : color;
  };
  return {
    wrapper: css.css({
      display: "inline-grid",
      alignItems: "center",
      columnGap: theme.spacing(labelPadding),
      // gridAutoRows is needed to prevent https://github.com/grafana/grafana/issues/68570 in safari
      gridAutoRows: "max-content",
      position: "relative",
      verticalAlign: "middle"
    }),
    input: css.css({
      position: "absolute",
      zIndex: 1,
      top: 0,
      left: 0,
      width: "100% !important",
      // global styles unset this
      height: "100%",
      opacity: 0,
      "&:focus + span, &:focus-visible + span": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + span": getMouseFocusStyles(theme),
      /**
       * Using adjacent sibling selector to style checked state.
       * Primarily to limit the classes necessary to use when these classes will be used
       * for angular components styling
       * */
      "&:checked + span": {
        background: theme.colors.primary.main,
        border: `1px solid ${getBorderColor(theme.colors.primary.main)}`,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        "&:after": {
          content: '""',
          position: "absolute",
          zIndex: 2,
          left: theme.spacing(0.5),
          top: 0,
          width: theme.spacing(0.75),
          height: theme.spacing(1.5),
          border: `solid ${theme.colors.primary.contrastText}`,
          borderWidth: "0 3px 3px 0",
          transform: "rotate(45deg)"
        }
      },
      "&:disabled + span": {
        backgroundColor: theme.colors.action.disabledBackground,
        cursor: "not-allowed",
        border: `1px solid ${getBorderColor(theme.colors.action.disabledBackground)}`,
        "&:hover": {
          backgroundColor: theme.colors.action.disabledBackground
        },
        "&:after": {
          borderColor: theme.colors.action.disabledText
        }
      }
    }),
    inputIndeterminate: css.css({
      "&[aria-checked='mixed'] + span": {
        border: `1px solid ${getBorderColor(theme.colors.primary.main)}`,
        background: theme.colors.primary.main,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        "&:after": {
          content: '""',
          position: "absolute",
          zIndex: 2,
          left: "2px",
          right: "2px",
          top: "calc(50% - 1.5px)",
          height: "3px",
          border: `1.5px solid ${theme.colors.primary.contrastText}`,
          backgroundColor: theme.colors.primary.contrastText,
          width: "auto",
          transform: "none"
        }
      },
      "&:disabled[aria-checked='mixed'] + span": {
        backgroundColor: theme.colors.action.disabledBackground,
        border: `1px solid ${getBorderColor(theme.colors.error.transparent)}`,
        "&:after": {
          borderColor: theme.colors.action.disabledText
        }
      }
    }),
    checkboxWrapper: css.css({
      display: "flex",
      alignItems: "center",
      gridColumnStart: 1,
      gridRowStart: 1
    }),
    checkmark: css.css({
      position: "relative",
      zIndex: 2,
      display: "inline-block",
      width: theme.spacing(checkboxSize),
      height: theme.spacing(checkboxSize),
      borderRadius: theme.shape.radius.default,
      background: theme.components.input.background,
      border: `1px solid ${getBorderColor(theme.components.input.borderColor)}`,
      "&:hover": {
        cursor: "pointer",
        borderColor: getBorderColor(theme.components.input.borderHover)
      }
    }),
    label: css.cx(
      labelStyles.label,
      css.css({
        gridColumnStart: 2,
        gridRowStart: 1,
        position: "relative",
        zIndex: 2,
        cursor: "pointer",
        maxWidth: "fit-content",
        lineHeight: theme.typography.bodySmall.lineHeight,
        marginBottom: 0
      })
    ),
    description: css.cx(
      labelStyles.description,
      css.css({
        gridColumnStart: 2,
        gridRowStart: 2,
        lineHeight: theme.typography.bodySmall.lineHeight,
        marginTop: 0,
        // Enable interacting with description when checkbox is disabled
        zIndex: 1
      })
    )
  };
};
Checkbox.displayName = "Checkbox";

"use strict";
const AsyncError = () => /* @__PURE__ */ jsxRuntime.jsxs(MessageRow, { children: [
  /* @__PURE__ */ jsxRuntime.jsx(Text, { color: "warning", children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "exclamation-triangle", size: "md" }) }),
  /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "combobox.async.error", children: "An error occurred while loading options." })
] });
const NotFoundError = () => /* @__PURE__ */ jsxRuntime.jsx(MessageRow, { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "combobox.options.no-found", children: "No options found." }) });
const MessageRow = ({ children }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Box, { padding: 2, children: /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "center", alignItems: "center", direction: "column", children }) });
};

"use strict";
const MENU_ITEM_FONT_SIZE = 14;
const MENU_ITEM_DESCRIPTION_FONT_SIZE = 12;
const MENU_ITEM_FONT_WEIGHT = 500;
const MENU_ITEM_PADDING = 8;
const MENU_ITEM_GAP = 2;
const MENU_ITEM_LINE_HEIGHT = 1.5;
const MENU_OPTION_HEIGHT = MENU_ITEM_GAP + MENU_ITEM_PADDING * 2 + MENU_ITEM_FONT_SIZE * MENU_ITEM_LINE_HEIGHT;
const MENU_OPTION_HEIGHT_DESCRIPTION = MENU_OPTION_HEIGHT + MENU_ITEM_DESCRIPTION_FONT_SIZE * MENU_ITEM_LINE_HEIGHT;
const POPOVER_MAX_HEIGHT = MENU_OPTION_HEIGHT * 8.5;
const getComboboxStyles = (theme) => {
  return {
    menuClosed: css.css({
      display: "none"
    }),
    menu: css.css({
      label: "combobox-menu",
      background: theme.components.dropdown.background,
      boxShadow: theme.shadows.z3,
      zIndex: theme.zIndex.dropdown,
      position: "relative",
      borderRadius: theme.shape.radius.default,
      overflow: "hidden"
    }),
    menuUlContainer: css.css({
      label: "combobox-menu-ul-container",
      listStyle: "none"
    }),
    // The wrapper around the group header and option, not the option itself.
    // Should not contain visual styling itself.
    listItem: css.css({
      label: "list-item",
      position: "absolute",
      width: "100%"
    }),
    optionGroupHeader: css.css({
      label: "combobox-new-option-group",
      borderTop: `1px solid ${theme.colors.border.weak}`
    }),
    optionFirstGroupHeader: css.css({
      borderTop: "none"
    }),
    optionGroupLabel: css.css({
      textOverflow: "ellipsis",
      overflow: "hidden",
      letterSpacing: 0,
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightLight,
      padding: MENU_ITEM_PADDING
    }),
    option: css.css({
      label: "combobox-option",
      position: "relative",
      // for the selection gradient to grab to
      display: "flex",
      width: "100%",
      gap: theme.spacing(1),
      alignItems: "center",
      padding: MENU_ITEM_PADDING,
      marginBottom: MENU_ITEM_GAP,
      borderRadius: theme.shape.radius.default,
      fontWeight: theme.typography.fontWeightMedium,
      whiteSpace: "nowrap",
      overflow: "hidden",
      cursor: "pointer",
      "&:hover": {
        background: theme.colors.action.hover,
        "@media (forced-colors: active), (prefers-contrast: more)": {
          border: `1px solid ${theme.colors.primary.border}`
        }
      }
    }),
    optionAccessory: css.css({
      label: "combobox-option-accessory",
      height: MENU_ITEM_FONT_SIZE * MENU_ITEM_LINE_HEIGHT
      // Ensure the accessory doesn't make the option too tall
    }),
    optionBody: css.css({
      label: "combobox-option-body",
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      overflow: "hidden"
    }),
    optionLabel: css.css({
      label: "combobox-option-label",
      fontSize: MENU_ITEM_FONT_SIZE,
      fontWeight: MENU_ITEM_FONT_WEIGHT,
      lineHeight: MENU_ITEM_LINE_HEIGHT,
      letterSpacing: 0,
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    optionDescription: css.css({
      label: "combobox-option-description",
      color: theme.colors.text.secondary,
      fontSize: MENU_ITEM_DESCRIPTION_FONT_SIZE,
      fontWeight: theme.typography.fontWeightRegular,
      lineHeight: MENU_ITEM_LINE_HEIGHT,
      letterSpacing: 0,
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    optionFocused: css.css({
      label: "combobox-option-focused",
      // top: 0,
      background: theme.colors.action.focus,
      "@media (forced-colors: active), (prefers-contrast: more)": {
        border: `1px solid ${theme.colors.primary.border}`
      }
    }),
    optionSelected: css.css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        width: theme.spacing(0.5),
        left: 0,
        top: 0
      }
    }),
    clear: css.css({
      label: "combobox-clear",
      cursor: "pointer",
      pointerEvents: "auto",
      "&:hover": {
        color: theme.colors.text.primary
      }
    }),
    input: css.css({
      label: "combobox-input",
      "> div > div:last-child": {
        pointerEvents: "none"
      },
      "& input": {
        cursor: "pointer"
      },
      "& input:focus": {
        cursor: "text"
      }
    }),
    addaptToParent: css.css({
      label: "combobox-addapt-to-parent",
      maxWidth: "100%",
      '[class*="input-wrapper-combobox-input"]': {
        maxWidth: "100%"
      }
    })
  };
};

"use strict";
const ALL_OPTION_VALUE = "__GRAFANA_INTERNAL_MULTICOMBOBOX_ALL_OPTION__";

"use strict";
const isNewGroup = (option, prevOption) => {
  const currentGroup = option.group;
  if (!currentGroup) {
    return (prevOption == null ? void 0 : prevOption.group) ? true : false;
  }
  if (!prevOption) {
    return true;
  }
  return prevOption.group !== currentGroup;
};

"use strict";
const VIRTUAL_OVERSCAN_ITEMS$1 = 4;
const ComboboxList = ({
  options,
  highlightedIndex,
  selectedItems = [],
  scrollRef,
  getItemProps,
  enableAllOption,
  isMultiSelect = false,
  error = false
}) => {
  const styles = useStyles2(getComboboxStyles);
  const estimateSize = React.useCallback(
    (index) => {
      const firstGroupItem = isNewGroup(options[index], index > 0 ? options[index - 1] : void 0);
      const hasDescription = "description" in options[index];
      const hasGroup = "group" in options[index];
      let itemHeight = MENU_OPTION_HEIGHT;
      if (hasDescription) {
        itemHeight = MENU_OPTION_HEIGHT_DESCRIPTION;
      }
      if (firstGroupItem && hasGroup) {
        itemHeight += MENU_OPTION_HEIGHT;
      }
      return itemHeight;
    },
    [options]
  );
  const rowVirtualizer = reactVirtual.useVirtualizer({
    count: options.length,
    getScrollElement: () => scrollRef.current,
    estimateSize,
    overscan: VIRTUAL_OVERSCAN_ITEMS$1
  });
  const isOptionSelected = React.useCallback(
    (item) => selectedItems.some((opt) => opt.value === item.value),
    [selectedItems]
  );
  const allItemsSelected = enableAllOption && selectedItems.length === options.length - 1;
  return /* @__PURE__ */ jsxRuntime.jsxs(ScrollContainer, { showScrollIndicators: true, maxHeight: "inherit", ref: scrollRef, padding: 0.5, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { style: { height: rowVirtualizer.getTotalSize() }, className: styles.menuUlContainer, children: rowVirtualizer.getVirtualItems().map((virtualRow, index, allVirtualRows) => {
      var _a;
      const item = options[virtualRow.index];
      const startingNewGroup = isNewGroup(item, options[virtualRow.index - 1]);
      const groupHeaderIndex = allVirtualRows.find((row) => {
        const rowItem = options[row.index];
        return rowItem.group === item.group;
      });
      const groupHeaderItem = groupHeaderIndex && options[groupHeaderIndex.index];
      const itemId = `combobox-option-${item.value}`;
      const groupHeaderId = groupHeaderItem ? `combobox-option-group-${groupHeaderItem.value}` : void 0;
      return (
        // Wrapping div should have no styling other than virtual list positioning.
        // It's children (header and option) should appear as flat list items.
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            className: styles.listItem,
            style: {
              height: virtualRow.size,
              transform: `translateY(${virtualRow.start}px)`
            },
            children: [
              startingNewGroup && /* @__PURE__ */ jsxRuntime.jsx(
                "div",
                {
                  role: "presentation",
                  "data-testid": "combobox-option-group",
                  id: groupHeaderId,
                  className: css.cx(
                    styles.optionGroupHeader,
                    item.group && styles.optionGroupLabel,
                    virtualRow.index === 0 && styles.optionFirstGroupHeader
                  ),
                  children: item.group
                }
              ),
              /* @__PURE__ */ jsxRuntime.jsxs(
                "div",
                {
                  className: css.cx(
                    styles.option,
                    !isMultiSelect && isOptionSelected(item) && styles.optionSelected,
                    highlightedIndex === virtualRow.index && styles.optionFocused
                  ),
                  ...getItemProps({
                    item,
                    index: virtualRow.index,
                    id: itemId,
                    "aria-describedby": groupHeaderId
                  }),
                  children: [
                    isMultiSelect && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionAccessory, children: /* @__PURE__ */ jsxRuntime.jsx(
                      Checkbox,
                      {
                        value: allItemsSelected || isOptionSelected(item),
                        indeterminate: item.value === ALL_OPTION_VALUE && selectedItems.length > 0 && !allItemsSelected,
                        "aria-labelledby": itemId,
                        onClick: (e) => {
                          e.stopPropagation();
                        }
                      },
                      itemId
                    ) }),
                    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.optionBody, children: [
                      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionLabel, children: (_a = item.label) != null ? _a : item.value }),
                      item.description && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionDescription, children: item.description })
                    ] })
                  ]
                }
              )
            ]
          },
          item.value
        )
      );
    }) }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { "aria-live": "polite", children: [
      error && /* @__PURE__ */ jsxRuntime.jsx(AsyncError, {}),
      options.length === 0 && !error && /* @__PURE__ */ jsxRuntime.jsx(NotFoundError, {})
    ] })
  ] });
};

"use strict";
const REGEXP_NON_ASCII = /[^ -~]/m;
const REGEXP_ONLY_SYMBOLS = /^[\x21-\x2F\x3A-\x40\x5B-\x60\x7B-\x7E]+$/m;
const outOfOrderLimit = 5;
const maxNeedleLength = 25;
const maxFuzzyTerms = 5;
const rankThreshold = 1e4;
const uf = new uFuzzy__default.default({ intraMode: 1 });
function itemToString(item) {
  var _a;
  if (item == null) {
    return "";
  }
  return (_a = item.label) != null ? _a : item.value.toString();
}
function itemFilter(inputValue) {
  const lowerCasedInputValue = inputValue.toLowerCase();
  return (item) => {
    var _a, _b;
    return !inputValue || ((_a = item.label) == null ? void 0 : _a.toLowerCase().includes(lowerCasedInputValue)) || ((_b = item.value) == null ? void 0 : _b.toString().toLowerCase().includes(lowerCasedInputValue)) || item.value.toString() === ALL_OPTION_VALUE;
  };
}
function fuzzyFind(options, haystack, needle) {
  let matches = [];
  if (needle === "") {
    matches = options;
  } else if (
    // contains non-ascii
    REGEXP_NON_ASCII.test(needle) || // is only ascii symbols (operators)
    REGEXP_ONLY_SYMBOLS.test(needle) || // too long (often copy-paste from somewhere)
    needle.length > maxNeedleLength || uf.split(needle).length > maxFuzzyTerms
  ) {
    for (let i = 0; i < haystack.length; i++) {
      let item = haystack[i];
      if (item.includes(needle)) {
        matches.push(options[i]);
      }
    }
  } else {
    const [idxs, info, order] = uf.search(haystack, needle, outOfOrderLimit, rankThreshold);
    if (idxs == null ? void 0 : idxs.length) {
      if (info && order) {
        matches = order.map((idx) => options[info.idx[idx]]);
      } else {
        matches = idxs.map((idx) => options[idx]);
      }
    }
  }
  return matches;
}

"use strict";
const WIDTH_CALCULATION_LIMIT_ITEMS = 1e5;
const POPOVER_PADDING = 16;
const SCROLL_CONTAINER_PADDING = 8;
const useComboboxFloat = (items, isOpen) => {
  var _a;
  const inputRef = React.useRef(null);
  const floatingRef = React.useRef(null);
  const scrollRef = React.useRef(null);
  const [popoverMaxSize, setPopoverMaxSize] = React.useState({
    width: 0,
    height: 0
  });
  const scrollbarWidth = React.useMemo(() => getScrollbarWidth(), []);
  const middleware = [
    react$1.autoPlacement({
      // see https://floating-ui.com/docs/autoplacement
      allowedPlacements: ["bottom-start", "bottom-end", "top-start", "top-end"],
      boundary: document.body,
      crossAxis: true
    }),
    react$1.size({
      apply({ availableWidth, availableHeight }) {
        const preferredMaxWidth = availableWidth - POPOVER_PADDING;
        const preferredMaxHeight = availableHeight - POPOVER_PADDING;
        const width = Math.max(preferredMaxWidth, 0);
        const height = Math.min(Math.max(preferredMaxHeight, MENU_OPTION_HEIGHT * 6), POPOVER_MAX_HEIGHT);
        setPopoverMaxSize({ width, height });
      }
    })
  ];
  const elements = { reference: inputRef.current, floating: floatingRef.current };
  const { floatingStyles } = react$1.useFloating({
    strategy: "fixed",
    open: isOpen,
    placement: "bottom-start",
    middleware,
    elements,
    whileElementsMounted: react$1.autoUpdate
  });
  const longestItemWidth = React.useMemo(() => {
    var _a2;
    let longestItem = "";
    const itemsToLookAt = Math.min(items.length, WIDTH_CALCULATION_LIMIT_ITEMS);
    for (let i = 0; i < itemsToLookAt; i++) {
      const itemLabel = (_a2 = items[i].label) != null ? _a2 : items[i].value.toString();
      longestItem = itemLabel.length > longestItem.length ? itemLabel : longestItem;
    }
    const size2 = measureText(longestItem, MENU_ITEM_FONT_SIZE, MENU_ITEM_FONT_WEIGHT).width;
    return size2 + SCROLL_CONTAINER_PADDING + MENU_ITEM_PADDING * 2 + scrollbarWidth;
  }, [items, scrollbarWidth]);
  const floatStyles = {
    ...floatingStyles,
    width: longestItemWidth,
    maxWidth: popoverMaxSize.width,
    minWidth: (_a = inputRef.current) == null ? void 0 : _a.offsetWidth,
    maxHeight: popoverMaxSize.height
  };
  return { inputRef, floatingRef, scrollRef, floatStyles };
};
function getScrollbarWidth() {
  var _a;
  const outer = document.createElement("div");
  outer.style.visibility = "hidden";
  outer.style.overflow = "scroll";
  document.body.appendChild(outer);
  const inner = document.createElement("div");
  outer.appendChild(inner);
  const scrollbarWidth = outer.offsetWidth - inner.offsetWidth;
  (_a = outer.parentNode) == null ? void 0 : _a.removeChild(outer);
  return scrollbarWidth;
}

"use strict";
function useLatestAsyncCall(fn) {
  const latestValueCount = React.useRef(0);
  const wrappedFn = React.useCallback(
    (value) => {
      latestValueCount.current++;
      const requestCount = latestValueCount.current;
      return new Promise((resolve, reject) => {
        fn(value).then((result) => {
          if (requestCount === latestValueCount.current) {
            resolve(result);
          } else {
            reject(new StaleResultError());
          }
        }).catch(reject);
      });
    },
    [fn]
  );
  return wrappedFn;
}
class StaleResultError extends Error {
  constructor() {
    super("This result is stale and is discarded");
    this.name = "StaleResultError";
    Object.setPrototypeOf(this, new.target.prototype);
  }
}

"use strict";
const asyncNoop = () => Promise.resolve([]);
function useOptions(rawOptions, createCustomValue) {
  const isAsync = typeof rawOptions === "function";
  const loadOptions = useLatestAsyncCall(isAsync ? rawOptions : asyncNoop);
  const debouncedLoadOptions = React.useMemo(
    () => lodash.debounce((searchTerm) => {
      return loadOptions(searchTerm).then((options) => {
        setAsyncOptions(options);
        setAsyncLoading(false);
        setAsyncError(false);
      }).catch((error) => {
        if (!(error instanceof StaleResultError)) {
          setAsyncError(true);
          setAsyncLoading(false);
          if (error) {
            console.error("Error loading async options for Combobox", error);
          }
        }
      });
    }, 200),
    [loadOptions]
  );
  const [asyncOptions, setAsyncOptions] = React.useState([]);
  const [asyncLoading, setAsyncLoading] = React.useState(false);
  const [asyncError, setAsyncError] = React.useState(false);
  const [userTypedSearch, setUserTypedSearch] = React.useState("");
  const addCustomValue = React.useCallback(
    (opts) => {
      let currentOptions = opts;
      if (createCustomValue && userTypedSearch) {
        const customValueExists = opts.some((opt) => opt.value === userTypedSearch);
        if (!customValueExists) {
          currentOptions = currentOptions.slice();
          currentOptions.unshift({
            label: userTypedSearch,
            value: userTypedSearch,
            description: t("combobox.custom-value.description", "Use custom value")
          });
        }
      }
      return currentOptions;
    },
    [createCustomValue, userTypedSearch]
  );
  const updateOptions = React.useCallback(
    (inputValue) => {
      setUserTypedSearch(inputValue);
      if (isAsync) {
        setAsyncLoading(true);
        debouncedLoadOptions(inputValue);
      }
    },
    [debouncedLoadOptions, isAsync]
  );
  const stringifiedOptions = React.useMemo(() => {
    return isAsync ? [] : rawOptions.map(itemToString);
  }, [isAsync, rawOptions]);
  const filteredOptions = React.useMemo(() => {
    if (isAsync) {
      return asyncOptions;
    }
    return fuzzyFind(rawOptions, stringifiedOptions, userTypedSearch);
  }, [asyncOptions, isAsync, rawOptions, stringifiedOptions, userTypedSearch]);
  const [finalOptions, groupStartIndices] = React.useMemo(() => {
    const { options, groupStartIndices: groupStartIndices2 } = sortByGroup(filteredOptions);
    return [addCustomValue(options), groupStartIndices2];
  }, [filteredOptions, addCustomValue]);
  return { options: finalOptions, groupStartIndices, updateOptions, asyncLoading, asyncError };
}
function sortByGroup(options) {
  var _a, _b;
  const groupedOptions = /* @__PURE__ */ new Map();
  const groupStartIndices = /* @__PURE__ */ new Map();
  for (const option of options) {
    const group = option.group;
    const existing = groupedOptions.get(group);
    if (existing) {
      existing.push(option);
    } else {
      groupedOptions.set(group, [option]);
    }
  }
  if (groupedOptions.size <= 1) {
    if ((_a = options[0]) == null ? void 0 : _a.group) {
      groupStartIndices.set((_b = options[0]) == null ? void 0 : _b.group, 0);
    }
    return {
      options,
      groupStartIndices
    };
  }
  const result = new Array(options.length);
  let currentIndex = 0;
  for (const [group, groupOptions] of groupedOptions) {
    if (group) {
      groupStartIndices.set(group, currentIndex);
    }
    for (const option of groupOptions) {
      result[currentIndex++] = option;
    }
  }
  return {
    options: result,
    groupStartIndices
  };
}

"use strict";
const noop$1 = () => {
};
const VIRTUAL_OVERSCAN_ITEMS = 4;
const Combobox = (props) => {
  const {
    options: allOptions,
    onChange,
    value: valueProp,
    placeholder: placeholderProp,
    isClearable = false,
    createCustomValue = false,
    id,
    width,
    minWidth,
    maxWidth,
    "aria-labelledby": ariaLabelledBy,
    "data-testid": dataTestId,
    autoFocus,
    onBlur,
    disabled,
    loading,
    invalid
  } = props;
  const value = typeof valueProp === "object" ? valueProp == null ? void 0 : valueProp.value : valueProp;
  const baseId = React.useId().replace(/:/g, "--");
  const {
    options: filteredOptions,
    groupStartIndices,
    updateOptions,
    asyncLoading,
    asyncError
  } = useOptions(props.options, createCustomValue);
  const isAsync = typeof allOptions === "function";
  const selectedItemIndex = React.useMemo(() => {
    if (isAsync) {
      return null;
    }
    if (valueProp === void 0 || valueProp === null) {
      return null;
    }
    const index = allOptions.findIndex((option) => option.value === value);
    if (index === -1) {
      return null;
    }
    return index;
  }, [valueProp, allOptions, value, isAsync]);
  const selectedItem = React.useMemo(() => {
    if (valueProp === void 0 || valueProp === null) {
      return null;
    }
    if (selectedItemIndex !== null && !isAsync) {
      return allOptions[selectedItemIndex];
    }
    return typeof valueProp === "object" ? valueProp : { value: valueProp, label: valueProp.toString() };
  }, [selectedItemIndex, isAsync, valueProp, allOptions]);
  const menuId = `${baseId}-downshift-menu`;
  const labelId = `${baseId}-downshift-label`;
  const styles = useStyles2(getComboboxStyles);
  const rangeExtractor = React.useCallback(
    (range) => {
      const startIndex = Math.max(0, range.startIndex - range.overscan);
      const endIndex = Math.min(filteredOptions.length - 1, range.endIndex + range.overscan);
      const rangeToReturn = Array.from({ length: endIndex - startIndex + 1 }, (_, i) => startIndex + i);
      const firstDisplayedOption = filteredOptions[rangeToReturn[0]];
      if (firstDisplayedOption == null ? void 0 : firstDisplayedOption.group) {
        const groupStartIndex = groupStartIndices.get(firstDisplayedOption.group);
        if (groupStartIndex !== void 0 && groupStartIndex < rangeToReturn[0]) {
          rangeToReturn.unshift(groupStartIndex);
        }
      }
      return rangeToReturn;
    },
    [filteredOptions, groupStartIndices]
  );
  const rowVirtualizer = reactVirtual.useVirtualizer({
    count: filteredOptions.length,
    getScrollElement: () => scrollRef.current,
    estimateSize: (index) => {
      const firstGroupItem = isNewGroup(filteredOptions[index], index > 0 ? filteredOptions[index - 1] : void 0);
      const hasDescription = "description" in filteredOptions[index];
      const hasGroup = "group" in filteredOptions[index];
      let itemHeight = MENU_OPTION_HEIGHT;
      if (hasDescription) {
        itemHeight = MENU_OPTION_HEIGHT_DESCRIPTION;
      }
      if (firstGroupItem && hasGroup) {
        itemHeight += MENU_OPTION_HEIGHT;
      }
      return itemHeight;
    },
    overscan: VIRTUAL_OVERSCAN_ITEMS,
    rangeExtractor
  });
  const {
    isOpen,
    highlightedIndex,
    getInputProps,
    getMenuProps,
    getItemProps,
    selectItem
  } = downshift.useCombobox({
    menuId,
    labelId,
    inputId: id,
    items: filteredOptions,
    itemToString,
    selectedItem,
    // Don't change downshift state in the onBlahChange handlers. Instead, use the stateReducer to make changes.
    // Downshift calls change handlers on the render after so you can get sync/flickering issues if you change its state
    // in them.
    // Instead, stateReducer is called in the same tick as state changes, before that state is committed and rendered.
    onSelectedItemChange: ({ selectedItem: selectedItem2 }) => {
      onChange(selectedItem2);
    },
    defaultHighlightedIndex: selectedItemIndex != null ? selectedItemIndex : 0,
    scrollIntoView: () => {
    },
    onIsOpenChange: ({ isOpen: isOpen2, inputValue }) => {
      if (isOpen2 && inputValue === "") {
        updateOptions(inputValue);
      }
    },
    onHighlightedIndexChange: ({ highlightedIndex: highlightedIndex2, type }) => {
      if (type !== downshift.useCombobox.stateChangeTypes.MenuMouseLeave) {
        rowVirtualizer.scrollToIndex(highlightedIndex2);
      }
    },
    onStateChange: ({ inputValue: newInputValue, type, selectedItem: newSelectedItem }) => {
      switch (type) {
        case downshift.useCombobox.stateChangeTypes.InputChange:
          updateOptions(newInputValue != null ? newInputValue : "");
          break;
        default:
          break;
      }
    },
    stateReducer(state, actionAndChanges) {
      let { changes } = actionAndChanges;
      const menuBeingOpened = state.isOpen === false && changes.isOpen === true;
      const menuBeingClosed = state.isOpen === true && changes.isOpen === false;
      if (menuBeingOpened && changes.inputValue === state.inputValue) {
        changes = {
          ...changes,
          inputValue: ""
        };
      }
      if (menuBeingClosed) {
        if (changes.selectedItem) {
          changes = {
            ...changes,
            inputValue: itemToString(changes.selectedItem)
          };
        } else if (changes.inputValue !== "") {
          changes = {
            ...changes,
            inputValue: ""
          };
        }
      }
      return changes;
    }
  });
  const { inputRef, floatingRef, floatStyles, scrollRef } = useComboboxFloat(filteredOptions, isOpen);
  const isAutoSize = width === "auto";
  const InputComponent = isAutoSize ? AutoSizeInput : Input;
  const placeholder = (isOpen ? itemToString(selectedItem) : null) || placeholderProp;
  const suffixIcon = asyncLoading ? "spinner" : (
    // If it's loading, show loading icon. Otherwise, icon indicating menu state
    isOpen ? "search" : "angle-down"
  );
  const inputSuffix = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    value && value === (selectedItem == null ? void 0 : selectedItem.value) && isClearable && /* @__PURE__ */ jsxRuntime.jsx(
      Icon,
      {
        name: "times",
        className: styles.clear,
        title: t("combobox.clear.title", "Clear value"),
        tabIndex: 0,
        role: "button",
        onClick: () => {
          selectItem(null);
        },
        onKeyDown: (e) => {
          if (e.key === "Enter" || e.key === " ") {
            selectItem(null);
          }
        }
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: suffixIcon })
  ] });
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: isAutoSize ? styles.addaptToParent : void 0, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      InputComponent,
      {
        width: isAutoSize ? void 0 : width,
        ...isAutoSize ? { minWidth, maxWidth } : {},
        autoFocus,
        onBlur,
        disabled,
        loading,
        invalid,
        className: styles.input,
        suffix: inputSuffix,
        ...getInputProps({
          ref: inputRef,
          onChange: noop$1,
          // Empty onCall to avoid TS error https://github.com/downshift-js/downshift/issues/718
          "aria-labelledby": ariaLabelledBy,
          // Label should be handled with the Field component
          placeholder,
          "data-testid": dataTestId
        })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.menu, !isOpen && styles.menuClosed),
        style: floatStyles,
        ...getMenuProps({
          ref: floatingRef,
          "aria-labelledby": ariaLabelledBy
        }),
        children: isOpen && /* @__PURE__ */ jsxRuntime.jsx(
          ComboboxList,
          {
            options: filteredOptions,
            highlightedIndex,
            selectedItems: selectedItem ? [selectedItem] : [],
            scrollRef,
            getItemProps,
            error: asyncError
          }
        )
      }
    ) })
  ] });
};

"use strict";
const Field = React__namespace.forwardRef(
  ({
    label,
    description,
    horizontal,
    invalid,
    loading,
    disabled,
    required,
    error,
    children,
    className,
    validationMessageHorizontalOverflow,
    htmlFor,
    ...otherProps
  }, ref) => {
    const styles = useStyles2(getFieldStyles);
    const inputId = htmlFor != null ? htmlFor : getChildId(children);
    const labelElement = typeof label === "string" ? /* @__PURE__ */ jsxRuntime.jsx(Label$1, { htmlFor: inputId, description, children: `${label}${required ? " *" : ""}` }) : label;
    const childProps = deleteUndefinedProps({ invalid, disabled, loading });
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.field, horizontal && styles.fieldHorizontal, className), ...otherProps, children: [
      labelElement,
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { ref, children: React__namespace.cloneElement(children, childProps) }),
        invalid && error && !horizontal && /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            className: css.cx(styles.fieldValidationWrapper, {
              [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
            }),
            children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
          }
        )
      ] }),
      invalid && error && horizontal && /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: css.cx(styles.fieldValidationWrapper, styles.fieldValidationWrapperHorizontal, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
        }
      )
    ] });
  }
);
Field.displayName = "Field";
function deleteUndefinedProps(obj) {
  for (const key in obj) {
    if (obj[key] === void 0) {
      delete obj[key];
    }
  }
  return obj;
}
const getFieldStyles = (theme) => ({
  field: css.css({
    display: "flex",
    flexDirection: "column",
    marginBottom: theme.spacing(2)
  }),
  fieldHorizontal: css.css({
    flexDirection: "row",
    justifyContent: "space-between",
    flexWrap: "wrap"
  }),
  fieldValidationWrapper: css.css({
    marginTop: theme.spacing(0.5)
  }),
  fieldValidationWrapperHorizontal: css.css({
    flex: "1 1 100%"
  }),
  validationMessageHorizontalOverflow: css.css({
    width: 0,
    overflowX: "visible",
    "& > *": {
      whiteSpace: "nowrap"
    }
  })
});

"use strict";
const TimeZoneGroup = (props) => {
  const { children, label } = props;
  const styles = useStyles2(getStyles$1v);
  if (!label) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { children });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.header, children: /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }) }),
    children
  ] });
};
const getStyles$1v = (theme) => {
  return {
    header: css.css({
      padding: "7px 10px",
      width: "100%",
      borderTop: `1px solid ${theme.colors.border.weak}`,
      textTransform: "capitalize"
    }),
    label: css.css({
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

"use strict";
const TimeZoneOffset = (props) => {
  const { timestamp, timeZone, className } = props;
  const styles = useStyles2(getStyles$1u);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx("span", { className: css.cx(styles.offset, className), children: formatUtcOffset(timestamp, timeZone) }) });
};
const formatUtcOffset = (timestamp, timeZone) => {
  const offset = data.dateTimeFormat(timestamp, {
    timeZone,
    format: "Z"
  });
  return `UTC${offset}`;
};
const getStyles$1u = (theme) => {
  const textBase = css.css({
    fontWeight: "normal",
    fontSize: theme.typography.size.sm,
    color: theme.colors.text.secondary,
    whiteSpace: "normal"
  });
  return {
    offset: css.css(textBase, {
      color: theme.colors.text.primary,
      background: theme.colors.background.secondary,
      padding: "2px 5px",
      borderRadius: theme.shape.radius.default,
      marginLeft: "4px"
    })
  };
};

"use strict";
const TimeZoneDescription = ({ info }) => {
  const styles = useStyles2(getStyles$1t);
  const description = useDescription(info);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.description, children: description });
};
const useDescription = (info) => {
  return React.useMemo(() => {
    const parts = [];
    if (!info) {
      return "";
    }
    if (info.name === "Europe/Simferopol") {
      return "Ukraine, EEST";
    }
    if (info.countries.length > 0) {
      const country = info.countries[0];
      parts.push(country.name);
    }
    if (info.abbreviation) {
      parts.push(info.abbreviation);
    }
    return parts.join(", ");
  }, [info]);
};
const getStyles$1t = (theme) => {
  return {
    description: css.css({
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      textOverflow: "ellipsis"
    })
  };
};

"use strict";
const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles$1s);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.title, children: title });
};
const getStyles$1s = (theme) => {
  return {
    title: css.css({
      fontWeight: theme.typography.fontWeightRegular,
      textOverflow: "ellipsis"
    })
  };
};

"use strict";
const offsetClassName = "tz-utc-offset";
const WideTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const styles = useStyles2(getStyles$1r);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: containerStyles, ...innerProps, ref: innerRef, "data-testid": e2eSelectors.selectors.components.Select.option, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.leftColumn, styles.row), children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.leftColumn, styles.wideRow), children: [
      /* @__PURE__ */ jsxRuntime.jsx(TimeZoneTitle, { title: children }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.spacer }),
      /* @__PURE__ */ jsxRuntime.jsx(TimeZoneDescription, { info: timeZoneInfo })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.rightColumn, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        TimeZoneOffset,
        {
          timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
          timestamp,
          className: offsetClassName
        }
      ),
      isSelected && /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check" }) })
    ] })
  ] }) });
};
const CompactTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const styles = useStyles2(getStyles$1r);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: containerStyles, ...innerProps, ref: innerRef, "data-testid": e2eSelectors.selectors.components.Select.option, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.body, children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.row, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.leftColumn, children: /* @__PURE__ */ jsxRuntime.jsx(TimeZoneTitle, { title: children }) }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.rightColumn, children: isSelected && /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check" }) }) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.row, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.leftColumn, children: /* @__PURE__ */ jsxRuntime.jsx(TimeZoneDescription, { info: timeZoneInfo }) }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.rightColumn, children: /* @__PURE__ */ jsxRuntime.jsx(
        TimeZoneOffset,
        {
          timestamp,
          timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
          className: offsetClassName
        }
      ) })
    ] })
  ] }) });
};
const getStyles$1r = (theme) => ({
  container: css.css({
    display: "flex",
    alignItems: "center",
    flexDirection: "row",
    flexShrink: 0,
    whiteSpace: "nowrap",
    cursor: "pointer",
    padding: "6px 8px 4px",
    "&:hover": {
      background: theme.colors.action.hover
    }
  }),
  containerFocused: css.css({
    background: theme.colors.action.hover
  }),
  body: css.css({
    display: "flex",
    fontWeight: theme.typography.fontWeightMedium,
    flexDirection: "column",
    flexGrow: 1
  }),
  row: css.css({
    display: "flex",
    flexDirection: "row"
  }),
  leftColumn: css.css({
    flexGrow: 1,
    textOverflow: "ellipsis"
  }),
  rightColumn: css.css({
    justifyContent: "flex-end",
    alignItems: "center"
  }),
  wideRow: css.css({
    display: "flex",
    flexDirection: "row",
    alignItems: "baseline"
  }),
  spacer: css.css({
    marginLeft: "6px"
  })
});

"use strict";
const TimeZonePicker = (props) => {
  const {
    onChange,
    width,
    autoFocus = false,
    onBlur,
    value,
    includeInternal = false,
    disabled = false,
    inputId,
    menuShouldPortal = true,
    openMenuOnFocus = true
  } = props;
  const groupedTimeZones = useTimeZones(includeInternal);
  const selected = useSelectedTimeZone(groupedTimeZones, value);
  const filterBySearchIndex = useFilterBySearchIndex();
  const TimeZoneOption = width && width <= 45 ? CompactTimeZoneOption : WideTimeZoneOption;
  const onChangeTz = React.useCallback(
    (selectable) => {
      if (!selectable || !lodash.isString(selectable.value)) {
        return onChange(value);
      }
      onChange(selectable.value);
    },
    [onChange, value]
  );
  return /* @__PURE__ */ jsxRuntime.jsx(
    Select,
    {
      inputId,
      value: selected,
      placeholder: t("time-picker.zone.select-search-input", "Type to search (country, city, abbreviation)"),
      autoFocus,
      menuShouldPortal,
      openMenuOnFocus,
      width,
      filterOption: filterBySearchIndex,
      options: groupedTimeZones,
      onChange: onChangeTz,
      onBlur,
      components: { Option: TimeZoneOption, Group: TimeZoneGroup },
      disabled,
      "aria-label": t("time-picker.zone.select-aria-label", "Time zone picker")
    }
  );
};
const useTimeZones = (includeInternal) => {
  const now = Date.now();
  const timeZoneGroups = data.getTimeZoneGroups(includeInternal).map((group) => {
    const options = group.zones.reduce((options2, zone) => {
      const info = data.getTimeZoneInfo(zone, now);
      if (!info) {
        return options2;
      }
      options2.push({
        label: info.name,
        value: info.zone,
        searchIndex: getSearchIndex(info, now)
      });
      return options2;
    }, []);
    return {
      label: group.name,
      options
    };
  });
  return timeZoneGroups;
};
const useSelectedTimeZone = (groups, timeZone) => {
  return React.useMemo(() => {
    if (timeZone === void 0) {
      return void 0;
    }
    const tz = lodash.toLower(timeZone);
    const group = groups.find((group2) => {
      if (!group2.label) {
        return isInternal(tz);
      }
      return tz.startsWith(lodash.toLower(group2.label));
    });
    return group == null ? void 0 : group.options.find((option) => {
      if (lodash.isEmpty(tz)) {
        return option.value === data.InternalTimeZones.default;
      }
      return lodash.toLower(option.value) === tz;
    });
  }, [groups, timeZone]);
};
const isInternal = (timeZone) => {
  switch (timeZone) {
    case data.InternalTimeZones.default:
    case data.InternalTimeZones.localBrowserTime:
    case data.InternalTimeZones.utc:
      return true;
    default:
      return false;
  }
};
const useFilterBySearchIndex = () => {
  return React.useCallback((option, searchQuery) => {
    if (!searchQuery || !option.data || !option.data.searchIndex) {
      return true;
    }
    return option.data.searchIndex.indexOf(lodash.toLower(searchQuery)) > -1;
  }, []);
};
const getSearchIndex = (info, timestamp) => {
  const parts = [
    lodash.toLower(info.name),
    lodash.toLower(info.abbreviation),
    lodash.toLower(formatUtcOffset(timestamp, info.zone))
  ];
  for (const country of info.countries) {
    parts.push(lodash.toLower(country.name));
    parts.push(lodash.toLower(country.code));
  }
  return parts.join("|");
};

"use strict";
const quickOptions = [
  { from: "now-5m", to: "now", display: "Last 5 minutes" },
  { from: "now-15m", to: "now", display: "Last 15 minutes" },
  { from: "now-30m", to: "now", display: "Last 30 minutes" },
  { from: "now-1h", to: "now", display: "Last 1 hour" },
  { from: "now-3h", to: "now", display: "Last 3 hours" },
  { from: "now-6h", to: "now", display: "Last 6 hours" },
  { from: "now-12h", to: "now", display: "Last 12 hours" },
  { from: "now-24h", to: "now", display: "Last 24 hours" },
  { from: "now-2d", to: "now", display: "Last 2 days" },
  { from: "now-7d", to: "now", display: "Last 7 days" },
  { from: "now-30d", to: "now", display: "Last 30 days" },
  { from: "now-90d", to: "now", display: "Last 90 days" },
  { from: "now-6M", to: "now", display: "Last 6 months" },
  { from: "now-1y", to: "now", display: "Last 1 year" },
  { from: "now-2y", to: "now", display: "Last 2 years" },
  { from: "now-5y", to: "now", display: "Last 5 years" },
  { from: "now-1d/d", to: "now-1d/d", display: "Yesterday" },
  { from: "now-2d/d", to: "now-2d/d", display: "Day before yesterday" },
  { from: "now-7d/d", to: "now-7d/d", display: "This day last week" },
  { from: "now-1w/w", to: "now-1w/w", display: "Previous week" },
  { from: "now-1M/M", to: "now-1M/M", display: "Previous month" },
  { from: "now-1Q/fQ", to: "now-1Q/fQ", display: "Previous fiscal quarter" },
  { from: "now-1y/y", to: "now-1y/y", display: "Previous year" },
  { from: "now-1y/fy", to: "now-1y/fy", display: "Previous fiscal year" },
  { from: "now/d", to: "now/d", display: "Today" },
  { from: "now/d", to: "now", display: "Today so far" },
  { from: "now/w", to: "now/w", display: "This week" },
  { from: "now/w", to: "now", display: "This week so far" },
  { from: "now/M", to: "now/M", display: "This month" },
  { from: "now/M", to: "now", display: "This month so far" },
  { from: "now/y", to: "now/y", display: "This year" },
  { from: "now/y", to: "now", display: "This year so far" },
  { from: "now/fQ", to: "now", display: "This fiscal quarter so far" },
  { from: "now/fQ", to: "now/fQ", display: "This fiscal quarter" },
  { from: "now/fy", to: "now", display: "This fiscal year so far" },
  { from: "now/fy", to: "now/fy", display: "This fiscal year" }
];
const monthOptions = [
  { label: "January", value: 0 },
  { label: "February", value: 1 },
  { label: "March", value: 2 },
  { label: "April", value: 3 },
  { label: "May", value: 4 },
  { label: "June", value: 5 },
  { label: "July", value: 6 },
  { label: "August", value: 7 },
  { label: "September", value: 8 },
  { label: "October", value: 9 },
  { label: "November", value: 10 },
  { label: "December", value: 11 }
];

"use strict";
const TimePickerFooter = (props) => {
  const {
    timeZone,
    fiscalYearStartMonth,
    timestamp = Date.now(),
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const [isEditing, setEditing] = React.useState(false);
  const [editMode, setEditMode] = React.useState("tz");
  const timeSettingsId = React.useId();
  const timeZoneSettingsId = React.useId();
  const fiscalYearSettingsId = React.useId();
  const onToggleChangeTimeSettings = React.useCallback(
    (event) => {
      if (event) {
        event.stopPropagation();
      }
      setEditing(!isEditing);
    },
    [isEditing, setEditing]
  );
  const style = useStyles2(getStyle);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  const info = data.getTimeZoneInfo(timeZone, timestamp);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(
      "section",
      {
        "aria-label": t("time-picker.footer.time-zone-selection", "Time zone selection"),
        className: style.container,
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.timeZoneContainer, children: [
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.timeZone, children: [
              /* @__PURE__ */ jsxRuntime.jsx(TimeZoneTitle, { title: info.name }),
              /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.spacer }),
              /* @__PURE__ */ jsxRuntime.jsx(TimeZoneDescription, { info })
            ] }),
            /* @__PURE__ */ jsxRuntime.jsx(TimeZoneOffset, { timeZone, timestamp })
          ] }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.spacer }),
          /* @__PURE__ */ jsxRuntime.jsx(
            Button,
            {
              "data-testid": e2eSelectors.selectors.components.TimeZonePicker.changeTimeSettingsButton,
              variant: "secondary",
              onClick: onToggleChangeTimeSettings,
              size: "sm",
              "aria-expanded": isEditing,
              "aria-controls": timeSettingsId,
              icon: isEditing ? "angle-up" : "angle-down",
              children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.footer.change-settings-button", children: "Change time settings" })
            }
          )
        ]
      }
    ),
    isEditing ? /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.editContainer, id: timeSettingsId, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(TabsBar, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("time-picker.footer.time-zone-option", "Time zone"),
            active: editMode === "tz",
            onChangeTab: () => {
              setEditMode("tz");
            },
            "aria-controls": timeZoneSettingsId
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("time-picker.footer.fiscal-year-option", "Fiscal year"),
            active: editMode === "fy",
            onChangeTab: () => {
              setEditMode("fy");
            },
            "aria-controls": fiscalYearSettingsId
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(TabContent, { children: editMode === "tz" ? /* @__PURE__ */ jsxRuntime.jsx(
        "section",
        {
          role: "tabpanel",
          "data-testid": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
          id: timeZoneSettingsId,
          className: css.cx(style.timeZoneContainer, style.timeSettingContainer),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            TimeZonePicker,
            {
              includeInternal: true,
              onChange: (timeZone2) => {
                onToggleChangeTimeSettings();
                if (lodash.isString(timeZone2)) {
                  onChangeTimeZone(timeZone2);
                }
              },
              onBlur: onToggleChangeTimeSettings,
              menuShouldPortal: false
            }
          )
        }
      ) : /* @__PURE__ */ jsxRuntime.jsx(
        "section",
        {
          role: "tabpanel",
          "data-testid": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
          id: fiscalYearSettingsId,
          className: css.cx(style.timeZoneContainer, style.timeSettingContainer),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            Field,
            {
              className: style.fiscalYearField,
              label: t("time-picker.footer.fiscal-year-start", "Fiscal year start month"),
              children: /* @__PURE__ */ jsxRuntime.jsx(
                Combobox,
                {
                  value: fiscalYearStartMonth != null ? fiscalYearStartMonth : null,
                  options: monthOptions,
                  onChange: (value) => {
                    var _a;
                    if (onChangeFiscalYearStartMonth) {
                      onChangeFiscalYearStartMonth((_a = value == null ? void 0 : value.value) != null ? _a : 0);
                    }
                  }
                }
              )
            }
          )
        }
      ) })
    ] }) : null
  ] });
};
const getStyle = (theme) => ({
  container: css.css({
    borderTop: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(1.5),
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center"
  }),
  editContainer: css.css({
    borderTop: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(1.5),
    paddingTop: 0,
    justifyContent: "space-between",
    alignItems: "center"
  }),
  spacer: css.css({
    marginLeft: "7px"
  }),
  timeSettingContainer: css.css({
    paddingTop: theme.spacing(1)
  }),
  fiscalYearField: css.css({
    marginBottom: 0
  }),
  timeZoneContainer: css.css({
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    flexGrow: 1
  }),
  timeZone: css.css({
    display: "flex",
    flexDirection: "row",
    alignItems: "baseline",
    flexGrow: 1
  })
});

"use strict";
const getStyles$1q = (theme) => {
  return {
    text: css.css({
      fontSize: theme.typography.size.md,
      fontWeight: theme.typography.fontWeightMedium,
      color: theme.colors.text.primary,
      margin: 0,
      display: "flex"
    })
  };
};
const TimePickerTitle = React.memo(({ children }) => {
  const styles = useStyles2(getStyles$1q);
  return /* @__PURE__ */ jsxRuntime.jsx("h3", { className: styles.text, children });
});
TimePickerTitle.displayName = "TimePickerTitle";

"use strict";
function isValid(value, roundUp, timeZone) {
  if (data.isDateTime(value)) {
    return value.isValid();
  }
  if (data.dateMath.isMathString(value)) {
    return data.dateMath.isValid(value);
  }
  const parsed = data.dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}
function isValidTimeRange(range) {
  return data.dateMath.isValid(range.from) && data.dateMath.isValid(range.to);
}

"use strict";
const weekStarts = [
  { value: "", label: "Default" },
  { value: "saturday", label: "Saturday" },
  { value: "sunday", label: "Sunday" },
  { value: "monday", label: "Monday" }
];
function isWeekStart(value) {
  return ["saturday", "sunday", "monday"].includes(value);
}
function getWeekStart(override) {
  var _a, _b;
  if (override && isWeekStart(override)) {
    return override;
  }
  const preference = (_b = (_a = window == null ? void 0 : window.grafanaBootData) == null ? void 0 : _a.user) == null ? void 0 : _b.weekStart;
  if (preference && isWeekStart(preference)) {
    return preference;
  }
  return "monday";
}
const WeekStartPicker = (props) => {
  const { onChange, width, autoFocus = false, onBlur, value, disabled = false, inputId } = props;
  const onChangeWeekStart = React.useCallback(
    (selectable) => {
      if (selectable && selectable.value !== void 0) {
        onChange(isWeekStart(selectable.value) ? selectable.value : void 0);
      }
    },
    [onChange]
  );
  const selected = React.useMemo(() => {
    var _a, _b;
    return (_b = (_a = weekStarts.find((item) => item.value === value)) == null ? void 0 : _a.value) != null ? _b : "";
  }, [value]);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Combobox,
    {
      id: inputId,
      value: selected,
      placeholder: e2eSelectors.selectors.components.WeekStartPicker.placeholder,
      autoFocus,
      width,
      options: weekStarts,
      onChange: onChangeWeekStart,
      onBlur,
      disabled
    }
  );
};

"use strict";
function adjustDateForReactCalendar(date, timeZone) {
  const zone = data.getZone(timeZone);
  if (!zone) {
    return date;
  }
  const timezonePrefOffset = zone.utcOffset(date.getTime());
  const localOffset = date.getTimezoneOffset();
  const diff = timezonePrefOffset - localOffset;
  const newDate = new Date(date.getTime() - diff * 1e3 * 60);
  return newDate;
}

"use strict";
const weekStartMap = {
  saturday: "islamic",
  sunday: "gregory",
  monday: "iso8601"
};
function Body$1({ onChange, from, to, timeZone, weekStart }) {
  const value = inputToValue(from, to, /* @__PURE__ */ new Date(), timeZone);
  const onCalendarChange = useOnCalendarChange(onChange, timeZone);
  const styles = useStyles2(getBodyStyles);
  const weekStartValue = getWeekStart(weekStart);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Calendar__default.default,
    {
      selectRange: true,
      next2Label: null,
      prev2Label: null,
      className: styles.body,
      tileClassName: styles.title,
      value,
      nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
      nextAriaLabel: t("time-picker.calendar.next-month", "Next month"),
      prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
      prevAriaLabel: t("time-picker.calendar.previous-month", "Previous month"),
      onChange: onCalendarChange,
      locale: "en",
      calendarType: weekStartMap[weekStartValue]
    }
  );
}
Body$1.displayName = "Body";
function inputToValue(from, to, invalidDateDefault = /* @__PURE__ */ new Date(), timezone) {
  let fromAsDate = from.isValid() ? from.toDate() : invalidDateDefault;
  let toAsDate = to.isValid() ? to.toDate() : invalidDateDefault;
  if (timezone) {
    fromAsDate = adjustDateForReactCalendar(fromAsDate, timezone);
    toAsDate = adjustDateForReactCalendar(toAsDate, timezone);
  }
  if (fromAsDate > toAsDate) {
    return [toAsDate, fromAsDate];
  }
  return [fromAsDate, toAsDate];
}
function useOnCalendarChange(onChange, timeZone) {
  return React.useCallback(
    (value) => {
      if (!Array.isArray(value)) {
        return console.error("onCalendarChange: should be run in selectRange={true}");
      }
      if (value[0] && value[1]) {
        const from = data.dateTimeParse(dateInfo(value[0]), { timeZone });
        const to = data.dateTimeParse(dateInfo(value[1]), { timeZone });
        onChange(from, to);
      }
    },
    [onChange, timeZone]
  );
}
function dateInfo(date) {
  return [date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()];
}
const getBodyStyles = (theme) => {
  const hasActiveSelector = `.react-calendar__tile--hasActive:not(.react-calendar__tile--range)`;
  return {
    title: css.css({
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.primary,
      fontSize: theme.typography.size.md,
      border: "1px solid transparent",
      "&:hover, &:focus": {
        position: "relative"
      },
      "&:disabled": {
        color: theme.colors.action.disabledText
      }
    }),
    body: css.css({
      zIndex: theme.zIndex.modal,
      backgroundColor: theme.colors.background.primary,
      width: "268px",
      ".react-calendar__navigation": {
        display: "flex"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation__arrow, .react-calendar__navigation": {
        paddingTop: "4px",
        backgroundColor: "inherit",
        color: theme.colors.text.primary,
        border: 0,
        fontWeight: theme.typography.fontWeightMedium
      },
      ".react-calendar__month-view__weekdays": {
        backgroundColor: "inherit",
        textAlign: "center",
        color: theme.colors.primary.text,
        abbr: {
          border: 0,
          textDecoration: "none",
          cursor: "default",
          display: "block",
          padding: "4px 0 4px 0"
        }
      },
      ".react-calendar__month-view__days": {
        backgroundColor: "inherit"
      },
      ".react-calendar__tile, .react-calendar__tile--now": {
        marginBottom: "4px",
        backgroundColor: "inherit",
        height: "26px"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation > button:focus, .time-picker-calendar-tile:focus": {
        outline: 0
      },
      [`${hasActiveSelector}, .react-calendar__tile--active, .react-calendar__tile--active:hover`]: {
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        border: "0px"
      },
      ".react-calendar__tile--rangeEnd, .react-calendar__tile--rangeStart": {
        padding: 0,
        border: "0px",
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        abbr: {
          backgroundColor: theme.colors.primary.main,
          borderRadius: "100px",
          display: "block",
          paddingTop: "2px",
          height: "26px"
        }
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeStart`]: {
        borderTopLeftRadius: "20px",
        borderBottomLeftRadius: "20px"
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeEnd`]: {
        borderTopRightRadius: "20px",
        borderBottomRightRadius: "20px"
      }
    })
  };
};

"use strict";
function Footer({ onClose, onApply }) {
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 2, justifyContent: "space-between", children: [
    /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "secondary", onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.cancel-button", children: "Cancel" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(Button, { onClick: onApply, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.apply-button", children: "Apply time range" }) })
  ] });
}
Footer.displayName = "Footer";

"use strict";
function Header({ onClose }) {
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", children: [
    /* @__PURE__ */ jsxRuntime.jsx(TimePickerTitle, { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.select-time", children: "Select a time range" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.closeButton,
        tooltip: t(`time-picker.calendar.close`, "Close calendar"),
        name: "times",
        variant: "secondary",
        onClick: onClose
      }
    )
  ] });
}
Header.displayName = "Header";

"use strict";
const getStyles$1p = (theme, isReversed = false) => {
  return {
    container: css.css({
      top: 0,
      position: "absolute",
      [`${isReversed ? "left" : "right"}`]: "546px"
      // lmao
    }),
    modalContainer: css.css({
      label: "modalContainer",
      margin: "0 auto"
    }),
    calendar: css.css({
      display: "flex",
      flexDirection: "column",
      gap: theme.spacing(1),
      padding: theme.spacing(1),
      label: "calendar",
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default
    }),
    modal: css.css({
      label: "modal",
      boxShadow: theme.shadows.z3,
      left: "50%",
      position: "fixed",
      top: "50%",
      transform: "translate(-50%, -50%)",
      zIndex: theme.zIndex.modal
    })
  };
};
function TimePickerCalendar(props) {
  const theme = useTheme2();
  const { modalBackdrop } = useStyles2(getModalStyles);
  const styles = getStyles$1p(theme, props.isReversed);
  const { isOpen, isFullscreen: isFullscreenProp, onClose } = props;
  const ref = React.createRef();
  const { dialogProps } = dialog.useDialog(
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.label
    },
    ref
  );
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: true,
      isOpen,
      onClose
    },
    ref
  );
  const showInModal = !isFullscreenProp;
  if (!isOpen) {
    return null;
  }
  const calendar = /* @__PURE__ */ jsxRuntime.jsxs(
    "section",
    {
      className: styles.calendar,
      ref,
      ...overlayProps,
      ...dialogProps,
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.label,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Header, { ...props }),
        /* @__PURE__ */ jsxRuntime.jsx(Body$1, { ...props }),
        showInModal && /* @__PURE__ */ jsxRuntime.jsx(Footer, { ...props })
      ]
    }
  );
  if (!showInModal) {
    return /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children: calendar }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(overlays.OverlayContainer, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: modalBackdrop }),
    /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modal, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalContainer, children: calendar }) }) })
  ] });
}
var TimePickerCalendar$1 = React.memo(TimePickerCalendar);
TimePickerCalendar.displayName = "TimePickerCalendar";

"use strict";
const ERROR_MESSAGES = {
  default: () => t("time-picker.range-content.default-error", 'Please enter a past date or "now"'),
  range: () => t("time-picker.range-content.range-error", `"From" can't be after "To"`)
};
const TimeRangeContent = (props) => {
  const {
    value,
    isFullscreen = false,
    timeZone,
    onApply: onApplyFromProps,
    isReversed,
    fiscalYearStartMonth,
    onError,
    weekStart
  } = props;
  const [fromValue, toValue] = valueToState(value.raw.from, value.raw.to, timeZone);
  const style = useStyles2(getStyles$1o);
  const [from, setFrom] = React.useState(fromValue);
  const [to, setTo] = React.useState(toValue);
  const [isOpen, setOpen] = React.useState(false);
  const fromFieldId = React.useId();
  const toFieldId = React.useId();
  React.useEffect(() => {
    const [fromValue2, toValue2] = valueToState(value.raw.from, value.raw.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  }, [value.raw.from, value.raw.to, timeZone]);
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  const onApply = React.useCallback(() => {
    if (to.invalid || from.invalid) {
      return;
    }
    const raw = { from: from.value, to: to.value };
    const timeRange = data.rangeUtil.convertRawToRange(raw, timeZone, fiscalYearStartMonth);
    onApplyFromProps(timeRange);
  }, [from.invalid, from.value, onApplyFromProps, timeZone, to.invalid, to.value, fiscalYearStartMonth]);
  const onChange = React.useCallback(
    (from2, to2) => {
      const [fromValue2, toValue2] = valueToState(from2, to2, timeZone);
      setFrom(fromValue2);
      setTo(toValue2);
    },
    [timeZone]
  );
  const submitOnEnter = (event) => {
    if (event.key === "Enter") {
      onApply();
    }
  };
  const onCopy = () => {
    const raw = { from: from.value, to: to.value };
    navigator.clipboard.writeText(JSON.stringify(raw));
  };
  const onPaste = async () => {
    const raw = await navigator.clipboard.readText();
    let range;
    try {
      range = JSON.parse(raw);
    } catch (error) {
      if (onError) {
        onError(raw);
      }
      return;
    }
    const [fromValue2, toValue2] = valueToState(range.from, range.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  };
  const fiscalYear = data.rangeUtil.convertRawToRange({ from: "now/fy", to: "now/fy" }, timeZone, fiscalYearStartMonth);
  const fiscalYearMessage = t("time-picker.range-content.fiscal-year", "Fiscal year");
  const fyTooltip = /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.tooltip, children: data.rangeUtil.isFiscal(value) ? /* @__PURE__ */ jsxRuntime.jsx(
    Tooltip,
    {
      content: `${fiscalYearMessage}: ${fiscalYear.from.format("MMM-DD")} - ${fiscalYear.to.format("MMM-DD")}`,
      children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "info-circle" })
    }
  ) : null });
  const icon = /* @__PURE__ */ jsxRuntime.jsx(
    Button,
    {
      "aria-label": t("time-picker.range-content.open-input-calendar", "Open calendar"),
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.openButton,
      icon: "calendar-alt",
      variant: "secondary",
      type: "button",
      onClick: onOpen
    }
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.fieldContainer, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Field,
        {
          label: t("time-picker.range-content.from-input", "From"),
          invalid: from.invalid,
          error: from.errorMessage,
          children: /* @__PURE__ */ jsxRuntime.jsx(
            Input,
            {
              id: fromFieldId,
              onClick: (event) => event.stopPropagation(),
              onChange: (event) => onChange(event.currentTarget.value, to.value),
              addonAfter: icon,
              onKeyDown: submitOnEnter,
              "data-testid": e2eSelectors.selectors.components.TimePicker.fromField,
              value: from.value
            }
          )
        }
      ),
      fyTooltip
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.fieldContainer, children: [
      /* @__PURE__ */ jsxRuntime.jsx(Field, { label: t("time-picker.range-content.to-input", "To"), invalid: to.invalid, error: to.errorMessage, children: /* @__PURE__ */ jsxRuntime.jsx(
        Input,
        {
          id: toFieldId,
          onClick: (event) => event.stopPropagation(),
          onChange: (event) => onChange(from.value, event.currentTarget.value),
          addonAfter: icon,
          onKeyDown: submitOnEnter,
          "data-testid": e2eSelectors.selectors.components.TimePicker.toField,
          value: to.value
        }
      ) }),
      fyTooltip
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.buttonsContainer, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Button,
        {
          "data-testid": e2eSelectors.selectors.components.TimePicker.copyTimeRange,
          icon: "copy",
          variant: "secondary",
          tooltip: t("time-picker.copy-paste.tooltip-copy", "Copy time range to clipboard"),
          type: "button",
          onClick: onCopy
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        Button,
        {
          "data-testid": e2eSelectors.selectors.components.TimePicker.pasteTimeRange,
          icon: "clipboard-alt",
          variant: "secondary",
          tooltip: t("time-picker.copy-paste.tooltip-paste", "Paste time range"),
          type: "button",
          onClick: onPaste
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(Button, { "data-testid": e2eSelectors.selectors.components.TimePicker.applyTimeRange, type: "button", onClick: onApply, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.range-content.apply-button", children: "Apply time range" }) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      TimePickerCalendar$1,
      {
        isFullscreen,
        isOpen,
        from: data.dateTimeParse(from.value, { timeZone }),
        to: data.dateTimeParse(to.value, { timeZone }),
        onApply,
        onClose: () => setOpen(false),
        onChange,
        timeZone,
        isReversed,
        weekStart
      }
    )
  ] });
};
function isRangeInvalid(from, to, timezone) {
  const raw = { from, to };
  const timeRange = data.rangeUtil.convertRawToRange(raw, timezone);
  const valid = timeRange.from.isSame(timeRange.to) || timeRange.from.isBefore(timeRange.to);
  return !valid;
}
function valueToState(rawFrom, rawTo, timeZone) {
  const fromValue = valueAsString(rawFrom, timeZone);
  const toValue = valueAsString(rawTo, timeZone);
  const fromInvalid = !isValid(fromValue, false, timeZone);
  const toInvalid = !isValid(toValue, true, timeZone);
  const rangeInvalid = isRangeInvalid(fromValue, toValue, timeZone) && !toInvalid;
  return [
    {
      value: fromValue,
      invalid: fromInvalid || rangeInvalid,
      errorMessage: rangeInvalid && !fromInvalid ? ERROR_MESSAGES.range() : ERROR_MESSAGES.default()
    },
    { value: toValue, invalid: toInvalid, errorMessage: ERROR_MESSAGES.default() }
  ];
}
function valueAsString(value, timeZone) {
  if (data.isDateTime(value)) {
    return data.dateTimeFormat(value, { timeZone });
  }
  if (value.endsWith("Z")) {
    const dt = data.dateTimeParse(value);
    return data.dateTimeFormat(dt, { timeZone });
  }
  return value;
}
function getStyles$1o(theme) {
  return {
    fieldContainer: css.css({
      display: "flex"
    }),
    buttonsContainer: css.css({
      display: "flex",
      gap: theme.spacing(0.5),
      marginTop: theme.spacing(1)
    }),
    tooltip: css.css({
      paddingLeft: theme.spacing(1),
      paddingTop: theme.spacing(3)
    })
  };
}

"use strict";
const getStyles$1n = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      flexDirection: "row-reverse",
      justifyContent: "space-between",
      position: "relative"
    }),
    radio: css.css({
      opacity: 0,
      width: "0 !important",
      "&:focus-visible + label": getFocusStyles(theme)
    }),
    label: css.css({
      cursor: "pointer",
      flex: 1,
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      "&:hover": {
        background: theme.colors.action.hover,
        cursor: "pointer"
      }
    }),
    labelSelected: css.css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        width: theme.spacing(0.5),
        left: 0,
        top: 0
      }
    })
  };
};
const TimeRangeOption = React.memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles$1n);
  const id = uuid.v4();
  return /* @__PURE__ */ jsxRuntime.jsxs("li", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        className: styles.radio,
        checked: selected,
        name,
        type: "checkbox",
        "data-role": "item",
        tabIndex: -1,
        id,
        onChange: () => onSelect(value)
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("label", { className: css.cx(styles.label, selected && styles.labelSelected), htmlFor: id, children: value.display })
  ] });
});
TimeRangeOption.displayName = "TimeRangeOption";

"use strict";
const modulo$2 = (a, n) => (a % n + n) % n;
const CAUGHT_KEYS = ["ArrowUp", "ArrowDown", "Home", "End", "Enter", "Tab"];
const useListFocus = ({ localRef, options }) => {
  const [focusedItem, setFocusedItem] = React.useState(0);
  React.useEffect(() => {
    var _a;
    const items = ((_a = localRef.current) == null ? void 0 : _a.querySelectorAll('[data-role="item"]')) || [];
    const checkedIndex = Array.from(items).findIndex((item) => item.checked);
    const newFocusedIndex = checkedIndex >= 0 ? checkedIndex : 0;
    items.forEach((item, i) => {
      item.tabIndex = i === newFocusedIndex ? 0 : -1;
    });
    setFocusedItem(newFocusedIndex);
  }, [localRef, options]);
  const handleKeys = (event) => {
    var _a, _b, _c, _d;
    const items = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll('[data-role="item"]');
    const itemsCount = (_b = items == null ? void 0 : items.length) != null ? _b : 0;
    if (CAUGHT_KEYS.indexOf(event.key) > -1) {
      event.preventDefault();
      if (event.key !== "Tab") {
        event.stopPropagation();
      }
    }
    let newFocusedIndex = null;
    switch (event.key) {
      case "ArrowUp":
        newFocusedIndex = modulo$2(focusedItem - 1, itemsCount);
        break;
      case "ArrowDown":
        newFocusedIndex = modulo$2(focusedItem + 1, itemsCount);
        break;
      case "Home":
        newFocusedIndex = 0;
        break;
      case "End":
        newFocusedIndex = itemsCount - 1;
        break;
      case "Enter":
        (_c = items == null ? void 0 : items[focusedItem]) == null ? void 0 : _c.click();
        break;
      default:
        break;
    }
    if (newFocusedIndex !== null) {
      setFocusedItem(newFocusedIndex);
      (_d = items == null ? void 0 : items[newFocusedIndex]) == null ? void 0 : _d.focus();
      items == null ? void 0 : items.forEach((item, i) => {
        item.tabIndex = i === newFocusedIndex ? 0 : -1;
      });
    }
  };
  return [handleKeys];
};

"use strict";
const TimeRangeList = (props) => {
  const styles = useStyles2(getStyles$1m);
  const { title, options, placeholderEmpty } = props;
  if (typeof placeholderEmpty !== "undefined" && options.length <= 0) {
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: placeholderEmpty });
  }
  if (!title) {
    return /* @__PURE__ */ jsxRuntime.jsx(Options$1, { ...props });
  }
  return /* @__PURE__ */ jsxRuntime.jsx("section", { "aria-label": title, children: /* @__PURE__ */ jsxRuntime.jsxs("fieldset", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.title, children: /* @__PURE__ */ jsxRuntime.jsx(TimePickerTitle, { children: title }) }),
    /* @__PURE__ */ jsxRuntime.jsx(Options$1, { ...props })
  ] }) });
};
const Options$1 = ({ options, value, onChange, title }) => {
  const styles = useStyles2(getOptionsStyles);
  const localRef = React.useRef(null);
  const [handleKeys] = useListFocus({ localRef, options });
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
    "ul",
    {
      role: "presentation",
      onKeyDown: handleKeys,
      ref: localRef,
      "aria-roledescription": t("time-picker.time-range.aria-role", "Time range selection"),
      className: styles.list,
      children: options.map((option, index) => /* @__PURE__ */ jsxRuntime.jsx(
        TimeRangeOption,
        {
          value: option,
          selected: isEqual(option, value),
          onSelect: onChange,
          name: title != null ? title : t("time-picker.time-range.default-title", "Time ranges")
        },
        keyForOption(option, index)
      ))
    }
  ) });
};
function keyForOption(option, index) {
  return `${option.from}-${option.to}-${index}`;
}
function isEqual(x, y) {
  if (!y || !x) {
    return false;
  }
  return y.from === x.from && y.to === x.to;
}
const getStyles$1m = () => ({
  title: css.css({
    display: "flex",
    alignItems: "center",
    justifyContent: "space-between",
    padding: "8px 16px 5px 9px"
  })
});
const getOptionsStyles = (theme) => ({
  list: css.css({
    padding: theme.spacing(0.5)
  })
});

"use strict";
const mapOptionToTimeRange = (option, timeZone) => {
  return data.rangeUtil.convertRawToRange({ from: option.from, to: option.to }, timeZone);
};
const mapRangeToTimeOption = (range, timeZone) => {
  const from = data.dateTimeFormat(range.from, { timeZone });
  const to = data.dateTimeFormat(range.to, { timeZone });
  return {
    from,
    to,
    display: `${from} to ${to}`
  };
};

"use strict";
const TimePickerContentWithScreenSize = (props) => {
  const {
    quickOptions = [],
    isReversed,
    isFullscreen,
    hideQuickRanges,
    timeZone,
    fiscalYearStartMonth,
    value,
    onChange,
    history,
    showHistory,
    className,
    hideTimeZone,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const isHistoryEmpty = !(history == null ? void 0 : history.length);
  const isContainerTall = isFullscreen && showHistory || !isFullscreen && (showHistory && !isHistoryEmpty || !hideQuickRanges);
  const styles = useStyles2(getStyles$1l, isReversed, hideQuickRanges, isContainerTall, isFullscreen);
  const historyOptions = mapToHistoryOptions(history, timeZone);
  const timeOption = useTimeOption(value.raw, quickOptions);
  const [searchTerm, setSearchQuery] = React.useState("");
  const filteredQuickOptions = quickOptions.filter((o) => o.display.toLowerCase().includes(searchTerm.toLowerCase()));
  const onChangeTimeOption = (timeOption2) => {
    return onChange(mapOptionToTimeRange(timeOption2));
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { id: "TimePickerContent", className: css.cx(styles.container, className), children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.body, children: [
      (!isFullscreen || !hideQuickRanges) && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.rightSide, children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.timeRangeFilter, children: /* @__PURE__ */ jsxRuntime.jsx(
          FilterInput,
          {
            width: 0,
            value: searchTerm,
            onChange: setSearchQuery,
            placeholder: t("time-picker.content.filter-placeholder", "Search quick ranges")
          }
        ) }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.scrollContent, children: [
          !isFullscreen && /* @__PURE__ */ jsxRuntime.jsx(NarrowScreenForm, { ...props, historyOptions }),
          !hideQuickRanges && /* @__PURE__ */ jsxRuntime.jsx(TimeRangeList, { options: filteredQuickOptions, onChange: onChangeTimeOption, value: timeOption })
        ] })
      ] }),
      isFullscreen && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.leftSide, children: /* @__PURE__ */ jsxRuntime.jsx(FullScreenForm, { ...props, historyOptions }) })
    ] }),
    !hideTimeZone && isFullscreen && /* @__PURE__ */ jsxRuntime.jsx(
      TimePickerFooter,
      {
        timeZone,
        fiscalYearStartMonth,
        onChangeTimeZone,
        onChangeFiscalYearStartMonth
      }
    )
  ] });
};
const TimePickerContent = (props) => {
  const { widthOverride } = props;
  const theme = useTheme2();
  const isFullscreen = (widthOverride || window.innerWidth) >= theme.breakpoints.values.lg;
  return /* @__PURE__ */ jsxRuntime.jsx(TimePickerContentWithScreenSize, { ...props, isFullscreen });
};
const NarrowScreenForm = (props) => {
  const { value, hideQuickRanges, onChange, timeZone, historyOptions = [], showHistory, onError, weekStart } = props;
  const styles = useStyles2(getNarrowScreenStyles);
  const isAbsolute = data.isDateTime(value.raw.from) || data.isDateTime(value.raw.to);
  const [collapsedFlag, setCollapsedFlag] = React.useState(!isAbsolute);
  const collapsed = hideQuickRanges ? false : collapsedFlag;
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("fieldset", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.header, children: /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        type: "button",
        className: styles.expandButton,
        onClick: () => {
          if (!hideQuickRanges) {
            setCollapsedFlag(!collapsed);
          }
        },
        "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle,
        "aria-expanded": !collapsed,
        "aria-controls": "expanded-timerange",
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(TimePickerTitle, { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.absolute.title", children: "Absolute time range" }) }),
          !hideQuickRanges && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: !collapsed ? "angle-up" : "angle-down" })
        ]
      }
    ) }),
    !collapsed && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.body, id: "expanded-timerange", children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.form, children: /* @__PURE__ */ jsxRuntime.jsx(
        TimeRangeContent,
        {
          value,
          onApply: onChange,
          timeZone,
          isFullscreen: false,
          onError,
          weekStart
        }
      ) }),
      showHistory && /* @__PURE__ */ jsxRuntime.jsx(
        TimeRangeList,
        {
          title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
          options: historyOptions,
          onChange: onChangeTimeOption,
          placeholderEmpty: null
        }
      )
    ] })
  ] });
};
const FullScreenForm = (props) => {
  const { onChange, value, timeZone, fiscalYearStartMonth, isReversed, historyOptions, onError, weekStart } = props;
  const styles = useStyles2(getFullScreenStyles, props.hideQuickRanges);
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.title, "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle, children: /* @__PURE__ */ jsxRuntime.jsx(TimePickerTitle, { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.absolute.title", children: "Absolute time range" }) }) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        TimeRangeContent,
        {
          value,
          timeZone,
          fiscalYearStartMonth,
          onApply: onChange,
          isFullscreen: true,
          isReversed,
          onError,
          weekStart
        }
      )
    ] }),
    props.showHistory && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.recent, children: /* @__PURE__ */ jsxRuntime.jsx(
      TimeRangeList,
      {
        title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
        options: historyOptions || [],
        onChange: onChangeTimeOption,
        placeholderEmpty: /* @__PURE__ */ jsxRuntime.jsx(EmptyRecentList, {})
      }
    ) })
  ] });
};
const EmptyRecentList = React.memo(() => {
  const styles = useStyles2(getEmptyListStyles);
  const emptyRecentListText = t(
    "time-picker.content.empty-recent-list-info",
    "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here."
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx("span", { children: emptyRecentListText }) }),
    /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.content.empty-recent-list-docs", children: /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          className: styles.link,
          href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
          target: "_new",
          children: "Read the documentation"
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("span", { children: " to find out more about how to enter custom time ranges." })
    ] }) })
  ] });
});
function mapToHistoryOptions(ranges, timeZone) {
  if (!Array.isArray(ranges) || ranges.length === 0) {
    return [];
  }
  return ranges.map((range) => mapRangeToTimeOption(range, timeZone));
}
EmptyRecentList.displayName = "EmptyRecentList";
const useTimeOption = (raw, quickOptions) => {
  return React.useMemo(() => {
    if (!data.rangeUtil.isRelativeTimeRange(raw)) {
      return;
    }
    return quickOptions.find((option) => {
      return option.from === raw.from && option.to === raw.to;
    });
  }, [raw, quickOptions]);
};
const getStyles$1l = (theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen) => ({
  container: css.css({
    background: theme.colors.background.elevated,
    boxShadow: theme.shadows.z3,
    width: `${isFullscreen ? "546px" : "262px"}`,
    borderRadius: theme.shape.radius.default,
    border: `1px solid ${theme.colors.border.weak}`,
    [`${isReversed ? "left" : "right"}`]: 0,
    display: "flex",
    flexDirection: "column"
  }),
  body: css.css({
    display: "flex",
    flexDirection: "row-reverse",
    height: `${isContainerTall ? "381px" : "217px"}`,
    maxHeight: "100vh"
  }),
  leftSide: css.css({
    display: "flex",
    flexDirection: "column",
    borderRight: `${isReversed ? "none" : `1px solid ${theme.colors.border.weak}`}`,
    width: `${!hideQuickRanges ? "60%" : "100%"}`,
    overflow: "auto",
    scrollbarWidth: "thin",
    order: isReversed ? 1 : 0
  }),
  rightSide: css.css({
    width: `${isFullscreen ? "40%" : "100%"}; !important`,
    borderRight: isReversed ? `1px solid ${theme.colors.border.weak}` : "none",
    display: "flex",
    flexDirection: "column"
  }),
  timeRangeFilter: css.css({
    padding: theme.spacing(1)
  }),
  spacing: css.css({
    marginTop: "16px"
  }),
  scrollContent: css.css({
    overflowY: "auto",
    scrollbarWidth: "thin"
  })
});
const getNarrowScreenStyles = (theme) => ({
  header: css.css({
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    padding: "7px 9px 7px 9px"
  }),
  expandButton: css.css({
    backgroundColor: "transparent",
    border: "none",
    display: "flex",
    width: "100%",
    "&:focus-visible": getFocusStyles(theme)
  }),
  body: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`
  }),
  form: css.css({
    padding: "7px 9px 7px 9px"
  })
});
const getFullScreenStyles = (theme, hideQuickRanges) => ({
  container: css.css({
    paddingTop: "9px",
    paddingLeft: "11px",
    paddingRight: !hideQuickRanges ? "20%" : "11px"
  }),
  title: css.css({
    marginBottom: "11px"
  }),
  recent: css.css({
    flexGrow: 1,
    display: "flex",
    flexDirection: "column",
    justifyContent: "flex-end",
    paddingTop: theme.spacing(1)
  })
});
const getEmptyListStyles = (theme) => ({
  container: css.css({
    padding: "12px",
    margin: "12px",
    "a, span": {
      fontSize: "13px"
    }
  }),
  link: css.css({
    color: theme.colors.text.link
  })
});

"use strict";
const TimeRangeContext = React.createContext(void 0);
function TimeRangeProvider({ children }) {
  const [pickersCount, setPickersCount] = React.useState(0);
  const [syncedValue, setSyncedValue] = React.useState();
  const contextVal = React.useMemo(() => {
    return {
      sync: (value) => setSyncedValue(value),
      unSync: () => setSyncedValue(void 0),
      addPicker: () => setPickersCount((val) => val + 1),
      removePicker: () => {
        setPickersCount((val) => {
          const newVal = val - 1;
          if (newVal < 2) {
            setSyncedValue(void 0);
          }
          return newVal;
        });
      },
      syncPossible: pickersCount > 1,
      synced: Boolean(syncedValue),
      syncedValue
    };
  }, [pickersCount, syncedValue]);
  return /* @__PURE__ */ jsxRuntime.jsx(TimeRangeContext.Provider, { value: contextVal, children });
}
function useTimeRangeContext(initialSyncValue) {
  const context = React.useContext(TimeRangeContext);
  React.useEffect(() => {
    if (context) {
      context.addPicker();
      if (initialSyncValue) {
        context.sync(initialSyncValue);
      }
      return () => {
        context.removePicker();
      };
    }
    return () => {
    };
  }, []);
  return React.useMemo(() => {
    if (!context) {
      return context;
    }
    return {
      sync: context.sync,
      unSync: context.unSync,
      syncPossible: context.syncPossible,
      synced: context.synced,
      syncedValue: context.syncedValue
    };
  }, [context]);
}

"use strict";
function TimeSyncButton(props) {
  const { onClick, isSynced } = props;
  const syncTimesTooltip = () => {
    const tooltip = isSynced ? "Unsync all views" : "Sync all views to this time range";
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: tooltip });
  };
  return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: syncTimesTooltip, placement: "bottom", children: /* @__PURE__ */ jsxRuntime.jsx(
    ToolbarButton,
    {
      icon: "link",
      variant: isSynced ? "active" : "canvas",
      "aria-label": isSynced ? "Un sync times" : "Sync times",
      onClick
    }
  ) });
}

"use strict";
function useTimeSync(options) {
  const { value, onChangeProp, isSyncedProp, initialIsSynced, timeSyncButtonProp } = options;
  const timeRangeContext = useTimeRangeContext(initialIsSynced && value ? value : void 0);
  const timeRangeContextSynced = timeRangeContext == null ? void 0 : timeRangeContext.synced;
  const timeRangeContextSyncedValue = timeRangeContext == null ? void 0 : timeRangeContext.syncedValue;
  const timeRangeContextSyncFunc = timeRangeContext == null ? void 0 : timeRangeContext.sync;
  const usingTimeRangeContext = Boolean(options.isSyncedProp === void 0 && timeRangeContext);
  const onChangeWithSync = React.useCallback(
    (timeRange) => {
      onChangeProp(timeRange);
      if (usingTimeRangeContext && timeRangeContextSynced) {
        timeRangeContextSyncFunc == null ? void 0 : timeRangeContextSyncFunc(timeRange);
      }
    },
    [onChangeProp, usingTimeRangeContext, timeRangeContextSyncFunc, timeRangeContextSynced]
  );
  const prevValue = reactUse.usePrevious(value);
  const prevSyncedValue = reactUse.usePrevious(timeRangeContext == null ? void 0 : timeRangeContext.syncedValue);
  React.useEffect(() => {
    if (usingTimeRangeContext && timeRangeContextSynced) {
      if (value !== prevValue && value !== timeRangeContextSyncedValue) {
        timeRangeContextSyncFunc == null ? void 0 : timeRangeContextSyncFunc(value);
      } else if (timeRangeContextSyncedValue && timeRangeContextSyncedValue !== prevSyncedValue && timeRangeContextSyncedValue !== value) {
        onChangeProp(timeRangeContextSyncedValue);
      }
    }
  }, [
    usingTimeRangeContext,
    timeRangeContextSynced,
    timeRangeContextSyncedValue,
    timeRangeContextSyncFunc,
    prevSyncedValue,
    value,
    prevValue,
    onChangeProp
  ]);
  const isSynced = usingTimeRangeContext ? timeRangeContext == null ? void 0 : timeRangeContext.synced : isSyncedProp;
  const button = usingTimeRangeContext ? (timeRangeContext == null ? void 0 : timeRangeContext.syncPossible) && /* @__PURE__ */ jsxRuntime.jsx(
    TimeSyncButton,
    {
      isSynced: timeRangeContext == null ? void 0 : timeRangeContext.synced,
      onClick: () => (timeRangeContext == null ? void 0 : timeRangeContext.synced) ? timeRangeContext.unSync() : timeRangeContext.sync(value)
    }
  ) : timeSyncButtonProp;
  return {
    onChangeWithSync,
    isSynced,
    timeSyncButton: button
  };
}

"use strict";
function TimeRangePicker(props) {
  var _a;
  const [isOpen, setOpen] = React.useState(false);
  const {
    value,
    onMoveBackward,
    onMoveForward,
    onZoom,
    onError,
    timeZone,
    fiscalYearStartMonth,
    history,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth,
    quickRanges,
    hideQuickRanges,
    widthOverride,
    isOnCanvas,
    onToolbarTimePickerClick,
    weekStart,
    initialIsSynced
  } = props;
  const { onChangeWithSync, isSynced, timeSyncButton } = useTimeSync({
    initialIsSynced,
    value,
    onChangeProp: props.onChange,
    isSyncedProp: props.isSynced,
    timeSyncButtonProp: props.timeSyncButton
  });
  const onChange = (timeRange) => {
    onChangeWithSync(timeRange);
    setOpen(false);
  };
  React.useEffect(() => {
    if (isOpen && onToolbarTimePickerClick) {
      onToolbarTimePickerClick();
    }
  }, [isOpen, onToolbarTimePickerClick]);
  const onToolbarButtonSwitch = () => {
    setOpen((prevState) => !prevState);
  };
  const onClose = () => {
    setOpen(false);
  };
  const overlayRef = React.createRef();
  const buttonRef = React.createRef();
  const { overlayProps, underlayProps } = overlays.useOverlay(
    {
      onClose,
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        var _a2;
        const portalContainer = getPortalContainer();
        return !((_a2 = buttonRef.current) == null ? void 0 : _a2.contains(element)) && !portalContainer.contains(element);
      }
    },
    overlayRef
  );
  const { dialogProps } = dialog.useDialog({}, overlayRef);
  const styles = useStyles2(getStyles$1k);
  const { modalBackdrop } = useStyles2(getModalStyles);
  const hasAbsolute = !data.rangeUtil.isRelativeTime(value.raw.from) || !data.rangeUtil.isRelativeTime(value.raw.to);
  const variant = isSynced ? "active" : isOnCanvas ? "canvas" : "default";
  const isFromAfterTo = (_a = value == null ? void 0 : value.to) == null ? void 0 : _a.isBefore(value.from);
  const timePickerIcon = isFromAfterTo ? "exclamation-triangle" : "clock-nine";
  const currentTimeRange = formattedRange(value, timeZone, quickRanges);
  return /* @__PURE__ */ jsxRuntime.jsxs(ButtonGroup, { className: styles.container, children: [
    hasAbsolute && /* @__PURE__ */ jsxRuntime.jsx(
      ToolbarButton,
      {
        "aria-label": t("time-picker.range-picker.backwards-time-aria-label", "Move time range backwards"),
        variant,
        onClick: onMoveBackward,
        icon: "angle-left",
        type: "button",
        narrow: true
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      Tooltip,
      {
        ref: buttonRef,
        content: /* @__PURE__ */ jsxRuntime.jsx(TimePickerTooltip, { timeRange: value, timeZone }),
        placement: "bottom",
        interactive: true,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ToolbarButton,
          {
            "data-testid": e2eSelectors.selectors.components.TimePicker.openButton,
            "aria-label": t("time-picker.range-picker.current-time-selected", "Time range selected: {{currentTimeRange}}", {
              currentTimeRange
            }),
            "aria-controls": "TimePickerContent",
            onClick: onToolbarButtonSwitch,
            icon: timePickerIcon,
            isOpen,
            type: "button",
            variant,
            children: /* @__PURE__ */ jsxRuntime.jsx(TimePickerButtonLabel, { ...props })
          }
        )
      }
    ),
    isOpen && /* @__PURE__ */ jsxRuntime.jsxs("div", { "data-testid": e2eSelectors.selectors.components.TimePicker.overlayContent, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { role: "presentation", className: css.cx(modalBackdrop, styles.backdrop), ...underlayProps }),
      /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("section", { className: styles.content, ref: overlayRef, ...overlayProps, ...dialogProps, children: /* @__PURE__ */ jsxRuntime.jsx(
        TimePickerContent,
        {
          timeZone,
          fiscalYearStartMonth,
          value,
          onChange,
          quickOptions: quickRanges || quickOptions,
          history,
          showHistory: true,
          widthOverride,
          onChangeTimeZone,
          onChangeFiscalYearStartMonth,
          hideQuickRanges,
          onError,
          weekStart
        }
      ) }) })
    ] }),
    timeSyncButton,
    hasAbsolute && /* @__PURE__ */ jsxRuntime.jsx(
      ToolbarButton,
      {
        "aria-label": t("time-picker.range-picker.forwards-time-aria-label", "Move time range forwards"),
        onClick: onMoveForward,
        icon: "angle-right",
        narrow: true,
        type: "button",
        variant
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: ZoomOutTooltip, placement: "bottom", children: /* @__PURE__ */ jsxRuntime.jsx(
      ToolbarButton,
      {
        "aria-label": t("time-picker.range-picker.zoom-out-button", "Zoom out time range"),
        onClick: onZoom,
        icon: "search-minus",
        type: "button",
        variant
      }
    ) })
  ] });
}
TimeRangePicker.displayName = "TimeRangePicker";
const ZoomOutTooltip = () => /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "time-picker.range-picker.zoom-out-tooltip", children: [
  "Time range zoom out ",
  /* @__PURE__ */ jsxRuntime.jsx("br", {}),
  " CTRL+Z"
] }) });
const TimePickerTooltip = ({ timeRange, timeZone }) => {
  const styles = useStyles2(getLabelStyles$2);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    data.dateTimeFormat(timeRange.from, { timeZone }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: "text-center", children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.range-picker.to", children: "to" }) }),
    data.dateTimeFormat(timeRange.to, { timeZone }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: "text-center", children: /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.utc, children: data.timeZoneFormatUserFriendly(timeZone) }) })
  ] });
};
const TimePickerButtonLabel = React.memo(({ hideText, value, timeZone, quickRanges }) => {
  const styles = useStyles2(getLabelStyles$2);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.container, "aria-live": "polite", "aria-atomic": "true", children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: formattedRange(value, timeZone, quickRanges) }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.utc, children: data.rangeUtil.describeTimeRangeAbbreviation(value, timeZone) })
  ] });
});
TimePickerButtonLabel.displayName = "TimePickerButtonLabel";
const formattedRange = (value, timeZone, quickRanges) => {
  const adjustedTimeRange = {
    to: data.dateMath.isMathString(value.raw.to) ? value.raw.to : value.to,
    from: data.dateMath.isMathString(value.raw.from) ? value.raw.from : value.from
  };
  return data.rangeUtil.describeTimeRange(adjustedTimeRange, timeZone, quickRanges);
};
const getStyles$1k = (theme) => {
  return {
    container: css.css({
      position: "relative",
      display: "flex",
      verticalAlign: "middle"
    }),
    backdrop: css.css({
      display: "none",
      [theme.breakpoints.down("sm")]: {
        display: "block"
      }
    }),
    content: css.css({
      position: "absolute",
      right: 0,
      top: "116%",
      zIndex: theme.zIndex.dropdown,
      [theme.breakpoints.down("sm")]: {
        position: "fixed",
        right: "50%",
        top: "50%",
        transform: "translate(50%, -50%)",
        zIndex: theme.zIndex.modal
      }
    })
  };
};
const getLabelStyles$2 = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      whiteSpace: "nowrap"
    }),
    utc: css.css({
      color: theme.v1.palette.orange,
      fontSize: theme.typography.size.sm,
      paddingLeft: "6px",
      lineHeight: "28px",
      verticalAlign: "bottom",
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

"use strict";
const TimeRangeLabel = React.memo(function TimePickerLabel({
  hideText,
  value,
  timeZone = "browser",
  placeholder = "No time range selected",
  className
}) {
  const styles = useStyles2(getLabelStyles$1);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className, children: isValidTimeRange(value) ? /* @__PURE__ */ jsxRuntime.jsx(TimePickerButtonLabel, { value, timeZone }) : /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.placeholder, children: placeholder }) });
});
const getLabelStyles$1 = (theme) => {
  return {
    placeholder: css.css({
      color: theme.colors.text.disabled,
      opacity: 1
    })
  };
};

"use strict";
const POPUP_CLASS_NAME = "time-of-day-picker-panel";
const TimeOfDayPicker = ({
  minuteStep = 1,
  showHour = true,
  showSeconds = false,
  value,
  size = "auto",
  disabled,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  placeholder,
  // note: we can't destructure allowEmpty/onChange here
  // in order to discriminate the types properly later in the onChange handler
  ...restProps
}) => {
  var _a;
  const styles = useStyles2(getStyles$1j);
  const allowClear = (_a = restProps.allowEmpty) != null ? _a : false;
  return /* @__PURE__ */ jsxRuntime.jsx(
    RcPicker__default.default,
    {
      generateConfig: generateConfig__default.default,
      locale: locale__default.default,
      allowClear: allowClear && {
        clearIcon: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "times", className: styles.clearIcon })
      },
      className: css.cx(inputSizes()[size], styles.input),
      classNames: {
        popup: css.cx(styles.picker, POPUP_CLASS_NAME)
      },
      defaultValue: restProps.allowEmpty ? void 0 : data.dateTimeAsMoment(),
      disabled,
      disabledTime: () => ({
        disabledHours,
        disabledMinutes,
        disabledSeconds
      }),
      format: generateFormat(showHour, showSeconds),
      minuteStep,
      onChange: (value2) => {
        if (data.isDateTimeInput(value2)) {
          if (restProps.allowEmpty) {
            return restProps.onChange(value2 ? data.dateTime(value2) : void 0);
          } else {
            return restProps.onChange(data.dateTime(value2));
          }
        }
      },
      picker: "time",
      placeholder,
      showNow: false,
      needConfirm: false,
      suffixIcon: /* @__PURE__ */ jsxRuntime.jsx(Caret, { wrapperStyle: styles.caretWrapper }),
      value: value ? data.dateTimeAsMoment(value) : value
    }
  );
};
function generateFormat(showHour = true, showSeconds = false) {
  const maybeHour = showHour ? "HH:" : "";
  const maybeSecond = showSeconds ? ":ss" : "";
  return maybeHour + "mm" + maybeSecond;
}
const Caret = ({ wrapperStyle = "" }) => {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: wrapperStyle, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-down" }) });
};
const getStyles$1j = (theme) => {
  const bgColor = theme.components.input.background;
  const optionBgHover = theme.colors.action.hover;
  const borderRadius = theme.shape.radius.default;
  const borderColor = theme.components.input.borderColor;
  return {
    caretWrapper: css.css({
      position: "relative",
      top: "50%",
      transform: "translateY(-50%)",
      display: "inline-block",
      color: theme.colors.text.secondary
    }),
    clearIcon: css.css({
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    picker: css.css({
      "&.rc-picker-dropdown": {
        boxShadow: "none",
        zIndex: theme.zIndex.portal
      },
      ".rc-picker-time-panel-column": {
        fontSize: theme.typography.htmlFontSize,
        backgroundColor: bgColor,
        color: theme.colors.text.secondary,
        padding: "unset",
        overflowY: "auto",
        scrollbarWidth: "thin",
        width: theme.spacing(8),
        li: {
          paddingRight: theme.spacing(2),
          width: "auto",
          "&.rc-picker-time-panel-cell-selected": {
            backgroundColor: "inherit",
            border: `1px solid ${theme.colors.action.selectedBorder}`,
            borderRadius,
            color: theme.colors.text.primary
          },
          "&:hover": {
            background: optionBgHover,
            color: theme.colors.text.primary
          },
          "&.rc-picker-time-panel-cell-disabled": {
            color: theme.colors.action.disabledText
          }
        },
        ".rc-picker-time-panel-cell-inner": {
          color: "inherit"
        },
        "&:not(:last-of-type)": {
          borderRight: `1px solid ${borderColor}`
        }
      },
      ".rc-picker-panel": {
        boxShadow: theme.shadows.z3,
        backgroundColor: bgColor,
        borderColor,
        borderRadius,
        overflow: "hidden"
      }
    }),
    input: css.css({
      "&.rc-picker-focused": {
        border: "none",
        ".rc-picker-input": getFocusStyles(theme)
      },
      "&.rc-picker-disabled": {
        ".rc-picker-input": {
          backgroundColor: theme.colors.action.disabledBackground,
          color: theme.colors.action.disabledText,
          border: `1px solid ${theme.colors.action.disabledBackground}`,
          "&:focus": {
            boxShadow: "none"
          }
        }
      },
      ".rc-picker-input": {
        backgroundColor: bgColor,
        borderRadius,
        borderColor,
        borderStyle: "solid",
        borderWidth: "1px",
        color: theme.colors.text.primary,
        height: theme.spacing(4),
        padding: theme.spacing(0, 1),
        input: {
          color: "unset",
          backgroundColor: "unset",
          "&:focus": {
            outline: "none"
          },
          "&::placeholder": {
            color: theme.colors.text.disabled
          }
        }
      },
      ".rc-picker-clear": {
        alignItems: "center",
        display: "flex",
        insetInlineEnd: "unset",
        position: "relative"
      }
    })
  };
};

"use strict";
const DatePicker = React.memo((props) => {
  const styles = useStyles2(getStyles$1i);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modal, "data-testid": "date-picker", children: /* @__PURE__ */ jsxRuntime.jsx(Body, { ...props }) }) });
});
DatePicker.displayName = "DatePicker";
const Body = React.memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Calendar__default.default,
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || /* @__PURE__ */ new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (ev && !Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles$1i = (theme) => {
  return {
    modal: css.css({
      zIndex: theme.zIndex.modal,
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderTopLeftRadius: theme.shape.radius.default,
      borderBottomLeftRadius: theme.shape.radius.default,
      "button:disabled": {
        color: theme.colors.text.disabled
      }
    })
  };
};

"use strict";
const formatDate = (date) => data.dateTime(date).format("L");
const DatePickerWithInput = ({
  value,
  minDate,
  maxDate,
  onChange,
  closeOnSelect,
  placeholder = "Date",
  ...rest
}) => {
  const [open, setOpen] = React.useState(false);
  const styles = useStyles2(getStyles$1h);
  const middleware = [
    react$1.flip({
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open,
    placement: "bottom-start",
    onOpenChange: setOpen,
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  const click = react$1.useClick(context);
  const dismiss = react$1.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        ref: refs.setReference,
        type: "text",
        autoComplete: "off",
        placeholder,
        value: value ? formatDate(value) : value,
        onChange: (ev) => {
          if (ev.target.value === "") {
            onChange("");
          }
        },
        className: styles.input,
        ...rest,
        ...getReferenceProps()
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.popover, ref: refs.setFloating, style: floatingStyles, ...getFloatingProps(), children: /* @__PURE__ */ jsxRuntime.jsx(
      DatePicker,
      {
        isOpen: open,
        value: value && typeof value !== "string" ? value : data.dateTime().toDate(),
        minDate,
        maxDate,
        onChange: (ev) => {
          onChange(ev);
          if (closeOnSelect) {
            setOpen(false);
          }
        },
        onClose: () => setOpen(false)
      }
    ) })
  ] });
};
const getStyles$1h = (theme) => {
  return {
    container: css.css({
      position: "relative"
    }),
    input: css.css({
      /* hides the native Calendar picker icon given when using type=date */
      "input[type='date']::-webkit-inner-spin-button, input[type='date']::-webkit-calendar-picker-indicator": {
        display: "none",
        WebkitAppearance: "none"
      }
    }),
    popover: css.css({
      zIndex: theme.zIndex.tooltip
    })
  };
};

"use strict";
const DateTimePicker = ({
  date,
  maxDate,
  minDate,
  label,
  onChange,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  timeZone,
  showSeconds = true,
  clearable = false
}) => {
  const [isOpen, setOpen] = React.useState(false);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    {
      onClose: () => setOpen(false),
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        const popupElement = document.getElementsByClassName(POPUP_CLASS_NAME)[0];
        return !(popupElement && popupElement.contains(element));
      }
    },
    ref
  );
  const { dialogProps } = dialog.useDialog({}, ref);
  const theme = useTheme2();
  const { modalBackdrop } = useStyles2(getModalStyles);
  const isFullscreen = reactUse.useMedia(`(min-width: ${theme.breakpoints.values.lg}px)`);
  const styles = useStyles2(getStyles$1g);
  const middleware = [
    react$1.flip({
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { refs, floatingStyles } = react$1.useFloating({
    open: isOpen,
    placement: "bottom-start",
    onOpenChange: setOpen,
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  const onApply = React.useCallback(
    (date2) => {
      setOpen(false);
      onChange(date2);
    },
    [onChange]
  );
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { "data-testid": "date-time-picker", style: { position: "relative" }, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      DateTimeInput,
      {
        date,
        onChange,
        isFullscreen,
        onOpen,
        label,
        ref: refs.setReference,
        showSeconds,
        clearable,
        timeZone
      }
    ),
    isOpen ? isFullscreen ? /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref, ...overlayProps, ...dialogProps, children: /* @__PURE__ */ jsxRuntime.jsx(
      DateTimeCalendar,
      {
        date,
        onChange: onApply,
        isFullscreen: true,
        onClose: () => setOpen(false),
        maxDate,
        minDate,
        ref: refs.setFloating,
        style: floatingStyles,
        showSeconds,
        disabledHours,
        disabledMinutes,
        disabledSeconds,
        timeZone
      }
    ) }) }) }) : /* @__PURE__ */ jsxRuntime.jsxs(Portal$1, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: modalBackdrop, ...underlayProps }),
      /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref, ...overlayProps, ...dialogProps, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modal, children: /* @__PURE__ */ jsxRuntime.jsx(
        DateTimeCalendar,
        {
          date,
          maxDate,
          minDate,
          onChange: onApply,
          isFullscreen: false,
          onClose: () => setOpen(false),
          showSeconds,
          disabledHours,
          disabledMinutes,
          disabledSeconds,
          timeZone
        }
      ) }) }) })
    ] }) : null
  ] });
};
const DateTimeInput = React__namespace.forwardRef(
  ({ date, label, onChange, onOpen, timeZone, showSeconds = true, clearable = false }, ref) => {
    const styles = useStyles2(getStyles$1g);
    const format = showSeconds ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD HH:mm";
    const [internalDate, setInternalDate] = React.useState(() => {
      return {
        value: date ? data.dateTimeFormat(date, { timeZone }) : !clearable ? data.dateTimeFormat(data.dateTime(), { timeZone }) : "",
        invalid: false
      };
    });
    React.useEffect(() => {
      if (date) {
        const formattedDate = data.dateTimeFormat(date, { format, timeZone });
        setInternalDate({
          invalid: !isValid(formattedDate),
          value: data.isDateTime(date) ? formattedDate : date
        });
      }
    }, [date, format, timeZone]);
    const onChangeDate = React.useCallback((event) => {
      const isInvalid = !isValid(event.currentTarget.value);
      setInternalDate({
        value: event.currentTarget.value,
        invalid: isInvalid
      });
    }, []);
    const onBlur = React.useCallback(() => {
      if (!internalDate.invalid && internalDate.value) {
        const date2 = data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), internalDate.value);
        onChange(date2);
      }
    }, [internalDate, onChange, timeZone]);
    const clearInternalDate = React.useCallback(() => {
      setInternalDate({ value: "", invalid: false });
      onChange();
    }, [onChange]);
    const icon = /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": t("grafana-ui.date-time-picker.calendar-icon-label", "Time picker"),
        icon: "calendar-alt",
        variant: "secondary",
        onClick: onOpen
      }
    );
    return /* @__PURE__ */ jsxRuntime.jsx(InlineField, { label, invalid: !!(internalDate.value && internalDate.invalid), className: styles.field, children: /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        onChange: onChangeDate,
        addonAfter: icon,
        value: internalDate.value,
        onBlur,
        "data-testid": e2eSelectors.Components.DateTimePicker.input,
        placeholder: t("grafana-ui.date-time-picker.select-placeholder", "Select date/time"),
        ref,
        suffix: clearable && internalDate.value && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "times", className: styles.clearIcon, onClick: clearInternalDate })
      }
    ) });
  }
);
DateTimeInput.displayName = "DateTimeInput";
const DateTimeCalendar = React__namespace.forwardRef(
  ({
    date,
    onClose,
    onChange,
    isFullscreen,
    maxDate,
    minDate,
    style,
    showSeconds = true,
    disabledHours,
    disabledMinutes,
    disabledSeconds,
    timeZone
  }, ref) => {
    const calendarStyles = useStyles2(getBodyStyles);
    const styles = useStyles2(getStyles$1g);
    const [timeOfDayDateTime, setTimeOfDayDateTime] = React.useState(() => {
      if (date && date.isValid()) {
        return data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), date);
      }
      return data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), /* @__PURE__ */ new Date());
    });
    const [reactCalendarDate, setReactCalendarDate] = React.useState(() => {
      if (date && date.isValid()) {
        return adjustDateForReactCalendar(date.toDate(), data.getTimeZone({ timeZone }));
      }
      return adjustDateForReactCalendar(/* @__PURE__ */ new Date(), data.getTimeZone({ timeZone }));
    });
    const onChangeDate = React.useCallback((date2) => {
      if (date2 && !Array.isArray(date2)) {
        setReactCalendarDate(date2);
      }
    }, []);
    const onChangeTime = React.useCallback((date2) => {
      setTimeOfDayDateTime(date2);
    }, []);
    const handleApply = () => {
      const newDate = data.dateTime(timeOfDayDateTime);
      newDate.set("date", reactCalendarDate.getDate());
      newDate.set("month", reactCalendarDate.getMonth());
      newDate.set("year", reactCalendarDate.getFullYear());
      onChange(newDate);
    };
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, { [styles.fullScreen]: isFullscreen }), style, ref, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Calendar__default.default,
        {
          next2Label: null,
          prev2Label: null,
          value: reactCalendarDate,
          nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
          nextAriaLabel: t("grafana-ui.date-time-picker.next-label", "Next month"),
          prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
          prevAriaLabel: t("grafana-ui.date-time-picker.previous-label", "Previous month"),
          onChange: onChangeDate,
          locale: "en",
          className: calendarStyles.body,
          tileClassName: calendarStyles.title,
          maxDate,
          minDate
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.time, children: /* @__PURE__ */ jsxRuntime.jsx(
        TimeOfDayPicker,
        {
          showSeconds,
          onChange: onChangeTime,
          value: timeOfDayDateTime,
          disabledHours,
          disabledMinutes,
          disabledSeconds
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(Button, { type: "button", onClick: handleApply, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.date-time-picker.apply", children: "Apply" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "secondary", type: "button", onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.date-time-picker.cancel", children: "Cancel" }) })
      ] })
    ] });
  }
);
DateTimeCalendar.displayName = "DateTimeCalendar";
const getStyles$1g = (theme) => ({
  container: css.css({
    padding: theme.spacing(1),
    border: `1px ${theme.colors.border.weak} solid`,
    borderRadius: theme.shape.radius.default,
    backgroundColor: theme.colors.background.primary,
    zIndex: theme.zIndex.modal
  }),
  fullScreen: css.css({
    position: "absolute"
  }),
  time: css.css({
    marginBottom: theme.spacing(2)
  }),
  modal: css.css({
    position: "fixed",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    zIndex: theme.zIndex.modal,
    maxWidth: "280px"
  }),
  clearIcon: css.css({
    cursor: "pointer"
  }),
  field: css.css({
    marginBottom: 0,
    width: "100%"
  })
});

"use strict";
const getStyles$1f = stylesFactory((inlineList = false) => ({
  list: css.css({
    listStyleType: "none",
    margin: 0,
    padding: 0
  }),
  item: css.css({
    display: inlineList && "inline-block" || "block"
  })
}));
class AbstractList extends React.PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles$1f(inline);
    return /* @__PURE__ */ jsxRuntime.jsx("ul", { className: css.cx(styles.list, className), children: items.map((item, i) => {
      return /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: renderItem(item, i) }, getItemKey ? getItemKey(item) : i);
    }) });
  }
}

"use strict";
class List extends React.PureComponent {
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(AbstractList, { ...this.props });
  }
}

"use strict";
const expanderContainerStyles = css.css({
  display: "flex",
  alignItems: "center",
  height: "100%"
});
function ExpanderCell({ row, __rowID }) {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: expanderContainerStyles, children: /* @__PURE__ */ jsxRuntime.jsx(
    IconButton,
    {
      tooltip: t("grafana-ui.interactive-table.expand-row-tooltip", "Toggle row expanded"),
      "aria-controls": __rowID,
      name: row.isExpanded ? "angle-down" : "angle-right",
      "aria-expanded": row.isExpanded,
      ...row.getToggleRowExpandedProps(),
      size: "lg"
    }
  ) });
}
function ExpanderHeader({ isAllRowsExpanded, toggleAllRowsExpanded }) {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: expanderContainerStyles, children: /* @__PURE__ */ jsxRuntime.jsx(
    IconButton,
    {
      "aria-label": !isAllRowsExpanded ? "Expand all rows" : "Collapse all rows",
      name: !isAllRowsExpanded ? "table-expand-all" : "table-collapse-all",
      onClick: () => toggleAllRowsExpanded(),
      size: "lg",
      tooltip: !isAllRowsExpanded ? "Expand all rows" : "Collapse all rows",
      variant: "secondary"
    }
  ) });
}

"use strict";
const EXPANDER_CELL_ID = "__expander";
function getColumns$1(columns, showExpandAll = false) {
  return [
    {
      id: EXPANDER_CELL_ID,
      Cell: ExpanderCell,
      ...showExpandAll && {
        Header: ExpanderHeader
      },
      disableSortBy: true,
      width: 0
    },
    // @ts-expect-error react-table expects each column key(id) to have data associated with it and therefore complains about
    // column.id being possibly undefined and not keyof T (where T is the data object)
    // We do not want to be that strict as we simply pass undefined to cells that do not have data associated with them.
    ...columns.map((column) => ({
      id: column.id,
      accessor: column.id,
      Header: column.header || (() => null),
      sortType: column.sortType || "alphanumeric",
      disableSortBy: !Boolean(column.sortType),
      width: column.disableGrow ? 0 : void 0,
      visible: column.visible,
      ...column.cell && { Cell: column.cell }
    }))
  ];
}

"use strict";
const getStyles$1e = (theme) => {
  const rowHoverBg = theme.colors.emphasize(theme.colors.background.primary, 0.03);
  return {
    container: css.css({
      display: "flex",
      gap: theme.spacing(2),
      flexDirection: "column",
      width: "100%",
      overflowX: "auto"
    }),
    cell: css.css({
      padding: theme.spacing(1),
      minWidth: theme.spacing(3)
    }),
    table: css.css({
      borderRadius: theme.shape.radius.default,
      width: "100%"
    }),
    disableGrow: css.css({
      width: 0
    }),
    header: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      minWidth: theme.spacing(3),
      "&, & > button": {
        position: "relative",
        whiteSpace: "nowrap",
        padding: theme.spacing(1)
      },
      "& > button": {
        "&:after": {
          content: '"\\00a0"'
        },
        width: "100%",
        height: "100%",
        background: "none",
        border: "none",
        paddingRight: theme.spacing(2.5),
        textAlign: "left",
        fontWeight: theme.typography.fontWeightMedium
      }
    }),
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:hover": {
        backgroundColor: rowHoverBg
      },
      "&:last-child": {
        borderBottom: 0
      }
    }),
    expandedRow: css.css({
      label: "expanded-row-content",
      borderBottom: "none"
    }),
    expandedContentCell: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      position: "relative",
      padding: theme.spacing(2, 2, 2, 5),
      "&:before": {
        content: '""',
        position: "absolute",
        width: "1px",
        top: 0,
        left: "16px",
        bottom: theme.spacing(2),
        background: theme.colors.border.medium
      }
    }),
    expandedContentRow: css.css({
      label: "expanded-row-content"
    }),
    sortableHeader: css.css({
      /* increases selector's specificity so that it always takes precedence over default styles  */
      "&&": {
        padding: 0
      }
    })
  };
};
function InteractiveTable({
  className,
  columns,
  data: data$1,
  getRowId,
  headerTooltips,
  pageSize = 0,
  renderExpandedRow,
  showExpandAll = false,
  fetchData,
  initialSortBy = []
}) {
  const styles = useStyles2(getStyles$1e);
  const tableColumns = React.useMemo(() => {
    return getColumns$1(columns, showExpandAll);
  }, [columns, showExpandAll]);
  const id = useUniqueId();
  const getRowHTMLID = React.useCallback(
    (row) => {
      return `${id}-${row.id}`.replace(/\s/g, "");
    },
    [id]
  );
  const tableHooks = [reactTable.useSortBy, reactTable.useExpanded];
  const multiplePages = data$1.length > pageSize;
  const paginationEnabled = pageSize > 0;
  if (paginationEnabled) {
    tableHooks.push(reactTable.usePagination);
  }
  const tableInstance = reactTable.useTable(
    {
      columns: tableColumns,
      data: data$1,
      autoResetExpanded: false,
      autoResetSortBy: false,
      disableMultiSort: true,
      // If fetchData is provided, we disable client-side sorting
      manualSortBy: Boolean(fetchData),
      getRowId,
      initialState: {
        hiddenColumns: [
          !renderExpandedRow && EXPANDER_CELL_ID,
          ...tableColumns.filter((col) => !(col.visible ? col.visible(data$1) : true)).map((c) => c.id).filter(data.isTruthy)
        ].filter(data.isTruthy),
        sortBy: initialSortBy
      }
    },
    ...tableHooks
  );
  const { getTableProps, getTableBodyProps, headerGroups, prepareRow } = tableInstance;
  const { sortBy } = tableInstance.state;
  React.useEffect(() => {
    if (fetchData) {
      fetchData({ sortBy });
    }
  }, [sortBy, fetchData]);
  React.useEffect(() => {
    if (paginationEnabled) {
      tableInstance.setPageSize(pageSize);
    }
  }, [paginationEnabled, pageSize, tableInstance.setPageSize, tableInstance]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsxs("table", { ...getTableProps(), className: css.cx(styles.table, className), children: [
      /* @__PURE__ */ jsxRuntime.jsx("thead", { children: headerGroups.map((headerGroup) => {
        const { key, ...headerRowProps } = headerGroup.getHeaderGroupProps();
        return /* @__PURE__ */ jsxRuntime.jsx("tr", { ...headerRowProps, children: headerGroup.headers.map((column) => {
          const { key: key2, ...headerCellProps } = column.getHeaderProps();
          const headerTooltip = headerTooltips == null ? void 0 : headerTooltips[column.id];
          return /* @__PURE__ */ jsxRuntime.jsx(
            "th",
            {
              className: css.cx(styles.header, {
                [styles.disableGrow]: column.width === 0,
                [styles.sortableHeader]: column.canSort
              }),
              ...headerCellProps,
              ...column.isSorted && { "aria-sort": column.isSortedDesc ? "descending" : "ascending" },
              children: /* @__PURE__ */ jsxRuntime.jsx(ColumnHeader, { column, headerTooltip })
            },
            key2
          );
        }) }, key);
      }) }),
      /* @__PURE__ */ jsxRuntime.jsx("tbody", { ...getTableBodyProps(), children: (paginationEnabled ? tableInstance.page : tableInstance.rows).map((row) => {
        prepareRow(row);
        const { key, ...otherRowProps } = row.getRowProps();
        const rowId = getRowHTMLID(row);
        const isExpanded = row.isExpanded;
        return /* @__PURE__ */ jsxRuntime.jsxs(React.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx("tr", { ...otherRowProps, className: css.cx(styles.row, isExpanded && styles.expandedRow), children: row.cells.map((cell) => {
            const { key: key2, ...otherCellProps } = cell.getCellProps();
            return /* @__PURE__ */ jsxRuntime.jsx("td", { className: styles.cell, ...otherCellProps, children: cell.render("Cell", { __rowID: rowId }) }, key2);
          }) }),
          isExpanded && renderExpandedRow && /* @__PURE__ */ jsxRuntime.jsx("tr", { ...otherRowProps, id: rowId, className: styles.expandedContentRow, children: /* @__PURE__ */ jsxRuntime.jsx("td", { className: styles.expandedContentCell, colSpan: row.cells.length, children: renderExpandedRow(row.original) }) })
        ] }, key);
      }) })
    ] }),
    paginationEnabled && multiplePages && /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsx(
      Pagination,
      {
        currentPage: tableInstance.state.pageIndex + 1,
        numberOfPages: tableInstance.pageOptions.length,
        onNavigate: (toPage) => tableInstance.gotoPage(toPage - 1)
      }
    ) })
  ] });
}
const useUniqueId = () => {
  return React.useMemo(() => lodash.uniqueId("InteractiveTable"), []);
};
const getColumnHeaderStyles = (theme) => ({
  sortIcon: css.css({
    position: "absolute",
    top: theme.spacing(1)
  }),
  headerTooltipIcon: css.css({
    marginLeft: theme.spacing(0.5)
  })
});
function ColumnHeader({
  column: { canSort, render, isSorted, isSortedDesc, getSortByToggleProps },
  headerTooltip
}) {
  const styles = useStyles2(getColumnHeaderStyles);
  const { onClick } = getSortByToggleProps();
  const children = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    render("Header"),
    headerTooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { theme: "info-alt", content: headerTooltip.content, placement: "top-end", children: /* @__PURE__ */ jsxRuntime.jsx(
      Icon,
      {
        className: styles.headerTooltipIcon,
        name: headerTooltip.iconName || "info-circle",
        "data-testid": "header-tooltip-icon"
      }
    ) }),
    isSorted && /* @__PURE__ */ jsxRuntime.jsx("span", { "aria-hidden": "true", className: styles.sortIcon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: isSortedDesc ? "angle-down" : "angle-up" }) })
  ] });
  if (canSort) {
    return /* @__PURE__ */ jsxRuntime.jsx("button", { type: "button", onClick, children });
  }
  return children;
}

"use strict";
const TagItem = ({ name, disabled, onRemove, autoColors = true }) => {
  const styles = useStyles2(getStyles$1d);
  const tagStyle = React.useMemo(() => {
    if (autoColors) {
      const { color, borderColor } = getTagColorsFromName(name);
      return { backgroundColor: color, borderColor };
    }
    return void 0;
  }, [name, autoColors]);
  return /* @__PURE__ */ jsxRuntime.jsxs("li", { className: css.cx(styles.itemStyle, !tagStyle && styles.defaultTagColor), style: tagStyle, children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.nameStyle, children: name }),
    /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "times",
        size: "lg",
        disabled,
        tooltip: t("grafana-ui.tags-input.remove", "Remove tag: {{name}}", { name }),
        onClick: () => onRemove(name),
        className: styles.buttonStyles
      }
    )
  ] });
};
const getStyles$1d = (theme) => {
  const height = theme.spacing.gridSize * 3;
  return {
    itemStyle: css.css({
      display: "flex",
      gap: "3px",
      alignItems: "center",
      height: `${height}px`,
      lineHeight: `${height - 2}px`,
      borderWidth: "1px",
      borderStyle: "solid",
      borderRadius: theme.shape.radius.default,
      padding: `0 ${theme.spacing(0.5)}`,
      whiteSpace: "nowrap",
      textShadow: "none",
      fontWeight: 500,
      fontSize: theme.typography.size.sm,
      color: "#fff"
    }),
    defaultTagColor: css.css({
      backgroundColor: theme.colors.background.secondary,
      borderColor: theme.components.input.borderColor,
      color: theme.colors.text.primary
    }),
    nameStyle: css.css({
      maxWidth: "25ch",
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    buttonStyles: css.css({
      margin: 0,
      "&:hover::before": {
        display: "none"
      }
    })
  };
};

"use strict";
const TagsInput = ({
  placeholder = "New tag (enter key to add)",
  tags = [],
  onChange,
  width,
  className,
  disabled,
  addOnBlur,
  invalid,
  id,
  autoColors = true
}) => {
  const [newTagName, setNewTagName] = React.useState("");
  const styles = useStyles2(getStyles$1c);
  const theme = useTheme2();
  const onNameChange = React.useCallback((event) => {
    setNewTagName(event.target.value);
  }, []);
  const onRemove = (tagToRemove) => {
    onChange(tags.filter((x) => x !== tagToRemove));
  };
  const onAdd = (event) => {
    event == null ? void 0 : event.preventDefault();
    if (!tags.includes(newTagName)) {
      onChange(tags.concat(newTagName));
    }
    setNewTagName("");
  };
  const onBlur = () => {
    if (addOnBlur && newTagName) {
      onAdd();
    }
  };
  const onKeyboardAdd = (event) => {
    if (event.key === "Enter" && newTagName !== "") {
      onAdd(event);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.wrapper, className, width ? css.css({ width: theme.spacing(width) }) : ""), children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        id,
        disabled,
        placeholder,
        onChange: onNameChange,
        value: newTagName,
        onKeyDown: onKeyboardAdd,
        onBlur,
        invalid,
        suffix: /* @__PURE__ */ jsxRuntime.jsx(
          Button,
          {
            fill: "text",
            className: styles.addButtonStyle,
            onClick: onAdd,
            size: "md",
            disabled: newTagName.length <= 0,
            children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.tags-input.add", children: "Add" })
          }
        )
      }
    ),
    (tags == null ? void 0 : tags.length) > 0 && /* @__PURE__ */ jsxRuntime.jsx("ul", { className: styles.tags, children: tags.map((tag) => /* @__PURE__ */ jsxRuntime.jsx(TagItem, { name: tag, onRemove, disabled, autoColors }, tag)) })
  ] });
};
const getStyles$1c = (theme) => ({
  wrapper: css.css({
    minHeight: theme.spacing(4),
    display: "flex",
    flexDirection: "column",
    gap: theme.spacing(1),
    flexWrap: "wrap"
  }),
  tags: css.css({
    display: "flex",
    justifyContent: "flex-start",
    flexWrap: "wrap",
    gap: theme.spacing(0.5)
  }),
  addButtonStyle: css.css({
    margin: `0 -${theme.spacing(1)}`
  })
});

"use strict";
const EllipsisAnimated = React.memo(() => {
  const styles = useStyles2(getStyles$1b);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.ellipsis, children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.firstDot, children: "." }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.secondDot, children: "." }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.thirdDot, children: "." })
  ] });
});
EllipsisAnimated.displayName = "EllipsisAnimated";
const getStyles$1b = (theme) => {
  return {
    ellipsis: css.css({
      display: "inline"
    }),
    firstDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${firstDot} 2s linear infinite`
      }
    }),
    secondDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${secondDot} 2s linear infinite`
      }
    }),
    thirdDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${thirdDot} 2s linear infinite`
      }
    })
  };
};
const firstDot = css.keyframes`
  0% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const secondDot = css.keyframes`
  0% {
    opacity: 0;
  }
  21% {
    opacity: 0.5;
  }
  22% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const thirdDot = css.keyframes`
  0% {
    opacity: 0;
  }
  43% {
    opacity: 0.5;
  }
  44% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;

"use strict";
const SHOW_SUCCESS_DURATION = 2 * 1e3;
function AutoSaveField(props) {
  const {
    invalid,
    loading,
    onFinishChange,
    saveErrorMessage = "Error saving this value",
    error,
    children,
    disabled,
    ...restProps
  } = props;
  const [fieldState, setFieldState] = React__namespace.useState({
    isLoading: false,
    showSuccess: false,
    showError: invalid
  });
  const fieldRef = React.useRef(null);
  React__namespace.useEffect(() => {
    let timeoutId;
    if (fieldState.showSuccess) {
      const time = fieldState.showError ? 0 : SHOW_SUCCESS_DURATION;
      timeoutId = setTimeout(() => {
        setFieldState({ ...fieldState, showSuccess: false });
      }, time);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [fieldState]);
  const handleChange = React.useCallback(
    (nextValue) => {
      if (invalid) {
        return;
      }
      setFieldState({ ...fieldState, isLoading: true, showSuccess: false });
      onFinishChange(nextValue).then(() => {
        setFieldState({
          isLoading: false,
          showSuccess: true,
          showError: false
        });
      }).catch(() => {
        setFieldState({
          ...fieldState,
          isLoading: false,
          showError: true
        });
      });
    },
    [invalid, fieldState, onFinishChange]
  );
  const lodashDebounce = React.useMemo(() => lodash.debounce(handleChange, 600, { leading: false }), [handleChange]);
  const isInvalid = invalid || fieldState.showError || void 0;
  const styles = useStyles2(getStyles$1a);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Field,
      {
        ...restProps,
        loading: loading || void 0,
        invalid: isInvalid,
        disabled,
        error: error || fieldState.showError && saveErrorMessage,
        ref: fieldRef,
        className: styles.widthFitContent,
        children: React__namespace.cloneElement(
          children((newValue) => {
            lodashDebounce(newValue);
          })
        )
      }
    ),
    fieldState.isLoading && /* @__PURE__ */ jsxRuntime.jsx(InlineToast, { referenceElement: fieldRef.current, placement: "right", children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.auto-save-field.saving", children: [
      "Saving ",
      /* @__PURE__ */ jsxRuntime.jsx(EllipsisAnimated, {})
    ] }) }),
    fieldState.showSuccess && /* @__PURE__ */ jsxRuntime.jsx(InlineToast, { suffixIcon: "check", referenceElement: fieldRef.current, placement: "right", children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.auto-save-field.saved", children: "Saved!" }) })
  ] });
}
AutoSaveField.displayName = "AutoSaveField";
const getStyles$1a = () => {
  return {
    widthFitContent: css.css({
      width: "fit-content"
    })
  };
};

"use strict";
const TagComponent = React.forwardRef(({ name, onClick, icon, className, colorIndex, ...rest }, ref) => {
  const theme = useTheme2();
  const styles = getTagStyles$1(theme, name, colorIndex);
  const onTagClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    onClick == null ? void 0 : onClick(name, event);
  };
  const classes = css.cx(styles.wrapper, className, { [styles.hover]: onClick !== void 0 });
  return onClick ? /* @__PURE__ */ jsxRuntime.jsxs("button", { ...rest, className: classes, onClick: onTagClick, ref, children: [
    icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
    name
  ] }) : /* @__PURE__ */ jsxRuntime.jsxs("span", { ...rest, className: classes, ref, children: [
    icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
    name
  ] });
});
TagComponent.displayName = "Tag";
const TagSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$2);
  return /* @__PURE__ */ jsxRuntime.jsx(Skeleton__default.default, { width: 60, height: 22, containerClassName: styles.container, ...rootProps });
};
const Tag = attachSkeleton(TagComponent, TagSkeleton);
const getSkeletonStyles$2 = () => ({
  container: css.css({
    lineHeight: 1
  })
});
const getTagStyles$1 = (theme, name, colorIndex) => {
  let colors;
  if (colorIndex === void 0) {
    colors = getTagColorsFromName(name);
  } else {
    colors = getTagColor(colorIndex);
  }
  return {
    wrapper: css.css({
      appearance: "none",
      borderStyle: "none",
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      lineHeight: theme.typography.bodySmall.lineHeight,
      verticalAlign: "baseline",
      backgroundColor: colors.color,
      color: theme.v1.palette.gray98,
      whiteSpace: "pre",
      textShadow: "none",
      padding: "3px 6px",
      borderRadius: theme.shape.radius.default
    }),
    hover: css.css({
      "&:hover": {
        opacity: 0.85,
        cursor: "pointer"
      }
    })
  };
};

"use strict";
const TagListComponent = React.memo(
  React.forwardRef(
    ({ displayMax, tags, icon, onClick, className, getAriaLabel, getColorIndex }, ref) => {
      const theme = useTheme2();
      const styles = getStyles$19(theme, Boolean(displayMax && displayMax > 0));
      const numTags = tags.length;
      const tagsToDisplay = displayMax ? tags.slice(0, displayMax) : tags;
      return /* @__PURE__ */ jsxRuntime.jsxs("ul", { className: css.cx(styles.wrapper, className), "aria-label": t("grafana-ui.tags.list-label", "Tags"), ref, children: [
        tagsToDisplay.map((tag, i) => /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.li, children: /* @__PURE__ */ jsxRuntime.jsx(
          Tag,
          {
            name: tag,
            icon,
            onClick,
            "aria-label": getAriaLabel == null ? void 0 : getAriaLabel(tag, i),
            "data-tag-id": i,
            colorIndex: getColorIndex == null ? void 0 : getColorIndex(tag, i)
          }
        ) }, tag)),
        displayMax && displayMax > 0 && numTags - displayMax > 0 && /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.moreTagsLabel, children: [
          "+ ",
          numTags - displayMax
        ] })
      ] });
    }
  )
);
TagListComponent.displayName = "TagList";
const TagListSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$1);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, ...rootProps, children: [
    /* @__PURE__ */ jsxRuntime.jsx(Tag.Skeleton, {}),
    /* @__PURE__ */ jsxRuntime.jsx(Tag.Skeleton, {})
  ] });
};
const TagList = attachSkeleton(TagListComponent, TagListSkeleton);
const getSkeletonStyles$1 = (theme) => ({
  container: css.css({
    display: "flex",
    gap: theme.spacing(1)
  })
});
const getStyles$19 = (theme, isTruncated) => {
  return {
    wrapper: css.css({
      position: "relative",
      alignItems: isTruncated ? "center" : "unset",
      display: "flex",
      flex: "1 1 auto",
      flexWrap: "wrap",
      flexShrink: isTruncated ? 0 : 1,
      justifyContent: "flex-end",
      gap: "6px"
    }),
    moreTagsLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm
    }),
    li: css.css({
      listStyle: "none"
    })
  };
};

"use strict";
const FilterPill = ({ label, selected, onClick, icon = "check" }) => {
  const styles = useStyles2(getStyles$18);
  const clearButton = useStyles2(clearButtonStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("button", { type: "button", className: css.cx(clearButton, styles.wrapper, selected && styles.selected), onClick, children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: label }),
    selected && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, className: styles.icon })
  ] });
};
const getStyles$18 = (theme) => {
  return {
    wrapper: css.css({
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.pill,
      padding: theme.spacing(0, 2),
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      lineHeight: theme.typography.bodySmall.lineHeight,
      color: theme.colors.text.secondary,
      display: "flex",
      alignItems: "center",
      height: "32px",
      position: "relative",
      border: `1px solid ${theme.colors.background.secondary}`,
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary
      }
    }),
    selected: css.css({
      color: theme.colors.text.primary,
      background: theme.colors.action.selected,
      "&:hover": {
        background: theme.colors.action.focus
      }
    }),
    icon: css.css({
      marginLeft: theme.spacing(0.5)
    })
  };
};

"use strict";
const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("h2", { className: styles.modalHeaderTitle, id, children: title }),
    children
  ] });
};

"use strict";
function Modal(props) {
  const {
    title,
    children,
    isOpen = false,
    closeOnEscape = true,
    closeOnBackdropClick = true,
    className,
    contentClassName,
    onDismiss,
    onClickBackdrop,
    trapFocus = true
  } = props;
  const styles = useStyles2(getModalStyles);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    { isKeyboardDismissDisabled: !closeOnEscape, isOpen, onClose: onDismiss },
    ref
  );
  const { dialogProps, titleProps } = dialog.useDialog({}, ref);
  if (!isOpen) {
    return null;
  }
  const headerClass = css.cx(styles.modalHeader, typeof title !== "string" && styles.modalHeaderWithTabs);
  return /* @__PURE__ */ jsxRuntime.jsxs(overlays.OverlayContainer, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        role: "presentation",
        className: styles.modalBackdrop,
        onClick: onClickBackdrop || (closeOnBackdropClick ? onDismiss : void 0),
        ...underlayProps
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: trapFocus, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.modal, className), ref, ...overlayProps, ...dialogProps, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: headerClass, children: [
        typeof title === "string" && /* @__PURE__ */ jsxRuntime.jsx(DefaultModalHeader, { ...props, title, id: titleProps.id }),
        // FIXME: custom title components won't get an accessible title.
        // Do we really want to support them or shall we just limit this ModalTabsHeader?
        typeof title !== "string" && title,
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalHeaderClose, children: /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "times",
            size: "xl",
            onClick: onDismiss,
            "aria-label": t("grafana-ui.modal.close-tooltip", "Close")
          }
        ) })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.modalContent, contentClassName), children })
    ] }) })
  ] });
}
function ModalButtonRow({ leftItems, children }) {
  const styles = useStyles2(getModalStyles);
  if (leftItems) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", children: [
      /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-start", gap: 2, children: leftItems }),
      /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-end", gap: 2, children })
    ] }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-end", gap: 2, wrap: "wrap", children }) });
}
Modal.ButtonRow = ModalButtonRow;
function DefaultModalHeader({ icon, iconTooltip, title, id }) {
  return /* @__PURE__ */ jsxRuntime.jsx(ModalHeader, { icon, iconTooltip, title, id });
}

"use strict";
const ConfirmContent = ({
  body,
  confirmPromptText,
  confirmButtonLabel,
  confirmButtonVariant,
  dismissButtonVariant,
  dismissButtonLabel,
  onConfirm,
  onDismiss,
  onAlternative,
  alternativeButtonLabel,
  description,
  justifyButtons = "flex-end",
  disabled
}) => {
  const [isDisabled, setIsDisabled] = React.useState(disabled);
  const styles = useStyles2(getStyles$17);
  const buttonRef = React.useRef(null);
  const onConfirmationTextChange = (event) => {
    setIsDisabled((confirmPromptText == null ? void 0 : confirmPromptText.toLowerCase().localeCompare(event.currentTarget.value.toLowerCase())) !== 0);
  };
  React.useEffect(() => {
    var _a;
    (_a = buttonRef.current) == null ? void 0 : _a.focus();
  }, []);
  React.useEffect(() => {
    setIsDisabled(disabled ? true : Boolean(confirmPromptText));
  }, [confirmPromptText, disabled]);
  const onConfirmClick = async () => {
    if (disabled === void 0) {
      setIsDisabled(true);
    }
    try {
      await onConfirm();
    } finally {
      if (disabled === void 0) {
        setIsDisabled(false);
      }
    }
  };
  const { handleSubmit } = reactHookForm.useForm();
  const placeholder = t("grafana-ui.confirm-content.placeholder", 'Type "{{confirmPromptText}}" to confirm', {
    confirmPromptText
  });
  return /* @__PURE__ */ jsxRuntime.jsxs("form", { onSubmit: handleSubmit(onConfirmClick), children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.text, children: [
      body,
      description ? /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.description, children: description }) : null,
      confirmPromptText ? /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.confirmationInput, children: /* @__PURE__ */ jsxRuntime.jsx(Stack, { alignItems: "flex-start", children: /* @__PURE__ */ jsxRuntime.jsx(Field, { disabled, children: /* @__PURE__ */ jsxRuntime.jsx(Input, { placeholder, onChange: onConfirmationTextChange }) }) }) }) : null
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.buttonsContainer, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: justifyButtons, gap: 2, wrap: "wrap", children: [
      /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: dismissButtonVariant, onClick: onDismiss, fill: "outline", children: dismissButtonLabel }),
      /* @__PURE__ */ jsxRuntime.jsx(
        Button,
        {
          type: "submit",
          variant: confirmButtonVariant,
          disabled: isDisabled,
          ref: buttonRef,
          "data-testid": e2eSelectors.selectors.pages.ConfirmModal.delete,
          children: confirmButtonLabel
        }
      ),
      onAlternative ? /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "primary", onClick: onAlternative, children: alternativeButtonLabel }) : null
    ] }) })
  ] });
};
const getStyles$17 = (theme) => ({
  text: css.css({
    fontSize: theme.typography.h5.fontSize,
    color: theme.colors.text.primary
  }),
  description: css.css({
    fontSize: theme.typography.body.fontSize
  }),
  confirmationInput: css.css({
    paddingTop: theme.spacing(1)
  }),
  buttonsContainer: css.css({
    paddingTop: theme.spacing(3)
  })
});

"use strict";
const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive",
  disabled
}) => {
  const styles = useStyles2(getStyles$16);
  return /* @__PURE__ */ jsxRuntime.jsx(Modal, { className: css.cx(styles.modal, modalClass), title, icon, isOpen, onDismiss, children: /* @__PURE__ */ jsxRuntime.jsx(
    ConfirmContent,
    {
      body,
      description,
      confirmButtonLabel: confirmText,
      dismissButtonLabel: dismissText,
      dismissButtonVariant: dismissVariant,
      confirmPromptText: confirmationText,
      alternativeButtonLabel: alternativeText,
      confirmButtonVariant,
      onConfirm,
      onDismiss,
      onAlternative,
      disabled
    }
  ) });
};
const getStyles$16 = () => ({
  modal: css.css({
    width: "500px"
  })
});

"use strict";
const BRACES = {
  "[": "]",
  "{": "}",
  "(": ")"
};
const MATCH_MARK = "brace_match";
function BracesPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const { value } = editor;
      switch (event.key) {
        case "(":
        case "{":
        case "[": {
          const {
            start: { offset: startOffset, key: startKey },
            end: { offset: endOffset, key: endKey },
            focus: { offset: focusOffset }
          } = value.selection;
          const text = value.focusText.text;
          if (value.selection.isExpanded) {
            event.preventDefault();
            editor.insertTextByKey(startKey, startOffset, event.key).insertTextByKey(endKey, endOffset + 1, BRACES[event.key]).moveEndBackward(1);
            return true;
          } else if (
            // Insert matching brace when there is no input after caret
            focusOffset === text.length || text[focusOffset] === " " || Object.values(BRACES).includes(text[focusOffset])
          ) {
            event.preventDefault();
            const complement = BRACES[event.key];
            const matchAnnotation = {
              key: `${MATCH_MARK}-${uuid.v4()}`,
              type: `${MATCH_MARK}-${complement}`,
              anchor: {
                key: startKey,
                offset: startOffset,
                object: "point"
              },
              focus: {
                key: endKey,
                offset: endOffset + 1,
                object: "point"
              },
              object: "annotation"
            };
            editor.insertText(event.key).insertText(complement).addAnnotation(matchAnnotation).moveBackward(1);
            return true;
          }
          break;
        }
        case ")":
        case "}":
        case "]": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const nextChar = text[offset];
          const complement = event.key;
          const annotationType = `${MATCH_MARK}-${complement}`;
          const annotation = value.annotations.find(
            (a) => (a == null ? void 0 : a.type) === annotationType && a.anchor.key === value.anchorText.key
          );
          if (annotation && nextChar === complement && !value.selection.isExpanded) {
            event.preventDefault();
            editor.moveFocusForward(1).removeAnnotation(annotation).moveAnchorForward(1);
            return true;
          }
          break;
        }
        case "Backspace": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const previousChar = text[offset - 1];
          const nextChar = text[offset];
          if (BRACES[previousChar] && BRACES[previousChar] === nextChar) {
            event.preventDefault();
            editor.deleteBackward(1).deleteForward(1).focus();
            return true;
          }
        }
        default: {
          break;
        }
      }
      return next();
    }
  };
}

"use strict";
function ClearPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "k" && event.ctrlKey) {
        event.preventDefault();
        const text = value.anchorText.text;
        const offset = value.selection.anchor.offset;
        const length = text.length;
        const forward = length - offset;
        editor.deleteForward(forward);
        return true;
      }
      return next();
    }
  };
}

"use strict";
const getCopiedText = (textBlocks, startOffset, endOffset) => {
  if (!textBlocks.length) {
    return void 0;
  }
  const excludingLastLineLength = textBlocks.slice(0, -1).join("").length + textBlocks.length - 1;
  return textBlocks.join("\n").slice(startOffset, excludingLastLineLength + endOffset);
};
const removeBom = (str) => {
  return str == null ? void 0 : str.replace(/[\uFEFF]/g, "");
};
function ClipboardPlugin() {
  const clipboardPlugin = {
    onCopy(event, editor, next) {
      event.preventDefault();
      const { document, selection } = editor.value;
      const {
        start: { offset: startOffset },
        end: { offset: endOffset }
      } = selection;
      const selectedBlocks = document.getLeafBlocksAtRange(selection).toArray().map((block) => block.text);
      const copiedText = removeBom(getCopiedText(selectedBlocks, startOffset, endOffset));
      if (copiedText && event.clipboardData) {
        event.clipboardData.setData("Text", copiedText);
      }
      return true;
    },
    onPaste(event, editor, next) {
      event.preventDefault();
      if (event.clipboardData) {
        const pastedValue = removeBom(event.clipboardData.getData("Text"));
        const lines = pastedValue == null ? void 0 : pastedValue.split("\n");
        if (lines && lines.length) {
          editor.insertText(lines[0]);
          for (const line of lines.slice(1)) {
            editor.splitBlock().insertText(line);
          }
        }
      }
      return true;
    }
  };
  return {
    ...clipboardPlugin,
    onCut(event, editor, next) {
      clipboardPlugin.onCopy(event, editor, next);
      editor.deleteAtRange(editor.value.selection);
      return true;
    }
  };
}

"use strict";
const isIndentLeftHotkey = isHotkey.isKeyHotkey("mod+[");
const isShiftTabHotkey = isHotkey.isKeyHotkey("shift+tab");
const isIndentRightHotkey = isHotkey.isKeyHotkey("mod+]");
const SLATE_TAB = "  ";
const handleTabKey = (event, editor, next) => {
  const {
    startBlock,
    endBlock,
    selection: {
      start: { offset: startOffset, key: startKey },
      end: { offset: endOffset, key: endKey }
    }
  } = editor.value;
  if (Plain__default.default.serialize(editor.value) === "") {
    return;
  }
  event.preventDefault();
  const first = startBlock.getFirstText();
  const startBlockIsSelected = first && startOffset === 0 && startKey === first.key && endOffset === first.text.length && endKey === first.key;
  if (startBlockIsSelected || !startBlock.equals(endBlock)) {
    handleIndent(editor, "right");
  } else {
    editor.insertText(SLATE_TAB);
  }
};
const handleIndent = (editor, indentDirection) => {
  const curSelection = editor.value.selection;
  const selectedBlocks = editor.value.document.getLeafBlocksAtRange(curSelection).toArray();
  if (indentDirection === "left") {
    for (const block of selectedBlocks) {
      const blockWhitespace = block.text.length - block.text.trimLeft().length;
      const textKey = block.getFirstText().key;
      const rangeProperties = {
        anchor: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        },
        focus: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        }
      };
      editor.deleteBackwardAtRange(slate.Range.create(rangeProperties), Math.min(SLATE_TAB.length, blockWhitespace));
    }
  } else {
    const { startText } = editor.value;
    const textBeforeCaret = startText.text.slice(0, curSelection.start.offset);
    const isWhiteSpace = /^\s*$/.test(textBeforeCaret);
    for (const block of selectedBlocks) {
      editor.insertTextByKey(block.getFirstText().key, 0, SLATE_TAB);
    }
    if (isWhiteSpace) {
      editor.moveStartBackward(SLATE_TAB.length);
    }
  }
};
function IndentationPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isIndentLeftHotkey(event) || isShiftTabHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "left");
      } else if (isIndentRightHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "right");
      } else if (event.key === "Tab") {
        handleTabKey(event, editor, next);
      } else {
        return next();
      }
      return true;
    }
  };
}

"use strict";
function getIndent(text) {
  let offset = text.length - text.trimLeft().length;
  if (offset) {
    let indent = text[0];
    while (--offset) {
      indent += text[0];
    }
    return indent;
  }
  return "";
}
function NewlinePlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "Enter") {
        event.preventDefault();
        const { startBlock } = value;
        const currentLineText = startBlock.text;
        const indent = getIndent(currentLineText);
        return editor.splitBlock().insertText(indent).focus();
      }
      return next();
    }
  };
}

"use strict";
function RunnerPlugin({ handler }) {
  return {
    onKeyDown(event, editor, next) {
      if (handler && event.key === "Enter" && (event.shiftKey || event.ctrlKey)) {
        event.preventDefault();
        handler(event);
        return editor;
      }
      return next();
    }
  };
}

"use strict";
const isSelectLineHotkey = isHotkey.isKeyHotkey("mod+l");
function SelectionShortcutsPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isSelectLineHotkey(event)) {
        event.preventDefault();
        const { focusBlock, document } = editor.value;
        editor.moveAnchorToStartOfBlock();
        const nextBlock = document.getNextBlock(focusBlock.key);
        if (nextBlock) {
          editor.moveFocusToStartOfNextBlock();
        } else {
          editor.moveFocusToEndOfText();
        }
      } else {
        return next();
      }
      return true;
    }
  };
}

"use strict";
const TOKEN_MARK = "prism-token";

"use strict";
function defaultOnlyIn(node) {
  return node.object === "block" && node.type === "code_block";
}
function defaultGetSyntax(node) {
  return "javascript";
}
function defaultRenderDecoration(props, editor, next) {
  const { decoration } = props;
  if (decoration.type !== TOKEN_MARK) {
    return next();
  }
  const className = decoration.data.get("className");
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className, children: props.children });
}
class Options extends immutable.Record({
  onlyIn: defaultOnlyIn,
  getSyntax: defaultGetSyntax,
  renderDecoration: defaultRenderDecoration
}) {
  constructor(props) {
    super(props);
  }
}

"use strict";
function SlatePrism(optsParam = {}, prismLanguages = Prism__default.default.languages) {
  const opts = new Options(optsParam);
  return {
    decorateNode: (node, editor, next) => {
      if (!opts.onlyIn(node)) {
        return next();
      }
      const block = slate.Block.create(node);
      const grammarName = opts.getSyntax(block);
      const grammar = prismLanguages[grammarName];
      if (!grammar) {
        return [];
      }
      const texts = block.getTexts();
      const blockText = texts.map((text) => text && text.getText()).join("\n");
      const tokens = Prism__default.default.tokenize(blockText, grammar);
      const flattened = flattenTokens(tokens);
      const newData = editor.value.data.set("tokens", flattened);
      editor.setData(newData);
      return decorateNode(opts, tokens, block);
    },
    renderDecoration: (props, editor, next) => opts.renderDecoration(
      {
        children: props.children,
        decoration: props.decoration
      },
      editor,
      next
    )
  };
}
function decorateNode(opts, tokens, block) {
  const texts = block.getTexts();
  const decorations = [];
  let textStart = 0;
  let textEnd = 0;
  texts.forEach((text) => {
    textEnd = textStart + text.getText().length;
    let offset = 0;
    function processToken(token, accu) {
      if (typeof token === "string") {
        if (accu) {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
        }
        offset += token.length;
      } else {
        accu = `${accu} ${token.type}`;
        if (token.alias) {
          accu += " " + token.alias;
        }
        if (typeof token.content === "string") {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.content.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
          offset += token.content.length;
        } else {
          for (let i = 0; i < token.content.length; i += 1) {
            processToken(token.content[i], accu);
          }
        }
      }
    }
    tokens.forEach(processToken);
    textStart = textEnd + 1;
  });
  return decorations;
}
function createDecoration({
  text,
  textStart,
  textEnd,
  start,
  end,
  className,
  block
}) {
  if (start >= textEnd || end <= textStart) {
    return null;
  }
  start = Math.max(start, textStart);
  end = Math.min(end, textEnd);
  start -= textStart;
  end -= textStart;
  const myDec = block.createDecoration({
    object: "decoration",
    anchor: {
      key: text.key,
      offset: start,
      object: "point"
    },
    focus: {
      key: text.key,
      offset: end,
      object: "point"
    },
    type: TOKEN_MARK,
    data: { className }
  });
  return myDec;
}
function flattenToken(token) {
  if (typeof token === "string") {
    return [
      {
        content: token,
        types: [],
        aliases: []
      }
    ];
  } else if (Array.isArray(token)) {
    return token.flatMap((t) => flattenToken(t));
  } else if (token instanceof Prism__default.default.Token) {
    return flattenToken(token.content).flatMap((t) => {
      var _a;
      let aliases = [];
      if (typeof token.alias === "string") {
        aliases = [token.alias];
      } else {
        aliases = (_a = token.alias) != null ? _a : [];
      }
      return {
        content: t.content,
        types: [token.type, ...t.types],
        aliases: [...aliases, ...t.aliases]
      };
    });
  }
  return [];
}
function flattenTokens(token) {
  const tokens = flattenToken(token);
  if (!tokens.length) {
    return [];
  }
  const firstToken = tokens[0];
  firstToken.prev = null;
  firstToken.next = tokens.length >= 2 ? tokens[1] : null;
  firstToken.offsets = {
    start: 0,
    end: firstToken.content.length
  };
  for (let i = 1; i < tokens.length - 1; i++) {
    tokens[i].prev = tokens[i - 1];
    tokens[i].next = tokens[i + 1];
    tokens[i].offsets = {
      start: tokens[i - 1].offsets.end,
      end: tokens[i - 1].offsets.end + tokens[i].content.length
    };
  }
  const lastToken = tokens[tokens.length - 1];
  lastToken.prev = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
  lastToken.next = null;
  lastToken.offsets = {
    start: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end : 0,
    end: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end + lastToken.content.length : lastToken.content.length
  };
  return tokens;
}

"use strict";
const flattenGroupItems = (groupedItems) => {
  return groupedItems.reduce((all, { items, label }) => {
    all.push({
      label,
      kind: CompletionItemKind.GroupTitle
    });
    return items.reduce((all2, item) => {
      all2.push(item);
      return all2;
    }, all);
  }, []);
};
const calculateLongestLabel = (allItems) => {
  return allItems.reduce((longest, current) => {
    return longest.length < current.label.length ? current.label : longest;
  }, "");
};
const calculateListSizes = (theme, allItems, longestLabel) => {
  const size = calculateSize__default.default(longestLabel, {
    font: theme.typography.fontFamilyMonospace,
    fontSize: theme.typography.bodySmall.fontSize,
    fontWeight: "normal"
  });
  const listWidth = calculateListWidth(size.width, theme);
  const itemHeight = calculateItemHeight(size.height, theme);
  const listHeight = calculateListHeight(itemHeight, allItems);
  return {
    listWidth,
    listHeight,
    itemHeight
  };
};
const calculateItemHeight = (longestLabelHeight, theme) => {
  const horizontalPadding = theme.spacing.gridSize * 2;
  const itemHeight = longestLabelHeight + horizontalPadding;
  return itemHeight;
};
const calculateListWidth = (longestLabelWidth, theme) => {
  const verticalPadding = theme.spacing.gridSize * 3;
  const maxWidth = 800;
  const listWidth = Math.min(Math.max(longestLabelWidth + verticalPadding, 200), maxWidth);
  return listWidth;
};
const calculateListHeight = (itemHeight, allItems) => {
  const numberOfItemsToShow = Math.min(allItems.length, 10);
  const minHeight = 100;
  const totalHeight = numberOfItemsToShow * itemHeight;
  const listHeight = Math.max(totalHeight, minHeight);
  return listHeight;
};

"use strict";
const getStyles$15 = (theme, height, visible) => {
  return {
    typeaheadItem: css.css({
      label: "type-ahead-item",
      zIndex: 11,
      padding: theme.spacing(1, 1, 1, 2),
      border: theme.colors.border.medium,
      overflowY: "scroll",
      overflowX: "hidden",
      outline: "none",
      background: theme.colors.background.secondary,
      color: theme.colors.text.secondary,
      boxShadow: `0 0 20px ${theme.v1.colors.dropdownShadow}`,
      visibility: visible === true ? "visible" : "hidden",
      width: "250px",
      minHeight: `${height + parseInt(theme.spacing(0.25), 10)}px`,
      position: "relative",
      wordBreak: "break-word"
    })
  };
};
const TypeaheadInfo = ({ item, height }) => {
  const visible = item && !!item.documentation;
  const label = item ? item.label : "";
  const documentation = data.renderMarkdown(item == null ? void 0 : item.documentation);
  const theme = useTheme2();
  const styles = getStyles$15(theme, height, visible);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx([styles.typeaheadItem]), children: [
    /* @__PURE__ */ jsxRuntime.jsx("b", { children: label }),
    /* @__PURE__ */ jsxRuntime.jsx("hr", {}),
    /* @__PURE__ */ jsxRuntime.jsx("div", { dangerouslySetInnerHTML: { __html: documentation } })
  ] });
};

"use strict";
function getStartIndices(parts, length) {
  const indices = [];
  parts.forEach((part) => {
    indices.push(part.start, part.end + 1);
  });
  if (indices[0] !== 0) {
    indices.unshift(0);
  }
  if (indices[indices.length - 1] !== length) {
    indices.push(length);
  }
  return indices;
}
const PartialHighlighter = (props) => {
  let { highlightParts, text, highlightClassName } = props;
  if (!(highlightParts == null ? void 0 : highlightParts.length)) {
    return null;
  }
  let children = [];
  let indices = getStartIndices(highlightParts, text.length);
  let highlighted = highlightParts[0].start === 0;
  for (let i = 1; i < indices.length; i++) {
    let start = indices[i - 1];
    let end = indices[i];
    children.push(
      React.createElement(
        highlighted ? "mark" : "span",
        {
          key: i - 1,
          className: highlighted ? highlightClassName : void 0
        },
        text.substring(start, end)
      )
    );
    highlighted = !highlighted;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { children });
};

"use strict";
const getStyles$14 = (theme) => ({
  typeaheadItem: css.css({
    border: "none",
    background: "none",
    textAlign: "left",
    label: "type-ahead-item",
    height: "auto",
    fontFamily: theme.typography.fontFamilyMonospace,
    padding: theme.spacing(1, 1, 1, 2),
    fontSize: theme.typography.bodySmall.fontSize,
    textOverflow: "ellipsis",
    overflow: "hidden",
    zIndex: 11,
    display: "block",
    whiteSpace: "nowrap",
    cursor: "pointer",
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: "color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), border-color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), background 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), padding 0.15s cubic-bezier(0.645, 0.045, 0.355, 1)"
    }
  }),
  typeaheadItemSelected: css.css({
    label: "type-ahead-item-selected",
    backgroundColor: theme.colors.background.secondary
  }),
  typeaheadItemMatch: css.css({
    label: "type-ahead-item-match",
    color: theme.v1.palette.yellow,
    borderBottom: `1px solid ${theme.v1.palette.yellow}`,
    padding: "inherit",
    background: "inherit"
  }),
  typeaheadItemGroupTitle: css.css({
    label: "type-ahead-item-group-title",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.bodySmall.fontSize,
    lineHeight: theme.typography.body.lineHeight,
    padding: theme.spacing(1)
  })
});
const TypeaheadItem = (props) => {
  const styles = useStyles2(getStyles$14);
  const { isSelected, item, prefix, style, onMouseEnter, onMouseLeave, onClickItem } = props;
  const className = isSelected ? css.cx([styles.typeaheadItem, styles.typeaheadItemSelected]) : css.cx([styles.typeaheadItem]);
  const highlightClassName = css.cx([styles.typeaheadItemMatch]);
  const itemGroupTitleClassName = css.cx([styles.typeaheadItemGroupTitle]);
  const label = item.label || "";
  if (item.kind === CompletionItemKind.GroupTitle) {
    return /* @__PURE__ */ jsxRuntime.jsx("li", { className: itemGroupTitleClassName, style, children: /* @__PURE__ */ jsxRuntime.jsx("span", { children: label }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx("li", { role: "none", children: /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      role: "menuitem",
      className,
      style,
      onMouseDown: onClickItem,
      onMouseEnter,
      onMouseLeave,
      type: "button",
      children: item.highlightParts !== void 0 ? /* @__PURE__ */ jsxRuntime.jsx(
        PartialHighlighter,
        {
          text: label,
          highlightClassName,
          highlightParts: item.highlightParts
        }
      ) : /* @__PURE__ */ jsxRuntime.jsx(
        Highlighter__default.default,
        {
          textToHighlight: label,
          searchWords: [prefix != null ? prefix : ""],
          autoEscape: true,
          highlightClassName
        }
      )
    }
  ) });
};

"use strict";
const modulo$1 = (a, n) => a - n * Math.floor(a / n);
class Typeahead extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.listRef = React.createRef();
    this.state = {
      hoveredItem: null,
      typeaheadIndex: null,
      allItems: [],
      listWidth: -1,
      listHeight: -1,
      itemHeight: -1
    };
    this.componentDidMount = () => {
      if (this.props.menuRef) {
        this.props.menuRef(this);
      }
      document.addEventListener("selectionchange", this.handleSelectionChange);
      const allItems = flattenGroupItems(this.props.groupedItems);
      const longestLabel = calculateLongestLabel(allItems);
      const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
      this.setState({
        listWidth,
        listHeight,
        itemHeight,
        allItems
      });
    };
    this.componentWillUnmount = () => {
      document.removeEventListener("selectionchange", this.handleSelectionChange);
    };
    this.handleSelectionChange = () => {
      this.forceUpdate();
    };
    this.componentDidUpdate = (prevProps, prevState) => {
      if (this.state.typeaheadIndex !== null && prevState.typeaheadIndex !== this.state.typeaheadIndex && this.listRef && this.listRef.current) {
        if (this.state.typeaheadIndex === 1) {
          this.listRef.current.scrollToItem(0);
          return;
        }
        this.listRef.current.scrollToItem(this.state.typeaheadIndex);
      }
      if (lodash.isEqual(prevProps.groupedItems, this.props.groupedItems) === false) {
        const allItems = flattenGroupItems(this.props.groupedItems);
        const longestLabel = calculateLongestLabel(allItems);
        const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
        this.setState({ listWidth, listHeight, itemHeight, allItems, typeaheadIndex: null });
      }
    };
    this.onMouseEnter = (index) => {
      this.setState({
        hoveredItem: index
      });
    };
    this.onMouseLeave = () => {
      this.setState({
        hoveredItem: null
      });
    };
    this.moveMenuIndex = (moveAmount) => {
      const itemCount = this.state.allItems.length;
      if (itemCount) {
        const typeaheadIndex = this.state.typeaheadIndex || 0;
        let newTypeaheadIndex = modulo$1(typeaheadIndex + moveAmount, itemCount);
        if (this.state.allItems[newTypeaheadIndex].kind === CompletionItemKind.GroupTitle) {
          newTypeaheadIndex = modulo$1(newTypeaheadIndex + moveAmount, itemCount);
        }
        this.setState({
          typeaheadIndex: newTypeaheadIndex
        });
        return;
      }
    };
    this.insertSuggestion = () => {
      if (this.props.onSelectSuggestion && this.state.typeaheadIndex !== null) {
        this.props.onSelectSuggestion(this.state.allItems[this.state.typeaheadIndex]);
      }
    };
  }
  get menuPosition() {
    if (!window.getSelection) {
      return "";
    }
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      const scrollX = window.scrollX;
      const scrollY = window.scrollY;
      return `position: absolute; display: flex; top: ${rect.top + scrollY + rect.height + 6}px; left: ${rect.left + scrollX - 2}px`;
    }
    return "";
  }
  render() {
    const { prefix, isOpen = false, origin } = this.props;
    const { allItems, listWidth, listHeight, itemHeight, hoveredItem, typeaheadIndex } = this.state;
    const styles = getStyles$13(this.context);
    const showDocumentation = hoveredItem || typeaheadIndex;
    const documentationItem = allItems[hoveredItem ? hoveredItem : typeaheadIndex || 0];
    return /* @__PURE__ */ jsxRuntime.jsxs(Portal, { origin, isOpen, style: this.menuPosition, children: [
      /* @__PURE__ */ jsxRuntime.jsx("ul", { role: "menu", className: styles.typeahead, "data-testid": "typeahead", children: /* @__PURE__ */ jsxRuntime.jsx(
        reactWindow.FixedSizeList,
        {
          ref: this.listRef,
          itemCount: allItems.length,
          itemSize: itemHeight,
          itemKey: (index) => {
            const item = allItems && allItems[index];
            const key = item ? `${index}-${item.label}` : `${index}`;
            return key;
          },
          width: listWidth,
          height: listHeight,
          children: ({ index, style }) => {
            const item = allItems && allItems[index];
            if (!item) {
              return null;
            }
            return /* @__PURE__ */ jsxRuntime.jsx(
              TypeaheadItem,
              {
                onClickItem: () => this.props.onSelectSuggestion ? this.props.onSelectSuggestion(item) : {},
                isSelected: typeaheadIndex === null ? false : allItems[typeaheadIndex] === item,
                item,
                prefix,
                style,
                onMouseEnter: () => this.onMouseEnter(index),
                onMouseLeave: this.onMouseLeave
              }
            );
          }
        }
      ) }),
      showDocumentation && /* @__PURE__ */ jsxRuntime.jsx(TypeaheadInfo, { height: listHeight, item: documentationItem })
    ] });
  }
}
Typeahead.contextType = data.ThemeContext;
class Portal extends React.PureComponent {
  constructor(props) {
    super(props);
    const { index = 0, origin = "query", style } = props;
    this.node = document.createElement("div");
    this.node.setAttribute("style", style);
    this.node.classList.add(`slate-typeahead-${origin}-${index}`);
    document.body.appendChild(this.node);
  }
  componentWillUnmount() {
    document.body.removeChild(this.node);
  }
  render() {
    if (this.props.isOpen) {
      this.node.setAttribute("style", this.props.style);
      this.node.classList.add(`slate-typeahead--open`);
      return ReactDOM__default.default.createPortal(this.props.children, this.node);
    } else {
      this.node.classList.remove(`slate-typeahead--open`);
    }
    return null;
  }
}
const getStyles$13 = (theme) => ({
  typeahead: css.css({
    position: "relative",
    zIndex: theme.zIndex.typeahead,
    borderRadius: theme.shape.radius.default,
    border: `1px solid ${theme.components.panel.borderColor}`,
    maxHeight: "66vh",
    overflowY: "scroll",
    overflowX: "hidden",
    outline: "none",
    listStyle: "none",
    background: theme.components.panel.background,
    color: theme.colors.text.primary,
    boxShadow: theme.shadows.z2,
    strong: {
      color: theme.v1.palette.yellow
    }
  })
});

"use strict";
const TYPEAHEAD_DEBOUNCE = 250;
function SuggestionsPlugin({
  onTypeahead,
  cleanText,
  onWillApplySuggestion,
  portalOrigin
}) {
  let typeaheadRef;
  let state = {
    groupedItems: [],
    typeaheadPrefix: "",
    typeaheadContext: "",
    typeaheadText: ""
  };
  const handleTypeaheadDebounced = lodash.debounce(handleTypeahead, TYPEAHEAD_DEBOUNCE);
  const setState = (update) => {
    state = {
      ...state,
      ...update
    };
  };
  return {
    onBlur: (event, editor, next) => {
      state = {
        ...state,
        groupedItems: []
      };
      return next();
    },
    onClick: (event, editor, next) => {
      state = {
        ...state,
        groupedItems: []
      };
      return next();
    },
    onKeyDown: (event, editor, next) => {
      const currentSuggestions = state.groupedItems;
      const hasSuggestions = currentSuggestions.length;
      switch (event.key) {
        case "Escape": {
          if (hasSuggestions) {
            event.preventDefault();
            state = {
              ...state,
              groupedItems: []
            };
            return editor.insertText("");
          }
          break;
        }
        case "ArrowDown":
        case "ArrowUp":
          if (hasSuggestions) {
            event.preventDefault();
            typeaheadRef.moveMenuIndex(event.key === "ArrowDown" ? 1 : -1);
            return;
          }
          break;
        case "Enter": {
          if (!(event.shiftKey || event.ctrlKey) && hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        case "Tab": {
          if (hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        default: {
          if (event.key.length === 1) {
            handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
          }
          break;
        }
      }
      return next();
    },
    commands: {
      selectSuggestion: (editor, suggestion) => {
        const suggestions = state.groupedItems;
        if (!suggestions || !suggestions.length) {
          return editor;
        }
        const ed = editor.applyTypeahead(suggestion);
        handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
        return ed;
      },
      applyTypeahead: (editor, suggestion) => {
        let suggestionText = suggestion.insertText || suggestion.label;
        const preserveSuffix = suggestion.kind === "function";
        const move = suggestion.move || 0;
        const moveForward = move > 0 ? move : 0;
        const moveBackward = move < 0 ? -move : 0;
        const { typeaheadPrefix, typeaheadText, typeaheadContext } = state;
        if (onWillApplySuggestion) {
          suggestionText = onWillApplySuggestion(suggestionText, {
            groupedItems: state.groupedItems,
            typeaheadContext,
            typeaheadPrefix,
            typeaheadText
          });
        }
        const { forward, backward } = getNumCharsToDelete(
          suggestionText,
          typeaheadPrefix,
          typeaheadText,
          preserveSuffix,
          suggestion.deleteBackwards,
          cleanText
        );
        if (suggestionText.match(/\n/)) {
          const fragment = makeFragment(suggestionText);
          editor.deleteBackward(backward).deleteForward(forward).insertFragment(fragment).focus();
          return editor;
        }
        state = {
          ...state,
          groupedItems: []
        };
        editor.snapshotSelection().deleteBackward(backward).deleteForward(forward).insertText(suggestionText).moveForward(moveForward).moveBackward(moveBackward).focus();
        return editor;
      }
    },
    renderEditor(props, editor, next) {
      if (editor.value.selection.isExpanded) {
        return next();
      }
      const children = next();
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        children,
        /* @__PURE__ */ jsxRuntime.jsx(
          Typeahead,
          {
            menuRef: (menu) => typeaheadRef = menu,
            origin: portalOrigin,
            prefix: state.typeaheadPrefix,
            isOpen: !!state.groupedItems.length,
            groupedItems: state.groupedItems,
            onSelectSuggestion: editor.selectSuggestion
          }
        )
      ] });
    }
  };
}
const handleTypeahead = async (editor, onStateChange, onTypeahead, cleanText) => {
  if (!onTypeahead) {
    return;
  }
  const { value } = editor;
  const { selection } = value;
  const parentBlock = value.document.getClosestBlock(value.focusBlock.key);
  const selectionStartOffset = value.selection.start.offset - 1;
  const decorations = parentBlock && parentBlock.getDecorations(editor);
  const filteredDecorations = decorations ? decorations.filter(
    (decoration) => decoration.start.offset <= selectionStartOffset && decoration.end.offset > selectionStartOffset && decoration.type === TOKEN_MARK
  ).toArray() : [];
  const labelKeyDec = decorations && decorations.filter(
    (decoration) => decoration.end.offset <= selectionStartOffset && decoration.type === TOKEN_MARK && decoration.data.get("className").includes("label-key")
  ).last();
  const labelKey = labelKeyDec && value.focusText.text.slice(labelKeyDec.start.offset, labelKeyDec.end.offset);
  const wrapperClasses = filteredDecorations.map((decoration) => decoration.data.get("className")).join(" ").split(" ").filter((className) => className.length);
  let text = value.focusText.text;
  let prefix = text.slice(0, selection.focus.offset);
  if (filteredDecorations.length) {
    text = value.focusText.text.slice(filteredDecorations[0].start.offset, filteredDecorations[0].end.offset);
    prefix = value.focusText.text.slice(filteredDecorations[0].start.offset, selection.focus.offset);
  }
  const labelValueMatch = prefix.match(/(?:!?=~?"?|")(.*)/);
  if (labelValueMatch) {
    prefix = labelValueMatch[1];
  } else if (cleanText) {
    prefix = cleanText(prefix);
  }
  const { suggestions, context } = await onTypeahead({
    prefix,
    text,
    value,
    wrapperClasses,
    labelKey: labelKey || void 0,
    editor
  });
  const filteredSuggestions = suggestions.map((group) => {
    if (!group.items) {
      return group;
    }
    const searchFunctionType = group.searchFunctionType || (group.prefixMatch ? SearchFunctionType.Prefix : SearchFunctionType.Word);
    const searchFunction = SearchFunctionMap[searchFunctionType];
    let newGroup = { ...group };
    if (prefix) {
      if (!group.skipFilter) {
        newGroup.items = newGroup.items.filter((c) => (c.filterText || c.label).length >= prefix.length);
        newGroup.items = searchFunction(newGroup.items, prefix);
      }
      newGroup.items = newGroup.items.filter(
        (c) => {
          var _a;
          return !(c.insertText === prefix || ((_a = c.filterText) != null ? _a : c.label) === prefix);
        }
      );
    }
    if (!group.skipSort) {
      newGroup.items = lodash.sortBy(newGroup.items, (item) => {
        if (item.sortText === void 0) {
          return item.sortValue !== void 0 ? item.sortValue : item.label;
        } else {
          return item.sortText || item.label;
        }
      });
    }
    return newGroup;
  }).filter((gr) => gr.items && gr.items.length);
  onStateChange({
    groupedItems: filteredSuggestions,
    typeaheadPrefix: prefix,
    typeaheadContext: context,
    typeaheadText: text
  });
  editor.blur().focus();
};
function getNumCharsToDelete(suggestionText, typeaheadPrefix, typeaheadText, preserveSuffix, deleteBackwards, cleanText) {
  const backward = deleteBackwards || typeaheadPrefix.length;
  const text = cleanText ? cleanText(typeaheadText) : typeaheadText;
  const offset = typeaheadText.indexOf(typeaheadPrefix);
  const suffixLength = offset > -1 ? text.length - offset - typeaheadPrefix.length : text.length - typeaheadPrefix.length;
  const midWord = Boolean(typeaheadPrefix && suffixLength > 0 || suggestionText === typeaheadText);
  const forward = midWord && !preserveSuffix ? suffixLength + offset : 0;
  return {
    forward,
    backward
  };
}

"use strict";

"use strict";
class UnThemedQueryField extends React.PureComponent {
  constructor(props) {
    super(props);
    this.lastExecutedValue = null;
    this.mounted = false;
    this.editor = null;
    /**
     * Update local state, propagate change upstream and optionally run the query afterwards.
     */
    this.onChange = (value, runQuery) => {
      const documentChanged = value.document !== this.state.value.document;
      const prevValue = this.state.value;
      if (this.props.onRichValueChange) {
        this.props.onRichValueChange(value);
      }
      this.setState({ value }, () => {
        if (documentChanged) {
          const textChanged = Plain__default.default.serialize(prevValue) !== Plain__default.default.serialize(value);
          if (textChanged && runQuery) {
            this.runOnChangeAndRunQuery();
          }
          if (textChanged && !runQuery) {
            this.runOnChangeDebounced();
          }
        }
      });
    };
    this.runOnChange = () => {
      const { onChange } = this.props;
      const value = Plain__default.default.serialize(this.state.value);
      if (onChange) {
        onChange(this.cleanText(value));
      }
    };
    this.runOnRunQuery = () => {
      const { onRunQuery } = this.props;
      if (onRunQuery) {
        onRunQuery();
        this.lastExecutedValue = this.state.value;
      }
    };
    this.runOnChangeAndRunQuery = () => {
      this.runOnChange();
      this.runOnRunQuery();
    };
    /**
     * We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur.
     */
    this.handleBlur = (_, editor, next) => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur();
      } else {
        const previousValue = this.lastExecutedValue ? Plain__default.default.serialize(this.lastExecutedValue) : "";
        const currentValue = Plain__default.default.serialize(editor.value);
        if (previousValue !== currentValue) {
          this.runOnChangeAndRunQuery();
        }
      }
      return next();
    };
    this.runOnChangeDebounced = lodash.debounce(this.runOnChange, 500);
    const { onTypeahead, cleanText, portalOrigin, onWillApplySuggestion } = props;
    this.plugins = [
      // SuggestionsPlugin and RunnerPlugin need to be before NewlinePlugin
      // because they override Enter behavior
      SuggestionsPlugin({ onTypeahead, cleanText, portalOrigin, onWillApplySuggestion }),
      RunnerPlugin({ handler: this.runOnChangeAndRunQuery }),
      NewlinePlugin(),
      ClearPlugin(),
      SelectionShortcutsPlugin(),
      IndentationPlugin(),
      ClipboardPlugin(),
      ...props.additionalPlugins || []
    ].filter((p) => p);
    this.state = {
      suggestions: [],
      typeaheadContext: null,
      typeaheadPrefix: "",
      typeaheadText: "",
      value: makeValue(props.query || "", props.syntax)
    };
  }
  componentDidMount() {
    this.mounted = true;
  }
  componentWillUnmount() {
    this.mounted = false;
  }
  componentDidUpdate(prevProps, prevState) {
    const { query, syntax, syntaxLoaded } = this.props;
    if (!prevProps.syntaxLoaded && syntaxLoaded && this.editor) {
      const editor = this.editor.insertText(" ").deleteBackward(1);
      this.onChange(editor.value, true);
    }
    const { value } = this.state;
    if (query !== prevProps.query) {
      if (query !== Plain__default.default.serialize(value)) {
        this.setState({ value: makeValue(query || "", syntax) });
      }
    }
  }
  cleanText(text) {
    const newText = text.replace(/[\r]/g, "");
    return newText;
  }
  render() {
    const { disabled, theme } = this.props;
    const wrapperClassName = classNames__default.default("slate-query-field__wrapper", {
      "slate-query-field__wrapper--disabled": disabled
    });
    const styles = getStyles$12(theme);
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(wrapperClassName, styles.wrapper), children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "slate-query-field", "data-testid": e2eSelectors.selectors.components.QueryField.container, children: /* @__PURE__ */ jsxRuntime.jsx(
      slateReact.Editor,
      {
        ref: (editor) => this.editor = editor,
        schema: SCHEMA,
        autoCorrect: false,
        readOnly: this.props.disabled,
        onBlur: this.handleBlur,
        onClick: this.props.onClick,
        onChange: (change) => {
          this.onChange(change.value, false);
        },
        placeholder: this.props.placeholder,
        plugins: this.plugins,
        spellCheck: false,
        value: this.state.value
      }
    ) }) });
  }
}
// By default QueryField calls onChange if onBlur is not defined, this will trigger a rerender
// And slate will claim the focus, making it impossible to leave the field.
UnThemedQueryField.defaultProps = {
  onBlur: () => {
  }
};
const QueryField = withTheme2(UnThemedQueryField);
const getStyles$12 = (theme) => {
  const focusStyles = getFocusStyles(theme);
  return {
    wrapper: css.css({
      "&:focus-within": focusStyles
    })
  };
};

"use strict";
function variableSuggestionToCodeEditorSuggestion(sug) {
  const label = "${" + sug.value + "}";
  const detail = sug.value === sug.label ? sug.origin : `${sug.label} / ${sug.origin}`;
  return {
    label,
    kind: CodeEditorSuggestionItemKind.Property,
    detail,
    documentation: sug.documentation
  };
}

"use strict";
const ModalTabsHeader = ({ icon, title, tabs, activeTab, onChangeTab }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(ModalHeader, { icon, title, children: /* @__PURE__ */ jsxRuntime.jsx(TabsBar, { hideBorder: true, children: tabs.map((t, index) => {
    return /* @__PURE__ */ jsxRuntime.jsx(
      Tab,
      {
        label: t.label,
        icon: t.icon,
        suffix: t.tabSuffix,
        active: t.value === activeTab,
        onChangeTab: () => onChangeTab(t)
      },
      `${t.value}-${index}`
    );
  }) }) });
};

"use strict";
const ModalTabContent = ({ children }) => {
  const styles = useStyles2(getStyles$11);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.header, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.content, children }) }) });
};
const getStyles$11 = (theme) => ({
  header: css.css({
    display: "flex",
    margin: theme.spacing(0, 0, 3, 0)
  }),
  content: css.css({
    flexGrow: 1
  })
});

"use strict";
const ModalsContext = React__namespace.createContext({
  component: null,
  props: {},
  showModal: () => {
  },
  hideModal: () => {
  }
});
class ModalsProvider extends React.Component {
  constructor(props) {
    super(props);
    this.showModal = (component, props) => {
      this.setState({
        component,
        props
      });
    };
    this.hideModal = () => {
      this.setState({
        component: null,
        props: {}
      });
    };
    this.state = {
      component: props.component || null,
      props: props.props || {},
      showModal: this.showModal,
      hideModal: this.hideModal
    };
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(ModalsContext.Provider, { value: this.state, children: this.props.children });
  }
}
const ModalRoot = () => /* @__PURE__ */ jsxRuntime.jsx(ModalsContext.Consumer, { children: ({ component: Component2, props }) => {
  return Component2 ? /* @__PURE__ */ jsxRuntime.jsx(Component2, { ...props }) : null;
} });
const ModalsController = ModalsContext.Consumer;

"use strict";
const Link = React.forwardRef(({ href, children, ...rest }, ref) => {
  const validUrl = data.locationUtil.stripBaseFromUrl(data.textUtil.sanitizeUrl(href != null ? href : ""));
  return /* @__PURE__ */ jsxRuntime.jsx(reactRouterDomV5Compat.Link, { ref, to: validUrl, ...rest, children });
});
Link.displayName = "Link";

"use strict";
const PageToolbar = React.memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles$10);
    const mainStyle = css.cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.truncateText, children: title }),
      section && /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.pre, children: [
        " / ",
        section
      ] })
    ] });
    const goBackLabel = t("grafana-ui.page-toolbar.go-back", "Go back (Esc)");
    const searchParentFolderLabel = t(
      "grafana-ui.page-toolbar.search-parent-folder",
      "Search dashboard in the {{parent}} folder",
      { parent }
    );
    const searchDashboardNameLabel = t("grafana-ui.page-toolbar.search-dashboard-name", "Search dashboard by name");
    const searchLinksLabel = t("grafana-ui.page-toolbar.search-links", "Search links");
    return /* @__PURE__ */ jsxRuntime.jsxs("nav", { className: mainStyle, "aria-label": ariaLabel, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.leftWrapper, children: [
        pageIcon && !onGoBack && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: pageIcon, size: "lg", "aria-hidden": true }) }),
        onGoBack && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "arrow-left",
            tooltip: goBackLabel,
            tooltipPlacement: "bottom",
            size: "xxl",
            "data-testid": e2eSelectors.selectors.components.BackButton.backArrow,
            onClick: onGoBack
          }
        ) }),
        /* @__PURE__ */ jsxRuntime.jsxs("nav", { "aria-label": searchLinksLabel, className: styles.navElement, children: [
          parent && parentHref && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
            /* @__PURE__ */ jsxRuntime.jsxs(
              Link,
              {
                "aria-label": searchParentFolderLabel,
                className: css.cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
                href: parentHref,
                children: [
                  parent,
                  " ",
                  /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.parentIcon })
                ]
              }
            ),
            titleHref && /* @__PURE__ */ jsxRuntime.jsx("span", { className: css.cx(styles.titleText, styles.titleDivider), "aria-hidden": true, children: "/" })
          ] }),
          (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.titleWrapper, children: [
            title && /* @__PURE__ */ jsxRuntime.jsx("h1", { className: styles.h1Styles, children: titleHref ? /* @__PURE__ */ jsxRuntime.jsx(
              Link,
              {
                "aria-label": searchDashboardNameLabel,
                className: css.cx(styles.titleText, styles.titleLink),
                href: titleHref,
                children: titleEl
              }
            ) : /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.titleText, children: titleEl }) }),
            leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                className: css.cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
                children: child
              },
              index
            ))
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(ToolbarButtonRow, { alignment: buttonOverflowAlignment, children: React.Children.toArray(children).filter(Boolean) })
    ] });
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles$10 = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css.css({
      whiteSpace: "pre"
    }),
    toolbar: css.css({
      alignItems: "center",
      background: theme.colors.background.canvas,
      display: "flex",
      gap: theme.spacing(2),
      justifyContent: "space-between",
      padding: theme.spacing(1.5, 2),
      [theme.breakpoints.down("md")]: {
        paddingLeft: "53px"
      }
    }),
    noPageIcon: css.css({
      [theme.breakpoints.down("md")]: {
        paddingLeft: theme.spacing(2)
      }
    }),
    leftWrapper: css.css({
      display: "flex",
      flexWrap: "nowrap",
      maxWidth: "70%"
    }),
    pageIcon: css.css({
      display: "none",
      [theme.breakpoints.up("sm")]: {
        display: "flex",
        paddingRight: theme.spacing(1),
        alignItems: "center"
      }
    }),
    truncateText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    }),
    titleWrapper: css.css({
      display: "flex",
      margin: 0,
      minWidth: 0
    }),
    navElement: css.css({
      display: "flex",
      alignItems: "center",
      minWidth: 0
    }),
    h1Styles: css.css({
      margin: spacing(0, 1, 0, 0),
      lineHeight: "inherit",
      flexGrow: 1,
      minWidth: 0
    }),
    parentIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    titleText: css.css({
      display: "flex",
      fontSize: typography.size.lg,
      margin: 0,
      borderRadius: theme.shape.radius.default
    }),
    titleLink: css.css({
      "&:focus-visible": focusStyle
    }),
    titleDivider: css.css({
      padding: spacing(0, 0.5, 0, 0.5),
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset"
      }
    }),
    parentLink: css.css({
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset",
        flex: 1
      }
    }),
    leftActionItem: css.css({
      display: "none",
      alignItems: "center",
      paddingRight: spacing(0.5),
      [theme.breakpoints.up("md")]: {
        display: "flex"
      }
    }),
    forceShowLeftActionItems: css.css({
      display: "flex"
    })
  };
};

"use strict";
function getIntervalFromString(strInterval) {
  return {
    label: strInterval,
    value: data.stringToMs(strInterval)
  };
}
class SetInterval extends React.PureComponent {
  constructor(props) {
    super(props);
    this.propsSubject = new rxjs.Subject();
    this.subscription = null;
  }
  componentDidMount() {
    this.subscription = this.propsSubject.pipe(
      // switchMap creates a new observables based on the input stream,
      // which becomes part of the propsSubject stream
      operators.switchMap((props) => {
        if (RefreshPicker.isLive(props.interval)) {
          return rxjs.of({});
        }
        return props.loading ? rxjs.NEVER : rxjs.interval(data.stringToMs(props.interval));
      }),
      // tap will execute function passed via func prop
      // * on value from `of` stream merged if query is live
      // * on specified interval (triggered by values emitted by interval)
      operators.tap(() => this.props.func())
    ).subscribe();
    this.propsSubject.next(this.props);
  }
  componentDidUpdate(prevProps) {
    if (RefreshPicker.isLive(prevProps.interval) && RefreshPicker.isLive(this.props.interval) || lodash.isEqual(prevProps, this.props)) {
      return;
    }
    this.propsSubject.next(this.props);
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
    this.propsSubject.unsubscribe();
  }
  render() {
    return null;
  }
}

"use strict";
function useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef) {
  React.useEffect(() => {
    var _a;
    if (variableSizeListScrollbarRef.current && tableDivRef.current) {
      const listVerticalScrollbarHTML = variableSizeListScrollbarRef.current.querySelector(".track-vertical");
      const tableScrollbarView = tableDivRef.current.firstChild;
      if (tableScrollbarView && listVerticalScrollbarHTML) {
        listVerticalScrollbarHTML.remove();
        if (tableScrollbarView instanceof HTMLElement) {
          (_a = tableScrollbarView.querySelector(":scope > .track-vertical")) == null ? void 0 : _a.remove();
          tableScrollbarView.append(listVerticalScrollbarHTML);
        }
      }
    }
  });
}
function useResetVariableListSizeCache(extendedState, listRef, data, hasUniqueId) {
  const expandedRowsRepr = JSON.stringify(Object.keys(extendedState.expanded));
  React.useEffect(() => {
    var _a;
    let resetIndex = 0;
    if (!hasUniqueId) {
      if (Number.isFinite(extendedState.lastExpandedOrCollapsedIndex)) {
        resetIndex = extendedState.lastExpandedOrCollapsedIndex;
      }
      resetIndex = extendedState.pageIndex === 0 ? resetIndex - 1 : resetIndex - extendedState.pageIndex - extendedState.pageIndex * extendedState.pageSize;
    }
    (_a = listRef.current) == null ? void 0 : _a.resetAfterIndex(Math.max(resetIndex, 0));
    return;
  }, [
    extendedState.lastExpandedOrCollapsedIndex,
    extendedState.pageSize,
    extendedState.pageIndex,
    listRef,
    data,
    expandedRowsRepr,
    hasUniqueId
  ]);
}

"use strict";
function useTableStateReducer({ onColumnResize, onSortByChange, data: data$1 }) {
  return React.useCallback(
    (newState, action) => {
      var _a, _b, _c, _d;
      switch (action.type) {
        case "columnDoneResizing":
          if (onColumnResize) {
            const info = (_b = (_a = newState.columnResizing) == null ? void 0 : _a.headerIdWidths) == null ? void 0 : _b[0];
            const columnIdString = info == null ? void 0 : info[0];
            const fieldIndex = parseInt(columnIdString, 10);
            const width = Math.round((_c = newState.columnResizing.columnWidths) == null ? void 0 : _c[columnIdString]);
            const field = (_d = data$1.fields) == null ? void 0 : _d[fieldIndex];
            if (!field) {
              return newState;
            }
            const fieldDisplayName = data.getFieldDisplayName(field, data$1);
            onColumnResize(fieldDisplayName, width);
          }
        case "toggleSortBy":
          if (onSortByChange) {
            const sortByFields = [];
            for (const sortItem of newState.sortBy) {
              const field = data$1.fields[parseInt(sortItem.id, 10)];
              if (!field) {
                continue;
              }
              sortByFields.push({
                displayName: data.getFieldDisplayName(field, data$1),
                desc: sortItem.desc
              });
            }
            onSortByChange(sortByFields);
          }
        case "toggleRowExpanded": {
          if (action.id) {
            return {
              ...newState,
              lastExpandedOrCollapsedIndex: parseInt(action.id, 10)
            };
          }
        }
      }
      return newState;
    },
    [data$1, onColumnResize, onSortByChange]
  );
}
function getInitialState(initialSortBy, columns) {
  const state = {};
  if (initialSortBy) {
    state.sortBy = [];
    for (const sortBy of initialSortBy) {
      for (const col of columns) {
        if (col.Header === sortBy.displayName) {
          state.sortBy.push({ id: col.id, desc: sortBy.desc });
        }
      }
    }
  }
  return state;
}

"use strict";
function ActionButton({ action, ...buttonProps }) {
  const [showConfirm, setShowConfirm] = React.useState(false);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        variant: "primary",
        size: "sm",
        onClick: () => setShowConfirm(true),
        ...buttonProps,
        style: { width: "fit-content" },
        children: action.title
      }
    ),
    showConfirm && /* @__PURE__ */ jsxRuntime.jsx(
      ConfirmModal,
      {
        isOpen: true,
        title: t("grafana-ui.action-editor.button.confirm-action", "Confirm action"),
        body: action.confirmation,
        confirmText: t("grafana-ui.action-editor.button.confirm", "Confirm"),
        confirmButtonVariant: "primary",
        onConfirm: () => {
          setShowConfirm(false);
          action.onClick(new MouseEvent("click"));
        },
        onDismiss: () => {
          setShowConfirm(false);
        }
      }
    )
  ] });
}

"use strict";
const ActionsCell$1 = (props) => {
  const { cellProps, tableStyles, actions } = props;
  const styles = useStyles2(getStyles$$);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: css.cx(tableStyles.cellContainerText, styles.buttonsGap), children: actions && actions.map((action, i) => /* @__PURE__ */ jsxRuntime.jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles$$ = (theme) => ({
  buttonsGap: css.css({
    gap: 6
  })
});

"use strict";
function fontSizeReductionFactor(fontSize) {
  if (fontSize < 20) {
    return 0.9;
  }
  if (fontSize < 26) {
    return 0.8;
  }
  return 0.6;
}
const FormattedValueDisplay = ({ value, className, style, ...htmlProps }) => {
  var _a, _b;
  const hasPrefix = ((_a = value.prefix) != null ? _a : "").length > 0;
  const hasSuffix = ((_b = value.suffix) != null ? _b : "").length > 0;
  let suffixStyle;
  if (style && typeof style.fontSize === "number" && !Number.isNaN(style.fontSize)) {
    const fontSize = style.fontSize;
    const reductionFactor = fontSizeReductionFactor(fontSize);
    suffixStyle = { fontSize: fontSize * reductionFactor };
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className, style, ...htmlProps, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    hasPrefix && /* @__PURE__ */ jsxRuntime.jsx("span", { children: value.prefix }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: value.text }),
    hasSuffix && /* @__PURE__ */ jsxRuntime.jsx("span", { style: suffixStyle, children: value.suffix })
  ] }) });
};
FormattedValueDisplay.displayName = "FormattedDisplayValue";

"use strict";
const MIN_VALUE_HEIGHT = 18;
const MAX_VALUE_HEIGHT = 50;
const MAX_VALUE_WIDTH = 150;
const TITLE_LINE_HEIGHT = 1.5;
const VALUE_LINE_HEIGHT = 1;
const VALUE_LEFT_PADDING = 10;
const VALUE_RIGHT_OVERFLOW_PADDING = 15;
class BarGauge extends React.PureComponent {
  render() {
    const { onClick, className, theme } = this.props;
    const { title } = this.props.value;
    const styles = getTitleStyles(this.props);
    if (onClick) {
      return /* @__PURE__ */ jsxRuntime.jsxs(
        "button",
        {
          type: "button",
          style: styles.wrapper,
          onClick,
          className: css.cx(clearButtonStyles(theme), className),
          children: [
            /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.title, children: title }),
            this.renderBarAndValue()
          ]
        }
      );
    }
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.wrapper, className, children: [
      title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.title, children: title }),
      this.renderBarAndValue()
    ] });
  }
  renderBarAndValue() {
    switch (this.props.displayMode) {
      case "lcd":
        return this.renderRetroBars();
      case "basic":
      case "gradient":
      default:
        return this.renderBasicAndGradientBars();
    }
  }
  renderBasicAndGradientBars() {
    const { value, showUnfilled, valueDisplayMode } = this.props;
    const styles = getBasicAndGradientStyles(this.props);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.wrapper, children: [
      valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ jsxRuntime.jsx(
        FormattedValueDisplay,
        {
          "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
          value,
          style: styles.value
        }
      ),
      showUnfilled && /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.emptyBar }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.bar })
    ] });
  }
  renderRetroBars() {
    var _a, _b;
    const {
      display,
      field,
      value,
      itemSpacing,
      alignmentFactors,
      orientation,
      lcdCellWidth,
      text,
      valueDisplayMode,
      theme,
      isOverflow
    } = this.props;
    const { valueHeight, valueWidth, maxBarHeight, maxBarWidth, wrapperWidth, wrapperHeight } = calculateBarAndValueDimensions(this.props);
    const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
    const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
    const isVert = isVertical(orientation);
    const valueRange = maxValue - minValue;
    const maxSize = isVert ? maxBarHeight : maxBarWidth;
    const cellSpacing = itemSpacing;
    const cellCount = Math.floor(maxSize / lcdCellWidth);
    const cellSize = Math.floor((maxSize - cellSpacing * cellCount) / cellCount);
    const valueColor = getTextValueColor(this.props);
    const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
    const valueStyles = getValueStyles(
      valueToBaseSizeOn,
      valueColor,
      valueWidth,
      valueHeight,
      orientation,
      isOverflow,
      text
    );
    const containerStyles = {
      width: `${wrapperWidth}px`,
      height: `${wrapperHeight}px`,
      display: "flex"
    };
    if (isVert) {
      containerStyles.flexDirection = "column-reverse";
      containerStyles.alignItems = "center";
    } else {
      containerStyles.flexDirection = "row";
      containerStyles.alignItems = "center";
      valueStyles.justifyContent = "flex-end";
    }
    const cells = [];
    for (let i = 0; i < cellCount; i++) {
      const currentValue = minValue + valueRange / cellCount * i;
      const cellColor = getCellColor(currentValue, value, display);
      const cellStyles = {
        borderRadius: theme.shape.radius.default
      };
      if (cellColor.isLit) {
        cellStyles.backgroundImage = `radial-gradient(${cellColor.background} 10%, ${cellColor.backgroundShade})`;
      } else {
        cellStyles.backgroundColor = cellColor.background;
      }
      if (isVert) {
        cellStyles.height = `${cellSize}px`;
        cellStyles.width = `${maxBarWidth}px`;
        cellStyles.marginTop = `${cellSpacing}px`;
      } else {
        cellStyles.width = `${cellSize}px`;
        cellStyles.height = `${maxBarHeight}px`;
        cellStyles.marginRight = `${cellSpacing}px`;
      }
      cells.push(/* @__PURE__ */ jsxRuntime.jsx("div", { style: cellStyles }, i.toString()));
    }
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: containerStyles, children: [
      cells,
      valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ jsxRuntime.jsx(
        FormattedValueDisplay,
        {
          "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
          value,
          style: valueStyles
        }
      )
    ] });
  }
}
BarGauge.defaultProps = {
  lcdCellWidth: 12,
  value: {
    text: "100",
    numeric: 100
  },
  displayMode: schema.BarGaugeDisplayMode.Gradient,
  orientation: data.VizOrientation.Horizontal,
  field: {
    min: 0,
    max: 100,
    thresholds: {
      mode: data.ThresholdsMode.Absolute,
      steps: []
    }
  },
  itemSpacing: 8,
  showUnfilled: true,
  isOverflow: false
};
function isVertical(orientation) {
  return orientation === data.VizOrientation.Vertical;
}
function calculateTitleDimensions(props) {
  var _a, _b;
  const { height, width, alignmentFactors, orientation, text, namePlacement } = props;
  const title = alignmentFactors ? alignmentFactors.title : props.value.title;
  if (!title) {
    return { fontSize: 0, width: 0, height: 0, placement: "above" };
  }
  if (namePlacement === schema.BarGaugeNamePlacement.Hidden) {
    return {
      fontSize: 0,
      width: 0,
      height: 0,
      placement: schema.BarGaugeNamePlacement.Hidden
    };
  }
  if (isVertical(orientation)) {
    const fontSize = (_a = text == null ? void 0 : text.titleSize) != null ? _a : 14;
    return {
      fontSize,
      width,
      height: fontSize * TITLE_LINE_HEIGHT,
      placement: "below"
    };
  }
  const shouldDisplayValueAbove = height > 40 && namePlacement === schema.BarGaugeNamePlacement.Auto || namePlacement === schema.BarGaugeNamePlacement.Top;
  if (shouldDisplayValueAbove) {
    if (text == null ? void 0 : text.titleSize) {
      return {
        fontSize: text == null ? void 0 : text.titleSize,
        width: 0,
        height: text.titleSize * TITLE_LINE_HEIGHT,
        placement: "above"
      };
    }
    const maxTitleHeightRatio2 = 0.45;
    const titleHeight2 = Math.max(Math.min(height * maxTitleHeightRatio2, MAX_VALUE_HEIGHT), 17);
    return {
      fontSize: titleHeight2 / TITLE_LINE_HEIGHT,
      width: 0,
      height: titleHeight2,
      placement: "above"
    };
  }
  const maxTitleHeightRatio = 0.6;
  const titleHeight = Math.max(height * maxTitleHeightRatio, MIN_VALUE_HEIGHT);
  const titleFontSize = titleHeight / TITLE_LINE_HEIGHT;
  const textSize = measureText(title, titleFontSize);
  const textWidth = Math.min(textSize.width + 15, width * 0.4);
  return {
    fontSize: (_b = text == null ? void 0 : text.titleSize) != null ? _b : titleFontSize,
    height: 0,
    width: textWidth,
    placement: "left"
  };
}
function getTitleStyles(props) {
  const wrapperStyles = {
    display: "flex",
    overflow: "hidden",
    width: "100%"
  };
  const titleDim = calculateTitleDimensions(props);
  const titleStyles = {
    fontSize: `${titleDim.fontSize}px`,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    width: "100%",
    alignItems: "center",
    alignSelf: "center"
  };
  if (titleDim.placement === "hidden") {
    titleStyles.display = "none";
  } else {
    if (isVertical(props.orientation)) {
      wrapperStyles.flexDirection = "column-reverse";
      titleStyles.textAlign = "center";
    } else {
      if (titleDim.placement === "above") {
        wrapperStyles.flexDirection = "column";
      } else {
        wrapperStyles.flexDirection = "row";
        titleStyles.width = `${titleDim.width}px`;
        titleStyles.textAlign = "right";
        titleStyles.paddingRight = "10px";
      }
    }
  }
  return {
    wrapper: wrapperStyles,
    title: titleStyles
  };
}
function calculateBarAndValueDimensions(props) {
  var _a;
  const { height, width, orientation, text, alignmentFactors, valueDisplayMode } = props;
  const titleDim = calculateTitleDimensions(props);
  const value = alignmentFactors != null ? alignmentFactors : props.value;
  const valueString = data.formattedValueToString(value);
  let maxBarHeight = 0;
  let maxBarWidth = 0;
  let valueHeight = 0;
  let valueWidth = 0;
  let wrapperWidth = 0;
  let wrapperHeight = 0;
  const fontSizeToMeasureWith = (_a = text == null ? void 0 : text.valueSize) != null ? _a : Math.max(titleDim.fontSize, 12);
  const realTextSize = measureText(valueString, fontSizeToMeasureWith);
  const realValueWidth = realTextSize.width + VALUE_LEFT_PADDING * 2;
  if (isVertical(orientation)) {
    if (text == null ? void 0 : text.valueSize) {
      valueHeight = text.valueSize * VALUE_LINE_HEIGHT;
    } else {
      valueHeight = Math.min(Math.max(height * 0.1, MIN_VALUE_HEIGHT), MAX_VALUE_HEIGHT);
    }
    valueWidth = width;
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    }
    maxBarHeight = height - (titleDim.height + valueHeight);
    maxBarWidth = width;
    wrapperWidth = width;
    wrapperHeight = height - titleDim.height;
  } else {
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    } else {
      valueHeight = height - titleDim.height;
      valueWidth = Math.max(Math.min(width * 0.2, MAX_VALUE_WIDTH), realValueWidth);
    }
    maxBarHeight = height - titleDim.height;
    maxBarWidth = width - valueWidth - titleDim.width;
    if (titleDim.placement === "above") {
      wrapperWidth = width;
      wrapperHeight = height - titleDim.height;
    } else {
      wrapperWidth = width - titleDim.width;
      wrapperHeight = height;
    }
  }
  return {
    valueWidth,
    valueHeight,
    maxBarWidth,
    maxBarHeight,
    wrapperHeight,
    wrapperWidth
  };
}
function getCellColor(positionValue, value, display) {
  if (positionValue === null) {
    return {
      background: data.FALLBACK_COLOR,
      border: data.FALLBACK_COLOR
    };
  }
  const color = display ? display(positionValue).color : null;
  if (color) {
    if (value === null || isNaN(value.numeric) || positionValue !== null && positionValue > value.numeric) {
      return {
        background: tinycolor__default.default(color).setAlpha(0.18).toRgbString(),
        border: "transparent",
        isLit: false
      };
    } else {
      return {
        background: tinycolor__default.default(color).setAlpha(0.95).toRgbString(),
        backgroundShade: tinycolor__default.default(color).setAlpha(0.55).toRgbString(),
        border: tinycolor__default.default(color).setAlpha(0.9).toRgbString(),
        isLit: true
      };
    }
  }
  return {
    background: data.FALLBACK_COLOR,
    border: data.FALLBACK_COLOR
  };
}
function getValuePercent(value, minValue, maxValue) {
  const valueRatio = Math.min((value - minValue) / (maxValue - minValue), 1);
  return isNaN(valueRatio) ? 0 : valueRatio;
}
function getBasicAndGradientStyles(props) {
  var _a, _b, _c;
  const { displayMode, field, value, alignmentFactors, orientation, theme, text, isOverflow } = props;
  const { valueWidth, valueHeight, maxBarHeight, maxBarWidth } = calculateBarAndValueDimensions(props);
  const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
  const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
  const valuePercent = getValuePercent(value.numeric, minValue, maxValue);
  const textColor = getTextValueColor(props);
  const barColor = (_c = value.color) != null ? _c : data.FALLBACK_COLOR;
  const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
  const valueStyles = getValueStyles(
    valueToBaseSizeOn,
    textColor,
    valueWidth,
    valueHeight,
    orientation,
    isOverflow,
    text
  );
  const isBasic = displayMode === "basic";
  const wrapperStyles = {
    display: "flex",
    flexGrow: 1
  };
  const barStyles = {
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  const emptyBar = {
    background: theme.colors.background.secondary,
    flexGrow: 1,
    display: "flex",
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  if (isVertical(orientation)) {
    const barHeight = Math.max(valuePercent * maxBarHeight, 1);
    wrapperStyles.flexDirection = "column";
    wrapperStyles.justifyContent = "flex-end";
    barStyles.transition = "height 1s";
    barStyles.height = `${barHeight}px`;
    barStyles.width = `${maxBarWidth}px`;
    emptyBar.bottom = "-3px";
    emptyBar.width = `${valueWidth}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default.default(barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderTop = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarHeight);
    }
  } else {
    const barWidth = Math.max(valuePercent * maxBarWidth, 1);
    wrapperStyles.flexDirection = "row-reverse";
    wrapperStyles.justifyContent = "flex-end";
    wrapperStyles.alignItems = "stretch";
    barStyles.transition = "width 1s";
    barStyles.height = `${maxBarHeight}px`;
    barStyles.width = `${barWidth}px`;
    emptyBar.left = "-3px";
    emptyBar.height = `${valueHeight}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default.default(barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderRight = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarWidth);
    }
  }
  return {
    wrapper: wrapperStyles,
    bar: barStyles,
    value: valueStyles,
    emptyBar
  };
}
function getBarGradient(props, maxSize) {
  var _a, _b;
  const { field, value, orientation, theme } = props;
  const cssDirection = isVertical(orientation) ? "0deg" : "90deg";
  const minValue = field.min;
  const maxValue = field.max;
  let gradient = "";
  let lastpos = 0;
  let mode = data.getFieldColorMode((_a = field.color) == null ? void 0 : _a.mode);
  if (mode.id === data.FieldColorModeId.Thresholds) {
    const thresholds = field.thresholds;
    for (let i = 0; i < thresholds.steps.length; i++) {
      const threshold = thresholds.steps[i];
      const color = props.theme.visualization.getColorByName(threshold.color);
      const valuePercent = thresholds.mode === data.ThresholdsMode.Percentage ? threshold.value / 100 : getValuePercent(threshold.value, minValue, maxValue);
      const pos = valuePercent * maxSize;
      const offset = Math.round(pos - (pos - lastpos) / 2);
      const thresholdValue = thresholds.mode === data.ThresholdsMode.Percentage ? minValue + (maxValue - minValue) * valuePercent : threshold.value;
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color}, ${color}`;
      } else if (value.numeric < thresholdValue) {
        break;
      } else {
        lastpos = pos;
        gradient += ` ${offset}px, ${color}`;
      }
    }
    return gradient + ")";
  }
  if (mode.isContinuous && mode.getColors) {
    const scheme = mode.getColors(theme);
    for (let i = 0; i < scheme.length; i++) {
      const color = scheme[i];
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color} 0px`;
      } else {
        const valuePercent = i / (scheme.length - 1);
        const pos = valuePercent * maxSize;
        gradient += `, ${color} ${pos}px`;
      }
    }
    return gradient + ")";
  }
  return (_b = value.color) != null ? _b : data.FALLBACK_COLOR;
}
function getTextValueColor(props) {
  if (props.valueDisplayMode === "text") {
    return props.theme.colors.text.primary;
  }
  const { value } = props;
  if (value.color) {
    return value.color;
  }
  return data.FALLBACK_COLOR;
}
function getValueStyles(value, color, width, height, orientation, isOverflow, text) {
  var _a, _b;
  const styles = {
    color,
    height: `${height}px`,
    width: `${width}px`,
    display: "flex",
    alignItems: "center",
    textWrap: "nowrap",
    lineHeight: VALUE_LINE_HEIGHT
  };
  let textWidth = width;
  const formattedValueString = data.formattedValueToString(value);
  if (isVertical(orientation)) {
    styles.fontSize = (_a = text == null ? void 0 : text.valueSize) != null ? _a : calculateFontSize(formattedValueString, textWidth, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `center`;
  } else {
    styles.fontSize = (_b = text == null ? void 0 : text.valueSize) != null ? _b : calculateFontSize(formattedValueString, textWidth - VALUE_LEFT_PADDING * 2, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `flex-end`;
    styles.paddingLeft = `${VALUE_LEFT_PADDING}px`;
    styles.paddingRight = `${VALUE_LEFT_PADDING + (isOverflow ? VALUE_RIGHT_OVERFLOW_PADDING : 0)}px`;
    textWidth -= VALUE_LEFT_PADDING;
  }
  return styles;
}

"use strict";
const WithContextMenu = ({ children, renderMenuItems, focusOnOpen = true }) => {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false);
  const [menuPosition, setMenuPosition] = React.useState({ x: 0, y: 0 });
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    children({
      openMenu: (e) => {
        setIsMenuOpen(true);
        setMenuPosition({
          x: e.pageX,
          y: e.pageY - window.scrollY
        });
      }
    }),
    isMenuOpen && /* @__PURE__ */ jsxRuntime.jsx(
      ContextMenu,
      {
        onClose: () => setIsMenuOpen(false),
        x: menuPosition.x,
        y: menuPosition.y,
        renderMenuItems,
        focusOnOpen
      }
    )
  ] });
};

"use strict";
const DataLinksContextMenu = ({ children, links, style }) => {
  const styles = useStyles2(getStyles$_);
  const itemsGroup = [
    { items: linkModelToContextMenuItems(links), label: Boolean(links().length) ? "Data links" : "" }
  ];
  const linksCounter = itemsGroup[0].items.length;
  const renderMenuGroupItems = () => {
    return itemsGroup.map((group, groupIdx) => /* @__PURE__ */ jsxRuntime.jsx(MenuGroup, { label: group.label, children: (group.items || []).map((item, itemIdx) => /* @__PURE__ */ jsxRuntime.jsx(
      MenuItem,
      {
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick,
        className: styles.itemWrapper
      },
      `${group.label}-${groupIdx}-${itemIdx}}`
    )) }, `${group.label}${groupIdx}`));
  };
  const targetClassName = css.css({
    cursor: "context-menu"
  });
  if (linksCounter > 1) {
    return /* @__PURE__ */ jsxRuntime.jsx(WithContextMenu, { renderMenuItems: renderMenuGroupItems, children: ({ openMenu }) => {
      return children({ openMenu, targetClassName });
    } });
  } else {
    const linkModel = links()[0];
    return /* @__PURE__ */ jsxRuntime.jsx(
      "a",
      {
        href: linkModel.href,
        onClick: linkModel.onClick,
        target: linkModel.target,
        title: linkModel.title,
        style: { ...style, overflow: "hidden", display: "flex" },
        "data-testid": e2eSelectors.selectors.components.DataLinksContextMenu.singleLink,
        children: children({})
      }
    );
  }
};
const getStyles$_ = (theme) => ({
  itemWrapper: css.css({
    fontSize: 12
  })
});

"use strict";
const defaultScale$1 = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell$1 = (props) => {
  var _a;
  const { field, innerWidth, tableStyles, cell, cellProps, row } = props;
  const displayValue = field.display(cell.value);
  const cellOptions = getCellOptions$1(field);
  let config = data.getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale$1
    };
  }
  let barGaugeMode = schema.BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : schema.BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : schema.BarGaugeValueMode.Text;
  }
  const getLinks = () => {
    if (!lodash.isFunction(field.getLinks)) {
      return [];
    }
    return field.getLinks({ valueRowIndex: row.index });
  };
  const hasLinks = Boolean(getLinks().length);
  const alignmentFactors = getAlignmentFactor$1(field, displayValue, cell.row.index);
  const renderComponent = (menuProps) => {
    const { openMenu, targetClassName } = menuProps;
    return /* @__PURE__ */ jsxRuntime.jsx(
      BarGauge,
      {
        width: innerWidth,
        height: tableStyles.cellHeightInner,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: data.VizOrientation.Horizontal,
        theme: tableStyles.theme,
        alignmentFactors,
        onClick: openMenu,
        className: targetClassName,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: getLinks, style: { display: "flex", width: "100%" }, children: (api) => renderComponent(api) }) : renderComponent({}) });
};

"use strict";
const DataLinksCell$1 = (props) => {
  const { field, row, cellProps, tableStyles } = props;
  const links = getCellLinks$1(field, row);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainerText, children: links && links.map((link, idx) => {
    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: tableStyles.cellLink, onClick: link.onClick, children: /* @__PURE__ */ jsxRuntime.jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};

"use strict";
const FILTER_FOR_OPERATOR$1 = "=";
const FILTER_OUT_OPERATOR$1 = "!=";

"use strict";
function CellActions({
  field,
  cell,
  previewMode,
  showFilters,
  onCellFilterAdded,
  setInspectCell
}) {
  var _a;
  const isRightAligned = getTextAlign$1(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR$1, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR$1, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: `cellActions${isRightAligned ? " cellActionsLeft" : ""}`, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 0.5, children: [
    inspectEnabled && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "eye",
        tooltip: t("grafana-ui.table.cell-inspect", "Inspect value"),
        onClick: () => {
          if (setInspectCell) {
            setInspectCell({ value: cell.value, mode: previewMode });
          }
        },
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "search-plus",
        onClick: onFilterFor,
        tooltip: t("grafana-ui.table.cell-filter-on", "Filter for value"),
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "search-minus",
        onClick: onFilterOut,
        tooltip: t("grafana-ui.table.cell-filter-out", "Filter out value"),
        ...commonButtonProps
      }
    )
  ] }) });
}

"use strict";
const DefaultCell = (props) => {
  var _a, _b, _c;
  const { field, cell, tableStyles, row, cellProps, frame, rowStyled, rowExpanded, textWrapped, height } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const displayValue = field.display(cell.value);
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== void 0 || inspectEnabled;
  const cellOptions = getCellOptions$1(field);
  const hasLinks = Boolean((_b = getCellLinks$1(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  let value;
  const OG_TWEET_LENGTH = 140;
  if (cellOptions.type === schema.TableCellDisplayMode.Custom) {
    const CustomCellComponent = cellOptions.cellComponent;
    value = /* @__PURE__ */ jsxRuntime.jsx(CustomCellComponent, { field, value: cell.value, rowIndex: row.index, frame });
  } else {
    if (React__namespace.isValidElement(cell.value)) {
      value = cell.value;
    } else {
      value = data.formattedValueToString(displayValue);
    }
  }
  const isStringValue = typeof value === "string";
  const textShouldWrap = displayValue.text.length <= OG_TWEET_LENGTH && /\s/.test(displayValue.text);
  const cellStyle = getCellStyle(
    tableStyles,
    cellOptions,
    displayValue,
    inspectEnabled,
    isStringValue,
    textShouldWrap,
    textWrapped,
    rowStyled,
    rowExpanded
  );
  if (isStringValue) {
    let justifyContent = (_c = cellProps.style) == null ? void 0 : _c.justifyContent;
    if (justifyContent === "flex-end") {
      cellProps.style = { ...cellProps.style, textAlign: "right" };
    } else if (justifyContent === "center") {
      cellProps.style = { ...cellProps.style, textAlign: "center" };
    }
  }
  if (height) {
    cellProps.style = { ...cellProps.style, height };
  }
  if (textWrapped) {
    cellProps.style = { ...cellProps.style, textWrap: "wrap" };
  }
  const { key, ...rest } = cellProps;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...rest, className: cellStyle, children: [
    hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks$1(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsxRuntime.jsx(
          "button",
          {
            className: css.cx(clearButtonStyle, getLinkStyle$1(tableStyles, cellOptions, api.targetClassName)),
            onClick: api.openMenu,
            children: value
          }
        );
      } else {
        return /* @__PURE__ */ jsxRuntime.jsx("div", { className: getLinkStyle$1(tableStyles, cellOptions, api.targetClassName), children: value });
      }
    } }) : isStringValue ? `${value}` : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, children: value }),
    showActions && /* @__PURE__ */ jsxRuntime.jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.text, showFilters })
  ] }, key);
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false, isStringValue = false, shouldWrapText = false, textWrapped = false, rowStyled = false, rowExpanded = false) {
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = void 0;
  const colors = getCellColors$1(tableStyles.theme, cellOptions, displayValue);
  textColor = colors.textColor;
  bgColor = colors.bgColor;
  bgHoverColor = colors.bgHoverColor;
  return tableStyles.buildCellContainerStyle(
    textColor,
    bgColor,
    bgHoverColor,
    !disableOverflowOnHover,
    isStringValue,
    shouldWrapText,
    textWrapped,
    rowStyled,
    rowExpanded
  );
}
function getLinkStyle$1(tableStyles, cellOptions, targetClassName) {
  if (cellOptions.type === schema.TableCellDisplayMode.Auto) {
    return css.cx(tableStyles.cellLink, targetClassName);
  }
  return css.cx(tableStyles.cellLinkForColoredCell, targetClassName);
}

"use strict";
function GeoCell$1(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof geom.Geometry) {
    disp = new WKT__default.default().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" }, children: disp }) });
}

"use strict";
const DATALINKS_HEIGHT_OFFSET$1 = 10;
const ImageCell$1 = (props) => {
  var _a;
  const { field, cell, tableStyles, row, cellProps } = props;
  const cellOptions = getCellOptions$1(field);
  const { title, alt } = cellOptions.type === schema.TableCellDisplayMode.Image ? cellOptions : { title: void 0, alt: void 0 };
  const displayValue = field.display(cell.value);
  const hasLinks = Boolean((_a = getCellLinks$1(field, row)) == null ? void 0 : _a.length);
  const img = /* @__PURE__ */ jsxRuntime.jsx(
    "img",
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET$1, width: "auto" },
      src: displayValue.text,
      className: tableStyles.imageCell,
      alt,
      title
    }
  );
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(
    DataLinksContextMenu,
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET$1, width: "auto" },
      links: () => getCellLinks$1(field, row) || [],
      children: (api) => {
        if (api.openMenu) {
          return /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              onClick: api.openMenu,
              role: "button",
              tabIndex: 0,
              onKeyDown: (e) => {
                if (e.key === "Enter" && api.openMenu) {
                  api.openMenu(e);
                }
              },
              children: img
            }
          );
        } else {
          return img;
        }
      }
    }
  ) : img });
};

"use strict";
function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css.css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (lodash.isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks$1(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...cellProps, className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tableStyles.cellText, txt), children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks$1(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsxRuntime.jsx(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
      } else {
        return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: displayValue });
      }
    } }) : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, children: displayValue }) }),
    inspectEnabled && /* @__PURE__ */ jsxRuntime.jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.code })
  ] });
}

"use strict";
const FIXED_UNIT = "__fixed";
class PlotConfigBuilder {
  constructor(props) {
    this.props = props;
  }
}

"use strict";
function buildScaleKey$1(config, fieldType) {
  var _a, _b, _c, _d, _e, _f, _g;
  const defaultPart = "na";
  const scaleRange = `${config.min !== void 0 ? config.min : defaultPart}-${config.max !== void 0 ? config.max : defaultPart}`;
  const scaleSoftRange = `${((_a = config.custom) == null ? void 0 : _a.axisSoftMin) !== void 0 ? config.custom.axisSoftMin : defaultPart}-${((_b = config.custom) == null ? void 0 : _b.axisSoftMax) !== void 0 ? config.custom.axisSoftMax : defaultPart}`;
  const scalePlacement = `${((_c = config.custom) == null ? void 0 : _c.axisPlacement) !== void 0 ? (_d = config.custom) == null ? void 0 : _d.axisPlacement : schema.AxisPlacement.Auto}`;
  const scaleUnit = (_e = config.unit) != null ? _e : FIXED_UNIT;
  const scaleDistribution = ((_f = config.custom) == null ? void 0 : _f.scaleDistribution) ? getScaleDistributionPart$1(config.custom.scaleDistribution) : schema.ScaleDistribution.Linear;
  const scaleLabel = Boolean((_g = config.custom) == null ? void 0 : _g.axisLabel) ? config.custom.axisLabel : defaultPart;
  return `${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${scaleLabel}/${fieldType}`;
}
function getScaleDistributionPart$1(config) {
  if (config.type === schema.ScaleDistribution.Log) {
    return `${config.type}${config.log}`;
  }
  return config.type;
}

"use strict";
const paddingSide = (u, side, sidesWithAxes) => {
  let hasCrossAxis = side % 2 ? sidesWithAxes[0] || sidesWithAxes[2] : sidesWithAxes[1] || sidesWithAxes[3];
  return sidesWithAxes[side] || !hasCrossAxis ? 0 : 8;
};
const DEFAULT_PLOT_CONFIG = {
  ms: 1,
  focus: {
    alpha: 1
  },
  cursor: {
    focus: {
      prox: 30
    }
  },
  legend: {
    show: false
  },
  padding: [paddingSide, paddingSide, paddingSide, paddingSide],
  series: [],
  hooks: {}
};
var StackDirection = /* @__PURE__ */ ((StackDirection2) => {
  StackDirection2[StackDirection2["Pos"] = 1] = "Pos";
  StackDirection2[StackDirection2["Neg"] = -1] = "Neg";
  return StackDirection2;
})(StackDirection || {});
function getStackingBands(group) {
  let bands = [];
  let { series, dir } = group;
  let lastIdx = series.length - 1;
  let rSeries = series.slice().reverse();
  rSeries.forEach((si, i) => {
    if (i !== lastIdx) {
      let nextIdx = rSeries[i + 1];
      bands.push({
        series: [si, nextIdx],
        // fill direction is inverted from stack direction
        dir: -1 * dir
      });
    }
  });
  return bands;
}
function getStackingGroups(frame) {
  let groups = /* @__PURE__ */ new Map();
  frame.fields.forEach(({ config, values, type }, i) => {
    var _a;
    if (i === 0) {
      return;
    }
    let { custom } = config;
    if (custom == null) {
      return;
    }
    if ((_a = custom.hideFrom) == null ? void 0 : _a.viz) {
      return;
    }
    let { stacking } = custom;
    if (stacking == null) {
      return;
    }
    let { mode: stackingMode, group: stackingGroup } = stacking;
    if (stackingMode === schema.StackingMode.None) {
      return;
    }
    let transform = custom.transform;
    let stackDir = getStackDirection(transform, values);
    let drawStyle = custom.drawStyle;
    let drawStyle2 = drawStyle === schema.GraphDrawStyle.Bars ? custom.barAlignment : drawStyle === schema.GraphDrawStyle.Line ? custom.lineInterpolation : null;
    let stackKey = `${stackDir}|${stackingMode}|${stackingGroup}|${buildScaleKey$1(
      config,
      type
    )}|${drawStyle}|${drawStyle2}`;
    let group = groups.get(stackKey);
    if (group == null) {
      group = {
        series: [],
        dir: stackDir
      };
      groups.set(stackKey, group);
    }
    group.series.push(i);
  });
  return [...groups.values()];
}
function preparePlotData2(frame, stackingGroups, onStackMeta) {
  let data$1 = Array(frame.fields.length);
  let stacksQty = stackingGroups.length;
  let dataLen = frame.length;
  let zeroArr = stacksQty > 0 ? Array(dataLen).fill(0) : [];
  let falseArr = stacksQty > 0 ? Array(dataLen).fill(false) : [];
  let accums = Array.from({ length: stacksQty }, () => zeroArr.slice());
  let anyValsAtX = Array.from({ length: stacksQty }, () => falseArr.slice());
  stackingGroups.forEach((group, groupIdx) => {
    let groupValsAtX = anyValsAtX[groupIdx];
    group.series.forEach((seriesIdx) => {
      var _a, _b;
      let field = frame.fields[seriesIdx];
      if ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz) {
        return;
      }
      let vals = field.values;
      for (let i = 0; i < dataLen; i++) {
        if (vals[i] != null) {
          groupValsAtX[i] = true;
        }
      }
    });
  });
  frame.fields.forEach((field, i) => {
    var _a, _b;
    let vals = field.values;
    if (i === 0) {
      if (field.type === data.FieldType.time) {
        data$1[0] = data.ensureTimeField(field).values;
      } else {
        data$1[0] = vals;
      }
      return;
    }
    let { custom } = field.config;
    if (!custom || ((_a = custom.hideFrom) == null ? void 0 : _a.viz)) {
      data$1[i] = vals;
      return;
    }
    if (custom.transform === schema.GraphTransform.Constant) {
      let firstValIdx = vals.findIndex((v) => v != null);
      let firstVal = vals[firstValIdx];
      vals = Array(vals.length).fill(void 0);
      vals[firstValIdx] = firstVal;
    } else {
      vals = vals.slice();
      if (custom.transform === schema.GraphTransform.NegativeY) {
        for (let i2 = 0; i2 < vals.length; i2++) {
          if (vals[i2] != null) {
            vals[i2] *= -1;
          }
        }
      }
    }
    let stackingMode = (_b = custom.stacking) == null ? void 0 : _b.mode;
    if (!stackingMode || stackingMode === schema.StackingMode.None) {
      data$1[i] = vals;
    } else {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let groupValsAtX = anyValsAtX[stackIdx];
      let stacked = data$1[i] = Array(dataLen);
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = vals[i2];
        if (v != null) {
          stacked[i2] = accum[i2] += v;
        } else {
          stacked[i2] = groupValsAtX[i2] ? accum[i2] : v;
        }
      }
    }
  });
  if (onStackMeta) {
    let accumsBySeriesIdx = data$1.map((vals, i) => {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      return stackIdx !== -1 ? accums[stackIdx] : vals;
    });
    onStackMeta({
      totals: accumsBySeriesIdx
    });
  }
  frame.fields.forEach((field, i) => {
    var _a, _b, _c, _d;
    if (i === 0 || ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz)) {
      return;
    }
    let stackingMode = (_d = (_c = field.config.custom) == null ? void 0 : _c.stacking) == null ? void 0 : _d.mode;
    if (stackingMode === schema.StackingMode.Percent) {
      let stackIdx = stackingGroups.findIndex((group2) => group2.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let group = stackingGroups[stackIdx];
      let stacked = data$1[i];
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = stacked[i2];
        if (v != null) {
          stacked[i2] = accum[i2] === 0 ? 0 : group.dir * (v / accum[i2]);
        }
      }
    }
  });
  return data$1;
}
function findMidPointYPosition(u, idx) {
  let y;
  let sMaxIdx = 1;
  let sMinIdx = 1;
  let max = u.data[1][idx];
  let min = u.data[1][idx];
  for (let i = 1; i < u.data.length; i++) {
    const sData = u.data[i];
    const sVal = sData[idx];
    if (sVal != null) {
      if (max == null) {
        max = sVal;
      } else {
        if (sVal > max) {
          max = u.data[i][idx];
          sMaxIdx = i;
        }
      }
      if (min == null) {
        min = sVal;
      } else {
        if (sVal < min) {
          min = u.data[i][idx];
          sMinIdx = i;
        }
      }
    }
  }
  if (min == null && max == null) {
    y = void 0;
  } else if (min != null && max != null) {
    y = (u.valToPos(min, u.series[sMinIdx].scale) + u.valToPos(max, u.series[sMaxIdx].scale)) / 2;
  } else {
    y = u.valToPos(min || max, u.series[sMaxIdx || sMinIdx].scale);
  }
  if (y !== void 0 && y < 0) {
    y = u.bbox.height / devicePixelRatio;
  }
  return y;
}
function getStackDirection(transform, data) {
  const hasNegSamp = hasNegSample(data);
  if (transform === schema.GraphTransform.NegativeY) {
    return hasNegSamp ? 1 /* Pos */ : -1 /* Neg */;
  }
  return hasNegSamp ? -1 /* Neg */ : 1 /* Pos */;
}
function hasNegSample(data, samples = 100) {
  const len = data.length;
  if (len === 0) {
    return false;
  }
  let firstIdx = 0;
  let lastIdx = len - 1;
  while (firstIdx <= lastIdx && data[firstIdx] == null) {
    firstIdx++;
  }
  while (lastIdx >= firstIdx && data[lastIdx] == null) {
    lastIdx--;
  }
  let negCount = 0;
  let posCount = 0;
  if (lastIdx >= firstIdx) {
    const stride = Math.max(1, Math.floor((lastIdx - firstIdx + 1) / samples));
    for (let i = firstIdx; i <= lastIdx; i += stride) {
      const v = data[i];
      if (v != null && typeof v === "number") {
        if (v < 0 || Object.is(v, -0)) {
          negCount++;
        } else if (v > 0) {
          posCount++;
        }
      }
    }
    if (negCount > posCount) {
      return true;
    }
  }
  return false;
}
const getDisplayValuesForCalcs = (calcs, field, theme) => {
  var _a;
  if (!(calcs == null ? void 0 : calcs.length)) {
    return [];
  }
  const defaultFormatter = (v) => v == null ? "-" : v.toFixed(1);
  const fmt = (_a = field.display) != null ? _a : defaultFormatter;
  let countFormatter = null;
  const fieldCalcs = data.reduceField({
    field,
    reducers: calcs
  });
  return calcs.map((reducerId) => {
    const fieldReducer = data.fieldReducers.get(reducerId);
    let formatter = fmt;
    if (fieldReducer.id === data.ReducerID.diffperc) {
      formatter = data.getDisplayProcessor({
        field: {
          ...field,
          config: {
            ...field.config,
            unit: "percent"
          }
        },
        theme
      });
    }
    if (fieldReducer.id === data.ReducerID.count || fieldReducer.id === data.ReducerID.changeCount || fieldReducer.id === data.ReducerID.distinctCount) {
      if (!countFormatter) {
        countFormatter = data.getDisplayProcessor({
          field: {
            ...field,
            config: {
              ...field.config,
              unit: "none"
            }
          },
          theme
        });
      }
      formatter = countFormatter;
    }
    return {
      ...formatter(fieldCalcs[reducerId]),
      title: fieldReducer.name,
      description: fieldReducer.description
    };
  });
};
const pluginLogger = createLogger("uPlot");
const pluginLog = pluginLogger.logger;
attachDebugger("graphng", void 0, pluginLogger);

"use strict";
function sameDims(prevProps, nextProps) {
  return nextProps.width === prevProps.width && nextProps.height === prevProps.height;
}
function sameData(prevProps, nextProps) {
  return nextProps.data === prevProps.data;
}
function sameConfig(prevProps, nextProps) {
  return nextProps.config === prevProps.config;
}
class UPlotChart extends React.Component {
  constructor(props) {
    super(props);
    this.plotContainer = React.createRef();
    this.plotCanvasBBox = React.createRef();
    this.plotInstance = null;
  }
  reinitPlot() {
    var _a;
    let { width, height, plotRef } = this.props;
    (_a = this.plotInstance) == null ? void 0 : _a.destroy();
    if (width === 0 && height === 0) {
      return;
    }
    this.props.config.addHook("setSize", (u) => {
      const canvas = u.over;
      if (!canvas) {
        return;
      }
    });
    const config = {
      width: Math.floor(this.props.width),
      height: Math.floor(this.props.height),
      ...this.props.config.getConfig()
    };
    pluginLog("UPlot", false, "Reinitializing plot", config);
    const plot = new uPlot__default.default(config, this.props.data, this.plotContainer.current);
    if (plotRef) {
      plotRef(plot);
    }
    this.plotInstance = plot;
  }
  componentDidMount() {
    this.reinitPlot();
  }
  componentWillUnmount() {
    var _a;
    (_a = this.plotInstance) == null ? void 0 : _a.destroy();
  }
  componentDidUpdate(prevProps) {
    var _a, _b;
    if (!sameDims(prevProps, this.props)) {
      (_a = this.plotInstance) == null ? void 0 : _a.setSize({
        width: Math.floor(this.props.width),
        height: Math.floor(this.props.height)
      });
    } else if (!sameConfig(prevProps, this.props)) {
      this.reinitPlot();
    } else if (!sameData(prevProps, this.props)) {
      (_b = this.plotInstance) == null ? void 0 : _b.setData(this.props.data);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { position: "relative" }, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: this.plotContainer, "data-testid": "uplot-main-div" }),
      this.props.children
    ] });
  }
}

"use strict";
class UPlotScaleBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.min = optMinMax("min", this.props.min, props.min);
    this.props.max = optMinMax("max", this.props.max, props.max);
  }
  getConfig() {
    var _a, _b;
    let {
      isTime,
      scaleKey,
      min: hardMin,
      max: hardMax,
      softMin,
      softMax,
      range,
      direction,
      orientation,
      centeredZero,
      decimals,
      stackingMode
    } = this.props;
    if (stackingMode === schema.StackingMode.Percent) {
      if (hardMin == null && softMin == null) {
        softMin = 0;
      }
      if (hardMax == null && softMax == null) {
        softMax = 1;
      }
    }
    const distr = this.props.distribution;
    const distribution = !isTime ? {
      distr: distr === schema.ScaleDistribution.Symlog ? 4 : distr === schema.ScaleDistribution.Log ? 3 : distr === schema.ScaleDistribution.Ordinal ? 2 : 1,
      log: distr === schema.ScaleDistribution.Log || distr === schema.ScaleDistribution.Symlog ? (_a = this.props.log) != null ? _a : 2 : void 0,
      asinh: distr === schema.ScaleDistribution.Symlog ? (_b = this.props.linearThreshold) != null ? _b : 1 : void 0
    } : {};
    if (distr === schema.ScaleDistribution.Log) {
      let logBase = this.props.log;
      let logFn = logBase === 2 ? Math.log2 : Math.log10;
      if (hardMin != null) {
        if (hardMin <= 0) {
          hardMin = null;
        } else {
          hardMin = logBase ** Math.floor(logFn(hardMin));
        }
      }
      if (hardMax != null) {
        if (hardMax <= 0) {
          hardMax = null;
        } else {
          hardMax = logBase ** Math.ceil(logFn(hardMax));
        }
      }
      if (softMin != null) {
        if (softMin <= 0) {
          softMin = null;
        } else {
          softMin = logBase ** Math.floor(logFn(softMin));
        }
      }
      if (softMax != null) {
        if (softMax <= 0) {
          softMax = null;
        } else {
          softMax = logBase ** Math.ceil(logFn(softMax));
        }
      }
    }
    let softMinMode = softMin == null ? 3 : 1;
    let softMaxMode = softMax == null ? 3 : 1;
    const rangeConfig = {
      min: {
        pad: 0.1,
        hard: hardMin != null ? hardMin : -Infinity,
        soft: softMin || 0,
        mode: softMinMode
      },
      max: {
        pad: 0.1,
        hard: hardMax != null ? hardMax : Infinity,
        soft: softMax || 0,
        mode: softMaxMode
      }
    };
    let hardMinOnly = softMin == null && hardMin != null;
    let hardMaxOnly = softMax == null && hardMax != null;
    let hasFixedRange = hardMinOnly && hardMaxOnly;
    const rangeFn = (u, dataMin, dataMax, scaleKey2) => {
      var _a2;
      const scale = u.scales[scaleKey2];
      let minMax = [dataMin, dataMax];
      if (!hasFixedRange && dataMin == null && dataMax == null) {
        return minMax;
      }
      let logBase = (_a2 = scale.log) != null ? _a2 : 10;
      if (scale.distr === 1 || scale.distr === 2 || scale.distr === 4) {
        if (centeredZero) {
          let absMin = Math.abs(dataMin);
          let absMax = Math.abs(dataMax);
          let max = Math.max(absMin, absMax);
          if (max === 0) {
            max = 80;
          }
          dataMin = -max;
          dataMax = max;
        }
        if (scale.distr === 4) {
          minMax = uPlot__default.default.rangeAsinh(dataMin, dataMax, logBase, true);
        } else {
          minMax = uPlot__default.default.rangeNum(hardMinOnly ? hardMin : dataMin, hardMaxOnly ? hardMax : dataMax, rangeConfig);
        }
      } else if (scale.distr === 3) {
        minMax = uPlot__default.default.rangeLog(hardMin != null ? hardMin : dataMin, hardMax != null ? hardMax : dataMax, logBase, true);
      }
      if (decimals === 0) {
        if (scale.distr === 1 || scale.distr === 2) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        } else if (scale.distr === 3) {
          let logFn = scale.log === 2 ? Math.log2 : Math.log10;
          if (minMax[0] <= 1) {
            minMax[0] = 1;
          } else {
            let minExp = Math.floor(logFn(minMax[0]));
            minMax[0] = logBase ** minExp;
          }
          let maxExp = Math.ceil(logFn(minMax[1]));
          minMax[1] = logBase ** maxExp;
          if (minMax[0] === minMax[1]) {
            minMax[1] *= logBase;
          }
        } else if (scale.distr === 4) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        }
      }
      if (scale.distr === 1 || scale.distr === 4) {
        if (hardMinOnly) {
          minMax[0] = hardMin;
        }
        if (hardMaxOnly) {
          minMax[1] = hardMax;
        }
      }
      if (minMax[0] >= minMax[1]) {
        minMax[0] = scale.distr === 3 ? 1 : 0;
        minMax[1] = 100;
      }
      return minMax;
    };
    let auto = !isTime && !hasFixedRange;
    if (data.isBooleanUnit(scaleKey)) {
      auto = false;
      range = [0, 1];
    }
    return {
      [scaleKey]: {
        time: isTime,
        auto,
        range: range != null ? range : rangeFn,
        dir: direction,
        ori: orientation,
        ...distribution
      }
    };
  }
}
function optMinMax(minmax, a, b) {
  const hasA = !(a === void 0 || a === null);
  const hasB = !(b === void 0 || b === null);
  if (hasA) {
    if (!hasB) {
      return a;
    }
    if (minmax === "min") {
      return a < b ? a : b;
    }
    return a > b ? a : b;
  }
  return b;
}

"use strict";
const UPLOT_AXIS_FONT_SIZE = 12;
const Y_TICK_SPACING_PANEL_HEIGHT = 150;
const Y_TICK_SPACING_NORMAL = 30;
const Y_TICK_SPACING_SMALL = 15;
const X_TICK_SPACING_NORMAL = 40;
const X_TICK_VALUE_GAP = 18;
const labelPad = 8;
class UPlotAxisBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.size = optMinMax("max", this.props.size, props.size);
    if (!this.props.label) {
      this.props.label = props.label;
    }
    if (this.props.placement === schema.AxisPlacement.Auto) {
      this.props.placement = props.placement;
    }
  }
  getConfig() {
    let {
      scaleKey,
      label,
      show = true,
      placement = schema.AxisPlacement.Auto,
      grid = { show: true },
      ticks,
      space,
      filter,
      gap = 5,
      formatValue,
      splits,
      values,
      incrs,
      isTime,
      timeZone,
      theme,
      tickLabelRotation,
      size,
      color,
      border,
      decimals,
      distr = schema.ScaleDistribution.Linear
    } = this.props;
    const font = `${UPLOT_AXIS_FONT_SIZE}px ${theme.typography.fontFamily}`;
    const gridColor = theme.isDark ? "rgba(240, 250, 255, 0.09)" : "rgba(0, 10, 23, 0.09)";
    if (data.isBooleanUnit(scaleKey)) {
      splits = [0, 1];
    }
    if (decimals === 0 && distr === schema.ScaleDistribution.Linear) {
      filter = (u, splits2) => splits2.map((v) => Number.isInteger(v) ? v : null);
    }
    let config = {
      scale: scaleKey,
      show,
      stroke: color != null ? color : theme.colors.text.primary,
      side: getUPlotSideFromAxis(placement),
      font,
      size: size != null ? size : (self, values2, axisIdx) => {
        return calculateAxisSize(self, values2, axisIdx);
      },
      rotate: tickLabelRotation,
      gap,
      labelGap: 0,
      grid: {
        show: grid.show,
        stroke: gridColor,
        width: 1 / devicePixelRatio
      },
      ticks: Object.assign(
        {
          show: true,
          stroke: (border == null ? void 0 : border.show) ? color != null ? color : theme.colors.text.primary : gridColor,
          width: 1 / devicePixelRatio,
          size: 4
        },
        ticks
      ),
      splits,
      values,
      space: space != null ? space : (self, axisIdx, scaleMin, scaleMax, plotDim) => {
        return calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim, formatValue);
      },
      filter,
      incrs
    };
    if (border == null ? void 0 : border.show) {
      config.border = {
        stroke: color != null ? color : theme.colors.text.primary,
        width: 1 / devicePixelRatio,
        ...border
      };
    }
    if (label != null && label.length > 0) {
      config.label = label;
      config.labelSize = UPLOT_AXIS_FONT_SIZE + labelPad;
      config.labelFont = font;
      config.labelGap = labelPad;
    }
    if (values) {
      config.values = values;
    } else if (isTime) {
      config.values = formatTime;
    } else if (formatValue) {
      config.values = (u, splits2, axisIdx, tickSpace, tickIncr) => {
        let decimals2 = data.guessDecimals(data.roundDecimals(tickIncr, 6));
        return splits2.map((v) => {
          if (v == null) {
            return null;
          } else {
            return formatValue(v, decimals2 > 0 ? decimals2 : void 0);
          }
        });
      };
    }
    config.timeZone = timeZone;
    return config;
  }
}
const timeUnitSize = {
  second: 1e3,
  minute: 60 * 1e3,
  hour: 60 * 60 * 1e3,
  day: 24 * 60 * 60 * 1e3,
  month: 28 * 24 * 60 * 60 * 1e3,
  year: 365 * 24 * 60 * 60 * 1e3
};
function formatTime(self, splits, axisIdx, foundSpace, foundIncr) {
  var _a, _b;
  const axis = self.axes[axisIdx];
  const timeZone = "timeZone" in axis && typeof axis.timeZone === "string" ? axis.timeZone : void 0;
  const scale = self.scales.x;
  const range = ((_a = scale == null ? void 0 : scale.max) != null ? _a : 0) - ((_b = scale == null ? void 0 : scale.min) != null ? _b : 0);
  const yearRoundedToDay = Math.round(timeUnitSize.year / timeUnitSize.day) * timeUnitSize.day;
  const incrementRoundedToDay = Math.round(foundIncr / timeUnitSize.day) * timeUnitSize.day;
  let format = data.systemDateFormats.interval.year;
  if (foundIncr < timeUnitSize.second) {
    format = data.systemDateFormats.interval.millisecond;
  } else if (foundIncr <= timeUnitSize.minute) {
    format = data.systemDateFormats.interval.second;
  } else if (range <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.minute;
  } else if (foundIncr <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.hour;
  } else if (range < timeUnitSize.year) {
    format = data.systemDateFormats.interval.day;
  } else if (incrementRoundedToDay === yearRoundedToDay) {
    format = data.systemDateFormats.interval.year;
  } else if (foundIncr <= timeUnitSize.year) {
    format = data.systemDateFormats.interval.month;
  }
  return splits.map((v) => v == null ? "" : data.dateTimeFormat(v, { format, timeZone }));
}
function calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim, formatValue) {
  const axis = self.axes[axisIdx];
  const scale = self.scales[axis.scale];
  if (axis.side !== 2 || !scale) {
    return plotDim <= Y_TICK_SPACING_PANEL_HEIGHT ? Y_TICK_SPACING_SMALL : Y_TICK_SPACING_NORMAL;
  }
  const maxTicks = plotDim / X_TICK_SPACING_NORMAL;
  const increment = (scaleMax - scaleMin) / maxTicks;
  const bigValue = Math.max(Math.abs(scaleMin), Math.abs(scaleMax));
  let sample = "";
  if (scale.time) {
    sample = formatTime(self, [bigValue], axisIdx, X_TICK_SPACING_NORMAL, increment)[0];
  } else if (formatValue != null) {
    sample = formatValue(bigValue);
  } else {
    return X_TICK_SPACING_NORMAL;
  }
  const valueWidth = measureText(sample, UPLOT_AXIS_FONT_SIZE).width;
  return valueWidth + X_TICK_VALUE_GAP;
}
function calculateAxisSize(self, values, axisIdx) {
  const axis = self.axes[axisIdx];
  let axisSize = axis.ticks.size;
  if (axis.side === 2) {
    axisSize += axis.gap + UPLOT_AXIS_FONT_SIZE;
  } else if (values == null ? void 0 : values.length) {
    let maxTextWidth = values.reduce((acc, value) => Math.max(acc, measureText(value, UPLOT_AXIS_FONT_SIZE).width), 0);
    const textWidthWithLimit = Math.min(self.width * 0.4, maxTextWidth);
    axisSize += axis.gap + axis.labelGap + textWidthWithLimit;
  }
  return Math.ceil(axisSize);
}
function getUPlotSideFromAxis(axis) {
  switch (axis) {
    case schema.AxisPlacement.Top:
      return 0;
    case schema.AxisPlacement.Right:
      return 1;
    case schema.AxisPlacement.Bottom:
      return 2;
    case schema.AxisPlacement.Left:
  }
  return 3;
}

"use strict";
function makeDirectionalGradient(direction, bbox, ctx) {
  let x0 = 0, y0 = 0, x1 = 0, y1 = 0;
  if (direction === 3 /* Down */) {
    y0 = bbox.top;
    y1 = bbox.top + bbox.height;
  } else if (direction === 2 /* Left */) {
    x0 = bbox.left + bbox.width;
    x1 = bbox.left;
  } else if (direction === 1 /* Up */) {
    y0 = bbox.top + bbox.height;
    y1 = bbox.top;
  } else if (direction === 0 /* Right */) {
    x0 = bbox.left;
    x1 = bbox.left + bbox.width;
  }
  return ctx.createLinearGradient(x0, y0, x1, y1);
}
function getOpacityGradientFn(color, opacity) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    gradient.addColorStop(0, data.colorManipulator.alpha(color, opacity));
    gradient.addColorStop(1, data.colorManipulator.alpha(color, 0));
    return gradient;
  };
}
function getHueGradientFn(color, opacity, theme) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    const color1 = tinycolor__default.default(color).spin(-25).darken(5);
    const color2 = tinycolor__default.default(color).saturate(20).spin(20).brighten(10);
    if (theme.isDark) {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.darken(10).setAlpha(opacity).toString());
    } else {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.setAlpha(opacity).toString());
    }
    return gradient;
  };
}
var GradientDirection = /* @__PURE__ */ ((GradientDirection2) => {
  GradientDirection2[GradientDirection2["Right"] = 0] = "Right";
  GradientDirection2[GradientDirection2["Up"] = 1] = "Up";
  GradientDirection2[GradientDirection2["Left"] = 2] = "Left";
  GradientDirection2[GradientDirection2["Down"] = 3] = "Down";
  return GradientDirection2;
})(GradientDirection || {});
function scaleGradient(u, scaleKey, scaleStops, discrete = false) {
  let scale = u.scales[scaleKey];
  let minStopIdx = null;
  let maxStopIdx = null;
  for (let i = 0; i < scaleStops.length; i++) {
    let stopVal = scaleStops[i][0];
    if (stopVal <= scale.min || minStopIdx == null) {
      minStopIdx = i;
    }
    maxStopIdx = i;
    if (stopVal >= scale.max) {
      break;
    }
  }
  if (minStopIdx === maxStopIdx) {
    return scaleStops[minStopIdx][1];
  }
  let minStopVal = scaleStops[minStopIdx][0];
  let maxStopVal = scaleStops[maxStopIdx][0];
  if (minStopVal === -Infinity) {
    minStopVal = scale.min;
  }
  if (maxStopVal === Infinity) {
    maxStopVal = scale.max;
  }
  let minStopPos = Math.round(u.valToPos(minStopVal, scaleKey, true));
  let maxStopPos = Math.round(u.valToPos(maxStopVal, scaleKey, true));
  let range = minStopPos - maxStopPos;
  if (range === 0) {
    return scaleStops[maxStopIdx][1];
  }
  let x0, y0, x1, y1;
  if (u.scales.x.ori === schema.ScaleOrientation.Horizontal) {
    x0 = x1 = 0;
    y0 = minStopPos;
    y1 = maxStopPos;
  } else {
    y0 = y1 = 0;
    x0 = minStopPos;
    x1 = maxStopPos;
  }
  let ctx = getCanvasContext();
  let grd = ctx.createLinearGradient(x0, y0, x1, y1);
  let prevColor;
  for (let i = minStopIdx; i <= maxStopIdx; i++) {
    let s = scaleStops[i];
    let stopPos = i === minStopIdx ? minStopPos : i === maxStopIdx ? maxStopPos : Math.round(u.valToPos(s[0], scaleKey, true));
    let pct = (minStopPos - stopPos) / range;
    if (discrete && i > minStopIdx) {
      grd.addColorStop(pct, prevColor);
    }
    grd.addColorStop(pct, prevColor = s[1]);
  }
  return grd;
}
function getDataRange(plot, scaleKey) {
  let sc = plot.scales[scaleKey];
  let min = Infinity;
  let max = -Infinity;
  plot.series.forEach((ser, seriesIdx) => {
    if (ser.show && ser.scale === scaleKey) {
      if (ser.min == null) {
        let data = plot.data[seriesIdx];
        for (let i = 0; i < data.length; i++) {
          if (data[i] != null) {
            min = Math.min(min, data[i]);
            max = Math.max(max, data[i]);
          }
        }
      } else {
        min = Math.min(min, ser.min);
        max = Math.max(max, ser.max);
      }
    }
  });
  if (max === min) {
    min = sc.min;
    max = sc.max;
  }
  return [min, max];
}
function getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax) {
  var _a, _b, _c, _d;
  let min = (_a = hardMin != null ? hardMin : softMin) != null ? _a : null;
  let max = (_b = hardMax != null ? hardMax : softMax) != null ? _b : null;
  if (min == null || max == null) {
    let [dataMin, dataMax] = getDataRange(u, scaleKey);
    min = (_c = min != null ? min : dataMin) != null ? _c : 0;
    max = (_d = max != null ? max : dataMax) != null ? _d : 100;
  }
  return [min, max];
}
function isStepTransparent(color) {
  return color === "transparent" || color[0] === "#" && color.slice(-2) === "00";
}
function getScaleGradientFn(opacity, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax) {
  if (!colorMode) {
    throw Error("Missing colorMode required for color scheme gradients");
  }
  if (!thresholds) {
    throw Error("Missing thresholds required for color scheme gradients");
  }
  return (plot, seriesIdx) => {
    let scaleKey = plot.series[seriesIdx].scale;
    let gradient = "";
    if (colorMode.id === data.FieldColorModeId.Thresholds) {
      if (thresholds.mode === data.ThresholdsMode.Absolute) {
        const valueStops = thresholds.steps.map((step) => [
          step.value,
          isStepTransparent(step.color) ? "#0000" : data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      } else {
        const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
        const range = max - min;
        const valueStops = thresholds.steps.map((step) => [
          min + range * (step.value / 100),
          data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      }
    } else if (colorMode.getColors) {
      const colors = colorMode.getColors(theme);
      const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
      const range = max - min;
      const valueStops = colors.map((color, i) => [
        min + range * (i / (colors.length - 1)),
        data.colorManipulator.alpha(theme.visualization.getColorByName(color), opacity)
      ]);
      gradient = scaleGradient(plot, scaleKey, valueStops, false);
    }
    return gradient;
  };
}

"use strict";
class UPlotSeriesBuilder extends PlotConfigBuilder {
  getConfig() {
    var _a;
    const {
      facets,
      drawStyle,
      pathBuilder,
      pointsBuilder,
      pointsFilter,
      lineInterpolation,
      lineWidth,
      lineStyle,
      barAlignment,
      barWidthFactor,
      barMaxWidth,
      showPoints,
      pointSize,
      scaleKey,
      pxAlign,
      spanNulls,
      show = true
    } = this.props;
    let lineConfig = {};
    let lineColor = this.getLineColor();
    lineConfig.stroke = lineColor;
    lineConfig.width = lineWidth;
    if (lineStyle && lineStyle.fill !== "solid") {
      if (lineStyle.fill === "dot") {
        lineConfig.cap = "round";
      }
      lineConfig.dash = (_a = lineStyle.dash) != null ? _a : [10, 10];
    }
    if (pathBuilder != null) {
      lineConfig.paths = pathBuilder;
    } else if (drawStyle === schema.GraphDrawStyle.Points) {
      lineConfig.paths = () => null;
    } else if (drawStyle != null) {
      lineConfig.paths = (self, seriesIdx, idx0, idx1) => {
        let pathsBuilder = mapDrawStyleToPathBuilder(
          drawStyle,
          lineInterpolation,
          barAlignment,
          barWidthFactor,
          barMaxWidth
        );
        return pathsBuilder(self, seriesIdx, idx0, idx1);
      };
    }
    const useColor = (
      // @ts-ignore
      typeof lineColor === "string" ? lineColor : (u, seriesIdx) => u.series[seriesIdx]._stroke
    );
    const pointsConfig = {
      points: {
        stroke: useColor,
        fill: useColor,
        size: !pointSize || pointSize < lineWidth ? void 0 : pointSize,
        filter: pointsFilter
      }
    };
    if (pointsBuilder != null) {
      pointsConfig.points.show = pointsBuilder;
    } else {
      if (drawStyle === schema.GraphDrawStyle.Points) {
        pointsConfig.points.show = true;
      } else {
        if (showPoints === schema.VisibilityMode.Auto) {
          if (drawStyle === schema.GraphDrawStyle.Bars) {
            pointsConfig.points.show = false;
          }
        } else if (showPoints === schema.VisibilityMode.Never) {
          pointsConfig.points.show = false;
        } else if (showPoints === schema.VisibilityMode.Always) {
          pointsConfig.points.show = true;
        }
      }
    }
    return {
      scale: scaleKey,
      facets,
      spanGaps: typeof spanNulls === "number" ? false : spanNulls,
      value: () => "",
      pxAlign,
      show,
      fill: this.getFill(),
      ...lineConfig,
      ...pointsConfig
    };
  }
  getLineColor() {
    const {
      lineColor,
      gradientMode,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (gradientMode === schema.GraphGradientMode.None && dynamicSeriesColor) {
      return (plot, seriesIdx) => {
        var _a, _b;
        return (_b = (_a = dynamicSeriesColor(seriesIdx)) != null ? _a : lineColor) != null ? _b : data.FALLBACK_COLOR;
      };
    }
    if (gradientMode === schema.GraphGradientMode.Scheme && (colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
      return getScaleGradientFn(1, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
    }
    if (gradientMode === schema.GraphGradientMode.Hue) {
      return getHueGradientFn(lineColor != null ? lineColor : data.FALLBACK_COLOR, 1, theme);
    }
    return lineColor != null ? lineColor : data.FALLBACK_COLOR;
  }
  getFill() {
    const {
      lineColor,
      fillColor,
      gradientMode,
      fillOpacity,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (fillColor) {
      return fillColor;
    }
    const mode = gradientMode != null ? gradientMode : schema.GraphGradientMode.None;
    const opacityPercent = (fillOpacity != null ? fillOpacity : 0) / 100;
    if (mode === schema.GraphGradientMode.None && dynamicSeriesColor && opacityPercent > 0) {
      return (u, seriesIdx) => {
        let lineColor2 = u.series[seriesIdx]._stroke;
        return data.colorManipulator.alpha(lineColor2 != null ? lineColor2 : "", opacityPercent);
      };
    }
    switch (mode) {
      case schema.GraphGradientMode.Opacity:
        return getOpacityGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent);
      case schema.GraphGradientMode.Hue:
        return getHueGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent, theme);
      case schema.GraphGradientMode.Scheme:
        if ((colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
          return getScaleGradientFn(opacityPercent, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
        }
      // intentional fall-through to handle Scheme with Fixed color
      default:
        if (opacityPercent > 0) {
          return data.colorManipulator.alpha(lineColor != null ? lineColor : "", opacityPercent);
        }
    }
    return void 0;
  }
}
let builders = void 0;
function mapDrawStyleToPathBuilder(style, lineInterpolation, barAlignment = schema.BarAlignment.Center, barWidthFactor = 0.6, barMaxWidth = 200) {
  const pathBuilders = uPlot__default.default.paths;
  if (!builders) {
    builders = {
      linear: pathBuilders.linear(),
      smooth: pathBuilders.spline(),
      stepBefore: pathBuilders.stepped({ align: -1 }),
      stepAfter: pathBuilders.stepped({ align: 1 })
    };
  }
  if (style === schema.GraphDrawStyle.Bars) {
    let barsCfgKey = `bars|${barAlignment}|${barWidthFactor}|${barMaxWidth}`;
    if (!builders[barsCfgKey]) {
      builders[barsCfgKey] = pathBuilders.bars({
        size: [barWidthFactor, barMaxWidth],
        align: barAlignment
      });
    }
    return builders[barsCfgKey];
  } else if (style === schema.GraphDrawStyle.Line) {
    if (lineInterpolation === schema.LineInterpolation.StepBefore) {
      return builders.stepBefore;
    }
    if (lineInterpolation === schema.LineInterpolation.StepAfter) {
      return builders.stepAfter;
    }
    if (lineInterpolation === schema.LineInterpolation.Smooth) {
      return builders.smooth;
    }
  }
  return builders.linear;
}

"use strict";
function getThresholdsDrawHook(options) {
  const dashSegments = options.config.mode === schema.GraphThresholdsStyleMode.Dashed || options.config.mode === schema.GraphThresholdsStyleMode.DashedAndArea ? [10, 10] : [];
  function addLines(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let transparentIndex = 0;
    for (let idx = 0; idx < steps.length; idx++) {
      const step = steps[idx];
      if (step.color === "transparent") {
        transparentIndex = idx;
        break;
      }
    }
    ctx.lineWidth = 2;
    ctx.setLineDash(dashSegments);
    for (let idx = 1; idx < steps.length; idx++) {
      const step = steps[idx];
      let color;
      if (transparentIndex >= idx && idx > 0) {
        color = tinycolor__default.default(theme2.visualization.getColorByName(steps[idx - 1].color));
      } else {
        color = tinycolor__default.default(theme2.visualization.getColorByName(step.color));
      }
      if (color.getAlpha() === 1) {
        color.setAlpha(0.7);
      }
      const isHorizontal = u.scales.x.ori === schema.ScaleOrientation.Horizontal;
      const scaleVal = u.valToPos(step.value, yScaleKey, true);
      let x0 = Math.round(isHorizontal ? u.bbox.left : scaleVal);
      let y0 = Math.round(isHorizontal ? scaleVal : u.bbox.top);
      let x1 = Math.round(isHorizontal ? u.bbox.left + u.bbox.width : scaleVal);
      let y1 = Math.round(isHorizontal ? scaleVal : u.bbox.top + u.bbox.height);
      ctx.beginPath();
      ctx.moveTo(x0, y0);
      ctx.lineTo(x1, y1);
      ctx.strokeStyle = color.toString();
      ctx.stroke();
    }
  }
  function addAreas(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let grd = scaleGradient(
      u,
      yScaleKey,
      steps.map((step) => {
        let color = tinycolor__default.default(theme2.visualization.getColorByName(step.color));
        if (color.getAlpha() === 1) {
          color.setAlpha(0.15);
        }
        return [step.value, color.toString()];
      }),
      true
    );
    ctx.fillStyle = grd;
    ctx.fillRect(u.bbox.left, u.bbox.top, u.bbox.width, u.bbox.height);
  }
  const { scaleKey, thresholds, theme, config, hardMin, hardMax, softMin, softMax } = options;
  return (u) => {
    const ctx = u.ctx;
    const { min: xMin, max: xMax } = u.scales.x;
    const { min: yMin, max: yMax } = u.scales[scaleKey];
    if (xMin == null || xMax == null || yMin == null || yMax == null) {
      return;
    }
    let { steps, mode } = thresholds;
    if (mode === data.ThresholdsMode.Percentage) {
      let [min, max] = getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax);
      let range = max - min;
      steps = steps.map((step) => ({
        ...step,
        value: min + range * (step.value / 100)
      }));
    }
    ctx.save();
    switch (config.mode) {
      case schema.GraphThresholdsStyleMode.Line:
      case schema.GraphThresholdsStyleMode.Dashed:
        addLines(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.Area:
        addAreas(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.LineAndArea:
      case schema.GraphThresholdsStyleMode.DashedAndArea:
        addAreas(u, scaleKey, steps, theme);
        addLines(u, scaleKey, steps, theme);
    }
    ctx.restore();
  };
}

"use strict";
const cursorDefaults = {
  // prevent client-side zoom from triggering at the end of a selection
  drag: { setScale: false },
  points: {
    /*@ts-ignore*/
    size: (u, seriesIdx) => u.series[seriesIdx].points.size * 2,
    /*@ts-ignore*/
    width: (u, seriesIdx, size) => size / 4
  },
  focus: {
    prox: 30
  }
};
class UPlotConfigBuilder {
  constructor(timeZone = data.DefaultTimeZone) {
    this.uid = Math.random().toString(36).slice(2);
    this.series = [];
    this.axes = {};
    this.scales = [];
    this.bands = [];
    this.stackingGroups = [];
    this.hasLeftAxis = false;
    this.hooks = {};
    this.tz = void 0;
    this.mode = 1;
    this.frames = void 0;
    // to prevent more than one threshold per scale
    this.thresholds = {};
    this.padding = void 0;
    this.prepData = void 0;
    // Exposed to let the container know the primary scale keys
    this.scaleKeys = ["", ""];
    this.tzDate = (ts) => {
      let date = new Date(ts);
      return this.tz ? uPlot__default.default.tzDate(date, this.tz) : date;
    };
    var _a;
    this.tz = (_a = data.getTimeZoneInfo(timeZone, Date.now())) == null ? void 0 : _a.ianaName;
  }
  addHook(type, hook) {
    pluginLog("UPlotConfigBuilder", false, "addHook", type);
    if (!this.hooks[type]) {
      this.hooks[type] = [];
    }
    this.hooks[type].push(hook);
  }
  addThresholds(options) {
    if (!this.thresholds[options.scaleKey]) {
      this.thresholds[options.scaleKey] = options;
      this.addHook("drawClear", getThresholdsDrawHook(options));
    }
  }
  addAxis(props) {
    var _a, _b, _c;
    props.placement = (_a = props.placement) != null ? _a : schema.AxisPlacement.Auto;
    props.grid = (_b = props.grid) != null ? _b : {};
    let scaleKey = props.scaleKey;
    if (scaleKey === "x") {
      scaleKey += (_c = props.timeZone) != null ? _c : "";
    }
    if (this.axes[scaleKey]) {
      this.axes[scaleKey].merge(props);
      return;
    }
    if (props.placement === schema.AxisPlacement.Auto) {
      props.placement = this.hasLeftAxis ? schema.AxisPlacement.Right : schema.AxisPlacement.Left;
    }
    if (props.placement === schema.AxisPlacement.Left) {
      this.hasLeftAxis = true;
    }
    if (props.placement === schema.AxisPlacement.Hidden) {
      props.grid.show = false;
      props.size = 0;
    }
    this.axes[scaleKey] = new UPlotAxisBuilder(props);
  }
  getAxisPlacement(scaleKey) {
    var _a;
    const axis = this.axes[scaleKey];
    return (_a = axis == null ? void 0 : axis.props.placement) != null ? _a : schema.AxisPlacement.Left;
  }
  setCursor(cursor) {
    this.cursor = lodash.merge({}, this.cursor, cursor);
  }
  setMode(mode) {
    this.mode = mode;
  }
  setSelect(select) {
    this.select = select;
  }
  addSeries(props) {
    this.series.push(new UPlotSeriesBuilder(props));
  }
  getSeries() {
    return this.series;
  }
  /** Add or update the scale with the scale key */
  addScale(props) {
    const current = this.scales.find((v) => v.props.scaleKey === props.scaleKey);
    if (current) {
      current.merge(props);
      return;
    }
    this.scales.push(new UPlotScaleBuilder(props));
  }
  addBand(band) {
    this.bands.push(band);
  }
  setStackingGroups(groups) {
    this.stackingGroups = groups;
  }
  getStackingGroups() {
    return this.stackingGroups;
  }
  setPrepData(prepData) {
    this.prepData = (frames) => {
      this.frames = frames;
      return prepData(frames, this.getStackingGroups());
    };
  }
  setPadding(padding) {
    this.padding = padding;
  }
  getConfig() {
    if (this.cachedConfig) {
      return this.cachedConfig;
    }
    const config = {
      ...DEFAULT_PLOT_CONFIG,
      mode: this.mode,
      series: [
        this.mode === 2 ? null : {
          value: () => ""
        }
      ]
    };
    config.axes = this.ensureNonOverlappingAxes(Object.values(this.axes)).map((a) => a.getConfig());
    config.series = [...config.series, ...this.series.map((s) => s.getConfig())];
    config.scales = this.scales.reduce((acc, s) => {
      return { ...acc, ...s.getConfig() };
    }, {});
    config.hooks = this.hooks;
    config.select = this.select;
    const pointColorFn = (alphaHex = "") => (u, seriesIdx) => {
      let s = u.series[seriesIdx].points._stroke;
      if (typeof s !== "string") {
        let field = this.frames[0].fields[seriesIdx];
        s = field.display(field.values[u.cursor.idxs[seriesIdx]]).color;
      }
      return s + alphaHex;
    };
    config.cursor = lodash.merge(
      {},
      cursorDefaults,
      {
        points: {
          stroke: pointColorFn("80"),
          fill: pointColorFn()
        }
      },
      this.cursor
    );
    config.tzDate = this.tzDate;
    if (Array.isArray(this.padding)) {
      config.padding = this.padding;
    }
    this.stackingGroups.forEach((group) => {
      getStackingBands(group).forEach((band) => {
        this.addBand(band);
      });
    });
    if (this.bands.length) {
      config.bands = this.bands;
    }
    this.cachedConfig = config;
    return config;
  }
  ensureNonOverlappingAxes(axes) {
    const xAxis = axes.find((a) => a.props.scaleKey === "x");
    const axesWithoutGridSet = axes.filter((a) => {
      var _a;
      return ((_a = a.props.grid) == null ? void 0 : _a.show) === void 0;
    });
    const firstValueAxisIdx = axesWithoutGridSet.findIndex(
      (a) => a.props.placement === schema.AxisPlacement.Left || a.props.placement === schema.AxisPlacement.Right || a.props.placement === schema.AxisPlacement.Bottom && a !== xAxis
    );
    for (let i = 0; i < axesWithoutGridSet.length; i++) {
      if (axesWithoutGridSet[i] === xAxis || i === firstValueAxisIdx) {
        axesWithoutGridSet[i].props.grid.show = true;
      } else {
        axesWithoutGridSet[i].props.grid.show = false;
      }
    }
    return axes;
  }
}

"use strict";
function preparePlotFrame$1(sparkline, config) {
  var _a, _b, _c;
  const length = sparkline.y.values.length;
  const yFieldConfig = {
    ...sparkline.y.config,
    ...config
  };
  const xField = (_a = sparkline.x) != null ? _a : {
    name: "",
    values: [...Array(length).keys()],
    type: data.FieldType.number,
    config: {}
  };
  let frame = {
    refId: "sparkline",
    fields: [
      xField,
      {
        ...sparkline.y,
        config: yFieldConfig
      }
    ],
    length
  };
  if (!data.isLikelyAscendingVector(xField.values)) {
    frame = data.sortDataFrame(frame, 0);
  }
  return data.applyNullInsertThreshold({
    frame,
    refFieldPseudoMin: (_b = sparkline.timeRange) == null ? void 0 : _b.from.valueOf(),
    refFieldPseudoMax: (_c = sparkline.timeRange) == null ? void 0 : _c.to.valueOf()
  });
}

"use strict";
const defaultConfig$1 = {
  drawStyle: schema.GraphDrawStyle.Line,
  showPoints: schema.VisibilityMode.Auto,
  axisPlacement: schema.AxisPlacement.Hidden,
  pointSize: 2
};
class Sparkline extends React.PureComponent {
  constructor(props) {
    super(props);
    const alignedDataFrame = preparePlotFrame$1(props.sparkline, props.config);
    this.state = {
      data: preparePlotData2(alignedDataFrame, getStackingGroups(alignedDataFrame)),
      alignedDataFrame,
      configBuilder: this.prepareConfig(alignedDataFrame)
    };
  }
  static getDerivedStateFromProps(props, state) {
    const _frame = preparePlotFrame$1(props.sparkline, props.config);
    const frame = data.nullToValue(_frame);
    if (!frame) {
      return { ...state };
    }
    return {
      ...state,
      data: preparePlotData2(frame, getStackingGroups(frame)),
      alignedDataFrame: frame
    };
  }
  componentDidUpdate(prevProps, prevState) {
    var _a, _b;
    const { alignedDataFrame } = this.state;
    if (!alignedDataFrame) {
      return;
    }
    let rebuildConfig = false;
    if (prevProps.sparkline !== this.props.sparkline) {
      const isStructureChanged = !data.compareDataFrameStructures(this.state.alignedDataFrame, prevState.alignedDataFrame);
      const isRangeChanged = !lodash.isEqual(
        (_a = alignedDataFrame.fields[1].state) == null ? void 0 : _a.range,
        (_b = prevState.alignedDataFrame.fields[1].state) == null ? void 0 : _b.range
      );
      rebuildConfig = isStructureChanged || isRangeChanged;
    } else {
      rebuildConfig = !lodash.isEqual(prevProps.config, this.props.config);
    }
    if (rebuildConfig) {
      this.setState({ configBuilder: this.prepareConfig(alignedDataFrame) });
    }
  }
  getYRange(field) {
    var _a, _b, _c, _d;
    let { min, max } = (_a = this.state.alignedDataFrame.fields[1].state) == null ? void 0 : _a.range;
    const noValue = +((_b = this.state.alignedDataFrame.fields[1].config) == null ? void 0 : _b.noValue);
    if (!Number.isNaN(noValue)) {
      min = Math.min(min, +noValue);
      max = Math.max(max, +noValue);
    }
    if (min === max) {
      if (min === 0) {
        max = 100;
      } else {
        min = 0;
        max *= 2;
      }
      return [min, max];
    }
    return [Math.max(min, (_c = field.config.min) != null ? _c : -Infinity), Math.min(max, (_d = field.config.max) != null ? _d : Infinity)];
  }
  prepareConfig(data$1) {
    var _a;
    const { theme } = this.props;
    const builder = new UPlotConfigBuilder();
    builder.setCursor({
      show: false,
      x: false,
      // no crosshairs
      y: false
    });
    const xField = data$1.fields[0];
    builder.addScale({
      scaleKey: "x",
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      isTime: false,
      //xField.type === FieldType.time,
      range: () => {
        const { sparkline } = this.props;
        if (sparkline.x) {
          if (sparkline.timeRange && sparkline.x.type === data.FieldType.time) {
            return [sparkline.timeRange.from.valueOf(), sparkline.timeRange.to.valueOf()];
          }
          const vals = sparkline.x.values;
          return [vals[0], vals[vals.length - 1]];
        }
        return [0, sparkline.y.values.length - 1];
      }
    });
    builder.addAxis({
      scaleKey: "x",
      theme,
      placement: schema.AxisPlacement.Hidden
    });
    for (let i = 0; i < data$1.fields.length; i++) {
      const field = data$1.fields[i];
      const config = field.config;
      const customConfig = {
        ...defaultConfig$1,
        ...config.custom
      };
      if (field === xField || field.type !== data.FieldType.number) {
        continue;
      }
      const scaleKey = config.unit || "__fixed";
      builder.addScale({
        scaleKey,
        orientation: schema.ScaleOrientation.Vertical,
        direction: schema.ScaleDirection.Up,
        range: () => this.getYRange(field)
      });
      builder.addAxis({
        scaleKey,
        theme,
        placement: schema.AxisPlacement.Hidden
      });
      const colorMode = data.getFieldColorModeForField(field);
      const seriesColor = colorMode.getCalculator(field, theme)(0, 0);
      const pointsMode = customConfig.drawStyle === schema.GraphDrawStyle.Points ? schema.VisibilityMode.Always : customConfig.showPoints;
      builder.addSeries({
        pxAlign: false,
        scaleKey,
        theme,
        colorMode,
        thresholds: config.thresholds,
        drawStyle: customConfig.drawStyle,
        lineColor: (_a = customConfig.lineColor) != null ? _a : seriesColor,
        lineWidth: customConfig.lineWidth,
        lineInterpolation: customConfig.lineInterpolation,
        showPoints: pointsMode,
        pointSize: customConfig.pointSize,
        fillOpacity: customConfig.fillOpacity,
        fillColor: customConfig.fillColor,
        lineStyle: customConfig.lineStyle,
        gradientMode: customConfig.gradientMode,
        spanNulls: customConfig.spanNulls
      });
    }
    return builder;
  }
  render() {
    const { data, configBuilder } = this.state;
    const { width, height } = this.props;
    return /* @__PURE__ */ jsxRuntime.jsx(UPlotChart, { data, config: configBuilder, width, height });
  }
}

"use strict";
const defaultSparklineCellConfig$1 = {
  type: schema.TableCellDisplayMode.Sparkline,
  drawStyle: schema.GraphDrawStyle.Line,
  lineInterpolation: schema.LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: schema.GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: schema.BarAlignment.Center,
  showPoints: schema.VisibilityMode.Never,
  hideValue: false
};
const SparklineCell$1 = (props) => {
  var _a, _b;
  const { field, innerWidth, tableStyles, cell, cellProps, timeRange } = props;
  const sparkline = getSparkline$1(cell.value);
  const theme = useTheme2();
  if (!sparkline) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: field.config.noValue || "no data" });
  }
  if (sparkline.x && !sparkline.x.config.interval && sparkline.x.values.length > 1) {
    sparkline.x.config.interval = sparkline.x.values[1] - sparkline.x.values[0];
  }
  sparkline.y.values = sparkline.y.values.map((v) => {
    if (!Number.isFinite(v)) {
      return null;
    } else {
      return v;
    }
  });
  const range = data.getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  sparkline.timeRange = timeRange;
  const cellOptions = getTableSparklineCellOptions$1(field);
  const config = {
    color: field.config.color,
    custom: {
      ...defaultSparklineCellConfig$1,
      ...cellOptions
    }
  };
  const hideValue = (_b = (_a = field.config.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.hideValue;
  let valueWidth = 0;
  let valueElement = null;
  if (!hideValue) {
    const value = data.isDataFrameWithValue(cell.value) ? cell.value.value : null;
    const displayValue = field.display(value);
    const alignmentFactor = getAlignmentFactor$1(field, displayValue, cell.row.index);
    valueWidth = measureText(data.formattedValueToString(alignmentFactor), 16).width + theme.spacing.gridSize;
    valueElement = /* @__PURE__ */ jsxRuntime.jsx(
      FormattedValueDisplay,
      {
        style: {
          width: `${valueWidth - theme.spacing.gridSize}px`,
          textAlign: "right",
          marginRight: theme.spacing(1)
        },
        value: displayValue
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...cellProps, className: tableStyles.cellContainer, children: [
    valueElement,
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      Sparkline,
      {
        width: innerWidth - valueWidth,
        height: tableStyles.cellHeightInner,
        sparkline,
        config,
        theme: tableStyles.theme
      }
    ) })
  ] });
};
function getSparkline$1(value) {
  if (Array.isArray(value)) {
    return {
      y: {
        name: "test",
        type: data.FieldType.number,
        values: value,
        config: {}
      }
    };
  }
  if (data.isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === data.FieldType.time);
    const numberField = value.fields.find((x) => x.type === data.FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions$1(field) {
  let options = getCellOptions$1(field);
  if (options.type === schema.TableCellDisplayMode.Auto) {
    options = { ...options, type: schema.TableCellDisplayMode.Sparkline };
  }
  if (options.type === schema.TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Expected options type ${schema.TableCellDisplayMode.Sparkline} but got ${options.type}`);
}

"use strict";
const FooterCell = (props) => {
  const cell = css.css({
    width: "100%",
    listStyle: "none"
  });
  const list = css.css({
    width: "100%",
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between"
  });
  if (props.value && !Array.isArray(props.value)) {
    return /* @__PURE__ */ jsxRuntime.jsx("span", { children: props.value });
  }
  if (props.value && Array.isArray(props.value) && props.value.length > 0) {
    return /* @__PURE__ */ jsxRuntime.jsx("ul", { className: cell, children: props.value.map((v, i) => {
      const key = Object.keys(v)[0];
      return /* @__PURE__ */ jsxRuntime.jsxs("li", { className: list, children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { children: key }),
        /* @__PURE__ */ jsxRuntime.jsx("span", { children: v[key] })
      ] }, i);
    }) });
  }
  return EmptyCell;
};
const EmptyCell = () => {
  return /* @__PURE__ */ jsxRuntime.jsx("span", { children: "\xA0" });
};

"use strict";
function FooterRow(props) {
  const { totalColumnsWidth, footerGroups, isPaginationVisible, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      style: {
        position: isPaginationVisible ? "relative" : "absolute",
        width: totalColumnsWidth ? `${totalColumnsWidth}px` : "100%",
        bottom: "0px"
      },
      children: footerGroups.map((footerGroup) => {
        const { key, ...footerGroupProps } = footerGroup.getFooterGroupProps();
        return /* @__PURE__ */ React.createElement("div", { className: tableStyles.tfoot, ...footerGroupProps, key, "data-testid": e2eSelectorsTable.footer }, footerGroup.headers.map((column) => renderFooterCell(column, tableStyles)));
      })
    }
  );
}
function renderFooterCell(column, tableStyles) {
  var _a;
  const { key, ...footerProps } = column.getHeaderProps();
  if (!footerProps) {
    return null;
  }
  footerProps.style = (_a = footerProps.style) != null ? _a : {};
  footerProps.style.position = "absolute";
  footerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.headerCell, ...footerProps, children: column.render("Footer") }, key);
}
function getFooterValue(index, footerValues, isCountRowsSet) {
  if (footerValues === void 0) {
    return EmptyCell;
  }
  if (isCountRowsSet) {
    if (footerValues[index] === void 0) {
      return EmptyCell;
    }
    const key = data.fieldReducers.get(data.ReducerID.count).name;
    return FooterCell({ value: [{ [key]: String(footerValues[index]) }] });
  }
  return FooterCell({ value: footerValues[index] });
}

"use strict";
function RowExpander$1({ row, tableStyles }) {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.expanderCell, ...row.getToggleRowExpandedProps(), children: /* @__PURE__ */ jsxRuntime.jsx(
    Icon,
    {
      "aria-label": row.isExpanded ? "Collapse row" : "Expand row",
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}

"use strict";
const EXPANDER_WIDTH = 50;
function getTextAlign$1(field) {
  if (!field) {
    return "flex-start";
  }
  if (field.config.custom) {
    const custom = field.config.custom;
    switch (custom.align) {
      case "right":
        return "flex-end";
      case "left":
        return "flex-start";
      case "center":
        return "center";
    }
  }
  if (field.type === data.FieldType.number) {
    return "flex-end";
  }
  return "flex-start";
}
function getColumns(data$1, availableWidth, columnMinWidth, expander, footerValues, isCountRowsSet) {
  var _a, _b;
  const columns = [];
  let fieldCountWithoutWidth = 0;
  if (expander) {
    columns.push({
      // Make an expander cell
      Header: () => null,
      // No header
      id: "expander",
      // It needs an ID
      // @ts-expect-error
      // TODO fix type error here
      Cell: RowExpander$1,
      width: EXPANDER_WIDTH,
      minWidth: EXPANDER_WIDTH,
      filter: (_rows, _id, _filterValues) => {
        return [];
      },
      justifyContent: "left",
      field: data$1.fields[0],
      sortType: "basic"
    });
    availableWidth -= EXPANDER_WIDTH;
  }
  for (const [fieldIndex, field] of data$1.fields.entries()) {
    const fieldTableOptions = field.config.custom || {};
    if (fieldTableOptions.hidden || field.type === data.FieldType.nestedFrames) {
      continue;
    }
    if (fieldTableOptions.width) {
      availableWidth -= fieldTableOptions.width;
    } else {
      fieldCountWithoutWidth++;
    }
    const selectSortType = (type) => {
      switch (type) {
        case data.FieldType.number:
        case data.FieldType.frame:
          return "number";
        case data.FieldType.time:
          return "basic";
        default:
          return "alphanumeric-insensitive";
      }
    };
    const Cell = getCellComponent((_a = fieldTableOptions.cellOptions) == null ? void 0 : _a.type, field);
    columns.push({
      // @ts-expect-error
      // TODO fix type error here
      Cell,
      id: fieldIndex.toString(),
      field,
      Header: fieldTableOptions.hideHeader ? "" : data.getFieldDisplayName(field, data$1),
      accessor: (_row, i) => field.values[i],
      sortType: selectSortType(field.type),
      width: fieldTableOptions.width,
      minWidth: (_b = fieldTableOptions.minWidth) != null ? _b : columnMinWidth,
      filter: memoize__default.default(filterByValue(field)),
      justifyContent: getTextAlign$1(field),
      Footer: getFooterValue(fieldIndex, footerValues, isCountRowsSet)
    });
  }
  let sharedWidth = availableWidth / fieldCountWithoutWidth;
  for (let i = fieldCountWithoutWidth; i > 0; i--) {
    for (const column of columns) {
      if (!column.width && column.minWidth > sharedWidth) {
        column.width = column.minWidth;
        availableWidth -= column.width;
        fieldCountWithoutWidth -= 1;
        sharedWidth = availableWidth / fieldCountWithoutWidth;
      }
    }
  }
  for (const column of columns) {
    if (!column.width) {
      column.width = sharedWidth;
    }
    column.minWidth = 50;
  }
  return columns;
}
function getCellComponent(displayMode, field) {
  switch (displayMode) {
    case schema.TableCellDisplayMode.Custom:
    case schema.TableCellDisplayMode.ColorText:
    case schema.TableCellDisplayMode.ColorBackground:
      return DefaultCell;
    case schema.TableCellDisplayMode.Image:
      return ImageCell$1;
    case schema.TableCellDisplayMode.Gauge:
      return BarGaugeCell$1;
    case schema.TableCellDisplayMode.Sparkline:
      return SparklineCell$1;
    case schema.TableCellDisplayMode.JSONView:
      return JSONViewCell;
    case schema.TableCellDisplayMode.DataLinks:
      return DataLinksCell$1;
    case schema.TableCellDisplayMode.Actions:
      return ActionsCell$1;
  }
  if (field.type === data.FieldType.geo) {
    return GeoCell$1;
  }
  if (field.type === data.FieldType.frame) {
    const firstValue = field.values[0];
    if (data.isDataFrame(firstValue) && data.isTimeSeriesFrame(firstValue)) {
      return SparklineCell$1;
    }
    return JSONViewCell;
  }
  if (field.type === data.FieldType.other) {
    return JSONViewCell;
  }
  return DefaultCell;
}
function filterByValue(field) {
  return function(rows, id, filterValues) {
    if (rows.length === 0) {
      return rows;
    }
    if (!filterValues) {
      return rows;
    }
    if (!field) {
      return rows;
    }
    return rows.filter((row) => {
      if (!row.values.hasOwnProperty(id)) {
        return false;
      }
      const value = rowToFieldValue(row, field);
      return filterValues.find((filter) => filter.value === value) !== void 0;
    });
  };
}
function calculateUniqueFieldValues$1(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const value = rowToFieldValue(rows[index], field);
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function rowToFieldValue(row, field) {
  if (!field || !row) {
    return "";
  }
  const fieldValue = field.values[row.index];
  const displayValue = field.display ? field.display(fieldValue) : fieldValue;
  const value = field.display ? data.formattedValueToString(displayValue) : displayValue;
  return value;
}
function valuesToOptions$1(unique) {
  return Object.keys(unique).reduce((all, key) => all.concat({ value: unique[key], label: key }), []).sort(sortOptions$1);
}
function sortOptions$1(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}
function getFilteredOptions$1(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function sortCaseInsensitive(a, b, id) {
  return String(a.values[id]).localeCompare(String(b.values[id]), void 0, { sensitivity: "base" });
}
function sortNumber(rowA, rowB, id) {
  const a = toNumber(rowA.values[id]);
  const b = toNumber(rowB.values[id]);
  return a === b ? 0 : a > b ? 1 : -1;
}
function toNumber(value) {
  var _a;
  if (data.isDataFrameWithValue(value)) {
    return (_a = value.value) != null ? _a : Number.NEGATIVE_INFINITY;
  }
  if (value === null || value === void 0 || value === "" || isNaN(value)) {
    return Number.NEGATIVE_INFINITY;
  }
  if (typeof value === "number") {
    return value;
  }
  return Number(value);
}
function getFooterItems(filterFields, values, options, theme2) {
  addMissingColumnIndex(filterFields);
  return filterFields.map((data$1, i) => {
    var _a;
    if (((_a = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a.type) !== data.FieldType.number) {
      if (i === 0 && options.reducer && options.reducer.length > 0) {
        const reducer = data.fieldReducers.get(options.reducer[0]);
        return reducer.name;
      }
      return void 0;
    }
    let newField = lodash.clone(data$1.field);
    newField.values = values[data$1.id];
    newField.state = void 0;
    data$1.field = newField;
    if (options.fields && options.fields.length > 0) {
      const f = options.fields.find((f2) => {
        var _a2;
        return f2 === ((_a2 = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a2.name);
      });
      if (f) {
        return getFormattedValue(data$1.field, options.reducer, theme2);
      }
      return void 0;
    }
    return getFormattedValue(data$1.field, options.reducer || [], theme2);
  });
}
function getFormattedValue(field, reducer, theme) {
  var _a;
  const calc = reducer[0];
  if (calc === void 0) {
    return "";
  }
  const format = (_a = field.display) != null ? _a : data.getDisplayProcessor({ field, theme });
  const fieldCalcValue = data.reduceField({ field, reducers: reducer })[calc];
  const reducerInfo = data.fieldReducers.get(calc);
  if (reducerInfo.preservesUnits) {
    return data.formattedValueToString(format(fieldCalcValue));
  }
  return data.formattedValueToString({ text: fieldCalcValue });
}
function createFooterCalculationValues(rows) {
  const values = [];
  for (const key in rows) {
    for (const [valKey, val] of Object.entries(rows[key].values)) {
      if (values[valKey] === void 0) {
        values[valKey] = [];
      }
      values[valKey].push(val);
    }
  }
  return values;
}
const defaultCellOptions$1 = { type: schema.TableCellDisplayMode.Auto };
function getCellOptions$1(field) {
  var _a, _b, _c;
  if ((_a = field.config.custom) == null ? void 0 : _a.displayMode) {
    return migrateTableDisplayModeToCellOptions$1((_b = field.config.custom) == null ? void 0 : _b.displayMode);
  }
  if (!((_c = field.config.custom) == null ? void 0 : _c.cellOptions)) {
    return defaultCellOptions$1;
  }
  return field.config.custom.cellOptions;
}
function migrateTableDisplayModeToCellOptions$1(displayMode) {
  switch (displayMode) {
    // In the case of the gauge we move to a different option
    case "basic":
    case "gradient-gauge":
    case "lcd-gauge":
      let gaugeMode = schema.BarGaugeDisplayMode.Basic;
      if (displayMode === "gradient-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Gradient;
      } else if (displayMode === "lcd-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Lcd;
      }
      return {
        type: schema.TableCellDisplayMode.Gauge,
        mode: gaugeMode
      };
    // Also true in the case of the color background
    case "color-background":
    case "color-background-solid":
      let mode = schema.TableCellBackgroundDisplayMode.Basic;
      if (displayMode === "color-background") {
        mode = schema.TableCellBackgroundDisplayMode.Gradient;
      }
      return {
        type: schema.TableCellDisplayMode.ColorBackground,
        mode
      };
    default:
      return {
        // @ts-ignore
        type: displayMode
      };
  }
}
function addMissingColumnIndex(columns) {
  var _a;
  const missingIndex = columns.findIndex((field, index) => (field == null ? void 0 : field.id) !== String(index));
  if (missingIndex === -1 || ((_a = columns[missingIndex]) == null ? void 0 : _a.id) === "expander") {
    return;
  }
  columns.splice(missingIndex, 0, { id: String(missingIndex) });
  addMissingColumnIndex(columns);
}
function getAlignmentFactor$1(field, displayValue, rowIndex) {
  var _a;
  let alignmentFactor = (_a = field.state) == null ? void 0 : _a.alignmentFactors;
  if (alignmentFactor) {
    if (data.formattedValueToString(alignmentFactor).length < data.formattedValueToString(displayValue).length) {
      alignmentFactor = { ...displayValue };
      field.state.alignmentFactors = alignmentFactor;
    }
    return alignmentFactor;
  } else {
    alignmentFactor = { ...displayValue };
    const maxIndex = Math.min(field.values.length, rowIndex + 1e3);
    for (let i = rowIndex + 1; i < maxIndex; i++) {
      const nextDisplayValue = field.display(field.values[i]);
      if (data.formattedValueToString(alignmentFactor).length > data.formattedValueToString(nextDisplayValue).length) {
        alignmentFactor.text = displayValue.text;
      }
    }
    if (field.state) {
      field.state.alignmentFactors = alignmentFactor;
    } else {
      field.state = { alignmentFactors: alignmentFactor };
    }
    return alignmentFactor;
  }
}
function isPointTimeValAroundTableTimeVal(pointTime, rowTime, threshold) {
  return Math.abs(Math.floor(pointTime) - rowTime) < threshold;
}
function calculateAroundPointThreshold(timeField) {
  let max = -Number.MAX_VALUE;
  let min = Number.MAX_VALUE;
  if (timeField.values.length < 2) {
    return 0;
  }
  for (let i = 0; i < timeField.values.length; i++) {
    const value = timeField.values[i];
    if (value > max) {
      max = value;
    }
    if (value < min) {
      min = value;
    }
  }
  return (max - min) / timeField.values.length;
}
function getCellColors$1(theme, cellOptions, displayValue) {
  var _a;
  const darkeningFactor = theme.isDark ? 1 : -0.7;
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.ColorText) {
    textColor = displayValue.color;
  } else if (cellOptions.type === schema.TableCellDisplayMode.ColorBackground) {
    const mode = (_a = cellOptions.mode) != null ? _a : schema.TableCellBackgroundDisplayMode.Gradient;
    if (mode === schema.TableCellBackgroundDisplayMode.Basic) {
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = tinycolor__default.default(displayValue.color).toRgbString();
      bgHoverColor = tinycolor__default.default(displayValue.color).setAlpha(1).toRgbString();
    } else if (mode === schema.TableCellBackgroundDisplayMode.Gradient) {
      const hoverColor = tinycolor__default.default(displayValue.color).setAlpha(1).toRgbString();
      const bgColor2 = tinycolor__default.default(displayValue.color).darken(10 * darkeningFactor).spin(5);
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${displayValue.color})`;
      bgHoverColor = `linear-gradient(120deg, ${bgColor2.setAlpha(1).toRgbString()}, ${hoverColor})`;
    }
  }
  return { textColor, bgColor, bgHoverColor };
}
function guessTextBoundingBox(text, headerGroup, osContext, lineHeight, defaultRowHeight, padding = 0) {
  var _a;
  const width = Number((_a = headerGroup == null ? void 0 : headerGroup.width) != null ? _a : 300);
  const LINE_SCALE_FACTOR = 1.17;
  const LOW_LINE_PAD = 42;
  const PADDING = padding * 2;
  if (osContext !== null && typeof text === "string") {
    const words = text.split(/\s/);
    const lines = [];
    let currentLine = "";
    let wordCount = 0;
    let extraLines = 0;
    for (let i = 0; i < words.length; i++) {
      const currentWord = words[i];
      let lineWidth = osContext.measureText(currentLine + " " + currentWord).width;
      if (lineWidth < width - PADDING) {
        currentLine += " " + currentWord;
        wordCount++;
      } else {
        lines.push({
          width: lineWidth,
          line: currentLine
        });
        currentLine = currentWord;
        wordCount = 0;
      }
    }
    for (let i = 0; i < lines.length; i++) {
      if (lines[i].width > width) {
        let extra = Math.floor(lines[i].width / width) - 1;
        extraLines += extra;
      }
    }
    let lineNumber = lines.length + extraLines;
    let height = 38;
    if (lineNumber > 5) {
      height = lineNumber * lineHeight * LINE_SCALE_FACTOR;
    } else {
      height = lineNumber * lineHeight + LOW_LINE_PAD;
    }
    height += PADDING;
    return { width, height };
  }
  return { width, height: defaultRowHeight };
}
function guessLongestField(fieldConfig, data$1) {
  var _a, _b, _c, _d, _e;
  let longestField = void 0;
  const SAMPLE_SIZE = 3;
  if ((_b = (_a = fieldConfig.defaults.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.wrapText) {
    const stringFields = data$1.fields.filter((field) => field.type === data.FieldType.string);
    if (stringFields.length >= 1 && stringFields[0].values.length > 0) {
      const numValues = stringFields[0].values.length;
      let longestLength = 0;
      if (numValues <= 30) {
        for (const field of stringFields) {
          const fieldLength = field.values[0].length;
          if (fieldLength > longestLength) {
            longestLength = fieldLength;
            longestField = field;
          }
        }
      } else {
        for (const field of stringFields) {
          const vals = lodash.sampleSize(field.values, SAMPLE_SIZE);
          const meanLength = (((_c = vals[0]) == null ? void 0 : _c.length) + ((_d = vals[1]) == null ? void 0 : _d.length) + ((_e = vals[2]) == null ? void 0 : _e.length)) / 3;
          if (meanLength > longestLength) {
            longestLength = meanLength;
            longestField = field;
          }
        }
      }
    }
  }
  return longestField;
}

"use strict";
const ITEM_HEIGHT$1 = 28;
const MIN_HEIGHT$1 = ITEM_HEIGHT$1 * 5;
const operatorSelectableValues$1 = {
  Contains: { label: "Contains", value: "Contains", description: "Contains" },
  "=": { label: "=", value: "=", description: "Equals" },
  "!=": { label: "!=", value: "!=", description: "Not equals" },
  ">": { label: ">", value: ">", description: "Greater" },
  ">=": { label: ">=", value: ">=", description: "Greater or Equal" },
  "<": { label: "<", value: "<", description: "Less" },
  "<=": { label: "<=", value: "<=", description: "Less or Equal" },
  Expression: {
    label: "Expression",
    value: "Expression",
    description: 'Bool Expression (Char $ represents the column value in the expression, e.g. "$ >= 10 && $ <= 12")'
  }
};
const OPERATORS$1 = Object.values(operatorSelectableValues$1);
const REGEX_OPERATOR$1 = operatorSelectableValues$1["Contains"];
const XPR_OPERATOR$1 = operatorSelectableValues$1["Expression"];
const comparableValue$1 = (value) => {
  value = value.trim().replace(/\\/g, "");
  if (/^(\d{4}-\d{2}-\d{2}|\d{4}\/\d{2}\/\d{2})/.test(value)) {
    const date = new Date(value);
    if (!isNaN(date.getTime())) {
      const fmt = data.getValueFormat("dateTimeAsIso");
      return data.formattedValueToString(fmt(date.getTime()));
    }
  }
  const num = parseFloat(value);
  if (!isNaN(num)) {
    return num;
  }
  const lvalue = value.toLowerCase();
  if (lvalue === "true" || lvalue === "false") {
    return lvalue === "true";
  }
  return value;
};
const FilterList$1 = ({
  options,
  values,
  caseSensitive,
  showOperators,
  onChange,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const regex = React.useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = React.useMemo(
    () => options.filter((option) => {
      if (!showOperators || !searchFilter || operator.value === REGEX_OPERATOR$1.value) {
        if (option.label === void 0) {
          return false;
        }
        return regex.test(option.label);
      } else if (operator.value === XPR_OPERATOR$1.value) {
        if (option.value === void 0) {
          return false;
        }
        try {
          const xpr = searchFilter.replace(/\\/g, "");
          const fnc = new Function("$", `'use strict'; return ${xpr};`);
          const val = comparableValue$1(option.value);
          return fnc(val);
        } catch (_) {
        }
        return false;
      } else {
        if (option.value === void 0) {
          return false;
        }
        const value1 = comparableValue$1(option.value);
        const value2 = comparableValue$1(searchFilter);
        switch (operator.value) {
          case "=":
            return value1 === value2;
          case "!=":
            return value1 !== value2;
          case ">":
            return value1 > value2;
          case ">=":
            return value1 >= value2;
          case "<":
            return value1 < value2;
          case "<=":
            return value1 <= value2;
        }
        return false;
      }
    }),
    [options, regex, showOperators, operator, searchFilter]
  );
  const selectedItems = React.useMemo(() => items.filter((item) => values.includes(item)), [items, values]);
  const selectCheckValue = React.useMemo(() => items.length === selectedItems.length, [items, selectedItems]);
  const selectCheckIndeterminate = React.useMemo(
    () => selectedItems.length > 0 && items.length > selectedItems.length,
    [items, selectedItems]
  );
  const selectCheckLabel = React.useMemo(
    () => selectedItems.length ? `${selectedItems.length} selected` : `Select all`,
    [selectedItems]
  );
  const selectCheckDescription = React.useMemo(
    () => items.length !== selectedItems.length ? "Add all displayed values to the filter" : "Remove all displayed values from the filter",
    [items, selectedItems]
  );
  const styles = useStyles2(getStyles$Z);
  const theme = useTheme2();
  const gutter = theme.spacing.gridSize;
  const height = React.useMemo(() => Math.min(items.length * ITEM_HEIGHT$1, MIN_HEIGHT$1) + gutter, [gutter, items.length]);
  const onCheckedChanged = React.useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  const onSelectChanged = React.useCallback(() => {
    if (items.length === selectedItems.length) {
      const newValues = values.filter((item) => !items.includes(item));
      onChange(newValues);
    } else {
      const newValues = [.../* @__PURE__ */ new Set([...values, ...items])];
      onChange(newValues);
    }
  }, [onChange, values, items, selectedItems]);
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.25, children: [
    !showOperators && /* @__PURE__ */ jsxRuntime.jsx(
      FilterInput,
      {
        placeholder: t("grafana-ui.table.filter-placeholder", "Filter values"),
        onChange: setSearchFilter,
        value: searchFilter
      }
    ),
    showOperators && /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "row", gap: 0, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ButtonSelect,
        {
          variant: "canvas",
          options: OPERATORS$1,
          onChange: setOperator,
          value: operator,
          tooltip: operator.description
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        FilterInput,
        {
          placeholder: t("grafana-ui.table.filter-placeholder", "Filter values"),
          onChange: setSearchFilter,
          value: searchFilter
        }
      )
    ] }),
    items.length > 0 ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        reactWindow.FixedSizeList,
        {
          height,
          itemCount: items.length,
          itemSize: ITEM_HEIGHT$1,
          itemData: { items, values: selectedItems, onCheckedChanged, className: styles.filterListRow },
          width: "100%",
          className: styles.filterList,
          children: ItemRenderer$1
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.25, children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.selectDivider) }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.filterListRow), children: /* @__PURE__ */ jsxRuntime.jsx(
          Checkbox,
          {
            value: selectCheckValue,
            indeterminate: selectCheckIndeterminate,
            label: selectCheckLabel,
            description: selectCheckDescription,
            onChange: onSelectChanged
          }
        ) })
      ] })
    ] }) : /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.noValuesLabel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.no-values-label", children: "No values" }) })
  ] });
};
function ItemRenderer$1({ index, style, data: { onCheckedChanged, items, values, className } }) {
  const option = items[index];
  const { value, label } = option;
  const isChecked = values.find((s) => s.value === value) !== void 0;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className, style, title: label, children: /* @__PURE__ */ jsxRuntime.jsx(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }) });
}
const getStyles$Z = (theme) => ({
  filterList: css.css({
    label: "filterList"
  }),
  filterListRow: css.css({
    label: "filterListRow",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0.5),
    ":hover": {
      backgroundColor: theme.colors.action.hover
    }
  }),
  selectDivider: css.css({
    label: "selectDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  noValuesLabel: css.css({
    paddingTop: theme.spacing(1)
  })
});

"use strict";
const FilterPopup$1 = ({
  column: { preFilteredRows, filterValue, setFilter },
  onClose,
  field,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const theme = useTheme2();
  const uniqueValues = React.useMemo(() => calculateUniqueFieldValues$1(preFilteredRows, field), [preFilteredRows, field]);
  const options = React.useMemo(() => valuesToOptions$1(uniqueValues), [uniqueValues]);
  const filteredOptions = React.useMemo(() => getFilteredOptions$1(options, filterValue), [options, filterValue]);
  const [values, setValues] = React.useState(filteredOptions);
  const [matchCase, setMatchCase] = React.useState(false);
  const onCancel = React.useCallback((event) => onClose(), [onClose]);
  const onFilter = React.useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = React.useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = React.useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles$Y);
  return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { onClick: onCancel, useCapture: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.filterContainer), onClick: stopPropagation$1, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 3, children: [
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.5, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", alignItems: "center", children: [
        /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.label, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-heading", children: "Filter by values:" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "text-fields",
            tooltip: t("grafana-ui.table.filter-popup-match-case", "Match case"),
            style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
            onClick: () => {
              setMatchCase((s) => !s);
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.listDivider) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        FilterList$1,
        {
          onChange: setValues,
          values,
          options,
          caseSensitive: matchCase,
          showOperators: true,
          searchFilter,
          setSearchFilter,
          operator,
          setOperator
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", onClick: onFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-apply", children: "Ok" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", variant: "secondary", onClick: onCancel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-cancel", children: "Cancel" }) })
      ] }),
      clearFilterVisible && /* @__PURE__ */ jsxRuntime.jsx(Stack, { children: /* @__PURE__ */ jsxRuntime.jsx(Button, { fill: "text", size: "sm", onClick: onClearFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-clear", children: "Clear filter" }) }) })
    ] })
  ] }) }) });
};
const getStyles$Y = (theme) => ({
  filterContainer: css.css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    maxHeight: "400px",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css.css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  label: css.css({
    marginBottom: 0
  })
});
const stopPropagation$1 = (event) => {
  event.stopPropagation();
};

"use strict";
const Filter$1 = ({ column, field, tableStyles }) => {
  var _a;
  const ref = React.useRef(null);
  const [isPopoverVisible, setPopoverVisible] = React.useState(false);
  const styles = useStyles2(getStyles$X);
  const filterEnabled = React.useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = React.useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = React.useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = React.useState("");
  const [operator, setOperator] = React.useState(REGEX_OPERATOR$1);
  if (!field || !((_a = field.config.custom) == null ? void 0 : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "button",
    {
      className: css.cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsxRuntime.jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsxRuntime.jsx(
              FilterPopup$1,
              {
                column,
                tableStyles,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles$X = (theme) => ({
  filterIconEnabled: css.css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css.css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

"use strict";
const HeaderRow = (props) => {
  const { headerGroups, showTypeIcons, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { role: "rowgroup", className: tableStyles.headerRow, children: headerGroups.map((headerGroup) => {
    const { key, ...headerGroupProps } = headerGroup.getHeaderGroupProps();
    return /* @__PURE__ */ React.createElement(
      "div",
      {
        className: tableStyles.thead,
        ...headerGroupProps,
        key,
        "aria-label": e2eSelectorsTable.header,
        role: "row"
      },
      headerGroup.headers.map(
        (column, index) => renderHeaderCell(column, tableStyles, showTypeIcons)
      )
    );
  }) });
};
function renderHeaderCell(column, tableStyles, showTypeIcons) {
  var _a;
  const { key, ...headerProps } = column.getHeaderProps();
  const field = (_a = column.field) != null ? _a : null;
  const tableFieldOptions = field == null ? void 0 : field.config.custom;
  if (column.canResize) {
    headerProps.style.userSelect = column.isResizing ? "none" : "auto";
  }
  headerProps.style.position = "absolute";
  headerProps.style.justifyContent = column.justifyContent;
  headerProps.style.left = column.totalLeft;
  let headerContent = column.render("Header");
  let sortHeaderContent = column.canSort && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs("button", { ...column.getSortByToggleProps(), className: tableStyles.headerCellLabel, children: [
      showTypeIcons && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm", className: tableStyles.typeIcon }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { children: headerContent }),
      column.isSorted && (column.isSortedDesc ? /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "lg", name: "arrow-down", className: tableStyles.sortIcon }) : /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "arrow-up", size: "lg", className: tableStyles.sortIcon }))
    ] }),
    column.canFilter && /* @__PURE__ */ jsxRuntime.jsx(Filter$1, { column, tableStyles, field })
  ] });
  if (sortHeaderContent && (tableFieldOptions == null ? void 0 : tableFieldOptions.headerComponent)) {
    sortHeaderContent = /* @__PURE__ */ jsxRuntime.jsx(tableFieldOptions.headerComponent, { field, defaultContent: sortHeaderContent });
  } else if (tableFieldOptions == null ? void 0 : tableFieldOptions.headerComponent) {
    headerContent = /* @__PURE__ */ jsxRuntime.jsx(tableFieldOptions.headerComponent, { field, defaultContent: headerContent });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.headerCell, ...headerProps, role: "columnheader", children: [
    column.canSort && sortHeaderContent,
    !column.canSort && headerContent,
    !column.canSort && column.canFilter && /* @__PURE__ */ jsxRuntime.jsx(Filter$1, { column, tableStyles, field }),
    column.canResize && /* @__PURE__ */ jsxRuntime.jsx("div", { ...column.getResizerProps(), className: tableStyles.resizeHandle })
  ] }, key);
}

"use strict";
const TableCell = ({
  cell,
  tableStyles,
  onCellFilterAdded,
  timeRange,
  userProps,
  frame,
  rowStyled,
  rowExpanded,
  textWrapped,
  height,
  getActions,
  replaceVariables,
  setInspectCell
}) => {
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.wordBreak = "break-word";
    cellProps.style.minWidth = cellProps.style.width;
    const justifyContent = cell.column.justifyContent;
    if (justifyContent === "flex-end" && !field.config.unit) {
      cellProps.style.textAlign = "right";
      cellProps.style.direction = "rtl";
      cellProps.style.unicodeBidi = "plaintext";
    } else {
      cellProps.style.justifyContent = justifyContent;
    }
  }
  let innerWidth = (typeof cell.column.width === "number" ? cell.column.width : 24) - tableStyles.cellPadding * 2;
  const actions = getActions ? getActions(frame, field, cell.row.index, replaceVariables) : [];
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    timeRange,
    userProps,
    frame,
    rowStyled,
    rowExpanded,
    textWrapped,
    height,
    actions,
    setInspectCell
  }) });
};

"use strict";
function ExpandedRow({ tableStyles, nestedData, rowIndex, width, cellHeight }) {
  const frames = nestedData.values;
  const subTables = [];
  const theme = useTheme2();
  const styles = useStyles2(getStyles$W);
  let top = tableStyles.rowHeight + theme.spacing.gridSize;
  frames[rowIndex].forEach((nf, nfIndex) => {
    var _a, _b;
    const noHeader = !!((_b = (_a = nf.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
    const height = tableStyles.rowHeight * (nf.length + (noHeader ? 0 : 1));
    const subTable = {
      height,
      paddingLeft: EXPANDER_WIDTH,
      position: "absolute",
      top,
      backgroundColor: theme.colors.background.primary,
      color: theme.colors.text.primary
    };
    top += height + theme.spacing.gridSize;
    subTables.push(
      /* @__PURE__ */ jsxRuntime.jsx("div", { style: subTable, children: /* @__PURE__ */ jsxRuntime.jsx(
        Table,
        {
          data: nf,
          width: width - EXPANDER_WIDTH,
          height: tableStyles.rowHeight * (nf.length + 1),
          noHeader,
          cellHeight
        }
      ) }, `subTable_${rowIndex}_${nfIndex}`)
    );
  });
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.subTables, children: subTables });
}
const getStyles$W = (theme) => {
  return {
    subTables: css.css({
      "&:before": {
        content: '""',
        position: "absolute",
        width: "1px",
        top: theme.spacing(5),
        left: theme.spacing(1),
        bottom: theme.spacing(2),
        background: theme.colors.border.medium
      }
    })
  };
};
function getExpandedRowHeight(nestedData, rowIndex, tableStyles) {
  const frames = nestedData.values;
  const height = frames[rowIndex].reduce((acc, frame) => {
    var _a, _b;
    if (frame.length) {
      const noHeader = !!((_b = (_a = frame.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
      return acc + tableStyles.rowHeight * (frame.length + (noHeader ? 0 : 1)) + 8;
    }
    return acc;
  }, tableStyles.rowHeight);
  return height != null ? height : tableStyles.rowHeight;
}

"use strict";
const RowsList = (props) => {
  const {
    data: data$1,
    rows,
    headerHeight,
    footerPaginationEnabled,
    rowHeight,
    itemCount,
    pageIndex,
    tableState,
    prepareRow,
    onCellFilterAdded,
    width,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    tableStyles,
    nestedDataField,
    listHeight,
    listRef,
    enableSharedCrosshair = false,
    initialRowIndex = void 0,
    headerGroups,
    longestField,
    textWrapField,
    getActions,
    replaceVariables,
    setInspectCell
  } = props;
  const [rowHighlightIndex, setRowHighlightIndex] = React.useState(initialRowIndex);
  if (initialRowIndex === void 0 && rowHighlightIndex !== void 0) {
    setRowHighlightIndex(void 0);
  }
  const theme = useTheme2();
  const panelContext = usePanelContext();
  let osContext = null;
  if (window.OffscreenCanvas !== void 0) {
    osContext = new OffscreenCanvas(256, 1024).getContext("2d");
  }
  if (osContext !== void 0 && osContext !== null) {
    osContext.font = `${theme.typography.fontSize}px ${theme.typography.body.fontFamily}`;
  }
  const threshold = React.useMemo(() => {
    const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
    if (!timeField) {
      return 0;
    }
    return calculateAroundPointThreshold(timeField);
  }, [data$1]);
  const onRowHover = React.useCallback(
    (idx, frame) => {
      if (!panelContext || !enableSharedCrosshair) {
        return;
      }
      const timeField = frame.fields.find((f) => f.type === data.FieldType.time);
      if (!timeField) {
        return;
      }
      panelContext.eventBus.publish(
        new data.DataHoverEvent({
          point: {
            time: timeField.values[idx]
          }
        })
      );
    },
    [enableSharedCrosshair, panelContext]
  );
  const onRowLeave = React.useCallback(() => {
    if (!panelContext || !enableSharedCrosshair) {
      return;
    }
    panelContext.eventBus.publish(new data.DataHoverClearEvent());
  }, [enableSharedCrosshair, panelContext]);
  const onDataHoverEvent = React.useCallback(
    (evt) => {
      var _a;
      if (((_a = evt.payload.point) == null ? void 0 : _a.time) && evt.payload.rowIndex !== void 0) {
        const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
        const time = timeField.values[evt.payload.rowIndex];
        const pointTime = evt.payload.point.time;
        if (isPointTimeValAroundTableTimeVal(pointTime, time, threshold)) {
          setRowHighlightIndex(evt.payload.rowIndex);
          return;
        }
        const matchedRowIndex = timeField.values.findIndex(
          (t) => isPointTimeValAroundTableTimeVal(pointTime, t, threshold)
        );
        if (matchedRowIndex !== -1) {
          setRowHighlightIndex(matchedRowIndex);
          return;
        }
        setRowHighlightIndex(void 0);
      }
    },
    [data$1.fields, threshold]
  );
  React.useEffect(() => {
    if (!panelContext || !enableSharedCrosshair || !data.hasTimeField(data$1) || footerPaginationEnabled) {
      return;
    }
    const subs = new rxjs.Subscription();
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          onDataHoverEvent(evt);
        }
      })
    );
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverClearEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          setRowHighlightIndex(void 0);
        }
      })
    );
    return () => {
      subs.unsubscribe();
    };
  }, [data$1, enableSharedCrosshair, footerPaginationEnabled, onDataHoverEvent, panelContext]);
  let scrollTop = void 0;
  if (rowHighlightIndex !== void 0) {
    const firstMatchedRowIndex = rows.findIndex((row) => row.index === rowHighlightIndex);
    if (firstMatchedRowIndex !== -1) {
      scrollTop = headerHeight + (firstMatchedRowIndex - 1) * rowHeight;
    }
  }
  const rowIndexForPagination = React.useCallback(
    (index) => {
      return tableState.pageIndex * tableState.pageSize + index;
    },
    [tableState.pageIndex, tableState.pageSize]
  );
  let rowBg = void 0;
  let textWrapFinal;
  for (const field of data$1.fields) {
    const fieldOptions = field.config.custom;
    const cellOptionsExist = fieldOptions !== void 0 && fieldOptions.cellOptions !== void 0;
    if (cellOptionsExist && fieldOptions.cellOptions.type === schema.TableCellDisplayMode.ColorBackground && fieldOptions.cellOptions.applyToRow) {
      rowBg = (rowIndex) => {
        const display = field.display(field.values.get(rowIndex));
        const colors = getCellColors$1(tableStyles.theme, fieldOptions.cellOptions, display);
        return colors;
      };
    }
    if (textWrapField !== void 0) {
      textWrapFinal = textWrapField;
    } else if (longestField !== void 0) {
      textWrapFinal = longestField;
    }
  }
  const RenderRow = React.useCallback(
    ({ index, style, rowHighlightIndex: rowHighlightIndex2 }) => {
      const indexForPagination = rowIndexForPagination(index);
      const row = rows[indexForPagination];
      let additionalProps = {};
      prepareRow(row);
      const expandedRowStyle = tableState.expanded[row.id] ? css.css({ "&:hover": { background: "inherit" } }) : {};
      const rowExpanded = nestedDataField && tableState.expanded[row.id];
      if (rowHighlightIndex2 !== void 0 && row.index === rowHighlightIndex2) {
        style = { ...style, backgroundColor: theme.components.table.rowSelected };
        additionalProps = {
          "aria-selected": "true"
        };
      }
      if (rowBg) {
        const { bgColor, textColor } = rowBg(row.index);
        style.background = bgColor;
        style.color = textColor;
        style.borderLeft = `2px solid ${bgColor}`;
      }
      if (textWrapFinal) {
        const visibleFields = data$1.fields.filter((field) => {
          var _a;
          return !Boolean((_a = field.config.custom) == null ? void 0 : _a.hidden);
        });
        const seriesIndex = visibleFields.findIndex((field) => field.name === textWrapFinal.name);
        const pxLineHeight = theme.typography.body.lineHeight * theme.typography.fontSize;
        const bbox = guessTextBoundingBox(
          textWrapFinal.values[row.index],
          headerGroups[0].headers[seriesIndex],
          osContext,
          pxLineHeight,
          tableStyles.rowHeight,
          tableStyles.cellPadding
        );
        style.height = bbox.height;
      }
      const { key, ...rowProps } = row.getRowProps({ style, ...additionalProps });
      return /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          ...rowProps,
          className: css.cx(tableStyles.row, expandedRowStyle),
          onMouseEnter: () => onRowHover(row.index, data$1),
          onMouseLeave: onRowLeave,
          children: [
            rowExpanded && /* @__PURE__ */ jsxRuntime.jsx(
              ExpandedRow,
              {
                nestedData: nestedDataField,
                tableStyles,
                rowIndex: row.index,
                width,
                cellHeight
              }
            ),
            row.cells.map((cell, index2) => /* @__PURE__ */ jsxRuntime.jsx(
              TableCell,
              {
                tableStyles,
                cell,
                onCellFilterAdded,
                columnIndex: index2,
                columnCount: row.cells.length,
                timeRange,
                frame: data$1,
                rowStyled: rowBg !== void 0,
                rowExpanded,
                textWrapped: textWrapFinal !== void 0,
                height: Number(style.height) - 1,
                getActions,
                replaceVariables,
                setInspectCell
              },
              index2
            ))
          ]
        },
        key
      );
    },
    [
      rowIndexForPagination,
      rows,
      prepareRow,
      tableState.expanded,
      nestedDataField,
      rowBg,
      textWrapFinal,
      tableStyles,
      onRowLeave,
      width,
      cellHeight,
      theme.components.table.rowSelected,
      theme.typography.body.lineHeight,
      theme.typography.fontSize,
      data$1,
      headerGroups,
      osContext,
      onRowHover,
      onCellFilterAdded,
      timeRange,
      getActions,
      replaceVariables,
      setInspectCell
    ]
  );
  const getItemSize = (index) => {
    const indexForPagination = rowIndexForPagination(index);
    const row = rows[indexForPagination];
    if (tableState.expanded[row.id] && nestedDataField) {
      return getExpandedRowHeight(nestedDataField, row.index, tableStyles);
    }
    if (textWrapFinal) {
      const visibleFields = data$1.fields.filter((field) => {
        var _a;
        return !Boolean((_a = field.config.custom) == null ? void 0 : _a.hidden);
      });
      const seriesIndex = visibleFields.findIndex((field) => field.name === textWrapFinal.name);
      const pxLineHeight = theme.typography.fontSize * theme.typography.body.lineHeight;
      return guessTextBoundingBox(
        textWrapFinal.values[row.index],
        headerGroups[0].headers[seriesIndex],
        osContext,
        pxLineHeight,
        tableStyles.rowHeight,
        tableStyles.cellPadding
      ).height;
    }
    return tableStyles.rowHeight;
  };
  const handleScroll = (event) => {
    const { scrollTop: scrollTop2 } = event.currentTarget;
    if (listRef.current !== null) {
      listRef.current.scrollTo(scrollTop2);
    }
  };
  const expandedKey = Object.keys(tableState.expanded).join("|");
  React.useEffect(() => {
    if (listRef.current) {
      listRef.current.resetAfterIndex(0);
    }
  }, [rows, listRef]);
  return /* @__PURE__ */ jsxRuntime.jsx(CustomScrollbar, { onScroll: handleScroll, hideHorizontalTrack: true, scrollTop, children: /* @__PURE__ */ jsxRuntime.jsx(
    reactWindow.VariableSizeList,
    {
      height: listHeight,
      itemCount,
      itemSize: getItemSize,
      width: "100%",
      ref: listRef,
      style: { overflow: void 0 },
      children: ({ index, style }) => RenderRow({ index, style, rowHighlightIndex })
    },
    `${rowHeight}${pageIndex}${expandedKey}`
  ) });
};

"use strict";
function useTableStyles(theme, cellHeightOption) {
  const borderColor = theme.colors.border.weak;
  const resizerColor = theme.colors.primary.border;
  const cellPadding = 6;
  const cellHeight = getCellHeight$1(theme, cellHeightOption, cellPadding);
  const rowHeight = cellHeight + 2;
  const headerHeight = 28;
  const buildCellContainerStyle = (color, background, backgroundHover, overflowOnHover, asCellText, textShouldWrap, textWrapped, rowStyled, rowExpanded) => {
    return css.css({
      label: overflowOnHover ? "cellContainerOverflow" : "cellContainerNoOverflow",
      padding: `${cellPadding}px`,
      width: "100%",
      // Cell height need to account for row border
      height: rowExpanded ? "auto !important" : `${rowHeight - 1}px`,
      wordBreak: textWrapped ? "break-all" : "inherit",
      display: "flex",
      ...asCellText ? {
        overflow: "hidden",
        textOverflow: "ellipsis",
        userSelect: "text",
        whiteSpace: "nowrap"
      } : {},
      alignItems: "center",
      borderRight: `1px solid ${borderColor}`,
      color: rowStyled ? "inherit" : color != null ? color : void 0,
      background: rowStyled ? void 0 : background != null ? background : void 0,
      backgroundClip: "padding-box",
      "&:last-child:not(:only-child)": {
        borderRight: "none"
      },
      "&:hover": {
        overflow: overflowOnHover && !textWrapped ? "visible" : void 0,
        width: textShouldWrap || !overflowOnHover ? "auto" : "auto !important",
        height: (textShouldWrap || overflowOnHover) && !textWrapped ? "auto !important" : `${rowHeight - 1}px`,
        minHeight: `${rowHeight - 1}px`,
        wordBreak: textShouldWrap ? "break-word" : void 0,
        whiteSpace: textShouldWrap && overflowOnHover ? "normal" : "nowrap",
        boxShadow: overflowOnHover ? `0 0 2px ${theme.colors.primary.main}` : void 0,
        background: rowStyled ? "inherit" : backgroundHover != null ? backgroundHover : theme.colors.background.primary,
        zIndex: 1,
        ".cellActions": {
          background: theme.components.tooltip.background,
          color: theme.components.tooltip.text,
          visibility: "visible",
          opacity: 1,
          width: "auto",
          borderRadius: theme.shape.radius.default
        }
      },
      a: {
        color: "inherit"
      },
      ".cellActions": {
        display: "flex",
        position: overflowOnHover ? void 0 : "absolute",
        top: overflowOnHover ? void 0 : "1px",
        right: overflowOnHover ? void 0 : 0,
        margin: overflowOnHover ? theme.spacing(0, 0, 0, 1) : "auto",
        visibility: "hidden",
        opacity: 0,
        width: 0,
        alignItems: "center",
        height: "100%",
        padding: theme.spacing(0.5, 0, 0.5, 0.5),
        background: theme.components.tooltip.background,
        color: theme.components.tooltip.text
      },
      ".cellActionsLeft": {
        right: "auto !important",
        left: 0
      }
    });
  };
  return {
    theme,
    cellHeight,
    buildCellContainerStyle,
    cellPadding,
    cellHeightInner: cellHeight - cellPadding * 2,
    rowHeight,
    table: css.css({
      height: "100%",
      width: "100%",
      overflow: "auto",
      display: "flex",
      flexDirection: "column"
    }),
    thead: css.css({
      label: "thead",
      height: `${headerHeight}px`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    tfoot: css.css({
      label: "tfoot",
      height: `${headerHeight}px`,
      borderTop: `1px solid ${borderColor}`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    headerRow: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`
    }),
    headerCell: css.css({
      height: "100%",
      padding: `0 ${cellPadding}px`,
      overflow: "hidden",
      whiteSpace: "nowrap",
      display: "flex",
      alignItems: "center",
      fontWeight: theme.typography.fontWeightMedium,
      "&:last-child": {
        borderRight: "none"
      }
    }),
    headerCellLabel: css.css({
      border: "none",
      padding: 0,
      background: "inherit",
      cursor: "pointer",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      fontWeight: theme.typography.fontWeightMedium,
      display: "flex",
      alignItems: "center",
      marginRight: theme.spacing(0.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellContainerText: buildCellContainerStyle(void 0, void 0, void 0, true, true),
    cellContainerTextNoOverflow: buildCellContainerStyle(void 0, void 0, void 0, false, true),
    cellContainer: buildCellContainerStyle(void 0, void 0, void 0, true, false),
    cellContainerNoOverflow: buildCellContainerStyle(void 0, void 0, void 0, false, false),
    cellText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      cursor: "text"
    }),
    sortIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    cellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      color: theme.colors.text.link,
      fontWeight: theme.typography.fontWeightMedium,
      paddingRight: theme.spacing(1.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellLinkForColoredCell: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      fontWeight: theme.typography.fontWeightMedium,
      textDecoration: "underline"
    }),
    imageCellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      height: "100%"
    }),
    headerFilter: css.css({
      background: "transparent",
      border: "none",
      label: "headerFilter",
      padding: 0
    }),
    paginationWrapper: css.css({
      display: "flex",
      height: `${cellHeight}px`,
      justifyContent: "center",
      alignItems: "center",
      width: "100%",
      li: {
        marginBottom: 0
      }
    }),
    paginationSummary: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      display: "flex",
      justifyContent: "flex-end",
      padding: theme.spacing(0, 1, 0, 2)
    }),
    tableContentWrapper: (totalColumnsWidth) => {
      const width = totalColumnsWidth !== void 0 ? `${totalColumnsWidth}px` : "100%";
      return css.css({
        label: "tableContentWrapper",
        width,
        display: "flex",
        flexDirection: "column"
      });
    },
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`,
      "&:hover": {
        backgroundColor: theme.components.table.rowHoverBackground
      },
      "&:last-child": {
        borderBottom: 0
      }
    }),
    imageCell: css.css({
      height: "100%"
    }),
    resizeHandle: css.css({
      label: "resizeHandle",
      cursor: "col-resize !important",
      display: "inline-block",
      background: resizerColor,
      opacity: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: "opacity 0.2s ease-in-out"
      },
      width: "8px",
      height: "100%",
      position: "absolute",
      right: "-4px",
      borderRadius: theme.shape.radius.default,
      top: 0,
      touchAction: "none",
      "&:hover": {
        opacity: 1
      }
    }),
    typeIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    noData: css.css({
      alignItems: "center",
      display: "flex",
      height: "100%",
      justifyContent: "center",
      width: "100%"
    }),
    expanderCell: css.css({
      display: "flex",
      flexDirection: "column",
      justifyContent: "center",
      height: `${rowHeight}px`,
      cursor: "pointer"
    })
  };
}
function getCellHeight$1(theme, cellHeightOption, cellPadding) {
  const bodyFontSize = theme.typography.fontSize;
  const lineHeight = theme.typography.body.lineHeight;
  switch (cellHeightOption) {
    case "md":
      return 42;
    case "lg":
      return 48;
    case "sm":
    default:
      return cellPadding * 2 + bodyFontSize * lineHeight;
  }
}

"use strict";
const COLUMN_MIN_WIDTH = 150;
const FOOTER_ROW_HEIGHT = 36;
const NO_DATA_TEXT = "No data";
const Table = React.memo((props) => {
  var _a, _b, _c, _d;
  const {
    ariaLabel,
    data: data$1,
    height,
    onCellFilterAdded,
    onColumnResize,
    width,
    columnMinWidth = COLUMN_MIN_WIDTH,
    noHeader,
    resizable = true,
    initialSortBy,
    footerOptions,
    showTypeIcons,
    footerValues,
    enablePagination,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    enableSharedCrosshair = false,
    initialRowIndex = void 0,
    fieldConfig,
    getActions,
    replaceVariables
  } = props;
  const listRef = React.useRef(null);
  const tableDivRef = React.useRef(null);
  const variableSizeListScrollbarRef = React.useRef(null);
  const theme = useTheme2();
  const tableStyles = useTableStyles(theme, cellHeight);
  const headerHeight = noHeader ? 0 : tableStyles.rowHeight;
  const [footerItems, setFooterItems] = React.useState(footerValues);
  const noValuesDisplayText = (_b = (_a = fieldConfig == null ? void 0 : fieldConfig.defaults) == null ? void 0 : _a.noValue) != null ? _b : NO_DATA_TEXT;
  const [inspectCell, setInspectCell] = React.useState(null);
  const footerHeight = React.useMemo(() => {
    const EXTENDED_ROW_HEIGHT = FOOTER_ROW_HEIGHT;
    let length = 0;
    if (!footerItems) {
      return 0;
    }
    for (const fv of footerItems) {
      if (Array.isArray(fv) && fv.length > length) {
        length = fv.length;
      }
    }
    if (length > 1) {
      return EXTENDED_ROW_HEIGHT * length;
    }
    return EXTENDED_ROW_HEIGHT;
  }, [footerItems]);
  const memoizedData = React.useMemo(() => {
    if (!data$1.fields.length) {
      return [];
    }
    return Array(data$1.length).fill(0);
  }, [data$1]);
  const isCountRowsSet = Boolean(
    (footerOptions == null ? void 0 : footerOptions.countRows) && footerOptions.reducer && footerOptions.reducer.length && footerOptions.reducer[0] === data.ReducerID.count
  );
  const nestedDataField = data$1.fields.find((f) => f.type === data.FieldType.nestedFrames);
  const hasNestedData = nestedDataField !== void 0;
  const memoizedColumns = React.useMemo(
    () => getColumns(data$1, width, columnMinWidth, hasNestedData, footerItems, isCountRowsSet),
    [data$1, width, columnMinWidth, hasNestedData, footerItems, isCountRowsSet]
  );
  const toggleAllRowsExpandedRef = React.useRef();
  const stateReducer = useTableStateReducer({
    onColumnResize,
    onSortByChange: (state2) => {
      toggleAllRowsExpandedRef.current(false);
      if (props.onSortByChange) {
        props.onSortByChange(state2);
      }
    },
    data: data$1
  });
  const hasUniqueId = !!((_d = (_c = data$1.meta) == null ? void 0 : _c.uniqueRowIdFields) == null ? void 0 : _d.length);
  const options = React.useMemo(() => {
    const options2 = {
      columns: memoizedColumns,
      data: memoizedData,
      disableResizing: !resizable,
      stateReducer,
      autoResetPage: false,
      initialState: getInitialState(initialSortBy, memoizedColumns),
      autoResetFilters: false,
      sortTypes: {
        // the builtin number type on react-table does not handle NaN values
        number: sortNumber,
        // should be replaced with the builtin string when react-table is upgraded,
        // see https://github.com/tannerlinsley/react-table/pull/3235
        "alphanumeric-insensitive": sortCaseInsensitive
      }
    };
    if (hasUniqueId) {
      options2.getRowId = (row, relativeIndex) => data.getRowUniqueId(data$1, relativeIndex);
      options2.autoResetExpanded = false;
    }
    return options2;
  }, [initialSortBy, memoizedColumns, memoizedData, resizable, stateReducer, hasUniqueId, data$1]);
  const {
    getTableProps,
    headerGroups,
    footerGroups,
    rows,
    prepareRow,
    totalColumnsWidth,
    page,
    state,
    gotoPage,
    setPageSize,
    pageOptions,
    toggleAllRowsExpanded
  } = reactTable.useTable(options, reactTable.useFilters, reactTable.useSortBy, reactTable.useAbsoluteLayout, reactTable.useResizeColumns, reactTable.useExpanded, reactTable.usePagination);
  const extendedState = state;
  toggleAllRowsExpandedRef.current = toggleAllRowsExpanded;
  React.useEffect(() => {
    if (!footerOptions) {
      setFooterItems(footerValues);
    }
  }, [footerValues, footerOptions]);
  React.useEffect(() => {
    var _a2;
    if (!footerOptions) {
      return;
    }
    if (!footerOptions.show) {
      setFooterItems(void 0);
      return;
    }
    if (isCountRowsSet) {
      const footerItemsCountRows = [];
      footerItemsCountRows[0] = (_a2 = rows.length.toString()) != null ? _a2 : data$1.length.toString();
      setFooterItems(footerItemsCountRows);
      return;
    }
    const footerItems2 = getFooterItems(
      headerGroups[0].headers,
      createFooterCalculationValues(rows),
      footerOptions,
      theme
    );
    setFooterItems(footerItems2);
  }, [footerOptions, theme, state.filters, data$1]);
  let listHeight = height - (headerHeight + footerHeight);
  if (enablePagination) {
    listHeight -= tableStyles.cellHeight;
  }
  const pageSize = Math.round(listHeight / tableStyles.rowHeight) - 1;
  React.useEffect(() => {
    if (pageSize <= 0) {
      return;
    }
    setPageSize(pageSize);
  }, [pageSize, setPageSize]);
  React.useEffect(() => {
    if (data$1.length / pageSize < state.pageIndex) {
      gotoPage(0);
    }
  }, [data$1]);
  useResetVariableListSizeCache(extendedState, listRef, data$1, hasUniqueId);
  useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef);
  const onNavigate = React.useCallback(
    (toPage) => {
      gotoPage(toPage - 1);
    },
    [gotoPage]
  );
  const itemCount = enablePagination ? page.length : rows.length;
  let paginationEl = null;
  if (enablePagination) {
    const itemsRangeStart = state.pageIndex * state.pageSize + 1;
    let itemsRangeEnd = itemsRangeStart + state.pageSize - 1;
    const isSmall = width < 550;
    if (itemsRangeEnd > data$1.length) {
      itemsRangeEnd = data$1.length;
    }
    const numRows = rows.length;
    const displayedEnd = itemsRangeEnd < rows.length ? itemsRangeEnd : rows.length;
    paginationEl = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.paginationWrapper, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Pagination,
        {
          currentPage: state.pageIndex + 1,
          numberOfPages: pageOptions.length,
          showSmallVersion: isSmall,
          onNavigate
        }
      ),
      isSmall ? null : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.paginationSummary, children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.table.pagination-summary", children: [
        { itemsRangeStart },
        " - ",
        { displayedEnd },
        " of ",
        { numRows },
        " rows"
      ] }) })
    ] });
  }
  const longestField = fieldConfig ? guessLongestField(fieldConfig, data$1) : void 0;
  let textWrapField = void 0;
  if (fieldConfig !== void 0) {
    data$1.fields.forEach((field) => {
      fieldConfig.overrides.forEach((override) => {
        const matcher = data.getFieldMatcher(override.matcher);
        if (matcher(field, data$1, [data$1])) {
          for (const property of override.properties) {
            if (property.id === "custom.cellOptions" && property.value.wrapText) {
              textWrapField = field;
            }
          }
        }
      });
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        ...getTableProps(),
        className: tableStyles.table,
        "aria-label": ariaLabel,
        role: "table",
        ref: tableDivRef,
        style: { width, height },
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(CustomScrollbar, { hideVerticalTrack: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.tableContentWrapper(totalColumnsWidth), children: [
            !noHeader && /* @__PURE__ */ jsxRuntime.jsx(HeaderRow, { headerGroups, showTypeIcons, tableStyles }),
            itemCount > 0 ? /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                "data-testid": e2eSelectors.selectors.components.Panels.Visualization.Table.body,
                ref: variableSizeListScrollbarRef,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  RowsList,
                  {
                    headerGroups,
                    data: data$1,
                    rows,
                    width,
                    cellHeight,
                    headerHeight,
                    rowHeight: tableStyles.rowHeight,
                    itemCount,
                    pageIndex: state.pageIndex,
                    listHeight,
                    listRef,
                    tableState: state,
                    prepareRow,
                    timeRange,
                    onCellFilterAdded,
                    nestedDataField,
                    tableStyles,
                    footerPaginationEnabled: Boolean(enablePagination),
                    enableSharedCrosshair,
                    initialRowIndex,
                    longestField,
                    textWrapField,
                    getActions,
                    replaceVariables,
                    setInspectCell
                  }
                )
              }
            ) : /* @__PURE__ */ jsxRuntime.jsx("div", { style: { height: height - headerHeight, width }, className: tableStyles.noData, children: noValuesDisplayText }),
            footerItems && /* @__PURE__ */ jsxRuntime.jsx(
              FooterRow,
              {
                isPaginationVisible: Boolean(enablePagination),
                footerValues: footerItems,
                footerGroups,
                totalColumnsWidth,
                tableStyles
              }
            )
          ] }) }),
          paginationEl
        ]
      }
    ),
    inspectCell !== null && /* @__PURE__ */ jsxRuntime.jsx(
      TableCellInspector,
      {
        mode: inspectCell.mode,
        value: inspectCell.value,
        onDismiss: () => {
          setInspectCell(null);
        }
      }
    )
  ] });
});
Table.displayName = "Table";

"use strict";

"use strict";
const TextArea = React.forwardRef(({ invalid, className, ...props }, ref) => {
  const styles = useStyles2(getTextAreaStyle, invalid);
  return /* @__PURE__ */ jsxRuntime.jsx("textarea", { ...props, className: css.cx(styles.textarea, className), ref });
});
const getTextAreaStyle = (theme, invalid = false) => ({
  textarea: css.cx(
    sharedInputStyle(theme),
    getFocusStyle(theme),
    css.css({
      display: "block",
      borderRadius: theme.shape.radius.default,
      padding: `${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px`,
      width: "100%",
      borderColor: invalid ? theme.colors.error.border : theme.components.input.borderColor
    })
  )
});
TextArea.displayName = "TextArea";

"use strict";
class UnThemedTableInputCSV extends React.PureComponent {
  constructor(props) {
    super(props);
    this.readCSV = lodash.debounce(() => {
      const { config } = this.props;
      const { text } = this.state;
      this.setState({ data: data.readCSV(text, { config }) });
    }, 150);
    this.onTextChange = (event) => {
      this.setState({ text: event.target.value });
    };
    const { text, config } = props;
    this.state = {
      text,
      data: data.readCSV(text, { config })
    };
  }
  componentDidUpdate(prevProps, prevState) {
    const { text } = this.state;
    if (text !== prevState.text || this.props.config !== prevProps.config) {
      this.readCSV();
    }
    if (this.props.text !== prevProps.text && this.props.text !== text) {
      this.setState({ text: this.props.text });
    }
    if (this.state.data !== prevState.data) {
      this.props.onSeriesParsed(this.state.data, this.state.text);
    }
  }
  render() {
    const { width, height, theme } = this.props;
    const { data } = this.state;
    const styles = getStyles$V(theme);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.tableInputCsv, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        TextArea,
        {
          style: { width, height },
          placeholder: t("grafana-ui.table.csv-placeholder", "Enter CSV here..."),
          value: this.state.text,
          onChange: this.onTextChange,
          className: styles.textarea
        }
      ),
      data && /* @__PURE__ */ jsxRuntime.jsx("footer", { className: styles.footer, children: data.map((frame, index) => {
        const rows = frame.length;
        const columns = frame.fields.length;
        return /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.table.csv-counts", children: [
          "Rows:",
          { rows },
          ", Columns:",
          { columns },
          " \xA0",
          /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check-circle" })
        ] }) }, index);
      }) })
    ] });
  }
}
const TableInputCSV = withTheme2(UnThemedTableInputCSV);
TableInputCSV.displayName = "TableInputCSV";
const getStyles$V = stylesFactory((theme) => {
  return {
    tableInputCsv: css.css({
      position: "relative"
    }),
    textarea: css.css({
      height: "100%",
      width: "100%"
    }),
    footer: css.css({
      position: "absolute",
      bottom: "15px",
      right: "15px",
      border: "1px solid #222",
      background: theme.colors.success.main,
      padding: `1px ${theme.spacing(0.5)}`,
      fontSize: "80%"
    })
  };
});

"use strict";
const VerticalTab = React.forwardRef(
  ({ label, active, icon, counter, className, suffix: Suffix, onChangeTab, href, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getTabStyles);
    const content = () => /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsxRuntime.jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsxRuntime.jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = css.cx(tabsStyles.link, active && tabsStyles.activeStyle);
    return /* @__PURE__ */ jsxRuntime.jsx(
      "a",
      {
        href,
        className: linkClass,
        ...otherProps,
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref,
        children: content()
      }
    );
  }
);
VerticalTab.displayName = "Tab";
const getTabStyles = (theme) => {
  return {
    link: css.css({
      padding: "6px 12px",
      display: "block",
      height: "100%",
      cursor: "pointer",
      position: "relative",
      color: theme.colors.text.primary,
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:hover, &:focus": {
        textDecoration: "underline"
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.maxContrast,
      overflow: "hidden",
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        width: "4px",
        bottom: "2px",
        top: "2px",
        borderRadius: theme.shape.radius.default,
        backgroundImage: "linear-gradient(0deg, #f05a28 30%, #fbca0a 99%)"
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

"use strict";
function RenderUserContentAsHTML({
  component,
  content,
  ...rest
}) {
  return React__namespace.createElement(component || "span", {
    dangerouslySetInnerHTML: { __html: data.textUtil.sanitize(content) },
    ...rest
  });
}

"use strict";
const PercentChange = ({ percentChange, styles }) => {
  let percentChangeIcon = void 0;
  if (percentChange > 0) {
    percentChangeIcon = "arrow-up";
  } else if (percentChange < 0) {
    percentChangeIcon = "arrow-down";
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.containerStyles, children: [
    percentChangeIcon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: percentChangeIcon, height: styles.iconSize, width: styles.iconSize, viewBox: "6 6 12 12" }),
    percentChangeString(percentChange)
  ] });
};
const percentChangeString = (percentChange) => {
  return (percentChange / 100).toLocaleString(void 0, { style: "percent", maximumSignificantDigits: 3 });
};

"use strict";
const LINE_HEIGHT = 1.2;
const MAX_TITLE_SIZE = 30;
const VALUE_FONT_WEIGHT = 500;
class BigValueLayout {
  constructor(props) {
    this.props = props;
    var _a;
    const { width, height, value, text } = props;
    this.valueColor = (_a = value.color) != null ? _a : "gray";
    this.panelPadding = height > 100 ? 12 : 8;
    this.textValues = getTextValues(props);
    this.justifyCenter = shouldJustifyCenter(props.justifyMode, this.textValues.title);
    this.valueToAlignTo = this.textValues.valueToAlignTo;
    this.titleToAlignTo = this.textValues.titleToAlignTo;
    this.titleFontSize = 0;
    this.valueFontSize = 0;
    this.percentFontSize = 0;
    this.chartHeight = 0;
    this.chartWidth = 0;
    this.maxTextWidth = width - this.panelPadding * 2;
    this.maxTextHeight = height - this.panelPadding * 2;
    if (text) {
      if (text.titleSize) {
        this.titleFontSize = text.titleSize;
        this.titleToAlignTo = void 0;
      }
      if (text.valueSize) {
        this.valueFontSize = text.valueSize;
        this.valueToAlignTo = "";
      }
      if (text.percentSize) {
        this.percentFontSize = text.percentSize;
      }
    }
  }
  getTitleStyles() {
    const styles = {
      fontSize: `${this.titleFontSize}px`,
      lineHeight: LINE_HEIGHT
    };
    if (this.props.colorMode === BigValueColorMode.Background || this.props.colorMode === BigValueColorMode.BackgroundSolid) {
      styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
    }
    return styles;
  }
  getValueStyles() {
    const styles = {
      fontSize: this.valueFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      zIndex: 1
    };
    if (this.justifyCenter) {
      styles.textAlign = "center";
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Value:
        styles.color = this.valueColor;
        break;
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
      case BigValueColorMode.None:
        styles.color = this.props.theme.colors.text.primary;
        break;
    }
    return styles;
  }
  getPercentChangeStyles(percentChange, percentChangeColorMode, valueStyles) {
    const VALUE_TO_PERCENT_CHANGE_RATIO = 2.5;
    const valueContainerStyles = this.getValueAndTitleContainerStyles();
    const percentFontSize = this.percentFontSize || Math.max(this.valueFontSize / VALUE_TO_PERCENT_CHANGE_RATIO, 12);
    let iconSize = this.percentFontSize ? this.percentFontSize - 3 : Math.max(this.valueFontSize / 3, 10);
    const themeVisualizationColors = this.props.theme.visualization;
    const color = getPercentChangeColor(percentChange, percentChangeColorMode, valueStyles, themeVisualizationColors);
    const containerStyles = {
      fontSize: percentFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      display: "flex",
      alignItems: "center",
      gap: Math.max(percentFontSize / 3, 4),
      zIndex: 1,
      color
    };
    if (this.justifyCenter) {
      containerStyles.textAlign = "center";
    }
    if (valueContainerStyles.flexDirection === "column" && percentFontSize > 12) {
      containerStyles.marginTop = -(percentFontSize / 4);
    }
    if (valueContainerStyles.flexDirection === "row") {
      containerStyles.alignItems = "baseline";
      containerStyles.lineHeight = LINE_HEIGHT * VALUE_TO_PERCENT_CHANGE_RATIO;
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        containerStyles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
    }
    if (this.props.textMode === BigValueTextMode.None) {
      containerStyles.fontSize = calculateFontSize(
        percentChangeString(percentChange),
        this.maxTextWidth * 0.8,
        this.maxTextHeight * 0.8,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
      iconSize = containerStyles.fontSize * 0.8;
    }
    return {
      containerStyles,
      iconSize
    };
  }
  getValueAndTitleContainerStyles() {
    const styles = {
      display: "flex",
      flexWrap: "wrap"
    };
    if (this.justifyCenter) {
      styles.alignItems = "center";
      styles.justifyContent = "center";
      styles.flexGrow = 1;
      styles.gap = "0.75ch";
    }
    return styles;
  }
  getPanelStyles() {
    const { width, height, theme, colorMode, textMode } = this.props;
    const panelStyles = {
      width: `${width}px`,
      height: `${height}px`,
      padding: `${textMode === BigValueTextMode.None ? 2 : this.panelPadding}px`,
      borderRadius: theme.shape.radius.default,
      position: "relative",
      display: "flex"
    };
    const themeFactor = theme.isDark ? 1 : -0.7;
    switch (colorMode) {
      case BigValueColorMode.Background:
        const bgColor2 = tinycolor__default.default(this.valueColor).darken(15 * themeFactor).spin(8).toRgbString();
        const bgColor3 = tinycolor__default.default(this.valueColor).darken(5 * themeFactor).spin(-8).toRgbString();
        panelStyles.background = `linear-gradient(120deg, ${bgColor2}, ${bgColor3})`;
        break;
      case BigValueColorMode.BackgroundSolid:
        panelStyles.background = tinycolor__default.default(this.valueColor).toString();
        break;
      case BigValueColorMode.Value:
        panelStyles.background = `transparent`;
        break;
    }
    if (this.justifyCenter) {
      panelStyles.alignItems = "center";
      panelStyles.flexDirection = "row";
    }
    return panelStyles;
  }
  renderChart() {
    var _a;
    const { sparkline, colorMode } = this.props;
    if (!sparkline || ((_a = sparkline.y) == null ? void 0 : _a.type) !== data.FieldType.number) {
      return null;
    }
    let fillColor;
    let lineColor;
    switch (colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        fillColor = "rgba(255,255,255,0.4)";
        lineColor = tinycolor__default.default(this.valueColor).brighten(40).toRgbString();
        break;
      case BigValueColorMode.None:
      case BigValueColorMode.Value:
      default:
        lineColor = this.valueColor;
        fillColor = tinycolor__default.default(this.valueColor).setAlpha(0.2).toRgbString();
        break;
    }
    const config = {
      custom: {
        drawStyle: schema.GraphDrawStyle.Line,
        lineWidth: 1,
        fillColor,
        lineColor
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: this.getChartStyles(), children: /* @__PURE__ */ jsxRuntime.jsx(
      Sparkline,
      {
        height: this.chartHeight,
        width: this.chartWidth,
        sparkline,
        config,
        theme: this.props.theme
      }
    ) });
  }
  getChartStyles() {
    return {
      position: "absolute",
      right: 0,
      bottom: 0
    };
  }
}
class WideNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const valueWidthPercent = ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) ? 0.3 : 1;
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * 0.6,
        this.maxTextHeight,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.alignItems = "center";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const panelStyles = super.getPanelStyles();
    panelStyles.alignItems = "center";
    return panelStyles;
  }
}
class WideWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a;
    super(props);
    const { width, height } = props;
    const chartHeightPercent = 0.5;
    const titleWidthPercent = 0.6;
    const valueWidthPercent = 1 - titleWidthPercent;
    const textHeightPercent = 0.4;
    this.chartWidth = width;
    this.chartHeight = height * chartHeightPercent;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * titleWidthPercent,
        this.maxTextHeight * textHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight * chartHeightPercent,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "row";
    styles.justifyContent = "space-between";
    return styles;
  }
}
class StackedWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { width, height } = props;
    const titleHeightPercent = 0.15;
    const chartHeightPercent = 0.25;
    let titleHeight = 0;
    this.chartHeight = height * chartHeightPercent;
    this.chartWidth = width;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - this.chartHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
    this.chartHeight = height - this.titleFontSize * LINE_HEIGHT - this.valueFontSize * LINE_HEIGHT;
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.justifyContent = "center";
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "column";
    return styles;
  }
}
class StackedWithNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { height } = props;
    const titleHeightPercent = 0.15;
    let titleHeight = 0;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.flexGrow = 1;
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.alignItems = "center";
    return styles;
  }
}
function buildLayout(props) {
  const { width, height, sparkline } = props;
  const useWideLayout = width / height > 2.5 && !props.disableWideLayout;
  if (useWideLayout) {
    if (height > 50 && !!sparkline && sparkline.y.values.length > 1) {
      return new WideWithChartLayout(props);
    } else {
      return new WideNoChartLayout(props);
    }
  }
  if (height > 100 && sparkline && sparkline.y.values.length > 1) {
    return new StackedWithChartLayout(props);
  } else {
    return new StackedWithNoChartLayout(props);
  }
}
function shouldJustifyCenter(justifyMode, title) {
  if (justifyMode === BigValueJustifyMode.Center) {
    return true;
  }
  return (title != null ? title : "").length === 0;
}
function getTextValues(props) {
  const { value, alignmentFactors, count } = props;
  let { textMode } = props;
  const titleToAlignTo = alignmentFactors ? alignmentFactors.title : value.title;
  const valueToAlignTo = data.formattedValueToString(alignmentFactors ? alignmentFactors : value);
  if (textMode === BigValueTextMode.Auto && (count != null ? count : 1) === 1) {
    textMode = BigValueTextMode.Value;
  }
  switch (textMode) {
    case BigValueTextMode.Name:
      return {
        ...value,
        title: void 0,
        prefix: void 0,
        suffix: void 0,
        text: value.title || "",
        titleToAlignTo: void 0,
        valueToAlignTo: titleToAlignTo != null ? titleToAlignTo : "",
        tooltip: data.formattedValueToString(value)
      };
    case BigValueTextMode.Value:
      return {
        ...value,
        title: void 0,
        titleToAlignTo: void 0,
        valueToAlignTo,
        tooltip: value.title
      };
    case BigValueTextMode.None:
      return {
        numeric: value.numeric,
        color: value.color,
        title: void 0,
        text: "",
        titleToAlignTo: void 0,
        valueToAlignTo: "1",
        tooltip: `Name: ${value.title}
Value: ${data.formattedValueToString(value)}`
      };
    case BigValueTextMode.ValueAndName:
    default:
      return {
        ...value,
        titleToAlignTo,
        valueToAlignTo
      };
  }
}
function getPercentChangeColor(percentChange, percentChangeColorMode, valueStyles, themeVisualizationColors) {
  if (percentChangeColorMode === schema.PercentChangeColorMode.SameAsValue) {
    return valueStyles.color;
  } else {
    return percentChange * (percentChangeColorMode === schema.PercentChangeColorMode.Inverted ? -1 : 1) > 0 ? themeVisualizationColors.getColorByName("green") : themeVisualizationColors.getColorByName("red");
  }
}

"use strict";
var BigValueColorMode = /* @__PURE__ */ ((BigValueColorMode2) => {
  BigValueColorMode2["Background"] = "background";
  BigValueColorMode2["BackgroundSolid"] = "background_solid";
  BigValueColorMode2["None"] = "none";
  BigValueColorMode2["Value"] = "value";
  return BigValueColorMode2;
})(BigValueColorMode || {});
var BigValueGraphMode = /* @__PURE__ */ ((BigValueGraphMode2) => {
  BigValueGraphMode2["None"] = "none";
  BigValueGraphMode2["Line"] = "line";
  BigValueGraphMode2["Area"] = "area";
  return BigValueGraphMode2;
})(BigValueGraphMode || {});
var BigValueJustifyMode = /* @__PURE__ */ ((BigValueJustifyMode2) => {
  BigValueJustifyMode2["Auto"] = "auto";
  BigValueJustifyMode2["Center"] = "center";
  return BigValueJustifyMode2;
})(BigValueJustifyMode || {});
var BigValueTextMode = /* @__PURE__ */ ((BigValueTextMode2) => {
  BigValueTextMode2["Auto"] = "auto";
  BigValueTextMode2["Value"] = "value";
  BigValueTextMode2["ValueAndName"] = "value_and_name";
  BigValueTextMode2["Name"] = "name";
  BigValueTextMode2["None"] = "none";
  return BigValueTextMode2;
})(BigValueTextMode || {});
class BigValue extends React.PureComponent {
  render() {
    const { onClick, className, hasLinks, theme } = this.props;
    const layout = buildLayout(this.props);
    const panelStyles = layout.getPanelStyles();
    const valueAndTitleContainerStyles = layout.getValueAndTitleContainerStyles();
    const valueStyles = layout.getValueStyles();
    const titleStyles = layout.getTitleStyles();
    const textValues = layout.textValues;
    const percentChange = this.props.value.percentChange;
    const percentChangeColorMode = this.props.percentChangeColorMode;
    const showPercentChange = percentChange != null && !Number.isNaN(percentChange);
    const tooltip = hasLinks ? void 0 : textValues.tooltip;
    if (!onClick) {
      return /* @__PURE__ */ jsxRuntime.jsxs("div", { className, style: panelStyles, title: tooltip, children: [
        /* @__PURE__ */ jsxRuntime.jsxs("div", { style: valueAndTitleContainerStyles, children: [
          textValues.title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: titleStyles, children: textValues.title }),
          /* @__PURE__ */ jsxRuntime.jsx(FormattedValueDisplay, { value: textValues, style: valueStyles }),
          showPercentChange && /* @__PURE__ */ jsxRuntime.jsx(
            PercentChange,
            {
              percentChange,
              styles: layout.getPercentChangeStyles(percentChange, percentChangeColorMode, valueStyles)
            }
          )
        ] }),
        layout.renderChart()
      ] });
    }
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        type: "button",
        className: css.cx(clearButtonStyles(theme), className),
        style: panelStyles,
        onClick,
        title: tooltip,
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs("div", { style: valueAndTitleContainerStyles, children: [
            textValues.title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: titleStyles, children: textValues.title }),
            /* @__PURE__ */ jsxRuntime.jsx(FormattedValueDisplay, { value: textValues, style: valueStyles })
          ] }),
          layout.renderChart()
        ]
      }
    );
  }
}
BigValue.defaultProps = {
  justifyMode: "auto" /* Auto */
};

"use strict";
const DEFAULT_THRESHOLDS = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    { value: -Infinity, color: "green" },
    { value: 80, color: "red" }
  ]
};
function calculateGaugeAutoProps(width, height, title, orientation) {
  const showLabel = title !== null && title !== void 0;
  const titleFontSizeDimension = orientation === schema.VizOrientation.Vertical ? height : width;
  const titleFontSize = Math.min(titleFontSizeDimension * 0.15 / 1.5, 20);
  const titleHeight = titleFontSize * 1.5;
  const availableHeight = showLabel ? height - titleHeight : height;
  const gaugeHeight = Math.min(availableHeight, width);
  return {
    showLabel,
    gaugeHeight,
    titleFontSize
  };
}
function getFormattedThresholds(decimals, field, value, theme) {
  var _a, _b, _c, _d, _e, _f;
  if (((_a = field.color) == null ? void 0 : _a.mode) !== data.FieldColorModeId.Thresholds) {
    return [{ value: (_b = field.min) != null ? _b : data.GAUGE_DEFAULT_MINIMUM, color: (_c = value.color) != null ? _c : data.FALLBACK_COLOR }];
  }
  const thresholds = (_d = field.thresholds) != null ? _d : DEFAULT_THRESHOLDS;
  const isPercent = thresholds.mode === data.ThresholdsMode.Percentage;
  const steps = thresholds.steps;
  let min = (_e = field.min) != null ? _e : data.GAUGE_DEFAULT_MINIMUM;
  let max = (_f = field.max) != null ? _f : data.GAUGE_DEFAULT_MAXIMUM;
  if (isPercent) {
    min = 0;
    max = 100;
  }
  const first = data.getActiveThreshold(min, steps);
  const last = data.getActiveThreshold(max, steps);
  const formatted = [
    { value: +min.toFixed(decimals), color: theme.visualization.getColorByName(first.color) }
  ];
  let skip = true;
  for (let i = 0; i < steps.length; i++) {
    const step = steps[i];
    if (skip) {
      if (first === step) {
        skip = false;
      }
      continue;
    }
    const prev = steps[i - 1];
    formatted.push({ value: step.value, color: theme.visualization.getColorByName(prev.color) });
    if (step === last) {
      break;
    }
  }
  formatted.push({ value: +max.toFixed(decimals), color: theme.visualization.getColorByName(last.color) });
  return formatted;
}

"use strict";
class Gauge extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.canvasElement = null;
    this.renderVisualization = () => {
      var _a;
      const { width, value, height, onClick, text, theme, orientation } = this.props;
      const autoProps = calculateGaugeAutoProps(width, height, value.title, orientation);
      const gaugeWidth = orientation === schema.VizOrientation.Vertical ? `${autoProps.gaugeHeight}px` : "100%";
      const gaugeElement = /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          style: { height: `${autoProps.gaugeHeight}px`, width: gaugeWidth },
          ref: (element) => this.canvasElement = element
        }
      );
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        onClick ? /* @__PURE__ */ jsxRuntime.jsx("button", { className: clearButtonStyles(theme), type: "button", onClick, children: gaugeElement }) : gaugeElement,
        autoProps.showLabel && /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            style: {
              textAlign: "center",
              fontSize: (_a = text == null ? void 0 : text.titleSize) != null ? _a : autoProps.titleFontSize,
              overflow: "hidden",
              textOverflow: "ellipsis",
              whiteSpace: "nowrap",
              position: "relative",
              width: gaugeWidth,
              top: "-4px",
              cursor: "default"
            },
            children: value.title
          }
        )
      ] });
    };
  }
  componentDidMount() {
    this.draw();
  }
  componentDidUpdate() {
    this.draw();
  }
  draw() {
    var _a, _b, _c, _d, _e, _f;
    const { field, showThresholdLabels, showThresholdMarkers, width, height, theme, value, orientation } = this.props;
    const autoProps = calculateGaugeAutoProps(width, height, value.title);
    const calculatedGaugeWidth = orientation === schema.VizOrientation.Vertical ? autoProps.gaugeHeight : width;
    const dimension = Math.min(calculatedGaugeWidth, autoProps.gaugeHeight);
    const backgroundColor = theme.colors.background.secondary;
    const gaugeWidthReduceRatio = showThresholdLabels ? 1.5 : 1;
    const gaugeWidth = Math.min(dimension / 5.5, 40) / gaugeWidthReduceRatio;
    const thresholdMarkersWidth = gaugeWidth / 5;
    const text = data.formattedValueToString(value);
    const valueWidthBase = Math.min(calculatedGaugeWidth, dimension * 1.3) * 0.9;
    const valueWidth = valueWidthBase - ((gaugeWidth + (showThresholdMarkers ? thresholdMarkersWidth : 0) + (showThresholdLabels ? 10 : 0)) * 2 + 10);
    const fontSize = (_b = (_a = this.props.text) == null ? void 0 : _a.valueSize) != null ? _b : calculateFontSize(text, valueWidth, dimension, 1, gaugeWidth * 1.7);
    const thresholdLabelFontSize = Math.max(fontSize / 2.5, 12);
    let min = (_c = field.min) != null ? _c : data.GAUGE_DEFAULT_MINIMUM;
    let max = (_d = field.max) != null ? _d : data.GAUGE_DEFAULT_MAXIMUM;
    let numeric = value.numeric;
    if (((_e = field.thresholds) == null ? void 0 : _e.mode) === data.ThresholdsMode.Percentage) {
      min = 0;
      max = 100;
      if (value.percent === void 0) {
        numeric = (numeric - min) / (max - min) * 100;
      } else {
        numeric = value.percent * 100;
      }
    }
    const decimals = field.decimals === void 0 ? 2 : field.decimals;
    if (showThresholdMarkers) {
      min = +min.toFixed(decimals);
      max = +max.toFixed(decimals);
    }
    const options = {
      series: {
        gauges: {
          gauge: {
            min,
            max,
            neutralValue: (_f = field.custom) == null ? void 0 : _f.neutral,
            background: { color: backgroundColor },
            border: { color: null },
            shadow: { show: false },
            width: gaugeWidth
          },
          frame: { show: false },
          label: { show: false },
          layout: { margin: 0, thresholdWidth: 0, vMargin: 0 },
          cell: { border: { width: 0 } },
          threshold: {
            values: getFormattedThresholds(decimals, field, value, theme),
            label: {
              show: showThresholdLabels,
              margin: thresholdMarkersWidth + 1,
              font: { size: thresholdLabelFontSize }
            },
            show: showThresholdMarkers,
            width: thresholdMarkersWidth
          },
          value: {
            color: value.color,
            formatter: () => {
              return text;
            },
            font: { size: fontSize, family: theme.typography.fontFamily }
          },
          show: true
        }
      }
    };
    const plotSeries = {
      data: [[0, numeric]],
      label: value.title
    };
    try {
      if (this.canvasElement) {
        $__default.default.plot(this.canvasElement, [plotSeries], options);
      }
    } catch (err) {
      console.error("Gauge rendering error", err, options, value);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        style: {
          width: "100%",
          height: "100%",
          display: "flex",
          flexDirection: "column",
          justifyContent: "center",
          overflow: "hidden"
        },
        className: this.props.className,
        children: this.renderVisualization()
      }
    );
  }
}
Gauge.defaultProps = {
  showThresholdMarkers: true,
  showThresholdLabels: false,
  field: {
    min: 0,
    max: 100,
    thresholds: DEFAULT_THRESHOLDS
  }
};

"use strict";
var ColorIndicator = /* @__PURE__ */ ((ColorIndicator2) => {
  ColorIndicator2["series"] = "series";
  ColorIndicator2["value"] = "value";
  ColorIndicator2["hexagon"] = "hexagon";
  ColorIndicator2["pie_1_4"] = "pie_1_4";
  ColorIndicator2["pie_2_4"] = "pie_2_4";
  ColorIndicator2["pie_3_4"] = "pie_3_4";
  ColorIndicator2["marker_sm"] = "marker_sm";
  ColorIndicator2["marker_md"] = "marker_md";
  ColorIndicator2["marker_lg"] = "marker_lg";
  return ColorIndicator2;
})(ColorIndicator || {});
var ColorPlacement = /* @__PURE__ */ ((ColorPlacement2) => {
  ColorPlacement2["hidden"] = "hidden";
  ColorPlacement2["first"] = "first";
  ColorPlacement2["leading"] = "leading";
  ColorPlacement2["trailing"] = "trailing";
  return ColorPlacement2;
})(ColorPlacement || {});
const DEFAULT_COLOR_INDICATOR = "series" /* series */;

"use strict";
const calculateTooltipPosition = (xPos = 0, yPos = 0, tooltipWidth = 0, tooltipHeight = 0, xOffset = 0, yOffset = 0, windowWidth = 0, windowHeight = 0) => {
  let x = xPos;
  let y = yPos;
  const overflowRight = Math.max(xPos + xOffset + tooltipWidth - (windowWidth - xOffset), 0);
  const overflowLeft = Math.abs(Math.min(xPos - xOffset - tooltipWidth - xOffset, 0));
  const wouldOverflowRight = overflowRight > 0;
  const wouldOverflowLeft = overflowLeft > 0;
  const overflowBelow = Math.max(yPos + yOffset + tooltipHeight - (windowHeight - yOffset), 0);
  const overflowAbove = Math.abs(Math.min(yPos - yOffset - tooltipHeight - yOffset, 0));
  const wouldOverflowBelow = overflowBelow > 0;
  const wouldOverflowAbove = overflowAbove > 0;
  if (wouldOverflowRight && wouldOverflowLeft) {
    x = overflowRight > overflowLeft ? xOffset : windowWidth - xOffset - tooltipWidth;
  } else if (wouldOverflowRight) {
    x = xPos - xOffset - tooltipWidth;
  } else {
    x = xPos + xOffset;
  }
  if (wouldOverflowBelow && wouldOverflowAbove) {
    y = overflowBelow > overflowAbove ? yOffset : windowHeight - yOffset - tooltipHeight;
  } else if (wouldOverflowBelow) {
    y = yPos - yOffset - tooltipHeight;
  } else {
    y = yPos + yOffset;
  }
  return { x, y };
};
const getColorIndicatorClass = (colorIndicator, styles) => {
  switch (colorIndicator) {
    case ColorIndicator.value:
      return styles.value;
    case ColorIndicator.hexagon:
      return styles.hexagon;
    case ColorIndicator.pie_1_4:
      return styles.pie_1_4;
    case ColorIndicator.pie_2_4:
      return styles.pie_2_4;
    case ColorIndicator.pie_3_4:
      return styles.pie_3_4;
    case ColorIndicator.marker_sm:
      return styles.marker_sm;
    case ColorIndicator.marker_md:
      return styles.marker_md;
    case ColorIndicator.marker_lg:
      return styles.marker_lg;
    default:
      return styles.value;
  }
};
const numberCmp = (a, b) => a.numeric - b.numeric;
const collator = new Intl.Collator(void 0, { numeric: true, sensitivity: "base" });
const stringCmp = (a, b) => collator.compare(`${a.value}`, `${b.value}`);
const getContentItems = (fields, xField, dataIdxs, seriesIdx, mode, sortOrder, fieldFilter = (field) => true, hideZeros = false) => {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  let rows = [];
  let allNumeric = true;
  for (let i = 0; i < fields.length; i++) {
    const field = fields[i];
    if (field === xField || field.type === data.FieldType.time || !fieldFilter(field) || ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.tooltip) || ((_d = (_c = field.config.custom) == null ? void 0 : _c.hideFrom) == null ? void 0 : _d.viz)) {
      continue;
    }
    if (mode === schema.TooltipDisplayMode.Single && seriesIdx !== i) {
      continue;
    }
    let dataIdx = dataIdxs[i];
    if (dataIdx == null) {
      continue;
    }
    if (!(field.type === data.FieldType.number || field.type === data.FieldType.boolean || field.type === data.FieldType.enum)) {
      allNumeric = false;
    }
    const v = fields[i].values[dataIdx];
    if (v == null && field.config.noValue == null || hideZeros && v === 0) {
      continue;
    }
    const display = field.display(v);
    const numeric = !Number.isNaN(display.numeric) ? display.numeric : sortOrder === schema.SortOrder.Descending ? Number.MIN_SAFE_INTEGER : Number.MAX_SAFE_INTEGER;
    const colorMode = data.getFieldColorModeForField(field);
    let colorIndicator = ColorIndicator.series;
    let colorPlacement = ColorPlacement.first;
    if (colorMode.isByValue) {
      colorIndicator = ColorIndicator.value;
      colorPlacement = ColorPlacement.trailing;
    }
    rows.push({
      label: (_f = (_e = field.state) == null ? void 0 : _e.displayName) != null ? _f : field.name,
      value: data.formattedValueToString(display),
      color: (_g = display.color) != null ? _g : data.FALLBACK_COLOR,
      colorIndicator,
      colorPlacement,
      isActive: mode === schema.TooltipDisplayMode.Multi && seriesIdx === i,
      numeric,
      lineStyle: (_h = field.config.custom) == null ? void 0 : _h.lineStyle
    });
  }
  if (sortOrder !== schema.SortOrder.None && rows.length > 1) {
    const cmp = allNumeric ? numberCmp : stringCmp;
    const mult = sortOrder === schema.SortOrder.Descending ? -1 : 1;
    rows.sort((a, b) => mult * cmp(a, b));
  }
  return rows;
};

"use strict";
const VizTooltipContainer = ({
  position: { x: positionX, y: positionY },
  offset: { x: offsetX, y: offsetY },
  children,
  allowPointerEvents = false,
  className,
  ...otherProps
}) => {
  const tooltipRef = React.useRef(null);
  const [tooltipMeasurement, setTooltipMeasurement] = React.useState({ width: 0, height: 0 });
  const { width, height } = reactUse.useWindowSize();
  const [placement, setPlacement] = React.useState({
    x: positionX + offsetX,
    y: positionY + offsetY
  });
  const resizeObserver = React.useMemo(
    () => (
      // TS has hard time playing games with @types/resize-observer-browser, hence the ignore
      // @ts-ignore
      new ResizeObserver((entries) => {
        for (let entry of entries) {
          const tW = Math.floor(entry.contentRect.width + 2 * 8);
          const tH = Math.floor(entry.contentRect.height + 2 * 8);
          if (tooltipMeasurement.width !== tW || tooltipMeasurement.height !== tH) {
            setTooltipMeasurement({
              width: Math.min(tW, width),
              height: Math.min(tH, height)
            });
          }
        }
      })
    ),
    [tooltipMeasurement, width, height]
  );
  React.useLayoutEffect(() => {
    if (tooltipRef.current) {
      resizeObserver.observe(tooltipRef.current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [resizeObserver]);
  React.useLayoutEffect(() => {
    if (tooltipRef && tooltipRef.current) {
      const { x, y } = calculateTooltipPosition(
        positionX,
        positionY,
        tooltipMeasurement.width,
        tooltipMeasurement.height,
        offsetX,
        offsetY,
        width,
        height
      );
      setPlacement({ x, y });
    }
  }, [width, height, positionX, offsetX, positionY, offsetY, tooltipMeasurement]);
  const styles = useStyles2(getStyles$U);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref: tooltipRef,
      style: {
        position: "fixed",
        left: 0,
        // disabling pointer-events is to prevent the tooltip from flickering when moving left to right
        // see e.g. https://github.com/grafana/grafana/pull/33609
        pointerEvents: allowPointerEvents ? "auto" : "none",
        top: 0,
        transform: `translate(${placement.x}px, ${placement.y}px)`,
        transition: "transform ease-out 0.1s"
      },
      "aria-live": "polite",
      "aria-atomic": "true",
      ...otherProps,
      className: css.cx(styles.wrapper, className),
      children
    }
  );
};
VizTooltipContainer.displayName = "VizTooltipContainer";
const getStyles$U = (theme) => ({
  wrapper: css.css(getTooltipContainerStyles(theme))
});

"use strict";
const VizTooltip = ({ content, position, offset }) => {
  const styles = useStyles2(getStyles$T);
  if (position) {
    return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { className: styles.portal, children: /* @__PURE__ */ jsxRuntime.jsx(VizTooltipContainer, { position, offset: offset || { x: 0, y: 0 }, children: content }) });
  }
  return null;
};
VizTooltip.displayName = "VizTooltip";
const getStyles$T = () => {
  return {
    portal: css.css({
      position: "absolute",
      top: 0,
      left: 0,
      pointerEvents: "none",
      width: "100%",
      height: "100%"
    })
  };
};

"use strict";
const SeriesIcon = React__namespace.memo(
  React__namespace.forwardRef(({ color, className, gradient, lineStyle, ...restProps }, ref) => {
    var _a, _b;
    const theme = useTheme2();
    const styles = useStyles2(getStyles$S);
    let cssColor;
    if (gradient) {
      const colors = (_b = (_a = data.fieldColorModeRegistry.get(gradient)).getColors) == null ? void 0 : _b.call(_a, theme);
      if (colors == null ? void 0 : colors.length) {
        cssColor = `linear-gradient(90deg, ${colors.join(", ")})`;
      } else {
        cssColor = theme.visualization.getColorByName("");
      }
    } else {
      cssColor = color;
    }
    let customStyle;
    if ((lineStyle == null ? void 0 : lineStyle.fill) === "dot" && !gradient) {
      customStyle = {
        backgroundImage: `radial-gradient(circle at 2px 2px, ${color} 2px, transparent 0)`,
        backgroundSize: "4px 4px",
        backgroundRepeat: "space"
      };
    } else if ((lineStyle == null ? void 0 : lineStyle.fill) === "dash" && !gradient) {
      customStyle = {
        backgroundImage: `linear-gradient(to right, ${color} 100%, transparent 0%)`,
        backgroundSize: "6px 4px",
        backgroundRepeat: "space"
      };
    } else {
      customStyle = {
        background: cssColor,
        borderRadius: theme.shape.radius.pill
      };
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        "data-testid": "series-icon",
        ref,
        className: css.cx(className, styles.forcedColors, styles.container),
        style: customStyle,
        ...restProps
      }
    );
  })
);
const getStyles$S = (theme) => ({
  container: css.css({
    marginRight: "8px",
    display: "inline-block",
    width: "14px",
    height: "4px"
  }),
  forcedColors: css.css({
    "@media (forced-colors: active)": {
      forcedColorAdjust: "none"
    }
  })
});
SeriesIcon.displayName = "SeriesIcon";

"use strict";
const getSeriesTableRowStyles = (theme) => {
  return {
    icon: css.css({
      marginRight: theme.spacing(1),
      verticalAlign: "middle"
    }),
    seriesTable: css.css({
      display: "table"
    }),
    seriesTableRow: css.css({
      display: "table-row",
      fontSize: theme.typography.bodySmall.fontSize
    }),
    seriesTableCell: css.css({
      display: "table-cell"
    }),
    label: css.css({
      wordBreak: "break-all"
    }),
    value: css.css({
      paddingLeft: theme.spacing(2),
      textAlign: "right"
    }),
    activeSeries: css.css({
      fontWeight: theme.typography.fontWeightBold,
      color: theme.colors.text.maxContrast
    }),
    timestamp: css.css({
      fontWeight: theme.typography.fontWeightBold,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};
const SeriesTableRow = ({ color, label, value, isActive }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { "data-testid": "SeriesTableRow", className: css.cx(styles.seriesTableRow, isActive && styles.activeSeries), children: [
    color && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.seriesTableCell, children: /* @__PURE__ */ jsxRuntime.jsx(SeriesIcon, { color, className: styles.icon }) }),
    label && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.seriesTableCell, styles.label), children: label }),
    value && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.seriesTableCell, styles.value), children: value })
  ] });
};
const SeriesTable = ({ timestamp, series }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    timestamp && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.timestamp, "aria-label": t("grafana-ui.viz-tooltip.timestamp", "Timestamp"), children: timestamp }),
    series.map((s, i) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        SeriesTableRow,
        {
          isActive: s.isActive,
          label: s.label,
          color: s.color,
          value: s.value
        },
        `${s.label}-${i}`
      );
    })
  ] });
};

"use strict";

"use strict";
const calculateGridDimensions = (parentWidth, parentHeight, itemSpacing, numberOfChildren) => {
  const vertical = calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren);
  const horizontal = calculateSizeOfChild(parentHeight, parentWidth, numberOfChildren);
  const square = Math.max(vertical, horizontal);
  let xCount = Math.floor(parentWidth / square);
  let yCount = Math.ceil(numberOfChildren / xCount);
  xCount = Math.ceil(numberOfChildren / yCount);
  const itemsOnLastRow = xCount - (xCount * yCount - numberOfChildren);
  const widthOnLastRow = parentWidth / itemsOnLastRow - itemSpacing + itemSpacing / itemsOnLastRow;
  return {
    width: parentWidth / xCount - itemSpacing + itemSpacing / xCount,
    height: parentHeight / yCount - itemSpacing + itemSpacing / yCount,
    widthOnLastRow,
    xCount,
    yCount
  };
};
function calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren) {
  const parts = Math.ceil(Math.sqrt(numberOfChildren * parentWidth / parentHeight));
  if (Math.floor(parts * parentHeight / parentWidth) * parts < numberOfChildren) {
    return parentHeight / Math.ceil(parts * parentHeight / parentWidth);
  }
  return parentWidth / parts;
}

"use strict";
class VizRepeater extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      values: props.getValues()
    };
  }
  componentDidUpdate(prevProps) {
    const { renderCounter, source } = this.props;
    if (renderCounter !== prevProps.renderCounter || source !== prevProps.source) {
      this.setState({ values: this.props.getValues() });
    }
  }
  getOrientation() {
    const { orientation, width, height } = this.props;
    if (orientation === data.VizOrientation.Auto) {
      if (width > height) {
        return data.VizOrientation.Vertical;
      } else {
        return data.VizOrientation.Horizontal;
      }
    }
    return orientation;
  }
  renderGrid() {
    const { renderValue, height, width, itemSpacing, getAlignmentFactors, orientation } = this.props;
    const { values } = this.state;
    const grid = calculateGridDimensions(width, height, itemSpacing, values.length);
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, grid.width, grid.height) : {};
    let xGrid = 0;
    let yGrid = 0;
    let items = [];
    for (let i = 0; i < values.length; i++) {
      const value = values[i];
      const isLastRow = yGrid === grid.yCount - 1;
      const itemWidth = isLastRow ? grid.widthOnLastRow : grid.width;
      const itemHeight = grid.height;
      const xPos = xGrid * itemWidth + itemSpacing * xGrid;
      const yPos = yGrid * itemHeight + itemSpacing * yGrid;
      const itemStyles = {
        position: "absolute",
        left: xPos,
        top: yPos,
        width: `${itemWidth}px`,
        height: `${itemHeight}px`
      };
      items.push(
        /* @__PURE__ */ jsxRuntime.jsx("div", { style: itemStyles, children: renderValue({
          value,
          width: itemWidth,
          height: itemHeight,
          alignmentFactors,
          orientation,
          count: values.length
        }) }, i)
      );
      xGrid++;
      if (xGrid === grid.xCount) {
        xGrid = 0;
        yGrid++;
      }
    }
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: { position: "relative" }, children: items });
  }
  render() {
    const {
      renderValue,
      height,
      width,
      itemSpacing,
      getAlignmentFactors,
      autoGrid,
      orientation,
      maxVizHeight,
      minVizWidth,
      minVizHeight
    } = this.props;
    const { values } = this.state;
    if (autoGrid && orientation === data.VizOrientation.Auto) {
      return this.renderGrid();
    }
    const itemStyles = {
      display: "flex"
    };
    const repeaterStyle = {
      display: "flex",
      overflow: `${minVizWidth ? "auto" : "hidden"} ${minVizHeight ? "auto" : "hidden"}`
    };
    let vizHeight = height;
    let vizWidth = width;
    const resolvedOrientation = this.getOrientation();
    switch (resolvedOrientation) {
      case data.VizOrientation.Horizontal:
        const defaultVizHeight = (height + itemSpacing) / values.length - itemSpacing;
        repeaterStyle.flexDirection = "column";
        repeaterStyle.height = `${height}px`;
        repeaterStyle.overflowX = "hidden";
        repeaterStyle.scrollbarWidth = "thin";
        itemStyles.marginBottom = `${itemSpacing}px`;
        vizWidth = width;
        vizHeight = lodash.clamp(defaultVizHeight, minVizHeight != null ? minVizHeight : 0, maxVizHeight != null ? maxVizHeight : defaultVizHeight);
        break;
      case data.VizOrientation.Vertical:
        repeaterStyle.flexDirection = "row";
        repeaterStyle.justifyContent = "space-between";
        repeaterStyle.overflowY = "hidden";
        itemStyles.marginRight = `${itemSpacing}px`;
        vizHeight = height;
        vizWidth = Math.max(width / values.length - itemSpacing + itemSpacing / values.length, minVizWidth != null ? minVizWidth : 0);
    }
    itemStyles.width = `${vizWidth}px`;
    itemStyles.height = `${vizHeight}px`;
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, vizWidth, vizHeight) : {};
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: repeaterStyle, children: values.map((value, index) => {
      return /* @__PURE__ */ jsxRuntime.jsx("div", { style: getItemStylesForIndex(itemStyles, index, values.length), children: renderValue({
        value,
        width: vizWidth,
        height: vizHeight,
        alignmentFactors,
        orientation: resolvedOrientation,
        count: values.length
      }) }, index);
    }) });
  }
}
VizRepeater.defaultProps = {
  itemSpacing: 8
};
function getItemStylesForIndex(itemStyles, index, length) {
  if (index === length - 1) {
    return {
      ...itemStyles,
      marginRight: 0,
      marginBottom: 0
    };
  }
  return itemStyles;
}

"use strict";
const VizLayout = ({ width, height, legend, children }) => {
  const theme = useTheme2();
  const styles = useStyles2(getVizStyles);
  const containerStyle = {
    display: "flex",
    width: `${width}px`,
    height: `${height}px`
  };
  const [legendRef, legendMeasure] = reactUse.useMeasure();
  if (!legend) {
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { style: containerStyle, className: styles.viz, children: children(width, height) }) });
  }
  let { placement, maxHeight = "35%", maxWidth = "60%" } = legend.props;
  if (document.body.clientWidth < theme.breakpoints.values.lg) {
    placement = "bottom";
  }
  let size = null;
  const legendStyle = {};
  switch (placement) {
    case "bottom":
      containerStyle.flexDirection = "column";
      legendStyle.maxHeight = maxHeight;
      if (legendMeasure.height) {
        size = { width, height: height - legendMeasure.height };
      }
      break;
    case "right":
      containerStyle.flexDirection = "row";
      legendStyle.maxWidth = maxWidth;
      if (legendMeasure.width) {
        size = { width: width - legendMeasure.width, height };
      }
      if (legend.props.width) {
        legendStyle.width = legend.props.width;
        size = { width: width - legend.props.width, height };
      }
      break;
  }
  if ((size == null ? void 0 : size.width) === 0) {
    size.width = width;
  }
  if ((size == null ? void 0 : size.height) === 0) {
    size.height = height;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: containerStyle, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.viz, children: size && children(size.width, size.height) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { style: legendStyle, ref: legendRef, children: /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { children: legend }) })
  ] });
};
const getVizStyles = (theme) => {
  return {
    viz: css.css({
      flexGrow: 2,
      borderRadius: theme.shape.radius.default,
      "&:focus-visible": getFocusStyles(theme)
    })
  };
};
const VizLayoutLegend = ({ children }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children });
};
VizLayout.Legend = VizLayoutLegend;

"use strict";
var SeriesVisibilityChangeBehavior = /* @__PURE__ */ ((SeriesVisibilityChangeBehavior2) => {
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Isolate"] = 0] = "Isolate";
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Hide"] = 1] = "Hide";
  return SeriesVisibilityChangeBehavior2;
})(SeriesVisibilityChangeBehavior || {});

"use strict";
class InlineList extends React.PureComponent {
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(AbstractList, { inline: true, ...this.props });
  }
}

"use strict";
const VizLegendSeriesIcon = React.memo(({ seriesName, color, gradient, readonly, lineStyle }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = React.useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ jsxRuntime.jsx(SeriesColorPicker, { color, onChange, enableNamedColors: true, children: ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ jsxRuntime.jsx(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker,
        lineStyle
      }
    ) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(SeriesIcon, { color, gradient, lineStyle });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

"use strict";
const VizLegendStatsList = ({ stats }) => {
  const styles = useStyles2(getStyles$R);
  if (stats.length === 0) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    InlineList,
    {
      className: styles.list,
      items: stats,
      renderItem: (stat) => /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.item, title: stat.description, children: [
        stat.title && `${lodash.capitalize(stat.title)}:`,
        " ",
        data.formattedValueToString(stat)
      ] })
    }
  );
};
const getStyles$R = () => ({
  list: css.css({
    flexGrow: 1,
    textAlign: "right"
  }),
  item: css.css({
    marginLeft: "8px"
  })
});
VizLegendStatsList.displayName = "VizLegendStatsList";

"use strict";
const VizLegendListItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles$Q);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(styles.itemWrapper, item.disabled && styles.itemDisabled, className),
      "data-testid": e2eSelectors.selectors.components.VizLegend.seriesName(item.label),
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          VizLegendSeriesIcon,
          {
            seriesName: (_a = item.fieldName) != null ? _a : item.label,
            color: item.color,
            gradient: item.gradient,
            readonly,
            lineStyle: item.lineStyle
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          "button",
          {
            disabled: readonly,
            type: "button",
            onBlur: onMouseOut,
            onFocus: onMouseOver,
            onMouseOver,
            onMouseOut,
            onClick,
            className: styles.label,
            children: item.label
          }
        ),
        item.getDisplayValues && /* @__PURE__ */ jsxRuntime.jsx(VizLegendStatsList, { stats: item.getDisplayValues() })
      ]
    }
  );
};
VizLegendListItem.displayName = "VizLegendListItem";
const getStyles$Q = (theme) => ({
  label: css.css({
    label: "LegendLabel",
    whiteSpace: "nowrap",
    background: "none",
    border: "none",
    fontSize: "inherit",
    padding: 0,
    userSelect: "text"
  }),
  itemDisabled: css.css({
    label: "LegendLabelDisabled",
    color: theme.colors.text.disabled
  }),
  itemWrapper: css.css({
    label: "LegendItemWrapper",
    display: "flex",
    whiteSpace: "nowrap",
    alignItems: "center",
    flexGrow: 1
  }),
  value: css.css({
    textAlign: "right"
  }),
  yAxisLabel: css.css({
    color: theme.v1.palette.gray2
  })
});

"use strict";
const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$P);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ jsxRuntime.jsx(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.itemRight, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.rightWrapper, className), children: /* @__PURE__ */ jsxRuntime.jsx(List, { items, renderItem, getItemKey }) });
    }
    case "bottom":
    default: {
      const leftItems = items.filter((item) => item.yAxis === 1);
      const rightItems = items.filter((item) => item.yAxis !== 1);
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.itemBottom, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.bottomWrapper, className), children: [
        leftItems.length > 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.section, children: /* @__PURE__ */ jsxRuntime.jsx(InlineList, { items: leftItems, renderItem, getItemKey }) }),
        rightItems.length > 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.section, styles.sectionRight), children: /* @__PURE__ */ jsxRuntime.jsx(InlineList, { items: rightItems, renderItem, getItemKey }) })
      ] });
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles$P = (theme) => {
  const itemStyles = css.css({
    paddingRight: "10px",
    display: "flex",
    fontSize: theme.typography.bodySmall.fontSize,
    whiteSpace: "nowrap"
  });
  return {
    itemBottom: itemStyles,
    itemRight: css.cx(
      itemStyles,
      css.css({
        marginBottom: theme.spacing(0.5)
      })
    ),
    rightWrapper: css.css({
      padding: theme.spacing(0.5)
    }),
    bottomWrapper: css.css({
      display: "flex",
      flexWrap: "wrap",
      justifyContent: "space-between",
      width: "100%",
      padding: theme.spacing(0.5),
      gap: "15px 25px"
    }),
    section: css.css({
      display: "flex"
    }),
    sectionRight: css.css({
      justifyContent: "flex-end",
      flexGrow: 1,
      flexBasis: "50%"
    })
  };
};

"use strict";
const LegendTableItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles$O);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("tr", { className: css.cx(styles.row, className), children: [
    /* @__PURE__ */ jsxRuntime.jsx("td", { children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.itemWrapper, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendSeriesIcon,
        {
          color: item.color,
          seriesName: (_a = item.fieldName) != null ? _a : item.label,
          readonly,
          lineStyle: item.lineStyle
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsxs(
        "button",
        {
          disabled: readonly,
          type: "button",
          title: item.label,
          onBlur: onMouseOut,
          onFocus: onMouseOver,
          onMouseOver,
          onMouseOut,
          onClick: !readonly ? onClick : void 0,
          className: css.cx(styles.label, item.disabled && styles.labelDisabled),
          children: [
            item.label,
            " ",
            item.yAxis === 2 && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.yAxisLabel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.viz-legend.right-axis-indicator", children: "(right y-axis)" }) })
          ]
        }
      )
    ] }) }),
    item.getDisplayValues && item.getDisplayValues().map((stat, index) => {
      return /* @__PURE__ */ jsxRuntime.jsx("td", { className: styles.value, children: data.formattedValueToString(stat) }, `${stat.title}-${index}`);
    })
  ] });
};
LegendTableItem.displayName = "LegendTableItem";
const getStyles$O = (theme) => {
  const rowHoverBg = hoverColor(theme.colors.background.primary, theme);
  return {
    row: css.css({
      label: "LegendRow",
      fontSize: theme.v1.typography.size.sm,
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      td: {
        padding: theme.spacing(0.25, 1),
        whiteSpace: "nowrap"
      },
      "&:hover": {
        background: rowHoverBg
      }
    }),
    label: css.css({
      label: "LegendLabel",
      whiteSpace: "nowrap",
      background: "none",
      border: "none",
      fontSize: "inherit",
      padding: 0,
      maxWidth: "600px",
      textOverflow: "ellipsis",
      overflow: "hidden",
      userSelect: "text"
    }),
    labelDisabled: css.css({
      label: "LegendLabelDisabled",
      color: theme.colors.text.disabled
    }),
    itemWrapper: css.css({
      display: "flex",
      whiteSpace: "nowrap",
      alignItems: "center"
    }),
    value: css.css({
      textAlign: "right"
    }),
    yAxisLabel: css.css({
      color: theme.colors.text.secondary
    })
  };
};

"use strict";
const nameSortKey = "Name";
const naturalCompare = new Intl.Collator(void 0, { numeric: true, sensitivity: "base" }).compare;
const VizLegendTable = ({
  items,
  sortBy: sortKey,
  sortDesc,
  itemRenderer,
  className,
  onToggleSort,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  readonly,
  isSortable
}) => {
  var _a, _b;
  const styles = useStyles2(getStyles$N);
  const header = {};
  if (isSortable) {
    header[nameSortKey] = "";
  }
  for (const item of items) {
    if (item.getDisplayValues) {
      for (const displayValue of item.getDisplayValues()) {
        header[(_a = displayValue.title) != null ? _a : "?"] = (_b = displayValue.description) != null ? _b : "";
      }
    }
  }
  if (sortKey != null) {
    let itemVals = /* @__PURE__ */ new Map();
    items.forEach((item) => {
      if (sortKey !== nameSortKey && item.getDisplayValues) {
        const stat = item.getDisplayValues().find((stat2) => stat2.title === sortKey);
        const val = stat == null || Number.isNaN(stat.numeric) ? -Infinity : stat.numeric;
        itemVals.set(item, val);
      }
    });
    let sortMult = sortDesc ? -1 : 1;
    if (sortKey === nameSortKey) {
      items.sort((a, b) => {
        return sortMult * naturalCompare(a.label, b.label);
      });
    } else {
      items.sort((a, b) => {
        var _a2, _b2;
        const aVal = (_a2 = itemVals.get(a)) != null ? _a2 : 0;
        const bVal = (_b2 = itemVals.get(b)) != null ? _b2 : 0;
        return sortMult * (aVal - bVal);
      });
    }
  }
  if (!itemRenderer) {
    itemRenderer = (item, index) => /* @__PURE__ */ jsxRuntime.jsx(
      LegendTableItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      },
      `${item.label}-${index}`
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("table", { className: css.cx(styles.table, className), children: [
    /* @__PURE__ */ jsxRuntime.jsx("thead", { children: /* @__PURE__ */ jsxRuntime.jsxs("tr", { children: [
      !isSortable && /* @__PURE__ */ jsxRuntime.jsx("th", {}),
      Object.keys(header).map((columnTitle) => /* @__PURE__ */ jsxRuntime.jsxs(
        "th",
        {
          title: header[columnTitle],
          className: css.cx(styles.header, onToggleSort && styles.headerSortable, isSortable && styles.nameHeader, {
            [styles.withIcon]: sortKey === columnTitle
          }),
          onClick: () => {
            if (onToggleSort) {
              onToggleSort(columnTitle);
            }
          },
          children: [
            columnTitle,
            sortKey === columnTitle && /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "xs", name: sortDesc ? "angle-down" : "angle-up" })
          ]
        },
        columnTitle
      ))
    ] }) }),
    /* @__PURE__ */ jsxRuntime.jsx("tbody", { children: items.map(itemRenderer) })
  ] });
};
const getStyles$N = (theme) => ({
  table: css.css({
    width: "100%",
    "th:first-child": {
      width: "100%",
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }
  }),
  header: css.css({
    color: theme.colors.primary.text,
    fontWeight: theme.typography.fontWeightMedium,
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(0.25, 1, 0.25, 1),
    fontSize: theme.typography.bodySmall.fontSize,
    textAlign: "right",
    whiteSpace: "nowrap"
  }),
  nameHeader: css.css({
    textAlign: "left",
    paddingLeft: "30px"
  }),
  // This needs to be padding-right - icon size(xs==12) to avoid jumping
  withIcon: css.css({
    paddingRight: "4px"
  }),
  headerSortable: css.css({
    cursor: "pointer"
  })
});

"use strict";
function mapMouseEventToMode(event) {
  if (event.ctrlKey || event.metaKey || event.shiftKey) {
    return SeriesVisibilityChangeMode.AppendToSelection;
  }
  return SeriesVisibilityChangeMode.ToggleSelection;
}

"use strict";
function VizLegend({
  items,
  thresholdItems,
  mappingItems,
  displayMode,
  sortBy: sortKey,
  seriesVisibilityChangeBehavior = SeriesVisibilityChangeBehavior.Isolate,
  sortDesc,
  onLabelClick,
  onToggleSort,
  placement,
  className,
  itemRenderer,
  readonly,
  isSortable
}) {
  const { eventBus, onToggleSeriesVisibility, onToggleLegendSort } = usePanelContext();
  const onMouseOver = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onMouseOut = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverClearEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onLegendLabelClick = React.useCallback(
    (item, event) => {
      var _a;
      if (onLabelClick) {
        onLabelClick(item, event);
      }
      if (onToggleSeriesVisibility) {
        onToggleSeriesVisibility(
          (_a = item.fieldName) != null ? _a : item.label,
          seriesVisibilityChangeBehavior === SeriesVisibilityChangeBehavior.Hide ? SeriesVisibilityChangeMode.AppendToSelection : mapMouseEventToMode(event)
        );
      }
    },
    [onToggleSeriesVisibility, onLabelClick, seriesVisibilityChangeBehavior]
  );
  const makeVizLegendList = React.useCallback(
    (items2) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendList,
        {
          className,
          placement,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          onLabelClick: onLegendLabelClick,
          itemRenderer,
          readonly,
          items: items2
        }
      );
    },
    [className, placement, onMouseOver, onMouseOut, onLegendLabelClick, itemRenderer, readonly]
  );
  switch (displayMode) {
    case schema.LegendDisplayMode.Table:
      return /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendTable,
        {
          className,
          items,
          placement,
          sortBy: sortKey,
          sortDesc,
          onLabelClick: onLegendLabelClick,
          onToggleSort: onToggleSort || onToggleLegendSort,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          itemRenderer,
          readonly,
          isSortable
        }
      );
    case schema.LegendDisplayMode.List:
      const isThresholdsEnabled = thresholdItems && thresholdItems.length > 1;
      const isValueMappingEnabled = mappingItems && mappingItems.length > 0;
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        !isThresholdsEnabled && (!isValueMappingEnabled || items.length > 1) && makeVizLegendList(items),
        isThresholdsEnabled && makeVizLegendList(thresholdItems),
        isValueMappingEnabled && makeVizLegendList(mappingItems)
      ] });
    default:
      return null;
  }
}
VizLegend.displayName = "VizLegend";

"use strict";
class GraphSeriesToggler extends React.Component {
  constructor(props) {
    super(props);
    this.onSeriesToggle = this.onSeriesToggle.bind(this);
    this.state = {
      hiddenSeries: [],
      toggledSeries: props.series
    };
  }
  componentDidUpdate(prevProps) {
    const { series } = this.props;
    if (!lodash.isEqual(prevProps.series, series)) {
      this.setState({ hidd