import { useRef, useEffect } from 'react';
import { roundMsToMin } from '../language_utils.mjs';

"use strict";
function usePromQueryFieldEffects(languageProvider, range, series, refreshMetrics, refreshHint) {
  const lastRangeRef = useRef(null);
  const languageProviderInitRef = useRef(null);
  useEffect(() => {
    if (languageProvider) {
      refreshMetrics(languageProviderInitRef);
    }
    refreshHint();
    return () => {
      if (languageProviderInitRef.current) {
        languageProviderInitRef.current.cancel();
        languageProviderInitRef.current = null;
      }
    };
  }, []);
  useEffect(() => {
    if (!range) {
      return;
    }
    const currentFrom = roundMsToMin(range.from.valueOf());
    const currentTo = roundMsToMin(range.to.valueOf());
    if (!lastRangeRef.current) {
      lastRangeRef.current = { from: range.from, to: range.to };
    }
    const lastFrom = roundMsToMin(lastRangeRef.current.from.valueOf());
    const lastTo = roundMsToMin(lastRangeRef.current.to.valueOf());
    if (currentFrom !== lastFrom || currentTo !== lastTo) {
      lastRangeRef.current = { from: range.from, to: range.to };
      refreshMetrics(languageProviderInitRef);
    }
  }, [range, refreshMetrics]);
  useEffect(() => {
    refreshHint();
  }, [series, refreshHint]);
  return languageProviderInitRef;
}

export { usePromQueryFieldEffects };
//# sourceMappingURL=usePromQueryFieldEffects.mjs.map
