import { jsx, Fragment } from 'react/jsx-runtime';
import '../ToolbarButton/index.mjs';
import '../Tooltip/index.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.mjs';

"use strict";
function TimeSyncButton(props) {
  const { onClick, isSynced } = props;
  const syncTimesTooltip = () => {
    const tooltip = isSynced ? "Unsync all views" : "Sync all views to this time range";
    return /* @__PURE__ */ jsx(Fragment, { children: tooltip });
  };
  return /* @__PURE__ */ jsx(Tooltip, { content: syncTimesTooltip, placement: "bottom", children: /* @__PURE__ */ jsx(
    ToolbarButton,
    {
      icon: "link",
      variant: isSynced ? "active" : "canvas",
      "aria-label": isSynced ? "Un sync times" : "Sync times",
      onClick
    }
  ) });
}

export { TimeSyncButton };
//# sourceMappingURL=TimeSyncButton.mjs.map
