"use strict";
let singleton;
function setGetObservablePluginComponents(fn) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error(
      "setGetObservablePluginComponents() function should only be called once, when Grafana is starting."
    );
  }
  singleton = fn;
}
function getObservablePluginComponents(options) {
  if (!singleton) {
    throw new Error("getObservablePluginComponents() can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}

export { getObservablePluginComponents, setGetObservablePluginComponents };
//# sourceMappingURL=getObservablePluginComponents.mjs.map
