"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[3955],{"../grafana-data/src/dataframe/processDataFrame.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{KR:function(){return getTimeField},dF:function(){return guessFieldTypeForField},HW:function(){return guessFieldTypeFromValue},ci:function(){return isDataFrame},LI:function(){return isDataFrameWithValue},ES:function(){return sortDataFrame},Kl:function(){return toDataFrameDTO}});var lodash=__webpack_require__("../../node_modules/lodash/lodash.js"),moment_wrapper=__webpack_require__("../grafana-data/src/datetime/moment_wrapper.ts"),dataFrame=__webpack_require__("../grafana-data/src/types/dataFrame.ts");const fieldIndexComparer=(field,reverse=!1)=>{const values=field.values;switch(field.type){case dataFrame.PU.number:return numericIndexComparer(values,reverse);case dataFrame.PU.string:return stringIndexComparer(values,reverse);case dataFrame.PU.boolean:return booleanIndexComparer(values,reverse);case dataFrame.PU.time:return"number"==typeof field.values[0]?timestampIndexComparer(values,reverse):timeIndexComparer(values,reverse);default:return naturalIndexComparer(reverse)}},timeComparer=(a,b)=>{if(!a||!b)return falsyComparer(a,b);if((0,lodash.isNumber)(a)&&(0,lodash.isNumber)(b))return numericComparer(a,b);if((0,moment_wrapper.u8)(a)&&(0,moment_wrapper.u8)(b)){if((0,moment_wrapper.KQ)(a).isBefore(b))return-1;if((0,moment_wrapper.KQ)(b).isBefore(a))return 1}return 0},numericComparer=(a,b)=>a-b,compare=new Intl.Collator("en",{sensitivity:"base"}).compare,stringComparer=(a,b)=>a&&b?compare(String(a),String(b)):falsyComparer(a,b),booleanComparer=(a,b)=>falsyComparer(a,b),falsyComparer=(a,b)=>!a&&b?1:a&&!b?-1:0,timestampIndexComparer=(values,reverse)=>{let mult=reverse?-1:1;return(a,b)=>mult*(values[a]-values[b])},timeIndexComparer=(values,reverse)=>(a,b)=>{const vA=values[a],vB=values[b];return reverse?timeComparer(vB,vA):timeComparer(vA,vB)},booleanIndexComparer=(values,reverse)=>(a,b)=>{const vA=values[a],vB=values[b];return reverse?booleanComparer(vB,vA):booleanComparer(vA,vB)},numericIndexComparer=(values,reverse)=>(a,b)=>{const vA=values[a],vB=values[b];return reverse?numericComparer(vB,vA):numericComparer(vA,vB)},stringIndexComparer=(values,reverse)=>(a,b)=>{const vA=values[a],vB=values[b];return reverse?stringComparer(vB,vA):stringComparer(vA,vB)},naturalIndexComparer=reverse=>(a,b)=>reverse?numericComparer(b,a):numericComparer(a,b);const NUMBER=/^\s*(-?(\d*\.?\d+|\d+\.?\d*)(e[-+]?\d+)?|NAN)\s*$/i;function guessFieldTypeFromValue(v){return v instanceof Date||(0,moment_wrapper.Ar)(v)?dataFrame.PU.time:(0,lodash.isNumber)(v)?dataFrame.PU.number:(0,lodash.isString)(v)?NUMBER.test(v)?dataFrame.PU.number:"true"===v||"TRUE"===v||"True"===v||"false"===v||"FALSE"===v||"False"===v?dataFrame.PU.boolean:dataFrame.PU.string:(0,lodash.isBoolean)(v)?dataFrame.PU.boolean:dataFrame.PU.other}function guessFieldTypeForField(field){if(field.name){const name=field.name.toLowerCase();if("date"===name||"time"===name)return dataFrame.PU.time}for(let i=0;i<field.values.length;i++){const v=field.values[i];if(null!=v)return guessFieldTypeFromValue(v)}}const isDataFrame=data=>Boolean(data&&data.hasOwnProperty("fields")),isDataFrameWithValue=data=>Boolean(isDataFrame(data)&&data.hasOwnProperty("value"));function sortDataFrame(data,sortIndex,reverse=!1){const field=data.fields[sortIndex];if(!field)return data;const index=[];for(let i=0;i<data.length;i++)index.push(i);const fieldComparer=fieldIndexComparer(field,reverse);return index.sort(fieldComparer),{...data,fields:data.fields.map((f=>{const newF={...f,values:f.values.map(((v,i)=>f.values[index[i]]))},{nanos:nanos}=f;return void 0!==nanos&&(newF.nanos=nanos.map(((n,i)=>nanos[index[i]]))),newF}))}}function toDataFrameDTO(data){return function toFilteredDataFrameDTO(data,fieldPredicate){const filteredFields=fieldPredicate?data.fields.filter(fieldPredicate):data.fields;return{fields:filteredFields.map((f=>{let values=f.values;return{name:f.name,type:f.type,config:f.config,values:values,labels:f.labels}})),refId:data.refId,meta:data.meta,name:data.name}}(data)}const getTimeField=series=>{for(let i=0;i<series.fields.length;i++)if(series.fields[i].type===dataFrame.PU.time)return{timeField:series.fields[i],timeIndex:i};return{}}},"../grafana-data/src/field/fieldState.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{Ct:function(){return getFieldDisplayName}});var dataFrame=__webpack_require__("../grafana-data/src/types/dataFrame.ts");function getFieldDisplayName(field,frame,allFrames){const existingTitle=field.state?.displayName,multipleFrames=Boolean(allFrames&&allFrames.length>1);if(existingTitle&&multipleFrames===field.state?.multipleFrames)return existingTitle;const displayName=function calculateFieldDisplayName(field,frame,allFrames){const hasConfigTitle=field.config?.displayName&&field.config?.displayName.length,isComparisonSeries=Boolean(frame?.meta?.timeCompare?.isTimeShiftQuery);let displayName=hasConfigTitle?field.config.displayName:field.name;if(hasConfigTitle)return isComparisonSeries?`${displayName} (comparison)`:displayName;if(frame&&field.config?.displayNameFromDS)return isComparisonSeries?`${field.config.displayNameFromDS} (comparison)`:field.config.displayNameFromDS;if(field.type===dataFrame.PU.time&&!field.labels)return displayName??dataFrame.LE;let parts=[],frameNamesDiffer=!1;if(allFrames&&allFrames.length>1)for(let i=1;i<allFrames.length;i++){if(allFrames[i].name!==allFrames[i-1].name){frameNamesDiffer=!0;break}}let frameNameAdded=!1,labelsAdded=!1;frameNamesDiffer&&frame?.name&&(parts.push(frame.name),frameNameAdded=!0);field.name&&field.name!==dataFrame.Bc&&parts.push(field.name);if(field.labels&&frame){let singleLabelName=function getSingleLabelName(frames){let singleName=null;for(let i=0;i<frames.length;i++){const frame=frames[i];for(const field of frame.fields)if(field.labels)for(const labelKey in field.labels)if(null===singleName)singleName=labelKey;else if(labelKey!==singleName)return null}return singleName}(allFrames??[frame]);if(singleLabelName)field.labels[singleLabelName]&&(parts.push(field.labels[singleLabelName]),labelsAdded=!0);else{let allLabels=function formatLabels(labels,defaultValue="",withoutBraces){if(!labels||0===Object.keys(labels).length)return defaultValue;const cleanSelector=Object.keys(labels).sort().map((key=>`${key}="${labels[key]}"`)).join(", ");return withoutBraces?cleanSelector:["{",cleanSelector,"}"].join("")}(field.labels);allLabels&&(parts.push(allLabels),labelsAdded=!0)}}!frame||frameNameAdded||labelsAdded||field.name!==dataFrame.Bc||frame.name&&frame.name.length>0&&(parts.push(frame.name),frameNameAdded=!0);displayName=parts.length?parts.join(" "):field.name?field.name:dataFrame.Bc;displayName===field.name&&(displayName=function getUniqueFieldName(field,frame){let dupeCount=0,foundSelf=!1;if(frame)for(let i=0;i<frame.fields.length;i++){const otherField=frame.fields[i];if(field===otherField){if(foundSelf=!0,dupeCount>0){dupeCount++;break}}else if(field.name===otherField.name&&(dupeCount++,foundSelf))break}if(dupeCount)return`${field.name} ${dupeCount}`;return field.name}(field,frame));isComparisonSeries&&(displayName=`${displayName} (comparison)`);return displayName}(field,frame,allFrames);return field.state=field.state||{},field.state.displayName=displayName,field.state.multipleFrames=multipleFrames,displayName}},"../grafana-data/src/transformations/matchers.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{sJ:function(){return fieldMatchers},RE:function(){return frameMatchers},NS:function(){return getFieldMatcher},Dq:function(){return getFrameMatchers}});var Registry=__webpack_require__("../grafana-data/src/utils/Registry.ts"),dataFrame=__webpack_require__("../grafana-data/src/types/dataFrame.ts"),ids=__webpack_require__("../grafana-data/src/transformations/matchers/ids.ts");const fieldTypeMatcher={id:ids.Ct.byType,name:"Field Type",description:"match based on the field type",defaultOptions:dataFrame.PU.number,get:type=>(field,frame,allFrames)=>type===field.type,getOptionsDisplayText:type=>`Field type: ${type}`},fieldTypesMatcher={id:ids.Ct.byTypes,name:"Field Type",description:"match based on the field types",defaultOptions:new Set,get:types=>(field,frame,allFrames)=>types.has(field.type),getOptionsDisplayText:types=>`Field types: ${[...types].join(" | ")}`},numericMatcher={id:ids.Ct.numeric,name:"Numeric Fields",description:"Fields with type number",get:()=>fieldTypeMatcher.get(dataFrame.PU.number),getOptionsDisplayText:()=>"Numeric Fields"},timeMatcher={id:ids.Ct.time,name:"Time Fields",description:"Fields with type time",get:()=>fieldTypeMatcher.get(dataFrame.PU.time),getOptionsDisplayText:()=>"Time Fields"};var common_gen=__webpack_require__("../grafana-schema/src/common/common.gen.ts"),fieldReducer=__webpack_require__("../grafana-data/src/transformations/fieldReducer.ts");const fieldValueMatcherInfo={id:ids.Ct.byValue,name:"By value (reducer)",description:"Reduce a field to a single value and test for inclusion",defaultOptions:{reducer:fieldReducer.gy.allIsZero,op:common_gen.zT.GTE,value:0},get:props=>{if(!props||!props.reducer)return()=>!1;let{reducer:reducer,op:op,value:value}=props;const isBoolean=function isBooleanReducer(r){return r===fieldReducer.gy.allIsNull||r===fieldReducer.gy.allIsZero}(reducer);return op||(op=common_gen.zT.EQ),(field,frame,allFrames)=>{const left=(0,fieldReducer.Nw)({field:field,reducers:[reducer]})[reducer];return isBoolean?Boolean(left):function compareValues(left,op,right){switch(null!=left&&null!=right||(null==left&&(left="null"),null==right&&(right="null"),op!==common_gen.zT.GTE&&op!==common_gen.zT.LTE||(op=common_gen.zT.EQ)),op){case common_gen.zT.EQ:return`${left}`==`${right}`;case common_gen.zT.NEQ:return`${left}`!=`${right}`;case common_gen.zT.GT:return left>right;case common_gen.zT.GTE:return left>=right;case common_gen.zT.LT:return left<right;case common_gen.zT.LTE:return left<=right;default:return!1}}(left,op,value)}},getOptionsDisplayText:props=>`By value (${props.reducer})`};var fieldState=__webpack_require__("../grafana-data/src/field/fieldState.ts"),string=__webpack_require__("../grafana-data/src/text/string.ts");const fieldNameMatcher={id:ids.Ct.byName,name:"Field Name",description:"match the field name",defaultOptions:"",get:name=>{const fallback=fieldNameFallback(new Set([name]));return(field,frame,allFrames)=>name===field.name||name===(0,fieldState.Ct)(field,frame,allFrames)||Boolean(fallback&&fallback(field,frame,allFrames))},getOptionsDisplayText:name=>`Field name: ${name}`},multipleFieldNamesMatcher={id:ids.Ct.byNames,name:"Field Names",description:"match any of the given the field names",defaultOptions:{mode:"include",names:[]},get:options=>{const{names:names,mode:mode="include"}=options,uniqueNames=new Set(names??[]),fallback=fieldNameFallback(uniqueNames),matcher=(field,frame,frames)=>uniqueNames.has(field.name)||uniqueNames.has((0,fieldState.Ct)(field,frame,frames))||Boolean(fallback&&fallback(field,frame,frames));return"exclude"===mode?(field,frame,frames)=>!matcher(field,frame,frames):matcher},getOptionsDisplayText:options=>{const{names:names,mode:mode}=options,displayText=(names??[]).join(", ");return"exclude"===mode?`All except: ${displayText}`:`All of: ${displayText}`}};function fieldNameFallback(fields){let fallback;const useMatcherFallback=window?.grafanaBootData?.settings?.featureToggles?.dataplaneFrontendFallback;return useMatcherFallback&&(fields.has(dataFrame.Bc)?fallback=(field,frame)=>Boolean(field.labels)&&field.labels?.__name__===field.name:(fields.has("Time")||fields.has("time"))&&(fallback=(field,frame)=>null==frame.meta?.typeVersion&&field.type===dataFrame.PU.time)),fallback}const regexpFieldNameMatcher={id:ids.Ct.byRegexp,name:"Field Name by Regexp",description:"match the field name by a given regexp pattern",defaultOptions:"/.*/",get:pattern=>{const regexp=patternToRegex(pattern);return(field,frame,allFrames)=>{const displayName=(0,fieldState.Ct)(field,frame,allFrames);return!!regexp&&regexp.test(displayName)}},getOptionsDisplayText:pattern=>`Field name by pattern: ${pattern}`},fieldsInFrameMatcher={id:ids.Ct.byFrameRefID,name:"Fields by frame refId",description:"match all fields returned in data frame with refId.",defaultOptions:"",get:refId=>(field,frame,allFrames)=>frame.refId===refId,getOptionsDisplayText:refId=>`Math all fields returned by query with reference ID: ${refId}`},regexpOrMultipleNamesMatcher={id:ids.Ct.byRegexpOrNames,name:"Field Name by Regexp or Names",description:"match the field name by a given regexp pattern or given names",defaultOptions:{pattern:"/.*/",names:[]},get:options=>{const regexpMatcher=regexpFieldNameMatcher.get(options?.pattern||""),namesMatcher=multipleFieldNamesMatcher.get({mode:"include",names:options?.names??[]});return(field,frame,allFrames)=>namesMatcher(field,frame,allFrames)||regexpMatcher(field,frame,allFrames)},getOptionsDisplayText:options=>`Field name by pattern: ${options?.pattern??""} or names: ${options?.names?.join(",")??""}`},patternToRegex=pattern=>{if(pattern)try{return(0,string.dO)(pattern)}catch(error){return void console.error(error)}},frameNameMatcher={id:ids.jR.byName,name:"Frame Name",description:"match the frame name",defaultOptions:"/.*/",get:pattern=>{const regex=(0,string.dO)(pattern);return frame=>regex.test(frame.name||"")},getOptionsDisplayText:pattern=>`Frame name: ${pattern}`};const anyFieldMatcher={id:ids.cV.anyMatch,name:"Any",description:"Any child matches (OR)",excludeFromPicker:!0,defaultOptions:[],get:options=>{const children=options.map((option=>getFieldMatcher(option)));return(field,frame,allFrames)=>{for(const child of children)if(child(field,frame,allFrames))return!0;return!1}},getOptionsDisplayText:options=>{let text="";for(const sub of options){text.length>0&&(text+=" OR ");const matcher=fieldMatchers.get(sub.id);text+=matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(sub):matcher.name}return text}},anyFrameMatcher={id:ids.cV.anyMatch,name:"Any",description:"Any child matches (OR)",excludeFromPicker:!0,defaultOptions:[],get:options=>{const children=options.map((option=>getFrameMatchers(option)));return frame=>{for(const child of children)if(child(frame))return!0;return!1}},getOptionsDisplayText:options=>{let text="";for(const sub of options){text.length>0&&(text+=" OR ");const matcher=frameMatchers.get(sub.id);text+=matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(sub):matcher.name}return text}},allFieldsMatcher={id:ids.cV.allMatch,name:"All",description:"Everything matches (AND)",excludeFromPicker:!0,defaultOptions:[],get:options=>{const children=options.map((option=>getFieldMatcher(option)));return(field,frame,allFrames)=>{for(const child of children)if(!child(field,frame,allFrames))return!1;return!0}},getOptionsDisplayText:options=>{let text="";for(const sub of options){text.length>0&&(text+=" AND ");const matcher=fieldMatchers.get(sub.id);text+=matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(sub):matcher.name}return text}},allFramesMatcher={id:ids.cV.allMatch,name:"All",description:"Everything matches (AND)",excludeFromPicker:!0,defaultOptions:[],get:options=>{const children=options.map((option=>getFrameMatchers(option)));return frame=>{for(const child of children)if(!child(frame))return!1;return!0}},getOptionsDisplayText:options=>{let text="";for(const sub of options){text.length>0&&(text+=" AND ");const matcher=frameMatchers.get(sub.id);text+=matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(sub):matcher.name}return text}},notFieldMatcher={id:ids.cV.invertMatch,name:"NOT",description:"Inverts other matchers",excludeFromPicker:!0,get:option=>{const check=getFieldMatcher(option);return(field,frame,allFrames)=>!check(field,frame,allFrames)},getOptionsDisplayText:options=>{const matcher=fieldMatchers.get(options.id);return"NOT "+(matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(options.options):matcher.name)}},notFrameMatcher={id:ids.cV.invertMatch,name:"NOT",description:"Inverts other matchers",excludeFromPicker:!0,get:option=>{const check=getFrameMatchers(option);return frame=>!check(frame)},getOptionsDisplayText:options=>{const matcher=frameMatchers.get(options.id);return"NOT "+(matcher.getOptionsDisplayText?matcher.getOptionsDisplayText(options.options):matcher.name)}},alwaysFieldMatcher=field=>!0,alwaysFrameMatcher=frame=>!0,neverFieldMatcher=field=>!1,neverFrameMatcher=frame=>!1,alwaysFieldMatcherInfo={id:ids.cV.alwaysMatch,name:"All Fields",description:"Always Match",get:_option=>alwaysFieldMatcher,getOptionsDisplayText:_options=>"Always"},alwaysFrameMatcherInfo={id:ids.cV.alwaysMatch,name:"All Frames",description:"Always Match",get:_option=>alwaysFrameMatcher,getOptionsDisplayText:_options=>"Always"},neverFieldMatcherInfo={id:ids.cV.neverMatch,name:"No Fields",description:"Never Match",excludeFromPicker:!0,get:_option=>neverFieldMatcher,getOptionsDisplayText:_options=>"Never"},neverFrameMatcherInfo={id:ids.cV.neverMatch,name:"No Frames",description:"Never Match",get:_option=>neverFrameMatcher,getOptionsDisplayText:_options=>"Never"};const refIdMatcher={id:ids.jR.byRefId,name:"Query refId",description:"match the refId",defaultOptions:"A",get:pattern=>{let regex=null;if((0,string.AP)(pattern))try{regex=(0,string.dO)(pattern)}catch(error){error instanceof Error&&console.warn(error.message)}else if(pattern.includes("|")){const escapedUnion=pattern.split("|").map(string.jD).join("|");regex=new RegExp(`^(?:${escapedUnion})$`)}return frame=>regex?.test(frame.refId||"")??frame.refId===pattern},getOptionsDisplayText:pattern=>`RefID: ${pattern}`};const firstFieldMatcher={id:ids.Ct.first,name:"First Field",description:"The first field in the frame",get:type=>(field,frame,allFrames)=>field===frame.fields[0],getOptionsDisplayText:()=>"First field"},firstTimeFieldMatcher={id:ids.Ct.firstTimeField,name:"First time field",description:"The first field of type time in a frame",get:type=>(field,frame,allFrames)=>field.type===dataFrame.PU.time&&field===frame.fields.find((f=>f.type===dataFrame.PU.time)),getOptionsDisplayText:()=>"First time field"};const isEqualValueMatcher={id:ids.Js.equal,name:"Is equal",description:"Match where value for given field is equal to options value.",get:options=>(valueIndex,field)=>field.values[valueIndex]==options.value,getOptionsDisplayText:()=>"Matches all rows where field is null.",isApplicable:()=>!0,getDefaultOptions:()=>({value:""})},isNotEqualValueMatcher={id:ids.Js.notEqual,name:"Is not equal",description:"Match where value for given field is not equal to options value.",get:options=>(valueIndex,field)=>field.values[valueIndex]!=options.value,getOptionsDisplayText:()=>"Matches all rows where field is not null.",isApplicable:()=>!0,getDefaultOptions:()=>({value:""})},isNullValueMatcher={id:ids.Js.isNull,name:"Is null",description:"Match where value for given field is null.",get:()=>(valueIndex,field)=>null==field.values[valueIndex],getOptionsDisplayText:()=>"Matches all rows where field is null.",isApplicable:()=>!0,getDefaultOptions:()=>({})},isNotNullValueMatcher={id:ids.Js.isNotNull,name:"Is not null",description:"Match where value for given field is not null.",get:()=>(valueIndex,field)=>null!=field.values[valueIndex],getOptionsDisplayText:()=>"Matches all rows where field is not null.",isApplicable:()=>!0,getDefaultOptions:()=>({})},isGreaterValueMatcher={id:ids.Js.greater,name:"Is greater",description:"Match when field value is greater than option.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return!isNaN(value)&&value>options.value},getOptionsDisplayText:options=>`Matches all rows where field value is greater than: ${options.value}.`,isApplicable:field=>field.type===dataFrame.PU.number,getDefaultOptions:()=>({value:0})},isGreaterOrEqualValueMatcher={id:ids.Js.greaterOrEqual,name:"Is greater or equal",description:"Match when field value is greater than or equal to option.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return!isNaN(value)&&value>=options.value},getOptionsDisplayText:options=>`Matches all rows where field value is greater than or equal to: ${options.value}.`,isApplicable:field=>field.type===dataFrame.PU.number,getDefaultOptions:()=>({value:0})},isLowerValueMatcher={id:ids.Js.lower,name:"Is lower",description:"Match when field value is lower than option.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return!isNaN(value)&&value<options.value},getOptionsDisplayText:options=>`Matches all rows where field value is lower than: ${options.value}.`,isApplicable:field=>field.type===dataFrame.PU.number,getDefaultOptions:()=>({value:0})},isLowerOrEqualValueMatcher={id:ids.Js.lowerOrEqual,name:"Is lower or equal",description:"Match when field value is lower or equal than option.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return!isNaN(value)&&value<=options.value},getOptionsDisplayText:options=>`Matches all rows where field value is lower or equal than: ${options.value}.`,isApplicable:field=>field.type===dataFrame.PU.number,getDefaultOptions:()=>({value:0})},isBetweenValueMatcher={id:ids.Js.between,name:"Is between",description:"Match when field value is between given option values.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return!isNaN(value)&&(value>options.from&&value<options.to)},getOptionsDisplayText:options=>`Matches all rows where field value is between ${options.from} and ${options.to}.`,isApplicable:field=>field.type===dataFrame.PU.number,getDefaultOptions:()=>({from:0,to:100})},regexValueMatcher={id:ids.Js.regex,name:"Regex",description:"Match when field value is matching regex.",get:options=>{const regex=new RegExp(options.value);return(valueIndex,field)=>{const value=field.values[valueIndex];return regex.test(value)}},getOptionsDisplayText:options=>`Matches all rows where field value is matching regex: ${options.value}`,isApplicable:()=>!0,getDefaultOptions:()=>({value:".*"})},isSubstringMatcher={id:ids.Js.substring,name:"Contains substring",description:"Match where value for given field is a substring to options value.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return value&&options.value&&"string"==typeof value&&value.toLowerCase().includes(options.value.toLowerCase())||""===options.value},getOptionsDisplayText:()=>"Matches all rows where field is similar to the value.",isApplicable:field=>field.type===dataFrame.PU.string,getDefaultOptions:()=>({value:""})},isNotSubstringValueMatcher={id:ids.Js.notSubstring,name:"Does not contain substring",description:"Match where value for given field is not a substring to options value.",get:options=>(valueIndex,field)=>{const value=field.values[valueIndex];return"string"==typeof value&&options.value&&value&&""!==options.value&&!value.toLowerCase().includes(options.value.toLowerCase())},getOptionsDisplayText:()=>"Matches all rows where field is not similar to the value.",isApplicable:field=>field.type===dataFrame.PU.string,getDefaultOptions:()=>({value:""})},fieldMatchers=new Registry.O((()=>[anyFieldMatcher,allFieldsMatcher,notFieldMatcher,alwaysFieldMatcherInfo,neverFieldMatcherInfo,fieldTypeMatcher,fieldTypesMatcher,numericMatcher,timeMatcher,fieldNameMatcher,regexpFieldNameMatcher,multipleFieldNamesMatcher,regexpOrMultipleNamesMatcher,fieldsInFrameMatcher,firstFieldMatcher,firstTimeFieldMatcher,fieldValueMatcherInfo])),frameMatchers=new Registry.O((()=>[anyFrameMatcher,allFramesMatcher,notFrameMatcher,alwaysFrameMatcherInfo,neverFrameMatcherInfo,frameNameMatcher,refIdMatcher]));new Registry.O((()=>[isNullValueMatcher,isNotNullValueMatcher,isGreaterValueMatcher,isGreaterOrEqualValueMatcher,isLowerValueMatcher,isLowerOrEqualValueMatcher,isEqualValueMatcher,isNotEqualValueMatcher,isSubstringMatcher,isNotSubstringValueMatcher,isBetweenValueMatcher,regexValueMatcher]));function getFieldMatcher(config){const info=fieldMatchers.get(config.id);if(!info)throw new Error("Unknown field matcher: "+config.id);return info.get(config.options)}function getFrameMatchers(config){const info=frameMatchers.get(config.id);if(!info)throw new Error("Unknown frame matcher: "+config.id);return info.get(config.options)}},"../grafana-data/src/transformations/matchers/ids.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{Ct:function(){return FieldMatcherID},Js:function(){return ValueMatcherID},cV:function(){return MatcherID},jR:function(){return FrameMatcherID}});var MatcherID=function(MatcherID){return MatcherID.anyMatch="anyMatch",MatcherID.allMatch="allMatch",MatcherID.invertMatch="invertMatch",MatcherID.alwaysMatch="alwaysMatch",MatcherID.neverMatch="neverMatch",MatcherID}({}),FieldMatcherID=function(FieldMatcherID){return FieldMatcherID.numeric="numeric",FieldMatcherID.time="time",FieldMatcherID.first="first",FieldMatcherID.firstTimeField="firstTimeField",FieldMatcherID.byType="byType",FieldMatcherID.byTypes="byTypes",FieldMatcherID.byName="byName",FieldMatcherID.byNames="byNames",FieldMatcherID.byRegexp="byRegexp",FieldMatcherID.byRegexpOrNames="byRegexpOrNames",FieldMatcherID.byFrameRefID="byFrameRefID",FieldMatcherID.byValue="byValue",FieldMatcherID}({}),FrameMatcherID=function(FrameMatcherID){return FrameMatcherID.byName="byName",FrameMatcherID.byRefId="byRefId",FrameMatcherID.byIndex="byIndex",FrameMatcherID}({}),ValueMatcherID=function(ValueMatcherID){return ValueMatcherID.regex="regex",ValueMatcherID.isNull="isNull",ValueMatcherID.isNotNull="isNotNull",ValueMatcherID.greater="greater",ValueMatcherID.greaterOrEqual="greaterOrEqual",ValueMatcherID.lower="lower",ValueMatcherID.lowerOrEqual="lowerOrEqual",ValueMatcherID.equal="equal",ValueMatcherID.notEqual="notEqual",ValueMatcherID.substring="substring",ValueMatcherID.notSubstring="notSubstring",ValueMatcherID.between="between",ValueMatcherID}({})},"./src/components/Sparkline/Sparkline.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{O:function(){return Sparkline}});var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),lodash=__webpack_require__("../../node_modules/lodash/lodash.js"),react=__webpack_require__("../../node_modules/react/index.js");function nullToValueField(field,noValue){const transformedVals=field.values.slice();for(let i=0;i<transformedVals.length;i++)null===transformedVals[i]&&(transformedVals[i]=noValue);return{...field,values:transformedVals}}const defaultCmp=(a,b)=>a===b;function shallowCompare(a,b,cmp=defaultCmp){if(a===b)return!0;if(Object.keys(a).length!==Object.keys(b).length)return!1;let key;for(key in a)if(!cmp(a[key],b[key]))return!1;return!0}var dataFrame=__webpack_require__("../grafana-data/src/types/dataFrame.ts"),fieldColor=__webpack_require__("../grafana-data/src/field/fieldColor.ts"),common_gen=__webpack_require__("../grafana-schema/src/common/common.gen.ts"),uPlot_esm=__webpack_require__("../../node_modules/uplot/dist/uPlot.esm.js"),map=__webpack_require__("../../node_modules/rxjs/dist/esm5/internal/operators/map.js"),parser=__webpack_require__("../grafana-data/src/datetime/parser.ts"),matchers=__webpack_require__("../grafana-data/src/transformations/matchers.ts"),ids=__webpack_require__("../grafana-data/src/transformations/matchers/ids.ts"),DataTransformerID=function(DataTransformerID){return DataTransformerID.append="append",DataTransformerID.reduce="reduce",DataTransformerID.order="order",DataTransformerID.organize="organize",DataTransformerID.rename="rename",DataTransformerID.calculateField="calculateField",DataTransformerID.seriesToColumns="seriesToColumns",DataTransformerID.seriesToRows="seriesToRows",DataTransformerID.merge="merge",DataTransformerID.concatenate="concatenate",DataTransformerID.labelsToFields="labelsToFields",DataTransformerID.filterFields="filterFields",DataTransformerID.filterFieldsByName="filterFieldsByName",DataTransformerID.filterFrames="filterFrames",DataTransformerID.filterByRefId="filterByRefId",DataTransformerID.renameByRegex="renameByRegex",DataTransformerID.filterByValue="filterByValue",DataTransformerID.noop="noop",DataTransformerID.ensureColumns="ensureColumns",DataTransformerID.groupBy="groupBy",DataTransformerID.sortBy="sortBy",DataTransformerID.histogram="histogram",DataTransformerID.configFromData="configFromData",DataTransformerID.rowsToFields="rowsToFields",DataTransformerID.prepareTimeSeries="prepareTimeSeries",DataTransformerID.convertFieldType="convertFieldType",DataTransformerID.fieldLookup="fieldLookup",DataTransformerID.heatmap="heatmap",DataTransformerID.spatial="spatial",DataTransformerID.joinByField="joinByField",DataTransformerID.joinByLabels="joinByLabels",DataTransformerID.extractFields="extractFields",DataTransformerID.groupingToMatrix="groupingToMatrix",DataTransformerID.limit="limit",DataTransformerID.partitionByValues="partitionByValues",DataTransformerID.timeSeriesTable="timeSeriesTable",DataTransformerID.transpose="transpose",DataTransformerID.formatTime="formatTime",DataTransformerID.formatString="formatString",DataTransformerID.regression="regression",DataTransformerID.groupToNestedTable="groupToNestedTable",DataTransformerID}({});const convertFieldTypeTransformer={id:DataTransformerID.convertFieldType,name:"Convert field type",description:"Convert a field to a specified field type.",defaultOptions:{fields:{},conversions:[{targetField:void 0,destinationType:void 0,dateFormat:void 0,timezone:void 0}]},operator:(options,ctx)=>source=>source.pipe((0,map.T)((data=>convertFieldTypeTransformer.transformer(options,ctx)(data)))),transformer:options=>data=>Array.isArray(data)&&0!==data.length?function convertFieldTypes(options,frames){if(!options.conversions.length)return frames;const framesCopy=frames.map((frame=>({...frame})));for(const conversion of options.conversions){if(!conversion.targetField)continue;const matches=matchers.sJ.get(ids.Ct.byName).get(conversion.targetField);for(const frame of framesCopy)frame.fields=frame.fields.map((field=>matches(field,frame,framesCopy)?convertFieldType(field,conversion):field))}return framesCopy}(options,data)??[]:data};function convertFieldType(field,opts){switch(opts.destinationType){case dataFrame.PU.time:return ensureTimeField(field,opts.dateFormat);case dataFrame.PU.number:return function fieldToNumberField(field){const numValues=field.values.slice(),valuesAsStrings=numValues.some((v=>"string"==typeof v));for(let n=0;n<numValues.length;n++){let toBeConverted=numValues[n];valuesAsStrings&&null!=toBeConverted&&"string"==typeof toBeConverted&&(toBeConverted=toBeConverted.replace(/,/g,""));const number=+toBeConverted;numValues[n]=Number.isFinite(number)?number:null}return{...field,type:dataFrame.PU.number,values:numValues}}(field);case dataFrame.PU.string:return function fieldToStringField(field,dateFormat,parseOptions,joinWith){let values=field.values;switch(field.type){case dataFrame.PU.time:values=values.map((v=>(0,parser.b)(v,parseOptions).format(dateFormat)));break;case dataFrame.PU.other:values=values.map((v=>joinWith?.length&&Array.isArray(v)?v.join(joinWith):JSON.stringify(v)));break;default:values=values.map((v=>`${v}`))}return{...field,type:dataFrame.PU.string,values:values}}(field,opts.dateFormat,{timeZone:opts.timezone},opts.joinWith);case dataFrame.PU.boolean:return function fieldToBooleanField(field){const booleanValues=field.values.slice();for(let b=0;b<booleanValues.length;b++)booleanValues[b]=Boolean(!!booleanValues[b]);return{...field,type:dataFrame.PU.boolean,values:booleanValues}}(field);case dataFrame.PU.enum:return function fieldToEnumField(field,config){const enumConfig={...config},enumValues=field.values.slice(),lookup=new Map;if(!(enumConfig.text&&enumConfig.text.length>0))return field;for(let i=0;i<enumConfig.text.length;i++)lookup.set(enumConfig.text[i],i);for(let i=0;i<enumValues.length;i++){const value=enumValues[i];enumValues[i]=lookup.get(value)}return{...field,config:{...field.config,type:{enum:enumConfig}},type:dataFrame.PU.enum,values:enumValues}}(field,opts.enumConfig);case dataFrame.PU.other:return function fieldToComplexField(field){const complexValues=field.values.slice();for(let s=0;s<complexValues.length;s++)try{complexValues[s]=JSON.parse(complexValues[s])}catch{complexValues[s]=null}return{...field,type:dataFrame.PU.other,values:complexValues}}(field);default:return field}}const iso8601Regex=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{3,})?(?:Z|[-+]\d{2}:?\d{2})$/;function ensureTimeField(field,dateFormat){const firstValueTypeIsNumber="number"==typeof field.values[0],isUnixSecondsFormat="X"===dateFormat;return field.type===dataFrame.PU.time&&firstValueTypeIsNumber?field:firstValueTypeIsNumber&&!isUnixSecondsFormat?{...field,type:dataFrame.PU.time}:function fieldToTimeField(field,dateFormat){let opts=dateFormat?{format:dateFormat}:void 0;const timeValues=field.values.slice();let firstDefined=timeValues.find((v=>null!=v));const convertToMS="number"==typeof firstDefined&&"X"===dateFormat,isISO8601="string"==typeof firstDefined&&iso8601Regex.test(firstDefined);for(let t=0;t<timeValues.length;t++)if(timeValues[t]){let parsed=isISO8601?Date.parse(timeValues[t]):(0,parser.b)(timeValues[t],opts).valueOf();Number.isFinite(parsed)?timeValues[t]=convertToMS?1e3*parsed:parsed:timeValues[t]=null}else timeValues[t]=null;return{...field,type:dataFrame.PU.time,values:timeValues}}(field,dateFormat)}(0,lodash.throttle)(((...t)=>{console.log(...t)}),500);class PlotConfigBuilder{props;constructor(props){this.props=props}}function buildScaleKey(config,fieldType){const scaleRange=`${void 0!==config.min?config.min:"na"}-${void 0!==config.max?config.max:"na"}`,scaleSoftRange=`${void 0!==config.custom?.axisSoftMin?config.custom.axisSoftMin:"na"}-${void 0!==config.custom?.axisSoftMax?config.custom.axisSoftMax:"na"}`,scalePlacement=`${void 0!==config.custom?.axisPlacement?config.custom?.axisPlacement:common_gen.vM.Auto}`,scaleUnit=config.unit??"__fixed",scaleDistribution=config.custom?.scaleDistribution?function getScaleDistributionPart(config){if(config.type===common_gen.L4.Log)return`${config.type}${config.log}`;return config.type}(config.custom.scaleDistribution):common_gen.L4.Linear;return`${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${Boolean(config.custom?.axisLabel)?config.custom.axisLabel:"na"}/${fieldType}`}const paddingSide=(u,side,sidesWithAxes)=>{let hasCrossAxis=side%2?sidesWithAxes[0]||sidesWithAxes[2]:sidesWithAxes[1]||sidesWithAxes[3];return sidesWithAxes[side]||!hasCrossAxis?0:8},DEFAULT_PLOT_CONFIG={ms:1,focus:{alpha:1},cursor:{focus:{prox:30}},legend:{show:!1},padding:[paddingSide,paddingSide,paddingSide,paddingSide],series:[],hooks:{}};function getStackingGroups(frame){let groups=new Map;return frame.fields.forEach((({config:config,values:values,type:type},i)=>{if(0===i)return;let{custom:custom}=config;if(null==custom)return;if(custom.hideFrom?.viz)return;let{stacking:stacking}=custom;if(null==stacking)return;let{mode:stackingMode,group:stackingGroup}=stacking;if(stackingMode===common_gen.gs.None)return;let stackDir=function getStackDirection(transform,data){const hasNegSamp=function hasNegSample(data,samples=100){const len=data.length;if(0===len)return!1;let firstIdx=0,lastIdx=len-1;for(;firstIdx<=lastIdx&&null==data[firstIdx];)firstIdx++;for(;lastIdx>=firstIdx&&null==data[lastIdx];)lastIdx--;let negCount=0,posCount=0;if(lastIdx>=firstIdx){const stride=Math.max(1,Math.floor((lastIdx-firstIdx+1)/samples));for(let i=firstIdx;i<=lastIdx;i+=stride){const v=data[i];null!=v&&"number"==typeof v&&(v<0||Object.is(v,-0)?negCount++:v>0&&posCount++)}if(negCount>posCount)return!0}return!1}(data);if(transform===common_gen.NU.NegativeY)return hasNegSamp?1:-1;return hasNegSamp?-1:1}(custom.transform,values),drawStyle=custom.drawStyle,drawStyle2=drawStyle===common_gen.GR.Bars?custom.barAlignment:drawStyle===common_gen.GR.Line?custom.lineInterpolation:null,stackKey=`${stackDir}|${stackingMode}|${stackingGroup}|${buildScaleKey(config,type)}|${drawStyle}|${drawStyle2}`,group=groups.get(stackKey);null==group&&(group={series:[],dir:stackDir},groups.set(stackKey,group)),group.series.push(i)})),[...groups.values()]}function preparePlotData2(frame,stackingGroups,onStackMeta){let data=Array(frame.fields.length),stacksQty=stackingGroups.length,dataLen=frame.length,zeroArr=stacksQty>0?Array(dataLen).fill(0):[],falseArr=stacksQty>0?Array(dataLen).fill(!1):[],accums=Array.from({length:stacksQty},(()=>zeroArr.slice())),anyValsAtX=Array.from({length:stacksQty},(()=>falseArr.slice()));if(stackingGroups.forEach(((group,groupIdx)=>{let groupValsAtX=anyValsAtX[groupIdx];group.series.forEach((seriesIdx=>{let field=frame.fields[seriesIdx];if(field.config.custom?.hideFrom?.viz)return;let vals=field.values;for(let i=0;i<dataLen;i++)null!=vals[i]&&(groupValsAtX[i]=!0)}))})),frame.fields.forEach(((field,i)=>{let vals=field.values;if(0===i)return void(field.type===dataFrame.PU.time?data[0]=ensureTimeField(field).values:data[0]=vals);let{custom:custom}=field.config;if(!custom||custom.hideFrom?.viz)return void(data[i]=vals);if(custom.transform===common_gen.NU.Constant){let firstValIdx=vals.findIndex((v=>null!=v)),firstVal=vals[firstValIdx];vals=Array(vals.length).fill(void 0),vals[firstValIdx]=firstVal}else if(vals=vals.slice(),custom.transform===common_gen.NU.NegativeY)for(let i=0;i<vals.length;i++)null!=vals[i]&&(vals[i]*=-1);let stackingMode=custom.stacking?.mode;if(stackingMode&&stackingMode!==common_gen.gs.None){let stackIdx=stackingGroups.findIndex((group=>group.series.indexOf(i)>-1)),accum=accums[stackIdx],groupValsAtX=anyValsAtX[stackIdx],stacked=data[i]=Array(dataLen);for(let i=0;i<dataLen;i++){let v=vals[i];stacked[i]=null!=v?accum[i]+=v:groupValsAtX[i]?accum[i]:v}}else data[i]=vals})),onStackMeta){onStackMeta({totals:data.map(((vals,i)=>{let stackIdx=stackingGroups.findIndex((group=>group.series.indexOf(i)>-1));return-1!==stackIdx?accums[stackIdx]:vals}))})}return frame.fields.forEach(((field,i)=>{if(0===i||field.config.custom?.hideFrom?.viz)return;let stackingMode=field.config.custom?.stacking?.mode;if(stackingMode===common_gen.gs.Percent){let stackIdx=stackingGroups.findIndex((group=>group.series.indexOf(i)>-1)),accum=accums[stackIdx],group=stackingGroups[stackIdx],stacked=data[i];for(let i=0;i<dataLen;i++){let v=stacked[i];null!=v&&(stacked[i]=0===accum[i]?0:group.dir*(v/accum[i]))}}})),data}const pluginLogger=(()=>{let loggingEnabled=!1;return"undefined"!=typeof window&&(loggingEnabled="true"===window.localStorage.getItem("grafana.debug")),{logger:(id,throttle=!1,...t)=>{},enable:()=>loggingEnabled=!0,disable:()=>loggingEnabled=!1,isEnabled:()=>loggingEnabled}})(),pluginLog=pluginLogger.logger;__webpack_require__("../../node_modules/uplot/dist/uPlot.min.css");class UPlotChart extends react.Component{plotContainer=(0,react.createRef)();plotCanvasBBox=(0,react.createRef)();plotInstance=null;constructor(props){super(props)}reinitPlot(){let{width:width,height:height,plotRef:plotRef}=this.props;if(this.plotInstance?.destroy(),0===width&&0===height)return;this.props.config.addHook("setSize",(u=>{u.over}));const config={width:Math.floor(this.props.width),height:Math.floor(this.props.height),...this.props.config.getConfig()};pluginLog("UPlot",!1,"Reinitializing plot",config);const plot=new uPlot_esm.A(config,this.props.data,this.plotContainer.current);plotRef&&plotRef(plot),this.plotInstance=plot}componentDidMount(){this.reinitPlot()}componentWillUnmount(){this.plotInstance?.destroy()}componentDidUpdate(prevProps){!function sameDims(prevProps,nextProps){return nextProps.width===prevProps.width&&nextProps.height===prevProps.height}(prevProps,this.props)?this.plotInstance?.setSize({width:Math.floor(this.props.width),height:Math.floor(this.props.height)}):!function sameConfig(prevProps,nextProps){return nextProps.config===prevProps.config}(prevProps,this.props)?this.reinitPlot():function sameData(prevProps,nextProps){return nextProps.data===prevProps.data}(prevProps,this.props)||this.plotInstance?.setData(this.props.data)}render(){return(0,jsx_runtime.jsxs)("div",{style:{position:"relative"},children:[(0,jsx_runtime.jsx)("div",{ref:this.plotContainer,"data-testid":"uplot-main-div"}),this.props.children]})}}try{UPlotChart.displayName="UPlotChart",UPlotChart.__docgenInfo={description:"",displayName:"UPlotChart",props:{data:{defaultValue:null,description:"",name:"data",required:!0,type:{name:"AlignedData | [_: null, ...series: FacetValues[]]"}},width:{defaultValue:null,description:"",name:"width",required:!0,type:{name:"number"}},height:{defaultValue:null,description:"",name:"height",required:!0,type:{name:"number"}},config:{defaultValue:null,description:"",name:"config",required:!0,type:{name:"UPlotConfigBuilder"}},plotRef:{defaultValue:null,description:"",name:"plotRef",required:!1,type:{name:"((u: uPlot) => void)"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/uPlot/Plot.tsx#UPlotChart"]={docgenInfo:UPlotChart.__docgenInfo,name:"UPlotChart",path:"src/components/uPlot/Plot.tsx#UPlotChart"})}catch(__react_docgen_typescript_loader_error){}var time=__webpack_require__("../grafana-data/src/types/time.ts"),timezones=__webpack_require__("../grafana-data/src/datetime/timezones.ts"),valueFormats=__webpack_require__("../grafana-data/src/valueFormats/valueFormats.ts");function numbers_roundDecimals(val,dec=0){if(Number.isInteger(val))return val;let p=10**dec,n=val*p*(1+Number.EPSILON);return Math.round(n)/p}var formats=__webpack_require__("../grafana-data/src/datetime/formats.ts"),formatter=__webpack_require__("../grafana-data/src/datetime/formatter.ts"),measureText=__webpack_require__("./src/utils/measureText.ts"),displayProcessor=__webpack_require__("../grafana-data/src/field/displayProcessor.ts"),createTheme=__webpack_require__("../grafana-data/src/themes/createTheme.ts"),dataFrameTypes_DataFrameType=function(DataFrameType){return DataFrameType.TimeSeriesWide="timeseries-wide",DataFrameType.TimeSeriesLong="timeseries-long",DataFrameType.TimeSeriesMany="timeseries-many",DataFrameType.TimeSeriesMulti="timeseries-multi",DataFrameType.NumericWide="numeric-wide",DataFrameType.NumericMulti="numeric-multi",DataFrameType.NumericLong="numeric-long",DataFrameType.LogLines="log-lines",DataFrameType.DirectoryListing="directory-listing",DataFrameType.HeatmapRows="heatmap-rows",DataFrameType.HeatmapCells="heatmap-cells",DataFrameType.Histogram="histogram",DataFrameType}({}),processDataFrame=__webpack_require__("../grafana-data/src/dataframe/processDataFrame.ts"),JoinMode=function(JoinMode){return JoinMode.outer="outer",JoinMode.inner="inner",JoinMode.outerTabular="outerTabular",JoinMode}({});const joinByFieldTransformer={id:DataTransformerID.joinByField,aliasIds:[DataTransformerID.seriesToColumns],name:"Join by field",description:"Combine rows from two or more tables, based on a related field between them.  This can be used to outer join multiple time series on the _time_ field to show many time series in one table.",defaultOptions:{byField:void 0,mode:"outer"},operator:(options,ctx)=>source=>source.pipe((0,map.T)((data=>joinByFieldTransformer.transformer(options,ctx)(data)))),transformer:(options,ctx)=>{let joinBy;return data=>{if(data.length>1){options.byField&&!joinBy&&(joinBy=matchers.sJ.get(ids.Ct.byName).get(options.byField));const joined=function joinDataFrames(options){if(!options.frames?.length)return;const nullMode=options.nullMode??(field=>{let spanNulls=field.config.custom?.spanNulls;return!0===spanNulls?NULL_REMOVE:-1===spanNulls?NULL_RETAIN:NULL_EXPAND});if(1===options.frames.length){let frame=options.frames[0],frameCopy=frame;const joinFieldMatcher=getJoinMatcher(options);let joinIndex=frameCopy.fields.findIndex((f=>joinFieldMatcher(f,frameCopy,options.frames)));if(options.keepOriginIndices&&(frameCopy={...frame,fields:frame.fields.map(((f,fieldIndex)=>{const copy={...f},origin={frameIndex:0,fieldIndex:fieldIndex};return copy.state?copy.state.origin=origin:copy.state={origin:origin},copy}))},joinIndex>0)){const joinField=frameCopy.fields[joinIndex],fields=frameCopy.fields.filter(((f,idx)=>idx!==joinIndex));fields.unshift(joinField),frameCopy.fields=fields,joinIndex=0}if(joinIndex>=0&&(frameCopy=function maybeSortFrame(frame,fieldIdx){if(fieldIdx>=0){let sortByField=frame.fields[fieldIdx];sortByField.type===dataFrame.PU.string||isLikelyAscendingVector(sortByField.values)||(frame=(0,processDataFrame.ES)(frame,fieldIdx))}return frame}(frameCopy,joinIndex)),options.keep){let fields=frameCopy.fields.filter(((f,fieldIdx)=>fieldIdx===joinIndex||options.keep(f,frameCopy,options.frames)));frame!==frameCopy?frameCopy.fields=fields:frameCopy={...frame,fields:fields}}return frameCopy}const nullModes=[],allData=[],originalFields=[],originalFieldsOrderByFrame=[];let fieldsOrder=1;const joinFieldMatcher=getJoinMatcher(options);for(let frameIndex=0;frameIndex<options.frames.length;frameIndex++){const frame=options.frames[frameIndex];if(!frame||!frame.fields?.length)continue;const nullModesFrame=[NULL_REMOVE];let join,fields=[],frameFieldsOrder=[];for(let fieldIndex=0;fieldIndex<frame.fields.length;fieldIndex++){const field=frame.fields[fieldIndex];if(field.state=field.state||{},!join&&joinFieldMatcher(field,frame,options.frames))join=field;else{if(options.keep&&!options.keep(field,frame,options.frames))continue;nullModesFrame.push(nullMode(field));let labels=field.labels??{},name=field.name;frame.name&&(field.name===dataFrame.Bc?name=frame.name:null==labels.name&&(labels={...labels,name:frame.name})),fields.push({...field,name:name,labels:labels})}options.keepOriginIndices&&(field.state.origin={frameIndex:frameIndex,fieldIndex:fieldIndex})}if(!join)continue;0===originalFields.length&&originalFields.push(join),nullModes.push(nullModesFrame);const a=[join.values];for(const field of fields)a.push(field.values),originalFields.push(field),options.keepDisplayNames||delete field.state?.displayName,frameFieldsOrder.push(fieldsOrder),fieldsOrder++;originalFieldsOrderByFrame.push(frameFieldsOrder),allData.push(a)}let joined=[];joined=options.mode===JoinMode.outerTabular?function joinOuterTabular(tables,originalFieldsOrderByFrame,numberOfFields,nullModes){let duplicateHash={};for(let tableIdx=0;tableIdx<tables.length;tableIdx++){let table=tables[tableIdx],joinOnTableField=table[0];for(let otherTablesIdx=0;otherTablesIdx<tables.length;otherTablesIdx++){if(otherTablesIdx===tableIdx)continue;let otherTable=tables[otherTablesIdx],otherTableJoinOnField=otherTable[0];for(let joinTableFieldValuesIdx=0;joinTableFieldValuesIdx<joinOnTableField.length;joinTableFieldValuesIdx++){let joinedRow=[joinOnTableField[joinTableFieldValuesIdx]].concat(new Array(numberOfFields-1)),tableFieldValIdx=0;for(let fieldsIdx=1;fieldsIdx<table.length;fieldsIdx++){joinedRow[originalFieldsOrderByFrame[tableIdx][tableFieldValIdx]]=table[fieldsIdx][joinTableFieldValuesIdx],tableFieldValIdx++}for(let otherTableValuesIdx=0;otherTableValuesIdx<otherTableJoinOnField.length;otherTableValuesIdx++)if(joinOnTableField[joinTableFieldValuesIdx]===otherTableJoinOnField[otherTableValuesIdx]){let tableFieldValIdx=0;for(let fieldsIdx=1;fieldsIdx<otherTable.length;fieldsIdx++){joinedRow[originalFieldsOrderByFrame[otherTablesIdx][tableFieldValIdx]]=otherTable[fieldsIdx][otherTableValuesIdx],tableFieldValIdx++}break}duplicateHash[JSON.stringify(joinedRow)]=joinedRow}}}let data=[];for(let field=0;field<numberOfFields;field++)data.push(new Array(0));for(let key in duplicateHash){const row=duplicateHash[key];for(let valIdx=0;valIdx<row.length;valIdx++)data[valIdx].push(row[valIdx])}return data}(allData,originalFieldsOrderByFrame,originalFields.length):options.mode===JoinMode.inner?function joinInner(tables){const joinedTables=[],joinTables=(currentTables,currentIndex,currentRow)=>{if(currentIndex===currentTables.length)return void joinedTables.push(currentRow);const currentTable=currentTables[currentIndex],[xValues,...yValues]=currentTable;for(let i=0;i<xValues.length;i++){const value=xValues[i];if(0===currentIndex||currentRow.includes(value)){const newRow=[...currentRow];0===currentIndex&&newRow.push(value);for(let j=0;j<yValues.length;j++)newRow.push(yValues[j][i]);joinTables(currentTables,currentIndex+1,newRow)}}};if(joinTables(tables,0,[]),0===joinedTables.length){const fieldCount=tables.reduce(((count,table)=>count+(table.length-1)),1);return Array.from({length:fieldCount},(()=>[]))}return joinedTables[0].map(((_,colIndex)=>joinedTables.map((row=>row[colIndex]))))}(allData):join(allData,nullModes,options.mode);return{length:joined[0]?joined[0].length:0,fields:originalFields.map(((f,index)=>({...f,values:joined[index]})))}}({frames:data,joinBy:joinBy,mode:options.mode});if(joined)return joined.refId=`${DataTransformerID.joinByField}-${data.map((frame=>frame.refId)).join("-")}`,[joined]}return data}}};function getJoinMatcher(options){return options.joinBy??function pickBestJoinField(data){const{timeField:timeField}=(0,processDataFrame.KR)(data[0]);if(timeField)return matchers.sJ.get(ids.Ct.firstTimeField).get({});let common=[];for(const f of data[0].fields)f.type===dataFrame.PU.number&&common.push(f.name);for(let i=1;i<data.length;i++){const names=[];for(const f of data[0].fields)f.type===dataFrame.PU.number&&names.push(f.name);common=common.filter((v=>!names.includes(v)))}return matchers.sJ.get(ids.Ct.byName).get(common[0])}(options.frames)}const NULL_REMOVE=0,NULL_RETAIN=1,NULL_EXPAND=2;function nullExpand(yVals,nullIdxs,alignedLen){for(let xi,i=0,lastNullIdx=-1;i<nullIdxs.length;i++){let nullIdx=nullIdxs[i];if(nullIdx>lastNullIdx){for(xi=nullIdx-1;xi>=0&&null==yVals[xi];)yVals[xi--]=null;for(xi=nullIdx+1;xi<alignedLen&&null==yVals[xi];)yVals[lastNullIdx=xi++]=null}}}function join(tables,nullModes,mode=JoinMode.outer){let xVals=new Set;for(let ti=0;ti<tables.length;ti++){let xs=tables[ti][0],len=xs.length;for(let i=0;i<len;i++)xVals.add(xs[i])}let data=[Array.from(xVals).sort(((a,b)=>a-b))],alignedLen=data[0].length,xIdxs=new Map;for(let i=0;i<alignedLen;i++)xIdxs.set(data[0][i],i);for(let ti=0;ti<tables.length;ti++){let t=tables[ti],xs=t[0];for(let si=1;si<t.length;si++){let ys=t[si],yVals=Array(alignedLen).fill(void 0),nullMode=nullModes?nullModes[ti][si]:NULL_RETAIN,nullIdxs=[];for(let i=0;i<ys.length;i++){let yVal=ys[i],alignedIdx=xIdxs.get(xs[i]);null===yVal?nullMode!==NULL_REMOVE&&(yVals[alignedIdx]=yVal,nullMode===NULL_EXPAND&&nullIdxs.push(alignedIdx)):yVals[alignedIdx]=yVal}nullExpand(yVals,nullIdxs,alignedLen),data.push(yVals)}}return data}function isLikelyAscendingVector(data,samples=50){const len=data.length;if(len<=1)return!0;let firstIdx=0,lastIdx=len-1;for(;firstIdx<=lastIdx&&null==data[firstIdx];)firstIdx++;for(;lastIdx>=firstIdx&&null==data[lastIdx];)lastIdx--;if(lastIdx<=firstIdx)return!0;const stride=Math.max(1,Math.floor((lastIdx-firstIdx+1)/samples));for(let prevVal=data[firstIdx],i=firstIdx+stride;i<=lastIdx;i+=stride){const v=data[i];if(null!=v&&null!=prevVal){if(v<=prevVal)return!1;prevVal=v}}return!0}const histogramBucketSizes=[1e-9,2e-9,2.5e-9,4e-9,5e-9,1e-8,2e-8,25e-9,4e-8,5e-8,1e-7,2e-7,25e-8,4e-7,5e-7,1e-6,2e-6,25e-7,4e-6,5e-6,1e-5,2e-5,25e-6,4e-5,5e-5,1e-4,2e-4,25e-5,4e-4,5e-4,.001,.002,.0025,.004,.005,.01,.02,.025,.04,.05,.1,.2,.25,.4,.5,1,2,4,5,10,20,25,40,50,100,200,250,400,500,1e3,2e3,2500,4e3,5e3,1e4,2e4,25e3,4e4,5e4,1e5,2e5,25e4,4e5,5e5,1e6,2e6,25e5,4e6,5e6,1e7,2e7,25e6,4e7,5e7,1e8,2e8,25e7,4e8,5e8,1e9,2e9,25e8,4e9,5e9],histFilter=[],histSort=(a,b)=>a-b,histogramTransformer={id:DataTransformerID.histogram,name:"Histogram",description:"Calculate a histogram from input data.",defaultOptions:{fields:{}},operator:(options,ctx)=>source=>source.pipe((0,map.T)((data=>histogramTransformer.transformer(options,ctx)(data)))),transformer:(options,ctx)=>data=>{if(!Array.isArray(data)||0===data.length)return data;let bucketSize,bucketOffset;options.bucketSize&&(bucketSize="string"==typeof options.bucketSize?parseFloat(options.bucketSize):options.bucketSize,isNaN(bucketSize)&&(bucketSize=void 0)),options.bucketOffset&&(bucketOffset="string"==typeof options.bucketOffset?parseFloat(options.bucketOffset):options.bucketOffset,isNaN(bucketOffset)&&(bucketOffset=void 0));const hist=function buildHistogram(frames,options,theme){let bucketSize=options?.bucketSize,bucketCount=options?.bucketCount??30,bucketOffset=options?.bucketOffset??0;if(frames=frames.map((frame=>({...frame,fields:frame.fields.map((field=>{if(field.type===dataFrame.PU.number){const noValue=Number(field.config.noValue);field=Number.isNaN(noValue)?{...field,values:field.values.filter((v=>null!=v))}:nullToValueField(field,noValue)}return field}))}))),!bucketSize||bucketSize<0){let allValues=[];for(const frame of frames)for(const field of frame.fields)field.type===dataFrame.PU.number&&(allValues=allValues.concat(field.values));allValues.sort(((a,b)=>a-b));let smallestDelta=1/0;if(1===allValues.length)smallestDelta=1;else for(let i=1;i<allValues.length;i++){let delta=allValues[i]-allValues[i-1];0!==delta&&(smallestDelta=Math.min(smallestDelta,delta))}let min=allValues[0];const targetSize=(allValues[allValues.length-1]-min)/bucketCount;for(let i=0;i<histogramBucketSizes.length;i++){let _bucketSize=histogramBucketSizes[i];if(targetSize<_bucketSize&&_bucketSize>=smallestDelta){bucketSize=_bucketSize;break}}}const getBucket=v=>numbers_roundDecimals(incrRoundDn(v-bucketOffset,bucketSize)+bucketOffset,9);let config,bucketDecimals=((""+bucketSize).match(/\.\d+$/)??["."])[0].length-1,histograms=[],counts=[];for(const frame of frames)for(const field of frame.fields)if(field.type===dataFrame.PU.number){let fieldHist=histogram(field.values,getBucket,histFilter,histSort);histograms.push(fieldHist);const count={...field,config:{...field.config,unit:"short"===field.config.unit?"short":void 0}};count.display=(0,displayProcessor.J)({field:count,theme:theme??(0,createTheme.a)()}),counts.push(count),!config&&field.config.unit&&(config=field.config)}if(!counts.length)return null;let joinedHists=join(histograms);for(let histIdx=1;histIdx<joinedHists.length;histIdx++){let hist=joinedHists[histIdx];for(let bucketIdx=0;bucketIdx<hist.length;bucketIdx++)null==hist[bucketIdx]&&(hist[bucketIdx]=0)}const xMin={name:histogramFrameBucketMinFieldName,values:joinedHists[0],type:dataFrame.PU.number,state:void 0,config:0===bucketDecimals?config??{}:{...config,decimals:bucketDecimals}},xMax={...xMin,name:histogramFrameBucketMaxFieldName,values:joinedHists[0].map((v=>v+bucketSize))};if(options?.combine){const vals=new Array(joinedHists[0].length).fill(0);for(let i=1;i<joinedHists.length;i++)for(let j=0;j<vals.length;j++)vals[j]+=joinedHists[i][j];counts=[{...counts[0],name:"count",values:vals,type:dataFrame.PU.number,state:{...counts[0].state,displayName:"Count",multipleFrames:!1,origin:{frameIndex:0,fieldIndex:2}}}]}else counts.forEach(((field,i)=>{field.values=joinedHists[i+1]}));return{xMin:xMin,xMax:xMax,counts:counts}}(data,{bucketSize:bucketSize,bucketOffset:bucketOffset,combine:options.combine});return null==hist?[]:[histogramFieldsToFrame(hist)]}},histogramFrameBucketMinFieldName="xMin";const histogramFrameBucketMaxFieldName="xMax";function incrRoundUp(num,incr){return Math.ceil(num/incr)*incr}function incrRoundDn(num,incr){return Math.floor(num/incr)*incr}function histogram(vals,getBucket,filterOut,sort){let hist=new Map;for(let i=0;i<vals.length;i++){let v=vals[i];null!=v&&(v=getBucket(v));let entry=hist.get(v);entry?entry.count++:hist.set(v,{value:v,count:1})}filterOut&&filterOut.forEach((v=>hist.delete(v)));let bins=[...hist.values()];sort&&bins.sort(((a,b)=>sort(a.value,b.value)));let values=Array(bins.length),counts=Array(bins.length);for(let i=0;i<bins.length;i++)values[i]=bins[i].value,counts[i]=bins[i].count;return[values,counts]}function histogramFieldsToFrame(info,theme){if(!info.xMin.display){const display=(0,displayProcessor.J)({field:info.xMin,theme:theme??(0,createTheme.a)()});info.xMin.display=display,info.xMax.display=display}return{length:info.xMin.values.length,meta:{type:dataFrameTypes_DataFrameType.Histogram},fields:[info.xMin,info.xMax,...info.counts],refId:`${DataTransformerID.histogram}`}}class UPlotScaleBuilder extends PlotConfigBuilder{merge(props){this.props.min=optMinMax("min",this.props.min,props.min),this.props.max=optMinMax("max",this.props.max,props.max)}getConfig(){let{isTime:isTime,scaleKey:scaleKey,min:hardMin,max:hardMax,softMin:softMin,softMax:softMax,range:range,direction:direction,orientation:orientation,centeredZero:centeredZero,decimals:decimals,stackingMode:stackingMode}=this.props;stackingMode===common_gen.gs.Percent&&(null==hardMin&&null==softMin&&(softMin=0),null==hardMax&&null==softMax&&(softMax=1));const distr=this.props.distribution,distribution=isTime?{}:{distr:distr===common_gen.L4.Symlog?4:distr===common_gen.L4.Log?3:distr===common_gen.L4.Ordinal?2:1,log:distr===common_gen.L4.Log||distr===common_gen.L4.Symlog?this.props.log??2:void 0,asinh:distr===common_gen.L4.Symlog?this.props.linearThreshold??1:void 0};if(distr===common_gen.L4.Log){let logBase=this.props.log,logFn=2===logBase?Math.log2:Math.log10;null!=hardMin&&(hardMin=hardMin<=0?null:logBase**Math.floor(logFn(hardMin))),null!=hardMax&&(hardMax=hardMax<=0?null:logBase**Math.ceil(logFn(hardMax))),null!=softMin&&(softMin=softMin<=0?null:logBase**Math.floor(logFn(softMin))),null!=softMax&&(softMax=softMax<=0?null:logBase**Math.ceil(logFn(softMax)))}const rangeConfig={min:{pad:.1,hard:hardMin??-1/0,soft:softMin||0,mode:null==softMin?3:1},max:{pad:.1,hard:hardMax??1/0,soft:softMax||0,mode:null==softMax?3:1}};let hardMinOnly=null==softMin&&null!=hardMin,hardMaxOnly=null==softMax&&null!=hardMax,hasFixedRange=hardMinOnly&&hardMaxOnly;let auto=!isTime&&!hasFixedRange;return(0,valueFormats.j9)(scaleKey)&&(auto=!1,range=[0,1]),{[scaleKey]:{time:isTime,auto:auto,range:range??((u,dataMin,dataMax,scaleKey)=>{const scale=u.scales[scaleKey];let minMax=[dataMin,dataMax];if(!hasFixedRange&&null==dataMin&&null==dataMax)return minMax;let logBase=scale.log??10;if(1===scale.distr||2===scale.distr||4===scale.distr){if(centeredZero){let absMin=Math.abs(dataMin),absMax=Math.abs(dataMax),max=Math.max(absMin,absMax);0===max&&(max=80),dataMin=-max,dataMax=max}minMax=4===scale.distr?uPlot_esm.A.rangeAsinh(dataMin,dataMax,logBase,!0):uPlot_esm.A.rangeNum(hardMinOnly?hardMin:dataMin,hardMaxOnly?hardMax:dataMax,rangeConfig)}else 3===scale.distr&&(minMax=uPlot_esm.A.rangeLog(hardMin??dataMin,hardMax??dataMax,logBase,!0));if(0===decimals)if(1===scale.distr||2===scale.distr)minMax[0]=incrRoundDn(minMax[0],1),minMax[1]=incrRoundUp(minMax[1],1);else if(3===scale.distr){let logFn=2===scale.log?Math.log2:Math.log10;if(minMax[0]<=1)minMax[0]=1;else{let minExp=Math.floor(logFn(minMax[0]));minMax[0]=logBase**minExp}let maxExp=Math.ceil(logFn(minMax[1]));minMax[1]=logBase**maxExp,minMax[0]===minMax[1]&&(minMax[1]*=logBase)}else 4===scale.distr&&(minMax[0]=incrRoundDn(minMax[0],1),minMax[1]=incrRoundUp(minMax[1],1));return 1!==scale.distr&&4!==scale.distr||(hardMinOnly&&(minMax[0]=hardMin),hardMaxOnly&&(minMax[1]=hardMax)),minMax[0]>=minMax[1]&&(minMax[0]=3===scale.distr?1:0,minMax[1]=100),minMax}),dir:direction,ori:orientation,...distribution}}}}function optMinMax(minmax,a,b){return!(null==a)?!(null==b)?"min"===minmax?a<b?a:b:a>b?a:b:a:b}class UPlotAxisBuilder extends PlotConfigBuilder{merge(props){this.props.size=optMinMax("max",this.props.size,props.size),this.props.label||(this.props.label=props.label),this.props.placement===common_gen.vM.Auto&&(this.props.placement=props.placement)}getConfig(){let{scaleKey:scaleKey,label:label,show:show=!0,placement:placement=common_gen.vM.Auto,grid:grid={show:!0},ticks:ticks,space:space,filter:filter,gap:gap=5,formatValue:formatValue,splits:splits,values:values,incrs:incrs,isTime:isTime,timeZone:timeZone,theme:theme,tickLabelRotation:tickLabelRotation,size:size,color:color,border:border,decimals:decimals,distr:distr=common_gen.L4.Linear}=this.props;const font=`12px ${theme.typography.fontFamily}`,gridColor=theme.isDark?"rgba(240, 250, 255, 0.09)":"rgba(0, 10, 23, 0.09)";(0,valueFormats.j9)(scaleKey)&&(splits=[0,1]),0===decimals&&distr===common_gen.L4.Linear&&(filter=(u,splits)=>splits.map((v=>Number.isInteger(v)?v:null)));let config={scale:scaleKey,show:show,stroke:color??theme.colors.text.primary,side:getUPlotSideFromAxis(placement),font:font,size:size??((self,values,axisIdx)=>function calculateAxisSize(self,values,axisIdx){const axis=self.axes[axisIdx];let axisSize=axis.ticks.size;if(2===axis.side)axisSize+=axis.gap+12;else if(values?.length){let maxTextWidth=values.reduce(((acc,value)=>Math.max(acc,(0,measureText.kD)(value,12).width)),0);const textWidthWithLimit=Math.min(.4*self.width,maxTextWidth);axisSize+=axis.gap+axis.labelGap+textWidthWithLimit}return Math.ceil(axisSize)}(self,values,axisIdx)),rotate:tickLabelRotation,gap:gap,labelGap:0,grid:{show:grid.show,stroke:gridColor,width:1/devicePixelRatio},ticks:Object.assign({show:!0,stroke:border?.show?color??theme.colors.text.primary:gridColor,width:1/devicePixelRatio,size:4},ticks),splits:splits,values:values,space:space??((self,axisIdx,scaleMin,scaleMax,plotDim)=>function calculateSpace(self,axisIdx,scaleMin,scaleMax,plotDim,formatValue){const axis=self.axes[axisIdx],scale=self.scales[axis.scale];if(2!==axis.side||!scale)return plotDim<=150?15:30;const maxTicks=plotDim/40,increment=(scaleMax-scaleMin)/maxTicks,bigValue=Math.max(Math.abs(scaleMin),Math.abs(scaleMax));let sample="";if(scale.time)sample=formatTime(self,[bigValue],axisIdx,40,increment)[0];else{if(null==formatValue)return 40;sample=formatValue(bigValue)}return(0,measureText.kD)(sample,12).width+18}(self,axisIdx,scaleMin,scaleMax,plotDim,formatValue)),filter:filter,incrs:incrs};return border?.show&&(config.border={stroke:color??theme.colors.text.primary,width:1/devicePixelRatio,...border}),null!=label&&label.length>0&&(config.label=label,config.labelSize=20,config.labelFont=font,config.labelGap=8),values?config.values=values:isTime?config.values=formatTime:formatValue&&(config.values=(u,splits,axisIdx,tickSpace,tickIncr)=>{let decimals=function guessDecimals(num){return((""+num).split(".")[1]||"").length}(numbers_roundDecimals(tickIncr,6));return splits.map((v=>null==v?null:formatValue(v,decimals>0?decimals:void 0)))}),config.timeZone=timeZone,config}}const timeUnitSize={second:1e3,minute:6e4,hour:36e5,day:864e5,month:24192e5,year:31536e6};function formatTime(self,splits,axisIdx,foundSpace,foundIncr){const axis=self.axes[axisIdx],timeZone="timeZone"in axis&&"string"==typeof axis.timeZone?axis.timeZone:void 0,scale=self.scales.x,range=(scale?.max??0)-(scale?.min??0),yearRoundedToDay=Math.round(timeUnitSize.year/timeUnitSize.day)*timeUnitSize.day,incrementRoundedToDay=Math.round(foundIncr/timeUnitSize.day)*timeUnitSize.day;let format=formats.WC.interval.year;return foundIncr<timeUnitSize.second?format=formats.WC.interval.millisecond:foundIncr<=timeUnitSize.minute?format=formats.WC.interval.second:range<=timeUnitSize.day?format=formats.WC.interval.minute:foundIncr<=timeUnitSize.day?format=formats.WC.interval.hour:range<timeUnitSize.year?format=formats.WC.interval.day:incrementRoundedToDay===yearRoundedToDay?format=formats.WC.interval.year:foundIncr<=timeUnitSize.year&&(format=formats.WC.interval.month),splits.map((v=>null==v?"":(0,formatter.LE)(v,{format:format,timeZone:timeZone})))}function getUPlotSideFromAxis(axis){switch(axis){case common_gen.vM.Top:return 0;case common_gen.vM.Right:return 1;case common_gen.vM.Bottom:return 2;case common_gen.vM.Left:}return 3}var types_fieldColor=__webpack_require__("../grafana-data/src/types/fieldColor.ts"),colorManipulator=__webpack_require__("../grafana-data/src/themes/colorManipulator.ts"),tinycolor=__webpack_require__("../../node_modules/tinycolor2/esm/tinycolor.js"),types_thresholds=__webpack_require__("../grafana-data/src/types/thresholds.ts");function makeDirectionalGradient(direction,bbox,ctx){let x0=0,y0=0,x1=0,y1=0;return 3===direction?(y0=bbox.top,y1=bbox.top+bbox.height):2===direction?(x0=bbox.left+bbox.width,x1=bbox.left):1===direction?(y0=bbox.top+bbox.height,y1=bbox.top):0===direction&&(x0=bbox.left,x1=bbox.left+bbox.width),ctx.createLinearGradient(x0,y0,x1,y1)}function getHueGradientFn(color,opacity,theme){return(plot,seriesIdx)=>{const ctx=(0,measureText.Yc)(),gradient=makeDirectionalGradient(plot.scales.x.ori===common_gen.Lt.Horizontal?3:2,plot.bbox,ctx),color1=(0,tinycolor.A)(color).spin(-25).darken(5),color2=(0,tinycolor.A)(color).saturate(20).spin(20).brighten(10);return theme.isDark?(gradient.addColorStop(0,color2.lighten(10).setAlpha(opacity).toString()),gradient.addColorStop(1,color1.darken(10).setAlpha(opacity).toString())):(gradient.addColorStop(0,color2.lighten(10).setAlpha(opacity).toString()),gradient.addColorStop(1,color1.setAlpha(opacity).toString())),gradient}}function scaleGradient(u,scaleKey,scaleStops,discrete=!1){let scale=u.scales[scaleKey],minStopIdx=null,maxStopIdx=null;for(let i=0;i<scaleStops.length;i++){let stopVal=scaleStops[i][0];if((stopVal<=scale.min||null==minStopIdx)&&(minStopIdx=i),maxStopIdx=i,stopVal>=scale.max)break}if(minStopIdx===maxStopIdx)return scaleStops[minStopIdx][1];let minStopVal=scaleStops[minStopIdx][0],maxStopVal=scaleStops[maxStopIdx][0];minStopVal===-1/0&&(minStopVal=scale.min),maxStopVal===1/0&&(maxStopVal=scale.max);let x0,y0,x1,y1,minStopPos=Math.round(u.valToPos(minStopVal,scaleKey,!0)),maxStopPos=Math.round(u.valToPos(maxStopVal,scaleKey,!0)),range=minStopPos-maxStopPos;if(0===range)return scaleStops[maxStopIdx][1];u.scales.x.ori===common_gen.Lt.Horizontal?(x0=x1=0,y0=minStopPos,y1=maxStopPos):(y0=y1=0,x0=minStopPos,x1=maxStopPos);let prevColor,grd=(0,measureText.Yc)().createLinearGradient(x0,y0,x1,y1);for(let i=minStopIdx;i<=maxStopIdx;i++){let s=scaleStops[i],pct=(minStopPos-(i===minStopIdx?minStopPos:i===maxStopIdx?maxStopPos:Math.round(u.valToPos(s[0],scaleKey,!0))))/range;discrete&&i>minStopIdx&&grd.addColorStop(pct,prevColor),grd.addColorStop(pct,prevColor=s[1])}return grd}function getGradientRange(u,scaleKey,hardMin,hardMax,softMin,softMax){let min=hardMin??softMin??null,max=hardMax??softMax??null;if(null==min||null==max){let[dataMin,dataMax]=function getDataRange(plot,scaleKey){let sc=plot.scales[scaleKey],min=1/0,max=-1/0;return plot.series.forEach(((ser,seriesIdx)=>{if(ser.show&&ser.scale===scaleKey)if(null==ser.min){let data=plot.data[seriesIdx];for(let i=0;i<data.length;i++)null!=data[i]&&(min=Math.min(min,data[i]),max=Math.max(max,data[i]))}else min=Math.min(min,ser.min),max=Math.max(max,ser.max)})),max===min&&(min=sc.min,max=sc.max),[min,max]}(u,scaleKey);min=min??dataMin??0,max=max??dataMax??100}return[min,max]}function getScaleGradientFn(opacity,theme,colorMode,thresholds,hardMin,hardMax,softMin,softMax){if(!colorMode)throw Error("Missing colorMode required for color scheme gradients");if(!thresholds)throw Error("Missing thresholds required for color scheme gradients");return(plot,seriesIdx)=>{let scaleKey=plot.series[seriesIdx].scale,gradient="";if(colorMode.id===types_fieldColor.Y.Thresholds)if(thresholds.mode===types_thresholds.O.Absolute){gradient=scaleGradient(plot,scaleKey,thresholds.steps.map((step=>{return[step.value,(color=step.color,"transparent"===color||"#"===color[0]&&"00"===color.slice(-2)?"#0000":colorManipulator.MV.alpha(theme.visualization.getColorByName(step.color),opacity))];var color})),!0)}else{const[min,max]=getGradientRange(plot,scaleKey,hardMin,hardMax,softMin,softMax),range=max-min;gradient=scaleGradient(plot,scaleKey,thresholds.steps.map((step=>[min+range*(step.value/100),colorManipulator.MV.alpha(theme.visualization.getColorByName(step.color),opacity)])),!0)}else if(colorMode.getColors){const colors=colorMode.getColors(theme),[min,max]=getGradientRange(plot,scaleKey,hardMin,hardMax,softMin,softMax),range=max-min;gradient=scaleGradient(plot,scaleKey,colors.map(((color,i)=>[min+range*(i/(colors.length-1)),colorManipulator.MV.alpha(theme.visualization.getColorByName(color),opacity)])),!1)}return gradient}}class UPlotSeriesBuilder extends PlotConfigBuilder{getConfig(){const{facets:facets,drawStyle:drawStyle,pathBuilder:pathBuilder,pointsBuilder:pointsBuilder,pointsFilter:pointsFilter,lineInterpolation:lineInterpolation,lineWidth:lineWidth,lineStyle:lineStyle,barAlignment:barAlignment,barWidthFactor:barWidthFactor,barMaxWidth:barMaxWidth,showPoints:showPoints,pointSize:pointSize,scaleKey:scaleKey,pxAlign:pxAlign,spanNulls:spanNulls,show:show=!0}=this.props;let lineConfig={},lineColor=this.getLineColor();lineConfig.stroke=lineColor,lineConfig.width=lineWidth,lineStyle&&"solid"!==lineStyle.fill&&("dot"===lineStyle.fill&&(lineConfig.cap="round"),lineConfig.dash=lineStyle.dash??[10,10]),null!=pathBuilder?lineConfig.paths=pathBuilder:drawStyle===common_gen.GR.Points?lineConfig.paths=()=>null:null!=drawStyle&&(lineConfig.paths=(self,seriesIdx,idx0,idx1)=>{let pathsBuilder=function mapDrawStyleToPathBuilder(style,lineInterpolation,barAlignment=common_gen.Nj.Center,barWidthFactor=.6,barMaxWidth=200){const pathBuilders=uPlot_esm.A.paths;builders||(builders={linear:pathBuilders.linear(),smooth:pathBuilders.spline(),stepBefore:pathBuilders.stepped({align:-1}),stepAfter:pathBuilders.stepped({align:1})});if(style===common_gen.GR.Bars){let barsCfgKey=`bars|${barAlignment}|${barWidthFactor}|${barMaxWidth}`;return builders[barsCfgKey]||(builders[barsCfgKey]=pathBuilders.bars({size:[barWidthFactor,barMaxWidth],align:barAlignment})),builders[barsCfgKey]}if(style===common_gen.GR.Line){if(lineInterpolation===common_gen.dx.StepBefore)return builders.stepBefore;if(lineInterpolation===common_gen.dx.StepAfter)return builders.stepAfter;if(lineInterpolation===common_gen.dx.Smooth)return builders.smooth}return builders.linear}(drawStyle,lineInterpolation,barAlignment,barWidthFactor,barMaxWidth);return pathsBuilder(self,seriesIdx,idx0,idx1)});const useColor="string"==typeof lineColor?lineColor:(u,seriesIdx)=>u.series[seriesIdx]._stroke,pointsConfig={points:{stroke:useColor,fill:useColor,size:!pointSize||pointSize<lineWidth?void 0:pointSize,filter:pointsFilter}};return null!=pointsBuilder?pointsConfig.points.show=pointsBuilder:drawStyle===common_gen.GR.Points?pointsConfig.points.show=!0:showPoints===common_gen.yL.Auto?drawStyle===common_gen.GR.Bars&&(pointsConfig.points.show=!1):showPoints===common_gen.yL.Never?pointsConfig.points.show=!1:showPoints===common_gen.yL.Always&&(pointsConfig.points.show=!0),{scale:scaleKey,facets:facets,spanGaps:"number"!=typeof spanNulls&&spanNulls,value:()=>"",pxAlign:pxAlign,show:show,fill:this.getFill(),...lineConfig,...pointsConfig}}getLineColor(){const{lineColor:lineColor,gradientMode:gradientMode,colorMode:colorMode,thresholds:thresholds,theme:theme,hardMin:hardMin,hardMax:hardMax,softMin:softMin,softMax:softMax,dynamicSeriesColor:dynamicSeriesColor}=this.props;return gradientMode===common_gen.on.None&&dynamicSeriesColor?(plot,seriesIdx)=>dynamicSeriesColor(seriesIdx)??lineColor??types_fieldColor.F:gradientMode===common_gen.on.Scheme&&colorMode?.id!==types_fieldColor.Y.Fixed?getScaleGradientFn(1,theme,colorMode,thresholds,hardMin,hardMax,softMin,softMax):gradientMode===common_gen.on.Hue?getHueGradientFn(lineColor??types_fieldColor.F,1,theme):lineColor??types_fieldColor.F}getFill(){const{lineColor:lineColor,fillColor:fillColor,gradientMode:gradientMode,fillOpacity:fillOpacity,colorMode:colorMode,thresholds:thresholds,theme:theme,hardMin:hardMin,hardMax:hardMax,softMin:softMin,softMax:softMax,dynamicSeriesColor:dynamicSeriesColor}=this.props;if(fillColor)return fillColor;const mode=gradientMode??common_gen.on.None,opacityPercent=(fillOpacity??0)/100;if(mode===common_gen.on.None&&dynamicSeriesColor&&opacityPercent>0)return(u,seriesIdx)=>{let lineColor=u.series[seriesIdx]._stroke;return colorManipulator.MV.alpha(lineColor??"",opacityPercent)};switch(mode){case common_gen.on.Opacity:return function getOpacityGradientFn(color,opacity){return(plot,seriesIdx)=>{const ctx=(0,measureText.Yc)(),gradient=makeDirectionalGradient(plot.scales.x.ori===common_gen.Lt.Horizontal?3:2,plot.bbox,ctx);return gradient.addColorStop(0,colorManipulator.MV.alpha(color,opacity)),gradient.addColorStop(1,colorManipulator.MV.alpha(color,0)),gradient}}(fillColor??lineColor,opacityPercent);case common_gen.on.Hue:return getHueGradientFn(fillColor??lineColor,opacityPercent,theme);case common_gen.on.Scheme:if(colorMode?.id!==types_fieldColor.Y.Fixed)return getScaleGradientFn(opacityPercent,theme,colorMode,thresholds,hardMin,hardMax,softMin,softMax);default:if(opacityPercent>0)return colorManipulator.MV.alpha(lineColor??"",opacityPercent)}}}let builders;const cursorDefaults={drag:{setScale:!1},points:{size:(u,seriesIdx)=>2*u.series[seriesIdx].points.size,width:(u,seriesIdx,size)=>size/4},focus:{prox:30}};class UPlotConfigBuilder{uid=Math.random().toString(36).slice(2);series=[];axes={};scales=[];bands=[];stackingGroups=[];cursor;select;hasLeftAxis=!1;hooks={};tz=void 0;mode=1;frames=void 0;thresholds={};padding=void 0;cachedConfig;prepData=void 0;constructor(timeZone=time.lE){this.tz=(0,timezones.QZ)(timeZone,Date.now())?.ianaName}scaleKeys=["",""];addHook(type,hook){pluginLog("UPlotConfigBuilder",!1,"addHook",type),this.hooks[type]||(this.hooks[type]=[]),this.hooks[type].push(hook)}addThresholds(options){this.thresholds[options.scaleKey]||(this.thresholds[options.scaleKey]=options,this.addHook("drawClear",function getThresholdsDrawHook(options){const dashSegments=options.config.mode===common_gen.Ly.Dashed||options.config.mode===common_gen.Ly.DashedAndArea?[10,10]:[];function addLines(u,yScaleKey,steps,theme){let ctx=u.ctx,transparentIndex=0;for(let idx=0;idx<steps.length;idx++)if("transparent"===steps[idx].color){transparentIndex=idx;break}ctx.lineWidth=2,ctx.setLineDash(dashSegments);for(let idx=1;idx<steps.length;idx++){const step=steps[idx];let color;color=transparentIndex>=idx&&idx>0?(0,tinycolor.A)(theme.visualization.getColorByName(steps[idx-1].color)):(0,tinycolor.A)(theme.visualization.getColorByName(step.color)),1===color.getAlpha()&&color.setAlpha(.7);const isHorizontal=u.scales.x.ori===common_gen.Lt.Horizontal,scaleVal=u.valToPos(step.value,yScaleKey,!0);let x0=Math.round(isHorizontal?u.bbox.left:scaleVal),y0=Math.round(isHorizontal?scaleVal:u.bbox.top),x1=Math.round(isHorizontal?u.bbox.left+u.bbox.width:scaleVal),y1=Math.round(isHorizontal?scaleVal:u.bbox.top+u.bbox.height);ctx.beginPath(),ctx.moveTo(x0,y0),ctx.lineTo(x1,y1),ctx.strokeStyle=color.toString(),ctx.stroke()}}function addAreas(u,yScaleKey,steps,theme){let ctx=u.ctx,grd=scaleGradient(u,yScaleKey,steps.map((step=>{let color=(0,tinycolor.A)(theme.visualization.getColorByName(step.color));return 1===color.getAlpha()&&color.setAlpha(.15),[step.value,color.toString()]})),!0);ctx.fillStyle=grd,ctx.fillRect(u.bbox.left,u.bbox.top,u.bbox.width,u.bbox.height)}const{scaleKey:scaleKey,thresholds:thresholds,theme:theme,config:config,hardMin:hardMin,hardMax:hardMax,softMin:softMin,softMax:softMax}=options;return u=>{const ctx=u.ctx,{min:xMin,max:xMax}=u.scales.x,{min:yMin,max:yMax}=u.scales[scaleKey];if(null==xMin||null==xMax||null==yMin||null==yMax)return;let{steps:steps,mode:mode}=thresholds;if(mode===types_thresholds.O.Percentage){let[min,max]=getGradientRange(u,scaleKey,hardMin,hardMax,softMin,softMax),range=max-min;steps=steps.map((step=>({...step,value:min+range*(step.value/100)})))}switch(ctx.save(),config.mode){case common_gen.Ly.Line:case common_gen.Ly.Dashed:addLines(u,scaleKey,steps,theme);break;case common_gen.Ly.Area:addAreas(u,scaleKey,steps,theme);break;case common_gen.Ly.LineAndArea:case common_gen.Ly.DashedAndArea:addAreas(u,scaleKey,steps,theme),addLines(u,scaleKey,steps,theme)}ctx.restore()}}(options)))}addAxis(props){props.placement=props.placement??common_gen.vM.Auto,props.grid=props.grid??{};let scaleKey=props.scaleKey;"x"===scaleKey&&(scaleKey+=props.timeZone??""),this.axes[scaleKey]?this.axes[scaleKey].merge(props):(props.placement===common_gen.vM.Auto&&(props.placement=this.hasLeftAxis?common_gen.vM.Right:common_gen.vM.Left),props.placement===common_gen.vM.Left&&(this.hasLeftAxis=!0),props.placement===common_gen.vM.Hidden&&(props.grid.show=!1,props.size=0),this.axes[scaleKey]=new UPlotAxisBuilder(props))}getAxisPlacement(scaleKey){const axis=this.axes[scaleKey];return axis?.props.placement??common_gen.vM.Left}setCursor(cursor){this.cursor=(0,lodash.merge)({},this.cursor,cursor)}setMode(mode){this.mode=mode}setSelect(select){this.select=select}addSeries(props){this.series.push(new UPlotSeriesBuilder(props))}getSeries(){return this.series}addScale(props){const current=this.scales.find((v=>v.props.scaleKey===props.scaleKey));current?current.merge(props):this.scales.push(new UPlotScaleBuilder(props))}addBand(band){this.bands.push(band)}setStackingGroups(groups){this.stackingGroups=groups}getStackingGroups(){return this.stackingGroups}setPrepData(prepData){this.prepData=frames=>(this.frames=frames,prepData(frames,this.getStackingGroups()))}setPadding(padding){this.padding=padding}getConfig(){if(this.cachedConfig)return this.cachedConfig;const config={...DEFAULT_PLOT_CONFIG,mode:this.mode,series:[2===this.mode?null:{value:()=>""}]};config.axes=this.ensureNonOverlappingAxes(Object.values(this.axes)).map((a=>a.getConfig())),config.series=[...config.series,...this.series.map((s=>s.getConfig()))],config.scales=this.scales.reduce(((acc,s)=>({...acc,...s.getConfig()})),{}),config.hooks=this.hooks,config.select=this.select;const pointColorFn=(alphaHex="")=>(u,seriesIdx)=>{let s=u.series[seriesIdx].points._stroke;if("string"!=typeof s){let field=this.frames[0].fields[seriesIdx];s=field.display(field.values[u.cursor.idxs[seriesIdx]]).color}return s+alphaHex};return config.cursor=(0,lodash.merge)({},cursorDefaults,{points:{stroke:pointColorFn("80"),fill:pointColorFn()}},this.cursor),config.tzDate=this.tzDate,Array.isArray(this.padding)&&(config.padding=this.padding),this.stackingGroups.forEach((group=>{(function getStackingBands(group){let bands=[],{series:series,dir:dir}=group,lastIdx=series.length-1,rSeries=series.slice().reverse();return rSeries.forEach(((si,i)=>{if(i!==lastIdx){let nextIdx=rSeries[i+1];bands.push({series:[si,nextIdx],dir:-1*dir})}})),bands})(group).forEach((band=>{this.addBand(band)}))})),this.bands.length&&(config.bands=this.bands),this.cachedConfig=config,config}tzDate=ts=>{let date=new Date(ts);return this.tz?uPlot_esm.A.tzDate(date,this.tz):date};ensureNonOverlappingAxes(axes){const xAxis=axes.find((a=>"x"===a.props.scaleKey)),axesWithoutGridSet=axes.filter((a=>void 0===a.props.grid?.show)),firstValueAxisIdx=axesWithoutGridSet.findIndex((a=>a.props.placement===common_gen.vM.Left||a.props.placement===common_gen.vM.Right||a.props.placement===common_gen.vM.Bottom&&a!==xAxis));for(let i=0;i<axesWithoutGridSet.length;i++)axesWithoutGridSet[i]===xAxis||i===firstValueAxisIdx?axesWithoutGridSet[i].props.grid.show=!0:axesWithoutGridSet[i].props.grid.show=!1;return axes}}const INSERT_MODES_threshold=(prev,next,threshold)=>prev+threshold;function applyNullInsertThreshold(opts){if(0===opts.frame.length)return opts.frame;let{frame:frame,refFieldName:refFieldName,refFieldPseudoMax:refFieldPseudoMax,refFieldPseudoMin:refFieldPseudoMin,insertMode:insertMode}=opts;insertMode||(insertMode=INSERT_MODES_threshold);const refField=function getRefField(frame,refFieldName){return frame.fields.find((field=>null!=refFieldName?field.name===refFieldName:field.type===dataFrame.PU.time))}(frame,refFieldName);if(null==refField)return frame;refField.state={...refField.state,nullThresholdApplied:!0};const thresholds=frame.fields.map((field=>field.config.custom?.insertNulls||refField.config.interval||null)),uniqueThresholds=new Set(thresholds);if(uniqueThresholds.delete(null),0===uniqueThresholds.size)return frame;if(1===uniqueThresholds.size){const threshold=uniqueThresholds.values().next().value;if(!threshold||threshold<=0)return frame;const refValues=refField.values,frameValues=frame.fields.map((field=>field.values)),filledFieldValues=function nullInsertThreshold(refValues,frameValues,threshold,refFieldPseudoMin=null,refFieldPseudoMax=null,getInsertValue,thorough){const len=refValues.length,refValuesNew=[];if(null!=refFieldPseudoMin&&refFieldPseudoMin<refValues[0]){let preFillCount=Math.ceil((refValues[0]-refFieldPseudoMin)/threshold),prevSlot=refValues[0]-preFillCount*threshold;for(;prevSlot<refValues[0];)refValuesNew.push(getInsertValue(prevSlot-threshold,prevSlot,threshold)),prevSlot+=threshold}refValuesNew.push(refValues[0]);let prevValue=refValues[0];for(let i=1;i<len;i++){const curValue=refValues[i];for(;curValue-prevValue>threshold&&(refValuesNew.push(getInsertValue(prevValue,curValue,threshold)),prevValue+=threshold,thorough););refValuesNew.push(curValue),prevValue=curValue}if(null!=refFieldPseudoMax&&refFieldPseudoMax>prevValue)for(;prevValue+threshold<refFieldPseudoMax;)refValuesNew.push(getInsertValue(prevValue,refFieldPseudoMax,threshold)),prevValue+=threshold;const filledLen=refValuesNew.length;if(filledLen===len)return frameValues;const filledFieldValues=[];for(let fieldValues of frameValues){let filledValues;if(fieldValues!==refValues){filledValues=Array(filledLen);for(let i=0,j=0;i<filledLen;i++)filledValues[i]=refValues[j]===refValuesNew[i]?fieldValues[j++]:null}else filledValues=refValuesNew;filledFieldValues.push(filledValues)}return filledFieldValues}(refValues,frameValues,threshold,refFieldPseudoMin,refFieldPseudoMax,insertMode,true);return filledFieldValues===frameValues?frame:{...frame,length:filledFieldValues[0].length,fields:frame.fields.map(((field,i)=>({...field,values:filledFieldValues[i]})))}}return frame}function preparePlotFrame(sparkline,config){const length=sparkline.y.values.length,yFieldConfig={...sparkline.y.config,...config},xField=sparkline.x??{name:"",values:[...Array(length).keys()],type:dataFrame.PU.number,config:{}};let frame={refId:"sparkline",fields:[xField,{...sparkline.y,config:yFieldConfig}],length:length};return isLikelyAscendingVector(xField.values)||(frame=(0,processDataFrame.ES)(frame,0)),applyNullInsertThreshold({frame:frame,refFieldPseudoMin:sparkline.timeRange?.from.valueOf(),refFieldPseudoMax:sparkline.timeRange?.to.valueOf()})}const defaultConfig={drawStyle:common_gen.GR.Line,showPoints:common_gen.yL.Auto,axisPlacement:common_gen.vM.Hidden,pointSize:2};class Sparkline extends react.PureComponent{constructor(props){super(props);const alignedDataFrame=preparePlotFrame(props.sparkline,props.config);this.state={data:preparePlotData2(alignedDataFrame,getStackingGroups(alignedDataFrame)),alignedDataFrame:alignedDataFrame,configBuilder:this.prepareConfig(alignedDataFrame)}}static getDerivedStateFromProps(props,state){const frame=function nullToValue(frame){return{...frame,fields:frame.fields.map((field=>{const noValue=Number(field.config.noValue);return Number.isNaN(noValue)?field:nullToValueField(field,noValue)}))}}(preparePlotFrame(props.sparkline,props.config));return frame?{...state,data:preparePlotData2(frame,getStackingGroups(frame)),alignedDataFrame:frame}:{...state}}componentDidUpdate(prevProps,prevState){const{alignedDataFrame:alignedDataFrame}=this.state;if(!alignedDataFrame)return;let rebuildConfig=!1;if(prevProps.sparkline!==this.props.sparkline){const isStructureChanged=!function compareDataFrameStructures(a,b,skipConfig){if(a===b)return!0;if(a?.fields?.length!==b?.fields?.length)return!1;if(a.name!==b.name)return!1;for(let i=0;i<a.fields.length;i++){const fA=a.fields[i],fB=b.fields[i];if(fA.type!==fB.type||fA.name!==fB.name)return!1;if(skipConfig)continue;if(fA.labels&&fB.labels&&!shallowCompare(fA.labels,fB.labels))return!1;const cfgA=fA.config,cfgB=fB.config;if(Object.keys(cfgA).length!==Object.keys(cfgB).length)return!1;let key;for(key in cfgA){if(!(key in cfgB))return!1;if("interval"!==key&&!(0,lodash.isEqual)(cfgA[key],cfgB[key]))return!1}}return!0}(this.state.alignedDataFrame,prevState.alignedDataFrame),isRangeChanged=!(0,lodash.isEqual)(alignedDataFrame.fields[1].state?.range,prevState.alignedDataFrame.fields[1].state?.range);rebuildConfig=isStructureChanged||isRangeChanged}else rebuildConfig=!(0,lodash.isEqual)(prevProps.config,this.props.config);rebuildConfig&&this.setState({configBuilder:this.prepareConfig(alignedDataFrame)})}getYRange(field){let{min:min,max:max}=this.state.alignedDataFrame.fields[1].state?.range;const noValue=+this.state.alignedDataFrame.fields[1].config?.noValue;return Number.isNaN(noValue)||(min=Math.min(min,+noValue),max=Math.max(max,+noValue)),min===max?(0===min?max=100:(min=0,max*=2),[min,max]):[Math.max(min,field.config.min??-1/0),Math.min(max,field.config.max??1/0)]}prepareConfig(data){const{theme:theme}=this.props,builder=new UPlotConfigBuilder;builder.setCursor({show:!1,x:!1,y:!1});const xField=data.fields[0];builder.addScale({scaleKey:"x",orientation:common_gen.Lt.Horizontal,direction:common_gen.ON.Right,isTime:!1,range:()=>{const{sparkline:sparkline}=this.props;if(sparkline.x){if(sparkline.timeRange&&sparkline.x.type===dataFrame.PU.time)return[sparkline.timeRange.from.valueOf(),sparkline.timeRange.to.valueOf()];const vals=sparkline.x.values;return[vals[0],vals[vals.length-1]]}return[0,sparkline.y.values.length-1]}}),builder.addAxis({scaleKey:"x",theme:theme,placement:common_gen.vM.Hidden});for(let i=0;i<data.fields.length;i++){const field=data.fields[i],config=field.config,customConfig={...defaultConfig,...config.custom};if(field===xField||field.type!==dataFrame.PU.number)continue;const scaleKey=config.unit||"__fixed";builder.addScale({scaleKey:scaleKey,orientation:common_gen.Lt.Vertical,direction:common_gen.ON.Up,range:()=>this.getYRange(field)}),builder.addAxis({scaleKey:scaleKey,theme:theme,placement:common_gen.vM.Hidden});const colorMode=(0,fieldColor.Qi)(field),seriesColor=colorMode.getCalculator(field,theme)(0,0),pointsMode=customConfig.drawStyle===common_gen.GR.Points?common_gen.yL.Always:customConfig.showPoints;builder.addSeries({pxAlign:!1,scaleKey:scaleKey,theme:theme,colorMode:colorMode,thresholds:config.thresholds,drawStyle:customConfig.drawStyle,lineColor:customConfig.lineColor??seriesColor,lineWidth:customConfig.lineWidth,lineInterpolation:customConfig.lineInterpolation,showPoints:pointsMode,pointSize:customConfig.pointSize,fillOpacity:customConfig.fillOpacity,fillColor:customConfig.fillColor,lineStyle:customConfig.lineStyle,gradientMode:customConfig.gradientMode,spanNulls:customConfig.spanNulls})}return builder}render(){const{data:data,configBuilder:configBuilder}=this.state,{width:width,height:height}=this.props;return(0,jsx_runtime.jsx)(UPlotChart,{data:data,config:configBuilder,width:width,height:height})}}try{Sparkline.displayName="Sparkline",Sparkline.__docgenInfo={description:"",displayName:"Sparkline",props:{width:{defaultValue:null,description:"",name:"width",required:!0,type:{name:"number"}},height:{defaultValue:null,description:"",name:"height",required:!0,type:{name:"number"}},config:{defaultValue:null,description:"",name:"config",required:!1,type:{name:"FieldConfig<GraphFieldConfig>"}},sparkline:{defaultValue:null,description:"",name:"sparkline",required:!0,type:{name:"FieldSparkline"}},theme:{defaultValue:null,description:"",name:"theme",required:!0,type:{name:"GrafanaTheme2"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Sparkline/Sparkline.tsx#Sparkline"]={docgenInfo:Sparkline.__docgenInfo,name:"Sparkline",path:"src/components/Sparkline/Sparkline.tsx#Sparkline"})}catch(__react_docgen_typescript_loader_error){}},"./src/utils/colors.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{mZ:function(){return getTextColorForAlphaBackground}});var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("../../node_modules/lodash/lodash.js"),tinycolor2__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__("../../node_modules/tinycolor2/esm/tinycolor.js");function hexToHsl(color){return(0,tinycolor2__WEBPACK_IMPORTED_MODULE_1__.A)(color).toHsl()}function hslToHex(color){return(0,tinycolor2__WEBPACK_IMPORTED_MODULE_1__.A)(color).toHexString()}function getTextColorForAlphaBackground(color,themeIsDark){const tcolor=(0,tinycolor2__WEBPACK_IMPORTED_MODULE_1__.A)(color),b=tcolor.getBrightness();return tcolor.getAlpha()<.3?themeIsDark?"rgb(247, 248, 250)":"rgb(32, 34, 38)":b>180?"rgb(32, 34, 38)":"rgb(247, 248, 250)"}(function sortColorsByHue(hexColors){const hslColors=(0,lodash__WEBPACK_IMPORTED_MODULE_0__.map)(hexColors,hexToHsl),sortedHSLColors=(0,lodash__WEBPACK_IMPORTED_MODULE_0__.sortBy)(hslColors,["h"]),chunkedHSLColors=(0,lodash__WEBPACK_IMPORTED_MODULE_0__.chunk)(sortedHSLColors,4),sortedChunkedHSLColors=(0,lodash__WEBPACK_IMPORTED_MODULE_0__.map)(chunkedHSLColors,(chunk=>(0,lodash__WEBPACK_IMPORTED_MODULE_0__.sortBy)(chunk,"l"))),flattenedZippedSortedChunkedHSLColors=(0,lodash__WEBPACK_IMPORTED_MODULE_0__.flattenDeep)((0,lodash__WEBPACK_IMPORTED_MODULE_0__.zip)(...sortedChunkedHSLColors));return(0,lodash__WEBPACK_IMPORTED_MODULE_0__.map)(flattenedZippedSortedChunkedHSLColors,hslToHex)})(["#7EB26D","#EAB839","#6ED0E0","#EF843C","#E24D42","#1F78C1","#BA43A9","#705DA0","#508642","#CCA300","#447EBC","#C15C17","#890F02","#0A437C","#6D1F62","#584477","#B7DBAB","#F4D598","#70DBED","#F9BA8F","#F29191","#82B5D8","#E5A8E2","#AEA2E0","#629E51","#E5AC0E","#64B0C8","#E0752D","#BF1B00","#0A50A1","#962D82","#614D93","#9AC48A","#F2C96D","#65C5DB","#F9934E","#EA6460","#5195CE","#D683CE","#806EB7","#3F6833","#967302","#2F575E","#99440A","#58140C","#052B51","#511749","#3F2B5B","#E0F9D7","#FCEACA","#CFFAFF","#F9E2D2","#FCE2DE","#BADFF4","#F9D9F9","#DEDAF7"])}}]);