import React__default, { useCallback, useMemo } from 'react';

"use strict";
function createPointerDistance(distance = 10) {
  let initial = { x: 0, y: 0 };
  const set = (evt) => {
    initial = getPoint(evt);
  };
  const check = (evt, overrideDistance = distance) => checkDistance(initial, getPoint(evt), overrideDistance);
  return { set, check };
}
function usePointerDistance(distance = 10) {
  const initial = React__default.useRef({ x: 0, y: 0 });
  const set = useCallback((evt) => {
    initial.current = getPoint(evt);
  }, []);
  const check = useCallback(
    (evt, overrideDistance = distance) => checkDistance(initial.current, getPoint(evt), overrideDistance),
    [distance]
  );
  return useMemo(() => ({ set, check }), [set, check]);
}
function getPoint(evt) {
  return { x: evt.clientX, y: evt.clientY };
}
function checkDistance(point1, point2, distance) {
  return Math.hypot(point1.x - point2.x, point1.y - point2.y) > distance;
}

export { createPointerDistance, usePointerDistance };
//# sourceMappingURL=usePointerDistance.mjs.map
