import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Counter } from './Counter.mjs';

"use strict";
const VerticalTab = forwardRef(
  ({ label, active, icon, counter, className, suffix: Suffix, onChangeTab, href, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getTabStyles);
    const content = () => /* @__PURE__ */ jsxs(Fragment, { children: [
      icon && /* @__PURE__ */ jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = cx(tabsStyles.link, active && tabsStyles.activeStyle);
    return /* @__PURE__ */ jsx(
      "a",
      {
        href,
        className: linkClass,
        ...otherProps,
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref,
        children: content()
      }
    );
  }
);
VerticalTab.displayName = "Tab";
const getTabStyles = (theme) => {
  return {
    link: css({
      padding: "6px 12px",
      display: "block",
      height: "100%",
      cursor: "pointer",
      position: "relative",
      color: theme.colors.text.primary,
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:hover, &:focus": {
        textDecoration: "underline"
      }
    }),
    activeStyle: css({
      label: "activeTabStyle",
      color: theme.colors.text.maxContrast,
      overflow: "hidden",
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        width: "4px",
        bottom: "2px",
        top: "2px",
        borderRadius: theme.shape.radius.default,
        backgroundImage: "linear-gradient(0deg, #f05a28 30%, #fbca0a 99%)"
      }
    }),
    suffix: css({
      marginLeft: theme.spacing(1)
    })
  };
};

export { VerticalTab };
//# sourceMappingURL=VerticalTab.mjs.map
