import { jsx, Fragment } from 'react/jsx-runtime';

"use strict";
const TableCell = ({
  cell,
  tableStyles,
  onCellFilterAdded,
  timeRange,
  userProps,
  frame,
  rowStyled,
  rowExpanded,
  textWrapped,
  height,
  getActions,
  replaceVariables,
  setInspectCell
}) => {
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.wordBreak = "break-word";
    cellProps.style.minWidth = cellProps.style.width;
    const justifyContent = cell.column.justifyContent;
    if (justifyContent === "flex-end" && !field.config.unit) {
      cellProps.style.textAlign = "right";
      cellProps.style.direction = "rtl";
      cellProps.style.unicodeBidi = "plaintext";
    } else {
      cellProps.style.justifyContent = justifyContent;
    }
  }
  let innerWidth = (typeof cell.column.width === "number" ? cell.column.width : 24) - tableStyles.cellPadding * 2;
  const actions = getActions ? getActions(frame, field, cell.row.index, replaceVariables) : [];
  return /* @__PURE__ */ jsx(Fragment, { children: cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    timeRange,
    userProps,
    frame,
    rowStyled,
    rowExpanded,
    textWrapped,
    height,
    actions,
    setInspectCell
  }) });
};

export { TableCell };
//# sourceMappingURL=TableCell.mjs.map
