import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '../../../themes/index.mjs';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';

"use strict";
const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ jsx("span", { className: styles.title, children: title });
};
const getStyles = (theme) => {
  return {
    title: css({
      fontWeight: theme.typography.fontWeightRegular,
      textOverflow: "ellipsis"
    })
  };
};

export { TimeZoneTitle };
//# sourceMappingURL=TimeZoneTitle.mjs.map
