import { jsxs, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { memo } from 'react';
import { v4 } from 'uuid';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { getFocusStyles } from '../../../themes/mixins.mjs';

"use strict";
const getStyles = (theme) => {
  return {
    container: css({
      display: "flex",
      alignItems: "center",
      flexDirection: "row-reverse",
      justifyContent: "space-between",
      position: "relative"
    }),
    radio: css({
      opacity: 0,
      width: "0 !important",
      "&:focus-visible + label": getFocusStyles(theme)
    }),
    label: css({
      cursor: "pointer",
      flex: 1,
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      "&:hover": {
        background: theme.colors.action.hover,
        cursor: "pointer"
      }
    }),
    labelSelected: css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        width: theme.spacing(0.5),
        left: 0,
        top: 0
      }
    })
  };
};
const TimeRangeOption = memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles);
  const id = v4();
  return /* @__PURE__ */ jsxs("li", { className: styles.container, children: [
    /* @__PURE__ */ jsx(
      "input",
      {
        className: styles.radio,
        checked: selected,
        name,
        type: "checkbox",
        "data-role": "item",
        tabIndex: -1,
        id,
        onChange: () => onSelect(value)
      }
    ),
    /* @__PURE__ */ jsx("label", { className: cx(styles.label, selected && styles.labelSelected), htmlFor: id, children: value.display })
  ] });
});
TimeRangeOption.displayName = "TimeRangeOption";

export { TimeRangeOption };
//# sourceMappingURL=TimeRangeOption.mjs.map
