import { jsx } from 'react/jsx-runtime';
import { getValueFromDimension } from '@grafana/data';
import '../../../components/VizTooltip/index.mjs';
import { getMultiSeriesGraphHoverInfo } from '../utils.mjs';
import { SeriesTable } from '../../../components/VizTooltip/SeriesTable.mjs';

"use strict";
const MultiModeGraphTooltip = ({ dimensions, activeDimensions, pos, timeZone }) => {
  let activeSeriesIndex = null;
  if (activeDimensions.xAxis === null) {
    return null;
  }
  if (activeDimensions.yAxis) {
    activeSeriesIndex = activeDimensions.yAxis[0];
  }
  const time = activeDimensions.xAxis[1] ? getValueFromDimension(dimensions.xAxis, activeDimensions.xAxis[0], activeDimensions.xAxis[1]) : pos.x;
  const hoverInfo = getMultiSeriesGraphHoverInfo(dimensions.yAxis.columns, dimensions.xAxis.columns, time, timeZone);
  const timestamp = hoverInfo.time;
  const series = hoverInfo.results.map((s, i) => {
    return {
      color: s.color,
      label: s.label,
      value: s.value,
      isActive: activeSeriesIndex === i
    };
  });
  return /* @__PURE__ */ jsx(SeriesTable, { series, timestamp });
};
MultiModeGraphTooltip.displayName = "MultiModeGraphTooltip";

export { MultiModeGraphTooltip };
//# sourceMappingURL=MultiModeGraphTooltip.mjs.map
