import { jsx } from 'react/jsx-runtime';
import '../../../utils/index.mjs';
import { DataLinksContextMenu } from '../../DataLinks/DataLinksContextMenu.mjs';
import '../types.mjs';
import { getCellOptions } from '../utils.mjs';
import { TableCellDisplayMode } from '@grafana/schema';
import { getCellLinks } from '../../../utils/table.mjs';

"use strict";
const DATALINKS_HEIGHT_OFFSET = 10;
const ImageCell = (props) => {
  var _a;
  const { field, cell, tableStyles, row, cellProps } = props;
  const cellOptions = getCellOptions(field);
  const { title, alt } = cellOptions.type === TableCellDisplayMode.Image ? cellOptions : { title: void 0, alt: void 0 };
  const displayValue = field.display(cell.value);
  const hasLinks = Boolean((_a = getCellLinks(field, row)) == null ? void 0 : _a.length);
  const img = /* @__PURE__ */ jsx(
    "img",
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET, width: "auto" },
      src: displayValue.text,
      className: tableStyles.imageCell,
      alt,
      title
    }
  );
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks ? /* @__PURE__ */ jsx(
    DataLinksContextMenu,
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET, width: "auto" },
      links: () => getCellLinks(field, row) || [],
      children: (api) => {
        if (api.openMenu) {
          return /* @__PURE__ */ jsx(
            "div",
            {
              onClick: api.openMenu,
              role: "button",
              tabIndex: 0,
              onKeyDown: (e) => {
                if (e.key === "Enter" && api.openMenu) {
                  api.openMenu(e);
                }
              },
              children: img
            }
          );
        } else {
          return img;
        }
      }
    }
  ) : img });
};

export { ImageCell };
//# sourceMappingURL=ImageCell.mjs.map
