import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import '../../themes/index.mjs';
import { getModalStyles } from './getModalStyles.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h2", { className: styles.modalHeaderTitle, id, children: title }),
    children
  ] });
};

export { ModalHeader };
//# sourceMappingURL=ModalHeader.mjs.map
