import { jsx } from 'react/jsx-runtime';
import { Icon } from '../Icon/Icon.mjs';

"use strict";
const SuffixIcon = ({ isLoading, isOpen }) => {
  const suffixIcon = isLoading ? "spinner" : (
    // If it's loading, show loading icon. Otherwise, icon indicating menu state
    isOpen ? "search" : "angle-down"
  );
  return /* @__PURE__ */ jsx(Icon, { name: suffixIcon });
};

export { SuffixIcon };
//# sourceMappingURL=SuffixIcon.mjs.map
