import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { locale } from '@grafana/data';
import '../../themes/index.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const Counter = ({ value }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("span", { className: styles.counter, children: locale(value, 0).text });
};
const getStyles = (theme) => ({
  counter: css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

export { Counter };
//# sourceMappingURL=Counter.mjs.map
