import { jsx } from 'react/jsx-runtime';
import { DataLinkEditorModalContent } from './DataLinkEditorModalContent.mjs';
import { DataLinksInlineEditorBase } from './DataLinksInlineEditorBase.mjs';

"use strict";
const DataLinksInlineEditor = ({
  links,
  getSuggestions,
  showOneClick = false,
  ...rest
}) => /* @__PURE__ */ jsx(DataLinksInlineEditorBase, { type: "link", items: links, ...rest, children: (item, index, onSave, onCancel) => /* @__PURE__ */ jsx(
  DataLinkEditorModalContent,
  {
    index,
    link: item != null ? item : { title: "", url: "" },
    data: rest.data,
    onSave,
    onCancel,
    getSuggestions,
    showOneClick
  }
) });

export { DataLinksInlineEditor };
//# sourceMappingURL=DataLinksInlineEditor.mjs.map
