---
canonical: https://grafana.com/docs/grafana/latest/alerting/alerting-rules/create-recording-rules/create-grafana-managed-recording-rules/
description: Recording rules allow you to pre-compute expensive queries in advance and save the results as a new set of time series. Grafana-managed recording rules can create a recording rule for any data source supported by alerting.
keywords:
  - grafana
  - alerting
  - guide
  - rules
  - recording rules
  - configure
labels:
  products:
    - cloud
    - enterprise
    - oss
title: Create Grafana-managed recording rules
weight: 401
refs:
  expressions:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/fundamentals/alert-rules/queries-conditions/#expression-queries
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/fundamentals/alert-rules/queries-conditions/#expression-queries
  create-recording-rules:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/alerting-rules/create-recording-rules/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/alerting-rules/create-recording-rules/
  alerting-data-sources:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/fundamentals/alert-rules/#supported-data-sources
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/fundamentals/alert-rules/#supported-data-sources
  configure-grafana-min-interval:
    - pattern: /docs/
      destination: /docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/#min_interval
  configure-feature-toggles:
    - pattern: /docs/
      destination: /docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/feature-toggles/
---

# Create Grafana-managed recording rules

[Recording rules](ref:create-recording-rules) allow you to periodically pre-compute frequently used or computationally expensive queries, saving the results as a new time series metric.

Alert rules and dashboards can then query the new metric resulting from the recording rule. This is faster than querying real-time data and can help to reduce system load.

Grafana does not contain an embedded time-series database to store recording rule results. You must bring your own Prometheus-compatible database to store the series generated by recording rules.

Grafana-managed recording rules offer the same Prometheus-like semantics but allow you to query [data sources supported by alerting](ref:alerting-data-sources). Additionally, you can use recording rules to import and map data from other data sources into Prometheus.

{{< admonition type="note" >}}

Grafana-managed recording rules are enabled by default in Grafana Cloud.

In Grafana OSS and Enterprise, you must enable them by following the [Before you begin](#before-you-begin) instructions.

{{< /admonition >}}

To configure Grafana-managed recording rules, complete the following steps.

## Before you begin

This section only applies to Grafana OSS and Grafana Enterprise.

First, enable the `grafanaManagedRecordingRules` [feature flag](ref:configure-feature-toggles).

Then, enable the feature by setting `enabled = true` in the `[recording_rules]` section of the Grafana config .ini. Provide the URL of your Prometheus-compatible remote-write endpoint in the `url` field, along with optional credentials or headers.

```
[recording_rules]
enabled = true
url = http://my-example-prometheus.local:9090/api/prom/push
basic_auth_username = my-user
basic_auth_password = my-pass

[recording_rules.custom_headers]
X-My-Header = MyValue
```

### Per-rule data source

To choose the remote-write Prometheus data source individually for each recording rule, also enable the `grafanaManagedRecordingRulesDatasources` feature flag.

When this flag is on, Grafana does not use the `url` defined in the configuration file, and the rule editor shows a dropdown to select the target data source. If a rule does not specify a target, for example it was created before the flag was enabled, Grafana writes to the data source identified by `default_datasource_uid` in the Grafana configuration:

```
[recording_rules]

default_datasource_uid = my-uid
```

## Add new recording rule

To create a new Grafana-managed recording rule:

1. Click **Alerts & IRM** -> **Alerting** ->
   **Alert rules**.
1. Scroll to the **Grafana-managed section** and click **+New recording rule**.

1. Enter the names to identify your recording rule and metric.

   The metric name must be a Prometheus metric name and contain no whitespace. For details, refer to [Prometheus metric names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).

## Define recording rule

Define a query to get the data you want to measure and set the recording rule output.

1. Select a data source.
1. From the **Options** dropdown, specify a time range.

   {{< admonition type="note" >}}
   Grafana Alerting only supports fixed relative time ranges, for example, `now-24hr: now`.

   It does not support absolute time ranges: `2021-12-02 00:00:00 to 2021-12-05 23:59:592` or semi-relative time ranges: `now/d to: now`.
   {{< /admonition >}}

1. Add a query.

   To add multiple queries, click **Add query**.

1. Add one or more [expressions](ref:expressions).

   a. For each expression, select either **Classic condition** to create a single recording rule, or choose from the **Math**, **Reduce**, and **Resample** options.

   When using Prometheus, you can use an instant vector and built-in functions, so you don't need to add additional expressions.

   b. Click **Preview** to verify that the expression is successful.

1. Click **Set as recording rule output** on the query or expression you want to set as your rule output.

## Set evaluation behavior

Use recording rule evaluation to determine how frequently a recording rule should be evaluated.

To do this, you need to make sure that your recording rule is in the right evaluation group with an interval that works best for your use case.

1. Select a folder or click **+ New folder**.
1. Select an evaluation group or click **+ New evaluation group**.

   If you are creating a new evaluation group, specify the interval for the group.

   All rules within the same group are evaluated concurrently over the same time interval. Every recording rule in a group uses the same evaluation time, meaning that all queries from the same group are always aligned with each other.

1. Before or after creating a recording rule, you have the option to **Pause evaluation** if necessary.

### Advanced configuration

[min_interval](ref:configure-grafana-min-interval) sets the minimum interval to enforce between rule evaluations. The default value is 10s which equals the scheduler interval. Rules are adjusted if they are less than this value or if they are not multiple of the scheduler interval (10s). Higher values can help with resource management as fewer evaluations are scheduled over time.

This setting has precedence over each individual rule frequency. If a rule frequency is lower than this value, then this value is enforced.

This setting applies to both Grafana-managed alert and recording rules.

## Add labels

Optionally, you can add custom labels to the resulting metric by selecting existing key-value pairs from the drop down or entering the new key or value.

## Query the new metric in dashboards or alert rules

Click **Save rule** or **Save rule and exit** to save the rule.

Once saved, the new recording metric is available for use in dashboards and alert rules.
