import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '../../themes/index.mjs';
import { Portal } from '../Portal/Portal.mjs';
import { VizTooltipContainer } from './VizTooltipContainer.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const VizTooltip = ({ content, position, offset }) => {
  const styles = useStyles2(getStyles);
  if (position) {
    return /* @__PURE__ */ jsx(Portal, { className: styles.portal, children: /* @__PURE__ */ jsx(VizTooltipContainer, { position, offset: offset || { x: 0, y: 0 }, children: content }) });
  }
  return null;
};
VizTooltip.displayName = "VizTooltip";
const getStyles = () => {
  return {
    portal: css({
      position: "absolute",
      top: 0,
      left: 0,
      pointerEvents: "none",
      width: "100%",
      height: "100%"
    })
  };
};

export { VizTooltip };
//# sourceMappingURL=VizTooltip.mjs.map
