import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '../../themes/index.mjs';
import { t } from '../../utils/i18n.mjs';
import { UserIcon } from './UserIcon.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const UsersIndicator = ({ users, onClick, limit = 4 }) => {
  const styles = useStyles2(getStyles);
  if (!users.length) {
    return null;
  }
  limit = limit > 0 ? limit : 4;
  const limitReached = users.length > limit;
  const extraUsers = users.length - limit;
  const tooManyUsers = extraUsers > 99;
  return /* @__PURE__ */ jsxs(
    "div",
    {
      className: styles.container,
      "aria-label": t("grafana-ui.users-indicator.container-label", "Users indicator container"),
      children: [
        limitReached && /* @__PURE__ */ jsx(UserIcon, { onClick, userView: { user: { name: "Extra users" }, lastActiveAt: "" }, showTooltip: false, children: tooManyUsers ? "..." : `+${extraUsers}` }),
        users.slice(0, limitReached ? limit : limit + 1).reverse().map((userView) => /* @__PURE__ */ jsx(UserIcon, { userView }, userView.user.name))
      ]
    }
  );
};
const getStyles = (theme) => {
  return {
    container: css({
      display: "flex",
      justifyContent: "center",
      flexDirection: "row-reverse",
      marginLeft: theme.spacing(1),
      "& > button": {
        marginLeft: theme.spacing(-1)
        // Overlay the elements a bit on top of each other
      }
    }),
    dots: css({
      marginBottom: "3px"
    })
  };
};

export { UsersIndicator };
//# sourceMappingURL=UsersIndicator.mjs.map
