import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '../../../../themes/index.mjs';
import { Icon } from '../../../Icon/Icon.mjs';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';

"use strict";
function RowExpander({ height, onCellExpand, isExpanded }) {
  const styles = useStyles2(getStyles, height);
  function handleKeyDown(e) {
    if (e.key === " " || e.key === "Enter") {
      e.preventDefault();
      onCellExpand();
    }
  }
  return /* @__PURE__ */ jsx("div", { className: styles.expanderCell, onClick: onCellExpand, onKeyDown: handleKeyDown, children: /* @__PURE__ */ jsx(
    Icon,
    {
      "aria-label": isExpanded ? "Collapse row" : "Expand row",
      name: isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}
const getStyles = (theme, rowHeight) => ({
  expanderCell: css({
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    height: `${rowHeight}px`,
    cursor: "pointer"
  })
});

export { RowExpander };
//# sourceMappingURL=RowExpander.mjs.map
