import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { isString } from 'lodash';
import '../../../themes/index.mjs';
import '../../../utils/index.mjs';
import '../../Button/index.mjs';
import { DataLinksContextMenu } from '../../DataLinks/DataLinksContextMenu.mjs';
import { CellActions } from '../CellActions.mjs';
import { TableCellInspectorMode } from '../TableCellInspector.mjs';
import { getCellLinks } from '../../../utils/table.mjs';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { clearLinkButtonStyles, Button } from '../../Button/Button.mjs';

"use strict";
function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsxs("div", { ...cellProps, className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer, children: [
    /* @__PURE__ */ jsx("div", { className: cx(tableStyles.cellText, txt), children: hasLinks ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsx(Button, { className: cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
      } else {
        return /* @__PURE__ */ jsx(Fragment, { children: displayValue });
      }
    } }) : /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, children: displayValue }) }),
    inspectEnabled && /* @__PURE__ */ jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.code })
  ] });
}

export { JSONViewCell };
//# sourceMappingURL=JSONViewCell.mjs.map
