import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { forwardRef } from 'react';
import '../../themes/index.mjs';
import { Box } from '../Layout/Box/Box.mjs';
import { ScrollIndicators } from './ScrollIndicators.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const ScrollContainer = forwardRef(
  ({
    children,
    showScrollIndicators = false,
    onScroll,
    overflowX = "auto",
    overflowY = "auto",
    scrollbarWidth = "thin",
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles, scrollbarWidth, overflowY, overflowX);
    const defaults = {
      maxHeight: "100%",
      minHeight: 0,
      minWidth: 0
    };
    const boxProps = { ...defaults, ...rest };
    return /* @__PURE__ */ jsx(Box, { ...boxProps, display: "flex", direction: "column", flex: 1, position: "relative", children: /* @__PURE__ */ jsx("div", { onScroll, className: styles.scroller, ref, children: showScrollIndicators ? /* @__PURE__ */ jsx(ScrollIndicators, { children }) : children }) });
  }
);
ScrollContainer.displayName = "ScrollContainer";
const getStyles = (theme, scrollbarWidth, overflowY, overflowX) => ({
  scroller: css({
    display: "flex",
    flex: 1,
    flexDirection: "column",
    overflowX,
    overflowY,
    scrollbarWidth
  })
});

export { ScrollContainer };
//# sourceMappingURL=ScrollContainer.mjs.map
